function [dataset,probDistribution] = createartificialdataset(randomSeed,supportOfOutcomeY,nObservations)

%This function creates an artificial dataset and corresponding probability
%distribution from a given random seed.
%INPUT:     randomSeed is an integer
%           supportOfOutcome is a row vector
%OUTPUT:    dataset is nObservations times 3 matrix where lines corresponds
%to observations of (Outcome, Treatment, Instrument)
%           probDistribution

%Initialize random number stream.
randomNumberStream = RandStream('mcg16807','Seed',randomSeed);
RandStream.setGlobalStream(randomNumberStream);

%Support of the variables.
supportOfTreatmentD  = [1 0];             %Treatment.
supportOfInstrumentZ = [1 0];             %Instrument.

%Size of the support of variables.
sizeOfSupportOfY = size(supportOfOutcomeY,2);  %Outcome.
sizeOfSupportOfD = 2;                          %Treatment.
sizeOfSupportOfZ = 2;                          %Instrument.
sizeOfSupportOfYDZ = sizeOfSupportOfY*sizeOfSupportOfD*sizeOfSupportOfZ;

%Create a "random" probability distribution probabilityOfYDZ.
%First, generate sizeY*sizeD*sizeZ Unif(0,1) random numbers.
randNumbers = rand(sizeOfSupportOfY,sizeOfSupportOfD,sizeOfSupportOfZ);
%Then, normalize it so it adds up to one.
probabilityOfYDZ = randNumbers/sum(reshape(randNumbers,1,sizeOfSupportOfYDZ));   

%We create a dataset of size approx nObservations that could have generated
%probabilityOfYDZ.
nObservationsRounded = sum(sum(sum(round(probabilityOfYDZ*nObservations))));
probabilityOfYDZRounded = round(probabilityOfYDZ*nObservations)/nObservationsRounded;
%probabilityOfYDZRounded is induced by a dataset of size
%nObservationsRounded.
countOfYDZinPYDZ = round(probabilityOfYDZRounded*nObservationsRounded);
countOfYDZinPYDZ = int32(countOfYDZinPYDZ); %Convert to integers.

dataset = zeros(nObservationsRounded,3);    %Initiate dataset variable.
iPivotDataset = 1;                          %Initiate iPivotDataset to the first row.
for k = 1:sizeOfSupportOfY
    for l = 1:sizeOfSupportOfD
        for m = 1:sizeOfSupportOfZ
            if countOfYDZinPYDZ(k,l,m) > 0
                rowsToAddToDataset = iPivotDataset:(iPivotDataset + countOfYDZinPYDZ(k,l,m)-1);  %We will add countOfYDZinPYDZ(k,l,m) rows.
                dataset(rowsToAddToDataset,1:3) = ones(countOfYDZinPYDZ(k,l,m),1)*[supportOfOutcomeY(k),supportOfTreatmentD(l),supportOfInstrumentZ(m)];
                iPivotDataset = iPivotDataset + countOfYDZinPYDZ(k,l,m);                %Change the pivotal row.
            end
        end
    end
end

probDistribution = probabilityOfYDZRounded;