function [Bounds] = calculateanalyticboundsonate(dataset,sizeGrid,supportOfOutcomeY,lowerBoundForDefiers,upperBoundForDefiers)

%This function calculates analytical bounds on ATE that are derived in the
%paper.
%INPUT:  dataset - dataset with three columns (outcome,treatment,instrument)
%        sizeGrid - size of the grid for the proportion of defiers
%        supportOfOutcomeY - row vector
%        loweBoundForDefiers - lower bound on the share of defiers pi01
%        upperBoundForDefiers - upper bound on the share of defiers pi01
%OUTPUT: Bounds - structure with bounds on ATE for various subpopulations
%
%NESTED FUNCTIONS: are defined at the end of this m-file.

y = dataset(:,1);   %Outcome.
t = dataset(:,2);   %Treatment.
z = dataset(:,3);   %Instrument

%Ptz = Probability of Treatment=t given Intrument=z
P11=sum(z==1&t==1)/sum(z==1);
P10=sum(z==0&t==1)/sum(z==0);
P01=1-P11;
P00=1-P10;

%Create a grid of values for the share of defiers pi01
pi01=(lowerBoundForDefiers:(upperBoundForDefiers-lowerBoundForDefiers)/sizeGrid:upperBoundForDefiers)'; 

y11=sort(y(z==1&t==1));
y01=sort(y(z==0&t==1));
y10=sort(y(z==1&t==0));
y00=sort(y(z==0&t==0));

%x11=unique(y11);
%x01=unique(y01);
%x10=unique(y10);
%x00=unique(y00);
x11 = supportOfOutcomeY;
x01 = supportOfOutcomeY;
x10 = supportOfOutcomeY;
x00 = supportOfOutcomeY;

n01=length(x01);
n11=length(x11);
n00=length(x00);
n10=length(x10);

f11=x11;
for i=1:n11
    if sum(y11==x11(i))>0
        f11(i)=mean(y11==x11(i));
    else
        f11(i) = 0;
    end
end

f01=x01;
for i=1:n01
    %f01(i)=mean(y01==x01(i));
    if sum(y01==x01(i))>0
        f01(i)=mean(y01==x01(i));
    else
        f01(i) = 0;
    end
end

f10=x10;
for i=1:n10
    %f10(i)=mean(y10==x10(i));
    if sum(y10==x10(i))>0
        f10(i)=mean(y10==x10(i));
    else
        f10(i) = 0;
    end
end

f00=x00;
for i=1:n00
    %f00(i)=mean(y00==x00(i));
    if sum(y00==x00(i))>0
        f00(i)=mean(y00==x00(i));
    else
        f00(i) = 0;
    end
end

Ylb=min(supportOfOutcomeY);
Yub=max(supportOfOutcomeY);
        
n01=length(y01);
n11=length(y11);
n00=length(y00);
n10=length(y10);

q11=zeros(1,sizeGrid+1);
q01=zeros(1,sizeGrid+1);
q10=zeros(1,sizeGrid+1);
q00=zeros(1,sizeGrid+1);
m01=zeros(1,sizeGrid+1);
m11=zeros(1,sizeGrid+1);
m00=zeros(1,sizeGrid+1);
m10=zeros(1,sizeGrid+1);
y01max=zeros(1,sizeGrid+1);
y11max=zeros(1,sizeGrid+1);
y01min=zeros(1,sizeGrid+1);
y11min=zeros(1,sizeGrid+1);
y00max=zeros(1,sizeGrid+1);
y10max=zeros(1,sizeGrid+1);
y00min=zeros(1,sizeGrid+1);
y10min=zeros(1,sizeGrid+1);
D10max=zeros(4,sizeGrid+1);
D10min=zeros(4,sizeGrid+1);
D11max=zeros(2,sizeGrid+1);
D11min=zeros(2,sizeGrid+1);
D00max=zeros(2,sizeGrid+1);
D00min=zeros(2,sizeGrid+1);
Dt1max=zeros(2,sizeGrid+1);
Dt1min=zeros(2,sizeGrid+1);
Dt0max=zeros(2,sizeGrid+1);
Dt0min=zeros(2,sizeGrid+1);
Dmax=zeros(4,sizeGrid+1);
Dmin=zeros(4,sizeGrid+1);


for iPi01=1:size(pi01,1)    %Analytic bounds involve calculating maxima and minima across different values of pi01.

    q11(iPi01)=((P10-pi01(iPi01))/P11);
    q11(iPi01)=q11(iPi01)*(q11(iPi01)<=1 & q11(iPi01)>0)+(q11(iPi01)>1);
    q01(iPi01)=(P10-pi01(iPi01))/P10;
    q01(iPi01)=q01(iPi01)*(q01(iPi01)<=1& q01(iPi01)>0)+(q01(iPi01)>1);
    q10(iPi01)=(P01-pi01(iPi01))/P01;
    q10(iPi01)=q10(iPi01)*(q10(iPi01)<=1& q10(iPi01)>0)+(q10(iPi01)>1);
    q00(iPi01)=(P01-pi01(iPi01))/P00;
    q00(iPi01)=q00(iPi01)*(q00(iPi01)<=1& q00(iPi01)>0)+(q00(iPi01)>1);

    m01(iPi01)=round(q01(iPi01)*n01);
    m11(iPi01)=round(q11(iPi01)*n11);
    m00(iPi01)=round(q00(iPi01)*n00);
    m10(iPi01)=round(q10(iPi01)*n10);
    
    %We use left trimmed means. Function lefttrimmedmean is defined at the
    %end of this m-file.
    y11max(iPi01)=sum(x11.*(lefttrimmedmean(f11,x11,q11(iPi01))));
    y01max(iPi01)=sum(x01.*(lefttrimmedmean(f01,x01,q01(iPi01))));
    y10max(iPi01)=sum(x10.*(lefttrimmedmean(f10,x10,q10(iPi01))));
    y00max(iPi01)=sum(x00.*(lefttrimmedmean(f00,x00,q00(iPi01))));
    
    %We use right trimmed means. Function righttrimmedmean is defined at the
    %end of this m-file.
    y11min(iPi01)=sum(x11.*(righttrimmedmean(f11,x11,q11(iPi01))));
    y01min(iPi01)=sum(x01.*(righttrimmedmean(f01,x01,q01(iPi01))));
    y10min(iPi01)=sum(x10.*(righttrimmedmean(f10,x10,q10(iPi01))));
    y00min(iPi01)=sum(x00.*(righttrimmedmean(f00,x00,q00(iPi01))));

    %% Worst case

    if (P11-P10+pi01(iPi01)) > 10e-6
    D10max(:,iPi01)=[(P11*mean(y11)-(P10-pi01(iPi01))*y11min(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y00max(iPi01))/(P11-P10+pi01(iPi01))
        (P11*mean(y11)-(P10-pi01(iPi01))*y01min(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y10max(iPi01))/(P11-P10+pi01(iPi01))
        (P11*mean(y11)-(P10-pi01(iPi01))*y11min(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y10max(iPi01))/(P11-P10+pi01(iPi01))
        (P11*mean(y11)-(P10-pi01(iPi01))*y01min(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y00max(iPi01))/(P11-P10+pi01(iPi01))
        ];
    else
        D10max(:,iPi01) = [ max(supportOfOutcomeY)-min(supportOfOutcomeY)
                        max(supportOfOutcomeY)-min(supportOfOutcomeY)
                        max(supportOfOutcomeY)-min(supportOfOutcomeY)
                        max(supportOfOutcomeY)-min(supportOfOutcomeY)];
    end

    if (P11-P10+pi01(iPi01)) > 10e-6
    D10min(:,iPi01)=[(P11*mean(y11)-(P10-pi01(iPi01))*y11max(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y00min(iPi01))/(P11-P10+pi01(iPi01))
        (P11*mean(y11)-(P10-pi01(iPi01))*y01max(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y10min(iPi01))/(P11-P10+pi01(iPi01))
        (P11*mean(y11)-(P10-pi01(iPi01))*y11max(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y10min(iPi01))/(P11-P10+pi01(iPi01))
        (P11*mean(y11)-(P10-pi01(iPi01))*y01max(iPi01))/(P11-P10+pi01(iPi01))-(P00*mean(y00)-(P01-pi01(iPi01))*y00min(iPi01))/(P11-P10+pi01(iPi01))];
    else
        D10min(:,iPi01) = [min(supportOfOutcomeY)-max(supportOfOutcomeY)
                       min(supportOfOutcomeY)-max(supportOfOutcomeY)
                       min(supportOfOutcomeY)-max(supportOfOutcomeY)
                       min(supportOfOutcomeY)-max(supportOfOutcomeY)];
    end

    D11max(:,iPi01)=[y11max(iPi01)-Ylb
        y01max(iPi01)-Ylb];
    D11min(:,iPi01)=[y11min(iPi01)-Yub
        y01min(iPi01)-Yub];
    D00max(:,iPi01)=[Yub-y00min(iPi01)
        Yub-y10min(iPi01)];
    D00min(:,iPi01)=[Ylb-y00max(iPi01)
        Ylb-y10max(iPi01)];
    Dt1max(:,iPi01)=[mean(y(t==1))-((1/mean(t))*((P10-pi01(iPi01))*min(supportOfOutcomeY)+mean(z)*P00*mean(y00)+mean(z==0)*P01*mean(y10)-(P01-pi01(iPi01))*y10max(iPi01)))
        mean(y(t==1))-((1/mean(t))*((P10-pi01(iPi01))*min(supportOfOutcomeY)+mean(z)*P00*mean(y00)+mean(z==0)*P01*mean(y10)-(P01-pi01(iPi01))*y00max(iPi01)))];
    Dt1min(:,iPi01)=[mean(y(t==1))-((1/mean(t))*((P10-pi01(iPi01))*max(supportOfOutcomeY)+mean(z)*P00*mean(y00)+mean(z==0)*P01*mean(y10)-(P01-pi01(iPi01))*y10min(iPi01)))
        mean(y(t==1))-((1/mean(t))*((P10-pi01(iPi01))*max(supportOfOutcomeY)+mean(z)*P00*mean(y00)+mean(z==0)*P01*mean(y10)-(P01-pi01(iPi01))*y00min(iPi01)))];

    Dt0max(:,iPi01)=[((1/mean(t==0))*((P01-pi01(iPi01))*max(supportOfOutcomeY)+mean(z)*P10*mean(y01)+mean(z==0)*P11*mean(y11)-(P10-pi01(iPi01))*y11min(iPi01)))-mean(y(t==0))
        ((1/mean(t==0))*((P01-pi01(iPi01))*max(supportOfOutcomeY)+mean(z)*P10*mean(y01)+mean(z==0)*P11*mean(y11)-(P10-pi01(iPi01))*y01min(iPi01)))-mean(y(t==0))];
    Dt0min(:,iPi01)=[((1/mean(t==0))*((P01-pi01(iPi01))*min(supportOfOutcomeY)+mean(z)*P10*mean(y01)+mean(z==0)*P11*mean(y11)-(P10-pi01(iPi01))*y11max(iPi01)))-mean(y(t==0))
        ((1/mean(t==0))*((P01-pi01(iPi01))*min(supportOfOutcomeY)+mean(z)*P10*mean(y01)+mean(z==0)*P11*mean(y11)-(P10-pi01(iPi01))*y01max(iPi01)))-mean(y(t==0))];

    Dmax(:,iPi01)=[mean(t)*Dt1max(1,iPi01)+mean(t==0)*Dt0max(1,iPi01)
        mean(t)*Dt1max(1,iPi01)+mean(t==0)*Dt0max(2,iPi01)
        mean(t)*Dt1max(2,iPi01)+mean(t==0)*Dt0max(2,iPi01)
        mean(t)*Dt1max(2,iPi01)+mean(t==0)*Dt0max(1,iPi01)];
    Dmin(:,iPi01)=[mean(t)*Dt1min(1,iPi01)+mean(t==0)*Dt0min(1,iPi01)
        mean(t)*Dt1min(1,iPi01)+mean(t==0)*Dt0min(2,iPi01)
        mean(t)*Dt1min(2,iPi01)+mean(t==0)*Dt0min(2,iPi01)
        mean(t)*Dt1min(2,iPi01)+mean(t==0)*Dt0min(1,iPi01)];

end

D10lb=min(max(D10min)); 
D10ub=max(min(D10max));
D11lb=min( max(D11min));
D11ub=max(min(D11max));
D00lb=min(max(D00min));
D00ub=max(min(D00max));
Dt1lb=min(max(Dt1min));
Dt1ub=max(min(Dt1max));
Dlb=min(max(Dmin));
Dub=max(min(Dmax));

%Save the bounds and optimal solutions to structure Bounds
Bounds = struct;
Bounds.EntirePopulation.lowerBound = Dlb;
Bounds.EntirePopulation.upperBound = Dub;

Bounds.Alwaystakers.lowerBound = D11lb+((min(supportOfOutcomeY)-max(supportOfOutcomeY))-D11lb)*(D11lb==(min(y(t==1))-max(supportOfOutcomeY)));
Bounds.Alwaystakers.upperBound = D11ub+(max(supportOfOutcomeY)-min(supportOfOutcomeY)-D11ub)*(max(y(t==1))-min(supportOfOutcomeY)==D11ub);
%Bounds.Alwaystakers.lowerBound = D11lb;%+((min(supportOfOutcomeY)-max(supportOfOutcomeY))-D11lb)*(D11lb==(min(supportOfOutcomeY)-max(supportOfOutcomeY)));
%Bounds.Alwaystakers.upperBound = D11ub;%+(max(supportOfOutcomeY)-min(supportOfOutcomeY)-D11ub)*(max(supportOfOutcomeY)-min(supportOfOutcomeY)==D11ub);

Bounds.Compliers.lowerBound = D10lb;
Bounds.Compliers.upperBound = D10ub;

Bounds.Nevertakers.lowerBound = D00lb+(min(supportOfOutcomeY)-max(supportOfOutcomeY)-D00lb)*(min(supportOfOutcomeY)-max(y(t==0))==D00lb);
Bounds.Nevertakers.upperBound = D00ub+(max(supportOfOutcomeY)-min(supportOfOutcomeY)-D00ub)*(max(supportOfOutcomeY)-min(y(t==0))==D00ub);
%Bounds.Nevertakers.lowerBound = D00lb;%+(min(supportOfOutcomeY)-max(supportOfOutcomeY)-D00lb)*(min(supportOfOutcomeY)-max(supportOfOutcomeY)==D00lb);
%Bounds.Nevertakers.upperBound = D00ub;%+(max(supportOfOutcomeY)-min(supportOfOutcomeY)-D00ub)*(max(supportOfOutcomeY)-min(supportOfOutcomeY)==D00ub);

Bounds.TreatedPopulation.lowerBound = Dt1lb;
Bounds.TreatedPopulation.upperBound = Dt1ub;


%_____________________________________________________________________
%Nested functions
function [fr]=righttrimmedmean(ff,yy,qq) %right trimmed mean
    cf=incusum(ff);
    iq=cf>=(1-qq);
    if qq<10e-6
        fr=zeros(size(ff));
        fr(1)=1;
    else
        qly=max(yy(iq));
        fr=ff.*(yy<qly)+(min(cf(iq))-(1-qq))*(yy==qly);
        fr=fr/qq;
    end
end

function [fl]=lefttrimmedmean(ff,yy,qq) %left trimmed mean
    cf=cumsum(ff);
    iq=cf>=(1-qq);
    if qq<10e-6
        fl=zeros(size(ff));
        fl(end)=1;
    else
        qly=min(yy(iq));
        fl=ff.*(yy>qly)+(min(cf(iq))-(1-qq))*(yy==qly);
        fl=fl/qq;  
    end
end

function ic=incusum(x)              %reversed cumulative sum
    nn=max(size(x));
    ic=zeros(size(x));
    for ii=0:nn-1
        ic(nn-ii)=sum(x(nn-ii:nn));
    end
end


end %end of the main function
