###########################
Definition of the functions
###########################

w_testindscore<-function(dep1,reg1,wei,smoothing1,dep2,reg2,order,coefks,m=length(dep1),grid=seq(0.1,0.9,0.01),nreps=1000,method="br",trim=0.045){
	grid=grid[abs(grid-0.5)>trim]
	grid=c(grid,0.25,0.75,0.5)
	nq=length(grid)
	wei=wei/mean(wei)
	temp=w_after1(dep1,reg1,wei,coefks,smoothing1)
	P=temp[[3]]
	Pder=temp[[2]]
	n=length(dep1)
	k1=ncol(reg1)
	reg2=as.matrix(reg2)
	k2=ncol(reg2)
	deltap=solve(temp[[1]])/n
	scoreks=Pder*c((dep1-P)/(P*(1-P)))
	index=reg1%*%coefks
	prob1<-glm(dep1~index,family=binomial(probit),weights=wei)$coef
	g<-prob1[1]+prob1[2]*index
	mill<-cbind(1,dnorm(g)/pnorm(g))
	if(order>1) for(i in 2:order) mill<-cbind(mill,mill[,2]^i)
	res<-matrix(,k2+order+1,0)
	for(q in 1:nq) res<-cbind(res,rq.wfit(cbind(reg2[dep1==1,],mill[dep1==1,]),dep2[dep1==1],tau=grid[q],weights=wei[dep1==1],method=method)$coef)
	r<-dep1*cbind(reg2,mill)
	dmill<-rep(0,n)
	for(i in 1:order) dmill<-cbind(dmill,i*(dnorm(g)/pnorm(g))^(i-1)*prob1[2]*((1/(2*pi)^0.5)*exp(-g^2/2)*(-g)*pnorm(g)-dnorm(g)^2)/pnorm(g)^2)
	deltafrx<-rep(list(matrix(,k2+order+1,k1)),nq)
	z<-rep(list(matrix(,n,k2+order+1)),nq)
	deltafr<-rep(list(matrix(,k2+order+1,k2+order+1)),nq)
	scoreqr<-rep(list(matrix(,n,k2+order+1)),nq)
	for(q in 1:nq){
		resid<-dep2-cbind(reg2,mill)%*%res[,q]
		h<-bandwidth.rq(grid[q],sum(dep1))
		if(grid[q]-h<0.001) h<-grid[q]-0.001
		if(grid[q]+h>0.999) h<-0.999-grid[q]
		h<-(qnorm(grid[q]+h)-qnorm(grid[q]-h))*min(sd(resid[dep1==1]),(quantile(resid[dep1==1],0.75)-quantile(resid[dep1==1],0.25))/1.34)
		den<-dnorm(resid/h)/h
		deltafr[[q]]<-crossprod(c(sqrt(den))*sqrt(wei)*r)/n
		deltafrx[[q]]<-t(c(den)*c(wei)*c(dmill%*%res[(k2+1):(k2+order+1),q])*r)%*%reg1[,-1]/n
		scoreqr[[q]]=c((grid[q]-(resid<0)))*r
		z[[q]]=(scoreqr[[q]]-scoreks%*%solve(deltap)%*%t(deltafrx[[q]]))%*%solve(deltafr[[q]])
	}
	for(q in 1:nq){
		z[[q]]=z[[q]]%*%rbind(diag(k2),matrix(0,order+1,k2))
	}
	finite_nq_var=cov.wt(cbind(z[[nq-2]],z[[nq-1]],z[[nq]]),wei)$cov/n
	R=rbind(cbind(diag(k2),matrix(0,k2,k2),-diag(k2)),cbind(matrix(0,k2,k2),diag(k2),-diag(k2)))
	finite_test=t(R%*%c(res[1:k2,(nq-2):nq]))%*%solve(R%*%finite_nq_var%*%t(R))%*%(R%*%c(res[1:k2,(nq-2):nq]))
	finite_p=1-pchisq(finite_test,2*k2)
	grid=grid[1:(nq-3)]
	zmed=z[[nq]]
	res_med=res[1:k2,nq]
	for(q in 1:(nq-3)){
		z[[q]]=z[[q]]-zmed
	}
	weit=c()
	weit_coef_by_coef=c()
	for(q in 1:(nq-3)){
		temp=cov.wt(z[[q]],wei)$cov/n
		weit[[q]]=solve(temp)
		weit_coef_by_coef[[q]]=1/sqrt(diag(temp))
	} 
	temp<-rep(list(matrix(,length(grid),nreps,)),length(m))
	coef_by_coef=array(,c(length(grid),nreps,length(m),k2))
	for(q in 1:length(grid)){
		for(j in 1:nreps){
			set.seed(j)
			sboot<-sample(1:n,max(m),TRUE)
			for(i in 1:length(m)){
				temp[[i]][q,j]=sqrt(wmeanc(as.matrix(z[[q]][sboot[1:m[i]],]),wei[sboot[1:m[i]]])%*%weit[[q]]%*%wmeanc(as.matrix(z[[q]][sboot[1:m[i]],]),wei[sboot[1:m[i]]]))
				for(k in 1:k2){
					coef_by_coef[q,j,i,k]=abs(wmeanc(z[[q]][sboot[1:m[i]],k,drop=FALSE],wei[sboot[1:m[i]]]))*weit_coef_by_coef[[q]][k]
				}
			}
		}
	}
	testks=matrix(,nreps,length(m))
	testcvm=matrix(,nreps,length(m))
	testks_coef_by_coef=array(,c(nreps,length(m),k2))
	testcvm_coef_by_coef=array(,c(nreps,length(m),k2))
	for(j in 1:nreps){
		for(i in 1:length(m)){
			testks[j,i]=sqrt(m[i])*max(temp[[i]][,j])
			testcvm[j,i]=m[i]*mean(temp[[i]][,j]^2)
			for(k in 1:k2){
				testks_coef_by_coef[j,i,k]=sqrt(m[i])*max(coef_by_coef[,j,i,k])
				testcvm_coef_by_coef[j,i,k]=m[i]*mean(coef_by_coef[,j,i,k]^2)
			}
		}
	}
	sample=matrix(res[1:k2,1:length(grid)],k2,length(grid))
	temp1=matrix(,length(grid),k2+1)
	for(q in 1:length(grid)){
		temp1[q,k2+1]=sqrt(c(sample[,q]-res_med)%*%weit[[q]]%*%c(sample[,q]-res_med))
		for(k in 1:k2){
			temp1[q,k]=abs(sample[k,q]-res_med[k])*weit_coef_by_coef[[q]][k]
		}
	}
	tvalueks=sqrt(length(dep1))*max(temp1[,k2+1])
	tvaluecvm=length(dep1)*mean(temp1[,k2+1]^2)
	cvm=pmean(tvaluecvm<testcvm)
	ks=pmean(tvalueks<testks)
	cvm_coef_by_coef=matrix(,k2,length(m))
	ks_coef_by_coef=matrix(,k2,length(m))
	for(k in 1:k2){
		tvalueks=sqrt(length(dep1))*max(temp1[,k])
		tvaluecvm=length(dep1)*mean(temp1[,k]^2)
		cvm_coef_by_coef[k,]=apply(tvaluecvm<testcvm_coef_by_coef[,,k,drop=FALSE],2,mean)
		ks_coef_by_coef[k,]=apply(tvalueks<testks_coef_by_coef[,,k,drop=FALSE],2,mean)
	}
	list(ks=ks,cvm=cvm,ks_coef_by_coef=ks_coef_by_coef,cvm_coef_by_coef=cvm_coef_by_coef,finite_p=finite_p,coef=res[1:k2,])
}

ob_inter<-function(b,y,x,w,h,np=500){
	b=c(1,b)
	k<-dim(x)[2]
	n<-dim(x)[1]
	xb<-crossprod(t(x),b)
	xb<-xb-weighted.mean(xb,w)
	e<-0.5/n
	hh<-c(sqrt(cov.wt(xb,w)$cov))
	hh<-h*hh
	if(np==0){
		xb_ev=xb
	} else{
		xb_ev=wq(xb,w,seq(0,1,1/np))
	}
	nev=length(xb_ev)
	g_ev<-rep(NA,nev)
	for(i in 1:nev){
		h=hh
		kw=dnorm(xb_ev[i]-xb,sd=h)
		kw[kw<0.001*mean(kw)]=0
		yi=y[kw>0]
		kw<-kw[kw>0]/sum(kw[kw>0])
		g_ev[i]<-crossprod(yi,kw)
	}
	g=approx(c(xb_ev),c(g_ev),xout=c(xb),rule=2)$y
	-weighted.mean(y*log(pmin(1-e,pmax(g,e)))+(1-y)*log(pmin(1-e,pmax(e,1-g))),w)
}

wq<-function(y,w,prob){
	o<-order(y)
	y<-y[o]; w<-w[o]
	a<-0; i<-1; w=w/sum(w)
	res<-c()
	n=length(w)
	for(q in prob){
		while(a<q & i<n){
			a<-a+w[i]
			i<-i+1
		}
		res<-c(res,y[i])
	}
	return(res)
}

w_after1=function(y,x,w,b,h){
	n=length(y)
	k=dim(x)[2]
	w<-w/mean(w)
	e<-0.5/n
	cov<-as.matrix(cov.wt(x,w)$cov[,2:k])
	temp<-w_newtk1(y,x,w,b,h,cov)
	g<-temp[[2]]
	dg=temp[[3]]
	Qn<-wsum(y*log(g[,1]+e)+(1-y)*log(1+e-g[,1]),w)
	gcv<-Qn/weighted.mean(1-g[,2],w)^2
	g[,1]=pmax(pmin(g[,1],1-e),e)
	vk<-solve(t(dg/c(g[,1]*(1-g[,1])))%*%(w*dg))
	list(vk,dg,g[,1],gcv)
}

w_newtk1<-function(y,x,w,b,h,t){
	k<-dim(x)[2]
	n<-dim(x)[1]
	f<-matrix(0,n,1)
	g<-f
	dg<-matrix(0,n,k-1)
	xb<-crossprod(t(x),b)
	xb<-xb-weighted.mean(xb,w)
	hh<-c(sqrt(cov.wt(xb,w)$cov))
	dm<-crossprod(b,t/hh^2)
	hh<-h*hh
	e<-0.5/n
	i<-1
	while(i<=n){
		h=hh
		v<-(xb[i,1]-xb)/h
		kw=dnorm(xb[i,1]-xb,sd=h)
		kw=kw/sum(kw)
		g[i]<-crossprod(y,kw)
		dg[i,]<-crossprod(kw*v*(y-g[i]),(x[,2:k]-matrix(x[i,2:k],n,k-1,byrow=TRUE))/hh)
		dg[i,]<-dg[i,]+crossprod(kw*v*(y-g[i]),c(v)*matrix(dm,n,k-1,byrow=TRUE))
		f[i]<-max(kw)/sum(kw)
		i<-i+1
	}
	v<-dg*c((y+((2*y-1)*e)-g)/((g+e)*(1+e-g)))
	xb<-wsumc(v,w)
	i<-dg*c(g+e)
	i<-i/c(1+e-g)
	i<-t(w*dg)%*%i
	i<-solve(i)
	xb<-c(0,i%*%xb)
	list(cbind(xb,c(0,sqrt(n)*pmean(v)/apply(v,2,sd))),cbind(g,f),dg)
}

wsumc<-function(y,w) psum(y*w)
psum<-function(x){
	n<-nrow(x)
	c(matrix(1,1,n)%*%x)
}
pmean<-function(x){
	n<-nrow(x)
	c(matrix(1,1,n)%*%x)/n
}
wsum<-function(y,w) sum(y*w)

w_optimalselrqgcv<-function(dep1,reg1,wei,dep2,reg2,quant,maxorder,coefks, method="br"){
	wei=wei/mean(wei)
	reg2=as.matrix(reg2)
	index=reg1%*%coefks
	prob1<-glm(dep1~index,family=binomial(probit),weights=wei)$coef
	g<-prob1[1]+prob1[2]*index[dep1==1]
	mill<-cbind(1,dnorm(g)/pnorm(g))
	for(i in 2:maxorder) mill<-cbind(mill,mill[,2]^i)
	gcv=c()
	for(i in 1:maxorder){
		beta=rq.wfit(cbind(reg2[dep1==1,],mill[,1:(1+i)]),dep2[dep1==1],tau=quant,weights=wei[dep1==1],method=method)$coef
		if(rcond(t(cbind(reg2[dep1==1,],mill[,1:(i+1)])*wei[dep1==1])%*%cbind(reg2[dep1==1,],mill[,1:(i+1)]))<.Machine$double.eps) break
		gcv<-c(gcv,w_gcvq(dep2[dep1==1],cbind(reg2[dep1==1,],mill[,1:(i+1)]), wei[dep1==1], beta,quant))
	}
	gcv
}

w_gcvq<-function(dep,reg,wei,beta,quantile){
	pred<-reg%*%beta
	i=1
	H=0
	while(((i-1)*1000)<length(dep)){
		j=min(length(dep),i*1000)
		H=H+wsum(diag(reg[((i-1)*1000+1):j,]%*%solve(t(reg*wei)%*%reg)%*%t(reg[((i-1)*1000):j,])),wei[((i-1)*1000+1):j])
		i=i+1
	}
	weighted.mean(check(dep-pred,quantile),wei)/(1-H/sum(wei))^2
}

check<-function(lambda,q) (q-(lambda<0))*lambda
wmeanc<-function(y,w) psum(y*w)/sum(w)

######################################
#DGP2: realistic simulations
######################################
library(foreign)
library(quantreg)
library(snow)
#folder where the file "simulations.dta" is saved
folder=" "

data=read.dta(paste(folder,"simulations.dta",sep=""))
attach(data)
x2=cbind(exp, exp^2, hsg, college)[female==0,]
y=lwage[female==0]
w=wgt[female==0]
w=w/mean(w)
detach(data)
remove(data)
#dependence
y_coef=rq(y~x2,tau=seq(1/2000,1999/2000,1/1000),weights=w)$coef
#independence
temp=rq(y~x2,tau=0.5,weights=w)$coef
y_coef_ind=matrix(temp[2:5],4,1000)
y_coef_ind=rbind(wq(y-x2%*%temp[2:5],w,seq(1/2000,1999/2000,1/1000)),y_coef_ind)

data=read.dta(paste(folder,"simulations.dta",sep=""))
attach(data)
x1=cbind(child02, child35, child613, exp, exp^2, hsg, college)[female==1,]
d=ft[female==1]
w=wgt[female==1]
w=w/mean(w)
detach(data)
remove(data)
gamma_coef=glm(d~x1,family=binomial(probit),weights=w)$coef

#clustered computation
do_all=function(r,obs,rho,y_coef,y_coef_ind,gamma_coef,x1,w,hgrid,tgrid,maxorder,np,nreps,trim=0.045){
	set.seed(r)
	eps=rnorm(obs)
	temp=rnorm(obs)
	u=rho*eps+sqrt(1-rho^2)*temp
	u=pnorm(u)
	u=ceiling(u*1000)
	sel=sample(1:nrow(x1),obs,TRUE)
	x1s=x1[sel,]
	ds=1*c(cbind(1,x1s)%*%gamma_coef+eps>0)
	x2s=x1[sel,4:7]
	ws=w[sel]
	temp<-glm(ds~x1s,weights=ws,family=binomial(probit))$coef
	b1<-temp[3:length(temp)]/temp[2]
	res=matrix(,length(hgrid),length(b1))
	for(i in 1:length(hgrid)){
		temp=optim(b1,ob_inter,method="Nelder-Mead",y=ds,x=x1s,w=ws,h=hgrid[i],np=np,control=list(trace=0))
		res[i,]=temp$par		
	}
	gcv=rep(-10e10,length(hgrid))
	for(i in 1:length(hgrid)){
		if(max(abs(res[i,]))<10000) gcv[i]=w_after1(ds,x1s,ws,c(1,res[i,]),hgrid[i])[[4]]
	}
	ys=apply(cbind(x2s,u),1,function(x) c(1,x[1:4])%*%y_coef[,x[5]])
	ys[ds==0]=0
	optorder=c()
	for(i in seq(0.1,0.9,0.1)){
		temp=w_optimalselrqgcv(ds,x1s,ws,ys,x2s,i,maxorder,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]), method="br")
		optorder=c(optorder,(1:length(temp))[temp==min(temp)])
	}
	temp=colSums(optorder==matrix(1:maxorder,length(optorder),maxorder,byrow=TRUE))
	order_dep=(1:maxorder)[temp==max(temp)]
	test_results_dep=w_testindscore(ds,x1s,ws,hgrid[gcv==max(gcv)],ys,x2s,order_dep,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	ys=apply(cbind(x2s,u),1,function(x) c(1,x[1:4])%*%y_coef_ind[,x[5]])
	ys[ds==0]=0
	optorder=c()
	for(i in seq(0.1,0.9,0.1)){
		temp=w_optimalselrqgcv(ds,x1s,ws,ys,x2s,i,maxorder,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]), method="br")
		optorder=c(optorder,(1:length(temp))[temp==min(temp)])
	}
	temp=colSums(optorder==matrix(1:maxorder,length(optorder),maxorder,byrow=TRUE))
	order=(1:maxorder)[temp==max(temp)]
	test_results_ind=w_testindscore(ds,x1s,ws,hgrid[gcv==max(gcv)],ys,x2s,order,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	c(test_results_dep$ks,test_results_dep$cvm,test_results_dep$ks_coef_by_coef[1,],test_results_dep$cvm_coef_by_coef[1,],test_results_dep$ks_coef_by_coef[2,],test_results_dep$cvm_coef_by_coef[2,],test_results_dep$ks_coef_by_coef[3,],test_results_dep$cvm_coef_by_coef[3,],test_results_dep$ks_coef_by_coef[4,],test_results_dep$cvm_coef_by_coef[4,],
	test_results_ind$ks,test_results_ind$cvm,test_results_ind$ks_coef_by_coef[1,],test_results_ind$cvm_coef_by_coef[1,],test_results_ind$ks_coef_by_coef[2,],test_results_ind$cvm_coef_by_coef[2,],test_results_ind$ks_coef_by_coef[3,],test_results_ind$cvm_coef_by_coef[3,],test_results_ind$ks_coef_by_coef[4,],test_results_ind$cvm_coef_by_coef[4,],
	test_results_dep$finite_p,test_results_ind$finite_p,hgrid[(1:length(hgrid))[gcv==max(gcv)]],c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),order_dep,order,r)
}

#Here give the number of processors that you want to use
cl <- makeCluster(4)
clusterEvalQ(cl,library(quantreg))
clusterExport(cl,c("ob_inter","w_testindscore","wq","w_after1","w_newtk1","wsumc","psum","pmean","wsum","w_optimalselrqgcv","w_gcvq","check","wmeanc"))
obs400=clusterApplyLB(cl, 1:1000, do_all, obs=400, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
obs800=clusterApplyLB(cl, 1:1000, do_all, obs=800, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
obs1600=clusterApplyLB(cl, 1:1000, do_all, obs=1600, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
obs3200=clusterApplyLB(cl, 1:1000, do_all, obs=3200, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
obs6400=clusterApplyLB(cl, 1:1000, do_all, obs=6400, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)

#########################################
#Simulations with only one regressor
#########################################
library(mvtnorm)
do_all1=function(r,obs,hgrid,tgrid,maxorder,np,nreps,trim=0.045){
	set.seed(r)
	sigma <- matrix(c(1,0.8,0.8,1),2,2)
	e<-rmvnorm(obs,rep(0,2),sigma)
	x1s<-cbind(rnorm(obs),rnorm(obs))
	x2s=x1s[,1]
	ds<-(x1s[,1]+x1s[,2]+e[,1]>0)
	ws=rep(1,obs)
	temp<-glm(ds~x1s,family=binomial(probit))$coef
	b1<-temp[3:length(temp)]/temp[2]
	res=matrix(,length(hgrid),length(b1))
	for(i in 1:length(hgrid)){
		temp=optim(b1,ob_inter,method="Nelder-Mead",y=ds,x=x1s,w=ws,h=hgrid[i],np=np,control=list(trace=0))
		res[i,]=temp$par		
	}
	gcv=rep(-10e10,length(hgrid))
	for(i in 1:length(hgrid)){
		gcv[i]=w_after1(ds,x1s,ws,c(1,res[i,]),hgrid[i])[[4]]
	}
	ys=x2s+e[,2]
	ys[ds==0]=0
	optorder=c()
	for(i in seq(0.1,0.9,0.1)){
		temp=w_optimalselrqgcv(ds,x1s,ws,ys,x2s,i,maxorder,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]), method="br")
		optorder=c(optorder,(1:length(temp))[temp==min(temp)])
	}
	temp=colSums(optorder==matrix(1:maxorder,length(optorder),maxorder,byrow=TRUE))
	order_0=(1:maxorder)[temp==max(temp)]
	test_results_0=w_testindscore(ds,x1s,ws,hgrid[gcv==max(gcv)],ys,x2s,order_0,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	ys=x2s+(1+0.2*x2s)*e[,2]
	ys[ds==0]=0
	optorder=c()
	for(i in seq(0.1,0.9,0.1)){
		temp=w_optimalselrqgcv(ds,x1s,ws,ys,x2s,i,maxorder,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]), method="br")
		optorder=c(optorder,(1:length(temp))[temp==min(temp)])
	}
	temp=colSums(optorder==matrix(1:maxorder,length(optorder),maxorder,byrow=TRUE))
	order_2=(1:maxorder)[temp==max(temp)]
	test_results_2=w_testindscore(ds,x1s,ws,hgrid[gcv==max(gcv)],ys,x2s,order_2,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	ys=x2s+(1+0.5*x2s)*e[,2]
	ys[ds==0]=0
	optorder=c()
	for(i in seq(0.1,0.9,0.1)){
		temp=w_optimalselrqgcv(ds,x1s,ws,ys,x2s,i,maxorder,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]), method="br")
		optorder=c(optorder,(1:length(temp))[temp==min(temp)])
	}
	temp=colSums(optorder==matrix(1:maxorder,length(optorder),maxorder,byrow=TRUE))
	order_5=(1:maxorder)[temp==max(temp)]
	test_results_5=w_testindscore(ds,x1s,ws,hgrid[gcv==max(gcv)],ys,x2s,order_5,c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	c(test_results_0$ks,test_results_0$cvm,
	test_results_2$ks,test_results_2$cvm,
	test_results_5$ks,test_results_5$cvm,
	test_results_0$finite_p,test_results_2$finite_p,test_results_5$finite_p,
	hgrid[(1:length(hgrid))[gcv==max(gcv)]],c(1,res[(1:length(hgrid))[gcv==max(gcv)],]),order_0,order_2,order_5,r)
}

clusterEvalQ(cl,library(mvtnorm))
clusterExport(cl,c("ob_inter","w_testindscore","wq","w_after1","w_newtk1","wsumc","psum","pmean","wsum","w_optimalselrqgcv","w_gcvq","check","wmeanc"))
normal400=clusterApplyLB(cl, 1:1000, do_all1, obs=400, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
normal800=clusterApplyLB(cl, 1:1000, do_all1, obs=800, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
normal1600=clusterApplyLB(cl, 1:1000, do_all1, obs=1600, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
normal3200=clusterApplyLB(cl, 1:1000, do_all1, obs=3200, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)
normal6400=clusterApplyLB(cl, 1:1000, do_all1, obs=6400, hgrid=c(0.01,0.05,0.1,0.25,0.5,1,2,5), tgrid=seq(0.1,0.9,0.01), maxorder=5, np=100, nreps=250)

###############################################
# redo all with different ranges of quantiles #
###############################################
#realistic simulations
redo_all=function(r,obs,rho,y_coef,y_coef_ind,gamma_coef,x1,w,first,tgrid,nreps,trim=0.045){
	set.seed(r)
	eps=rnorm(obs)
	temp=rnorm(obs)
	u=rho*eps+sqrt(1-rho^2)*temp
	u=pnorm(u)
	u=ceiling(u*1000)
	sel=sample(1:nrow(x1),obs,TRUE)
	x1s=x1[sel,]
	ds=1*c(cbind(1,x1s)%*%gamma_coef+eps>0)
	x2s=x1[sel,4:7]
	ws=w[sel]
	ys=apply(cbind(x2s,u),1,function(x) c(1,x[1:4])%*%y_coef[,x[5]])
	ys[ds==0]=0
	order_dep=first[[r]][91]
	test_results_dep=w_testindscore(ds,x1s,ws,first[[r]][83],ys,x2s,order_dep,first[[r]][84:90],m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	ys=apply(cbind(x2s,u),1,function(x) c(1,x[1:4])%*%y_coef_ind[,x[5]])
	ys[ds==0]=0
	order=first[[r]][92]
	test_results_ind=w_testindscore(ds,x1s,ws,first[[r]][83],ys,x2s,order,first[[r]][84:90],m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	c(test_results_dep$ks,test_results_dep$cvm,test_results_dep$ks_coef_by_coef[1,],test_results_dep$cvm_coef_by_coef[1,],test_results_dep$ks_coef_by_coef[2,],test_results_dep$cvm_coef_by_coef[2,],test_results_dep$ks_coef_by_coef[3,],test_results_dep$cvm_coef_by_coef[3,],test_results_dep$ks_coef_by_coef[4,],test_results_dep$cvm_coef_by_coef[4,],
	test_results_ind$ks,test_results_ind$cvm,test_results_ind$ks_coef_by_coef[1,],test_results_ind$cvm_coef_by_coef[1,],test_results_ind$ks_coef_by_coef[2,],test_results_ind$cvm_coef_by_coef[2,],test_results_ind$ks_coef_by_coef[3,],test_results_ind$cvm_coef_by_coef[3,],test_results_ind$ks_coef_by_coef[4,],test_results_ind$cvm_coef_by_coef[4,],
	test_results_dep$finite_p,test_results_ind$finite_p,first[[r]][83:90],order_dep,order,r)
}

clusterExport(cl,c("ob_inter","w_testindscore","wq","w_after1","w_newtk1","wsumc","psum","pmean","wsum","w_optimalselrqgcv","w_gcvq","check","wmeanc"))
obs400_0595=clusterApplyLB(cl, 1:1000, redo_all, obs=400, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs400, tgrid=seq(0.05,0.95,0.01), nreps=250)
obs800_0595=clusterApplyLB(cl, 1:1000, redo_all, obs=800, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs800, tgrid=seq(0.05,0.95,0.01), nreps=250)
obs1600_0595=clusterApplyLB(cl, 1:1000, redo_all, obs=1600, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs1600, tgrid=seq(0.05,0.95,0.01), nreps=250)
obs3200_0595=clusterApplyLB(cl, 1:1000, redo_all, obs=3200, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs3200, tgrid=seq(0.05,0.95,0.01), nreps=250)
obs6400_0595=clusterApplyLB(cl, 1:1000, redo_all, obs=6400, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs6400, tgrid=seq(0.05,0.95,0.01), nreps=250)

obs400_2080=clusterApplyLB(cl, 1:1000, redo_all, obs=400, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs400, tgrid=seq(0.2,0.8,0.01), nreps=250)
obs800_2080=clusterApplyLB(cl, 1:1000, redo_all, obs=800, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs800, tgrid=seq(0.2,0.8,0.01), nreps=250)
obs1600_2080=clusterApplyLB(cl, 1:1000, redo_all, obs=1600, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs1600, tgrid=seq(0.2,0.8,0.01), nreps=250)
obs3200_2080=clusterApplyLB(cl, 1:1000, redo_all, obs=3200, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs3200, tgrid=seq(0.2,0.8,0.01), nreps=250)
obs6400_2080=clusterApplyLB(cl, 1:1000, redo_all, obs=6400, rho=0.233, y_coef=y_coef, y_coef_ind=y_coef_ind, gamma_coef=gamma_coef, x1=x1, w=w, first=obs6400, tgrid=seq(0.2,0.8,0.01), nreps=250)

#simulations with one regressor
redo_all1=function(r,obs,first,tgrid,nreps,trim=0.045){
	set.seed(r)
	sigma <- matrix(c(1,0.8,0.8,1),2,2)
	e<-rmvnorm(obs,rep(0,2),sigma)
	x1s<-cbind(rnorm(obs),rnorm(obs))
	x2s=x1s[,1]
	ds<-(x1s[,1]+x1s[,2]+e[,1]>0)
	ws=rep(1,obs)
	ys=x2s+e[,2]
	ys[ds==0]=0
	order_0=first[[r]][31]
	test_results_0=w_testindscore(ds,x1s,ws,first[[r]][28],ys,x2s,order_0,first[[r]][29:30],m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	ys=x2s+(1+0.2*x2s)*e[,2]
	ys[ds==0]=0
	order_2=first[[r]][32]
	test_results_2=w_testindscore(ds,x1s,ws,first[[r]][28],ys,x2s,order_2,first[[r]][29:30],m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	ys=x2s+(1+0.5*x2s)*e[,2]
	ys[ds==0]=0
	order_5=first[[r]][33]
	test_results_5=w_testindscore(ds,x1s,ws,first[[r]][28],ys,x2s,order_5,first[[r]][29:30],m=c(20+length(ys)^0.25,20+length(ys)^(1/2.01),length(ys)/4,length(ys)),grid=tgrid,nreps=nreps,method="br",trim=trim)
	c(test_results_0$ks,test_results_0$cvm,
	test_results_2$ks,test_results_2$cvm,
	test_results_5$ks,test_results_5$cvm,
	test_results_0$finite_p,test_results_2$finite_p,test_results_5$finite_p,
	first[[r]][28:30],order_0,order_2,order_5,r)
}

normal100_0595=clusterApplyLB(cl, 1:1000, redo_all1, obs=100, normal100, tgrid=seq(0.05,0.95,0.01), nreps=250)
normal400_0595=clusterApplyLB(cl, 1:1000, redo_all1, obs=400, normal400, tgrid=seq(0.05,0.95,0.01), nreps=250)
normal1600_0595=clusterApplyLB(cl, 1:1000, redo_all1, obs=1600, normal1600, tgrid=seq(0.05,0.95,0.01), nreps=250)
normal3200_0595=clusterApplyLB(cl, 1:1000, redo_all1, obs=3200, normal3200, tgrid=seq(0.05,0.95,0.01), nreps=250)
normal6400_0595=clusterApplyLB(cl, 1:1000, redo_all1, obs=6400, normal6400, tgrid=seq(0.05,0.95,0.01), nreps=250)

normal100_2080=clusterApplyLB(cl, 1:1000, redo_all1, obs=100, normal100, tgrid=seq(0.2,0.8,0.01), nreps=250)
normal400_2080=clusterApplyLB(cl, 1:1000, redo_all1, obs=400, normal400, tgrid=seq(0.2,0.8,0.01), nreps=250)
normal1600_2080=clusterApplyLB(cl, 1:1000, redo_all1, obs=1600, normal1600, tgrid=seq(0.2,0.8,0.01), nreps=250)
normal3200_2080=clusterApplyLB(cl, 1:1000, redo_all1, obs=3200, normal3200, tgrid=seq(0.2,0.8,0.01), nreps=250)
normal6400_2080=clusterApplyLB(cl, 1:1000, redo_all1, obs=6400, normal6400, tgrid=seq(0.2,0.8,0.01), nreps=250)

#################################
#Make the tables
#################################
library(xtable)

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs400_0595[[i]])

ks.dep<-c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05))
cms.dep<-c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05))
ks.ind<-c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05))
cms.ind<-c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs1600_0595[[i]])

ks.dep<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs3200_0595[[i]])

ks.dep<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs6400_0595[[i]])

ks.dep_0595<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep_0595<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind_0595<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind_0595<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs400_2080[[i]])

ks.dep<-c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05))
cms.dep<-c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05))
ks.ind<-c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05))
cms.ind<-c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs1600_2080[[i]])

ks.dep<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs3200_2080[[i]])

ks.dep<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, obs6400_2080[[i]])

ks.dep_2080<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep_2080<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind_2080<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind_2080<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

#m.obs<-c()
#for (i in 1:1000) m.obs<-rbind(m.obs, obs400[[i]][1:93])
m.obs<-obs400_1090

ks.dep<-c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05))
cms.dep<-c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05))
ks.ind<-c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05))
cms.ind<-c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05))

#m.obs<-c()
#for (i in 1:1000) m.obs<-rbind(m.obs, obs1600[[i]][1:93])
m.obs<-obs1600_1090

ks.dep<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

#m.obs<-c()
#for (i in 1:1000) m.obs<-rbind(m.obs, obs3200[[i]][1:93])
m.obs<-obs3200_1090

ks.dep<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

#m.obs<-c()
#for (i in 1:1000) m.obs<-rbind(m.obs, obs6400[[i]][1:93])
m.obs<-obs6400_1090

ks.dep_1090<-rbind(ks.dep,c(mean(m.obs[,4]<0.05), mean(m.obs[,12]<0.05), mean(m.obs[,20]<0.05), mean(m.obs[,28]<0.05) , mean(m.obs[,36]<0.05)))
cms.dep_1090<-rbind(cms.dep,c(mean(m.obs[,8]<0.05), mean(m.obs[,16]<0.05), mean(m.obs[,24]<0.05), mean(m.obs[,32]<0.05), mean(m.obs[,40]<0.05)))
ks.ind_1090<-rbind(ks.ind,c(mean(m.obs[,44]<0.05), mean(m.obs[,52]<0.05), mean(m.obs[,60]<0.05), mean(m.obs[,68]<0.05) , mean(m.obs[,76]<0.05)))
cms.ind_1090<-rbind(cms.ind,c(mean(m.obs[,48]<0.05), mean(m.obs[,56]<0.05), mean(m.obs[,64]<0.05), mean(m.obs[,72]<0.05), mean(m.obs[,80]<0.05)))

xtable(rbind(cbind(ks.ind_0595, ks.ind_1090, ks.ind_2080), cbind(ks.dep_0595, ks.dep_1090, ks.dep_2080), cbind(cms.ind_0595, cms.ind_1090, cms.ind_2080), cbind(cms.dep_0595, cms.dep_1090, cms.dep_2080)), digit=3)
(rbind(cbind(ks.ind_0595, ks.ind_1090, ks.ind_2080), cbind(ks.dep_0595, ks.dep_1090, ks.dep_2080), cbind(cms.ind_0595, cms.ind_1090, cms.ind_2080), cbind(cms.dep_0595, cms.dep_1090, cms.dep_2080)))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal100_0595[[i]])

ks.0<-mean(m.obs[,4]<0.05)
ks.2<-mean(m.obs[,12]<0.05)
ks.5<-mean(m.obs[,20]<0.05)

cms.0<-mean(m.obs[,8]<0.05)
cms.2<-mean(m.obs[,16]<0.05)
cms.5<-mean(m.obs[,24]<0.05)

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal100[[i]][1:30])

ks.0<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal100_2080[[i]])

ks.0.100<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2.100<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5.100<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0.100<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2.100<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5.100<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal400_0595[[i]])

ks.0<-mean(m.obs[,4]<0.05)
ks.2<-mean(m.obs[,12]<0.05)
ks.5<-mean(m.obs[,20]<0.05)

cms.0<-mean(m.obs[,8]<0.05)
cms.2<-mean(m.obs[,16]<0.05)
cms.5<-mean(m.obs[,24]<0.05)

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal400[[i]][1:30])

ks.0<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal400_2080[[i]])

ks.0.400<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2.400<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5.400<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0.400<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2.400<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5.400<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal1600_0595[[i]])

ks.0<-mean(m.obs[,4]<0.05)
ks.2<-mean(m.obs[,12]<0.05)
ks.5<-mean(m.obs[,20]<0.05)

cms.0<-mean(m.obs[,8]<0.05)
cms.2<-mean(m.obs[,16]<0.05)
cms.5<-mean(m.obs[,24]<0.05)

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal1600[[i]][1:30])

ks.0<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal1600_2080[[i]])

ks.0.1600<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2.1600<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5.1600<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0.1600<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2.1600<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5.1600<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal3200_0595[[i]])

ks.0<-mean(m.obs[,4]<0.05)
ks.2<-mean(m.obs[,12]<0.05)
ks.5<-mean(m.obs[,20]<0.05)

cms.0<-mean(m.obs[,8]<0.05)
cms.2<-mean(m.obs[,16]<0.05)
cms.5<-mean(m.obs[,24]<0.05)

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal3200[[i]][1:30])

ks.0<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal3200_2080[[i]])

ks.0.3200<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2.3200<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5.3200<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0.3200<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2.3200<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5.3200<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal6400_0595[[i]])

ks.0<-mean(m.obs[,4]<0.05)
ks.2<-mean(m.obs[,12]<0.05)
ks.5<-mean(m.obs[,20]<0.05)

cms.0<-mean(m.obs[,8]<0.05)
cms.2<-mean(m.obs[,16]<0.05)
cms.5<-mean(m.obs[,24]<0.05)

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal6400[[i]][1:30])

ks.0<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5<-c(cms.5,mean(m.obs[,24]<0.05))

m.obs<-c()
for (i in 1:1000) m.obs<-rbind(m.obs, normal6400_2080[[i]])

ks.0.6400<-c(ks.0,mean(m.obs[,4]<0.05))
ks.2.6400<-c(ks.2,mean(m.obs[,12]<0.05))
ks.5.6400<-c(ks.5,mean(m.obs[,20]<0.05))

cms.0.6400<-c(cms.0,mean(m.obs[,8]<0.05))
cms.2.6400<-c(cms.2,mean(m.obs[,16]<0.05))
cms.5.6400<-c(cms.5,mean(m.obs[,24]<0.05))

xtable( rbind(  cbind(rbind(ks.0.100,ks.0.400,ks.0.1600,ks.0.3200,ks.0.6400),rbind(ks.2.100,ks.2.400,ks.2.1600,ks.2.3200,ks.2.6400),rbind(ks.5.100,ks.5.400,ks.5.1600,ks.5.3200,ks.5.6400)),   cbind(rbind(cms.0.100,cms.0.400,cms.0.1600,cms.0.3200,cms.0.6400),rbind(cms.2.100,cms.2.400,cms.2.1600,cms.2.3200,cms.2.6400),rbind(cms.5.100,cms.5.400,cms.5.1600,cms.5.3200,cms.5.6400)) )   ,digits=3  )

ks.0<-mean(normal800_0595[,4]<0.05)
ks.2<-mean(normal800_0595[,12]<0.05)
ks.5<-mean(normal800_0595[,20]<0.05)

cms.0<-mean(normal800_0595[,8]<0.05)
cms.2<-mean(normal800_0595[,16]<0.05)
cms.5<-mean(normal800_0595[,24]<0.05)

ks.0<-cbind(ks.0,mean(normal800[,4]<0.05))
ks.2<-cbind(ks.2,mean(normal800[,12]<0.05))
ks.5<-cbind(ks.5,mean(normal800[,20]<0.05))

cms.0<-cbind(cms.0,mean(normal800[,8]<0.05))
cms.2<-cbind(cms.2,mean(normal800[,16]<0.05))
cms.5<-cbind(cms.5,mean(normal800[,24]<0.05))

ks.0.800<-cbind(ks.0,mean(normal800_2080[,4]<0.05))
ks.2.800<-cbind(ks.2,mean(normal800_2080[,12]<0.05))
ks.5.800<-cbind(ks.5,mean(normal800_2080[,20]<0.05))

cms.0.800<-cbind(cms.0,mean(normal800_2080[,8]<0.05))
cms.2.800<-cbind(cms.2,mean(normal800_2080[,16]<0.05))
cms.5.800<-cbind(cms.5,mean(normal800_2080[,24]<0.05))

xtable(cbind(ks.0.800, ks.2.800, ks.5.800), digits=3)

xtable(cbind(cms.0.800, cms.2.800, cms.5.800), digits=3)


# other mesh size for normal DGP and smaple size 1600 and [0.05, 0.095]: 0.005 and 0.02
ks.0<-mean(normal1600_0.005[,4]<0.05)
ks.2<-mean(normal1600_0.005[,12]<0.05)
ks.5<-mean(normal1600_0.005[,20]<0.05)

cms.0<-mean(normal1600_0.005[,8]<0.05)
cms.2<-mean(normal1600_0.005[,16]<0.05)
cms.5<-mean(normal1600_0.005[,24]<0.05)

ks.0<-c(ks.0,mean(normal1600_0.02[,4]<0.05))
ks.2<-c(ks.2,mean(normal1600_0.02[,12]<0.05))
ks.5<-c(ks.5,mean(normal1600_0.02[,20]<0.05))

cms.0<-c(cms.0,mean(normal1600_0.02[,8]<0.05))
cms.2<-c(cms.2,mean(normal1600_0.02[,16]<0.05))
cms.5<-c(cms.5,mean(normal1600_0.02[,24]<0.05))

ks.0<-c(0.036,ks.0)
ks.2<-c(0.936, ks.2)
ks.5<-c(1, ks.5)

cms.0<-c(0.032,cms.0)
cms.2<-c(0.957, cms.2)
cms.5<-c(1, cms.5)

xtable(cbind(ks.0, ks.2, ks.5),digits=3  )

xtable(cbind(cms.0, cms.2, cms.5),digits=3  )




