library(foreign)
library(quantreg)
#change folder here
folder=""

data=read.dta(paste(folder,"simulations.dta",sep=""))

attach(data)
x2=cbind(exp, exp^2, hsg, college)[female==0,]
y=lwage[female==0]
w=wgt[female==0]
w=w/mean(w)
detach(data)
remove(data)

y_coef=rq(y~x2,tau=seq(1/2000,1999/2000,1/1000),weights=w)$coef

data=read.dta(paste(folder,"simulations.dta",sep=""))
attach(data)
x1=cbind(exp, exp^2, hsg, college, child02, child35, child613)[female==1,]
d=ft[female==1]
w=wgt[female==1]
w=w/mean(w)
detach(data)
remove(data)

gamma_coef=glm(d~x1,family=binomial(probit),weights=w)$coef

#Estimate the bias
obs=1000000
res=array(,c(10,99,5,4))
rho_all=c(-0.99,-0.5,0.5,0.99)
for(r in 9:10){
	for(m in 1:4){
		rho=rho_all[m]
		set.seed(r)
		eps=rnorm(obs)
		temp=rnorm(obs)
		u=rho*eps+sqrt(1-rho^2)*temp
		u=pnorm(u)
		u=ceiling(u*1000)
		sel=sample(1:45296,obs,TRUE)
		x1s=x1[sel,]
		ds=1*c(cbind(1,x1s)%*%gamma_coef+eps>0)
		x2s=x1[sel,1:4]
		ys=apply(cbind(x2s,u),1,function(x) c(1,x[1:4])%*%y_coef[,x[5]])
		ws=w[sel]
		index=cbind(1,x1s)%*%gamma_coef
		prob1<-glm(ds~index,family=binomial(probit),weights=ws)$coef
		g<-prob1[1]+prob1[2]*index
		mill<-cbind(1,dnorm(g)/pnorm(g))
		for(i in 2:6) mill<-cbind(mill,mill[,2]^i)
		temp=matrix(,5,99)
		for(q in 1:99){
			attempt=1
			temp1=0
			while(temp1==0 & attempt<20){
				try(temp1<-rq(ys[ds==1]~cbind(x2s[ds==1,],mill[ds==1,])-1,tau=q/100,weights=ws[ds==1],method="pfn")$coef[1:5],silent=TRUE)
				attempt=attempt+1
			}
			temp[,q]<-temp1
		}
		for(k in 1:5){ 
			res[r,1:99,k,m]=temp[k,]
		}
	}
}

layout.show(layout(matrix(c(1,2,3,4), 2,2,byrow=TRUE),c(1.1,1),c(1,1)))
par(mar=c(2,4,4,1))
temp=c()
for(i in 2:98){
	temp=c(temp,mean(y_coef[2,(5+(i-1)*10):(14+(i-1)*10)]))
}
plot(seq(0.02,0.98,0.01),temp,type="l",lwd=2,xlab="Quantile",ylab="Quantile regression coefficient",main="Experience")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,1,1]),lty=3,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,1,2]),lty=5,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,1,3]),lty=5,lwd=2,col="grey")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,1,4]),lty=3,lwd=2,col="grey")
legend(0.3,0.025,c("0.99","0.5","0 (true values)", "-0.5","-0.99"),lty=c(3,5,1,5,3),lwd=2,col=c("grey","grey","black","black","black"),title="Correlation")

temp=c()
for(i in 2:98){
	temp=c(temp,mean(y_coef[3,(5+(i-1)*10):(14+(i-1)*10)]))
}
par(mar=c(2,2,4,1))
plot(seq(0.02,0.98,0.01),temp,type="l",lwd=2,xlab="Quantile",ylab="Quantile regression coefficient",main="Experience squared")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,2,1]),lty=3,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,2,2]),lty=5,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,2,3]),lty=5,lwd=2,col="grey")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,2,4]),lty=3,lwd=2,col="grey")
#legend(0.35,0,c("0.99","0.5","0 (true values)", "-0.5","-0.99"),lty=c(3,5,1,5,3),lwd=2,col=c("grey","grey","black","black","black"),title="Correlation")

temp=c()
for(i in 2:98){
	temp=c(temp,mean(y_coef[4,(5+(i-1)*10):(14+(i-1)*10)]))
}
par(mar=c(4,4,4,1))
plot(seq(0.02,0.98,0.01),temp,type="l",lwd=2,xlab="Quantile",ylab="Quantile regression coefficient",main="High School")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,3,1]),lty=3,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,3,2]),lty=5,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,3,3]),lty=5,lwd=2,col="grey")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,3,4]),lty=3,lwd=2,col="grey")
#legend(0.35,0,c("0.99","0.5","0 (true values)", "-0.5","-0.99"),lty=c(3,5,1,5,3),lwd=2,col=c("grey","grey","black","black","black"),title="Correlation")

temp=c()
for(i in 2:98){
	temp=c(temp,mean(y_coef[5,(5+(i-1)*10):(14+(i-1)*10)]))
}
par(mar=c(4,2,4,1))
plot(seq(0.02,0.98,0.01),temp,type="l",lwd=2,xlab="Quantile",ylab="Quantile regression coefficient",main="College")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,4,1]),lty=3,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,4,2]),lty=5,lwd=2)
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,4,3]),lty=5,lwd=2,col="grey")
lines(seq(0.02,0.98,0.01),colMeans(res[,2:98,4,4]),lty=3,lwd=2,col="grey")
#legend(0.35,0,c("0.99","0.5","0 (true values)", "-0.5","-0.99"),lty=c(3,5,1,5,3),lwd=2,col=c("grey","grey","black","black","black"),title="Correlation")


