library(mvtnorm)
set.seed(1)
obs=500
sigma <- matrix(c(1,0.8,0.8,1),2,2)
e<-rmvnorm(obs,rep(0,2),sigma)
x1s<-rnorm(obs)
x1s=cbind(x1s,-x1s)
x2s=x1s[,1]
ds<-(x1s[,1]+x1s[,2]+e[,1]>0)
ys=x2s+e[,2]

layout.show(layout(matrix(c(1,2), 1,2),c(1,1),c(1)))
par(mar=c(4,4,4,1))
plot(x2s,ys,pch=4,xlim=c(-2,2),ylim=c(-3.8,3.8),ylab="Y",xlab=expression(X[2]),main="Independent error terms",cex.main=2)
points(x2s[ds==1],ys[ds==1],pch=0,col=grey(0.6))
lines(c(-10,10),c(-10,10),lwd=2)
obs=1000000
e<-rmvnorm(obs,rep(0,2),sigma)
lines(c(-10,10),c(-10+median(e[e[,1]>0,2]),10+median(e[e[,1]>0,2])),col="black", lty=2, lwd=2)
legend(-2,4,c("whole population","selected population"),title="Median regression in the",lty=c(1,2),col=c("black"),cex=1.2,lwd=2)

obs=500
set.seed(1)
e<-rmvnorm(obs,rep(0,2),sigma)
x1s<-rnorm(obs)
x1s=cbind(x1s,-x1s)
x2s=x1s[,1]
ds<-(x1s[,1]+x1s[,2]+e[,1]>0)
ys=x2s+(1+0.5*x2s)*e[,2]
plot(x2s,ys,ylab="Y",pch=4,xlim=c(-2,2),ylim=c(-3,3.8),xlab=expression(X[2]),main="Heteroscedastic error terms",cex.main=2)
points(x2s[ds==1],ys[ds==1],pch=0)
lines(c(-10,10),c(-10,10),lwd=2)
obs=1000000
e<-rmvnorm(obs,rep(0,2),sigma)
slope=1+0.5*median(e[e[,1]>0,2])
lines(c(-3,3),c(-2-1*slope,-2+5*slope),col="black",lty=2,lwd=2)
legend(-2,4,c("whole population","selected population"),title="Median regression in the",lty=c(1,2),col=c("black"),cex=1.2,lwd=2)


