clear
set mem 200m

*Download the file morg11.dta from http://data.nber.org/morg/annual/
*Define here the folder where the document has been saved 
global path "C:\Users\Blaise\Dropbox\Selection\"
*Define here the folder where the files will be saved
global path_save "C:\Users\Blaise\Dropbox\Selection\"
use "${path}\morg11.dta", clear
   
	/* keep age 18-64 wage and salary workers who had job wk before survey. */
	keep if age>=25 & age<=54
   	drop if class94==1 | class94==2 | class94==3 | class94==6 | class94==7
	gen employed=(lfsr94==1 | lfsr94==2)

	keep if race==1
   
   /* create region. */
	gen byte mw=(state>=31 & state<=47)
	gen byte So=(state>=51 & state<=74)
	gen byte We=(state>=81 & state<=95)
	
   /* create variable "female" equals one if the individual is female, zero 
   otherwise. */
   gen byte female=sex==2

   /* create variable "educomp" to indicate the number of years of completed 
   schooling.  If the individual did not complete the highest grade he 
   attended, his years of completed schooling is assigned to be one less than 
   the highest grade attended.*/
	gen educomp=.
	replace educomp=0 if grade92==31
	replace educomp=2.5 if grade92==32
	replace educomp=5.5 if grade92==33
	replace educomp=7.5 if grade92==34
	replace educomp=9 if grade92==35
	replace educomp=10 if grade92==36
	replace educomp=11 if grade92==37
	replace educomp=12 if grade92==38
	replace educomp=12 if grade92==39
	replace educomp=13 if grade92==40
	replace educomp=14 if grade92==41
	replace educomp=14 if grade92==42
	replace educomp=16 if grade92==43
	replace educomp=18 if grade92==44
	replace educomp=18 if grade92==45
	replace educomp=18 if grade92==46

	*education dummies
	gen hsg=educomp>=12
	gen college=educomp>=16

	/* create variable "exp" to indicate the number of years of experience, 1979-1991. */
 	  gen exp=max(age-educomp-5,0)
	  gen exp2=exp^2

   /* hours variables. */
    replace uhours=99 if uhours>=99 & uhours<.
    replace hourslw=99 if hourslw>=99 & hourslw<.
	replace hourslw=0 if lfsr94==2

   /* create variable to indicate fulltime workers (hours>=35).  We cannot use the MORG provided flag because of inconsistency. */
	gen byte ft=hourslw>=35
	replace ft=0 if hourslw==.
	label var ft "Hours >= 35 last week"
	tab ft , miss
	
	*Wages
	gen wage=earnwke/uhourse
	gen lwage=log(wage)

	* allocation flags  
	gen aernhr=I25c
	gen aernwk=I25d
	replace aernhr = (aernhr>0 & aernhr!=.)
	replace aernwk = (aernwk>0 & aernwk!=.)
	gen awage= aernhr if paidhre==1
	replace awage= aernwk if paidhre==2

	*weights
	gen wgt=earnwt
	label variable wgt "earnings weight"
	gen wgt_hrs=wgt*uhourse	
	label variable wgt_hrs "earnings weight*hours last week"

	*Children
	keep if relref<=3

	gen child017=ownchild
	gen child05_lb=0
	gen child05_ub=0
	gen child02_lb=0
	gen child02_ub=0
	gen child35_lb=0
	gen child35_ub=0
	gen child613_lb=0
	gen child613_ub=0
	gen child1417_lb=0
	gen child1417_ub=0

	replace child05_lb=child017 if chldpres==5
	replace child05_ub=child017 if chldpres==5
	replace child02_lb=1 if chldpres==5
	replace child02_ub=child017-1 if chldpres==5
	replace child35_lb=1 if chldpres==5
	replace child35_ub=child017-1 if chldpres==5
	replace child613_lb=0 if chldpres==5
	replace child613_ub=0 if chldpres==5
	replace child1417_lb=0 if chldpres==5
	replace child1417_ub=0 if chldpres==5

	replace child613_lb=child017 if chldpres==3
	replace child613_ub=child017 if chldpres==3
	replace child05_lb=0 if chldpres==3
	replace child05_ub=0 if chldpres==3
	replace child02_lb=0 if chldpres==3
	replace child02_ub=0 if chldpres==3
	replace child35_lb=0 if chldpres==3
	replace child35_ub=0 if chldpres==3
	replace child1417_lb=0 if chldpres==3
	replace child1417_ub=0 if chldpres==3

	replace child1417_lb=child017 if chldpres==4
	replace child1417_ub=child017 if chldpres==4
	replace child05_lb=0 if chldpres==4
	replace child05_ub=0 if chldpres==4
	replace child02_lb=0 if chldpres==4
	replace child02_ub=0 if chldpres==4
	replace child35_lb=0 if chldpres==4
	replace child35_ub=0 if chldpres==4
	replace child613_lb=0 if chldpres==4
	replace child613_lb=0 if chldpres==4

	replace child05_lb=0 if chldpres==10
	replace child05_ub=0 if chldpres==10
	replace child02_lb=0 if chldpres==10
	replace child02_ub=0 if chldpres==10
	replace child35_lb=0 if chldpres==10
	replace child35_ub=0 if chldpres==10
	replace child613_lb=1 if chldpres==10
	replace child613_ub=child017-1 if chldpres==10
	replace child1417_lb=1 if chldpres==10
	replace child1417_ub=child017-1 if chldpres==10

	replace child05_lb=2 if chldpres==12
	replace child05_ub=child017-1 if chldpres==12
	replace child02_lb=1 if chldpres==12
	replace child02_ub=child017-2 if chldpres==12
	replace child35_lb=1 if chldpres==12
	replace child35_ub=child017-2 if chldpres==12
	replace child613_lb=0 if chldpres==12
	replace child613_ub=0 if chldpres==12
	replace child1417_lb=1 if chldpres==12
	replace child1417_ub=child017-2 if chldpres==12

	replace child05_lb=2 if chldpres==11
	replace child05_ub=child017-1 if chldpres==11
	replace child02_lb=1 if chldpres==11
	replace child02_ub=child017-2 if chldpres==11
	replace child35_lb=1 if chldpres==11
	replace child35_ub=child017-2 if chldpres==11
	replace child613_lb=1 if chldpres==11
	replace child613_ub=child017-2 if chldpres==11
	replace child1417_lb=0 if chldpres==11
	replace child1417_ub=0 if chldpres==11

	replace child05_lb=2 if chldpres==15
	replace child05_ub=child017-2 if chldpres==15
	replace child02_lb=1 if chldpres==15
	replace child02_ub=child017-3 if chldpres==15
	replace child35_lb=1 if chldpres==15
	replace child35_ub=child017-3 if chldpres==15
	replace child613_lb=1 if chldpres==15
	replace child613_ub=child017-3 if chldpres==15
	replace child1417_lb=1 if chldpres==15
	replace child1417_ub=child017-3 if chldpres==15

	replace child05_lb=child017 if chldpres==1
	replace child05_ub=child017 if chldpres==1
	replace child02_lb=child017 if chldpres==1
	replace child02_ub=child017 if chldpres==1
	replace child35_lb=0 if chldpres==1
	replace child35_ub=0 if chldpres==1
	replace child613_lb=0 if chldpres==1
	replace child613_ub=0 if chldpres==1
	replace child1417_lb=0 if chldpres==1
	replace child1417_ub=0 if chldpres==1

	replace child05_lb=child017 if chldpres==2
	replace child05_ub=child017 if chldpres==2
	replace child02_lb=0 if chldpres==2
	replace child02_ub=0 if chldpres==2
	replace child35_lb=child017 if chldpres==2
	replace child35_ub=child017 if chldpres==2
	replace child613_lb=0 if chldpres==2
	replace child613_ub=0 if chldpres==2
	replace child1417_lb=0 if chldpres==2
	replace child1417_ub=0 if chldpres==2

replace child05_lb=1 if chldpres==6
	replace child05_ub=child017-1 if chldpres==6
	replace child02_lb=1 if chldpres==6
	replace child02_ub=child017-1 if chldpres==6
	replace child35_lb=0 if chldpres==6
	replace child35_ub=0 if chldpres==6
	replace child613_lb=1 if chldpres==6
	replace child613_ub=child017-1 if chldpres==6
	replace child1417_lb=0 if chldpres==6
	replace child1417_ub=0 if chldpres==6

	replace child05_lb=1 if chldpres==7
	replace child05_ub=child017-1 if chldpres==7
	replace child02_lb=1 if chldpres==7
	replace child02_ub=child017-1 if chldpres==7
	replace child35_lb=0 if chldpres==7
	replace child35_ub=0 if chldpres==7
	replace child613_lb=0 if chldpres==7
	replace child613_ub=0 if chldpres==7
	replace child1417_lb=1 if chldpres==7
	replace child1417_ub=child017-1 if chldpres==7

	replace child05_lb=1 if chldpres==8
	replace child05_ub=child017-1 if chldpres==8
	replace child02_lb=0 if chldpres==8
	replace child02_ub=0 if chldpres==8
	replace child35_lb=1 if chldpres==8
	replace child35_ub=child017-1 if chldpres==8
	replace child613_lb=1 if chldpres==8
	replace child613_ub=child017-1 if chldpres==8
	replace child1417_lb=0 if chldpres==8
	replace child1417_ub=0 if chldpres==8

	replace child05_lb=1 if chldpres==9
	replace child05_ub=child017-1 if chldpres==9
	replace child02_lb=0 if chldpres==9
	replace child02_ub=0 if chldpres==9
	replace child35_lb=1 if chldpres==9
	replace child35_ub=child017-1 if chldpres==9
	replace child613_lb=0 if chldpres==9
	replace child613_ub=0 if chldpres==9
	replace child1417_lb=1 if chldpres==9
	replace child1417_ub=child017-1 if chldpres==9

	replace child05_lb=1 if chldpres==13
	replace child05_ub=child017-2 if chldpres==13
	replace child02_lb=1 if chldpres==13
	replace child02_ub=child017-2 if chldpres==13
	replace child35_lb=0 if chldpres==13
	replace child35_ub=0 if chldpres==13
	replace child613_lb=1 if chldpres==13
	replace child613_ub=child017-2 if chldpres==13
	replace child1417_lb=1 if chldpres==13
	replace child1417_ub=child017-2 if chldpres==13

	replace child05_lb=1 if chldpres==14
	replace child05_ub=child017-2 if chldpres==14
	replace child02_lb=0 if chldpres==14
	replace child02_ub=0 if chldpres==14
	replace child35_lb=1 if chldpres==14
	replace child35_ub=child017-2 if chldpres==14
	replace child613_lb=1 if chldpres==14
	replace child613_ub=child017-2 if chldpres==14
	replace child1417_lb=1 if chldpres==14
	replace child1417_ub=child017-2 if chldpres==14

	gen exact05= child05_lb== child05_ub
	gen exact02= child02_lb== child02_ub
	gen exact35= child35_lb== child35_ub
	gen exact613= child613_lb== child613_ub
	gen exact1417= child1417_lb== child1417_ub
	sum exact*

	tab ch02 child02_lb
	tab ch05 child05_lb
	tab ch35 child35_lb
	tab ch613 child613_lb
	tab ch1417 child1417_lb

	gen child02=(child02_lb+child02_ub)/2
	gen child05=(child05_lb+child05_ub)/2
	gen child35=(child35_lb+child35_ub)/2
	gen child613=(child613_lb+child613_ub)/2
	gen child1417=(child1417_lb+child1417_ub)/2

	*data for the simulations
	keep if female==1 | (missing(lwage)==0 & awage==0 & ft==1)
	preserve
	keep female hsg college exp ft lwage awage wgt child02 child35 child613
	save "${path_save}\simulations.dta"
	restore
	
	*data for the application
	keep if female==1
	replace lwage=0 if ft==0
	gen some_college=educomp>=13
	gen associate=educomp>=14
	gen advanced=educomp>=18
	sum educomp
	gen exp_edu=exp*(educomp-r(mean))
	gen exp2_edu=exp2*(educomp-r(mean))
	gen married=marital<4
	gen child02_m=married *child02
	gen child35_m=married *child35
	gen child613_m=married *child613
	replace awage=0 if ft==0
	keep wgt lwage awage ft exp exp2 exp_edu exp2_edu hsg some_college associate college advanced mw So We married child02 child35 child613 child02_m child35_m child613_m
	save "${path_save}\application.dta", replace
