
rm(list=ls())
setwd("/Users/innoshuadmin/Dropbox/RDHeteroTest/RDMonoTest/")
load("./simulationR2/DGP_MonoTest.RData")

n=10000
Z=sort(2*rbeta(n,2,2)-1)
X=ceiling(runif(n)*10)/10
ATE=matrix(NA,nrow=4,ncol=11)

pdf("./simulationR2/DGP_RDMonoTest.pdf",width=9,height=6)
par(mfrow=c(2,3),mai=c(0.55,0.55,0.15,0.05))

for (model in 1:4){ 
	source("./simulationR2/SRD_DGPs.R")
  			  
    y.l =crd.m[1] + crd.m[2]*X + crd.m[3]*Z + crd.m[4]*Z*X + crd.m[5]*Z^2 + crd.m[6]*X^2
    y.r =crd.p[1] + crd.p[2]*X + crd.p[3]*Z + crd.p[4]*Z*X + crd.p[5]*Z^2 + crd.p[6]*X^2 

for (xind in 1:11){
	x=(xind-1)/10
	ATE[model,xind]=(crd.p[1] + crd.p[2]*x  + crd.p[6]*x^2 - (crd.m[1] + crd.m[2]*x  + crd.m[6]*x^2))
}
if (model<= 3){
plot(Z[X==0.1&Z<0],y.l[X==0.1&Z<0],xlim=c(-1,1),ylim=c(-2,1),type="l",col=1,main=paste("DGP ",model, sep=""),xlab="Z", ylab="E(Y|X,Z)",cex.main=1)
} else {
plot(Z[X==0.1&Z<0],y.l[X==0.1&Z<0],xlim=c(-1,1),ylim=c(-5,0),type="l",col=1,main=paste("DGP ",model, sep=""),xlab="Z", ylab="E(Y|X,Z)",cex.main=1)	
}
for (xind in c(1,3,5,7,9)){
  lines(Z[X==xind/10&Z<0],y.l[X==xind/10&Z<0],col=(xind+1)/2)
  lines(Z[X==xind/10&Z>0],y.r[X==xind/10&Z>0],col=(xind+1)/2)
  }
legend("topleft",lty=c(1,1),col=c(1,2,3,4,5),legend=c("X=0.1","X=0.3","X=0.5","X=0.7","X=0.9"))
}

xgrid=seq(0,1,0.1)
plot(xgrid,ATE[1,],type="l",ylim=c(-1.5,1), main="DGPs 1-4",xlab="X", ylab="CATE(X)")
for (model in 2:4){
	lines(xgrid,ATE[model,],lty=model)
}
	legend("topleft",lty=c(1,2,3,4),legend=c("DGP 1","DGP 2","DGP 3", "DGP 4"))

plot(NULL,main="Cube Illustration",xlim=c(0,1),ylim=c(0,1.2),xlab="X", yaxt="n",ylab="q",cex.main=1)
#q=2
lines(seq(1/2,1,by=0.01), rep(0.9,51),lty=1)
lines(seq(0,1/2,by=0.01), rep(0.9,51),lty=2)
#q=3
lines(seq(1/3,2/3,by=0.01), rep(0.8,34),lty=1)
lines(seq(0,1/3,by=0.01), rep(0.8,34),lty=2)
lines(seq(2/3,1,by=0.01), rep(0.7,34),lty=1)
lines(seq(0,1/3,by=0.01), rep(0.7,34),lty=2)
lines(seq(2/3,1,by=0.01), rep(0.6,34),lty=1)
lines(seq(1/3,2/3,by=0.01), rep(0.6,34),lty=2)
#q=4
lines(seq(1/4,2/4,by=0.01), rep(0.5,26),lty=1)
lines(seq(0,1/4,by=0.01), rep(0.5,26),lty=2)
lines(seq(2/4,3/4,by=0.01), rep(0.4,26),lty=1)
lines(seq(0,1/4,by=0.01), rep(0.4,26),lty=2)
lines(seq(3/4,1,by=0.01), rep(0.3,26),lty=1)
lines(seq(0,1/4,by=0.01), rep(0.3,26),lty=2)
lines(seq(2/4,3/4,by=0.01), rep(0.2,26),lty=1)
lines(seq(1/4,2/4,by=0.01), rep(0.2,26),lty=2)
lines(seq(3/4,1,by=0.01), rep(0.1,26),lty=1)
lines(seq(1/4,2/4,by=0.01), rep(0.1,26),lty=2)
lines(seq(3/4,1,by=0.01), rep(0,26),lty=1)
lines(seq(2/4,3/4,by=0.01), rep(0,26),lty=2)
legend("topleft",lty=c(1,2),legend=c("[x1,x1+1/(q+1)]","[x2,x2+1/(q+1)]"))
yat=0:9/10
ylab<-c("3","3","3","3","3","3","2","2","2","1")
axis(2,at=yat,labels=ylab)
dev.off()