rm(list=ls())
library(foreign)
library(locfit)

setwd("/Users/innoshuadmin/Dropbox/RDHeteroTest/RDMonoTest")
setwd("/home/users/innoshu.AD3/RDMonoTest")
## load in RD test functions
source("./functions/RDMono_Functions_Generic.R")

## load in data
romanian <- read.dta(file="./APP1/romanian_twoschooltown.dta")
romanian<- romanian[c("bcg","bcg_Dmean","bct","bct_Dmean","agus","dzag","zga","meanzag_jk","bct","town","Y","attend","minscore_bytownbyyear_Dmean","maxscore_bytownbyyear_Dmean")]
data<-romanian

pdf("./APP1/romanianMRDplot.pdf",width=7,height=4)
par(mfcol=c(1,2))

## first stage
set.seed(123)
y=data$attend
z=data$dzag

Zeval <- seq(-0.6, 0.6, length=61)  
xlab="Standardized Transition Score"
ylab1="First Stage"  
ylab2="# of Individuals"
main=" "
labels<-data.frame(xlab,ylab1,ylab2,main)
results<-MRD_sharp(y,z,bw=0.5,Zeval)
MRDplot(Zeval,y,z,results,labels)

## treatment effect
## leave school after first evaluation 
set.seed(123)
y=data$bct_Dmean
z=data$dzag
Zeval <- seq(-0.6, 0.6, length=61)  
xlab="Standardized Transition Score"
ylab1="Reduced Form"  
ylab2="# of Individuals"
main=" "
labels<-data.frame(xlab,ylab1,ylab2,main)
results<-MRD_sharp(y,z,bw=0.5,Zeval)
MRDplot(Zeval,y,z,results,labels)
dev.off()