* log likelihood function for column 4 of Table 5
program lnL_rL_tobit

	* The parameter groups (A, B, C, D, E) below correspond to the panel names in Table 5. 
	args lnf A B alpha C gamma D E rho12 rho13 rho23
	
	tempvar frL 
	tempvar S V
	tempvar pr0 pr1 gs
	
	local sold_dummy "$ML_y1"
	local lnrS "$ML_y2"
	local lnrL "$ML_y3" 

	qui gen double `frL' = normalden((`lnrL'-`A')/`D')/`D'	

	qui gen double `gs' = normalden((`lnrS'-(`B'+`alpha'*`A'+`rho12'*`E'*(`lnrL'-`A')/`D'))/(`E'*sqrt(1-`rho12'^2)))/(sqrt(1-`rho12'^2)*`E') if `sold_dummy' == 1

	qui gen double `S' = (`E'*(`rho13'-`rho12'*`rho23')*(`lnrL'-`A')+`D'*(`rho23'-`rho12'*`rho13')*(`lnrS'-`B'-`alpha'*`A'))/(`D'*`E'*(1-`rho12'^2)) if `sold_dummy' == 1

	qui gen double `V' = (1-`rho12'^2-`rho13'^2-`rho23'^3+2*`rho12'*`rho13'*`rho23')/(1-`rho12'^2) if `sold_dummy' == 1

	qui	gen double `pr0' = 1-normal((`C'+`gamma'*`A'+`rho13'*(`lnrL'-`A')/`D')/sqrt(1-`rho13'^2)) if `sold_dummy' == 0 

	qui gen double `pr1' = (normal((`C'+`gamma'*`A'+`S')/sqrt(`V')))*`gs' if `sold_dummy' == 1
	
	qui replace `lnf' =  ln(`frL')+ln(`pr0') if `sold_dummy' == 0
	qui replace `lnf' =  ln(`frL')+ln(`pr1') if `sold_dummy' == 1
	
end


