program lnL_rL

	* The parameter groups (A, B, C, D, E) below correspond to the panel names in Table 5. 
	args lnf A B C D E 
	
	tempvar frL 
	tempvar pr0 pr1 gs
	
	local sold_dummy "$ML_y1"
	local lnrS "$ML_y2"
	local lnrL "$ML_y3" 
	
	qui gen double `frL' = normalden((`lnrL'-`A')/`D')/`D'	

	qui gen double `gs' = normalden((`lnrS'-(`B'))/(`E'))/(`E') if `sold_dummy' == 1

	qui	gen double `pr0' = 1-normal(`C') if `sold_dummy' == 0 

	qui gen double `pr1' = (normal(`C'))*`gs' if `sold_dummy' == 1
	
	qui replace `lnf' =  ln(`frL')+ln(`pr0') if `sold_dummy' == 0
	qui replace `lnf' =  ln(`frL')+ln(`pr1') if `sold_dummy' == 1
	
end

