

clear 
clc

addpath('...\functions');


reps = 2000;

time = [20,50,100,200,400];
crosssec = [20,50,100,200,400];

preparematrices_simplesim;

nf = 1;
nx = 2;
exp = 2;   % running experiment 1 or 2, exp = 1 heterogeneous beta, exp = 2 homogeneous beta
% expA  = 1; % running experiment A or B, if 1 we run full rank condition, if 2, we run rank deficient version
% opt = 2;   % to include ybar, xbar, wbar, if 2 only includes ybar and xbar

optl = 1;  % KEEP as 1. If 1, factors are present. If anything else than factors, no factor in the equations.

gam = [1;0];
gam_n = [0.95;0.05];

tic
for ii = 1:size(time,2)

    for kk = 1:size(crosssec,2)
        
        t = time(ii);
        n = crosssec(kk);

        parfor rep = 1:reps
            rep 
            
            check1 = 0;
            while check1 < 1
                
            %simulate the data 
            
            f = randn(t,nf);
            if optl==1
                lambda1 = 1+randn(nf,n);
            else
                lambda1 = zeros(nf,n);
            end;
            
            x = f*lambda1+randn(t,n);
            
            if optl==1
                lambda2 = 1+randn(nf,n);
            else
                lambda2 = zeros(nf,n);
            end
            
            u = f*lambda2+randn(t,n);
            
            gg = g(gam,x);
            
            y = zeros(t,n);
            bt = zeros(n,nx,rep);
            
            for j = 1:n
                if exp == 1
                    bt(j,:,rep) = ones(2,1) + randn(2,1).*sqrt(0.04);
                elseif exp == 2
                    bt(j,:,rep) = ones(2,1);
                end
                y(:,j)=[x(:,j) gg(:,j)]*(bt(j,:,rep))' + u(:,j);
            end

            breal(:,rep) = mean(bt(:,:,rep),1)';

            % potential exogenous variables
            z = []; 
            options  =  optimset('LargeScale','off','Display','off');

                % correct with ybar, xbar, wbar
                [gamma,f]  =  fminunc(@(gamma) ngls(gamma,y,x,z,3), gam, options);
                b = gamma;
                [s, e, betap, betamg, betapv, betamgv , testbp, testbmg, testbp_n, testbmg_n] = ngls(gamma,y,x,z,3);

                % correct with ybar, xbar
                [gamma_yx,f_yx]  =  fminunc(@(gamma_yx) ngls(gamma_yx,y,x,z,2), gam, options);
                b_yx = gamma_yx;
                [s_yx, e_yx, betap_yx, betamg_yx, betapv_yx, betamgv_yx, testbp_yx, testbmg_yx, testbp_n_yx, testbmg_n_yx]= ngls(gamma_yx,y,x,z,2);

                 % to eliminate the explosive or extremely small gamma draws
                if  sum(abs(b)) < 10 && sum(abs(b_yx)) < 10 && abs(b(1))>0.1 && abs(b_yx(1))>0.1 && sum(abs(betap)) < 20 && sum(abs(betamg)) < 20
%                     && sum(abs(b)) > 0.7 && sum(abs(b_yx)) > 0.7 
                    check1 = check1+1;
                else
                    check1 = 0;
                end
            end
            
                % run the ngls with the real gamma
                % correct with ybar, xbar, wbar
                [s_R, e_R, betap_R, betamg_R, betapv_R, betamgv_R, testbp_R, testbmg_R, testbp_n_R, testbmg_n_R] = ngls(gam,y,x,z,3);

                % run the ngls with the true gamma
                % correct with ybar, xbar
                [s_yx_R, e_yx_R, betap_yx_R, betamg_yx_R, betapv_yx_R, betamgv_yx_R, testbp_yx_R, testbmg_yx_R, testbp_n_yx_R, testbmg_n_yx_R]= ngls(gam,y,x,z,2);

          

            % correct with ybar, xbar, wbar         
            [st, v, st2, v2] = varp(y,x,z,gamma,3);
                      
            allbp(:,rep) = [b;betap];     % pooled betas
            allbmg(:,rep) = betamg';        % mean group betas
            
            allbpv(:,rep) = betapv;         % pooled beta variances
            allbmgv(:,rep) = betamgv';      % mean group beta variances
                        
            allst(:,rep) = st; 
            
            alltp(:,rep) = testbp;            % pooled beta t stats
            alltmg(:,rep) = testbmg';            % mean group beta tstats
            alltg(:,rep) = ((sqrt(cols(y)*rows(y))*(b-gam))./st2);    % to look into the power of the t-stat
            
            alltp_n(:,rep) = testbp_n;            % pooled beta t stats under the null neta = 0.95
            alltmg_n(:,rep) = testbmg_n';            % mean group beta tstats under the null neta = 0.95
            alltg_n(:,rep) = ((sqrt(cols(y)*rows(y))*(b-gam_n))./st2);    % to look into the power of the t-stat on gamman under the nulls, gamma=0.95 and c=0.05

            % true gamma tests
            allbp_R(:,rep) = [gam;betap_R];     % pooled betas
            allbmg_R(:,rep) = betamg_R';        % mean group betas
            
            allbpv_R(:,rep) = betapv_R;         % pooled beta variances
            allbmgv_R(:,rep) = betamgv_R';      % mean group beta variances
            
            alltp_R(:,rep) = testbp_R;
            alltmg_R(:,rep) = testbmg_R;
            
            alltp_n_R(:,rep) = testbp_n_R;
            alltmg_n_R(:,rep) = testbmg_n_R;

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            
            % correct with ybar, xbar      
            [st_yx, v_yx, st2_yx, v2_yx] = varp(y,x,z,gamma_yx,2);
           
            allbp_yx(:,rep) = [b_yx;betap_yx];        % pooled betas
            allbmg_yx(:,rep) = betamg_yx';              % mean group betas
            
            allbpv_yx(:,rep) = betapv_yx;               % pooled beta variances
            allbmgv_yx(:,rep) = betamgv_yx';            % mean group beta variances

            allst_yx(:,rep) = st_yx;
     
            alltp_yx(:,rep) = testbp_yx;               % pooled beta t stats
            alltmg_yx(:,rep) = testbmg_yx';              % mean group beta tstats
            alltg_yx(:,rep) = ((sqrt(cols(y)*rows(y))*(b_yx-gam))./st2_yx);    %
            
            alltp_n_yx(:,rep) = testbp_n_yx;            % pooled beta t stats under the null neta = 0.95
            alltmg_n_yx(:,rep) = testbmg_n_yx';            % mean group beta tstats under the null neta = 0.95
            alltg_n_yx(:,rep) = ((sqrt(cols(y)*rows(y))*(b_yx-gam_n))./st2_yx);    % to look into the power of the t-stat on gamman under the nulls, gamma=0.95 and c=0.05

           
            % true gamma tests
            allbp_yx_R(:,rep) = [gam;betap_yx_R];     % pooled betas
            allbmg_yx_R(:,rep) = betamg_yx_R';        % mean group betas
            
            allbpv_yx_R(:,rep) = betapv_yx_R;         % pooled beta variances
            allbmgv_yx_R(:,rep) = betamgv_yx_R';      % mean group beta variances
            
            alltp_yx_R(:,rep) = testbp_yx_R;
            alltmg_yx_R(:,rep) = testbmg_yx_R;
            
            alltp_n_yx_R(:,rep) = testbp_n_yx_R;
            alltmg_n_yx_R(:,rep) = testbmg_n_yx_R;
            
        end

        % correct with ybar, xbar, wbar
        % average absolute bias of pooled and mean group coefficients
        biasabsp(kk,ii,:) = mean(abs(allbp - [repmat(gam,1,cols(breal));breal]),2);
        biasabsmg(kk,ii,:) = mean(abs(allbmg - breal),2);
        
        % average bias of pooled and mean group coefficients
        biasp(kk,ii,:) = mean((allbp - [repmat(gam,1,cols(breal));breal]),2);
        biasmg(kk,ii,:) = mean((allbmg - breal),2);
        
        % RMSE
        rmsep(kk,ii,:) = sqrt(mean((allbp - [repmat(gam,1,cols(breal));breal]).^2,2));
        rmsemg(kk,ii,:) = sqrt(mean((allbmg - breal).^2,2));
        
        % saving the coefficients of the simulations
        bp{kk,ii} = allbp;
        bmg{kk,ii} = allbmg;
        btemp{kk,ii} = breal;
        
        % variances of pooled and mean group coeffs
        varpl{kk,ii} = allbpv;
        varmg{kk,ii}= allbmgv;
        
        % average absolute bias of true gamma pooled and mean group coefficients
        biasabsp_R(kk,ii,:) = mean(abs(allbp_R - [repmat(gam,1,cols(breal));breal]),2);
        biasabsmg_R(kk,ii,:) = mean(abs(allbmg_R - breal),2);
        
        % average bias of true gamma pooled and mean group coefficients
        biasp_R(kk,ii,:) = mean((allbp_R - [repmat(gam,1,cols(breal));breal]),2);
        biasmg_R(kk,ii,:) = mean((allbmg_R - breal),2);
        
        % true gamma coefficient RMSE
        rmsep_R(kk,ii,:) = sqrt(mean((allbp_R - [repmat(gam,1,cols(breal));breal]).^2,2));
        rmsemg_R(kk,ii,:) = sqrt(mean((allbmg_R - breal).^2,2));
        
        % saving the coefficients of the simulations from true gamma 
        bp_R{kk,ii} = allbp_R;
        bmg_R{kk,ii} = allbmg_R;
        
        % variances of true gamma pooled and mean group coeffs
        varpl_R{kk,ii} = allbpv_R;
        varmg_R{kk,ii}= allbmgv_R;
        
        % Std deviation of gamma
        stall{kk,ii} = allst;
        
        % size of the t-test on pooled coeffs
        sizep1(kk,ii) = mean(abs(alltp(1,:))>1.96);
        sizep2(kk,ii) = mean(abs(alltp(2,:))>1.96);
        
        % size of the t-test on mean group coeffs
        sizemg1(kk,ii) = mean(abs(alltmg(1,:))>1.96); 
        sizemg2(kk,ii) = mean(abs(alltmg(2,:))>1.96); 
        
        % size of the t-test for true gamma pooled coeffs
        sizep1_R(kk,ii) = mean(abs(alltp_R(1,:))>1.96);
        sizep2_R(kk,ii) = mean(abs(alltp_R(2,:))>1.96);
        
        % size of the t-test for true gamma mean group coeffs
        sizemg1_R(kk,ii) = mean(abs(alltmg_R(1,:))>1.96); 
        sizemg2_R(kk,ii) = mean(abs(alltmg_R(2,:))>1.96); 
        
        % size of the t-test on g, both for gamma and c
        sizeg1(kk,ii) = mean(abs(alltg(1,:))>1.96); 
        sizeg2(kk,ii) = mean(abs(alltg(2,:))>1.96);  
        
        % power of the t-test on pooled coeffs for the null beta = 0.95;
        powerp1(kk,ii) = mean((abs(alltp_n(1,:))>1.96));
        powerp2(kk,ii) = mean((abs(alltp_n(2,:))>1.96));
        
        % power of the t-test on mean group coeffs
        powermg1(kk,ii) = mean(abs(alltmg_n(1,:))>1.96);
        powermg2(kk,ii) = mean(abs(alltmg_n(2,:))>1.96);
        
        % power of the t-test on gamma and c
        powerg1(kk,ii) = mean(abs(alltg_n(1,:))>1.96);
        powerg2(kk,ii) = mean(abs(alltg_n(2,:))>1.96);
        
        % power of the t-test of true gamma pooled coeffs for the null beta = 0.95;
        powerp1_R(kk,ii) = mean((abs(alltp_n_R(1,:))>1.96));
        powerp2_R(kk,ii) = mean((abs(alltp_n_R(2,:))>1.96));
        
        % power of the t-test true gamma mean group coeffs
        powermg1_R(kk,ii) = mean(abs(alltmg_n_R(1,:))>1.96);
        powermg2_R(kk,ii) = mean(abs(alltmg_n_R(2,:))>1.96);
       
        % t-stats
        tstatp{kk,ii} = alltp;
        tstatmg{kk,ii} = alltmg;
        tstatg{kk,ii}  = alltg;
        tstatp_n{kk,ii} = alltp_n;
        tstatmg_n{kk,ii} = alltmg_n;   
        tstatg_n{kk,ii}  = alltg_n;

        tstatp_R{kk,ii} = alltp_R;
        tstatmg_R{kk,ii} = alltmg_R;
        tstatp_n_R{kk,ii} = alltp_n_R;
        tstatmg_n_R{kk,ii} = alltmg_n_R;   
        
        % mean variances and mean size, for beta1, beta2 and gammas, and
        % power 
        mvp1(kk,ii) = mean(varpl{kk,ii}(1,:));
        mvp2(kk,ii) = mean(varpl{kk,ii}(2,:));

        mvmg1(kk,ii) = mean(varmg{kk,ii}(1,:));
        mvmg2(kk,ii) = mean(varmg{kk,ii}(2,:));
        
        mvp1_R(kk,ii) = mean(varpl_R{kk,ii}(1,:));
        mvp2_R(kk,ii) = mean(varpl_R{kk,ii}(2,:));

        mvmg1_R(kk,ii) = mean(varmg_R{kk,ii}(1,:));
        mvmg2_R(kk,ii) = mean(varmg_R{kk,ii}(2,:));

%         mtstatp1(kk,ii) = mean(abs(tstatp{kk,ii}(1,:)));
%         mtstatp2(kk,ii) = mean(abs(tstatp{kk,ii}(2,:)));
% 
%         mtstatmg1(kk,ii) = mean(abs(tstatmg{kk,ii}(1,:)));
%         mtstatmg2(kk,ii) = mean(abs(tstatmg{kk,ii}(2,:)));
%         
%         mtstatp1_n(kk,ii) = mean(abs(tstatp_n{kk,ii}(1,:)));
%         mtstatp2_n(kk,ii) = mean(abs(tstatp_n{kk,ii}(2,:)));
%         
%         mtstatmg1_n(kk,ii) = mean(abs(tstatmg_n{kk,ii}(1,:)));
%         mtstatmg2_n(kk,ii) = mean(abs(tstatmg_n{kk,ii}(2,:)));
%         
%         mtstatg1(kk,ii) = mean(abs(tstatg{kk,ii}(1,:)));
%         mtstatg2(kk,ii) = mean(abs(tstatg{kk,ii}(2,:)));
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % correct with ybar, xbar 
        % average absolute bias of pooled and mean group coefficients
        biasabsp_yx(kk,ii,:) = mean(abs(allbp_yx - [repmat(gam,1,cols(breal));breal]),2);
        biasabsmg_yx(kk,ii,:) = mean(abs(allbmg_yx - breal),2);
        
        % average bias of pooled and mean group coefficients
        biasp_yx(kk,ii,:) = mean((allbp_yx - [repmat(gam,1,cols(breal));breal]),2);
        biasmg_yx(kk,ii,:) = mean((allbmg_yx - breal),2);
        
        % RMSE
        rmsep_yx(kk,ii,:) = sqrt(mean((allbp_yx - [repmat(gam,1,cols(breal));breal]).^2,2));
        rmsemg_yx(kk,ii,:) = sqrt(mean((allbmg_yx - breal).^2,2));
        
        % saving the coefficients of the simulations
        bp_yx{kk,ii} = allbp_yx;
        bmg_yx{kk,ii} = allbmg_yx;
        
        % variances of pooled and mean group coeffs
        varpl_yx{kk,ii} = allbpv_yx;
        varmg_yx{kk,ii}= allbmgv_yx;
        
        % average absolute bias of true gamma pooled and mean group coefficients
        biasabsp_yx_R(kk,ii,:) = mean(abs(allbp_yx_R - [repmat(gam,1,cols(breal));breal]),2);
        biasabsmg_yx_R(kk,ii,:) = mean(abs(allbmg_yx_R - breal),2);
        
        % average bias of true gamma pooled and mean group coefficients
        biasp_yx_R(kk,ii,:) = mean((allbp_yx_R - [repmat(gam,1,cols(breal));breal]),2);
        biasmg_yx_R(kk,ii,:) = mean((allbmg_yx_R - breal),2);
        
        % true gamma coefficient RMSE
        rmsep_yx_R(kk,ii,:) = sqrt(mean((allbp_yx_R - [repmat(gam,1,cols(breal));breal]).^2,2));
        rmsemg_yx_R(kk,ii,:) = sqrt(mean((allbmg_yx_R - breal).^2,2));
        
        % saving the coefficients of the simulations from true gamma 
        bp_yx_R{kk,ii} = allbp_yx_R;
        bmg_yx_R{kk,ii} = allbmg_yx_R;
        
        % variances of true gamma pooled and mean group coeffs
        varpl_yx_R{kk,ii} = allbpv_yx_R;
        varmg_yx_R{kk,ii}= allbmgv_yx_R;
                
        % Std deviation of gamma
        stall_yx{kk,ii} = allst_yx;
        
        % size of the t-test on pooled coeffs
        sizep1_yx(kk,ii) = mean(abs(alltp_yx(1,:))>1.96);
        sizep2_yx(kk,ii) = mean(abs(alltp_yx(2,:))>1.96);
        
        % size of the t-test on mean group coeffs
        sizemg1_yx(kk,ii) = mean(abs(alltmg_yx(1,:))>1.96);
        sizemg2_yx(kk,ii) = mean(abs(alltmg_yx(2,:))>1.96);
        
        % size of the t-test for real gamma pooled coeffs
        sizep1_yx_R(kk,ii) = mean(abs(alltp_yx_R(1,:))>1.96);
        sizep2_yx_R(kk,ii) = mean(abs(alltp_yx_R(2,:))>1.96);
        
        % size of the t-test for real gamma mean group coeffs
        sizemg1_yx_R(kk,ii) = mean(abs(alltmg_yx_R(1,:))>1.96); 
        sizemg2_yx_R(kk,ii) = mean(abs(alltmg_yx_R(2,:))>1.96); 
        
        % size of the t-test on g, both for gamma and c
        sizeg1_yx(kk,ii) = mean(abs(alltg_yx(1,:))>1.96);
        sizeg2_yx(kk,ii) = mean(abs(alltg_yx(2,:))>1.96);
        
        % power of the t-test on pooled coeffs for the null beta = 0.95;
        powerp1_yx(kk,ii) = mean(abs(alltp_n_yx(1,:))>1.96);
        powerp2_yx(kk,ii) = mean(abs(alltp_n_yx(2,:))>1.96);
        
        % power of the t-test on mean group coeffs
        powermg1_yx(kk,ii) = mean(abs(alltmg_n_yx(1,:))>1.96);
        powermg2_yx(kk,ii) = mean(abs(alltmg_n_yx(2,:))>1.96);
        
        % power of the t-test on gamma and c
        powerg1_yx(kk,ii) = mean(abs(alltg_n_yx(1,:))>1.96);
        powerg2_yx(kk,ii) = mean(abs(alltg_n_yx(2,:))>1.96);
        
        % power of the t-test of real gamma pooled coeffs for the null beta = 0.95;
        powerp1_yx_R(kk,ii) = mean((abs(alltp_n_yx_R(1,:))>1.96));
        powerp2_yx_R(kk,ii) = mean((abs(alltp_n_yx_R(2,:))>1.96));
        
        % power of the t-test real gamma mean group coeffs
        powermg1_yx_R(kk,ii) = mean(abs(alltmg_n_yx_R(1,:))>1.96);
        powermg2_yx_R(kk,ii) = mean(abs(alltmg_n_yx_R(2,:))>1.96);
        
        
        % t-stats
        tstatp_yx{kk,ii} = alltp_yx;
        tstatmg_yx{kk,ii} = alltmg_yx;
        tstatg_yx{kk,ii}  = alltg_yx;
        tstatp_n_yx{kk,ii} = alltp_n_yx;
        tstatmg_n_yx{kk,ii} = alltmg_n_yx;  
        tstatg_n_yx{kk,ii}  = alltg_n_yx;
        
        tstatp_yx_R{kk,ii} = alltp_yx_R;
        tstatmg_yx_R{kk,ii} = alltmg_yx_R;
        tstatp_n_yx_R{kk,ii} = alltp_n_yx_R;
        tstatmg_n_yx_R{kk,ii} = alltmg_n_yx_R;  
        
        % mean variances and mean size, for beta1, beta2 and gammas
        mvp1_yx(kk,ii) = mean(varpl_yx{kk,ii}(1,:));
        mvp2_yx(kk,ii) = mean(varpl_yx{kk,ii}(2,:));
        
        mvmg1_yx(kk,ii) = mean(varmg_yx{kk,ii}(1,:));
        mvmg2_yx(kk,ii) = mean(varmg_yx{kk,ii}(2,:));
        
        mvp1_yx_R(kk,ii) = mean(varpl_yx_R{kk,ii}(1,:));
        mvp2_yx_R(kk,ii) = mean(varpl_yx_R{kk,ii}(2,:));
        
        mvmg1_yx_R(kk,ii) = mean(varmg_yx_R{kk,ii}(1,:));
        mvmg2_yx_R(kk,ii) = mean(varmg_yx_R{kk,ii}(2,:));
        
%         mtstatp1_yx(kk,ii) = mean(abs(tstatp_yx{kk,ii}(1,:)));
%         mtstatp2_yx(kk,ii) = mean(abs(tstatp_yx{kk,ii}(2,:)));
%         
%         mtstatmg1_yx(kk,ii) = mean(abs(tstatmg_yx{kk,ii}(1,:)));
%         mtstatmg2_yx(kk,ii) = mean(abs(tstatmg_yx{kk,ii}(2,:)));
%         
%         mtstatp1_n_yx(kk,ii) = mean(abs(tstatp_n_yx{kk,ii}(1,:)));
%         mtstatp2_n_yx(kk,ii) = mean(abs(tstatp_n_yx{kk,ii}(2,:)));
%         
%         mtstatmg1_n_yx(kk,ii) = mean(abs(tstatmg_n_yx{kk,ii}(1,:)));
%         mtstatmg2_n_yx(kk,ii) = mean(abs(tstatmg_n_yx{kk,ii}(2,:)));
%         
%         mtstatg1_yx(kk,ii) = mean(abs(tstatg_yx{kk,ii}(1,:)));
%         mtstatg2_yx(kk,ii) = mean(abs(tstatg_yx{kk,ii}(2,:)));
        
        
    end
end
toc


% save simplesim_Homog_f1