
function [s, e, beta, betamg, betamgv, betapv,  testb, testbp] = ngls_simplesim(gam,y,x,z,opt)

tbeta = 1;  % change for the t stat

% opt=_opt;
gg = g(gam,x);

ng = cols(gg)/cols(y);


if opt==1
  d = ones(rows(x),1);
elseif opt==2
  d = [mean(y,2) mean(x,2)];
elseif opt==3
  d = [mean(y,2) mean(x,2) mean(gg,2)];
end

x = [x,z];
nx = cols(x)/cols(y);
allbet = zeros(nx+ng,cols(y));

num = 0;
denom = 0;
for  i = 1:cols(y)
  xx = resid([x(:,[i,i+cols(y)]) gg(:,i)],d);   % [x(:,((i-1)*nx)+1:i*nx) gg(:,((i-1)*ng)+1:i*ng)]
  yy = resid(y(:,i),d);
  xxxx = xx'*xx;
  xxyy = xx'*yy;
  num = num+(xxyy);
  denom = denom+(xxxx);
  allbet(:,i) = pinv(xxxx)*xxyy;
end;

pdenom = pinv(denom);
beta = pdenom*num;   % pesaran equation 65
% _beta = beta1;
betamg = mean(allbet');   % pesaran equation 53

r = 0;

for i = 1:cols(y)
  xx = resid([x(:,[i,i+cols(y)]) gg(:,i)],d);
%   yy = resid(y(:,i),d);
  xxxx=(xx'*xx)/rows(y);
  r = r+(xxxx*(allbet(:,i)-betamg')*(allbet(:,i)-betamg')'*xxxx);  % pesaran equation 67
end


r = (1/cols(y))*r;  
betamgv = var(allbet');                                     % mean group betamg variances, pesaran eq 58 
betapv = diag((cols(y)^2)*(rows(y)^2)*pdenom*r*pdenom);   % pooled beta variances, pesaran eq 69
testb = (sqrt(cols(y))*(betamg-tbeta))./sqrt(betamgv);   % mean group betamg tstats 
testbp = (sqrt(cols(y))*(beta-tbeta))./sqrt(betapv);   % pooled beta tstats

e = [];
s = 0;
for i = 1:cols(y)
  xx = resid([x(:,[i,i+cols(y)]) gg(:,i)],d);
  yy = resid(y(:,i),d);
  ee = yy-xx*beta;
  e = [e;ee];  
  s = s+e'*e;
end

end


