/*
** Procedure ClusOut:
**
** Purpose:
** Generates output for clustering algorithm.
**
** Format:
** ClusOut( C , ClusName );
**
** Input:
** C        Kx1 vector, containing number of cluster in which series are
**              included (returned from CLUSTER).
** ClusName Kx1 character vector, containing names of series.
**
** Output:
** None, the procedure prints output. If the output is to be captured in an
** ASCII then open an output-file before calling this procedure.
*/
Proc(0) = ClusOut( C , ClusName );

Local K , NoSer , NoClust , i , Omat ;

K = Rows(C);
NoClust = MaxC( C );
NoSer = SeqA(1,1,NoClust)~SumC( C.==(SeqA(1,1,NoClust)') );
NoSer = Rev(SortC(NoSer,2));


"OUTPUT CLUSTER ALGORITHM:";
" ";
Format /ld 1,0;
"# Series     : " K ;
"# Clusters   : " NoClust ;
" ";
" ";
i = 0;
Do While ( i < NoClust );
    i = i+1;

    Format /ld 1,0;
    "CLUSTER " i ;
    "Number of series in cluster : " NoSer[i,2];
    "Series in cluster: ";
    Omat = DelIf( ClusName , (C./=NoSer[i,1]) );
    Format /ld 8,0;
    $Omat';
    " ";
    " ";
EnDo;

"END OF OUTPUT" ;
" ";
EndP;
