clear all 
insheet using "D:\your_local_folder\housing_data_long.csv", comma clear

tsset trend

arch california, ar(1) arch(1) garch(1)
predict res, res
predict v, v
gen california_res = res/sqrt(v)
drop res v

arch nevada, ar(1) arch(1) garch(1)
predict res, res
predict v, v
gen nevada_res = res/sqrt(v)
drop res v




capture program drop tcop0
program define tcop0
  version 10.0
  args lnf xb11 xb12 xb21 xb22 lntheta1 lntheta2 lnsigma11 lnsigma12 lnsigma21 lnsigma22 logitprob
  tempvar lnc1 lnc2 theta1 theta2 sigma11 sigma12 sigma21 sigma22 f11 f12 F11 F12 f21 f22 F21 F22 u1 u2 lnC prob

   quietly gen double `prob' = invlogit(`logitprob')
   quietly gen double `sigma11' = exp(`lnsigma11')
   quietly gen double `sigma12' = exp(`lnsigma12')
   quietly gen double `theta1' = exp(`lntheta1')
   quietly gen double `sigma21' = exp(`lnsigma21')
   quietly gen double `sigma22' = exp(`lnsigma22')
   quietly gen double `theta2' = exp(`lntheta2') + 1
   quietly gen double `f11' = normalden($ML_y1,`xb11',`sigma11')
   quietly gen double `f12' = normalden($ML_y2,`xb12',`sigma12') 
   quietly gen double `F11' = normal( ($ML_y1-`xb11')/`sigma11' )
   quietly gen double `F12' = normal( ($ML_y2-`xb12')/`sigma12' )
   quietly gen double `f21' = normalden($ML_y3,`xb21',`sigma21')
   quietly gen double `f22' = normalden($ML_y4,`xb22',`sigma22') 
   quietly gen double `F21' = normal( ($ML_y3-`xb21')/`sigma21' )
   quietly gen double `F22' = normal( ($ML_y4-`xb22')/`sigma22' )
   quietly  replace `F21' = min(`F21',1-1e-6)  
   quietly  replace `F22' = min(`F22',1-1e-6)
   quietly  replace `F21' = max(`F21',1e-6)  
   quietly  replace `F22' = max(`F22',1e-6)
   quietly gen double `u1' = -ln(`F21')
   quietly gen double `u2' = -ln(`F22')

   quietly gen double `lnc1' = ln(1+`theta1') - (`theta1'+1)*(ln(`F11') + ln(`F12')) - (1/`theta1'+2)*ln((`F11'^(-`theta1') + `F12'^(-`theta1') - 1))
   quietly replace `lnc1' = `lnc1' + ln(`f11') + ln(`f12')
   quietly gen double `lnC' = -((`u1'^`theta2' + `u2'^`theta2')^(1/`theta2'))
   quietly gen double `lnc2' = `lnC' + `u1' + `u2' + (`theta2' - 1) * (ln(`u1') + ln(`u2')) - (2 - 1/`theta2') * ln(`u1'^`theta2' + `u2'^`theta2') + ln(-`lnC' + `theta2' - 1)
   quietly replace `lnc2' = `lnc2' + ln(`f21') + ln(`f22') 
   quietly replace `lnf' = `prob' * exp(`lnc1') + (1-`prob') * exp(`lnc2')
   quietly replace `lnf' = max(`lnf',1e-6)
   quietly replace `lnf' = ln(`lnf')  

end


matrix s = 0,0,0,0,-.25,0,0,.36,0,0,-.9
constraint 1 [eq1]_cons=0
constraint 2 [eq2]_cons=0
constraint 3 [eq3]_cons=0
constraint 4 [eq4]_cons=0
constraint 5 [lnsigma11]_cons= 0
constraint 6 [lnsigma12]_cons= 0
constraint 7 [lnsigma21]_cons= 0
constraint 8 [lnsigma22]_cons= 0

ml model lf tcop0 (california_res = ) (nevada_res = ) (california_res = ) (nevada_res = ) /lntheta1 /lnsigma11 /lnsigma12 /lntheta2 /lnsigma21 /lnsigma22 /logitprob , robust init(s,copy) maximize iter(30) constraint(1-8) search(off)

matrix b = e(b)
matrix V = e(V)

gen prob = invlogit(b[1,11])
gen theta1 = exp(b[1,5])
gen tau1 = exp(b[1,5]) / (exp(b[1,5]) + 2)
gen theta2 = exp(b[1,8]) + 1
gen tau2 = 1 - ( 1/(exp(b[1,8]) + 1) )
gen tail1 = 2 ^ (-1/exp(b[1,5]))
gen tail2 = 2 - 2^( 1/(exp(b[1,8]) + 1) )

sum prob theta1 tau1 theta2 tau2 tail1 tail2

gen condprob=0
gen tail=0

mata:

b = st_matrix("b")
xvars = cols(b)
V = st_matrix("V")
y1 = st_data(.,("california_res"))
y2 = st_data(.,("nevada_res"))
obs = rows(y1)
theta1 = exp(b[1,5])
theta2 = exp(b[1,8]) + 1

taill = J(21,1,0)
tailu = J(20,1,0)
condprobl = J(21,1,0)
condprobu = J(20,1,0)

	for(i=0 ; i<=20 ; i++) {

	U11 = normal( -2.00 + i*.10 )
	U12 = normal( -2.00 + i*.10 )
	U21 = normal( -2.00 + i*.10 )
	U22 = normal( -2.00 + i*.10 )

	probc = ( U11^(-theta1) + U12^(-theta1) - 1)^(-1/theta1)
	u1 = -ln(U21)
	u2 = -ln(U22)
	probg = ( exp( -((u1^theta2 + u2^theta2)^(1/theta2)) ) )
	condprobl[i+1,1] = ( invlogit(b[1,11])*probc + (1-invlogit(b[1,11]))*probg ) / U12 
	taill[i+1,1] = -2.00 + i*.10
	
	}
	
	for(i=1 ; i<=20 ; i++) {

	U11 = normal( 0 + i*.10 )
	U12 = normal( 0 + i*.10 )
	U21 = normal( 0 + i*.10 )
	U22 = normal( 0 + i*.10 )

	probc = ( U11^(-theta1) + U12^(-theta1) - 1)^(-1/theta1)
	u1 = -ln(U21)
	u2 = -ln(U22)
	probg = ( exp( -((u1^theta2 + u2^theta2)^(1/theta2)) ) )
	condprobu[i,1] = (1 - U12 - U12 + ( invlogit(b[1,11])*probc + (1-invlogit(b[1,11]))*probg ) ) / (1-U12)
	tailu[i,1] = 0 + i*.10
	
	}

tail = taill \ tailu
condprob = condprobl \ condprobu

condprob = condprob \ J(obs-41,1,.)
tail = tail \ J(obs-41,1,.)
 st_store(., "condprob", condprob)
 st_store(., "tail", tail)

end

rename condprob mixture
keep mixture tail
save "D:\your_local_folder\mixture_long_CA_NV.dta", replace
qui list
