rm(list=ls())
library(foreign)

datos <- read.csv(file="D:/your_local_folder/all-Transactions-prct-diff.csv",header=TRUE)

estados <- ts(cbind(datos$prct_diff_ca,datos$prct_diff_fl,
                    datos$prct_diff_nv,datos$prct_diff_az)
              ,start=c(1975,1),end=c(2009,1),frequency=4)

postscript(file="D:/your_local_folder/prct_diff.ps",horizontal=TRUE,paper="letter")

layout(matrix(c(1,1,2,2),2,2,byrow=TRUE))
par(mar=c(4.5,4,0,0))
plot(datos$california_z,datos$prct_diff_ca,col="black",pch=1,cex=1,
xlim=c(-25,25),ylim=c(-4,4),
ylab=expression(paste(Delta,"Data",sep="")),xlab="Percentage Change in HPI",las=1)
abline(h=0,col="gray",lwd=1)
abline(v=0,col="gray",lwd=1)
points(datos$florida_z,datos$prct_diff_fl,col="gray30",pch=2,cex=1)
points(datos$nevada_z,datos$prct_diff_nv,col="gray45",pch=3,cex=1)
points(datos$arizona_z,datos$prct_diff_az,col="gray60",pch=4,cex=1)
legend(-24,3.8,c("California","Florida","Nevada","Arizona"),cex=1,box.lwd=0,pch=c(1,2,3,4),col=c("black","gray30","gray45","gray60"),box.col = "white")

plot(estados,plot.type="single",lty=1,lwd=2,las=1,
     col=c("black","gray30","gray45","gray60"),ylab=expression(paste(Delta,"Data",sep="")),
     xlab="Year")
abline(h=0,col="gray",lwd=1)
legend(1990,-1.5,c("California","Florida","Nevada","Arizona"),box.lwd=0,lty=1,lwd=3,col=c("black","gray30","gray45","gray60"),box.col = "white")

dev.off()
