rm(list=ls())
library(np)
library(boot)
library(fGarch)
load(file="D:/your_local_folder/bw0.Rdata")
num.R <- 499

colas <- function(X,bw.cdf.CA.AZ,bw.pdf.CA.AZ,
                    bw.cdf.CA.NV,bw.pdf.CA.NV,
                    bw.cdf.CA.FL,bw.pdf.CA.FL,
                    bw.cdf.AZ.FL,bw.pdf.AZ.FL,
                    bw.cdf.NV.FL,bw.pdf.NV.FL,
                    bw.cdf.NV.AZ,bw.pdf.NV.AZ,grid.z.seq,bwtype){
    AZ <- ts(X$arizona,start=c(1975,2),end=c(2009,1),frequency=4)
    CA <- ts(X$california,start=c(1975,2),end=c(2009,1),frequency=4)
    FL <- ts(X$florida,start=c(1975,2),end=c(2009,1),frequency=4)
    NV <- ts(X$nevada,start=c(1975,2),end=c(2009,1),frequency=4)

    ar.garch.AZ <- garchFit(formula=~arma(1,0)+garch(1,1),data=AZ,trace=FALSE)
    ar.garch.CA <- garchFit(formula=~arma(1,0)+garch(1,1),data=CA,trace=FALSE)
    ar.garch.FL <- garchFit(formula=~arma(1,0)+garch(1,1),data=FL,trace=FALSE)
    ar.garch.NV <- garchFit(formula=~arma(1,0)+garch(1,1),data=NV,trace=FALSE)

    res.AZ <- ar.garch.AZ@residuals/ar.garch.AZ@sigma.t
    res.CA <- ar.garch.CA@residuals/ar.garch.CA@sigma.t
    res.FL <- ar.garch.FL@residuals/ar.garch.FL@sigma.t
    res.NV <- ar.garch.NV@residuals/ar.garch.NV@sigma.t

    datos.res <- data.frame(res.AZ=res.AZ,res.CA=res.CA,res.FL=res.FL,res.NV=res.NV)

    bw.CA.ucdf <- npudistbw(~res.CA,data=datos.res,bws=bw.cdf.CA.AZ$bw[1],bandwidth.compute=FALSE,bwtype=bwtype)
    u.CA <- fitted(npudist(bws=bw.CA.ucdf,newdata=data.frame(res.CA=grid.z.seq)))
    bw.AZ.ucdf <- npudistbw(~res.AZ,data=datos.res,bws=bw.cdf.CA.AZ$bw[2],bandwidth.compute=FALSE,bwtype=bwtype)
    u.AZ <- fitted(npudist(bws=bw.AZ.ucdf,newdata=data.frame(res.AZ=grid.z.seq)))
    u.CA.AZ <- cbind(u.CA,u.AZ)
    copula.CA.AZ <- npcopula(bws=bw.cdf.CA.AZ,data=datos.res,bws.pdf=bw.pdf.CA.AZ,u=u.CA.AZ)
    C.u.CA.u.AZ <- diag(matrix(copula.CA.AZ$copula,length(grid.z.seq),length(grid.z.seq)))

    bw.CA.ucdf <- npudistbw(~res.CA,data=datos.res,bws=bw.cdf.CA.NV$bw[1],bandwidth.compute=FALSE,bwtype=bwtype)
    u.CA <- fitted(npudist(bws=bw.CA.ucdf,newdata=data.frame(res.CA=grid.z.seq)))
    bw.NV.ucdf <- npudistbw(~res.NV,data=datos.res,bws=bw.cdf.CA.NV$bw[2],bandwidth.compute=FALSE,bwtype=bwtype)
    u.NV <- fitted(npudist(bws=bw.NV.ucdf,newdata=data.frame(res.NV=grid.z.seq)))
    u.CA.NV <- cbind(u.CA,u.NV)
    copula.CA.NV <- npcopula(bws=bw.cdf.CA.NV,data=datos.res,bws.pdf=bw.pdf.CA.NV,u=u.CA.NV)
    C.u.CA.u.NV <- diag(matrix(copula.CA.NV$copula,length(grid.z.seq),length(grid.z.seq)))

    bw.CA.ucdf <- npudistbw(~res.CA,data=datos.res,bws=bw.cdf.CA.FL$bw[1],bandwidth.compute=FALSE,bwtype=bwtype)
    u.CA <- fitted(npudist(bws=bw.CA.ucdf,newdata=data.frame(res.CA=grid.z.seq)))
    bw.FL.ucdf <- npudistbw(~res.FL,data=datos.res,bws=bw.cdf.CA.FL$bw[2],bandwidth.compute=FALSE,bwtype=bwtype)
    u.FL <- fitted(npudist(bws=bw.FL.ucdf,newdata=data.frame(res.FL=grid.z.seq)))
    u.CA.FL <- cbind(u.CA,u.FL)
    copula.CA.FL <- npcopula(bws=bw.cdf.CA.FL,data=datos.res,bws.pdf=bw.pdf.CA.FL,u=u.CA.FL)
    C.u.CA.u.FL <- diag(matrix(copula.CA.FL$copula,length(grid.z.seq),length(grid.z.seq)))

    bw.FL.ucdf <- npudistbw(~res.FL,data=datos.res,bws=bw.cdf.AZ.FL$bw[1],bandwidth.compute=FALSE,bwtype=bwtype)
    u.FL <- fitted(npudist(bws=bw.FL.ucdf,newdata=data.frame(res.FL=grid.z.seq)))
    bw.AZ.ucdf <- npudistbw(~res.AZ,data=datos.res,bws=bw.cdf.AZ.FL$bw[2],bandwidth.compute=FALSE,bwtype=bwtype)
    u.AZ <- fitted(npudist(bws=bw.AZ.ucdf,newdata=data.frame(res.AZ=grid.z.seq)))
    u.AZ.FL <- cbind(u.FL,u.AZ)
    copula.AZ.FL <- npcopula(bws=bw.cdf.AZ.FL,data=datos.res,bws.pdf=bw.pdf.AZ.FL,u=u.AZ.FL)
    C.u.FL.u.AZ <- diag(matrix(copula.AZ.FL$copula,length(grid.z.seq),length(grid.z.seq)))

    bw.FL.ucdf <- npudistbw(~res.FL,data=datos.res,bws=bw.cdf.NV.FL$bw[1],bandwidth.compute=FALSE,bwtype=bwtype)
    u.FL <- fitted(npudist(bws=bw.FL.ucdf,newdata=data.frame(res.FL=grid.z.seq)))
    bw.NV.ucdf <- npudistbw(~res.NV,data=datos.res,bws=bw.cdf.NV.FL$bw[2],bandwidth.compute=FALSE,bwtype=bwtype)
    u.NV <- fitted(npudist(bws=bw.NV.ucdf,newdata=data.frame(res.NV=grid.z.seq)))
    u.NV.FL <- cbind(u.FL,u.NV)
    copula.NV.FL <- npcopula(bws=bw.cdf.NV.FL,data=datos.res,bws.pdf=bw.pdf.NV.FL,u=u.NV.FL)
    C.u.FL.u.NV <- diag(matrix(copula.NV.FL$copula,length(grid.z.seq),length(grid.z.seq)))

    bw.AZ.ucdf <- npudistbw(~res.AZ,data=datos.res,bws=bw.cdf.NV.AZ$bw[1],bandwidth.compute=FALSE,bwtype=bwtype)
    u.AZ <- fitted(npudist(bws=bw.AZ.ucdf,newdata=data.frame(res.AZ=grid.z.seq)))
    bw.NV.ucdf <- npudistbw(~res.NV,data=datos.res,bws=bw.cdf.NV.AZ$bw[2],bandwidth.compute=FALSE,bwtype=bwtype)
    u.NV <- fitted(npudist(bws=bw.NV.ucdf,newdata=data.frame(res.NV=grid.z.seq)))
    u.NV.AZ <- cbind(u.AZ,u.NV)
    copula.NV.AZ <- npcopula(bws=bw.cdf.NV.AZ,data=datos.res,bws.pdf=bw.pdf.NV.AZ,u=u.NV.AZ)
    C.u.AZ.u.NV <- diag(matrix(copula.NV.AZ$copula,length(grid.z.seq),length(grid.z.seq)))

    return(c((C.u.CA.u.AZ/u.AZ)[1:21],((1-u.AZ-u.CA+C.u.CA.u.AZ)/(1-u.AZ))[21:41],
             (C.u.CA.u.NV/u.NV)[1:21],((1-u.NV-u.CA+C.u.CA.u.NV)/(1-u.NV))[21:41],
             (C.u.CA.u.FL/u.FL)[1:21],((1-u.FL-u.CA+C.u.CA.u.FL)/(1-u.FL))[21:41],
             (C.u.FL.u.AZ/u.AZ)[1:21],((1-u.AZ-u.FL+C.u.FL.u.AZ)/(1-u.AZ))[21:41],
             (C.u.FL.u.NV/u.NV)[1:21],((1-u.NV-u.FL+C.u.FL.u.NV)/(1-u.NV))[21:41],
             (C.u.AZ.u.NV/u.NV)[1:21],((1-u.NV-u.AZ+C.u.AZ.u.NV)/(1-u.NV))[21:41]))
}


z.min <- -2; z.max <- 2
grid.z.seq <- seq(z.min, z.max, by=0.1)
ckertype <- "gaussian"
bwtype <- "adaptive_nn"

boot.copula <- tsboot(datos,colas,R=num.R,l=20,sim="fixed",n.sim=140,
                      bw.cdf.CA.AZ=bw.cdf.CA.AZ,bw.pdf.CA.AZ=bw.pdf.CA.AZ,
                      bw.cdf.CA.NV=bw.cdf.CA.NV,bw.pdf.CA.NV=bw.pdf.CA.NV,
                      bw.cdf.CA.FL=bw.cdf.CA.FL,bw.pdf.CA.FL=bw.pdf.CA.FL,
                      bw.cdf.AZ.FL=bw.cdf.AZ.FL,bw.pdf.AZ.FL=bw.pdf.AZ.FL,
                      bw.cdf.NV.FL=bw.cdf.NV.FL,bw.pdf.NV.FL=bw.pdf.NV.FL,
                      bw.cdf.NV.AZ=bw.cdf.NV.AZ,bw.pdf.NV.AZ=bw.pdf.NV.AZ,grid.z.seq=grid.z.seq,bwtype=bwtype)
save(list=ls(),file="D:/your_local_folder/boot0.Rdata")
