rm(list=ls())

library(np)
options(np.messages=FALSE)
library(crs)
options(crs.messages=FALSE)


ns <- 20
nn <- seq(from=500,to=10000,by=500)
sigma <- c(1,0.5)

G <- list(g1=expression(x*cos(pi*x)),
          g2=expression(x*cos(z*pi*x))
          )

rase <- array(0,c(20,2,length(nn),length(sigma)))
tiempo <- array(0,c(20,2,length(nn),length(sigma)))

ptm <- proc.time()

for (js in 1:ns){
    set.seed(42+js)
    for (ks in 1:length(sigma)){
        xx <- runif(nn[length(nn)],min=-2,max=2)
        yy <- eval(G[[1]],list(x=xx)) + sigma[ks]*rnorm(nn[length(nn)])
        for(jn in 1:length(nn)){
            x <- xx[1:nn[jn]]
            g <- eval(G[[1]],list(x=x))
            y <- yy[1:nn[jn]]
            #---- Time ----#
            tiempo[js,1,jn,ks] <- system.time(model.lc <- npreg(y~x,regtype="lc",ckertype="gaussian",nmulti=1))[1]
            tiempo[js,2,jn,ks] <- system.time(model.crs <- crs(y~x,basis="tensor",nmulti=1,complexity="knots",degree=3))[1]
            #----- Fit ----#
            rase[js,1,jn,ks] <- sqrt(mean((g-fitted(model.lc))^2))
            rase[js,2,jn,ks] <- sqrt(mean((g-fitted(model.crs))^2))
            print(c(js,ks,jn))
            }
        }
    }
save(rase,tiempo,file="simul1.Rdata")
print(proc.time() - ptm)
