rm(list=ls())

library(np)

ns <- 1000
n <- c(500,1000,1500,2000,2500,3000)
sim <- array(NA,c(ns,3,length(n)))

options(np.messages=FALSE)


ptm <- proc.time()
for(js in 1:ns){
    set.seed(41+js)
        for(jn in 1:length(n)){
            mydat <- data.frame(x=rnorm(n[jn]))
            sim[js,,jn] <- system.time(bw <- npudensbw(~x,
                                                       bwmethod="cv.ls",ckertype="gaussian",
                                                       dat=mydat))[1:3]
        }
}
print(proc.time() - ptm)

save(sim,file="sim_win_serial.Rdata")
