rm(list=ls())

library(npRmpi)
mpi.spawn.Rslaves(nslaves=2)

ns <- 1000
n <- c(500,1000,1500,2000,2500,3000)
sim <- array(NA,c(ns,3,length(n)))

mpi.bcast.cmd(np.mpi.initialize(),caller.execute=TRUE)
mpi.bcast.cmd(options(np.messages=FALSE),caller.execute=TRUE)


ptm <- proc.time()
for(js in 1:ns){
    seed <- 41+js
    mpi.bcast.cmd(set.seed(seed),caller.execute=TRUE)
        for(jn in 1:length(n)){
            mydat <- data.frame(x=rnorm(n[jn]))
            mpi.bcast.Robj2slave(mydat)
            sim[js,,jn] <- system.time(mpi.bcast.cmd(bw <- npudensbw(~x,
                                                                     bwmethod="cv.ls",ckertype="gaussian",
                                                                     dat=mydat),
                                                     caller.execute=TRUE))[1:3]
        }
}
print(proc.time() - ptm)

save(sim,file="sim_ubuntu_2.Rdata")

mpi.bcast.cmd(mpi.quit(),
              caller.execute=TRUE)
