
	
clear
set more off

local hor1 = 12
local hor2 = 24


	import excel data.xls, sheet("Sheet1") firstrow clear
	mvdecode _all, mv(-99)
	gen US=SP500_ret-Rfree
	local country_list = "Austria Austrlia Belgium Canada Denmark Finland France HongKong Ireland Italy Nethrlnd 	NewZland Norway Singapor Spain Sweden UK"

tsset t


outreg, clear

foreach country in `country_list' {
	
	capture drop ret_country
	gen ret_country = .

	capture drop ret_country_`hor1' 
	capture drop ret_country_`hor2'

	replace ret_country = `country' - `country'_rf/1200
	
	gen ret_country_`hor1' = ret_country
	
	local loopend1 = `hor1'-1
	
	forvalues i=1(1)`loopend1' {
		replace ret_country_`hor1' = ret_country_`hor1' + F`i'.ret_country
	}
	
	local loopend2 = `hor2'-1
	gen ret_country_`hor2' = ret_country
	forvalues i=1(1)`loopend2' {
		replace ret_country_`hor2' = ret_country_`hor2' + F`i'.ret_country
	}
	
	
	
	reg US L.US if ret_country!=.
	matrix beta = e(b)
	local rho : display %5.2f beta[1,1]
	scalar T = e(N)
	scalar rho_bias_corr = ((T*beta[1,1])+1)/(T-3)
	local rho_bc : display %5.2f rho_bias_corr
	predict ar_resid, resid 
	
	reg ret_country L.US
	scalar T_S = e(N)
	local sample_size : display %5.0f T_S
	predict ret_resid, resid 
	corr ar_resid ret_resid
	matrix corr_matrix = r(C)
	local delta: display %5.2f corr_matrix[1,2]
	drop ar_resid ret_resid
	
	scalar f_`hor1'_rho = (`hor1'*(1-(rho_bias_corr^2))-2*rho_bias_corr*(1-(rho_bias_corr^`hor1')))/(`hor1'*(1-rho_bias_corr)^2)
	scalar f_`hor2'_rho = (`hor2'*(1-(rho_bias_corr^2))-2*rho_bias_corr*(1-(rho_bias_corr^`hor2')))/(`hor2'*(1-rho_bias_corr)^2)
	
	
	scalar Lambda`hor1' = `hor1'/T_S
	scalar Lambda`hor2' = `hor2'/T_S
	local lambda_`hor1' : display %5.2f Lambda`hor1'
	local lambda_`hor2' : display %5.2f Lambda`hor2'
	
	reg ret_country L.US
	matrix beta = e(b)
	local beta_1 : display %5.2f beta[1,1]
	matrix varcov = e(V)
	scalar tstat_1 = beta[1,1]/sqrt(varcov[1,1])
	local t_1 : display %5.2f tstat_1 
		
	reg ret_country_`hor1' L.US
	matrix beta = e(b)
	local beta_`hor1' : display %5.2f beta[1,1]
	matrix varcov = e(V)
	scalar tstat_`hor1' = (beta[1,1]/sqrt(varcov[1,1]))
	scalar tstat_`hor1'_f = (beta[1,1]/sqrt(varcov[1,1]))/sqrt(f_`hor1'_rho)
	local t_`hor1' : display %5.2f tstat_`hor1'
	local t_`hor1'_f : display %5.2f tstat_`hor1'_f 
	
	reg ret_country_`hor2' L.US
	matrix beta = e(b)
	local beta_`hor2' : display %5.2f beta[1,1]
	matrix varcov = e(V)
	scalar tstat_`hor2' = (beta[1,1]/sqrt(varcov[1,1]))
	scalar tstat_`hor2'_f = (beta[1,1]/sqrt(varcov[1,1]))/sqrt(f_`hor2'_rho)
	local t_`hor2' : display %5.2f tstat_`hor2'
	local t_`hor2'_f : display %5.2f tstat_`hor2'_f 

	
	reg ret_country L.ret_country
	
	# delimit ;
	outreg, merge se bdec(2) starlevels(10 5 1) keep(L.ret_country)	 noautosumm 
			basefont(fs8 Times Roman) ctitle("","`country'") rtitles(rho\(Std.Err))
			addrows("rho_bc","`rho_bc'"\"delta","`delta'"\"T","`sample_size'"\"lambda_`hor1'","`lambda_`hor1''"\"lambda_`hor2'","`lambda_`hor2''"
			\"beta_1","`beta_1'"\"t_1","`t_1'"\"beta_`hor1'","`beta_`hor1''"\"t_`hor1'","`t_`hor1''"\"t_`hor1'_ALR","`t_`hor1'_f'"\"beta_`hor2'","`beta_`hor2''"\"t_`hor2'","`t_`hor2''"\"t_`hor2'_ALR","`t_`hor2'_f'");
	
	
	# delimit cr
	
	}
	
	
