%This function calculates the first q second moments (that is, the
%variance and first q-1 autocovariances) of an VAR(p) process, using the Yule
%Walker equations. The formulas are based on Hamilton, 1994, p.265-266.

%INPUT: varcoeffs: n x np matrix of VAR coefficients [A_1, A_2, ...A_p]
%        sigmasq: n x n covariance matrix of the residuals
%       q: scalar number of lags (including lag 0 for variance)
% OUTPUT: autocov: n x nq matrix of autocovariances [Gamma_0 Gamma_1 ...,
% Gamma_q-1]

function autocov = yule_walker(varcoeffs,sigmasq,q)
    [n, np] = size(varcoeffs);
    p=np/n;
    F=zeros(np,np);
    F(1:n,:)=varcoeffs;
    F(n+1:end,1:end-n)=eye(n*(p-1));
    Q=zeros(np,np);
    Q(1:n,1:n)=sigmasq;
    init_ac=(eye(np^2)-kron(F,F))\vec(Q);
    Sigma=unvec(init_ac);
    for i=1:q
        if i<p+1
        autocov(1:n,((i-1)*n+1):n*i)=Sigma(1:n,((i-1)*n+1):n*i);
        else
          Sigma_i=F^(i-1)*Sigma;
         autocov(1:n,(i-1)*n+1:n*i)=Sigma_i(1:n,1:n);
        end
    end
    
end


function v=vec(A)
    v=reshape(A,numel(A),1);
end

function A=unvec(v)
    A=reshape(v,sqrt(numel(v)),sqrt(numel(v)));
end