function [A,Omega,covmat,eps,const,bic]=varpest(X,lags,const)
    if nargin<3
        const = 0;
    end
    if nargin<2
        lags=1;
    end
    [T,K]=size(X);
    
    if const ==0
        X=X-mean(X);
        y=X(lags+1:end,:);
        x=[];
        for q=1:lags
            x=[x X(1+lags-q:end-q,:)];
        end
        A=(x'*x)^(-1)*(x'*y);
        %vecA=reshape(A,K^2,1);
        eps=y-x*A;
        Omega=eps'*eps/T;
        bic=log(det(Omega))+log(T)/T*K^2*lags;
        covmat=kron(Omega,(x'*x)^(-1)*T);   
    else
        y=X(lags+1:end,:);
        x=ones(length(y),1);
        for q=1:lags
            x=[x X(1+lags-q:end-q,:)];
        end
        Atot=(x'*x)^(-1)*(x'*y);
        %vecA=reshape(A,K^2,1);
        eps=y-x*Atot;
        Omega=eps'*eps/T;
        bic=log(det(Omega))+log(T)/T*K^2*lags;
        covmat=kron(Omega,(x'*x)^(-1)*T);  
        const=Atot(1,:)';
        A=Atot(2:end,:);
    end

end