%This function provides asymptotic critical values for the scaled 
%statistic t_f. 
%INPUT
% q (1x1)       - horizon 
% T (1x1)       - sample size
% delta (1x1)   - correlation between innovations
% level (1x1)   - significance level (2.5, 5, 95, 97.5 percent)
% 
%OUTPUT 
% critical_value (1x1) - a critical value of the t_f(q,rho) test.
% Note: critical values are provided up until lambda=q/T=0.5

function critical_value=tstat_cv(q,T,delta,level)
    if nargin < 4
        level = 0.95;
    end

    if q == 1 || delta == 0
        critical_value = norminv(level);
    else
        level_grid=[0.025 0.05 0.95 0.975];
        delta_grid=linspace(-0.99,0.99,199);
        [~,column]=min(abs(delta-delta_grid));
        lambda = q/T;
        lambda_grid = linspace(0.01,0.5,50);
        [~,row]=min(abs(lambda-lambda_grid));
        critical_value=choose_value(row,column,find(level == level_grid));
    
    end
    
end

function cv=choose_value(row,column,table)

cv95 = [ 1.7897  1.7887  1.7868  1.7855  1.7843  1.7827  1.7806  1.7784  1.7765  1.7754  1.7748  1.7735  1.7718  1.7703  1.7689  1.7677  1.7667  1.7648  1.7639  1.7628  1.7617  1.7605  1.7589  1.7574  1.7560  1.7552  1.7537  1.7518  1.7506  1.7494  1.7479  1.7465  1.7449  1.7435  1.7424  1.7411  1.7404  1.7385  1.7369  1.7351  1.7330  1.7319  1.7300  1.7287  1.7269  1.7253  1.7243  1.7230  1.7216  1.7200  1.7181  1.7167  1.7156  1.7143  1.7133  1.7114  1.7101  1.7081  1.7064  1.7047  1.7031  1.7013  1.7000  1.6985  1.6971  1.6961  1.6951  1.6937  1.6921  1.6908  1.6894  1.6884  1.6868  1.6853  1.6840  1.6825  1.6809  1.6792  1.6776  1.6760  1.6749  1.6733  1.6719  1.6701  1.6683  1.6668  1.6655  1.6642  1.6628  1.6613  1.6600  1.6586  1.6574  1.6559  1.6539  1.6524  1.6508  1.6492  1.6483  1.6463  1.6447  1.6428  1.6416  1.6396  1.6380  1.6368  1.6353  1.6332  1.6313  1.6305  1.6290  1.6274  1.6255  1.6244  1.6229  1.6213  1.6199  1.6184  1.6169  1.6155  1.6138  1.6127  1.6111  1.6097  1.6080  1.6071  1.6054  1.6040  1.6022  1.6008  1.5994  1.5975  1.5961  1.5948  1.5934  1.5920  1.5904  1.5888  1.5875  1.5864  1.5844  1.5833  1.5821  1.5805  1.5792  1.5780  1.5770  1.5756  1.5744  1.5731  1.5709  1.5698  1.5682  1.5661  1.5642  1.5629  1.5615  1.5600  1.5582  1.5572  1.5558  1.5540  1.5526  1.5510  1.5496  1.5483  1.5461  1.5445  1.5426  1.5415  1.5395  1.5382  1.5366  1.5345  1.5332  1.5319  1.5304  1.5280  1.5266  1.5247  1.5231  1.5212  1.5202  1.5183  1.5170  1.5151  1.5134  1.5115  1.5099  1.5083  1.5066  1.5054  1.5041  1.5015  1.5010  1.4993  1.4972  1.4956  1.4935
 1.8540  1.8519  1.8490  1.8462  1.8438  1.8411  1.8391  1.8365  1.8339  1.8330  1.8309  1.8289  1.8266  1.8245  1.8222  1.8197  1.8177  1.8151  1.8126  1.8106  1.8091  1.8070  1.8049  1.8028  1.8008  1.7981  1.7955  1.7936  1.7920  1.7900  1.7886  1.7871  1.7854  1.7828  1.7811  1.7791  1.7775  1.7751  1.7732  1.7707  1.7687  1.7670  1.7649  1.7631  1.7613  1.7589  1.7567  1.7548  1.7530  1.7507  1.7486  1.7470  1.7443  1.7425  1.7403  1.7376  1.7352  1.7330  1.7310  1.7291  1.7269  1.7250  1.7227  1.7206  1.7192  1.7173  1.7152  1.7134  1.7111  1.7092  1.7070  1.7051  1.7033  1.7008  1.6988  1.6971  1.6952  1.6931  1.6908  1.6890  1.6870  1.6854  1.6833  1.6809  1.6787  1.6769  1.6745  1.6717  1.6700  1.6682  1.6654  1.6631  1.6608  1.6589  1.6567  1.6546  1.6520  1.6502  1.6485  1.6463  1.6440  1.6413  1.6392  1.6372  1.6345  1.6319  1.6302  1.6281  1.6259  1.6237  1.6217  1.6200  1.6179  1.6154  1.6131  1.6112  1.6091  1.6067  1.6045  1.6026  1.6003  1.5983  1.5960  1.5941  1.5926  1.5908  1.5887  1.5868  1.5844  1.5826  1.5804  1.5782  1.5760  1.5739  1.5721  1.5697  1.5672  1.5649  1.5621  1.5601  1.5585  1.5568  1.5548  1.5525  1.5503  1.5478  1.5457  1.5434  1.5405  1.5386  1.5365  1.5342  1.5317  1.5299  1.5278  1.5249  1.5228  1.5207  1.5184  1.5162  1.5138  1.5120  1.5099  1.5083  1.5061  1.5035  1.5015  1.4992  1.4970  1.4950  1.4926  1.4907  1.4888  1.4872  1.4853  1.4829  1.4803  1.4779  1.4759  1.4729  1.4708  1.4691  1.4666  1.4648  1.4631  1.4602  1.4581  1.4559  1.4535  1.4517  1.4492  1.4467  1.4444  1.4417  1.4394  1.4379  1.4348  1.4320  1.4301
 1.9017  1.8983  1.8955  1.8923  1.8905  1.8876  1.8855  1.8824  1.8798  1.8772  1.8743  1.8719  1.8689  1.8658  1.8631  1.8604  1.8574  1.8548  1.8520  1.8494  1.8467  1.8441  1.8415  1.8393  1.8364  1.8333  1.8305  1.8283  1.8260  1.8236  1.8216  1.8190  1.8171  1.8143  1.8115  1.8089  1.8065  1.8040  1.8016  1.7993  1.7971  1.7943  1.7923  1.7897  1.7869  1.7842  1.7817  1.7788  1.7759  1.7732  1.7707  1.7683  1.7657  1.7629  1.7605  1.7585  1.7559  1.7532  1.7508  1.7486  1.7460  1.7434  1.7407  1.7381  1.7355  1.7327  1.7297  1.7275  1.7252  1.7228  1.7206  1.7182  1.7153  1.7130  1.7104  1.7078  1.7053  1.7029  1.7008  1.6981  1.6959  1.6930  1.6904  1.6876  1.6851  1.6827  1.6802  1.6773  1.6750  1.6724  1.6696  1.6670  1.6647  1.6620  1.6597  1.6570  1.6545  1.6515  1.6488  1.6463  1.6436  1.6406  1.6380  1.6353  1.6319  1.6291  1.6263  1.6235  1.6212  1.6192  1.6167  1.6141  1.6117  1.6089  1.6066  1.6042  1.6017  1.5988  1.5962  1.5932  1.5908  1.5886  1.5856  1.5824  1.5794  1.5768  1.5739  1.5709  1.5684  1.5664  1.5639  1.5612  1.5589  1.5560  1.5530  1.5504  1.5481  1.5450  1.5426  1.5400  1.5372  1.5346  1.5318  1.5293  1.5267  1.5241  1.5213  1.5186  1.5156  1.5127  1.5100  1.5063  1.5032  1.5004  1.4976  1.4951  1.4925  1.4898  1.4870  1.4843  1.4819  1.4795  1.4771  1.4742  1.4722  1.4694  1.4662  1.4635  1.4606  1.4580  1.4557  1.4533  1.4508  1.4481  1.4453  1.4436  1.4409  1.4379  1.4351  1.4322  1.4293  1.4265  1.4240  1.4210  1.4187  1.4159  1.4132  1.4116  1.4089  1.4065  1.4034  1.4007  1.3972  1.3943  1.3925  1.3893  1.3866  1.3825  1.3790
 1.9400  1.9357  1.9314  1.9283  1.9260  1.9227  1.9193  1.9161  1.9132  1.9106  1.9076  1.9043  1.9009  1.8981  1.8954  1.8928  1.8899  1.8871  1.8839  1.8812  1.8788  1.8759  1.8729  1.8706  1.8681  1.8649  1.8623  1.8595  1.8567  1.8542  1.8511  1.8479  1.8448  1.8421  1.8393  1.8368  1.8340  1.8311  1.8282  1.8248  1.8218  1.8188  1.8161  1.8133  1.8099  1.8073  1.8043  1.8010  1.7978  1.7949  1.7915  1.7883  1.7852  1.7824  1.7795  1.7760  1.7733  1.7703  1.7670  1.7642  1.7609  1.7578  1.7549  1.7520  1.7490  1.7463  1.7437  1.7404  1.7375  1.7346  1.7317  1.7287  1.7261  1.7232  1.7204  1.7178  1.7147  1.7121  1.7091  1.7062  1.7031  1.7001  1.6975  1.6945  1.6916  1.6885  1.6851  1.6822  1.6790  1.6763  1.6732  1.6709  1.6678  1.6647  1.6617  1.6587  1.6556  1.6525  1.6493  1.6463  1.6433  1.6398  1.6368  1.6334  1.6304  1.6272  1.6235  1.6204  1.6175  1.6148  1.6115  1.6087  1.6058  1.6025  1.5990  1.5964  1.5930  1.5900  1.5867  1.5832  1.5801  1.5771  1.5740  1.5708  1.5679  1.5652  1.5622  1.5595  1.5567  1.5536  1.5507  1.5473  1.5443  1.5411  1.5386  1.5357  1.5324  1.5290  1.5258  1.5224  1.5192  1.5163  1.5127  1.5103  1.5074  1.5048  1.5017  1.4988  1.4952  1.4921  1.4895  1.4865  1.4834  1.4798  1.4770  1.4742  1.4713  1.4683  1.4647  1.4617  1.4583  1.4550  1.4523  1.4493  1.4465  1.4432  1.4398  1.4366  1.4330  1.4304  1.4266  1.4236  1.4203  1.4173  1.4139  1.4105  1.4080  1.4048  1.4017  1.3988  1.3958  1.3923  1.3893  1.3864  1.3833  1.3802  1.3771  1.3741  1.3708  1.3677  1.3641  1.3610  1.3574  1.3541  1.3510  1.3479  1.3445  1.3412  1.3379
 1.9683  1.9657  1.9627  1.9599  1.9566  1.9545  1.9510  1.9479  1.9446  1.9413  1.9380  1.9356  1.9319  1.9296  1.9259  1.9228  1.9199  1.9163  1.9133  1.9103  1.9071  1.9030  1.9001  1.8965  1.8931  1.8903  1.8865  1.8838  1.8805  1.8774  1.8746  1.8718  1.8690  1.8663  1.8633  1.8602  1.8569  1.8541  1.8511  1.8469  1.8427  1.8393  1.8362  1.8332  1.8295  1.8262  1.8225  1.8195  1.8162  1.8129  1.8099  1.8070  1.8038  1.8005  1.7971  1.7937  1.7896  1.7863  1.7831  1.7789  1.7760  1.7727  1.7696  1.7662  1.7628  1.7593  1.7558  1.7526  1.7491  1.7458  1.7425  1.7394  1.7359  1.7330  1.7298  1.7259  1.7227  1.7197  1.7168  1.7136  1.7103  1.7073  1.7041  1.7011  1.6980  1.6948  1.6914  1.6879  1.6846  1.6808  1.6771  1.6736  1.6705  1.6668  1.6636  1.6602  1.6566  1.6531  1.6497  1.6463  1.6430  1.6388  1.6355  1.6322  1.6286  1.6250  1.6213  1.6181  1.6147  1.6110  1.6076  1.6043  1.6011  1.5981  1.5942  1.5905  1.5872  1.5840  1.5801  1.5768  1.5735  1.5700  1.5667  1.5629  1.5589  1.5556  1.5524  1.5489  1.5455  1.5420  1.5387  1.5356  1.5321  1.5290  1.5260  1.5229  1.5189  1.5151  1.5112  1.5080  1.5044  1.5014  1.4976  1.4945  1.4910  1.4873  1.4833  1.4797  1.4762  1.4730  1.4698  1.4663  1.4629  1.4593  1.4559  1.4528  1.4494  1.4455  1.4420  1.4387  1.4348  1.4309  1.4274  1.4237  1.4200  1.4170  1.4135  1.4107  1.4069  1.4037  1.3999  1.3962  1.3926  1.3889  1.3852  1.3817  1.3778  1.3744  1.3704  1.3671  1.3630  1.3591  1.3556  1.3518  1.3485  1.3453  1.3417  1.3381  1.3342  1.3313  1.3274  1.3235  1.3198  1.3152  1.3116  1.3074  1.3042  1.3003  1.2973
 1.9977  1.9943  1.9912  1.9881  1.9854  1.9827  1.9794  1.9762  1.9718  1.9678  1.9641  1.9610  1.9576  1.9538  1.9502  1.9463  1.9431  1.9399  1.9360  1.9330  1.9297  1.9260  1.9226  1.9190  1.9147  1.9115  1.9073  1.9040  1.9004  1.8974  1.8938  1.8908  1.8874  1.8835  1.8798  1.8762  1.8728  1.8689  1.8652  1.8620  1.8587  1.8556  1.8525  1.8487  1.8449  1.8413  1.8378  1.8342  1.8308  1.8269  1.8229  1.8195  1.8154  1.8116  1.8081  1.8050  1.8017  1.7979  1.7948  1.7912  1.7877  1.7837  1.7803  1.7770  1.7733  1.7692  1.7652  1.7616  1.7582  1.7548  1.7512  1.7478  1.7449  1.7410  1.7373  1.7339  1.7301  1.7262  1.7224  1.7188  1.7155  1.7116  1.7080  1.7046  1.7012  1.6978  1.6947  1.6912  1.6873  1.6833  1.6794  1.6757  1.6721  1.6691  1.6651  1.6616  1.6578  1.6537  1.6500  1.6463  1.6424  1.6383  1.6344  1.6311  1.6275  1.6237  1.6201  1.6155  1.6122  1.6086  1.6046  1.6009  1.5967  1.5930  1.5891  1.5858  1.5820  1.5780  1.5742  1.5700  1.5666  1.5626  1.5592  1.5556  1.5514  1.5479  1.5441  1.5402  1.5361  1.5318  1.5285  1.5249  1.5210  1.5170  1.5135  1.5100  1.5068  1.5030  1.4990  1.4953  1.4908  1.4865  1.4828  1.4784  1.4741  1.4701  1.4661  1.4624  1.4580  1.4541  1.4509  1.4470  1.4435  1.4392  1.4360  1.4322  1.4286  1.4252  1.4218  1.4181  1.4135  1.4099  1.4061  1.4023  1.3978  1.3940  1.3904  1.3862  1.3820  1.3774  1.3738  1.3695  1.3650  1.3609  1.3567  1.3523  1.3484  1.3443  1.3405  1.3373  1.3330  1.3296  1.3262  1.3220  1.3173  1.3129  1.3087  1.3043  1.3007  1.2962  1.2917  1.2880  1.2840  1.2801  1.2767  1.2730  1.2680  1.2642  1.2597
 2.0244  2.0210  2.0174  2.0133  2.0103  2.0069  2.0034  2.0002  1.9962  1.9930  1.9891  1.9859  1.9828  1.9799  1.9760  1.9720  1.9682  1.9638  1.9599  1.9562  1.9527  1.9492  1.9451  1.9413  1.9372  1.9335  1.9291  1.9249  1.9211  1.9175  1.9133  1.9092  1.9055  1.9011  1.8975  1.8945  1.8908  1.8868  1.8830  1.8791  1.8759  1.8721  1.8683  1.8641  1.8602  1.8564  1.8525  1.8482  1.8450  1.8411  1.8372  1.8333  1.8298  1.8257  1.8220  1.8184  1.8148  1.8109  1.8077  1.8041  1.7997  1.7960  1.7925  1.7885  1.7845  1.7811  1.7772  1.7731  1.7693  1.7654  1.7613  1.7577  1.7538  1.7497  1.7461  1.7426  1.7382  1.7341  1.7294  1.7255  1.7223  1.7183  1.7146  1.7110  1.7075  1.7035  1.6993  1.6949  1.6906  1.6867  1.6827  1.6783  1.6743  1.6705  1.6666  1.6625  1.6585  1.6543  1.6504  1.6463  1.6422  1.6377  1.6337  1.6293  1.6252  1.6214  1.6173  1.6133  1.6094  1.6052  1.6008  1.5964  1.5921  1.5879  1.5837  1.5795  1.5756  1.5715  1.5678  1.5636  1.5597  1.5554  1.5513  1.5472  1.5430  1.5392  1.5353  1.5313  1.5273  1.5233  1.5190  1.5144  1.5104  1.5068  1.5026  1.4982  1.4941  1.4901  1.4864  1.4822  1.4779  1.4733  1.4686  1.4641  1.4597  1.4551  1.4508  1.4464  1.4422  1.4374  1.4330  1.4288  1.4251  1.4208  1.4163  1.4120  1.4081  1.4034  1.3990  1.3952  1.3904  1.3859  1.3815  1.3770  1.3734  1.3694  1.3648  1.3610  1.3569  1.3534  1.3487  1.3446  1.3399  1.3355  1.3310  1.3272  1.3221  1.3184  1.3137  1.3095  1.3050  1.3005  1.2961  1.2915  1.2872  1.2830  1.2783  1.2739  1.2705  1.2657  1.2614  1.2575  1.2523  1.2483  1.2433  1.2389  1.2354  1.2309  1.2253
 2.0518  2.0488  2.0451  2.0416  2.0374  2.0342  2.0304  2.0263  2.0223  2.0187  2.0149  2.0114  2.0070  2.0035  1.9983  1.9946  1.9905  1.9864  1.9822  1.9781  1.9740  1.9692  1.9655  1.9614  1.9569  1.9529  1.9495  1.9454  1.9408  1.9368  1.9323  1.9283  1.9242  1.9204  1.9159  1.9121  1.9080  1.9037  1.9003  1.8966  1.8915  1.8876  1.8831  1.8791  1.8751  1.8716  1.8672  1.8638  1.8596  1.8551  1.8512  1.8474  1.8434  1.8396  1.8355  1.8314  1.8273  1.8227  1.8185  1.8144  1.8107  1.8067  1.8021  1.7981  1.7941  1.7900  1.7858  1.7819  1.7773  1.7733  1.7694  1.7652  1.7610  1.7571  1.7530  1.7491  1.7456  1.7413  1.7372  1.7330  1.7291  1.7249  1.7210  1.7169  1.7120  1.7076  1.7029  1.6987  1.6939  1.6895  1.6854  1.6816  1.6773  1.6727  1.6683  1.6640  1.6592  1.6545  1.6505  1.6463  1.6420  1.6372  1.6328  1.6283  1.6239  1.6194  1.6152  1.6109  1.6065  1.6020  1.5975  1.5929  1.5884  1.5835  1.5786  1.5746  1.5705  1.5659  1.5615  1.5572  1.5526  1.5481  1.5433  1.5390  1.5350  1.5309  1.5268  1.5219  1.5170  1.5126  1.5083  1.5041  1.4997  1.4952  1.4910  1.4868  1.4828  1.4782  1.4741  1.4696  1.4654  1.4608  1.4559  1.4516  1.4471  1.4422  1.4376  1.4327  1.4284  1.4234  1.4192  1.4143  1.4093  1.4045  1.3998  1.3951  1.3903  1.3855  1.3808  1.3765  1.3720  1.3670  1.3624  1.3580  1.3535  1.3492  1.3442  1.3396  1.3351  1.3308  1.3261  1.3212  1.3165  1.3114  1.3067  1.3019  1.2972  1.2923  1.2876  1.2825  1.2779  1.2730  1.2684  1.2632  1.2581  1.2541  1.2499  1.2456  1.2409  1.2358  1.2306  1.2265  1.2221  1.2167  1.2122  1.2082  1.2033  1.1981  1.1931
 2.0798  2.0750  2.0717  2.0679  2.0621  2.0581  2.0542  2.0498  2.0462  2.0422  2.0384  2.0340  2.0296  2.0256  2.0215  2.0171  2.0126  2.0087  2.0044  2.0005  1.9966  1.9920  1.9878  1.9839  1.9796  1.9755  1.9716  1.9671  1.9626  1.9582  1.9533  1.9491  1.9449  1.9405  1.9362  1.9322  1.9282  1.9242  1.9199  1.9156  1.9113  1.9068  1.9022  1.8978  1.8929  1.8884  1.8841  1.8790  1.8750  1.8710  1.8662  1.8620  1.8578  1.8537  1.8494  1.8447  1.8399  1.8356  1.8309  1.8265  1.8224  1.8184  1.8146  1.8104  1.8058  1.8016  1.7971  1.7924  1.7878  1.7839  1.7788  1.7748  1.7700  1.7653  1.7610  1.7568  1.7524  1.7478  1.7430  1.7392  1.7349  1.7301  1.7258  1.7213  1.7164  1.7118  1.7071  1.7025  1.6979  1.6932  1.6886  1.6840  1.6794  1.6746  1.6700  1.6652  1.6603  1.6554  1.6504  1.6463  1.6418  1.6369  1.6319  1.6270  1.6220  1.6170  1.6125  1.6078  1.6031  1.5981  1.5930  1.5885  1.5839  1.5793  1.5746  1.5703  1.5657  1.5609  1.5558  1.5509  1.5459  1.5414  1.5371  1.5322  1.5274  1.5228  1.5180  1.5134  1.5082  1.5033  1.4990  1.4945  1.4897  1.4854  1.4805  1.4758  1.4705  1.4653  1.4608  1.4556  1.4514  1.4467  1.4415  1.4374  1.4329  1.4282  1.4233  1.4179  1.4127  1.4082  1.4030  1.3988  1.3931  1.3881  1.3833  1.3784  1.3733  1.3679  1.3631  1.3579  1.3529  1.3483  1.3427  1.3378  1.3331  1.3280  1.3227  1.3181  1.3134  1.3080  1.3028  1.2977  1.2930  1.2882  1.2829  1.2771  1.2720  1.2670  1.2620  1.2569  1.2518  1.2465  1.2414  1.2363  1.2312  1.2269  1.2219  1.2168  1.2116  1.2066  1.2019  1.1967  1.1918  1.1867  1.1817  1.1762  1.1717  1.1671  1.1622
 2.1015  2.0976  2.0939  2.0896  2.0855  2.0801  2.0757  2.0714  2.0678  2.0633  2.0587  2.0543  2.0501  2.0452  2.0410  2.0369  2.0333  2.0291  2.0250  2.0209  2.0167  2.0123  2.0078  2.0030  1.9985  1.9942  1.9897  1.9852  1.9808  1.9762  1.9714  1.9669  1.9627  1.9581  1.9538  1.9491  1.9438  1.9393  1.9342  1.9296  1.9256  1.9215  1.9168  1.9121  1.9075  1.9030  1.8983  1.8933  1.8890  1.8844  1.8800  1.8751  1.8706  1.8663  1.8618  1.8573  1.8524  1.8477  1.8434  1.8382  1.8333  1.8288  1.8239  1.8191  1.8145  1.8098  1.8049  1.8002  1.7955  1.7909  1.7864  1.7820  1.7777  1.7730  1.7687  1.7637  1.7590  1.7540  1.7496  1.7450  1.7408  1.7360  1.7312  1.7264  1.7214  1.7165  1.7116  1.7060  1.7012  1.6965  1.6913  1.6863  1.6811  1.6763  1.6714  1.6661  1.6612  1.6558  1.6508  1.6463  1.6412  1.6359  1.6309  1.6258  1.6209  1.6158  1.6106  1.6058  1.6008  1.5956  1.5902  1.5852  1.5797  1.5749  1.5695  1.5644  1.5593  1.5539  1.5492  1.5445  1.5393  1.5340  1.5288  1.5241  1.5188  1.5136  1.5090  1.5044  1.4991  1.4940  1.4890  1.4844  1.4794  1.4745  1.4700  1.4652  1.4602  1.4554  1.4503  1.4448  1.4397  1.4350  1.4299  1.4250  1.4197  1.4149  1.4091  1.4041  1.3989  1.3936  1.3886  1.3830  1.3776  1.3728  1.3674  1.3627  1.3576  1.3523  1.3473  1.3419  1.3372  1.3315  1.3262  1.3212  1.3157  1.3106  1.3047  1.2992  1.2938  1.2885  1.2832  1.2779  1.2724  1.2673  1.2620  1.2568  1.2512  1.2459  1.2410  1.2353  1.2288  1.2230  1.2171  1.2110  1.2063  1.2014  1.1956  1.1897  1.1845  1.1790  1.1736  1.1683  1.1631  1.1577  1.1525  1.1470  1.1413  1.1372  1.1307
 2.1236  2.1201  2.1149  2.1111  2.1063  2.1014  2.0973  2.0930  2.0887  2.0839  2.0800  2.0760  2.0716  2.0672  2.0628  2.0579  2.0529  2.0485  2.0436  2.0392  2.0345  2.0297  2.0252  2.0207  2.0160  2.0108  2.0066  2.0022  1.9970  1.9920  1.9878  1.9831  1.9779  1.9731  1.9682  1.9633  1.9589  1.9538  1.9490  1.9444  1.9397  1.9351  1.9300  1.9258  1.9215  1.9167  1.9120  1.9066  1.9019  1.8966  1.8917  1.8864  1.8820  1.8769  1.8722  1.8672  1.8624  1.8577  1.8527  1.8477  1.8427  1.8380  1.8331  1.8287  1.8236  1.8188  1.8137  1.8090  1.8043  1.7991  1.7942  1.7894  1.7844  1.7796  1.7747  1.7696  1.7651  1.7605  1.7552  1.7503  1.7451  1.7400  1.7351  1.7305  1.7247  1.7197  1.7146  1.7092  1.7041  1.6992  1.6941  1.6888  1.6838  1.6785  1.6731  1.6672  1.6618  1.6564  1.6512  1.6463  1.6411  1.6354  1.6300  1.6247  1.6193  1.6144  1.6087  1.6031  1.5977  1.5930  1.5876  1.5823  1.5767  1.5712  1.5655  1.5599  1.5551  1.5497  1.5439  1.5388  1.5338  1.5287  1.5226  1.5171  1.5119  1.5070  1.5016  1.4965  1.4916  1.4864  1.4808  1.4759  1.4704  1.4654  1.4604  1.4551  1.4495  1.4447  1.4395  1.4335  1.4283  1.4227  1.4173  1.4118  1.4068  1.4014  1.3957  1.3899  1.3844  1.3787  1.3731  1.3675  1.3621  1.3565  1.3511  1.3456  1.3400  1.3343  1.3293  1.3239  1.3182  1.3130  1.3078  1.3019  1.2960  1.2903  1.2843  1.2790  1.2735  1.2679  1.2624  1.2569  1.2514  1.2457  1.2398  1.2344  1.2285  1.2223  1.2169  1.2116  1.2054  1.1990  1.1924  1.1867  1.1801  1.1747  1.1692  1.1641  1.1579  1.1518  1.1460  1.1398  1.1344  1.1287  1.1224  1.1166  1.1113  1.1056  1.0989
 2.1412  2.1360  2.1333  2.1281  2.1234  2.1191  2.1147  2.1104  2.1056  2.1008  2.0959  2.0920  2.0866  2.0819  2.0775  2.0717  2.0671  2.0633  2.0586  2.0540  2.0494  2.0446  2.0398  2.0348  2.0300  2.0252  2.0210  2.0162  2.0117  2.0069  2.0021  1.9964  1.9912  1.9861  1.9813  1.9766  1.9720  1.9672  1.9626  1.9580  1.9530  1.9481  1.9436  1.9382  1.9331  1.9285  1.9240  1.9193  1.9140  1.9093  1.9044  1.9000  1.8952  1.8903  1.8853  1.8804  1.8750  1.8698  1.8645  1.8599  1.8548  1.8496  1.8443  1.8391  1.8341  1.8291  1.8238  1.8187  1.8135  1.8084  1.8027  1.7974  1.7926  1.7878  1.7822  1.7765  1.7713  1.7666  1.7614  1.7558  1.7508  1.7453  1.7398  1.7341  1.7289  1.7239  1.7181  1.7128  1.7071  1.7015  1.6962  1.6907  1.6851  1.6798  1.6746  1.6689  1.6629  1.6575  1.6515  1.6463  1.6407  1.6351  1.6294  1.6239  1.6183  1.6132  1.6076  1.6020  1.5960  1.5903  1.5845  1.5788  1.5729  1.5671  1.5618  1.5556  1.5503  1.5448  1.5392  1.5339  1.5286  1.5231  1.5172  1.5119  1.5062  1.5006  1.4948  1.4895  1.4839  1.4787  1.4733  1.4677  1.4617  1.4566  1.4510  1.4453  1.4400  1.4345  1.4292  1.4238  1.4179  1.4122  1.4066  1.4009  1.3948  1.3891  1.3836  1.3785  1.3726  1.3667  1.3607  1.3547  1.3487  1.3430  1.3372  1.3311  1.3254  1.3202  1.3142  1.3087  1.3023  1.2968  1.2911  1.2855  1.2795  1.2731  1.2670  1.2608  1.2547  1.2491  1.2429  1.2360  1.2300  1.2238  1.2179  1.2120  1.2058  1.1999  1.1938  1.1880  1.1818  1.1758  1.1698  1.1636  1.1566  1.1510  1.1445  1.1383  1.1324  1.1267  1.1201  1.1140  1.1081  1.1014  1.0956  1.0889  1.0823  1.0766  1.0701
 2.1605  2.1556  2.1516  2.1468  2.1410  2.1367  2.1312  2.1264  2.1221  2.1178  2.1129  2.1083  2.1035  2.0985  2.0940  2.0895  2.0853  2.0803  2.0758  2.0704  2.0652  2.0598  2.0552  2.0500  2.0454  2.0399  2.0359  2.0303  2.0256  2.0210  2.0159  2.0106  2.0055  2.0004  1.9953  1.9900  1.9853  1.9801  1.9755  1.9704  1.9651  1.9602  1.9551  1.9496  1.9439  1.9388  1.9334  1.9282  1.9229  1.9181  1.9131  1.9082  1.9027  1.8974  1.8925  1.8868  1.8816  1.8764  1.8709  1.8656  1.8605  1.8550  1.8497  1.8447  1.8395  1.8345  1.8292  1.8240  1.8190  1.8131  1.8074  1.8021  1.7971  1.7916  1.7864  1.7806  1.7755  1.7704  1.7650  1.7599  1.7545  1.7490  1.7435  1.7375  1.7323  1.7264  1.7208  1.7151  1.7092  1.7038  1.6979  1.6927  1.6868  1.6812  1.6752  1.6692  1.6637  1.6578  1.6519  1.6463  1.6405  1.6348  1.6289  1.6226  1.6169  1.6113  1.6055  1.5994  1.5934  1.5873  1.5814  1.5757  1.5702  1.5641  1.5582  1.5523  1.5467  1.5407  1.5351  1.5292  1.5236  1.5179  1.5119  1.5063  1.5007  1.4945  1.4886  1.4827  1.4772  1.4710  1.4649  1.4584  1.4526  1.4468  1.4406  1.4349  1.4296  1.4238  1.4181  1.4125  1.4065  1.4006  1.3945  1.3885  1.3824  1.3762  1.3701  1.3641  1.3577  1.3514  1.3450  1.3387  1.3326  1.3266  1.3204  1.3143  1.3074  1.3015  1.2955  1.2891  1.2828  1.2763  1.2701  1.2642  1.2582  1.2520  1.2460  1.2399  1.2336  1.2273  1.2207  1.2145  1.2081  1.2020  1.1953  1.1890  1.1826  1.1758  1.1697  1.1630  1.1566  1.1500  1.1441  1.1376  1.1314  1.1248  1.1188  1.1121  1.1063  1.1002  1.0942  1.0873  1.0802  1.0741  1.0677  1.0610  1.0543  1.0474  1.0394
 2.1782  2.1738  2.1688  2.1634  2.1581  2.1544  2.1494  2.1442  2.1397  2.1347  2.1298  2.1247  2.1200  2.1149  2.1100  2.1052  2.1010  2.0965  2.0915  2.0865  2.0813  2.0759  2.0707  2.0655  2.0600  2.0547  2.0491  2.0445  2.0390  2.0338  2.0284  2.0229  2.0165  2.0117  2.0065  2.0015  1.9963  1.9913  1.9858  1.9810  1.9762  1.9707  1.9652  1.9598  1.9543  1.9489  1.9435  1.9381  1.9325  1.9276  1.9217  1.9166  1.9113  1.9054  1.8994  1.8942  1.8887  1.8834  1.8774  1.8719  1.8659  1.8610  1.8557  1.8503  1.8450  1.8399  1.8345  1.8291  1.8234  1.8179  1.8123  1.8071  1.8015  1.7960  1.7902  1.7851  1.7802  1.7749  1.7692  1.7638  1.7584  1.7526  1.7475  1.7412  1.7353  1.7291  1.7235  1.7170  1.7115  1.7056  1.6998  1.6942  1.6887  1.6830  1.6766  1.6704  1.6641  1.6579  1.6522  1.6463  1.6403  1.6341  1.6283  1.6220  1.6162  1.6103  1.6042  1.5976  1.5920  1.5859  1.5798  1.5738  1.5677  1.5612  1.5550  1.5489  1.5428  1.5366  1.5309  1.5248  1.5189  1.5125  1.5060  1.5004  1.4944  1.4881  1.4818  1.4759  1.4699  1.4640  1.4576  1.4512  1.4449  1.4395  1.4332  1.4262  1.4205  1.4139  1.4076  1.4010  1.3951  1.3891  1.3832  1.3770  1.3706  1.3640  1.3573  1.3506  1.3441  1.3372  1.3310  1.3247  1.3180  1.3117  1.3045  1.2979  1.2916  1.2850  1.2788  1.2722  1.2661  1.2596  1.2532  1.2468  1.2404  1.2337  1.2273  1.2207  1.2144  1.2080  1.2011  1.1942  1.1875  1.1808  1.1743  1.1678  1.1611  1.1550  1.1484  1.1418  1.1353  1.1284  1.1213  1.1151  1.1089  1.1020  1.0955  1.0881  1.0815  1.0748  1.0680  1.0614  1.0545  1.0483  1.0416  1.0344  1.0266  1.0185  1.0117
 2.1968  2.1920  2.1870  2.1821  2.1771  2.1723  2.1678  2.1626  2.1572  2.1517  2.1469  2.1417  2.1363  2.1311  2.1258  2.1204  2.1153  2.1103  2.1054  2.1006  2.0957  2.0902  2.0852  2.0800  2.0749  2.0700  2.0646  2.0593  2.0540  2.0486  2.0434  2.0383  2.0331  2.0281  2.0223  2.0166  2.0120  2.0061  2.0007  1.9951  1.9896  1.9839  1.9782  1.9725  1.9672  1.9619  1.9563  1.9510  1.9456  1.9403  1.9344  1.9289  1.9234  1.9179  1.9118  1.9060  1.8999  1.8941  1.8888  1.8832  1.8771  1.8713  1.8655  1.8603  1.8548  1.8487  1.8432  1.8377  1.8317  1.8258  1.8201  1.8141  1.8081  1.8024  1.7967  1.7910  1.7845  1.7789  1.7733  1.7676  1.7616  1.7558  1.7500  1.7439  1.7379  1.7319  1.7257  1.7200  1.7141  1.7080  1.7019  1.6960  1.6903  1.6839  1.6774  1.6711  1.6652  1.6586  1.6525  1.6463  1.6399  1.6336  1.6275  1.6210  1.6147  1.6089  1.6030  1.5965  1.5903  1.5840  1.5778  1.5713  1.5649  1.5586  1.5514  1.5452  1.5387  1.5321  1.5258  1.5194  1.5131  1.5073  1.5008  1.4947  1.4882  1.4818  1.4757  1.4694  1.4631  1.4563  1.4500  1.4435  1.4368  1.4307  1.4242  1.4184  1.4125  1.4059  1.3992  1.3930  1.3870  1.3803  1.3737  1.3669  1.3606  1.3541  1.3477  1.3408  1.3341  1.3268  1.3202  1.3136  1.3071  1.3005  1.2936  1.2866  1.2802  1.2731  1.2669  1.2597  1.2528  1.2460  1.2396  1.2334  1.2266  1.2197  1.2129  1.2058  1.1986  1.1916  1.1844  1.1774  1.1703  1.1634  1.1558  1.1490  1.1419  1.1353  1.1281  1.1207  1.1137  1.1066  1.0999  1.0939  1.0870  1.0802  1.0732  1.0663  1.0588  1.0514  1.0444  1.0376  1.0301  1.0231  1.0166  1.0082  1.0012  0.9951  0.9872
 2.2118  2.2068  2.2023  2.1975  2.1920  2.1871  2.1818  2.1767  2.1714  2.1663  2.1608  2.1560  2.1508  2.1456  2.1407  2.1356  2.1302  2.1249  2.1196  2.1145  2.1086  2.1035  2.0989  2.0934  2.0881  2.0830  2.0781  2.0729  2.0676  2.0621  2.0567  2.0515  2.0459  2.0405  2.0350  2.0296  2.0237  2.0183  2.0127  2.0068  2.0010  1.9953  1.9899  1.9841  1.9787  1.9728  1.9675  1.9611  1.9555  1.9496  1.9446  1.9392  1.9336  1.9277  1.9220  1.9159  1.9099  1.9041  1.8980  1.8919  1.8855  1.8793  1.8735  1.8678  1.8621  1.8562  1.8503  1.8448  1.8383  1.8316  1.8255  1.8198  1.8143  1.8084  1.8025  1.7965  1.7903  1.7842  1.7785  1.7723  1.7658  1.7594  1.7531  1.7469  1.7410  1.7347  1.7285  1.7219  1.7162  1.7100  1.7038  1.6975  1.6914  1.6851  1.6786  1.6721  1.6654  1.6590  1.6528  1.6463  1.6397  1.6332  1.6271  1.6204  1.6144  1.6080  1.6015  1.5945  1.5881  1.5817  1.5750  1.5685  1.5615  1.5548  1.5483  1.5419  1.5356  1.5290  1.5223  1.5154  1.5087  1.5020  1.4950  1.4886  1.4820  1.4750  1.4685  1.4616  1.4551  1.4485  1.4415  1.4347  1.4289  1.4221  1.4152  1.4090  1.4018  1.3952  1.3885  1.3821  1.3752  1.3687  1.3621  1.3557  1.3490  1.3423  1.3357  1.3287  1.3216  1.3147  1.3076  1.3003  1.2932  1.2862  1.2791  1.2727  1.2660  1.2590  1.2520  1.2444  1.2372  1.2308  1.2235  1.2165  1.2092  1.2023  1.1952  1.1884  1.1807  1.1739  1.1665  1.1591  1.1519  1.1446  1.1371  1.1296  1.1228  1.1152  1.1081  1.1012  1.0938  1.0863  1.0789  1.0718  1.0644  1.0564  1.0494  1.0432  1.0356  1.0276  1.0193  1.0127  1.0043  0.9970  0.9903  0.9823  0.9752  0.9665  0.9585
 2.2273  2.2225  2.2181  2.2127  2.2075  2.2021  2.1966  2.1918  2.1862  2.1811  2.1753  2.1700  2.1644  2.1594  2.1544  2.1490  2.1432  2.1375  2.1327  2.1274  2.1221  2.1169  2.1112  2.1055  2.1003  2.0952  2.0894  2.0838  2.0786  2.0733  2.0680  2.0628  2.0572  2.0520  2.0462  2.0405  2.0348  2.0291  2.0235  2.0178  2.0123  2.0068  2.0012  1.9953  1.9893  1.9832  1.9774  1.9710  1.9652  1.9591  1.9530  1.9476  1.9410  1.9353  1.9289  1.9222  1.9166  1.9107  1.9048  1.8985  1.8929  1.8872  1.8808  1.8747  1.8686  1.8626  1.8565  1.8502  1.8442  1.8381  1.8325  1.8264  1.8202  1.8143  1.8082  1.8012  1.7950  1.7885  1.7827  1.7764  1.7705  1.7640  1.7571  1.7503  1.7438  1.7368  1.7301  1.7241  1.7178  1.7114  1.7048  1.6984  1.6919  1.6858  1.6790  1.6724  1.6656  1.6595  1.6528  1.6463  1.6396  1.6329  1.6266  1.6201  1.6130  1.6063  1.5998  1.5933  1.5865  1.5793  1.5726  1.5659  1.5591  1.5516  1.5447  1.5376  1.5312  1.5248  1.5177  1.5108  1.5034  1.4966  1.4896  1.4825  1.4755  1.4688  1.4618  1.4553  1.4483  1.4413  1.4345  1.4280  1.4215  1.4149  1.4079  1.4012  1.3941  1.3870  1.3799  1.3732  1.3664  1.3598  1.3527  1.3455  1.3387  1.3316  1.3244  1.3174  1.3100  1.3030  1.2962  1.2892  1.2819  1.2753  1.2677  1.2599  1.2524  1.2450  1.2376  1.2301  1.2227  1.2157  1.2086  1.2010  1.1935  1.1859  1.1788  1.1717  1.1643  1.1568  1.1488  1.1411  1.1336  1.1266  1.1189  1.1113  1.1038  1.0962  1.0890  1.0814  1.0735  1.0659  1.0582  1.0506  1.0434  1.0354  1.0281  1.0203  1.0131  1.0053  0.9974  0.9896  0.9812  0.9738  0.9658  0.9580  0.9495  0.9418  0.9340
 2.2411  2.2374  2.2316  2.2267  2.2213  2.2170  2.2113  2.2065  2.2018  2.1959  2.1904  2.1854  2.1801  2.1743  2.1687  2.1637  2.1585  2.1533  2.1483  2.1428  2.1372  2.1314  2.1257  2.1194  2.1137  2.1085  2.1028  2.0971  2.0915  2.0858  2.0798  2.0738  2.0683  2.0621  2.0562  2.0503  2.0445  2.0382  2.0321  2.0260  2.0202  2.0143  2.0081  2.0023  1.9964  1.9910  1.9843  1.9784  1.9723  1.9668  1.9614  1.9553  1.9491  1.9431  1.9367  1.9307  1.9244  1.9187  1.9127  1.9066  1.9008  1.8946  1.8887  1.8824  1.8757  1.8689  1.8623  1.8561  1.8500  1.8436  1.8376  1.8314  1.8249  1.8180  1.8111  1.8048  1.7982  1.7920  1.7858  1.7794  1.7724  1.7659  1.7594  1.7529  1.7459  1.7395  1.7328  1.7261  1.7200  1.7134  1.7070  1.7004  1.6942  1.6876  1.6805  1.6732  1.6669  1.6599  1.6530  1.6463  1.6393  1.6326  1.6257  1.6189  1.6120  1.6052  1.5982  1.5913  1.5843  1.5773  1.5700  1.5631  1.5559  1.5489  1.5420  1.5349  1.5280  1.5210  1.5142  1.5072  1.5004  1.4931  1.4854  1.4783  1.4708  1.4642  1.4571  1.4496  1.4431  1.4355  1.4284  1.4216  1.4142  1.4071  1.4001  1.3927  1.3854  1.3778  1.3705  1.3633  1.3558  1.3485  1.3410  1.3338  1.3262  1.3183  1.3115  1.3039  1.2964  1.2887  1.2808  1.2732  1.2662  1.2582  1.2512  1.2437  1.2361  1.2287  1.2212  1.2139  1.2065  1.1989  1.1915  1.1842  1.1768  1.1698  1.1621  1.1542  1.1459  1.1381  1.1300  1.1220  1.1147  1.1064  1.0982  1.0901  1.0822  1.0746  1.0671  1.0598  1.0516  1.0438  1.0363  1.0285  1.0201  1.0123  1.0051  0.9972  0.9895  0.9812  0.9738  0.9650  0.9568  0.9483  0.9397  0.9325  0.9241  0.9159  0.9072
 2.2540  2.2494  2.2442  2.2389  2.2341  2.2291  2.2242  2.2188  2.2134  2.2079  2.2028  2.1976  2.1923  2.1865  2.1805  2.1754  2.1694  2.1641  2.1578  2.1522  2.1460  2.1404  2.1354  2.1294  2.1234  2.1181  2.1123  2.1067  2.1010  2.0955  2.0895  2.0835  2.0781  2.0718  2.0653  2.0595  2.0537  2.0478  2.0417  2.0357  2.0295  2.0233  2.0173  2.0110  2.0052  1.9994  1.9932  1.9874  1.9813  1.9755  1.9693  1.9628  1.9567  1.9505  1.9445  1.9382  1.9312  1.9248  1.9183  1.9122  1.9060  1.8996  1.8935  1.8870  1.8807  1.8740  1.8678  1.8613  1.8549  1.8488  1.8427  1.8360  1.8291  1.8220  1.8157  1.8091  1.8026  1.7960  1.7893  1.7826  1.7762  1.7693  1.7630  1.7563  1.7491  1.7423  1.7355  1.7292  1.7219  1.7150  1.7084  1.7014  1.6951  1.6881  1.6813  1.6739  1.6675  1.6604  1.6532  1.6463  1.6391  1.6320  1.6247  1.6176  1.6102  1.6034  1.5963  1.5892  1.5823  1.5748  1.5676  1.5606  1.5536  1.5460  1.5389  1.5314  1.5239  1.5166  1.5094  1.5018  1.4943  1.4863  1.4793  1.4719  1.4648  1.4576  1.4499  1.4426  1.4355  1.4284  1.4210  1.4138  1.4064  1.3988  1.3915  1.3839  1.3765  1.3691  1.3617  1.3541  1.3461  1.3384  1.3306  1.3237  1.3159  1.3082  1.3007  1.2931  1.2850  1.2773  1.2698  1.2622  1.2542  1.2461  1.2384  1.2313  1.2234  1.2157  1.2083  1.2007  1.1930  1.1847  1.1775  1.1696  1.1615  1.1542  1.1460  1.1378  1.1298  1.1216  1.1133  1.1048  1.0966  1.0884  1.0796  1.0718  1.0636  1.0556  1.0470  1.0395  1.0309  1.0219  1.0140  1.0055  0.9976  0.9886  0.9816  0.9730  0.9648  0.9565  0.9483  0.9394  0.9309  0.9228  0.9147  0.9060  0.8978  0.8886  0.8797
 2.2708  2.2660  2.2609  2.2560  2.2509  2.2455  2.2405  2.2346  2.2294  2.2243  2.2183  2.2128  2.2076  2.2014  2.1948  2.1888  2.1827  2.1769  2.1716  2.1658  2.1599  2.1539  2.1484  2.1426  2.1367  2.1307  2.1249  2.1185  2.1126  2.1068  2.1009  2.0945  2.0884  2.0818  2.0758  2.0699  2.0636  2.0578  2.0513  2.0459  2.0397  2.0339  2.0281  2.0221  2.0159  2.0101  2.0037  1.9977  1.9917  1.9853  1.9788  1.9725  1.9653  1.9583  1.9523  1.9457  1.9393  1.9329  1.9260  1.9195  1.9130  1.9064  1.8996  1.8933  1.8865  1.8797  1.8735  1.8674  1.8607  1.8540  1.8474  1.8406  1.8342  1.8273  1.8206  1.8139  1.8075  1.8009  1.7939  1.7875  1.7810  1.7740  1.7671  1.7596  1.7528  1.7459  1.7389  1.7322  1.7248  1.7178  1.7106  1.7033  1.6964  1.6894  1.6819  1.6748  1.6680  1.6608  1.6536  1.6463  1.6387  1.6316  1.6243  1.6171  1.6095  1.6025  1.5951  1.5876  1.5806  1.5729  1.5655  1.5580  1.5504  1.5424  1.5352  1.5280  1.5208  1.5133  1.5060  1.4979  1.4898  1.4822  1.4746  1.4672  1.4602  1.4526  1.4449  1.4372  1.4301  1.4226  1.4148  1.4069  1.3994  1.3920  1.3842  1.3768  1.3688  1.3607  1.3526  1.3444  1.3367  1.3285  1.3202  1.3126  1.3050  1.2972  1.2893  1.2819  1.2741  1.2663  1.2583  1.2503  1.2416  1.2335  1.2256  1.2177  1.2097  1.2017  1.1933  1.1851  1.1765  1.1681  1.1602  1.1525  1.1443  1.1357  1.1275  1.1193  1.1111  1.1024  1.0941  1.0861  1.0773  1.0696  1.0615  1.0524  1.0442  1.0357  1.0268  1.0185  1.0096  1.0006  0.9917  0.9831  0.9753  0.9666  0.9581  0.9501  0.9413  0.9321  0.9241  0.9166  0.9071  0.8990  0.8904  0.8813  0.8726  0.8626  0.8538
 2.2823  2.2763  2.2707  2.2653  2.2596  2.2543  2.2483  2.2428  2.2377  2.2313  2.2258  2.2204  2.2151  2.2094  2.2041  2.1985  2.1926  2.1868  2.1811  2.1757  2.1699  2.1640  2.1585  2.1522  2.1463  2.1400  2.1336  2.1274  2.1214  2.1155  2.1100  2.1040  2.0980  2.0918  2.0861  2.0802  2.0739  2.0674  2.0614  2.0557  2.0491  2.0429  2.0365  2.0305  2.0245  2.0183  2.0118  2.0058  1.9997  1.9932  1.9866  1.9801  1.9734  1.9668  1.9603  1.9540  1.9475  1.9410  1.9342  1.9278  1.9211  1.9144  1.9077  1.9010  1.8941  1.8873  1.8806  1.8739  1.8676  1.8611  1.8544  1.8477  1.8413  1.8347  1.8282  1.8210  1.8141  1.8070  1.7999  1.7931  1.7860  1.7788  1.7709  1.7634  1.7561  1.7492  1.7423  1.7349  1.7274  1.7201  1.7129  1.7055  1.6982  1.6906  1.6830  1.6756  1.6686  1.6611  1.6537  1.6463  1.6385  1.6307  1.6234  1.6162  1.6085  1.6009  1.5937  1.5862  1.5786  1.5711  1.5631  1.5556  1.5474  1.5398  1.5321  1.5240  1.5158  1.5078  1.4999  1.4924  1.4847  1.4774  1.4693  1.4622  1.4544  1.4466  1.4390  1.4310  1.4230  1.4150  1.4069  1.3991  1.3914  1.3836  1.3755  1.3678  1.3597  1.3517  1.3441  1.3356  1.3274  1.3188  1.3110  1.3030  1.2952  1.2871  1.2784  1.2698  1.2613  1.2528  1.2444  1.2362  1.2274  1.2189  1.2100  1.2023  1.1942  1.1865  1.1781  1.1699  1.1616  1.1533  1.1446  1.1360  1.1283  1.1196  1.1114  1.1030  1.0944  1.0858  1.0778  1.0687  1.0600  1.0513  1.0425  1.0336  1.0249  1.0162  1.0074  0.9987  0.9897  0.9807  0.9725  0.9630  0.9544  0.9450  0.9361  0.9277  0.9196  0.9111  0.9019  0.8922  0.8841  0.8748  0.8657  0.8571  0.8479  0.8379  0.8287
 2.2931  2.2881  2.2828  2.2777  2.2729  2.2676  2.2617  2.2562  2.2507  2.2448  2.2393  2.2340  2.2287  2.2229  2.2169  2.2107  2.2050  2.1990  2.1934  2.1876  2.1816  2.1762  2.1704  2.1643  2.1584  2.1528  2.1464  2.1406  2.1344  2.1283  2.1223  2.1157  2.1091  2.1023  2.0963  2.0903  2.0839  2.0773  2.0713  2.0654  2.0587  2.0526  2.0462  2.0399  2.0338  2.0273  2.0204  2.0145  2.0077  2.0013  1.9946  1.9882  1.9817  1.9752  1.9685  1.9621  1.9553  1.9483  1.9413  1.9345  1.9275  1.9209  1.9140  1.9069  1.9002  1.8936  1.8866  1.8801  1.8731  1.8656  1.8590  1.8523  1.8453  1.8386  1.8319  1.8251  1.8175  1.8098  1.8028  1.7958  1.7886  1.7814  1.7746  1.7669  1.7594  1.7521  1.7447  1.7376  1.7299  1.7225  1.7148  1.7074  1.6993  1.6913  1.6838  1.6764  1.6689  1.6616  1.6540  1.6463  1.6383  1.6305  1.6229  1.6152  1.6073  1.5998  1.5920  1.5845  1.5766  1.5690  1.5609  1.5525  1.5448  1.5366  1.5285  1.5204  1.5119  1.5044  1.4964  1.4887  1.4804  1.4724  1.4646  1.4570  1.4489  1.4411  1.4331  1.4249  1.4170  1.4090  1.4011  1.3928  1.3849  1.3768  1.3680  1.3600  1.3519  1.3437  1.3355  1.3271  1.3189  1.3114  1.3029  1.2938  1.2851  1.2770  1.2686  1.2597  1.2511  1.2422  1.2341  1.2261  1.2174  1.2086  1.2004  1.1918  1.1834  1.1751  1.1666  1.1577  1.1489  1.1402  1.1314  1.1232  1.1141  1.1055  1.0966  1.0880  1.0788  1.0698  1.0607  1.0517  1.0425  1.0332  1.0242  1.0152  1.0068  0.9974  0.9886  0.9793  0.9704  0.9610  0.9517  0.9427  0.9332  0.9236  0.9143  0.9050  0.8955  0.8867  0.8775  0.8684  0.8594  0.8501  0.8406  0.8313  0.8218  0.8117  0.8021
 2.3069  2.3021  2.2967  2.2908  2.2858  2.2807  2.2753  2.2701  2.2646  2.2597  2.2546  2.2480  2.2425  2.2361  2.2301  2.2239  2.2177  2.2120  2.2056  2.1992  2.1932  2.1877  2.1814  2.1755  2.1696  2.1628  2.1566  2.1501  2.1441  2.1374  2.1312  2.1253  2.1189  2.1126  2.1063  2.0998  2.0935  2.0873  2.0810  2.0743  2.0681  2.0614  2.0550  2.0486  2.0421  2.0359  2.0295  2.0229  2.0161  2.0099  2.0031  1.9956  1.9888  1.9816  1.9745  1.9678  1.9612  1.9539  1.9467  1.9398  1.9329  1.9257  1.9186  1.9114  1.9043  1.8973  1.8908  1.8840  1.8770  1.8694  1.8627  1.8556  1.8487  1.8415  1.8347  1.8280  1.8205  1.8134  1.8059  1.7982  1.7907  1.7834  1.7758  1.7683  1.7609  1.7538  1.7466  1.7394  1.7318  1.7236  1.7164  1.7085  1.7008  1.6927  1.6848  1.6772  1.6697  1.6621  1.6542  1.6463  1.6382  1.6303  1.6226  1.6148  1.6068  1.5985  1.5909  1.5830  1.5750  1.5666  1.5585  1.5506  1.5423  1.5342  1.5256  1.5173  1.5091  1.5008  1.4927  1.4844  1.4761  1.4678  1.4595  1.4513  1.4430  1.4348  1.4263  1.4180  1.4099  1.4015  1.3928  1.3846  1.3761  1.3674  1.3594  1.3510  1.3428  1.3348  1.3265  1.3181  1.3093  1.3005  1.2923  1.2839  1.2752  1.2666  1.2582  1.2494  1.2408  1.2318  1.2233  1.2146  1.2063  1.1972  1.1875  1.1781  1.1694  1.1607  1.1521  1.1439  1.1351  1.1265  1.1170  1.1080  1.0988  1.0898  1.0808  1.0716  1.0629  1.0535  1.0450  1.0356  1.0263  1.0169  1.0078  0.9984  0.9898  0.9802  0.9708  0.9609  0.9509  0.9419  0.9325  0.9226  0.9126  0.9031  0.8929  0.8835  0.8738  0.8642  0.8542  0.8450  0.8350  0.8247  0.8149  0.8052  0.7963  0.7856  0.7755
 2.3169  2.3125  2.3071  2.3010  2.2950  2.2907  2.2846  2.2784  2.2730  2.2674  2.2612  2.2562  2.2505  2.2447  2.2387  2.2329  2.2276  2.2214  2.2159  2.2101  2.2043  2.1981  2.1919  2.1855  2.1794  2.1732  2.1666  2.1605  2.1543  2.1478  2.1415  2.1349  2.1286  2.1223  2.1157  2.1090  2.1021  2.0955  2.0885  2.0819  2.0755  2.0686  2.0623  2.0555  2.0489  2.0421  2.0352  2.0288  2.0227  2.0158  2.0084  2.0021  1.9950  1.9873  1.9801  1.9735  1.9664  1.9593  1.9526  1.9456  1.9384  1.9312  1.9243  1.9168  1.9094  1.9026  1.8957  1.8892  1.8822  1.8751  1.8677  1.8609  1.8536  1.8465  1.8391  1.8318  1.8247  1.8173  1.8097  1.8023  1.7948  1.7873  1.7795  1.7715  1.7637  1.7560  1.7485  1.7406  1.7332  1.7252  1.7172  1.7090  1.7011  1.6931  1.6854  1.6775  1.6699  1.6622  1.6545  1.6463  1.6380  1.6304  1.6223  1.6140  1.6059  1.5975  1.5894  1.5812  1.5732  1.5648  1.5561  1.5481  1.5397  1.5313  1.5228  1.5145  1.5062  1.4978  1.4890  1.4807  1.4729  1.4644  1.4556  1.4471  1.4389  1.4303  1.4218  1.4128  1.4042  1.3955  1.3870  1.3785  1.3695  1.3613  1.3529  1.3440  1.3358  1.3270  1.3184  1.3098  1.3009  1.2927  1.2840  1.2746  1.2654  1.2570  1.2481  1.2390  1.2300  1.2214  1.2123  1.2037  1.1951  1.1865  1.1774  1.1682  1.1588  1.1488  1.1397  1.1306  1.1214  1.1123  1.1033  1.0941  1.0849  1.0757  1.0664  1.0564  1.0470  1.0374  1.0281  1.0182  1.0085  0.9989  0.9896  0.9799  0.9710  0.9616  0.9526  0.9426  0.9328  0.9230  0.9134  0.9038  0.8935  0.8840  0.8739  0.8645  0.8536  0.8434  0.8336  0.8241  0.8136  0.8036  0.7937  0.7831  0.7731  0.7628  0.7537
 2.3290  2.3229  2.3185  2.3122  2.3060  2.3009  2.2959  2.2906  2.2847  2.2787  2.2734  2.2669  2.2608  2.2555  2.2492  2.2426  2.2364  2.2299  2.2244  2.2188  2.2118  2.2054  2.1992  2.1929  2.1866  2.1806  2.1747  2.1684  2.1623  2.1556  2.1490  2.1428  2.1367  2.1309  2.1244  2.1175  2.1112  2.1048  2.0984  2.0917  2.0853  2.0787  2.0720  2.0650  2.0578  2.0504  2.0436  2.0367  2.0301  2.0232  2.0157  2.0086  2.0014  1.9943  1.9873  1.9799  1.9724  1.9660  1.9589  1.9515  1.9444  1.9374  1.9304  1.9234  1.9157  1.9085  1.9011  1.8936  1.8862  1.8789  1.8716  1.8642  1.8569  1.8492  1.8417  1.8341  1.8264  1.8189  1.8121  1.8048  1.7967  1.7885  1.7808  1.7730  1.7651  1.7571  1.7498  1.7417  1.7337  1.7257  1.7178  1.7103  1.7023  1.6944  1.6864  1.6779  1.6701  1.6622  1.6547  1.6463  1.6378  1.6298  1.6220  1.6137  1.6051  1.5967  1.5887  1.5805  1.5716  1.5630  1.5543  1.5462  1.5375  1.5290  1.5210  1.5121  1.5034  1.4947  1.4861  1.4774  1.4684  1.4602  1.4521  1.4437  1.4348  1.4259  1.4172  1.4087  1.4000  1.3908  1.3819  1.3733  1.3644  1.3556  1.3470  1.3381  1.3289  1.3203  1.3112  1.3019  1.2929  1.2839  1.2750  1.2659  1.2572  1.2475  1.2380  1.2289  1.2197  1.2108  1.2020  1.1932  1.1836  1.1746  1.1655  1.1558  1.1462  1.1364  1.1268  1.1176  1.1082  1.0988  1.0897  1.0802  1.0713  1.0615  1.0521  1.0426  1.0326  1.0227  1.0130  1.0031  0.9931  0.9834  0.9740  0.9638  0.9542  0.9444  0.9352  0.9253  0.9153  0.9048  0.8950  0.8851  0.8746  0.8646  0.8538  0.8435  0.8334  0.8234  0.8124  0.8021  0.7919  0.7816  0.7720  0.7618  0.7514  0.7414  0.7308
 2.3413  2.3357  2.3305  2.3250  2.3195  2.3128  2.3068  2.3011  2.2941  2.2882  2.2830  2.2770  2.2706  2.2649  2.2594  2.2533  2.2474  2.2419  2.2351  2.2290  2.2225  2.2165  2.2100  2.2036  2.1977  2.1915  2.1846  2.1779  2.1719  2.1655  2.1588  2.1523  2.1454  2.1395  2.1333  2.1264  2.1197  2.1125  2.1059  2.0993  2.0929  2.0864  2.0793  2.0719  2.0649  2.0581  2.0511  2.0437  2.0360  2.0292  2.0222  2.0152  2.0082  2.0012  1.9941  1.9867  1.9795  1.9724  1.9653  1.9582  1.9508  1.9435  1.9362  1.9291  1.9217  1.9143  1.9071  1.8996  1.8923  1.8849  1.8771  1.8701  1.8625  1.8546  1.8469  1.8395  1.8315  1.8237  1.8161  1.8083  1.8003  1.7918  1.7838  1.7759  1.7678  1.7599  1.7519  1.7434  1.7357  1.7280  1.7196  1.7118  1.7036  1.6953  1.6869  1.6789  1.6709  1.6626  1.6548  1.6463  1.6376  1.6297  1.6212  1.6126  1.6044  1.5959  1.5878  1.5791  1.5704  1.5621  1.5535  1.5445  1.5359  1.5265  1.5180  1.5093  1.5006  1.4914  1.4825  1.4738  1.4650  1.4560  1.4468  1.4377  1.4289  1.4205  1.4116  1.4024  1.3934  1.3842  1.3750  1.3664  1.3570  1.3479  1.3387  1.3300  1.3211  1.3118  1.3023  1.2930  1.2837  1.2744  1.2650  1.2560  1.2465  1.2376  1.2280  1.2181  1.2089  1.1995  1.1898  1.1803  1.1705  1.1610  1.1514  1.1413  1.1319  1.1226  1.1129  1.1035  1.0943  1.0850  1.0754  1.0660  1.0557  1.0461  1.0367  1.0270  1.0169  1.0068  0.9968  0.9868  0.9771  0.9671  0.9576  0.9473  0.9376  0.9270  0.9166  0.9066  0.8963  0.8858  0.8757  0.8648  0.8548  0.8450  0.8346  0.8240  0.8134  0.8026  0.7924  0.7819  0.7706  0.7604  0.7506  0.7399  0.7295  0.7186  0.7078
 2.3527  2.3471  2.3402  2.3341  2.3284  2.3227  2.3169  2.3114  2.3054  2.3000  2.2938  2.2879  2.2821  2.2764  2.2706  2.2647  2.2583  2.2521  2.2457  2.2394  2.2329  2.2267  2.2210  2.2146  2.2080  2.2017  2.1952  2.1889  2.1826  2.1756  2.1690  2.1621  2.1553  2.1490  2.1422  2.1358  2.1284  2.1210  2.1144  2.1073  2.1001  2.0931  2.0856  2.0789  2.0716  2.0653  2.0584  2.0514  2.0442  2.0371  2.0300  2.0226  2.0149  2.0080  2.0008  1.9935  1.9862  1.9790  1.9715  1.9643  1.9566  1.9488  1.9413  1.9336  1.9261  1.9183  1.9109  1.9034  1.8960  1.8881  1.8805  1.8727  1.8648  1.8571  1.8495  1.8416  1.8339  1.8260  1.8187  1.8102  1.8024  1.7943  1.7865  1.7789  1.7704  1.7620  1.7542  1.7455  1.7376  1.7296  1.7213  1.7138  1.7055  1.6968  1.6885  1.6800  1.6719  1.6633  1.6550  1.6463  1.6376  1.6291  1.6207  1.6120  1.6031  1.5943  1.5857  1.5773  1.5684  1.5593  1.5503  1.5415  1.5325  1.5239  1.5138  1.5050  1.4965  1.4878  1.4786  1.4695  1.4607  1.4517  1.4426  1.4335  1.4243  1.4151  1.4055  1.3969  1.3881  1.3786  1.3696  1.3605  1.3510  1.3416  1.3326  1.3228  1.3133  1.3043  1.2947  1.2849  1.2756  1.2661  1.2570  1.2470  1.2377  1.2282  1.2183  1.2086  1.1993  1.1902  1.1808  1.1708  1.1610  1.1518  1.1423  1.1319  1.1223  1.1119  1.1018  1.0917  1.0819  1.0721  1.0628  1.0527  1.0421  1.0319  1.0218  1.0121  1.0022  0.9919  0.9815  0.9715  0.9618  0.9515  0.9409  0.9303  0.9202  0.9089  0.8980  0.8881  0.8776  0.8666  0.8562  0.8457  0.8354  0.8248  0.8143  0.8040  0.7931  0.7830  0.7718  0.7606  0.7495  0.7381  0.7276  0.7173  0.7058  0.6942  0.6822
 2.3627  2.3571  2.3521  2.3465  2.3405  2.3349  2.3289  2.3224  2.3164  2.3103  2.3049  2.2987  2.2931  2.2872  2.2808  2.2747  2.2685  2.2621  2.2559  2.2497  2.2437  2.2371  2.2306  2.2239  2.2175  2.2107  2.2043  2.1975  2.1911  2.1849  2.1779  2.1712  2.1641  2.1573  2.1508  2.1446  2.1376  2.1307  2.1235  2.1164  2.1093  2.1019  2.0950  2.0881  2.0806  2.0740  2.0666  2.0597  2.0527  2.0452  2.0381  2.0305  2.0233  2.0162  2.0084  2.0013  1.9938  1.9863  1.9784  1.9707  1.9630  1.9558  1.9482  1.9403  1.9321  1.9245  1.9163  1.9083  1.9008  1.8932  1.8856  1.8775  1.8696  1.8616  1.8538  1.8459  1.8381  1.8305  1.8225  1.8144  1.8061  1.7981  1.7902  1.7821  1.7737  1.7651  1.7569  1.7483  1.7401  1.7317  1.7234  1.7152  1.7065  1.6980  1.6893  1.6806  1.6723  1.6635  1.6551  1.6463  1.6377  1.6289  1.6201  1.6114  1.6027  1.5936  1.5845  1.5759  1.5672  1.5583  1.5494  1.5408  1.5312  1.5215  1.5119  1.5030  1.4934  1.4841  1.4750  1.4659  1.4567  1.4479  1.4384  1.4293  1.4203  1.4109  1.4015  1.3920  1.3826  1.3733  1.3643  1.3548  1.3445  1.3349  1.3251  1.3157  1.3061  1.2966  1.2878  1.2781  1.2679  1.2580  1.2482  1.2386  1.2289  1.2188  1.2091  1.1989  1.1893  1.1795  1.1699  1.1600  1.1497  1.1402  1.1302  1.1202  1.1106  1.1012  1.0912  1.0807  1.0706  1.0605  1.0503  1.0401  1.0298  1.0195  1.0091  0.9986  0.9884  0.9783  0.9683  0.9576  0.9469  0.9365  0.9264  0.9157  0.9050  0.8942  0.8837  0.8731  0.8622  0.8514  0.8404  0.8290  0.8179  0.8078  0.7974  0.7861  0.7747  0.7635  0.7528  0.7416  0.7308  0.7198  0.7086  0.6979  0.6871  0.6753  0.6641
 2.3694  2.3644  2.3588  2.3526  2.3465  2.3419  2.3363  2.3308  2.3239  2.3185  2.3130  2.3069  2.3007  2.2947  2.2882  2.2822  2.2759  2.2697  2.2634  2.2570  2.2504  2.2441  2.2377  2.2312  2.2247  2.2180  2.2116  2.2049  2.1977  2.1907  2.1838  2.1771  2.1705  2.1633  2.1565  2.1500  2.1433  2.1363  2.1296  2.1222  2.1145  2.1077  2.1005  2.0933  2.0862  2.0792  2.0723  2.0653  2.0581  2.0512  2.0435  2.0358  2.0284  2.0207  2.0133  2.0059  1.9981  1.9906  1.9831  1.9755  1.9675  1.9599  1.9523  1.9444  1.9366  1.9288  1.9209  1.9131  1.9051  1.8976  1.8893  1.8811  1.8731  1.8651  1.8571  1.8490  1.8407  1.8329  1.8245  1.8165  1.8083  1.7999  1.7916  1.7834  1.7756  1.7670  1.7587  1.7500  1.7416  1.7328  1.7244  1.7156  1.7076  1.6988  1.6902  1.6815  1.6729  1.6641  1.6553  1.6463  1.6376  1.6286  1.6197  1.6106  1.6013  1.5923  1.5836  1.5747  1.5653  1.5561  1.5469  1.5377  1.5280  1.5187  1.5098  1.5007  1.4911  1.4812  1.4720  1.4633  1.4539  1.4444  1.4351  1.4259  1.4163  1.4067  1.3972  1.3874  1.3778  1.3684  1.3592  1.3497  1.3401  1.3304  1.3207  1.3114  1.3021  1.2918  1.2821  1.2719  1.2618  1.2518  1.2417  1.2321  1.2220  1.2115  1.2019  1.1915  1.1815  1.1716  1.1614  1.1514  1.1419  1.1316  1.1211  1.1112  1.1010  1.0912  1.0815  1.0708  1.0609  1.0501  1.0401  1.0291  1.0187  1.0081  0.9979  0.9873  0.9768  0.9659  0.9556  0.9446  0.9340  0.9229  0.9119  0.9015  0.8904  0.8793  0.8688  0.8578  0.8467  0.8356  0.8243  0.8135  0.8021  0.7913  0.7802  0.7690  0.7574  0.7463  0.7352  0.7240  0.7134  0.7017  0.6913  0.6796  0.6683  0.6570  0.6460
 2.3785  2.3730  2.3676  2.3612  2.3557  2.3505  2.3450  2.3393  2.3338  2.3277  2.3219  2.3159  2.3096  2.3030  2.2972  2.2907  2.2841  2.2775  2.2712  2.2653  2.2591  2.2528  2.2462  2.2395  2.2329  2.2261  2.2194  2.2128  2.2059  2.1989  2.1919  2.1849  2.1784  2.1716  2.1650  2.1581  2.1513  2.1440  2.1376  2.1306  2.1232  2.1162  2.1088  2.1019  2.0945  2.0872  2.0794  2.0719  2.0648  2.0573  2.0497  2.0422  2.0343  2.0262  2.0184  2.0114  2.0037  1.9966  1.9887  1.9809  1.9726  1.9645  1.9564  1.9485  1.9411  1.9330  1.9249  1.9169  1.9084  1.9005  1.8928  1.8850  1.8771  1.8688  1.8607  1.8525  1.8444  1.8358  1.8274  1.8193  1.8106  1.8028  1.7942  1.7857  1.7772  1.7688  1.7604  1.7520  1.7436  1.7350  1.7264  1.7180  1.7093  1.7003  1.6918  1.6825  1.6736  1.6647  1.6556  1.6463  1.6374  1.6284  1.6193  1.6101  1.6009  1.5917  1.5821  1.5727  1.5633  1.5542  1.5447  1.5357  1.5263  1.5173  1.5079  1.4985  1.4890  1.4791  1.4695  1.4599  1.4503  1.4411  1.4314  1.4215  1.4118  1.4021  1.3923  1.3828  1.3730  1.3632  1.3536  1.3437  1.3338  1.3239  1.3139  1.3039  1.2939  1.2845  1.2741  1.2644  1.2544  1.2445  1.2340  1.2248  1.2147  1.2044  1.1943  1.1836  1.1732  1.1631  1.1523  1.1415  1.1309  1.1212  1.1105  1.1001  1.0900  1.0796  1.0692  1.0590  1.0488  1.0377  1.0275  1.0166  1.0059  0.9952  0.9839  0.9734  0.9628  0.9517  0.9404  0.9295  0.9189  0.9078  0.8968  0.8864  0.8749  0.8638  0.8535  0.8424  0.8309  0.8200  0.8091  0.7981  0.7868  0.7753  0.7639  0.7520  0.7407  0.7286  0.7173  0.7063  0.6952  0.6841  0.6723  0.6613  0.6494  0.6377  0.6266
 2.3861  2.3810  2.3756  2.3703  2.3641  2.3582  2.3524  2.3467  2.3411  2.3354  2.3295  2.3234  2.3173  2.3111  2.3049  2.2982  2.2912  2.2854  2.2796  2.2732  2.2666  2.2602  2.2535  2.2470  2.2408  2.2345  2.2276  2.2210  2.2142  2.2073  2.2002  2.1934  2.1857  2.1787  2.1717  2.1644  2.1578  2.1514  2.1441  2.1362  2.1288  2.1217  2.1145  2.1074  2.1006  2.0934  2.0861  2.0785  2.0709  2.0630  2.0552  2.0477  2.0402  2.0327  2.0252  2.0174  2.0095  2.0013  1.9934  1.9854  1.9773  1.9691  1.9615  1.9529  1.9451  1.9369  1.9288  1.9205  1.9118  1.9038  1.8956  1.8873  1.8792  1.8714  1.8631  1.8547  1.8465  1.8386  1.8305  1.8223  1.8140  1.8054  1.7968  1.7880  1.7794  1.7706  1.7624  1.7539  1.7449  1.7358  1.7273  1.7188  1.7098  1.7011  1.6918  1.6827  1.6738  1.6647  1.6559  1.6463  1.6372  1.6282  1.6188  1.6097  1.6002  1.5908  1.5816  1.5722  1.5631  1.5535  1.5439  1.5344  1.5251  1.5152  1.5057  1.4957  1.4858  1.4759  1.4658  1.4567  1.4469  1.4372  1.4274  1.4174  1.4075  1.3979  1.3878  1.3778  1.3683  1.3583  1.3483  1.3384  1.3285  1.3188  1.3091  1.2991  1.2889  1.2779  1.2681  1.2579  1.2476  1.2371  1.2267  1.2166  1.2061  1.1959  1.1856  1.1751  1.1647  1.1541  1.1438  1.1333  1.1226  1.1119  1.1015  1.0907  1.0797  1.0693  1.0595  1.0486  1.0373  1.0263  1.0156  1.0052  0.9947  0.9834  0.9726  0.9617  0.9512  0.9400  0.9290  0.9183  0.9068  0.8957  0.8849  0.8731  0.8615  0.8497  0.8382  0.8267  0.8159  0.8042  0.7936  0.7820  0.7712  0.7601  0.7489  0.7379  0.7263  0.7148  0.7036  0.6916  0.6811  0.6686  0.6572  0.6453  0.6347  0.6227  0.6108
 2.3917  2.3879  2.3824  2.3775  2.3717  2.3662  2.3610  2.3547  2.3487  2.3428  2.3368  2.3312  2.3251  2.3190  2.3135  2.3071  2.3014  2.2944  2.2884  2.2818  2.2749  2.2679  2.2611  2.2544  2.2480  2.2408  2.2340  2.2264  2.2198  2.2133  2.2062  2.1993  2.1926  2.1863  2.1788  2.1710  2.1644  2.1572  2.1499  2.1426  2.1351  2.1275  2.1200  2.1126  2.1054  2.0974  2.0901  2.0825  2.0752  2.0671  2.0599  2.0526  2.0452  2.0374  2.0291  2.0217  2.0134  2.0060  1.9978  1.9898  1.9814  1.9731  1.9645  1.9563  1.9481  1.9401  1.9322  1.9238  1.9153  1.9071  1.8991  1.8910  1.8831  1.8751  1.8664  1.8579  1.8493  1.8408  1.8325  1.8240  1.8150  1.8067  1.7980  1.7894  1.7804  1.7717  1.7632  1.7546  1.7457  1.7368  1.7274  1.7181  1.7095  1.7005  1.6920  1.6832  1.6742  1.6652  1.6561  1.6463  1.6370  1.6277  1.6183  1.6088  1.5991  1.5898  1.5804  1.5706  1.5606  1.5510  1.5414  1.5314  1.5214  1.5116  1.5016  1.4915  1.4822  1.4719  1.4622  1.4529  1.4429  1.4330  1.4234  1.4138  1.4041  1.3937  1.3840  1.3735  1.3635  1.3537  1.3434  1.3332  1.3230  1.3133  1.3030  1.2928  1.2827  1.2721  1.2620  1.2521  1.2418  1.2311  1.2205  1.2101  1.1995  1.1893  1.1783  1.1677  1.1575  1.1471  1.1361  1.1252  1.1140  1.1036  1.0926  1.0815  1.0707  1.0603  1.0488  1.0378  1.0271  1.0160  1.0054  0.9942  0.9829  0.9713  0.9605  0.9493  0.9382  0.9275  0.9164  0.9053  0.8945  0.8829  0.8718  0.8609  0.8495  0.8371  0.8256  0.8142  0.8031  0.7915  0.7805  0.7694  0.7583  0.7465  0.7350  0.7231  0.7113  0.6996  0.6882  0.6768  0.6655  0.6543  0.6435  0.6322  0.6209  0.6083  0.5979
 2.3983  2.3934  2.3874  2.3817  2.3755  2.3704  2.3655  2.3603  2.3548  2.3485  2.3426  2.3367  2.3304  2.3245  2.3188  2.3129  2.3070  2.3002  2.2935  2.2872  2.2804  2.2739  2.2674  2.2610  2.2544  2.2471  2.2397  2.2328  2.2260  2.2195  2.2130  2.2062  2.1989  2.1920  2.1847  2.1776  2.1710  2.1635  2.1563  2.1490  2.1417  2.1342  2.1269  2.1197  2.1124  2.1049  2.0976  2.0900  2.0822  2.0743  2.0664  2.0592  2.0513  2.0434  2.0353  2.0276  2.0201  2.0120  2.0037  1.9956  1.9868  1.9783  1.9698  1.9616  1.9529  1.9448  1.9364  1.9280  1.9196  1.9113  1.9032  1.8951  1.8867  1.8788  1.8702  1.8622  1.8536  1.8447  1.8359  1.8270  1.8186  1.8097  1.8011  1.7924  1.7837  1.7752  1.7662  1.7570  1.7478  1.7387  1.7293  1.7200  1.7112  1.7018  1.6927  1.6836  1.6744  1.6654  1.6562  1.6463  1.6370  1.6273  1.6177  1.6084  1.5985  1.5891  1.5793  1.5692  1.5592  1.5494  1.5396  1.5298  1.5203  1.5101  1.4999  1.4903  1.4811  1.4712  1.4609  1.4514  1.4417  1.4315  1.4212  1.4110  1.4010  1.3912  1.3809  1.3704  1.3595  1.3494  1.3395  1.3292  1.3185  1.3077  1.2969  1.2866  1.2763  1.2655  1.2550  1.2444  1.2342  1.2239  1.2132  1.2022  1.1917  1.1817  1.1713  1.1603  1.1494  1.1386  1.1276  1.1168  1.1061  1.0955  1.0849  1.0741  1.0627  1.0514  1.0403  1.0293  1.0178  1.0070  0.9952  0.9840  0.9731  0.9616  0.9505  0.9398  0.9283  0.9171  0.9060  0.8951  0.8828  0.8711  0.8595  0.8480  0.8368  0.8251  0.8135  0.8020  0.7901  0.7791  0.7676  0.7553  0.7439  0.7322  0.7205  0.7089  0.6971  0.6855  0.6741  0.6623  0.6506  0.6394  0.6273  0.6160  0.6045  0.5935  0.5826
 2.4053  2.3992  2.3941  2.3883  2.3831  2.3777  2.3722  2.3659  2.3602  2.3539  2.3479  2.3423  2.3358  2.3300  2.3245  2.3188  2.3126  2.3065  2.3003  2.2937  2.2870  2.2808  2.2746  2.2676  2.2607  2.2541  2.2478  2.2408  2.2339  2.2275  2.2209  2.2139  2.2069  2.1997  2.1927  2.1852  2.1779  2.1707  2.1632  2.1558  2.1488  2.1415  2.1343  2.1269  2.1195  2.1120  2.1037  2.0963  2.0884  2.0805  2.0727  2.0644  2.0565  2.0485  2.0407  2.0332  2.0249  2.0167  2.0083  1.9996  1.9918  1.9836  1.9752  1.9673  1.9589  1.9508  1.9428  1.9344  1.9252  1.9163  1.9076  1.8991  1.8906  1.8821  1.8733  1.8645  1.8558  1.8476  1.8389  1.8300  1.8209  1.8121  1.8031  1.7942  1.7853  1.7764  1.7675  1.7579  1.7488  1.7393  1.7301  1.7207  1.7114  1.7022  1.6931  1.6840  1.6747  1.6656  1.6561  1.6463  1.6369  1.6271  1.6175  1.6080  1.5976  1.5883  1.5782  1.5686  1.5588  1.5491  1.5395  1.5297  1.5196  1.5092  1.4994  1.4895  1.4797  1.4695  1.4590  1.4489  1.4387  1.4286  1.4186  1.4076  1.3979  1.3877  1.3773  1.3667  1.3561  1.3458  1.3354  1.3248  1.3140  1.3037  1.2931  1.2827  1.2720  1.2610  1.2507  1.2396  1.2290  1.2182  1.2073  1.1967  1.1858  1.1745  1.1634  1.1527  1.1418  1.1307  1.1196  1.1085  1.0975  1.0865  1.0752  1.0637  1.0528  1.0424  1.0317  1.0206  1.0100  0.9987  0.9875  0.9766  0.9652  0.9541  0.9426  0.9315  0.9200  0.9087  0.8974  0.8856  0.8738  0.8629  0.8511  0.8401  0.8286  0.8166  0.8046  0.7934  0.7815  0.7698  0.7582  0.7462  0.7342  0.7218  0.7106  0.6987  0.6867  0.6746  0.6629  0.6509  0.6392  0.6271  0.6157  0.6044  0.5929  0.5819  0.5698
 2.4153  2.4089  2.4029  2.3978  2.3925  2.3867  2.3812  2.3756  2.3698  2.3635  2.3566  2.3505  2.3442  2.3383  2.3325  2.3267  2.3201  2.3135  2.3067  2.3006  2.2941  2.2873  2.2810  2.2747  2.2675  2.2607  2.2545  2.2476  2.2412  2.2338  2.2268  2.2197  2.2125  2.2051  2.1982  2.1910  2.1832  2.1759  2.1684  2.1611  2.1542  2.1471  2.1396  2.1316  2.1244  2.1164  2.1088  2.1010  2.0935  2.0857  2.0779  2.0699  2.0617  2.0536  2.0453  2.0370  2.0290  2.0206  2.0122  2.0037  1.9955  1.9871  1.9785  1.9703  1.9616  1.9530  1.9443  1.9360  1.9275  1.9191  1.9108  1.9024  1.8937  1.8850  1.8762  1.8678  1.8584  1.8500  1.8410  1.8321  1.8229  1.8143  1.8053  1.7961  1.7870  1.7775  1.7685  1.7591  1.7500  1.7409  1.7314  1.7221  1.7127  1.7033  1.6935  1.6840  1.6753  1.6654  1.6562  1.6463  1.6369  1.6272  1.6172  1.6074  1.5975  1.5881  1.5780  1.5682  1.5581  1.5476  1.5377  1.5274  1.5172  1.5070  1.4966  1.4867  1.4767  1.4661  1.4557  1.4450  1.4344  1.4245  1.4141  1.4034  1.3933  1.3833  1.3730  1.3623  1.3518  1.3414  1.3310  1.3203  1.3095  1.2989  1.2884  1.2773  1.2667  1.2562  1.2454  1.2343  1.2237  1.2130  1.2023  1.1909  1.1806  1.1695  1.1581  1.1473  1.1364  1.1254  1.1145  1.1032  1.0923  1.0813  1.0694  1.0583  1.0465  1.0349  1.0237  1.0126  1.0007  0.9894  0.9779  0.9666  0.9552  0.9433  0.9323  0.9213  0.9106  0.8989  0.8874  0.8759  0.8641  0.8525  0.8403  0.8289  0.8168  0.8054  0.7933  0.7812  0.7692  0.7572  0.7449  0.7329  0.7219  0.7098  0.6980  0.6858  0.6740  0.6616  0.6506  0.6382  0.6264  0.6153  0.6039  0.5928  0.5819  0.5702  0.5574
 2.4224  2.4164  2.4104  2.4040  2.3983  2.3924  2.3859  2.3799  2.3746  2.3689  2.3631  2.3568  2.3513  2.3454  2.3394  2.3333  2.3265  2.3204  2.3143  2.3080  2.3011  2.2948  2.2884  2.2817  2.2749  2.2681  2.2610  2.2542  2.2472  2.2405  2.2334  2.2266  2.2193  2.2119  2.2049  2.1977  2.1903  2.1829  2.1754  2.1683  2.1602  2.1533  2.1454  2.1374  2.1292  2.1212  2.1130  2.1054  2.0973  2.0897  2.0817  2.0738  2.0655  2.0575  2.0496  2.0414  2.0333  2.0254  2.0169  2.0086  2.0004  1.9918  1.9835  1.9745  1.9659  1.9571  1.9482  1.9396  1.9311  1.9223  1.9138  1.9051  1.8967  1.8875  1.8784  1.8699  1.8614  1.8521  1.8430  1.8341  1.8251  1.8163  1.8069  1.7981  1.7889  1.7795  1.7703  1.7608  1.7512  1.7418  1.7323  1.7225  1.7130  1.7034  1.6943  1.6847  1.6751  1.6656  1.6564  1.6463  1.6367  1.6267  1.6169  1.6074  1.5973  1.5872  1.5770  1.5671  1.5571  1.5472  1.5366  1.5262  1.5158  1.5055  1.4953  1.4850  1.4745  1.4642  1.4535  1.4430  1.4326  1.4224  1.4119  1.4017  1.3914  1.3806  1.3703  1.3592  1.3485  1.3378  1.3272  1.3162  1.3055  1.2947  1.2839  1.2727  1.2623  1.2516  1.2399  1.2292  1.2177  1.2067  1.1957  1.1845  1.1739  1.1625  1.1508  1.1393  1.1279  1.1171  1.1058  1.0948  1.0840  1.0725  1.0609  1.0498  1.0384  1.0264  1.0153  1.0039  0.9925  0.9811  0.9695  0.9578  0.9462  0.9344  0.9230  0.9113  0.8993  0.8873  0.8759  0.8642  0.8524  0.8410  0.8290  0.8172  0.8050  0.7929  0.7811  0.7691  0.7578  0.7464  0.7341  0.7221  0.7108  0.6991  0.6871  0.6746  0.6626  0.6510  0.6391  0.6274  0.6156  0.6039  0.5931  0.5817  0.5700  0.5578  0.5457
 2.4289  2.4225  2.4163  2.4112  2.4055  2.4005  2.3945  2.3887  2.3836  2.3776  2.3712  2.3651  2.3594  2.3533  2.3471  2.3408  2.3347  2.3289  2.3224  2.3160  2.3088  2.3027  2.2966  2.2895  2.2835  2.2762  2.2688  2.2616  2.2544  2.2471  2.2397  2.2325  2.2248  2.2175  2.2103  2.2033  2.1957  2.1884  2.1812  2.1734  2.1659  2.1581  2.1503  2.1426  2.1349  2.1274  2.1196  2.1114  2.1031  2.0949  2.0869  2.0787  2.0707  2.0625  2.0541  2.0460  2.0379  2.0293  2.0206  2.0122  2.0039  1.9954  1.9866  1.9779  1.9693  1.9608  1.9522  1.9432  1.9346  1.9256  1.9173  1.9086  1.8998  1.8911  1.8821  1.8735  1.8638  1.8551  1.8458  1.8365  1.8272  1.8183  1.8085  1.7992  1.7901  1.7806  1.7711  1.7617  1.7522  1.7427  1.7330  1.7236  1.7142  1.7045  1.6944  1.6850  1.6760  1.6662  1.6566  1.6463  1.6364  1.6264  1.6165  1.6065  1.5966  1.5866  1.5763  1.5659  1.5559  1.5462  1.5359  1.5256  1.5151  1.5047  1.4943  1.4834  1.4729  1.4626  1.4524  1.4414  1.4307  1.4201  1.4097  1.3990  1.3886  1.3781  1.3672  1.3560  1.3455  1.3353  1.3243  1.3139  1.3031  1.2922  1.2813  1.2699  1.2588  1.2474  1.2366  1.2258  1.2145  1.2029  1.1919  1.1809  1.1698  1.1588  1.1473  1.1357  1.1245  1.1130  1.1014  1.0902  1.0788  1.0674  1.0555  1.0436  1.0324  1.0211  1.0096  0.9976  0.9856  0.9740  0.9627  0.9512  0.9397  0.9282  0.9165  0.9041  0.8929  0.8812  0.8693  0.8573  0.8458  0.8345  0.8225  0.8104  0.7987  0.7867  0.7746  0.7632  0.7518  0.7390  0.7268  0.7151  0.7031  0.6901  0.6776  0.6654  0.6539  0.6421  0.6298  0.6176  0.6056  0.5938  0.5837  0.5722  0.5600  0.5483  0.5352
 2.4404  2.4348  2.4284  2.4226  2.4166  2.4110  2.4052  2.4002  2.3938  2.3878  2.3817  2.3757  2.3695  2.3634  2.3576  2.3520  2.3456  2.3385  2.3319  2.3251  2.3185  2.3122  2.3051  2.2986  2.2917  2.2847  2.2775  2.2706  2.2637  2.2570  2.2498  2.2421  2.2347  2.2273  2.2197  2.2121  2.2048  2.1969  2.1888  2.1807  2.1731  2.1653  2.1575  2.1497  2.1415  2.1338  2.1258  2.1180  2.1098  2.1016  2.0929  2.0848  2.0764  2.0679  2.0591  2.0506  2.0422  2.0337  2.0251  2.0166  2.0082  1.9997  1.9912  1.9828  1.9746  1.9665  1.9579  1.9491  1.9401  1.9311  1.9216  1.9126  1.9034  1.8945  1.8854  1.8767  1.8677  1.8587  1.8494  1.8403  1.8313  1.8217  1.8120  1.8023  1.7929  1.7832  1.7735  1.7638  1.7542  1.7444  1.7352  1.7256  1.7158  1.7057  1.6958  1.6860  1.6763  1.6663  1.6564  1.6463  1.6362  1.6262  1.6160  1.6057  1.5956  1.5855  1.5751  1.5652  1.5549  1.5444  1.5345  1.5240  1.5136  1.5031  1.4929  1.4820  1.4710  1.4605  1.4499  1.4394  1.4288  1.4181  1.4075  1.3972  1.3865  1.3756  1.3648  1.3539  1.3430  1.3319  1.3205  1.3094  1.2988  1.2874  1.2761  1.2650  1.2543  1.2429  1.2320  1.2211  1.2102  1.1990  1.1876  1.1760  1.1643  1.1527  1.1411  1.1296  1.1182  1.1067  1.0950  1.0837  1.0722  1.0607  1.0491  1.0374  1.0256  1.0136  1.0022  0.9905  0.9786  0.9664  0.9543  0.9423  0.9313  0.9197  0.9079  0.8955  0.8837  0.8721  0.8604  0.8483  0.8365  0.8244  0.8120  0.8002  0.7880  0.7765  0.7647  0.7520  0.7402  0.7284  0.7160  0.7039  0.6913  0.6794  0.6677  0.6563  0.6447  0.6327  0.6213  0.6092  0.5978  0.5862  0.5743  0.5624  0.5500  0.5382  0.5263
 2.4497  2.4439  2.4372  2.4316  2.4262  2.4210  2.4152  2.4089  2.4031  2.3976  2.3915  2.3850  2.3788  2.3718  2.3655  2.3587  2.3529  2.3460  2.3388  2.3322  2.3257  2.3188  2.3122  2.3052  2.2987  2.2914  2.2843  2.2768  2.2694  2.2616  2.2545  2.2470  2.2398  2.2325  2.2251  2.2176  2.2104  2.2030  2.1954  2.1878  2.1798  2.1727  2.1644  2.1565  2.1485  2.1401  2.1322  2.1242  2.1157  2.1072  2.0990  2.0907  2.0819  2.0734  2.0649  2.0563  2.0474  2.0384  2.0298  2.0207  2.0123  2.0037  1.9954  1.9868  1.9783  1.9700  1.9611  1.9521  1.9434  1.9347  1.9260  1.9170  1.9076  1.8980  1.8885  1.8793  1.8700  1.8607  1.8514  1.8420  1.8321  1.8228  1.8132  1.8036  1.7943  1.7847  1.7750  1.7651  1.7550  1.7454  1.7359  1.7260  1.7164  1.7062  1.6961  1.6862  1.6763  1.6662  1.6564  1.6463  1.6361  1.6258  1.6157  1.6052  1.5947  1.5849  1.5746  1.5642  1.5538  1.5432  1.5327  1.5222  1.5117  1.5013  1.4901  1.4792  1.4683  1.4574  1.4466  1.4360  1.4258  1.4155  1.4049  1.3941  1.3833  1.3725  1.3620  1.3513  1.3401  1.3284  1.3175  1.3067  1.2949  1.2838  1.2728  1.2619  1.2504  1.2391  1.2273  1.2162  1.2048  1.1934  1.1819  1.1699  1.1584  1.1469  1.1350  1.1233  1.1110  1.0997  1.0880  1.0765  1.0648  1.0536  1.0419  1.0304  1.0184  1.0067  0.9949  0.9833  0.9716  0.9599  0.9480  0.9360  0.9243  0.9131  0.9016  0.8894  0.8781  0.8663  0.8540  0.8419  0.8298  0.8181  0.8062  0.7942  0.7821  0.7699  0.7579  0.7459  0.7334  0.7216  0.7095  0.6977  0.6854  0.6739  0.6610  0.6488  0.6367  0.6253  0.6130  0.6010  0.5883  0.5756  0.5633  0.5520  0.5390  0.5285  0.5156
 2.4576  2.4528  2.4468  2.4406  2.4357  2.4302  2.4246  2.4184  2.4122  2.4059  2.3986  2.3924  2.3859  2.3791  2.3724  2.3657  2.3587  2.3525  2.3455  2.3383  2.3323  2.3253  2.3188  2.3115  2.3039  2.2969  2.2893  2.2827  2.2757  2.2682  2.2606  2.2537  2.2466  2.2389  2.2319  2.2242  2.2164  2.2088  2.2010  2.1934  2.1854  2.1776  2.1696  2.1621  2.1540  2.1454  2.1376  2.1295  2.1214  2.1134  2.1053  2.0964  2.0875  2.0786  2.0698  2.0609  2.0522  2.0436  2.0349  2.0259  2.0173  2.0080  1.9993  1.9905  1.9823  1.9737  1.9646  1.9558  1.9472  1.9383  1.9290  1.9199  1.9106  1.9013  1.8924  1.8828  1.8732  1.8637  1.8538  1.8441  1.8346  1.8249  1.8152  1.8056  1.7958  1.7863  1.7761  1.7666  1.7568  1.7463  1.7367  1.7266  1.7165  1.7065  1.6969  1.6868  1.6766  1.6668  1.6563  1.6463  1.6361  1.6258  1.6154  1.6047  1.5947  1.5839  1.5737  1.5629  1.5523  1.5419  1.5311  1.5206  1.5097  1.4989  1.4878  1.4772  1.4661  1.4551  1.4442  1.4336  1.4230  1.4121  1.4016  1.3907  1.3799  1.3691  1.3585  1.3481  1.3372  1.3259  1.3151  1.3034  1.2918  1.2804  1.2691  1.2575  1.2462  1.2345  1.2232  1.2116  1.2001  1.1887  1.1773  1.1657  1.1542  1.1428  1.1312  1.1197  1.1077  1.0961  1.0845  1.0728  1.0606  1.0486  1.0363  1.0251  1.0131  1.0013  0.9892  0.9771  0.9655  0.9535  0.9419  0.9301  0.9186  0.9068  0.8949  0.8828  0.8710  0.8592  0.8477  0.8364  0.8247  0.8126  0.8006  0.7882  0.7762  0.7634  0.7520  0.7396  0.7268  0.7139  0.7016  0.6893  0.6773  0.6653  0.6530  0.6408  0.6288  0.6158  0.6033  0.5914  0.5791  0.5669  0.5555  0.5431  0.5303  0.5186  0.5069
 2.4684  2.4630  2.4575  2.4511  2.4455  2.4398  2.4346  2.4281  2.4221  2.4162  2.4102  2.4032  2.3959  2.3889  2.3823  2.3763  2.3695  2.3633  2.3564  2.3494  2.3425  2.3357  2.3293  2.3222  2.3154  2.3083  2.3003  2.2934  2.2865  2.2792  2.2716  2.2643  2.2568  2.2486  2.2415  2.2333  2.2260  2.2182  2.2102  2.2020  2.1940  2.1858  2.1774  2.1691  2.1605  2.1523  2.1440  2.1357  2.1276  2.1191  2.1109  2.1024  2.0937  2.0850  2.0763  2.0673  2.0588  2.0500  2.0409  2.0319  2.0228  2.0140  2.0051  1.9963  1.9869  1.9774  1.9680  1.9585  1.9498  1.9401  1.9311  1.9220  1.9125  1.9028  1.8937  1.8836  1.8740  1.8642  1.8547  1.8451  1.8358  1.8261  1.8162  1.8062  1.7965  1.7868  1.7772  1.7671  1.7573  1.7474  1.7371  1.7272  1.7171  1.7070  1.6970  1.6870  1.6768  1.6665  1.6564  1.6463  1.6362  1.6258  1.6152  1.6049  1.5941  1.5836  1.5732  1.5625  1.5518  1.5413  1.5308  1.5198  1.5090  1.4980  1.4866  1.4759  1.4647  1.4542  1.4431  1.4324  1.4211  1.4104  1.4000  1.3890  1.3776  1.3667  1.3559  1.3449  1.3338  1.3225  1.3114  1.2998  1.2884  1.2768  1.2651  1.2533  1.2419  1.2306  1.2198  1.2083  1.1973  1.1854  1.1737  1.1618  1.1501  1.1382  1.1272  1.1151  1.1031  1.0914  1.0793  1.0677  1.0555  1.0436  1.0317  1.0202  1.0089  0.9972  0.9851  0.9730  0.9609  0.9489  0.9369  0.9251  0.9126  0.9004  0.8885  0.8766  0.8649  0.8532  0.8408  0.8290  0.8174  0.8055  0.7927  0.7805  0.7679  0.7552  0.7429  0.7313  0.7186  0.7062  0.6933  0.6808  0.6688  0.6567  0.6444  0.6323  0.6204  0.6083  0.5958  0.5830  0.5708  0.5580  0.5457  0.5334  0.5222  0.5104  0.4981
 2.4800  2.4739  2.4678  2.4619  2.4560  2.4511  2.4452  2.4391  2.4332  2.4268  2.4202  2.4133  2.4068  2.3999  2.3929  2.3871  2.3802  2.3723  2.3655  2.3582  2.3521  2.3451  2.3378  2.3309  2.3240  2.3164  2.3085  2.3009  2.2931  2.2856  2.2778  2.2703  2.2619  2.2542  2.2467  2.2386  2.2308  2.2230  2.2154  2.2076  2.1990  2.1906  2.1824  2.1744  2.1659  2.1577  2.1495  2.1408  2.1323  2.1241  2.1154  2.1068  2.0978  2.0889  2.0802  2.0710  2.0621  2.0536  2.0449  2.0361  2.0271  2.0181  2.0094  1.9998  1.9903  1.9812  1.9721  1.9626  1.9530  1.9440  1.9343  1.9247  1.9151  1.9059  1.8960  1.8862  1.8765  1.8669  1.8573  1.8478  1.8384  1.8285  1.8188  1.8090  1.7990  1.7890  1.7788  1.7688  1.7590  1.7489  1.7391  1.7286  1.7180  1.7078  1.6978  1.6874  1.6773  1.6668  1.6563  1.6463  1.6359  1.6251  1.6147  1.6040  1.5929  1.5825  1.5719  1.5618  1.5507  1.5401  1.5296  1.5186  1.5073  1.4961  1.4849  1.4741  1.4630  1.4520  1.4411  1.4301  1.4193  1.4078  1.3974  1.3863  1.3747  1.3636  1.3525  1.3413  1.3300  1.3189  1.3077  1.2965  1.2845  1.2726  1.2609  1.2494  1.2376  1.2259  1.2136  1.2020  1.1912  1.1796  1.1682  1.1564  1.1450  1.1337  1.1216  1.1096  1.0974  1.0855  1.0734  1.0615  1.0499  1.0378  1.0256  1.0143  1.0027  0.9912  0.9793  0.9676  0.9556  0.9438  0.9321  0.9195  0.9079  0.8956  0.8836  0.8715  0.8595  0.8471  0.8350  0.8226  0.8109  0.7988  0.7864  0.7743  0.7625  0.7495  0.7371  0.7251  0.7129  0.7001  0.6876  0.6749  0.6626  0.6505  0.6380  0.6266  0.6146  0.6021  0.5901  0.5777  0.5653  0.5536  0.5415  0.5276  0.5150  0.5029  0.4904
 2.4941  2.4878  2.4826  2.4763  2.4706  2.4645  2.4583  2.4518  2.4455  2.4393  2.4330  2.4264  2.4192  2.4130  2.4058  2.3990  2.3919  2.3849  2.3781  2.3716  2.3640  2.3567  2.3494  2.3415  2.3337  2.3260  2.3185  2.3101  2.3026  2.2947  2.2867  2.2785  2.2706  2.2630  2.2544  2.2464  2.2379  2.2295  2.2213  2.2133  2.2048  2.1963  2.1879  2.1800  2.1714  2.1626  2.1540  2.1453  2.1366  2.1283  2.1201  2.1115  2.1027  2.0941  2.0855  2.0759  2.0671  2.0582  2.0492  2.0398  2.0307  2.0206  2.0113  2.0021  1.9933  1.9834  1.9737  1.9647  1.9554  1.9457  1.9365  1.9274  1.9174  1.9073  1.8981  1.8884  1.8788  1.8695  1.8594  1.8494  1.8397  1.8299  1.8200  1.8103  1.8003  1.7898  1.7793  1.7694  1.7592  1.7489  1.7386  1.7283  1.7178  1.7080  1.6976  1.6877  1.6768  1.6664  1.6564  1.6463  1.6360  1.6254  1.6147  1.6040  1.5936  1.5828  1.5720  1.5609  1.5503  1.5397  1.5285  1.5174  1.5065  1.4956  1.4847  1.4738  1.4624  1.4519  1.4407  1.4297  1.4188  1.4076  1.3962  1.3848  1.3735  1.3626  1.3512  1.3400  1.3285  1.3171  1.3056  1.2947  1.2832  1.2714  1.2599  1.2482  1.2364  1.2251  1.2133  1.2017  1.1896  1.1776  1.1655  1.1542  1.1423  1.1308  1.1190  1.1069  1.0950  1.0834  1.0720  1.0599  1.0478  1.0363  1.0247  1.0134  1.0018  0.9899  0.9778  0.9656  0.9538  0.9415  0.9291  0.9168  0.9048  0.8926  0.8803  0.8680  0.8556  0.8435  0.8309  0.8186  0.8060  0.7935  0.7811  0.7694  0.7566  0.7442  0.7325  0.7203  0.7082  0.6955  0.6830  0.6706  0.6578  0.6447  0.6326  0.6208  0.6083  0.5959  0.5831  0.5703  0.5585  0.5460  0.5339  0.5214  0.5094  0.4969  0.4844
 2.5080  2.5013  2.4951  2.4887  2.4821  2.4762  2.4687  2.4618  2.4558  2.4501  2.4434  2.4361  2.4289  2.4214  2.4144  2.4072  2.4004  2.3929  2.3863  2.3787  2.3718  2.3641  2.3567  2.3489  2.3412  2.3335  2.3259  2.3182  2.3104  2.3023  2.2944  2.2870  2.2788  2.2705  2.2626  2.2541  2.2457  2.2380  2.2295  2.2211  2.2130  2.2048  2.1958  2.1880  2.1791  2.1706  2.1619  2.1531  2.1442  2.1352  2.1261  2.1169  2.1080  2.0988  2.0892  2.0800  2.0707  2.0615  2.0522  2.0427  2.0333  2.0239  2.0144  2.0045  1.9951  1.9860  1.9767  1.9669  1.9576  1.9483  1.9384  1.9292  1.9197  1.9099  1.9004  1.8909  1.8810  1.8710  1.8613  1.8514  1.8413  1.8316  1.8214  1.8113  1.8013  1.7909  1.7806  1.7701  1.7598  1.7499  1.7392  1.7287  1.7182  1.7080  1.6979  1.6878  1.6768  1.6668  1.6566  1.6463  1.6359  1.6253  1.6145  1.6036  1.5931  1.5825  1.5720  1.5615  1.5504  1.5391  1.5281  1.5169  1.5058  1.4955  1.4840  1.4728  1.4618  1.4508  1.4398  1.4289  1.4179  1.4068  1.3958  1.3844  1.3732  1.3618  1.3506  1.3392  1.3276  1.3160  1.3045  1.2931  1.2816  1.2700  1.2584  1.2469  1.2350  1.2234  1.2121  1.2003  1.1883  1.1766  1.1648  1.1533  1.1416  1.1300  1.1186  1.1067  1.0951  1.0828  1.0710  1.0588  1.0468  1.0346  1.0223  1.0104  0.9985  0.9868  0.9744  0.9621  0.9502  0.9386  0.9265  0.9140  0.9021  0.8902  0.8776  0.8647  0.8526  0.8399  0.8279  0.8156  0.8034  0.7914  0.7789  0.7667  0.7547  0.7422  0.7302  0.7179  0.7053  0.6928  0.6803  0.6674  0.6544  0.6422  0.6299  0.6172  0.6046  0.5924  0.5800  0.5673  0.5554  0.5434  0.5308  0.5178  0.5060  0.4932  0.4805
 2.5201  2.5142  2.5072  2.5006  2.4943  2.4881  2.4813  2.4745  2.4681  2.4612  2.4546  2.4474  2.4406  2.4334  2.4261  2.4187  2.4116  2.4041  2.3966  2.3897  2.3820  2.3739  2.3664  2.3588  2.3513  2.3435  2.3355  2.3278  2.3197  2.3114  2.3035  2.2956  2.2871  2.2788  2.2702  2.2618  2.2531  2.2449  2.2365  2.2281  2.2200  2.2115  2.2025  2.1941  2.1855  2.1766  2.1670  2.1587  2.1497  2.1404  2.1311  2.1218  2.1125  2.1031  2.0939  2.0848  2.0753  2.0664  2.0571  2.0475  2.0381  2.0285  2.0189  2.0095  1.9999  1.9905  1.9811  1.9709  1.9612  1.9515  1.9423  1.9326  1.9222  1.9121  1.9023  1.8925  1.8829  1.8731  1.8632  1.8532  1.8429  1.8327  1.8224  1.8123  1.8022  1.7919  1.7817  1.7713  1.7613  1.7509  1.7409  1.7303  1.7198  1.7088  1.6984  1.6879  1.6772  1.6667  1.6568  1.6463  1.6357  1.6250  1.6137  1.6034  1.5932  1.5821  1.5713  1.5606  1.5500  1.5390  1.5280  1.5165  1.5057  1.4950  1.4838  1.4731  1.4619  1.4502  1.4391  1.4279  1.4167  1.4058  1.3944  1.3829  1.3715  1.3605  1.3491  1.3374  1.3256  1.3139  1.3026  1.2909  1.2798  1.2682  1.2563  1.2449  1.2336  1.2219  1.2105  1.1991  1.1878  1.1760  1.1647  1.1532  1.1415  1.1296  1.1182  1.1062  1.0946  1.0830  1.0709  1.0586  1.0463  1.0340  1.0224  1.0101  0.9980  0.9856  0.9738  0.9616  0.9494  0.9373  0.9245  0.9123  0.8998  0.8874  0.8751  0.8624  0.8504  0.8375  0.8247  0.8127  0.8003  0.7878  0.7749  0.7625  0.7499  0.7372  0.7249  0.7128  0.7006  0.6879  0.6755  0.6631  0.6508  0.6380  0.6258  0.6132  0.5999  0.5879  0.5750  0.5630  0.5508  0.5376  0.5251  0.5127  0.5005  0.4888  0.4758
 2.5364  2.5292  2.5222  2.5153  2.5085  2.5020  2.4950  2.4877  2.4808  2.4735  2.4663  2.4595  2.4523  2.4454  2.4378  2.4301  2.4230  2.4148  2.4070  2.3990  2.3914  2.3836  2.3762  2.3681  2.3603  2.3523  2.3434  2.3354  2.3273  2.3187  2.3104  2.3018  2.2936  2.2850  2.2764  2.2679  2.2594  2.2509  2.2424  2.2337  2.2249  2.2165  2.2076  2.1986  2.1896  2.1804  2.1713  2.1622  2.1533  2.1442  2.1356  2.1263  2.1173  2.1081  2.0987  2.0891  2.0794  2.0697  2.0605  2.0508  2.0414  2.0320  2.0226  2.0130  2.0035  1.9933  1.9835  1.9738  1.9641  1.9543  1.9445  1.9346  1.9249  1.9148  1.9047  1.8949  1.8849  1.8746  1.8647  1.8544  1.8443  1.8342  1.8234  1.8135  1.8026  1.7924  1.7823  1.7719  1.7615  1.7514  1.7409  1.7307  1.7200  1.7093  1.6988  1.6884  1.6779  1.6672  1.6568  1.6463  1.6356  1.6247  1.6135  1.6029  1.5922  1.5816  1.5705  1.5598  1.5486  1.5374  1.5263  1.5158  1.5042  1.4932  1.4821  1.4713  1.4605  1.4490  1.4385  1.4273  1.4157  1.4047  1.3939  1.3827  1.3711  1.3598  1.3480  1.3368  1.3258  1.3143  1.3027  1.2909  1.2794  1.2679  1.2560  1.2440  1.2327  1.2207  1.2088  1.1969  1.1851  1.1730  1.1614  1.1501  1.1384  1.1264  1.1151  1.1032  1.0916  1.0800  1.0677  1.0558  1.0440  1.0320  1.0195  1.0071  0.9955  0.9830  0.9706  0.9578  0.9461  0.9341  0.9219  0.9098  0.8973  0.8846  0.8723  0.8605  0.8483  0.8358  0.8233  0.8106  0.7980  0.7853  0.7728  0.7601  0.7481  0.7352  0.7226  0.7105  0.6985  0.6866  0.6740  0.6618  0.6490  0.6362  0.6240  0.6113  0.5990  0.5864  0.5740  0.5609  0.5483  0.5359  0.5236  0.5112  0.4983  0.4854  0.4719
 2.5524  2.5458  2.5403  2.5333  2.5253  2.5182  2.5107  2.5027  2.4946  2.4871  2.4795  2.4721  2.4650  2.4568  2.4493  2.4415  2.4341  2.4264  2.4184  2.4111  2.4032  2.3952  2.3868  2.3782  2.3694  2.3614  2.3531  2.3445  2.3363  2.3273  2.3189  2.3101  2.3014  2.2925  2.2838  2.2750  2.2666  2.2573  2.2486  2.2401  2.2313  2.2223  2.2131  2.2039  2.1949  2.1861  2.1769  2.1678  2.1582  2.1494  2.1399  2.1309  2.1213  2.1121  2.1025  2.0929  2.0834  2.0737  2.0642  2.0545  2.0451  2.0353  2.0256  2.0152  2.0057  1.9954  1.9859  1.9760  1.9667  1.9567  1.9468  1.9365  1.9265  1.9164  1.9065  1.8966  1.8866  1.8768  1.8664  1.8560  1.8455  1.8357  1.8251  1.8148  1.8046  1.7940  1.7833  1.7724  1.7618  1.7514  1.7411  1.7305  1.7197  1.7092  1.6987  1.6885  1.6778  1.6673  1.6571  1.6463  1.6354  1.6246  1.6133  1.6026  1.5914  1.5809  1.5698  1.5591  1.5479  1.5366  1.5255  1.5147  1.5034  1.4921  1.4812  1.4702  1.4590  1.4478  1.4364  1.4250  1.4135  1.4028  1.3914  1.3797  1.3688  1.3577  1.3467  1.3357  1.3246  1.3128  1.3016  1.2902  1.2778  1.2658  1.2537  1.2425  1.2304  1.2189  1.2071  1.1952  1.1833  1.1715  1.1598  1.1479  1.1357  1.1235  1.1117  1.0998  1.0880  1.0769  1.0649  1.0527  1.0412  1.0286  1.0164  1.0040  0.9921  0.9805  0.9680  0.9558  0.9435  0.9314  0.9194  0.9074  0.8951  0.8829  0.8709  0.8590  0.8463  0.8335  0.8222  0.8097  0.7971  0.7844  0.7716  0.7586  0.7462  0.7338  0.7211  0.7081  0.6956  0.6828  0.6697  0.6571  0.6449  0.6317  0.6197  0.6073  0.5949  0.5819  0.5689  0.5561  0.5438  0.5311  0.5193  0.5074  0.4944  0.4824  0.4691
 2.5676  2.5596  2.5527  2.5458  2.5390  2.5320  2.5249  2.5165  2.5093  2.5015  2.4937  2.4856  2.4777  2.4694  2.4614  2.4532  2.4451  2.4370  2.4290  2.4208  2.4129  2.4045  2.3963  2.3879  2.3790  2.3700  2.3611  2.3523  2.3438  2.3346  2.3260  2.3165  2.3071  2.2990  2.2908  2.2820  2.2727  2.2642  2.2554  2.2464  2.2371  2.2280  2.2186  2.2097  2.2004  2.1906  2.1813  2.1720  2.1629  2.1533  2.1437  2.1350  2.1260  2.1160  2.1062  2.0966  2.0870  2.0774  2.0675  2.0574  2.0478  2.0378  2.0281  2.0183  2.0087  1.9985  1.9886  1.9788  1.9689  1.9590  1.9492  1.9391  1.9290  1.9192  1.9091  1.8988  1.8887  1.8784  1.8681  1.8580  1.8476  1.8378  1.8272  1.8161  1.8052  1.7947  1.7845  1.7740  1.7640  1.7533  1.7427  1.7323  1.7216  1.7109  1.6997  1.6888  1.6783  1.6674  1.6571  1.6463  1.6357  1.6244  1.6132  1.6022  1.5908  1.5798  1.5693  1.5586  1.5473  1.5363  1.5251  1.5138  1.5027  1.4917  1.4804  1.4691  1.4578  1.4462  1.4347  1.4232  1.4123  1.4013  1.3901  1.3787  1.3674  1.3565  1.3448  1.3334  1.3227  1.3113  1.3000  1.2886  1.2766  1.2648  1.2528  1.2413  1.2297  1.2178  1.2063  1.1945  1.1824  1.1705  1.1590  1.1478  1.1363  1.1242  1.1120  1.1000  1.0878  1.0755  1.0640  1.0522  1.0400  1.0283  1.0160  1.0044  0.9921  0.9805  0.9682  0.9560  0.9435  0.9314  0.9190  0.9072  0.8953  0.8823  0.8699  0.8579  0.8458  0.8335  0.8209  0.8086  0.7961  0.7834  0.7709  0.7582  0.7453  0.7323  0.7202  0.7074  0.6954  0.6830  0.6700  0.6574  0.6450  0.6326  0.6198  0.6079  0.5956  0.5817  0.5692  0.5565  0.5435  0.5304  0.5172  0.5042  0.4911  0.4791  0.4666
 2.5777  2.5702  2.5622  2.5555  2.5478  2.5404  2.5323  2.5249  2.5175  2.5086  2.5003  2.4920  2.4842  2.4758  2.4674  2.4598  2.4512  2.4430  2.4351  2.4270  2.4184  2.4096  2.4007  2.3919  2.3830  2.3743  2.3652  2.3568  2.3486  2.3394  2.3311  2.3219  2.3128  2.3039  2.2948  2.2855  2.2762  2.2669  2.2580  2.2483  2.2391  2.2299  2.2205  2.2108  2.2015  2.1919  2.1826  2.1734  2.1642  2.1550  2.1455  2.1360  2.1259  2.1161  2.1068  2.0966  2.0872  2.0775  2.0678  2.0579  2.0482  2.0384  2.0285  2.0186  2.0091  1.9992  1.9893  1.9793  1.9688  1.9589  1.9484  1.9382  1.9277  1.9174  1.9073  1.8973  1.8870  1.8766  1.8662  1.8562  1.8464  1.8362  1.8257  1.8153  1.8051  1.7946  1.7846  1.7743  1.7637  1.7533  1.7428  1.7323  1.7215  1.7109  1.7002  1.6894  1.6784  1.6678  1.6571  1.6463  1.6357  1.6245  1.6129  1.6019  1.5909  1.5802  1.5692  1.5579  1.5470  1.5354  1.5245  1.5132  1.5025  1.4910  1.4799  1.4687  1.4573  1.4462  1.4353  1.4241  1.4125  1.4010  1.3896  1.3788  1.3670  1.3556  1.3441  1.3329  1.3213  1.3099  1.2984  1.2869  1.2749  1.2630  1.2512  1.2392  1.2276  1.2160  1.2047  1.1923  1.1806  1.1691  1.1569  1.1449  1.1329  1.1211  1.1096  1.0975  1.0856  1.0737  1.0615  1.0499  1.0380  1.0253  1.0134  1.0016  0.9899  0.9779  0.9660  0.9538  0.9416  0.9294  0.9174  0.9053  0.8930  0.8812  0.8689  0.8569  0.8449  0.8325  0.8202  0.8081  0.7954  0.7831  0.7700  0.7573  0.7445  0.7325  0.7202  0.7073  0.6946  0.6816  0.6690  0.6562  0.6432  0.6308  0.6180  0.6056  0.5931  0.5803  0.5679  0.5552  0.5419  0.5293  0.5161  0.5032  0.4908  0.4780  0.4647
 2.5818  2.5744  2.5668  2.5589  2.5512  2.5435  2.5356  2.5277  2.5194  2.5110  2.5025  2.4943  2.4855  2.4770  2.4688  2.4600  2.4521  2.4439  2.4358  2.4276  2.4190  2.4099  2.4018  2.3928  2.3842  2.3755  2.3662  2.3571  2.3480  2.3392  2.3304  2.3215  2.3126  2.3039  2.2950  2.2858  2.2768  2.2674  2.2584  2.2492  2.2401  2.2306  2.2216  2.2125  2.2026  2.1937  2.1841  2.1744  2.1647  2.1557  2.1456  2.1361  2.1265  2.1167  2.1070  2.0972  2.0870  2.0778  2.0681  2.0581  2.0483  2.0384  2.0286  2.0187  2.0082  1.9981  1.9887  1.9781  1.9683  1.9585  1.9483  1.9382  1.9278  1.9177  1.9079  1.8972  1.8867  1.8767  1.8667  1.8564  1.8462  1.8364  1.8263  1.8158  1.8051  1.7949  1.7847  1.7742  1.7635  1.7537  1.7430  1.7325  1.7220  1.7114  1.7006  1.6896  1.6787  1.6680  1.6572  1.6463  1.6356  1.6246  1.6133  1.6021  1.5914  1.5805  1.5692  1.5580  1.5469  1.5357  1.5244  1.5129  1.5018  1.4909  1.4799  1.4684  1.4569  1.4456  1.4345  1.4232  1.4119  1.4004  1.3892  1.3774  1.3654  1.3540  1.3430  1.3313  1.3201  1.3085  1.2969  1.2853  1.2743  1.2626  1.2511  1.2396  1.2285  1.2168  1.2049  1.1934  1.1813  1.1696  1.1578  1.1462  1.1344  1.1228  1.1105  1.0986  1.0870  1.0751  1.0632  1.0513  1.0393  1.0273  1.0150  1.0034  0.9909  0.9786  0.9663  0.9547  0.9428  0.9306  0.9181  0.9058  0.8935  0.8816  0.8696  0.8574  0.8448  0.8320  0.8197  0.8074  0.7947  0.7826  0.7704  0.7582  0.7454  0.7324  0.7194  0.7064  0.6941  0.6820  0.6696  0.6570  0.6442  0.6308  0.6179  0.6053  0.5924  0.5803  0.5675  0.5548  0.5420  0.5285  0.5163  0.5036  0.4910  0.4784  0.4662
];

cv975 =[  2.1018  2.0999  2.0991  2.0978  2.0963  2.0940  2.0935  2.0923  2.0906  2.0886  2.0873  2.0861  2.0845  2.0823  2.0809  2.0794  2.0785  2.0770  2.0760  2.0746  2.0738  2.0720  2.0703  2.0683  2.0668  2.0655  2.0634  2.0625  2.0610  2.0604  2.0588  2.0577  2.0560  2.0549  2.0536  2.0524  2.0505  2.0490  2.0477  2.0467  2.0458  2.0436  2.0420  2.0408  2.0393  2.0379  2.0372  2.0359  2.0350  2.0336  2.0323  2.0307  2.0294  2.0278  2.0264  2.0242  2.0224  2.0219  2.0204  2.0190  2.0172  2.0160  2.0148  2.0133  2.0122  2.0104  2.0091  2.0085  2.0067  2.0050  2.0035  2.0022  2.0005  1.9991  1.9976  1.9966  1.9948  1.9936  1.9925  1.9914  1.9894  1.9879  1.9862  1.9850  1.9840  1.9826  1.9808  1.9795  1.9782  1.9771  1.9760  1.9745  1.9730  1.9719  1.9699  1.9680  1.9665  1.9653  1.9637  1.9620  1.9605  1.9590  1.9577  1.9566  1.9562  1.9551  1.9536  1.9514  1.9504  1.9493  1.9474  1.9459  1.9440  1.9426  1.9416  1.9404  1.9393  1.9378  1.9362  1.9348  1.9332  1.9320  1.9305  1.9286  1.9277  1.9257  1.9241  1.9230  1.9213  1.9194  1.9185  1.9168  1.9157  1.9145  1.9132  1.9120  1.9106  1.9087  1.9067  1.9052  1.9029  1.9017  1.9008  1.8988  1.8974  1.8958  1.8944  1.8926  1.8910  1.8899  1.8889  1.8864  1.8851  1.8837  1.8821  1.8803  1.8788  1.8779  1.8767  1.8748  1.8735  1.8724  1.8706  1.8689  1.8671  1.8654  1.8636  1.8623  1.8608  1.8594  1.8581  1.8567  1.8560  1.8545  1.8523  1.8508  1.8494  1.8480  1.8464  1.8454  1.8431  1.8417  1.8394  1.8383  1.8369  1.8355  1.8333  1.8319  1.8302  1.8291  1.8275  1.8253  1.8221  1.8205  1.8181  1.8166  1.8147  1.8137  1.8095
 2.1675  2.1658  2.1637  2.1611  2.1589  2.1579  2.1555  2.1526  2.1502  2.1492  2.1477  2.1454  2.1429  2.1403  2.1381  2.1356  2.1339  2.1310  2.1287  2.1265  2.1247  2.1228  2.1206  2.1188  2.1171  2.1141  2.1121  2.1103  2.1092  2.1064  2.1044  2.1021  2.0998  2.0978  2.0955  2.0934  2.0915  2.0885  2.0867  2.0836  2.0813  2.0792  2.0774  2.0755  2.0741  2.0723  2.0701  2.0681  2.0661  2.0639  2.0615  2.0595  2.0580  2.0563  2.0544  2.0527  2.0514  2.0496  2.0481  2.0458  2.0443  2.0422  2.0403  2.0383  2.0361  2.0346  2.0321  2.0298  2.0277  2.0265  2.0245  2.0221  2.0196  2.0182  2.0169  2.0153  2.0129  2.0103  2.0078  2.0056  2.0034  2.0008  1.9981  1.9963  1.9934  1.9917  1.9896  1.9872  1.9846  1.9828  1.9804  1.9783  1.9763  1.9746  1.9725  1.9707  1.9688  1.9670  1.9647  1.9620  1.9601  1.9579  1.9559  1.9543  1.9519  1.9502  1.9485  1.9462  1.9437  1.9421  1.9404  1.9379  1.9360  1.9337  1.9318  1.9298  1.9271  1.9245  1.9228  1.9213  1.9189  1.9165  1.9144  1.9118  1.9093  1.9073  1.9057  1.9035  1.9007  1.8988  1.8966  1.8946  1.8927  1.8904  1.8876  1.8863  1.8842  1.8820  1.8795  1.8772  1.8747  1.8732  1.8715  1.8699  1.8676  1.8657  1.8633  1.8614  1.8590  1.8571  1.8552  1.8530  1.8515  1.8498  1.8466  1.8441  1.8419  1.8392  1.8362  1.8338  1.8315  1.8297  1.8266  1.8243  1.8219  1.8196  1.8170  1.8153  1.8130  1.8114  1.8091  1.8067  1.8050  1.8024  1.8000  1.7984  1.7955  1.7928  1.7898  1.7879  1.7855  1.7834  1.7811  1.7787  1.7769  1.7744  1.7723  1.7701  1.7686  1.7669  1.7648  1.7620  1.7589  1.7568  1.7547  1.7524  1.7499  1.7460  1.7423
 2.2122  2.2109  2.2094  2.2066  2.2027  2.2006  2.1978  2.1943  2.1914  2.1888  2.1867  2.1836  2.1808  2.1782  2.1749  2.1727  2.1704  2.1679  2.1652  2.1618  2.1597  2.1574  2.1547  2.1521  2.1496  2.1467  2.1443  2.1419  2.1401  2.1384  2.1360  2.1348  2.1317  2.1290  2.1263  2.1239  2.1217  2.1194  2.1167  2.1137  2.1108  2.1088  2.1059  2.1033  2.1011  2.0982  2.0953  2.0928  2.0908  2.0883  2.0862  2.0839  2.0811  2.0785  2.0762  2.0739  2.0714  2.0684  2.0665  2.0638  2.0615  2.0592  2.0566  2.0541  2.0520  2.0500  2.0480  2.0454  2.0426  2.0405  2.0382  2.0354  2.0329  2.0305  2.0275  2.0246  2.0225  2.0201  2.0178  2.0155  2.0127  2.0097  2.0073  2.0045  2.0021  1.9995  1.9966  1.9935  1.9903  1.9879  1.9856  1.9829  1.9801  1.9776  1.9753  1.9727  1.9700  1.9676  1.9648  1.9620  1.9596  1.9569  1.9543  1.9522  1.9494  1.9473  1.9440  1.9413  1.9391  1.9364  1.9340  1.9319  1.9292  1.9267  1.9242  1.9218  1.9196  1.9180  1.9147  1.9108  1.9077  1.9041  1.9011  1.8984  1.8948  1.8926  1.8906  1.8884  1.8855  1.8823  1.8798  1.8767  1.8733  1.8709  1.8686  1.8664  1.8644  1.8617  1.8586  1.8563  1.8532  1.8504  1.8478  1.8455  1.8431  1.8406  1.8378  1.8350  1.8318  1.8293  1.8268  1.8243  1.8218  1.8197  1.8172  1.8148  1.8121  1.8096  1.8063  1.8030  1.8007  1.7979  1.7950  1.7925  1.7890  1.7865  1.7835  1.7799  1.7777  1.7751  1.7721  1.7693  1.7667  1.7642  1.7618  1.7592  1.7563  1.7528  1.7505  1.7478  1.7445  1.7418  1.7395  1.7371  1.7344  1.7318  1.7290  1.7255  1.7231  1.7203  1.7181  1.7144  1.7112  1.7087  1.7052  1.7017  1.6997  1.6971  1.6945
 2.2500  2.2478  2.2452  2.2433  2.2394  2.2369  2.2332  2.2313  2.2286  2.2258  2.2221  2.2193  2.2166  2.2132  2.2101  2.2077  2.2046  2.2017  2.1990  2.1958  2.1931  2.1897  2.1871  2.1840  2.1811  2.1784  2.1751  2.1711  2.1681  2.1654  2.1634  2.1606  2.1578  2.1544  2.1518  2.1480  2.1455  2.1420  2.1392  2.1371  2.1347  2.1326  2.1302  2.1272  2.1242  2.1216  2.1181  2.1159  2.1134  2.1107  2.1082  2.1051  2.1019  2.0987  2.0963  2.0932  2.0905  2.0871  2.0841  2.0818  2.0791  2.0759  2.0730  2.0700  2.0670  2.0641  2.0609  2.0582  2.0557  2.0522  2.0493  2.0470  2.0447  2.0414  2.0384  2.0355  2.0330  2.0299  2.0266  2.0235  2.0204  2.0170  2.0142  2.0109  2.0075  2.0041  2.0010  1.9976  1.9939  1.9913  1.9888  1.9857  1.9820  1.9796  1.9769  1.9744  1.9712  1.9684  1.9653  1.9620  1.9591  1.9559  1.9534  1.9503  1.9474  1.9446  1.9417  1.9392  1.9364  1.9334  1.9303  1.9273  1.9240  1.9205  1.9174  1.9144  1.9117  1.9083  1.9053  1.9019  1.8982  1.8957  1.8924  1.8894  1.8869  1.8836  1.8813  1.8785  1.8750  1.8715  1.8692  1.8663  1.8633  1.8606  1.8571  1.8529  1.8496  1.8461  1.8429  1.8393  1.8363  1.8334  1.8305  1.8277  1.8252  1.8216  1.8179  1.8140  1.8112  1.8080  1.8050  1.8017  1.7986  1.7958  1.7922  1.7898  1.7872  1.7845  1.7825  1.7800  1.7768  1.7740  1.7713  1.7687  1.7648  1.7612  1.7585  1.7553  1.7527  1.7503  1.7472  1.7440  1.7411  1.7385  1.7351  1.7318  1.7283  1.7246  1.7210  1.7176  1.7145  1.7101  1.7070  1.7042  1.7004  1.6975  1.6952  1.6916  1.6886  1.6849  1.6818  1.6791  1.6749  1.6701  1.6660  1.6618  1.6574  1.6544  1.6517
 2.2801  2.2757  2.2716  2.2701  2.2675  2.2654  2.2628  2.2595  2.2564  2.2537  2.2515  2.2485  2.2459  2.2431  2.2396  2.2367  2.2342  2.2310  2.2282  2.2255  2.2225  2.2193  2.2159  2.2125  2.2090  2.2053  2.2014  2.1983  2.1959  2.1932  2.1902  2.1863  2.1825  2.1789  2.1757  2.1723  2.1696  2.1666  2.1634  2.1595  2.1563  2.1540  2.1510  2.1474  2.1438  2.1405  2.1377  2.1343  2.1307  2.1283  2.1253  2.1224  2.1188  2.1157  2.1123  2.1089  2.1055  2.1019  2.0988  2.0958  2.0929  2.0899  2.0868  2.0829  2.0802  2.0771  2.0738  2.0706  2.0673  2.0636  2.0605  2.0566  2.0533  2.0503  2.0470  2.0440  2.0403  2.0367  2.0335  2.0300  2.0265  2.0232  2.0195  2.0155  2.0128  2.0096  2.0062  2.0031  1.9992  1.9957  1.9922  1.9885  1.9859  1.9824  1.9787  1.9759  1.9722  1.9688  1.9654  1.9620  1.9594  1.9557  1.9528  1.9491  1.9455  1.9422  1.9394  1.9365  1.9335  1.9300  1.9263  1.9229  1.9191  1.9161  1.9128  1.9091  1.9056  1.9026  1.8997  1.8960  1.8926  1.8891  1.8853  1.8822  1.8778  1.8744  1.8709  1.8671  1.8632  1.8597  1.8561  1.8525  1.8493  1.8456  1.8429  1.8391  1.8363  1.8327  1.8299  1.8272  1.8243  1.8204  1.8176  1.8138  1.8101  1.8062  1.8027  1.7992  1.7955  1.7919  1.7887  1.7847  1.7816  1.7777  1.7734  1.7697  1.7656  1.7622  1.7589  1.7556  1.7515  1.7481  1.7440  1.7413  1.7374  1.7332  1.7301  1.7265  1.7239  1.7193  1.7157  1.7121  1.7090  1.7055  1.7017  1.6975  1.6942  1.6904  1.6869  1.6833  1.6804  1.6778  1.6729  1.6695  1.6660  1.6630  1.6585  1.6553  1.6502  1.6465  1.6422  1.6382  1.6354  1.6313  1.6273  1.6231  1.6195  1.6170  1.6136
 2.3088  2.3062  2.3023  2.2988  2.2954  2.2927  2.2901  2.2871  2.2834  2.2801  2.2766  2.2726  2.2692  2.2664  2.2630  2.2600  2.2560  2.2530  2.2490  2.2459  2.2423  2.2388  2.2362  2.2334  2.2300  2.2267  2.2230  2.2199  2.2165  2.2132  2.2100  2.2071  2.2035  2.2003  2.1959  2.1921  2.1886  2.1851  2.1818  2.1777  2.1744  2.1717  2.1672  2.1635  2.1600  2.1567  2.1538  2.1505  2.1474  2.1428  2.1387  2.1355  2.1321  2.1291  2.1253  2.1220  2.1192  2.1156  2.1115  2.1077  2.1038  2.1004  2.0967  2.0930  2.0896  2.0857  2.0818  2.0784  2.0746  2.0711  2.0675  2.0642  2.0602  2.0567  2.0535  2.0499  2.0463  2.0423  2.0391  2.0353  2.0320  2.0285  2.0245  2.0205  2.0166  2.0128  2.0098  2.0060  2.0028  1.9988  1.9954  1.9913  1.9877  1.9839  1.9805  1.9768  1.9734  1.9692  1.9657  1.9620  1.9589  1.9553  1.9521  1.9483  1.9446  1.9411  1.9373  1.9335  1.9304  1.9267  1.9228  1.9196  1.9159  1.9122  1.9085  1.9047  1.9007  1.8972  1.8930  1.8884  1.8841  1.8801  1.8766  1.8726  1.8687  1.8651  1.8610  1.8568  1.8532  1.8492  1.8454  1.8416  1.8379  1.8338  1.8304  1.8268  1.8226  1.8188  1.8156  1.8115  1.8072  1.8030  1.7997  1.7957  1.7916  1.7885  1.7843  1.7802  1.7767  1.7727  1.7684  1.7641  1.7606  1.7563  1.7521  1.7484  1.7442  1.7400  1.7360  1.7316  1.7269  1.7226  1.7190  1.7144  1.7104  1.7055  1.7016  1.6974  1.6937  1.6902  1.6859  1.6827  1.6780  1.6739  1.6712  1.6672  1.6637  1.6608  1.6561  1.6517  1.6491  1.6446  1.6406  1.6371  1.6330  1.6293  1.6248  1.6204  1.6165  1.6114  1.6063  1.6022  1.5977  1.5941  1.5898  1.5854  1.5810  1.5768  1.5729
 2.3357  2.3328  2.3284  2.3247  2.3213  2.3172  2.3148  2.3111  2.3082  2.3031  2.3004  2.2968  2.2930  2.2902  2.2878  2.2834  2.2792  2.2751  2.2711  2.2680  2.2650  2.2622  2.2582  2.2540  2.2509  2.2471  2.2429  2.2393  2.2359  2.2335  2.2299  2.2259  2.2217  2.2173  2.2137  2.2100  2.2059  2.2022  2.1992  2.1957  2.1910  2.1876  2.1835  2.1799  2.1765  2.1733  2.1692  2.1654  2.1621  2.1583  2.1545  2.1510  2.1466  2.1429  2.1388  2.1354  2.1319  2.1279  2.1237  2.1199  2.1154  2.1115  2.1080  2.1038  2.0994  2.0953  2.0912  2.0875  2.0834  2.0798  2.0767  2.0731  2.0695  2.0655  2.0616  2.0574  2.0540  2.0501  2.0460  2.0416  2.0380  2.0334  2.0294  2.0258  2.0221  2.0182  2.0140  2.0103  2.0064  2.0022  1.9981  1.9945  1.9901  1.9861  1.9821  1.9780  1.9738  1.9700  1.9661  1.9620  1.9584  1.9541  1.9504  1.9471  1.9430  1.9392  1.9355  1.9317  1.9274  1.9236  1.9201  1.9159  1.9115  1.9073  1.9028  1.8988  1.8945  1.8905  1.8863  1.8817  1.8780  1.8738  1.8697  1.8653  1.8610  1.8569  1.8522  1.8477  1.8435  1.8391  1.8355  1.8318  1.8274  1.8225  1.8184  1.8146  1.8104  1.8067  1.8024  1.7986  1.7949  1.7908  1.7864  1.7828  1.7789  1.7745  1.7702  1.7659  1.7619  1.7574  1.7530  1.7486  1.7442  1.7391  1.7346  1.7304  1.7263  1.7208  1.7169  1.7120  1.7083  1.7040  1.7001  1.6958  1.6911  1.6860  1.6818  1.6782  1.6737  1.6686  1.6643  1.6597  1.6551  1.6503  1.6465  1.6429  1.6385  1.6339  1.6295  1.6252  1.6199  1.6159  1.6118  1.6071  1.6030  1.5979  1.5935  1.5888  1.5838  1.5780  1.5727  1.5677  1.5632  1.5591  1.5545  1.5501  1.5466  1.5427  1.5380
 2.3607  2.3574  2.3537  2.3497  2.3474  2.3444  2.3406  2.3362  2.3320  2.3284  2.3249  2.3203  2.3162  2.3129  2.3083  2.3045  2.3014  2.2971  2.2944  2.2906  2.2871  2.2831  2.2792  2.2748  2.2717  2.2678  2.2638  2.2599  2.2557  2.2523  2.2483  2.2448  2.2408  2.2367  2.2324  2.2285  2.2244  2.2201  2.2160  2.2117  2.2073  2.2038  2.1997  2.1958  2.1917  2.1878  2.1838  2.1800  2.1766  2.1732  2.1690  2.1648  2.1608  2.1574  2.1531  2.1488  2.1448  2.1404  2.1360  2.1320  2.1273  2.1228  2.1185  2.1140  2.1099  2.1052  2.1015  2.0977  2.0933  2.0889  2.0844  2.0805  2.0764  2.0718  2.0673  2.0625  2.0580  2.0540  2.0495  2.0456  2.0421  2.0381  2.0343  2.0300  2.0263  2.0220  2.0181  2.0130  2.0092  2.0047  2.0009  1.9972  1.9928  1.9881  1.9840  1.9794  1.9745  1.9702  1.9659  1.9620  1.9583  1.9539  1.9498  1.9460  1.9419  1.9375  1.9328  1.9284  1.9240  1.9197  1.9153  1.9111  1.9067  1.9026  1.8984  1.8944  1.8896  1.8850  1.8800  1.8764  1.8720  1.8672  1.8638  1.8592  1.8550  1.8500  1.8444  1.8401  1.8355  1.8308  1.8263  1.8220  1.8169  1.8124  1.8083  1.8037  1.7994  1.7940  1.7894  1.7848  1.7805  1.7760  1.7716  1.7668  1.7635  1.7589  1.7544  1.7495  1.7448  1.7398  1.7356  1.7308  1.7267  1.7217  1.7173  1.7135  1.7088  1.7040  1.6993  1.6949  1.6907  1.6856  1.6810  1.6760  1.6710  1.6664  1.6617  1.6564  1.6517  1.6474  1.6420  1.6371  1.6323  1.6271  1.6216  1.6163  1.6111  1.6067  1.6018  1.5969  1.5926  1.5879  1.5825  1.5778  1.5732  1.5691  1.5641  1.5598  1.5546  1.5492  1.5440  1.5385  1.5326  1.5279  1.5231  1.5188  1.5147  1.5093  1.5049
 2.3887  2.3827  2.3788  2.3756  2.3718  2.3678  2.3648  2.3618  2.3582  2.3543  2.3492  2.3448  2.3398  2.3358  2.3322  2.3289  2.3256  2.3217  2.3176  2.3135  2.3094  2.3052  2.3018  2.2973  2.2937  2.2890  2.2851  2.2810  2.2769  2.2735  2.2694  2.2651  2.2616  2.2570  2.2533  2.2487  2.2442  2.2397  2.2355  2.2315  2.2278  2.2234  2.2184  2.2138  2.2094  2.2047  2.2002  2.1961  2.1926  2.1880  2.1836  2.1788  2.1748  2.1709  2.1659  2.1610  2.1571  2.1526  2.1475  2.1433  2.1380  2.1338  2.1299  2.1254  2.1212  2.1163  2.1115  2.1068  2.1021  2.0977  2.0937  2.0888  2.0841  2.0796  2.0752  2.0701  2.0656  2.0614  2.0568  2.0525  2.0486  2.0440  2.0394  2.0356  2.0305  2.0263  2.0225  2.0180  2.0134  2.0088  2.0037  1.9985  1.9942  1.9895  1.9845  1.9799  1.9756  1.9708  1.9663  1.9620  1.9579  1.9533  1.9491  1.9448  1.9406  1.9358  1.9309  1.9266  1.9213  1.9171  1.9124  1.9085  1.9035  1.8988  1.8940  1.8900  1.8854  1.8803  1.8754  1.8706  1.8661  1.8610  1.8566  1.8522  1.8472  1.8419  1.8366  1.8316  1.8272  1.8215  1.8167  1.8117  1.8071  1.8023  1.7975  1.7923  1.7879  1.7824  1.7777  1.7729  1.7676  1.7626  1.7581  1.7534  1.7484  1.7437  1.7389  1.7337  1.7292  1.7243  1.7193  1.7146  1.7092  1.7049  1.6997  1.6947  1.6892  1.6842  1.6793  1.6733  1.6685  1.6635  1.6582  1.6534  1.6477  1.6424  1.6380  1.6334  1.6287  1.6238  1.6182  1.6128  1.6080  1.6037  1.5978  1.5931  1.5877  1.5825  1.5772  1.5721  1.5671  1.5614  1.5564  1.5513  1.5462  1.5405  1.5352  1.5297  1.5246  1.5193  1.5154  1.5101  1.5044  1.4990  1.4946  1.4887  1.4825  1.4779  1.4722
 2.4124  2.4071  2.4020  2.3982  2.3935  2.3896  2.3857  2.3816  2.3784  2.3740  2.3697  2.3647  2.3609  2.3562  2.3521  2.3482  2.3438  2.3395  2.3348  2.3313  2.3275  2.3233  2.3190  2.3154  2.3108  2.3068  2.3020  2.2976  2.2935  2.2891  2.2846  2.2803  2.2752  2.2706  2.2662  2.2619  2.2565  2.2522  2.2478  2.2432  2.2389  2.2341  2.2295  2.2242  2.2198  2.2155  2.2109  2.2070  2.2023  2.1979  2.1932  2.1883  2.1835  2.1796  2.1752  2.1709  2.1659  2.1614  2.1563  2.1517  2.1470  2.1428  2.1384  2.1331  2.1284  2.1239  2.1193  2.1145  2.1094  2.1048  2.0996  2.0949  2.0905  2.0857  2.0815  2.0766  2.0717  2.0662  2.0612  2.0567  2.0515  2.0466  2.0423  2.0375  2.0329  2.0287  2.0240  2.0196  2.0152  2.0104  2.0054  2.0005  1.9956  1.9912  1.9862  1.9813  1.9762  1.9714  1.9667  1.9620  1.9575  1.9530  1.9480  1.9431  1.9386  1.9340  1.9291  1.9236  1.9195  1.9143  1.9093  1.9048  1.9000  1.8951  1.8902  1.8852  1.8806  1.8754  1.8708  1.8663  1.8612  1.8561  1.8517  1.8463  1.8413  1.8361  1.8307  1.8254  1.8198  1.8144  1.8095  1.8049  1.7992  1.7934  1.7883  1.7832  1.7776  1.7723  1.7681  1.7624  1.7576  1.7530  1.7479  1.7432  1.7381  1.7331  1.7273  1.7213  1.7157  1.7110  1.7061  1.7013  1.6956  1.6901  1.6849  1.6793  1.6740  1.6684  1.6633  1.6582  1.6532  1.6484  1.6422  1.6369  1.6303  1.6245  1.6196  1.6134  1.6075  1.6021  1.5965  1.5911  1.5855  1.5805  1.5748  1.5694  1.5639  1.5588  1.5535  1.5478  1.5418  1.5360  1.5301  1.5252  1.5191  1.5138  1.5084  1.5028  1.4978  1.4926  1.4873  1.4806  1.4750  1.4702  1.4638  1.4570  1.4509  1.4441  1.4402
 2.4308  2.4269  2.4227  2.4180  2.4141  2.4109  2.4075  2.4030  2.3984  2.3945  2.3900  2.3857  2.3809  2.3767  2.3728  2.3683  2.3637  2.3590  2.3544  2.3500  2.3449  2.3409  2.3362  2.3321  2.3280  2.3231  2.3191  2.3146  2.3111  2.3068  2.3027  2.2983  2.2938  2.2890  2.2838  2.2794  2.2750  2.2696  2.2641  2.2592  2.2537  2.2486  2.2437  2.2388  2.2343  2.2294  2.2242  2.2197  2.2150  2.2104  2.2056  2.2003  2.1953  2.1903  2.1852  2.1809  2.1760  2.1714  2.1671  2.1622  2.1572  2.1523  2.1475  2.1431  2.1383  2.1327  2.1277  2.1222  2.1170  2.1121  2.1069  2.1024  2.0976  2.0927  2.0876  2.0833  2.0783  2.0730  2.0678  2.0632  2.0582  2.0526  2.0473  2.0421  2.0372  2.0329  2.0281  2.0230  2.0173  2.0126  2.0074  2.0032  1.9979  1.9922  1.9872  1.9823  1.9771  1.9717  1.9668  1.9620  1.9570  1.9527  1.9476  1.9421  1.9369  1.9320  1.9269  1.9217  1.9166  1.9116  1.9064  1.9016  1.8962  1.8911  1.8861  1.8805  1.8756  1.8709  1.8658  1.8610  1.8560  1.8505  1.8445  1.8386  1.8333  1.8276  1.8223  1.8164  1.8118  1.8067  1.8011  1.7955  1.7903  1.7849  1.7797  1.7740  1.7686  1.7627  1.7565  1.7509  1.7457  1.7407  1.7355  1.7303  1.7247  1.7194  1.7139  1.7085  1.7031  1.6967  1.6907  1.6852  1.6796  1.6737  1.6686  1.6628  1.6575  1.6520  1.6464  1.6403  1.6345  1.6286  1.6228  1.6169  1.6107  1.6050  1.5993  1.5938  1.5879  1.5819  1.5771  1.5708  1.5651  1.5590  1.5538  1.5476  1.5416  1.5357  1.5302  1.5234  1.5168  1.5108  1.5054  1.4996  1.4938  1.4882  1.4814  1.4759  1.4702  1.4640  1.4584  1.4518  1.4463  1.4409  1.4343  1.4278  1.4209  1.4142  1.4078
 2.4473  2.4432  2.4395  2.4354  2.4299  2.4260  2.4228  2.4181  2.4136  2.4090  2.4053  2.4006  2.3965  2.3921  2.3881  2.3841  2.3788  2.3755  2.3706  2.3661  2.3615  2.3567  2.3522  2.3474  2.3432  2.3391  2.3349  2.3304  2.3251  2.3207  2.3160  2.3119  2.3063  2.3015  2.2963  2.2917  2.2871  2.2815  2.2766  2.2718  2.2672  2.2626  2.2574  2.2522  2.2475  2.2429  2.2373  2.2324  2.2275  2.2220  2.2174  2.2112  2.2059  2.2017  2.1961  2.1908  2.1862  2.1809  2.1761  2.1714  2.1657  2.1606  2.1554  2.1494  2.1438  2.1393  2.1338  2.1289  2.1238  2.1183  2.1130  2.1078  2.1027  2.0979  2.0930  2.0881  2.0830  2.0781  2.0723  2.0674  2.0624  2.0573  2.0525  2.0470  2.0419  2.0366  2.0314  2.0260  2.0214  2.0161  2.0111  2.0054  1.9997  1.9941  1.9888  1.9834  1.9777  1.9721  1.9672  1.9620  1.9571  1.9514  1.9465  1.9412  1.9354  1.9299  1.9245  1.9192  1.9140  1.9090  1.9031  1.8977  1.8926  1.8876  1.8820  1.8767  1.8706  1.8650  1.8593  1.8542  1.8488  1.8431  1.8378  1.8316  1.8254  1.8191  1.8137  1.8078  1.8022  1.7975  1.7921  1.7868  1.7810  1.7753  1.7692  1.7634  1.7580  1.7519  1.7468  1.7408  1.7350  1.7292  1.7224  1.7165  1.7105  1.7056  1.7002  1.6933  1.6872  1.6825  1.6764  1.6705  1.6642  1.6581  1.6520  1.6458  1.6390  1.6326  1.6259  1.6196  1.6133  1.6080  1.6021  1.5960  1.5902  1.5837  1.5779  1.5722  1.5660  1.5599  1.5543  1.5484  1.5416  1.5362  1.5297  1.5241  1.5175  1.5121  1.5053  1.4990  1.4930  1.4865  1.4804  1.4737  1.4675  1.4606  1.4537  1.4476  1.4418  1.4353  1.4291  1.4223  1.4150  1.4089  1.4028  1.3970  1.3905  1.3845  1.3794
 2.4650  2.4605  2.4559  2.4510  2.4470  2.4423  2.4386  2.4335  2.4298  2.4242  2.4195  2.4154  2.4120  2.4072  2.4032  2.3989  2.3946  2.3902  2.3857  2.3812  2.3761  2.3711  2.3660  2.3603  2.3556  2.3513  2.3467  2.3420  2.3376  2.3325  2.3278  2.3232  2.3191  2.3148  2.3104  2.3054  2.3008  2.2956  2.2901  2.2855  2.2806  2.2748  2.2695  2.2640  2.2590  2.2534  2.2481  2.2430  2.2383  2.2326  2.2270  2.2215  2.2163  2.2115  2.2064  2.2011  2.1961  2.1908  2.1855  2.1806  2.1756  2.1701  2.1649  2.1600  2.1545  2.1495  2.1438  2.1381  2.1327  2.1264  2.1214  2.1153  2.1103  2.1053  2.0998  2.0946  2.0894  2.0839  2.0785  2.0732  2.0671  2.0615  2.0561  2.0509  2.0449  2.0398  2.0333  2.0279  2.0227  2.0177  2.0121  2.0067  2.0011  1.9957  1.9901  1.9843  1.9786  1.9731  1.9674  1.9620  1.9568  1.9505  1.9456  1.9395  1.9339  1.9285  1.9232  1.9170  1.9115  1.9055  1.9000  1.8942  1.8881  1.8831  1.8780  1.8721  1.8668  1.8609  1.8551  1.8493  1.8441  1.8377  1.8315  1.8257  1.8198  1.8134  1.8069  1.8004  1.7945  1.7882  1.7822  1.7761  1.7700  1.7646  1.7586  1.7527  1.7463  1.7401  1.7335  1.7279  1.7224  1.7157  1.7101  1.7035  1.6983  1.6917  1.6858  1.6803  1.6731  1.6667  1.6610  1.6545  1.6487  1.6420  1.6357  1.6290  1.6234  1.6171  1.6107  1.6040  1.5980  1.5916  1.5846  1.5792  1.5724  1.5671  1.5603  1.5534  1.5470  1.5400  1.5338  1.5263  1.5200  1.5134  1.5070  1.5005  1.4947  1.4885  1.4814  1.4747  1.4681  1.4605  1.4538  1.4483  1.4425  1.4357  1.4289  1.4231  1.4172  1.4099  1.4028  1.3960  1.3905  1.3833  1.3774  1.3710  1.3636  1.3563  1.3487
 2.4869  2.4818  2.4762  2.4716  2.4673  2.4624  2.4576  2.4522  2.4476  2.4434  2.4384  2.4341  2.4282  2.4229  2.4184  2.4139  2.4098  2.4048  2.4002  2.3958  2.3913  2.3861  2.3810  2.3769  2.3717  2.3665  2.3617  2.3567  2.3518  2.3472  2.3423  2.3378  2.3321  2.3279  2.3228  2.3175  2.3125  2.3065  2.3000  2.2950  2.2905  2.2851  2.2795  2.2738  2.2678  2.2630  2.2574  2.2519  2.2470  2.2413  2.2367  2.2311  2.2253  2.2200  2.2141  2.2091  2.2043  2.1989  2.1941  2.1884  2.1829  2.1773  2.1722  2.1665  2.1613  2.1555  2.1499  2.1440  2.1386  2.1335  2.1279  2.1223  2.1169  2.1112  2.1055  2.0998  2.0943  2.0887  2.0823  2.0770  2.0709  2.0649  2.0598  2.0535  2.0477  2.0426  2.0371  2.0313  2.0256  2.0203  2.0145  2.0086  2.0033  1.9972  1.9913  1.9852  1.9792  1.9731  1.9680  1.9620  1.9564  1.9507  1.9448  1.9389  1.9329  1.9272  1.9216  1.9155  1.9094  1.9028  1.8966  1.8912  1.8853  1.8800  1.8745  1.8685  1.8616  1.8553  1.8490  1.8428  1.8372  1.8316  1.8251  1.8193  1.8133  1.8065  1.8002  1.7940  1.7879  1.7814  1.7757  1.7687  1.7622  1.7560  1.7499  1.7435  1.7368  1.7304  1.7241  1.7179  1.7114  1.7050  1.6990  1.6924  1.6858  1.6800  1.6739  1.6673  1.6607  1.6542  1.6476  1.6411  1.6342  1.6274  1.6208  1.6140  1.6073  1.6013  1.5950  1.5877  1.5815  1.5752  1.5680  1.5609  1.5546  1.5483  1.5417  1.5350  1.5280  1.5216  1.5146  1.5070  1.4996  1.4931  1.4866  1.4799  1.4732  1.4663  1.4593  1.4520  1.4455  1.4390  1.4311  1.4254  1.4188  1.4117  1.4045  1.3974  1.3902  1.3825  1.3753  1.3670  1.3607  1.3538  1.3472  1.3403  1.3337  1.3272  1.3218
 2.5032  2.4986  2.4946  2.4892  2.4846  2.4797  2.4750  2.4701  2.4635  2.4592  2.4543  2.4489  2.4443  2.4396  2.4345  2.4292  2.4243  2.4195  2.4144  2.4093  2.4048  2.4003  2.3954  2.3902  2.3852  2.3800  2.3748  2.3696  2.3641  2.3592  2.3543  2.3486  2.3436  2.3382  2.3325  2.3276  2.3226  2.3174  2.3121  2.3067  2.3004  2.2958  2.2908  2.2850  2.2790  2.2738  2.2684  2.2636  2.2583  2.2521  2.2475  2.2423  2.2364  2.2307  2.2248  2.2199  2.2146  2.2093  2.2035  2.1976  2.1915  2.1855  2.1798  2.1743  2.1682  2.1626  2.1565  2.1509  2.1447  2.1390  2.1333  2.1278  2.1218  2.1158  2.1096  2.1036  2.0982  2.0925  2.0866  2.0811  2.0753  2.0688  2.0627  2.0565  2.0511  2.0457  2.0397  2.0337  2.0277  2.0223  2.0160  2.0107  2.0044  1.9984  1.9926  1.9861  1.9796  1.9735  1.9681  1.9620  1.9560  1.9505  1.9437  1.9383  1.9316  1.9258  1.9200  1.9145  1.9082  1.9019  1.8958  1.8899  1.8836  1.8776  1.8714  1.8653  1.8591  1.8532  1.8465  1.8400  1.8334  1.8269  1.8198  1.8142  1.8071  1.8003  1.7938  1.7877  1.7819  1.7748  1.7681  1.7613  1.7559  1.7493  1.7428  1.7364  1.7298  1.7227  1.7158  1.7086  1.7017  1.6949  1.6885  1.6817  1.6750  1.6684  1.6618  1.6550  1.6487  1.6417  1.6351  1.6283  1.6220  1.6148  1.6076  1.6008  1.5941  1.5866  1.5799  1.5728  1.5656  1.5583  1.5517  1.5442  1.5374  1.5304  1.5230  1.5163  1.5095  1.5016  1.4947  1.4879  1.4813  1.4749  1.4677  1.4609  1.4541  1.4462  1.4391  1.4322  1.4250  1.4186  1.4113  1.4045  1.3977  1.3905  1.3822  1.3744  1.3664  1.3594  1.3527  1.3442  1.3369  1.3290  1.3228  1.3157  1.3090  1.3019  1.2939
 2.5141  2.5090  2.5046  2.5007  2.4953  2.4897  2.4851  2.4803  2.4756  2.4698  2.4650  2.4602  2.4562  2.4509  2.4454  2.4406  2.4356  2.4306  2.4262  2.4215  2.4167  2.4126  2.4071  2.4016  2.3964  2.3910  2.3862  2.3806  2.3755  2.3704  2.3650  2.3596  2.3551  2.3493  2.3432  2.3377  2.3321  2.3273  2.3222  2.3172  2.3121  2.3067  2.3011  2.2951  2.2892  2.2834  2.2777  2.2719  2.2662  2.2607  2.2547  2.2496  2.2445  2.2390  2.2333  2.2275  2.2227  2.2170  2.2109  2.2053  2.1993  2.1931  2.1868  2.1810  2.1746  2.1688  2.1629  2.1571  2.1507  2.1445  2.1390  2.1324  2.1264  2.1204  2.1143  2.1082  2.1022  2.0965  2.0903  2.0841  2.0776  2.0716  2.0656  2.0597  2.0542  2.0484  2.0429  2.0370  2.0307  2.0245  2.0189  2.0126  2.0069  2.0005  1.9937  1.9876  1.9807  1.9744  1.9681  1.9620  1.9561  1.9499  1.9432  1.9366  1.9308  1.9244  1.9180  1.9115  1.9055  1.8988  1.8929  1.8865  1.8805  1.8741  1.8675  1.8610  1.8550  1.8485  1.8418  1.8358  1.8290  1.8223  1.8147  1.8078  1.8010  1.7934  1.7871  1.7801  1.7733  1.7670  1.7599  1.7529  1.7462  1.7394  1.7326  1.7251  1.7179  1.7112  1.7041  1.6971  1.6902  1.6836  1.6765  1.6696  1.6624  1.6561  1.6490  1.6422  1.6345  1.6272  1.6205  1.6135  1.6061  1.5989  1.5909  1.5836  1.5765  1.5689  1.5616  1.5543  1.5476  1.5406  1.5335  1.5268  1.5196  1.5128  1.5060  1.4987  1.4907  1.4837  1.4758  1.4692  1.4622  1.4547  1.4474  1.4398  1.4329  1.4255  1.4179  1.4108  1.4036  1.3962  1.3889  1.3816  1.3740  1.3660  1.3582  1.3494  1.3418  1.3348  1.3272  1.3194  1.3117  1.3047  1.2975  1.2898  1.2810  1.2737  1.2658
 2.5293  2.5245  2.5194  2.5138  2.5088  2.5049  2.4999  2.4951  2.4903  2.4850  2.4803  2.4751  2.4708  2.4661  2.4603  2.4552  2.4503  2.4449  2.4404  2.4352  2.4310  2.4259  2.4205  2.4154  2.4097  2.4045  2.3987  2.3941  2.3891  2.3838  2.3780  2.3725  2.3681  2.3628  2.3574  2.3514  2.3457  2.3398  2.3339  2.3275  2.3223  2.3162  2.3109  2.3052  2.2997  2.2944  2.2888  2.2831  2.2774  2.2718  2.2657  2.2596  2.2539  2.2484  2.2423  2.2365  2.2303  2.2243  2.2189  2.2126  2.2062  2.2006  2.1953  2.1890  2.1830  2.1764  2.1700  2.1641  2.1574  2.1513  2.1450  2.1386  2.1327  2.1270  2.1206  2.1145  2.1082  2.1020  2.0966  2.0900  2.0838  2.0777  2.0708  2.0647  2.0579  2.0523  2.0458  2.0398  2.0332  2.0270  2.0209  2.0150  2.0084  2.0021  1.9954  1.9885  1.9818  1.9751  1.9681  1.9620  1.9555  1.9492  1.9428  1.9364  1.9296  1.9224  1.9164  1.9091  1.9033  1.8973  1.8902  1.8831  1.8766  1.8701  1.8633  1.8568  1.8506  1.8440  1.8375  1.8305  1.8233  1.8163  1.8091  1.8019  1.7951  1.7877  1.7806  1.7735  1.7662  1.7593  1.7519  1.7452  1.7378  1.7308  1.7234  1.7161  1.7087  1.7018  1.6953  1.6878  1.6811  1.6736  1.6667  1.6594  1.6521  1.6447  1.6376  1.6305  1.6222  1.6147  1.6073  1.5995  1.5920  1.5846  1.5775  1.5702  1.5626  1.5551  1.5476  1.5401  1.5325  1.5247  1.5174  1.5097  1.5026  1.4954  1.4883  1.4808  1.4738  1.4665  1.4586  1.4516  1.4433  1.4363  1.4287  1.4216  1.4141  1.4064  1.3985  1.3911  1.3826  1.3747  1.3665  1.3591  1.3515  1.3442  1.3358  1.3278  1.3197  1.3113  1.3032  1.2964  1.2889  1.2808  1.2727  1.2650  1.2566  1.2485  1.2407
 2.5420  2.5386  2.5344  2.5299  2.5249  2.5203  2.5154  2.5097  2.5039  2.4989  2.4934  2.4879  2.4828  2.4774  2.4724  2.4681  2.4634  2.4581  2.4527  2.4467  2.4410  2.4352  2.4295  2.4241  2.4191  2.4135  2.4081  2.4021  2.3968  2.3922  2.3869  2.3814  2.3758  2.3705  2.3658  2.3601  2.3544  2.3486  2.3428  2.3371  2.3312  2.3256  2.3201  2.3145  2.3088  2.3028  2.2980  2.2919  2.2858  2.2803  2.2740  2.2679  2.2616  2.2550  2.2490  2.2427  2.2369  2.2308  2.2247  2.2188  2.2132  2.2073  2.2015  2.1951  2.1888  2.1826  2.1755  2.1691  2.1624  2.1562  2.1505  2.1444  2.1383  2.1318  2.1258  2.1196  2.1133  2.1062  2.0999  2.0933  2.0868  2.0805  2.0736  2.0675  2.0615  2.0550  2.0490  2.0418  2.0358  2.0294  2.0231  2.0170  2.0106  2.0033  1.9961  1.9896  1.9826  1.9755  1.9685  1.9620  1.9553  1.9487  1.9425  1.9354  1.9280  1.9214  1.9147  1.9082  1.9013  1.8949  1.8874  1.8806  1.8739  1.8668  1.8599  1.8536  1.8471  1.8401  1.8331  1.8262  1.8186  1.8113  1.8040  1.7964  1.7889  1.7813  1.7735  1.7661  1.7587  1.7512  1.7439  1.7360  1.7286  1.7218  1.7145  1.7067  1.6995  1.6919  1.6847  1.6771  1.6698  1.6621  1.6548  1.6471  1.6392  1.6315  1.6242  1.6172  1.6091  1.6019  1.5946  1.5870  1.5795  1.5722  1.5640  1.5560  1.5488  1.5409  1.5331  1.5258  1.5183  1.5107  1.5028  1.4951  1.4871  1.4793  1.4719  1.4642  1.4566  1.4490  1.4411  1.4332  1.4250  1.4175  1.4088  1.4018  1.3936  1.3859  1.3780  1.3696  1.3610  1.3530  1.3439  1.3357  1.3278  1.3199  1.3120  1.3039  1.2959  1.2877  1.2785  1.2705  1.2627  1.2552  1.2471  1.2385  1.2311  1.2225  1.2128
 2.5539  2.5489  2.5446  2.5383  2.5336  2.5285  2.5244  2.5195  2.5138  2.5088  2.5035  2.4987  2.4932  2.4877  2.4832  2.4782  2.4737  2.4684  2.4624  2.4572  2.4516  2.4469  2.4422  2.4365  2.4314  2.4254  2.4193  2.4132  2.4073  2.4023  2.3971  2.3916  2.3860  2.3811  2.3761  2.3701  2.3648  2.3591  2.3536  2.3469  2.3404  2.3340  2.3279  2.3219  2.3163  2.3103  2.3043  2.2990  2.2934  2.2880  2.2822  2.2765  2.2699  2.2631  2.2571  2.2503  2.2434  2.2372  2.2312  2.2252  2.2186  2.2125  2.2062  2.2005  2.1942  2.1877  2.1815  2.1744  2.1679  2.1614  2.1554  2.1495  2.1434  2.1370  2.1302  2.1238  2.1170  2.1101  2.1040  2.0970  2.0900  2.0835  2.0768  2.0696  2.0635  2.0571  2.0513  2.0445  2.0378  2.0317  2.0253  2.0190  2.0118  2.0042  1.9972  1.9904  1.9832  1.9760  1.9689  1.9620  1.9549  1.9482  1.9417  1.9346  1.9274  1.9209  1.9139  1.9068  1.8998  1.8918  1.8853  1.8783  1.8711  1.8642  1.8563  1.8491  1.8418  1.8348  1.8274  1.8200  1.8129  1.8055  1.7977  1.7899  1.7824  1.7748  1.7668  1.7588  1.7512  1.7429  1.7357  1.7278  1.7203  1.7123  1.7050  1.6973  1.6893  1.6822  1.6750  1.6674  1.6595  1.6516  1.6440  1.6364  1.6290  1.6209  1.6131  1.6055  1.5978  1.5902  1.5826  1.5746  1.5673  1.5592  1.5508  1.5426  1.5339  1.5264  1.5186  1.5108  1.5028  1.4944  1.4867  1.4787  1.4703  1.4625  1.4550  1.4469  1.4383  1.4301  1.4218  1.4142  1.4060  1.3977  1.3897  1.3812  1.3727  1.3644  1.3553  1.3476  1.3390  1.3305  1.3223  1.3145  1.3053  1.2972  1.2889  1.2796  1.2716  1.2626  1.2543  1.2459  1.2375  1.2286  1.2202  1.2117  1.2026  1.1932  1.1855
 2.5688  2.5651  2.5613  2.5555  2.5501  2.5442  2.5387  2.5340  2.5280  2.5233  2.5186  2.5130  2.5075  2.5020  2.4960  2.4914  2.4860  2.4803  2.4758  2.4697  2.4641  2.4589  2.4527  2.4476  2.4424  2.4364  2.4306  2.4242  2.4184  2.4132  2.4070  2.4020  2.3961  2.3908  2.3855  2.3792  2.3739  2.3683  2.3624  2.3566  2.3503  2.3439  2.3372  2.3316  2.3248  2.3183  2.3120  2.3062  2.2999  2.2945  2.2881  2.2819  2.2762  2.2699  2.2640  2.2580  2.2516  2.2454  2.2390  2.2327  2.2261  2.2201  2.2139  2.2074  2.1999  2.1936  2.1873  2.1808  2.1745  2.1678  2.1608  2.1544  2.1477  2.1410  2.1347  2.1276  2.1209  2.1142  2.1073  2.1008  2.0943  2.0882  2.0816  2.0741  2.0677  2.0606  2.0536  2.0475  2.0410  2.0340  2.0274  2.0203  2.0127  2.0055  1.9981  1.9905  1.9835  1.9764  1.9692  1.9620  1.9547  1.9483  1.9411  1.9338  1.9259  1.9193  1.9124  1.9054  1.8983  1.8906  1.8830  1.8756  1.8681  1.8605  1.8528  1.8451  1.8374  1.8305  1.8228  1.8153  1.8073  1.7996  1.7920  1.7843  1.7759  1.7676  1.7601  1.7526  1.7443  1.7362  1.7286  1.7209  1.7126  1.7049  1.6978  1.6900  1.6822  1.6738  1.6660  1.6582  1.6504  1.6429  1.6362  1.6285  1.6201  1.6119  1.6043  1.5962  1.5874  1.5788  1.5704  1.5625  1.5550  1.5471  1.5390  1.5299  1.5216  1.5137  1.5050  1.4970  1.4893  1.4811  1.4727  1.4641  1.4555  1.4472  1.4384  1.4297  1.4214  1.4129  1.4040  1.3954  1.3874  1.3796  1.3708  1.3625  1.3534  1.3442  1.3354  1.3273  1.3189  1.3099  1.3015  1.2921  1.2841  1.2754  1.2666  1.2577  1.2493  1.2400  1.2299  1.2212  1.2118  1.2022  1.1939  1.1856  1.1750  1.1670  1.1596
 2.5797  2.5745  2.5702  2.5654  2.5597  2.5545  2.5489  2.5435  2.5369  2.5323  2.5266  2.5213  2.5161  2.5109  2.5061  2.5007  2.4954  2.4892  2.4841  2.4797  2.4739  2.4683  2.4623  2.4566  2.4515  2.4458  2.4400  2.4347  2.4285  2.4227  2.4174  2.4119  2.4063  2.4006  2.3948  2.3886  2.3823  2.3765  2.3703  2.3646  2.3585  2.3518  2.3453  2.3392  2.3333  2.3270  2.3211  2.3147  2.3082  2.3017  2.2956  2.2897  2.2838  2.2771  2.2708  2.2647  2.2583  2.2520  2.2454  2.2388  2.2325  2.2258  2.2192  2.2126  2.2064  2.2003  2.1941  2.1872  2.1802  2.1735  2.1670  2.1600  2.1533  2.1464  2.1395  2.1328  2.1262  2.1193  2.1119  2.1045  2.0975  2.0908  2.0838  2.0772  2.0706  2.0640  2.0575  2.0508  2.0438  2.0367  2.0298  2.0224  2.0147  2.0074  2.0001  1.9925  1.9851  1.9772  1.9692  1.9620  1.9546  1.9475  1.9402  1.9329  1.9256  1.9181  1.9108  1.9034  1.8957  1.8882  1.8809  1.8735  1.8657  1.8582  1.8506  1.8427  1.8351  1.8272  1.8191  1.8115  1.8034  1.7949  1.7870  1.7785  1.7704  1.7621  1.7541  1.7462  1.7384  1.7301  1.7221  1.7138  1.7058  1.6975  1.6903  1.6821  1.6740  1.6656  1.6574  1.6493  1.6411  1.6328  1.6243  1.6159  1.6073  1.5995  1.5911  1.5828  1.5752  1.5667  1.5581  1.5503  1.5418  1.5338  1.5249  1.5160  1.5079  1.4992  1.4906  1.4820  1.4731  1.4649  1.4568  1.4483  1.4399  1.4310  1.4228  1.4138  1.4051  1.3963  1.3885  1.3802  1.3711  1.3620  1.3528  1.3448  1.3359  1.3271  1.3183  1.3095  1.3003  1.2909  1.2818  1.2731  1.2645  1.2554  1.2456  1.2365  1.2265  1.2172  1.2089  1.2006  1.1912  1.1826  1.1717  1.1626  1.1540  1.1429  1.1331
 2.5916  2.5863  2.5808  2.5756  2.5710  2.5656  2.5609  2.5548  2.5501  2.5447  2.5386  2.5338  2.5287  2.5235  2.5187  2.5135  2.5079  2.5037  2.4981  2.4927  2.4869  2.4802  2.4739  2.4681  2.4627  2.4572  2.4509  2.4460  2.4400  2.4347  2.4284  2.4223  2.4165  2.4102  2.4045  2.3982  2.3920  2.3860  2.3804  2.3743  2.3681  2.3622  2.3562  2.3499  2.3432  2.3367  2.3310  2.3242  2.3180  2.3120  2.3053  2.2993  2.2929  2.2863  2.2805  2.2744  2.2680  2.2614  2.2542  2.2476  2.2409  2.2342  2.2269  2.2202  2.2136  2.2062  2.1998  2.1927  2.1851  2.1779  2.1711  2.1645  2.1576  2.1505  2.1429  2.1357  2.1286  2.1220  2.1147  2.1078  2.1008  2.0940  2.0872  2.0797  2.0731  2.0661  2.0592  2.0522  2.0444  2.0372  2.0305  2.0232  2.0159  2.0083  2.0012  1.9933  1.9855  1.9771  1.9696  1.9620  1.9545  1.9473  1.9398  1.9325  1.9244  1.9166  1.9091  1.9018  1.8946  1.8866  1.8789  1.8709  1.8628  1.8549  1.8470  1.8389  1.8309  1.8234  1.8154  1.8075  1.7991  1.7909  1.7821  1.7738  1.7659  1.7581  1.7498  1.7411  1.7331  1.7251  1.7171  1.7085  1.7001  1.6919  1.6841  1.6757  1.6675  1.6584  1.6499  1.6414  1.6335  1.6253  1.6163  1.6078  1.5993  1.5909  1.5827  1.5743  1.5656  1.5571  1.5479  1.5397  1.5309  1.5222  1.5137  1.5045  1.4958  1.4863  1.4771  1.4686  1.4590  1.4496  1.4405  1.4320  1.4226  1.4135  1.4042  1.3948  1.3865  1.3775  1.3691  1.3602  1.3512  1.3424  1.3339  1.3247  1.3154  1.3063  1.2967  1.2876  1.2782  1.2695  1.2605  1.2518  1.2425  1.2340  1.2251  1.2150  1.2055  1.1959  1.1864  1.1775  1.1681  1.1590  1.1498  1.1388  1.1294  1.1193  1.1091
 2.6039  2.5991  2.5958  2.5905  2.5845  2.5793  2.5742  2.5688  2.5637  2.5578  2.5529  2.5473  2.5419  2.5362  2.5313  2.5258  2.5203  2.5144  2.5089  2.5037  2.4977  2.4921  2.4850  2.4796  2.4731  2.4678  2.4619  2.4556  2.4502  2.4441  2.4377  2.4318  2.4262  2.4203  2.4143  2.4074  2.4009  2.3949  2.3885  2.3819  2.3762  2.3698  2.3637  2.3570  2.3509  2.3441  2.3383  2.3319  2.3257  2.3190  2.3124  2.3065  2.3000  2.2931  2.2864  2.2799  2.2735  2.2666  2.2609  2.2544  2.2476  2.2408  2.2341  2.2270  2.2202  2.2127  2.2053  2.1981  2.1908  2.1840  2.1772  2.1705  2.1629  2.1559  2.1490  2.1419  2.1344  2.1274  2.1200  2.1127  2.1051  2.0982  2.0912  2.0840  2.0767  2.0694  2.0619  2.0548  2.0476  2.0399  2.0321  2.0247  2.0171  2.0094  2.0015  1.9937  1.9854  1.9775  1.9699  1.9620  1.9544  1.9470  1.9393  1.9316  1.9230  1.9150  1.9078  1.8998  1.8923  1.8842  1.8768  1.8688  1.8611  1.8528  1.8444  1.8361  1.8282  1.8199  1.8119  1.8035  1.7950  1.7870  1.7780  1.7696  1.7614  1.7523  1.7443  1.7363  1.7277  1.7186  1.7096  1.7015  1.6931  1.6846  1.6762  1.6683  1.6593  1.6509  1.6417  1.6324  1.6237  1.6149  1.6062  1.5985  1.5891  1.5802  1.5719  1.5627  1.5539  1.5448  1.5356  1.5268  1.5178  1.5085  1.4994  1.4898  1.4811  1.4720  1.4630  1.4533  1.4443  1.4350  1.4249  1.4157  1.4061  1.3968  1.3876  1.3791  1.3700  1.3601  1.3512  1.3418  1.3334  1.3239  1.3142  1.3046  1.2956  1.2862  1.2767  1.2669  1.2569  1.2472  1.2382  1.2289  1.2198  1.2112  1.2016  1.1916  1.1815  1.1722  1.1622  1.1530  1.1425  1.1332  1.1240  1.1144  1.1042  1.0936  1.0844
 2.6136  2.6074  2.6028  2.5979  2.5928  2.5883  2.5832  2.5787  2.5736  2.5691  2.5623  2.5571  2.5517  2.5461  2.5405  2.5343  2.5283  2.5231  2.5179  2.5126  2.5073  2.5016  2.4966  2.4903  2.4847  2.4783  2.4728  2.4654  2.4591  2.4533  2.4469  2.4408  2.4355  2.4288  2.4224  2.4159  2.4096  2.4036  2.3973  2.3905  2.3839  2.3780  2.3713  2.3649  2.3587  2.3522  2.3460  2.3398  2.3335  2.3268  2.3203  2.3136  2.3068  2.2995  2.2930  2.2864  2.2804  2.2740  2.2673  2.2597  2.2527  2.2457  2.2390  2.2321  2.2252  2.2174  2.2107  2.2036  2.1956  2.1884  2.1814  2.1746  2.1671  2.1596  2.1517  2.1444  2.1374  2.1299  2.1231  2.1158  2.1087  2.1015  2.0940  2.0863  2.0785  2.0705  2.0635  2.0558  2.0483  2.0408  2.0336  2.0262  2.0186  2.0110  2.0033  1.9947  1.9864  1.9775  1.9701  1.9620  1.9540  1.9462  1.9387  1.9303  1.9221  1.9141  1.9060  1.8977  1.8896  1.8810  1.8734  1.8653  1.8567  1.8487  1.8410  1.8328  1.8244  1.8160  1.8078  1.7993  1.7909  1.7825  1.7742  1.7654  1.7568  1.7479  1.7388  1.7305  1.7221  1.7133  1.7043  1.6949  1.6855  1.6767  1.6679  1.6594  1.6504  1.6415  1.6323  1.6232  1.6143  1.6059  1.5967  1.5877  1.5788  1.5699  1.5602  1.5508  1.5406  1.5310  1.5215  1.5129  1.5028  1.4941  1.4852  1.4752  1.4667  1.4574  1.4479  1.4390  1.4298  1.4204  1.4112  1.4021  1.3928  1.3830  1.3735  1.3629  1.3538  1.3450  1.3356  1.3268  1.3170  1.3078  1.2974  1.2878  1.2787  1.2682  1.2585  1.2483  1.2384  1.2286  1.2185  1.2084  1.1992  1.1899  1.1813  1.1706  1.1610  1.1515  1.1406  1.1310  1.1215  1.1113  1.1006  1.0917  1.0809  1.0714  1.0596
 2.6178  2.6142  2.6090  2.6038  2.5991  2.5940  2.5896  2.5850  2.5794  2.5736  2.5684  2.5626  2.5578  2.5522  2.5477  2.5426  2.5374  2.5320  2.5264  2.5205  2.5150  2.5096  2.5033  2.4973  2.4905  2.4842  2.4786  2.4731  2.4671  2.4610  2.4548  2.4480  2.4421  2.4350  2.4288  2.4229  2.4161  2.4101  2.4034  2.3968  2.3906  2.3840  2.3776  2.3713  2.3646  2.3587  2.3525  2.3462  2.3398  2.3342  2.3268  2.3203  2.3144  2.3070  2.3003  2.2943  2.2872  2.2795  2.2727  2.2662  2.2583  2.2513  2.2437  2.2362  2.2289  2.2210  2.2145  2.2073  2.2007  2.1936  2.1865  2.1795  2.1720  2.1646  2.1571  2.1496  2.1422  2.1343  2.1266  2.1194  2.1120  2.1040  2.0968  2.0892  2.0815  2.0737  2.0655  2.0580  2.0505  2.0429  2.0355  2.0275  2.0199  2.0119  2.0041  1.9953  1.9870  1.9780  1.9702  1.9620  1.9539  1.9459  1.9381  1.9297  1.9214  1.9135  1.9052  1.8965  1.8877  1.8798  1.8712  1.8628  1.8548  1.8465  1.8378  1.8297  1.8209  1.8128  1.8038  1.7955  1.7867  1.7780  1.7691  1.7599  1.7510  1.7426  1.7341  1.7251  1.7164  1.7073  1.6988  1.6895  1.6811  1.6714  1.6619  1.6525  1.6437  1.6347  1.6255  1.6166  1.6074  1.5973  1.5876  1.5787  1.5691  1.5602  1.5506  1.5415  1.5318  1.5220  1.5129  1.5040  1.4943  1.4849  1.4759  1.4666  1.4569  1.4476  1.4383  1.4291  1.4191  1.4096  1.4002  1.3907  1.3815  1.3710  1.3610  1.3510  1.3420  1.3319  1.3214  1.3106  1.3016  1.2922  1.2818  1.2716  1.2626  1.2520  1.2427  1.2325  1.2221  1.2126  1.2029  1.1921  1.1824  1.1726  1.1628  1.1533  1.1427  1.1316  1.1204  1.1111  1.1005  1.0911  1.0807  1.0704  1.0603  1.0491  1.0393
 2.6327  2.6262  2.6206  2.6173  2.6112  2.6058  2.6011  2.5960  2.5911  2.5850  2.5796  2.5741  2.5686  2.5625  2.5568  2.5516  2.5461  2.5401  2.5343  2.5293  2.5236  2.5182  2.5126  2.5066  2.5012  2.4948  2.4889  2.4823  2.4764  2.4697  2.4632  2.4573  2.4515  2.4454  2.4395  2.4329  2.4264  2.4206  2.4145  2.4076  2.4010  2.3948  2.3883  2.3814  2.3750  2.3678  2.3609  2.3541  2.3477  2.3409  2.3341  2.3269  2.3200  2.3128  2.3062  2.2999  2.2922  2.2859  2.2786  2.2713  2.2641  2.2569  2.2489  2.2415  2.2339  2.2270  2.2199  2.2123  2.2052  2.1977  2.1895  2.1821  2.1752  2.1672  2.1597  2.1520  2.1447  2.1370  2.1290  2.1214  2.1136  2.1061  2.0986  2.0919  2.0839  2.0753  2.0673  2.0597  2.0515  2.0437  2.0359  2.0279  2.0206  2.0131  2.0049  1.9962  1.9877  1.9789  1.9702  1.9620  1.9536  1.9455  1.9372  1.9289  1.9203  1.9116  1.9026  1.8946  1.8863  1.8786  1.8700  1.8613  1.8529  1.8445  1.8355  1.8266  1.8182  1.8093  1.8005  1.7925  1.7843  1.7753  1.7660  1.7571  1.7480  1.7390  1.7297  1.7210  1.7117  1.7025  1.6934  1.6839  1.6749  1.6653  1.6556  1.6462  1.6367  1.6272  1.6173  1.6080  1.5990  1.5893  1.5799  1.5709  1.5620  1.5526  1.5426  1.5330  1.5235  1.5128  1.5034  1.4940  1.4837  1.4741  1.4642  1.4551  1.4457  1.4359  1.4264  1.4173  1.4076  1.3974  1.3876  1.3776  1.3673  1.3567  1.3477  1.3375  1.3279  1.3177  1.3081  1.2979  1.2869  1.2771  1.2666  1.2562  1.2461  1.2359  1.2255  1.2154  1.2053  1.1953  1.1852  1.1754  1.1644  1.1534  1.1442  1.1332  1.1228  1.1132  1.1015  1.0904  1.0796  1.0693  1.0587  1.0476  1.0377  1.0269  1.0158
 2.6429  2.6375  2.6320  2.6281  2.6230  2.6175  2.6116  2.6063  2.6003  2.5945  2.5893  2.5837  2.5781  2.5727  2.5667  2.5619  2.5560  2.5502  2.5430  2.5364  2.5306  2.5246  2.5185  2.5132  2.5074  2.5017  2.4958  2.4897  2.4840  2.4776  2.4723  2.4664  2.4600  2.4532  2.4476  2.4405  2.4348  2.4282  2.4212  2.4148  2.4084  2.4017  2.3950  2.3883  2.3812  2.3741  2.3676  2.3610  2.3543  2.3479  2.3416  2.3339  2.3268  2.3198  2.3132  2.3060  2.2984  2.2916  2.2846  2.2769  2.2695  2.2622  2.2552  2.2476  2.2399  2.2324  2.2250  2.2176  2.2098  2.2024  2.1952  2.1872  2.1792  2.1718  2.1639  2.1568  2.1485  2.1410  2.1327  2.1249  2.1173  2.1092  2.1013  2.0937  2.0858  2.0779  2.0694  2.0611  2.0534  2.0464  2.0387  2.0305  2.0220  2.0142  2.0051  1.9966  1.9884  1.9792  1.9705  1.9620  1.9536  1.9450  1.9369  1.9275  1.9196  1.9112  1.9023  1.8933  1.8849  1.8766  1.8678  1.8586  1.8501  1.8408  1.8324  1.8239  1.8153  1.8067  1.7979  1.7886  1.7799  1.7708  1.7610  1.7522  1.7429  1.7337  1.7241  1.7150  1.7054  1.6961  1.6866  1.6775  1.6673  1.6577  1.6481  1.6393  1.6298  1.6207  1.6110  1.6009  1.5913  1.5813  1.5714  1.5613  1.5515  1.5416  1.5316  1.5218  1.5123  1.5024  1.4918  1.4822  1.4725  1.4624  1.4522  1.4422  1.4325  1.4232  1.4130  1.4029  1.3926  1.3828  1.3733  1.3632  1.3525  1.3424  1.3328  1.3224  1.3124  1.3015  1.2913  1.2814  1.2710  1.2601  1.2499  1.2392  1.2290  1.2181  1.2075  1.1972  1.1866  1.1766  1.1658  1.1550  1.1443  1.1341  1.1232  1.1131  1.1020  1.0914  1.0805  1.0696  1.0587  1.0483  1.0375  1.0270  1.0164  1.0067  0.9949
 2.6523  2.6471  2.6411  2.6364  2.6312  2.6251  2.6202  2.6145  2.6091  2.6037  2.5986  2.5930  2.5869  2.5819  2.5759  2.5707  2.5651  2.5598  2.5529  2.5475  2.5418  2.5363  2.5298  2.5236  2.5175  2.5119  2.5062  2.5002  2.4942  2.4880  2.4811  2.4748  2.4682  2.4616  2.4554  2.4487  2.4422  2.4354  2.4287  2.4217  2.4153  2.4083  2.4017  2.3947  2.3881  2.3811  2.3747  2.3678  2.3610  2.3539  2.3468  2.3398  2.3329  2.3260  2.3191  2.3119  2.3044  2.2965  2.2883  2.2806  2.2726  2.2652  2.2578  2.2506  2.2432  2.2355  2.2281  2.2218  2.2141  2.2068  2.1993  2.1919  2.1844  2.1767  2.1689  2.1611  2.1529  2.1448  2.1366  2.1285  2.1206  2.1121  2.1044  2.0961  2.0876  2.0793  2.0715  2.0643  2.0565  2.0482  2.0391  2.0314  2.0228  2.0144  2.0058  1.9978  1.9888  1.9794  1.9705  1.9620  1.9538  1.9452  1.9364  1.9275  1.9183  1.9101  1.9007  1.8921  1.8836  1.8755  1.8667  1.8581  1.8492  1.8398  1.8311  1.8224  1.8134  1.8043  1.7943  1.7851  1.7758  1.7661  1.7568  1.7472  1.7370  1.7279  1.7187  1.7092  1.7003  1.6914  1.6816  1.6715  1.6618  1.6524  1.6433  1.6337  1.6236  1.6135  1.6037  1.5937  1.5837  1.5735  1.5636  1.5539  1.5450  1.5350  1.5247  1.5147  1.5055  1.4954  1.4851  1.4749  1.4647  1.4544  1.4443  1.4340  1.4243  1.4138  1.4038  1.3940  1.3837  1.3732  1.3626  1.3521  1.3414  1.3302  1.3197  1.3091  1.2986  1.2886  1.2775  1.2667  1.2559  1.2449  1.2344  1.2236  1.2128  1.2021  1.1913  1.1803  1.1690  1.1586  1.1487  1.1380  1.1266  1.1163  1.1060  1.0960  1.0848  1.0732  1.0630  1.0523  1.0413  1.0303  1.0186  1.0075  0.9981  0.9868  0.9762
 2.6581  2.6532  2.6483  2.6428  2.6378  2.6320  2.6272  2.6211  2.6156  2.6103  2.6048  2.6002  2.5946  2.5890  2.5838  2.5778  2.5727  2.5667  2.5603  2.5555  2.5497  2.5431  2.5372  2.5315  2.5256  2.5196  2.5128  2.5062  2.4994  2.4928  2.4858  2.4792  2.4725  2.4664  2.4604  2.4537  2.4473  2.4415  2.4349  2.4282  2.4214  2.4153  2.4084  2.4014  2.3945  2.3882  2.3808  2.3741  2.3678  2.3604  2.3535  2.3459  2.3383  2.3313  2.3236  2.3157  2.3082  2.3005  2.2930  2.2852  2.2776  2.2691  2.2617  2.2549  2.2466  2.2393  2.2321  2.2248  2.2168  2.2091  2.2019  2.1946  2.1868  2.1790  2.1710  2.1633  2.1552  2.1473  2.1395  2.1310  2.1229  2.1146  2.1066  2.0982  2.0903  2.0820  2.0739  2.0656  2.0576  2.0494  2.0408  2.0326  2.0239  2.0154  2.0067  1.9976  1.9891  1.9796  1.9706  1.9620  1.9534  1.9446  1.9360  1.9272  1.9181  1.9093  1.9002  1.8911  1.8823  1.8734  1.8649  1.8555  1.8462  1.8376  1.8284  1.8186  1.8090  1.8000  1.7909  1.7814  1.7723  1.7625  1.7534  1.7439  1.7341  1.7240  1.7147  1.7052  1.6960  1.6867  1.6764  1.6669  1.6564  1.6470  1.6370  1.6275  1.6167  1.6072  1.5977  1.5874  1.5769  1.5669  1.5568  1.5469  1.5364  1.5262  1.5162  1.5069  1.4966  1.4860  1.4754  1.4644  1.4541  1.4446  1.4346  1.4241  1.4132  1.4030  1.3919  1.3819  1.3712  1.3609  1.3504  1.3396  1.3295  1.3187  1.3071  1.2968  1.2862  1.2759  1.2645  1.2536  1.2425  1.2316  1.2212  1.2095  1.1989  1.1882  1.1779  1.1662  1.1547  1.1438  1.1333  1.1220  1.1116  1.1015  1.0907  1.0796  1.0691  1.0567  1.0468  1.0363  1.0252  1.0138  1.0019  0.9915  0.9806  0.9699  0.9595
 2.6705  2.6651  2.6585  2.6538  2.6495  2.6423  2.6368  2.6311  2.6255  2.6198  2.6143  2.6082  2.6031  2.5977  2.5920  2.5863  2.5806  2.5749  2.5692  2.5636  2.5583  2.5519  2.5459  2.5402  2.5336  2.5274  2.5205  2.5141  2.5079  2.5014  2.4947  2.4881  2.4813  2.4753  2.4685  2.4614  2.4547  2.4474  2.4406  2.4338  2.4277  2.4207  2.4138  2.4065  2.3995  2.3928  2.3855  2.3793  2.3722  2.3654  2.3580  2.3500  2.3432  2.3359  2.3283  2.3215  2.3137  2.3064  2.2990  2.2916  2.2834  2.2760  2.2685  2.2607  2.2531  2.2453  2.2378  2.2294  2.2220  2.2145  2.2065  2.1988  2.1907  2.1823  2.1738  2.1658  2.1573  2.1490  2.1417  2.1335  2.1249  2.1170  2.1087  2.1002  2.0921  2.0835  2.0747  2.0662  2.0586  2.0497  2.0417  2.0335  2.0246  2.0161  2.0069  1.9980  1.9890  1.9800  1.9706  1.9620  1.9536  1.9448  1.9357  1.9271  1.9178  1.9084  1.8997  1.8907  1.8810  1.8720  1.8625  1.8534  1.8447  1.8352  1.8257  1.8163  1.8076  1.7978  1.7884  1.7788  1.7692  1.7598  1.7501  1.7399  1.7298  1.7198  1.7103  1.7003  1.6897  1.6796  1.6695  1.6599  1.6495  1.6394  1.6295  1.6197  1.6099  1.6002  1.5900  1.5796  1.5695  1.5589  1.5482  1.5379  1.5272  1.5169  1.5066  1.4965  1.4851  1.4747  1.4636  1.4534  1.4431  1.4324  1.4223  1.4112  1.4008  1.3911  1.3808  1.3699  1.3590  1.3483  1.3373  1.3263  1.3153  1.3051  1.2946  1.2838  1.2731  1.2623  1.2516  1.2407  1.2296  1.2189  1.2083  1.1972  1.1857  1.1749  1.1632  1.1517  1.1400  1.1284  1.1179  1.1073  1.0953  1.0848  1.0741  1.0627  1.0522  1.0420  1.0296  1.0183  1.0085  0.9985  0.9868  0.9761  0.9645  0.9532  0.9433
 2.6786  2.6744  2.6706  2.6649  2.6592  2.6541  2.6486  2.6427  2.6372  2.6310  2.6255  2.6200  2.6138  2.6082  2.6021  2.5965  2.5908  2.5844  2.5787  2.5731  2.5664  2.5602  2.5538  2.5479  2.5419  2.5348  2.5283  2.5224  2.5157  2.5092  2.5023  2.4952  2.4891  2.4820  2.4748  2.4675  2.4614  2.4546  2.4484  2.4417  2.4351  2.4287  2.4215  2.4141  2.4073  2.4000  2.3933  2.3861  2.3792  2.3718  2.3651  2.3579  2.3502  2.3425  2.3355  2.3275  2.3200  2.3127  2.3055  2.2980  2.2904  2.2822  2.2742  2.2663  2.2582  2.2508  2.2426  2.2342  2.2260  2.2180  2.2098  2.2022  2.1935  2.1852  2.1773  2.1698  2.1624  2.1545  2.1460  2.1371  2.1284  2.1202  2.1113  2.1029  2.0945  2.0858  2.0775  2.0690  2.0603  2.0516  2.0432  2.0341  2.0253  2.0167  2.0079  1.9990  1.9896  1.9803  1.9710  1.9620  1.9533  1.9445  1.9350  1.9257  1.9172  1.9075  1.8984  1.8886  1.8794  1.8708  1.8616  1.8528  1.8434  1.8343  1.8250  1.8148  1.8049  1.7954  1.7859  1.7764  1.7665  1.7567  1.7471  1.7369  1.7268  1.7170  1.7066  1.6960  1.6855  1.6756  1.6657  1.6552  1.6444  1.6340  1.6239  1.6139  1.6041  1.5941  1.5834  1.5733  1.5625  1.5517  1.5410  1.5307  1.5204  1.5098  1.4991  1.4886  1.4777  1.4680  1.4570  1.4469  1.4361  1.4254  1.4144  1.4033  1.3921  1.3809  1.3695  1.3581  1.3470  1.3369  1.3263  1.3157  1.3055  1.2943  1.2834  1.2719  1.2613  1.2506  1.2387  1.2278  1.2168  1.2061  1.1950  1.1838  1.1725  1.1616  1.1503  1.1381  1.1262  1.1143  1.1036  1.0925  1.0810  1.0702  1.0589  1.0480  1.0374  1.0255  1.0142  1.0029  0.9918  0.9824  0.9712  0.9602  0.9487  0.9384  0.9269
 2.6874  2.6818  2.6759  2.6695  2.6646  2.6586  2.6533  2.6479  2.6411  2.6353  2.6299  2.6240  2.6176  2.6119  2.6064  2.6016  2.5957  2.5895  2.5834  2.5768  2.5715  2.5665  2.5601  2.5540  2.5477  2.5413  2.5344  2.5277  2.5212  2.5149  2.5084  2.5016  2.4948  2.4884  2.4813  2.4744  2.4668  2.4593  2.4532  2.4469  2.4396  2.4328  2.4254  2.4182  2.4114  2.4046  2.3978  2.3903  2.3831  2.3752  2.3681  2.3601  2.3535  2.3462  2.3391  2.3316  2.3241  2.3167  2.3091  2.3016  2.2941  2.2854  2.2776  2.2699  2.2622  2.2541  2.2461  2.2378  2.2301  2.2226  2.2143  2.2058  2.1973  2.1892  2.1815  2.1731  2.1648  2.1555  2.1464  2.1382  2.1293  2.1208  2.1124  2.1041  2.0955  2.0867  2.0792  2.0706  2.0616  2.0525  2.0433  2.0346  2.0259  2.0175  2.0087  1.9994  1.9900  1.9803  1.9712  1.9620  1.9532  1.9438  1.9342  1.9247  1.9159  1.9064  1.8973  1.8879  1.8784  1.8695  1.8600  1.8505  1.8420  1.8320  1.8221  1.8127  1.8029  1.7925  1.7825  1.7726  1.7627  1.7528  1.7422  1.7318  1.7219  1.7114  1.7020  1.6912  1.6810  1.6707  1.6600  1.6497  1.6396  1.6297  1.6193  1.6088  1.5978  1.5873  1.5773  1.5668  1.5563  1.5457  1.5353  1.5249  1.5144  1.5036  1.4922  1.4811  1.4706  1.4600  1.4490  1.4381  1.4265  1.4155  1.4041  1.3930  1.3815  1.3712  1.3600  1.3494  1.3381  1.3273  1.3165  1.3051  1.2937  1.2829  1.2717  1.2605  1.2500  1.2390  1.2278  1.2175  1.2063  1.1945  1.1839  1.1723  1.1608  1.1488  1.1373  1.1258  1.1134  1.1022  1.0910  1.0803  1.0686  1.0569  1.0447  1.0331  1.0225  1.0114  1.0002  0.9890  0.9790  0.9681  0.9575  0.9450  0.9348  0.9238  0.9151
 2.6874  2.6831  2.6770  2.6712  2.6657  2.6614  2.6571  2.6512  2.6460  2.6401  2.6344  2.6285  2.6232  2.6176  2.6108  2.6049  2.5986  2.5929  2.5869  2.5805  2.5744  2.5686  2.5621  2.5561  2.5508  2.5453  2.5392  2.5333  2.5268  2.5209  2.5145  2.5074  2.5005  2.4940  2.4876  2.4802  2.4736  2.4670  2.4595  2.4529  2.4454  2.4386  2.4317  2.4240  2.4167  2.4091  2.4022  2.3951  2.3883  2.3805  2.3725  2.3650  2.3582  2.3507  2.3435  2.3362  2.3284  2.3207  2.3133  2.3053  2.2983  2.2907  2.2828  2.2748  2.2671  2.2588  2.2506  2.2428  2.2344  2.2260  2.2179  2.2098  2.2015  2.1926  2.1845  2.1761  2.1682  2.1598  2.1512  2.1420  2.1335  2.1251  2.1162  2.1072  2.0981  2.0896  2.0813  2.0725  2.0636  2.0548  2.0457  2.0368  2.0279  2.0187  2.0097  1.9999  1.9906  1.9808  1.9711  1.9620  1.9528  1.9434  1.9339  1.9253  1.9159  1.9060  1.8965  1.8870  1.8776  1.8683  1.8586  1.8492  1.8397  1.8304  1.8207  1.8104  1.8005  1.7895  1.7791  1.7690  1.7585  1.7485  1.7385  1.7279  1.7171  1.7067  1.6962  1.6858  1.6752  1.6650  1.6544  1.6441  1.6344  1.6238  1.6130  1.6025  1.5919  1.5817  1.5709  1.5606  1.5502  1.5394  1.5290  1.5184  1.5068  1.4952  1.4841  1.4742  1.4631  1.4519  1.4403  1.4293  1.4183  1.4070  1.3960  1.3847  1.3744  1.3626  1.3513  1.3408  1.3293  1.3185  1.3083  1.2977  1.2866  1.2760  1.2644  1.2520  1.2412  1.2299  1.2188  1.2072  1.1955  1.1844  1.1722  1.1603  1.1481  1.1368  1.1256  1.1144  1.1029  1.0916  1.0802  1.0686  1.0568  1.0457  1.0349  1.0232  1.0122  1.0015  0.9907  0.9802  0.9689  0.9572  0.9470  0.9353  0.9250  0.9139  0.9037
 2.6982  2.6932  2.6870  2.6812  2.6757  2.6710  2.6658  2.6610  2.6557  2.6503  2.6441  2.6381  2.6309  2.6251  2.6193  2.6134  2.6070  2.6013  2.5951  2.5896  2.5827  2.5767  2.5707  2.5640  2.5581  2.5529  2.5465  2.5403  2.5340  2.5276  2.5207  2.5138  2.5071  2.5007  2.4939  2.4870  2.4801  2.4734  2.4670  2.4601  2.4530  2.4459  2.4397  2.4327  2.4256  2.4182  2.4109  2.4032  2.3964  2.3889  2.3813  2.3738  2.3660  2.3583  2.3505  2.3430  2.3354  2.3278  2.3197  2.3116  2.3042  2.2966  2.2891  2.2813  2.2729  2.2651  2.2566  2.2481  2.2392  2.2308  2.2218  2.2138  2.2053  2.1971  2.1888  2.1795  2.1708  2.1620  2.1531  2.1445  2.1359  2.1269  2.1181  2.1095  2.1010  2.0924  2.0827  2.0737  2.0652  2.0558  2.0472  2.0379  2.0294  2.0200  2.0108  2.0010  1.9907  1.9806  1.9716  1.9620  1.9526  1.9432  1.9339  1.9241  1.9147  1.9048  1.8955  1.8857  1.8760  1.8667  1.8568  1.8473  1.8379  1.8281  1.8173  1.8074  1.7967  1.7866  1.7763  1.7660  1.7558  1.7456  1.7350  1.7244  1.7135  1.7030  1.6917  1.6811  1.6712  1.6606  1.6501  1.6388  1.6280  1.6171  1.6064  1.5959  1.5849  1.5744  1.5641  1.5532  1.5428  1.5326  1.5220  1.5112  1.5000  1.4886  1.4771  1.4658  1.4544  1.4434  1.4322  1.4201  1.4091  1.3984  1.3871  1.3762  1.3647  1.3527  1.3420  1.3311  1.3204  1.3097  1.2983  1.2870  1.2756  1.2642  1.2524  1.2418  1.2304  1.2185  1.2070  1.1957  1.1842  1.1720  1.1598  1.1480  1.1362  1.1249  1.1137  1.1021  1.0910  1.0794  1.0673  1.0563  1.0437  1.0322  1.0211  1.0098  0.9980  0.9870  0.9769  0.9659  0.9543  0.9425  0.9314  0.9217  0.9111  0.9001  0.8907
 2.7013  2.6967  2.6920  2.6869  2.6820  2.6775  2.6719  2.6663  2.6605  2.6557  2.6505  2.6454  2.6395  2.6339  2.6280  2.6224  2.6167  2.6116  2.6053  2.6004  2.5942  2.5874  2.5809  2.5750  2.5692  2.5624  2.5563  2.5498  2.5435  2.5369  2.5298  2.5231  2.5160  2.5088  2.5019  2.4949  2.4883  2.4815  2.4741  2.4675  2.4604  2.4534  2.4463  2.4389  2.4312  2.4238  2.4164  2.4090  2.4017  2.3941  2.3860  2.3788  2.3714  2.3634  2.3559  2.3477  2.3392  2.3317  2.3242  2.3164  2.3081  2.2999  2.2915  2.2839  2.2752  2.2675  2.2593  2.2505  2.2422  2.2336  2.2252  2.2164  2.2082  2.1996  2.1906  2.1825  2.1743  2.1658  2.1563  2.1477  2.1381  2.1294  2.1206  2.1108  2.1015  2.0918  2.0831  2.0739  2.0653  2.0566  2.0476  2.0391  2.0292  2.0205  2.0112  2.0010  1.9913  1.9814  1.9717  1.9620  1.9525  1.9428  1.9332  1.9235  1.9137  1.9043  1.8946  1.8852  1.8756  1.8657  1.8563  1.8457  1.8359  1.8252  1.8151  1.8044  1.7943  1.7840  1.7732  1.7634  1.7530  1.7429  1.7327  1.7215  1.7112  1.7011  1.6902  1.6794  1.6693  1.6586  1.6474  1.6368  1.6263  1.6148  1.6045  1.5937  1.5831  1.5730  1.5618  1.5511  1.5400  1.5289  1.5174  1.5065  1.4949  1.4827  1.4715  1.4594  1.4487  1.4373  1.4254  1.4142  1.4034  1.3919  1.3801  1.3683  1.3576  1.3460  1.3346  1.3230  1.3117  1.2998  1.2884  1.2765  1.2650  1.2537  1.2425  1.2310  1.2196  1.2085  1.1971  1.1857  1.1744  1.1620  1.1500  1.1393  1.1269  1.1145  1.1034  1.0917  1.0796  1.0682  1.0565  1.0448  1.0345  1.0227  1.0119  1.0001  0.9877  0.9771  0.9663  0.9546  0.9438  0.9332  0.9221  0.9104  0.9015  0.8898  0.8786
 2.7064  2.7012  2.6960  2.6914  2.6866  2.6817  2.6755  2.6698  2.6647  2.6591  2.6534  2.6474  2.6412  2.6366  2.6309  2.6248  2.6195  2.6137  2.6077  2.6022  2.5962  2.5894  2.5838  2.5787  2.5726  2.5658  2.5598  2.5532  2.5460  2.5396  2.5336  2.5270  2.5200  2.5137  2.5072  2.5004  2.4935  2.4858  2.4783  2.4708  2.4632  2.4559  2.4488  2.4417  2.4348  2.4280  2.4209  2.4128  2.4047  2.3971  2.3897  2.3825  2.3747  2.3670  2.3590  2.3516  2.3440  2.3358  2.3277  2.3188  2.3109  2.3028  2.2953  2.2872  2.2786  2.2704  2.2623  2.2551  2.2467  2.2377  2.2289  2.2207  2.2125  2.2038  2.1948  2.1858  2.1768  2.1673  2.1581  2.1494  2.1402  2.1317  2.1220  2.1127  2.1033  2.0937  2.0845  2.0757  2.0667  2.0570  2.0478  2.0392  2.0302  2.0211  2.0111  2.0015  1.9913  1.9816  1.9721  1.9620  1.9523  1.9424  1.9332  1.9235  1.9135  1.9032  1.8938  1.8844  1.8742  1.8646  1.8549  1.8446  1.8339  1.8236  1.8132  1.8032  1.7924  1.7814  1.7710  1.7604  1.7506  1.7411  1.7304  1.7199  1.7089  1.6985  1.6878  1.6768  1.6653  1.6544  1.6438  1.6328  1.6215  1.6106  1.5995  1.5882  1.5772  1.5661  1.5555  1.5440  1.5333  1.5219  1.5108  1.4998  1.4884  1.4772  1.4664  1.4543  1.4430  1.4315  1.4202  1.4091  1.3971  1.3852  1.3734  1.3621  1.3503  1.3396  1.3276  1.3155  1.3031  1.2919  1.2801  1.2688  1.2570  1.2457  1.2351  1.2236  1.2116  1.2001  1.1872  1.1751  1.1630  1.1518  1.1398  1.1279  1.1160  1.1048  1.0928  1.0807  1.0691  1.0577  1.0466  1.0344  1.0226  1.0104  0.9988  0.9886  0.9778  0.9664  0.9550  0.9435  0.9327  0.9209  0.9096  0.8988  0.8876  0.8776  0.8660
 2.7125  2.7071  2.7038  2.6989  2.6916  2.6864  2.6806  2.6753  2.6697  2.6641  2.6594  2.6539  2.6481  2.6423  2.6367  2.6309  2.6257  2.6198  2.6143  2.6093  2.6033  2.5970  2.5913  2.5852  2.5787  2.5724  2.5660  2.5600  2.5532  2.5470  2.5397  2.5332  2.5268  2.5192  2.5131  2.5064  2.4989  2.4918  2.4844  2.4764  2.4692  2.4620  2.4549  2.4479  2.4408  2.4340  2.4274  2.4192  2.4116  2.4038  2.3964  2.3882  2.3805  2.3728  2.3644  2.3564  2.3484  2.3403  2.3320  2.3236  2.3152  2.3068  2.2979  2.2898  2.2819  2.2739  2.2659  2.2574  2.2486  2.2397  2.2317  2.2233  2.2143  2.2059  2.1973  2.1884  2.1794  2.1709  2.1608  2.1522  2.1432  2.1338  2.1240  2.1145  2.1049  2.0958  2.0860  2.0770  2.0674  2.0580  2.0487  2.0395  2.0298  2.0205  2.0113  2.0016  1.9912  1.9812  1.9719  1.9620  1.9525  1.9426  1.9325  1.9230  1.9128  1.9031  1.8929  1.8824  1.8720  1.8620  1.8523  1.8420  1.8318  1.8214  1.8112  1.8003  1.7901  1.7796  1.7694  1.7589  1.7481  1.7374  1.7265  1.7162  1.7056  1.6954  1.6845  1.6729  1.6615  1.6501  1.6393  1.6283  1.6175  1.6063  1.5946  1.5839  1.5733  1.5620  1.5498  1.5385  1.5270  1.5161  1.5047  1.4935  1.4823  1.4708  1.4596  1.4481  1.4372  1.4262  1.4141  1.4029  1.3912  1.3801  1.3681  1.3564  1.3448  1.3329  1.3220  1.3099  1.2987  1.2866  1.2753  1.2639  1.2524  1.2409  1.2283  1.2162  1.2044  1.1929  1.1816  1.1693  1.1569  1.1455  1.1341  1.1219  1.1098  1.0981  1.0858  1.0747  1.0626  1.0506  1.0386  1.0278  1.0166  1.0046  0.9930  0.9813  0.9701  0.9588  0.9475  0.9352  0.9235  0.9125  0.9011  0.8909  0.8792  0.8677  0.8572
 2.7241  2.7177  2.7121  2.7071  2.7024  2.6969  2.6918  2.6859  2.6808  2.6749  2.6692  2.6643  2.6595  2.6545  2.6487  2.6431  2.6373  2.6306  2.6253  2.6192  2.6130  2.6070  2.6004  2.5937  2.5867  2.5809  2.5752  2.5685  2.5618  2.5546  2.5473  2.5400  2.5339  2.5267  2.5196  2.5126  2.5058  2.4987  2.4917  2.4847  2.4770  2.4695  2.4629  2.4555  2.4484  2.4410  2.4333  2.4260  2.4184  2.4100  2.4024  2.3947  2.3873  2.3794  2.3715  2.3630  2.3559  2.3474  2.3392  2.3308  2.3222  2.3131  2.3047  2.2955  2.2868  2.2783  2.2703  2.2617  2.2534  2.2448  2.2357  2.2269  2.2180  2.2094  2.2002  2.1912  2.1823  2.1731  2.1638  2.1550  2.1446  2.1351  2.1261  2.1171  2.1078  2.0978  2.0879  2.0787  2.0691  2.0598  2.0498  2.0405  2.0316  2.0219  2.0121  2.0021  1.9917  1.9819  1.9723  1.9620  1.9523  1.9421  1.9326  1.9226  1.9121  1.9021  1.8923  1.8816  1.8712  1.8608  1.8504  1.8400  1.8301  1.8192  1.8088  1.7982  1.7872  1.7765  1.7656  1.7555  1.7447  1.7337  1.7233  1.7128  1.7020  1.6908  1.6791  1.6678  1.6566  1.6456  1.6342  1.6231  1.6114  1.6000  1.5896  1.5788  1.5670  1.5560  1.5447  1.5333  1.5224  1.5108  1.4991  1.4874  1.4757  1.4645  1.4531  1.4423  1.4316  1.4195  1.4081  1.3967  1.3849  1.3725  1.3609  1.3487  1.3378  1.3257  1.3140  1.3022  1.2904  1.2783  1.2669  1.2554  1.2435  1.2317  1.2202  1.2079  1.1967  1.1842  1.1727  1.1607  1.1495  1.1368  1.1251  1.1132  1.1007  1.0898  1.0771  1.0653  1.0548  1.0437  1.0323  1.0198  1.0076  0.9962  0.9844  0.9726  0.9613  0.9495  0.9375  0.9252  0.9127  0.9017  0.8895  0.8788  0.8679  0.8572  0.8470
 2.7343  2.7268  2.7206  2.7160  2.7100  2.7048  2.6985  2.6926  2.6866  2.6819  2.6767  2.6722  2.6673  2.6625  2.6570  2.6516  2.6456  2.6390  2.6337  2.6267  2.6208  2.6140  2.6067  2.6002  2.5941  2.5868  2.5812  2.5750  2.5684  2.5624  2.5561  2.5488  2.5415  2.5348  2.5280  2.5204  2.5129  2.5062  2.4990  2.4913  2.4841  2.4773  2.4698  2.4620  2.4544  2.4471  2.4390  2.4315  2.4241  2.4165  2.4085  2.4011  2.3930  2.3843  2.3762  2.3683  2.3599  2.3510  2.3431  2.3345  2.3265  2.3182  2.3106  2.3021  2.2935  2.2846  2.2751  2.2666  2.2576  2.2487  2.2397  2.2309  2.2216  2.2130  2.2043  2.1950  2.1859  2.1769  2.1673  2.1580  2.1482  2.1387  2.1294  2.1192  2.1096  2.0996  2.0905  2.0811  2.0717  2.0618  2.0525  2.0426  2.0324  2.0230  2.0126  2.0026  1.9923  1.9824  1.9722  1.9620  1.9522  1.9423  1.9322  1.9212  1.9115  1.9009  1.8905  1.8801  1.8702  1.8601  1.8495  1.8391  1.8284  1.8178  1.8074  1.7964  1.7853  1.7742  1.7634  1.7527  1.7413  1.7309  1.7203  1.7096  1.6984  1.6873  1.6766  1.6654  1.6544  1.6431  1.6318  1.6206  1.6095  1.5981  1.5868  1.5752  1.5645  1.5530  1.5418  1.5307  1.5195  1.5079  1.4963  1.4846  1.4730  1.4613  1.4501  1.4379  1.4262  1.4150  1.4029  1.3918  1.3800  1.3678  1.3559  1.3445  1.3324  1.3202  1.3082  1.2965  1.2847  1.2728  1.2612  1.2494  1.2373  1.2259  1.2143  1.2024  1.1898  1.1781  1.1659  1.1548  1.1428  1.1306  1.1186  1.1063  1.0946  1.0828  1.0704  1.0584  1.0456  1.0333  1.0220  1.0107  0.9994  0.9877  0.9757  0.9634  0.9521  0.9398  0.9290  0.9169  0.9054  0.8934  0.8817  0.8699  0.8590  0.8467  0.8344
 2.7387  2.7328  2.7271  2.7221  2.7168  2.7114  2.7062  2.7009  2.6959  2.6909  2.6853  2.6793  2.6739  2.6682  2.6624  2.6563  2.6500  2.6439  2.6376  2.6323  2.6257  2.6199  2.6140  2.6068  2.6003  2.5947  2.5885  2.5810  2.5742  2.5666  2.5598  2.5527  2.5448  2.5375  2.5305  2.5233  2.5162  2.5093  2.5018  2.4946  2.4870  2.4798  2.4719  2.4644  2.4568  2.4495  2.4426  2.4352  2.4277  2.4195  2.4111  2.4035  2.3956  2.3866  2.3783  2.3700  2.3615  2.3532  2.3449  2.3360  2.3281  2.3198  2.3116  2.3029  2.2940  2.2851  2.2762  2.2676  2.2589  2.2504  2.2414  2.2325  2.2240  2.2147  2.2057  2.1962  2.1869  2.1772  2.1684  2.1592  2.1497  2.1402  2.1309  2.1217  2.1120  2.1024  2.0926  2.0830  2.0726  2.0624  2.0525  2.0428  2.0327  2.0229  2.0132  2.0029  1.9922  1.9819  1.9720  1.9620  1.9516  1.9422  1.9323  1.9213  1.9107  1.9008  1.8907  1.8804  1.8694  1.8596  1.8495  1.8390  1.8278  1.8163  1.8053  1.7957  1.7847  1.7741  1.7635  1.7527  1.7417  1.7304  1.7194  1.7087  1.6968  1.6855  1.6741  1.6630  1.6519  1.6409  1.6300  1.6188  1.6076  1.5963  1.5844  1.5734  1.5618  1.5508  1.5401  1.5282  1.5164  1.5045  1.4931  1.4817  1.4700  1.4583  1.4461  1.4340  1.4229  1.4115  1.3995  1.3879  1.3765  1.3642  1.3527  1.3405  1.3285  1.3171  1.3048  1.2929  1.2810  1.2696  1.2574  1.2450  1.2335  1.2213  1.2090  1.1966  1.1847  1.1718  1.1595  1.1473  1.1354  1.1232  1.1116  1.0995  1.0882  1.0763  1.0647  1.0519  1.0397  1.0277  1.0161  1.0044  0.9919  0.9800  0.9678  0.9562  0.9440  0.9320  0.9201  0.9082  0.8963  0.8847  0.8735  0.8620  0.8508  0.8385  0.8275
 2.7484  2.7435  2.7387  2.7339  2.7284  2.7219  2.7162  2.7107  2.7057  2.6996  2.6951  2.6901  2.6841  2.6781  2.6727  2.6670  2.6613  2.6546  2.6486  2.6424  2.6354  2.6293  2.6227  2.6157  2.6092  2.6030  2.5970  2.5903  2.5835  2.5768  2.5695  2.5628  2.5556  2.5474  2.5407  2.5331  2.5252  2.5180  2.5103  2.5037  2.4960  2.4886  2.4806  2.4731  2.4653  2.4574  2.4492  2.4415  2.4328  2.4248  2.4166  2.4087  2.4004  2.3920  2.3834  2.3751  2.3667  2.3588  2.3497  2.3410  2.3328  2.3244  2.3158  2.3071  2.2982  2.2887  2.2795  2.2711  2.2617  2.2533  2.2445  2.2354  2.2270  2.2174  2.2082  2.1992  2.1904  2.1810  2.1714  2.1621  2.1528  2.1431  2.1338  2.1240  2.1146  2.1040  2.0943  2.0848  2.0742  2.0637  2.0539  2.0437  2.0340  2.0240  2.0131  2.0030  1.9927  1.9824  1.9720  1.9620  1.9516  1.9417  1.9313  1.9209  1.9101  1.9000  1.8891  1.8790  1.8686  1.8585  1.8476  1.8372  1.8262  1.8154  1.8040  1.7935  1.7822  1.7713  1.7605  1.7495  1.7382  1.7266  1.7156  1.7044  1.6932  1.6827  1.6713  1.6602  1.6492  1.6374  1.6269  1.6157  1.6041  1.5931  1.5814  1.5699  1.5589  1.5476  1.5364  1.5248  1.5125  1.5010  1.4887  1.4777  1.4667  1.4552  1.4440  1.4325  1.4205  1.4087  1.3967  1.3850  1.3727  1.3610  1.3489  1.3372  1.3248  1.3126  1.3005  1.2885  1.2767  1.2648  1.2525  1.2412  1.2292  1.2176  1.2053  1.1935  1.1814  1.1689  1.1560  1.1440  1.1312  1.1199  1.1073  1.0945  1.0825  1.0704  1.0589  1.0468  1.0346  1.0215  1.0092  0.9970  0.9844  0.9723  0.9596  0.9477  0.9354  0.9231  0.9116  0.9003  0.8880  0.8763  0.8651  0.8532  0.8414  0.8302  0.8171
 2.7618  2.7559  2.7517  2.7459  2.7394  2.7346  2.7291  2.7228  2.7165  2.7106  2.7047  2.6995  2.6945  2.6891  2.6836  2.6782  2.6716  2.6653  2.6591  2.6530  2.6465  2.6403  2.6336  2.6270  2.6200  2.6136  2.6067  2.5995  2.5926  2.5850  2.5783  2.5707  2.5627  2.5559  2.5481  2.5410  2.5337  2.5263  2.5183  2.5107  2.5032  2.4950  2.4869  2.4794  2.4713  2.4638  2.4553  2.4465  2.4390  2.4305  2.4223  2.4143  2.4054  2.3970  2.3880  2.3791  2.3704  2.3614  2.3525  2.3441  2.3355  2.3263  2.3177  2.3090  2.3000  2.2914  2.2824  2.2736  2.2643  2.2558  2.2466  2.2368  2.2274  2.2182  2.2088  2.1997  2.1902  2.1809  2.1713  2.1616  2.1520  2.1428  2.1332  2.1233  2.1133  2.1034  2.0938  2.0846  2.0742  2.0644  2.0542  2.0445  2.0348  2.0243  2.0137  2.0035  1.9927  1.9824  1.9723  1.9620  1.9513  1.9414  1.9311  1.9204  1.9095  1.8991  1.8891  1.8781  1.8675  1.8569  1.8459  1.8355  1.8248  1.8136  1.8024  1.7914  1.7809  1.7702  1.7592  1.7481  1.7368  1.7259  1.7137  1.7030  1.6917  1.6800  1.6691  1.6579  1.6467  1.6355  1.6238  1.6128  1.6017  1.5907  1.5796  1.5687  1.5572  1.5451  1.5336  1.5219  1.5100  1.4985  1.4869  1.4753  1.4638  1.4518  1.4399  1.4275  1.4160  1.4039  1.3927  1.3801  1.3679  1.3559  1.3438  1.3318  1.3202  1.3078  1.2955  1.2841  1.2716  1.2591  1.2473  1.2357  1.2226  1.2105  1.1982  1.1854  1.1740  1.1618  1.1490  1.1372  1.1251  1.1132  1.1006  1.0887  1.0761  1.0641  1.0516  1.0390  1.0267  1.0145  1.0020  0.9895  0.9770  0.9650  0.9527  0.9401  0.9277  0.9145  0.9027  0.8901  0.8773  0.8652  0.8538  0.8417  0.8306  0.8181  0.8056
 2.7725  2.7662  2.7605  2.7560  2.7504  2.7445  2.7385  2.7336  2.7277  2.7219  2.7157  2.7096  2.7048  2.6992  2.6931  2.6869  2.6796  2.6741  2.6683  2.6616  2.6558  2.6492  2.6416  2.6344  2.6278  2.6210  2.6144  2.6065  2.5994  2.5921  2.5852  2.5775  2.5702  2.5623  2.5545  2.5466  2.5392  2.5315  2.5244  2.5171  2.5095  2.5016  2.4929  2.4846  2.4762  2.4677  2.4594  2.4510  2.4425  2.4341  2.4256  2.4176  2.4092  2.4012  2.3932  2.3847  2.3761  2.3671  2.3587  2.3498  2.3407  2.3321  2.3230  2.3137  2.3044  2.2955  2.2861  2.2777  2.2685  2.2588  2.2496  2.2402  2.2306  2.2215  2.2126  2.2034  2.1943  2.1848  2.1748  2.1650  2.1548  2.1453  2.1357  2.1261  2.1163  2.1060  2.0958  2.0854  2.0755  2.0650  2.0561  2.0456  2.0357  2.0254  2.0147  2.0047  1.9933  1.9829  1.9724  1.9620  1.9517  1.9412  1.9311  1.9203  1.9092  1.8987  1.8880  1.8774  1.8663  1.8555  1.8446  1.8344  1.8234  1.8124  1.8014  1.7900  1.7787  1.7672  1.7564  1.7450  1.7340  1.7234  1.7127  1.7014  1.6906  1.6788  1.6673  1.6562  1.6452  1.6336  1.6223  1.6108  1.5996  1.5881  1.5765  1.5646  1.5536  1.5425  1.5309  1.5191  1.5071  1.4957  1.4843  1.4723  1.4603  1.4486  1.4368  1.4247  1.4125  1.3997  1.3873  1.3747  1.3624  1.3511  1.3385  1.3266  1.3146  1.3032  1.2909  1.2789  1.2676  1.2546  1.2425  1.2304  1.2183  1.2054  1.1933  1.1808  1.1686  1.1550  1.1422  1.1299  1.1181  1.1060  1.0938  1.0811  1.0688  1.0563  1.0438  1.0312  1.0186  1.0058  0.9933  0.9812  0.9695  0.9572  0.9450  0.9334  0.9209  0.9083  0.8959  0.8829  0.8704  0.8592  0.8477  0.8359  0.8242  0.8115  0.8001
 2.7869  2.7807  2.7750  2.7694  2.7630  2.7582  2.7522  2.7460  2.7400  2.7338  2.7281  2.7231  2.7170  2.7104  2.7039  2.6970  2.6909  2.6837  2.6777  2.6703  2.6637  2.6562  2.6495  2.6431  2.6362  2.6289  2.6214  2.6142  2.6070  2.6005  2.5931  2.5853  2.5776  2.5698  2.5620  2.5543  2.5463  2.5382  2.5298  2.5222  2.5141  2.5062  2.4981  2.4891  2.4808  2.4728  2.4646  2.4559  2.4474  2.4389  2.4304  2.4218  2.4131  2.4040  2.3958  2.3864  2.3771  2.3685  2.3597  2.3513  2.3425  2.3339  2.3253  2.3162  2.3077  2.2985  2.2896  2.2808  2.2715  2.2628  2.2536  2.2438  2.2344  2.2252  2.2155  2.2054  2.1957  2.1863  2.1767  2.1672  2.1574  2.1477  2.1374  2.1273  2.1172  2.1072  2.0969  2.0864  2.0765  2.0662  2.0564  2.0464  2.0362  2.0255  2.0150  2.0044  1.9936  1.9827  1.9724  1.9620  1.9517  1.9412  1.9309  1.9202  1.9091  1.8979  1.8875  1.8766  1.8657  1.8546  1.8436  1.8324  1.8212  1.8105  1.7998  1.7893  1.7784  1.7676  1.7560  1.7444  1.7333  1.7223  1.7113  1.7007  1.6899  1.6786  1.6666  1.6545  1.6433  1.6316  1.6206  1.6091  1.5973  1.5863  1.5741  1.5628  1.5508  1.5392  1.5281  1.5170  1.5049  1.4936  1.4811  1.4687  1.4568  1.4445  1.4329  1.4206  1.4086  1.3955  1.3835  1.3717  1.3599  1.3479  1.3357  1.3236  1.3114  1.2997  1.2879  1.2760  1.2633  1.2511  1.2388  1.2267  1.2142  1.2019  1.1893  1.1774  1.1649  1.1530  1.1414  1.1291  1.1157  1.1028  1.0906  1.0780  1.0655  1.0535  1.0410  1.0287  1.0157  1.0024  0.9897  0.9773  0.9642  0.9514  0.9390  0.9262  0.9138  0.9015  0.8893  0.8778  0.8650  0.8540  0.8410  0.8280  0.8155  0.8042  0.7914
 2.7956  2.7899  2.7849  2.7794  2.7750  2.7689  2.7636  2.7585  2.7515  2.7453  2.7388  2.7338  2.7264  2.7198  2.7137  2.7073  2.7005  2.6936  2.6862  2.6799  2.6726  2.6654  2.6578  2.6502  2.6427  2.6363  2.6290  2.6224  2.6157  2.6077  2.6001  2.5930  2.5852  2.5766  2.5688  2.5608  2.5529  2.5446  2.5366  2.5283  2.5202  2.5125  2.5042  2.4958  2.4875  2.4795  2.4707  2.4623  2.4539  2.4458  2.4376  2.4289  2.4198  2.4109  2.4019  2.3933  2.3845  2.3755  2.3671  2.3581  2.3492  2.3392  2.3301  2.3211  2.3113  2.3023  2.2934  2.2833  2.2734  2.2646  2.2548  2.2455  2.2359  2.2268  2.2173  2.2076  2.1973  2.1872  2.1782  2.1679  2.1579  2.1487  2.1386  2.1285  2.1184  2.1078  2.0979  2.0875  2.0775  2.0676  2.0573  2.0470  2.0365  2.0262  2.0152  2.0049  1.9940  1.9830  1.9725  1.9620  1.9516  1.9414  1.9303  1.9199  1.9087  1.8975  1.8868  1.8757  1.8650  1.8540  1.8431  1.8321  1.8215  1.8106  1.7999  1.7886  1.7773  1.7663  1.7552  1.7440  1.7322  1.7211  1.7098  1.6983  1.6872  1.6763  1.6641  1.6524  1.6414  1.6294  1.6178  1.6059  1.5948  1.5829  1.5717  1.5604  1.5486  1.5371  1.5261  1.5143  1.5025  1.4906  1.4784  1.4666  1.4550  1.4428  1.4305  1.4182  1.4056  1.3931  1.3815  1.3694  1.3570  1.3447  1.3328  1.3214  1.3097  1.2974  1.2847  1.2720  1.2594  1.2477  1.2359  1.2241  1.2109  1.1988  1.1866  1.1744  1.1617  1.1487  1.1357  1.1232  1.1108  1.0980  1.0853  1.0734  1.0615  1.0490  1.0370  1.0255  1.0127  1.0003  0.9872  0.9749  0.9625  0.9500  0.9378  0.9252  0.9127  0.8997  0.8873  0.8742  0.8616  0.8506  0.8380  0.8267  0.8148  0.8008  0.7903
 2.8144  2.8083  2.8015  2.7960  2.7900  2.7849  2.7788  2.7722  2.7664  2.7600  2.7533  2.7469  2.7411  2.7347  2.7279  2.7209  2.7137  2.7073  2.7000  2.6917  2.6844  2.6773  2.6702  2.6630  2.6552  2.6476  2.6400  2.6323  2.6244  2.6164  2.6085  2.6011  2.5937  2.5854  2.5774  2.5688  2.5602  2.5520  2.5439  2.5356  2.5277  2.5191  2.5109  2.5026  2.4936  2.4847  2.4752  2.4668  2.4574  2.4491  2.4405  2.4319  2.4223  2.4136  2.4049  2.3960  2.3870  2.3770  2.3680  2.3592  2.3501  2.3407  2.3308  2.3217  2.3120  2.3023  2.2924  2.2834  2.2742  2.2647  2.2548  2.2456  2.2365  2.2271  2.2173  2.2074  2.1981  2.1886  2.1783  2.1683  2.1587  2.1486  2.1388  2.1294  2.1193  2.1090  2.0984  2.0882  2.0774  2.0672  2.0570  2.0471  2.0368  2.0261  2.0156  2.0050  1.9936  1.9831  1.9725  1.9620  1.9519  1.9413  1.9303  1.9194  1.9080  1.8974  1.8863  1.8758  1.8649  1.8541  1.8434  1.8320  1.8209  1.8098  1.7993  1.7883  1.7771  1.7657  1.7546  1.7428  1.7319  1.7206  1.7091  1.6985  1.6874  1.6755  1.6644  1.6536  1.6418  1.6299  1.6179  1.6061  1.5944  1.5828  1.5708  1.5593  1.5471  1.5354  1.5231  1.5113  1.4999  1.4879  1.4761  1.4642  1.4516  1.4396  1.4275  1.4154  1.4030  1.3909  1.3783  1.3667  1.3540  1.3420  1.3301  1.3176  1.3050  1.2928  1.2808  1.2693  1.2567  1.2447  1.2320  1.2189  1.2068  1.1949  1.1825  1.1710  1.1592  1.1466  1.1346  1.1218  1.1089  1.0965  1.0840  1.0707  1.0574  1.0454  1.0332  1.0212  1.0081  0.9954  0.9828  0.9704  0.9567  0.9440  0.9315  0.9194  0.9078  0.8942  0.8817  0.8689  0.8556  0.8424  0.8301  0.8177  0.8064  0.7943  0.7831
 2.8326  2.8259  2.8204  2.8139  2.8076  2.8014  2.7953  2.7879  2.7809  2.7740  2.7668  2.7602  2.7531  2.7457  2.7394  2.7319  2.7242  2.7172  2.7102  2.7024  2.6949  2.6876  2.6804  2.6725  2.6650  2.6572  2.6494  2.6422  2.6336  2.6256  2.6173  2.6092  2.6015  2.5928  2.5849  2.5761  2.5681  2.5603  2.5514  2.5432  2.5345  2.5267  2.5177  2.5091  2.5001  2.4911  2.4827  2.4738  2.4651  2.4559  2.4469  2.4382  2.4290  2.4199  2.4111  2.4019  2.3929  2.3829  2.3733  2.3643  2.3555  2.3462  2.3372  2.3275  2.3186  2.3087  2.2991  2.2895  2.2797  2.2701  2.2595  2.2495  2.2400  2.2303  2.2200  2.2098  2.1999  2.1905  2.1803  2.1700  2.1606  2.1505  2.1409  2.1309  2.1207  2.1102  2.0998  2.0891  2.0787  2.0683  2.0577  2.0474  2.0373  2.0263  2.0157  2.0047  1.9935  1.9833  1.9722  1.9620  1.9518  1.9412  1.9306  1.9198  1.9086  1.8977  1.8866  1.8758  1.8649  1.8540  1.8430  1.8318  1.8210  1.8101  1.7988  1.7876  1.7762  1.7659  1.7549  1.7438  1.7318  1.7202  1.7088  1.6973  1.6863  1.6749  1.6634  1.6518  1.6398  1.6283  1.6164  1.6057  1.5937  1.5821  1.5697  1.5586  1.5473  1.5349  1.5231  1.5110  1.4994  1.4876  1.4761  1.4640  1.4516  1.4397  1.4273  1.4148  1.4026  1.3906  1.3790  1.3677  1.3554  1.3433  1.3312  1.3190  1.3063  1.2938  1.2816  1.2698  1.2578  1.2444  1.2309  1.2182  1.2057  1.1935  1.1807  1.1672  1.1551  1.1425  1.1299  1.1167  1.1045  1.0922  1.0797  1.0671  1.0542  1.0425  1.0295  1.0173  1.0055  0.9922  0.9808  0.9678  0.9546  0.9414  0.9295  0.9177  0.9048  0.8934  0.8805  0.8673  0.8547  0.8416  0.8289  0.8159  0.8022  0.7901  0.7772
 2.8507  2.8439  2.8363  2.8307  2.8242  2.8170  2.8098  2.8027  2.7953  2.7894  2.7822  2.7749  2.7677  2.7607  2.7534  2.7455  2.7383  2.7307  2.7230  2.7151  2.7083  2.7008  2.6931  2.6851  2.6766  2.6696  2.6614  2.6530  2.6450  2.6368  2.6280  2.6197  2.6110  2.6024  2.5942  2.5857  2.5769  2.5687  2.5601  2.5514  2.5423  2.5331  2.5241  2.5149  2.5055  2.4965  2.4871  2.4774  2.4681  2.4594  2.4506  2.4412  2.4320  2.4225  2.4131  2.4039  2.3949  2.3854  2.3759  2.3668  2.3570  2.3481  2.3385  2.3292  2.3194  2.3100  2.2998  2.2904  2.2810  2.2709  2.2612  2.2518  2.2421  2.2315  2.2215  2.2114  2.2013  2.1913  2.1814  2.1711  2.1608  2.1506  2.1407  2.1311  2.1204  2.1100  2.0996  2.0891  2.0788  2.0684  2.0579  2.0472  2.0368  2.0264  2.0160  2.0047  1.9938  1.9827  1.9721  1.9620  1.9520  1.9412  1.9306  1.9196  1.9088  1.8978  1.8872  1.8761  1.8646  1.8537  1.8432  1.8318  1.8209  1.8104  1.7998  1.7887  1.7778  1.7670  1.7555  1.7433  1.7312  1.7198  1.7087  1.6971  1.6861  1.6743  1.6633  1.6521  1.6404  1.6283  1.6165  1.6046  1.5929  1.5815  1.5697  1.5582  1.5466  1.5348  1.5229  1.5111  1.4994  1.4871  1.4755  1.4634  1.4508  1.4385  1.4261  1.4140  1.4011  1.3888  1.3765  1.3644  1.3526  1.3396  1.3270  1.3142  1.3019  1.2897  1.2780  1.2653  1.2523  1.2403  1.2283  1.2162  1.2032  1.1914  1.1793  1.1666  1.1538  1.1404  1.1280  1.1161  1.1044  1.0920  1.0796  1.0664  1.0541  1.0418  1.0295  1.0166  1.0049  0.9915  0.9787  0.9662  0.9530  0.9402  0.9269  0.9142  0.9020  0.8891  0.8760  0.8637  0.8512  0.8387  0.8257  0.8138  0.8011  0.7878  0.7751
 2.8632  2.8567  2.8486  2.8413  2.8337  2.8268  2.8207  2.8123  2.8057  2.7984  2.7912  2.7825  2.7743  2.7665  2.7586  2.7507  2.7431  2.7353  2.7274  2.7189  2.7112  2.7037  2.6956  2.6874  2.6796  2.6716  2.6639  2.6559  2.6471  2.6383  2.6295  2.6209  2.6129  2.6042  2.5960  2.5871  2.5782  2.5692  2.5602  2.5507  2.5416  2.5323  2.5237  2.5146  2.5052  2.4962  2.4872  2.4783  2.4689  2.4604  2.4513  2.4422  2.4334  2.4242  2.4149  2.4052  2.3960  2.3868  2.3778  2.3683  2.3588  2.3495  2.3403  2.3300  2.3209  2.3116  2.3025  2.2924  2.2828  2.2727  2.2631  2.2530  2.2424  2.2323  2.2217  2.2115  2.2018  2.1917  2.1819  2.1713  2.1610  2.1505  2.1404  2.1301  2.1198  2.1096  2.0997  2.0893  2.0793  2.0698  2.0597  2.0490  2.0385  2.0271  2.0163  2.0047  1.9941  1.9828  1.9723  1.9620  1.9521  1.9413  1.9309  1.9202  1.9088  1.8980  1.8866  1.8757  1.8650  1.8540  1.8437  1.8329  1.8219  1.8106  1.8000  1.7877  1.7757  1.7645  1.7532  1.7416  1.7301  1.7187  1.7070  1.6956  1.6842  1.6729  1.6609  1.6495  1.6386  1.6265  1.6156  1.6038  1.5925  1.5814  1.5693  1.5573  1.5452  1.5333  1.5210  1.5086  1.4971  1.4849  1.4730  1.4614  1.4497  1.4367  1.4247  1.4124  1.4011  1.3891  1.3763  1.3637  1.3513  1.3393  1.3267  1.3149  1.3031  1.2910  1.2788  1.2667  1.2545  1.2416  1.2289  1.2163  1.2031  1.1902  1.1772  1.1639  1.1518  1.1391  1.1264  1.1138  1.1017  1.0888  1.0761  1.0642  1.0514  1.0389  1.0258  1.0129  1.0002  0.9880  0.9752  0.9619  0.9500  0.9372  0.9239  0.9114  0.8993  0.8875  0.8755  0.8617  0.8490  0.8363  0.8224  0.8092  0.7969  0.7859  0.7727
 2.8681  2.8607  2.8539  2.8476  2.8406  2.8328  2.8255  2.8184  2.8115  2.8042  2.7975  2.7899  2.7828  2.7749  2.7661  2.7579  2.7492  2.7413  2.7329  2.7250  2.7171  2.7090  2.7012  2.6927  2.6840  2.6756  2.6674  2.6591  2.6504  2.6418  2.6331  2.6250  2.6158  2.6071  2.5989  2.5899  2.5812  2.5725  2.5634  2.5543  2.5454  2.5371  2.5283  2.5189  2.5089  2.4995  2.4910  2.4820  2.4735  2.4637  2.4542  2.4450  2.4353  2.4262  2.4170  2.4076  2.3987  2.3890  2.3798  2.3701  2.3605  2.3512  2.3408  2.3310  2.3215  2.3122  2.3027  2.2926  2.2828  2.2731  2.2632  2.2533  2.2434  2.2327  2.2229  2.2126  2.2026  2.1923  2.1821  2.1722  2.1620  2.1524  2.1420  2.1315  2.1209  2.1103  2.1005  2.0900  2.0801  2.0694  2.0596  2.0488  2.0374  2.0273  2.0157  2.0048  1.9941  1.9832  1.9723  1.9620  1.9520  1.9409  1.9304  1.9202  1.9096  1.8985  1.8876  1.8765  1.8659  1.8544  1.8443  1.8332  1.8224  1.8112  1.8005  1.7900  1.7781  1.7671  1.7551  1.7434  1.7318  1.7208  1.7096  1.6979  1.6859  1.6740  1.6628  1.6511  1.6389  1.6266  1.6151  1.6032  1.5919  1.5800  1.5683  1.5569  1.5457  1.5338  1.5220  1.5104  1.4985  1.4865  1.4743  1.4620  1.4502  1.4383  1.4262  1.4140  1.4018  1.3900  1.3782  1.3659  1.3541  1.3414  1.3292  1.3175  1.3053  1.2918  1.2791  1.2660  1.2529  1.2411  1.2287  1.2162  1.2042  1.1921  1.1799  1.1673  1.1553  1.1420  1.1293  1.1169  1.1030  1.0907  1.0780  1.0651  1.0521  1.0397  1.0268  1.0147  1.0016  0.9886  0.9763  0.9636  0.9509  0.9381  0.9251  0.9124  0.8987  0.8862  0.8738  0.8606  0.8489  0.8358  0.8234  0.8110  0.7973  0.7839  0.7702
];

cv5=[  -1.4937   -1.4951   -1.4966   -1.4986   -1.4998   -1.5018   -1.5033   -1.5055   -1.5074   -1.5087   -1.5099   -1.5119   -1.5137   -1.5150   -1.5162   -1.5175   -1.5182   -1.5200   -1.5213   -1.5225   -1.5242   -1.5264   -1.5280   -1.5294   -1.5311   -1.5331   -1.5344   -1.5363   -1.5384   -1.5396   -1.5412   -1.5429   -1.5451   -1.5469   -1.5479   -1.5489   -1.5503   -1.5516   -1.5526   -1.5539   -1.5550   -1.5568   -1.5588   -1.5603   -1.5617   -1.5628   -1.5647   -1.5658   -1.5671   -1.5688   -1.5702   -1.5713   -1.5727   -1.5746   -1.5759   -1.5773   -1.5791   -1.5809   -1.5819   -1.5836   -1.5851   -1.5868   -1.5883   -1.5894   -1.5908   -1.5919   -1.5933   -1.5948   -1.5964   -1.5981   -1.5997   -1.6013   -1.6026   -1.6044   -1.6061   -1.6075   -1.6089   -1.6103   -1.6122   -1.6135   -1.6149   -1.6173   -1.6186   -1.6203   -1.6219   -1.6233   -1.6245   -1.6257   -1.6268   -1.6281   -1.6294   -1.6307   -1.6322   -1.6338   -1.6353   -1.6371   -1.6387   -1.6401   -1.6420   -1.6436   -1.6455   -1.6477   -1.6489   -1.6502   -1.6516   -1.6534   -1.6551   -1.6567   -1.6583   -1.6599   -1.6613   -1.6627   -1.6644   -1.6660   -1.6675   -1.6687   -1.6699   -1.6711   -1.6731   -1.6744   -1.6760   -1.6773   -1.6790   -1.6806   -1.6822   -1.6838   -1.6853   -1.6864   -1.6873   -1.6887   -1.6903   -1.6917   -1.6930   -1.6945   -1.6963   -1.6978   -1.6994   -1.7010   -1.7026   -1.7041   -1.7054   -1.7066   -1.7083   -1.7097   -1.7111   -1.7129   -1.7144   -1.7159   -1.7173   -1.7191   -1.7197   -1.7214   -1.7233   -1.7251   -1.7266   -1.7280   -1.7291   -1.7304   -1.7316   -1.7326   -1.7335   -1.7351   -1.7366   -1.7382   -1.7398   -1.7411   -1.7424   -1.7436   -1.7450   -1.7463   -1.7482   -1.7502   -1.7519   -1.7529   -1.7544   -1.7556   -1.7569   -1.7594   -1.7613   -1.7628   -1.7647   -1.7659   -1.7681   -1.7695   -1.7711   -1.7723   -1.7744   -1.7762   -1.7773   -1.7792   -1.7807   -1.7818   -1.7838   -1.7848   -1.7863   -1.7872   -1.7881   -1.7888   -1.7892
 -1.4277   -1.4299   -1.4328   -1.4348   -1.4378   -1.4405   -1.4427   -1.4443   -1.4462   -1.4488   -1.4505   -1.4537   -1.4549   -1.4576   -1.4595   -1.4611   -1.4632   -1.4658   -1.4680   -1.4707   -1.4731   -1.4756   -1.4777   -1.4802   -1.4827   -1.4845   -1.4863   -1.4883   -1.4908   -1.4934   -1.4949   -1.4972   -1.4993   -1.5015   -1.5033   -1.5061   -1.5084   -1.5107   -1.5128   -1.5149   -1.5167   -1.5190   -1.5214   -1.5230   -1.5249   -1.5268   -1.5283   -1.5303   -1.5326   -1.5347   -1.5375   -1.5397   -1.5422   -1.5437   -1.5468   -1.5487   -1.5510   -1.5532   -1.5555   -1.5572   -1.5593   -1.5616   -1.5642   -1.5663   -1.5687   -1.5709   -1.5728   -1.5753   -1.5772   -1.5796   -1.5817   -1.5838   -1.5862   -1.5882   -1.5908   -1.5927   -1.5950   -1.5974   -1.5992   -1.6012   -1.6027   -1.6047   -1.6070   -1.6088   -1.6110   -1.6133   -1.6158   -1.6180   -1.6199   -1.6220   -1.6238   -1.6260   -1.6282   -1.6304   -1.6324   -1.6343   -1.6367   -1.6389   -1.6413   -1.6436   -1.6460   -1.6486   -1.6502   -1.6520   -1.6544   -1.6562   -1.6586   -1.6606   -1.6626   -1.6652   -1.6675   -1.6700   -1.6715   -1.6734   -1.6756   -1.6776   -1.6799   -1.6822   -1.6842   -1.6861   -1.6883   -1.6909   -1.6936   -1.6955   -1.6976   -1.6995   -1.7015   -1.7034   -1.7060   -1.7080   -1.7102   -1.7120   -1.7138   -1.7157   -1.7184   -1.7207   -1.7225   -1.7242   -1.7264   -1.7286   -1.7309   -1.7334   -1.7353   -1.7370   -1.7394   -1.7422   -1.7442   -1.7465   -1.7486   -1.7506   -1.7525   -1.7540   -1.7564   -1.7583   -1.7600   -1.7620   -1.7638   -1.7657   -1.7683   -1.7705   -1.7725   -1.7744   -1.7764   -1.7790   -1.7808   -1.7833   -1.7859   -1.7877   -1.7895   -1.7923   -1.7946   -1.7970   -1.7989   -1.8011   -1.8036   -1.8053   -1.8069   -1.8094   -1.8111   -1.8135   -1.8157   -1.8177   -1.8200   -1.8221   -1.8236   -1.8260   -1.8281   -1.8304   -1.8324   -1.8347   -1.8369   -1.8394   -1.8413   -1.8433   -1.8455   -1.8479   -1.8493   -1.8507   -1.8526
 -1.3791   -1.3818   -1.3850   -1.3878   -1.3905   -1.3926   -1.3955   -1.3982   -1.4003   -1.4030   -1.4058   -1.4093   -1.4123   -1.4150   -1.4175   -1.4200   -1.4226   -1.4248   -1.4273   -1.4300   -1.4329   -1.4353   -1.4383   -1.4416   -1.4443   -1.4474   -1.4499   -1.4521   -1.4550   -1.4581   -1.4610   -1.4635   -1.4661   -1.4691   -1.4721   -1.4745   -1.4777   -1.4806   -1.4834   -1.4859   -1.4879   -1.4910   -1.4935   -1.4963   -1.4990   -1.5018   -1.5047   -1.5077   -1.5105   -1.5134   -1.5160   -1.5189   -1.5212   -1.5237   -1.5260   -1.5287   -1.5312   -1.5339   -1.5370   -1.5400   -1.5425   -1.5450   -1.5474   -1.5497   -1.5521   -1.5550   -1.5575   -1.5599   -1.5627   -1.5655   -1.5682   -1.5709   -1.5735   -1.5760   -1.5788   -1.5813   -1.5831   -1.5860   -1.5882   -1.5910   -1.5938   -1.5963   -1.5994   -1.6021   -1.6047   -1.6072   -1.6091   -1.6118   -1.6144   -1.6173   -1.6196   -1.6219   -1.6246   -1.6271   -1.6294   -1.6321   -1.6350   -1.6378   -1.6404   -1.6436   -1.6465   -1.6493   -1.6518   -1.6544   -1.6569   -1.6594   -1.6622   -1.6650   -1.6669   -1.6691   -1.6719   -1.6746   -1.6775   -1.6796   -1.6820   -1.6845   -1.6872   -1.6896   -1.6923   -1.6947   -1.6978   -1.7009   -1.7034   -1.7057   -1.7082   -1.7106   -1.7135   -1.7163   -1.7187   -1.7218   -1.7244   -1.7267   -1.7293   -1.7320   -1.7345   -1.7369   -1.7395   -1.7420   -1.7442   -1.7465   -1.7490   -1.7523   -1.7546   -1.7569   -1.7601   -1.7621   -1.7651   -1.7673   -1.7702   -1.7733   -1.7759   -1.7782   -1.7807   -1.7831   -1.7863   -1.7890   -1.7920   -1.7945   -1.7975   -1.7998   -1.8023   -1.8049   -1.8072   -1.8098   -1.8126   -1.8150   -1.8174   -1.8196   -1.8225   -1.8247   -1.8274   -1.8302   -1.8331   -1.8354   -1.8379   -1.8400   -1.8430   -1.8455   -1.8478   -1.8508   -1.8532   -1.8556   -1.8578   -1.8603   -1.8626   -1.8655   -1.8681   -1.8705   -1.8737   -1.8765   -1.8787   -1.8817   -1.8841   -1.8869   -1.8899   -1.8917   -1.8950   -1.8970   -1.9002
 -1.3357   -1.3393   -1.3428   -1.3462   -1.3498   -1.3528   -1.3561   -1.3595   -1.3626   -1.3655   -1.3681   -1.3709   -1.3742   -1.3778   -1.3806   -1.3839   -1.3870   -1.3901   -1.3929   -1.3959   -1.3991   -1.4026   -1.4058   -1.4090   -1.4114   -1.4145   -1.4181   -1.4209   -1.4239   -1.4272   -1.4302   -1.4333   -1.4364   -1.4391   -1.4417   -1.4455   -1.4484   -1.4520   -1.4556   -1.4584   -1.4623   -1.4657   -1.4689   -1.4718   -1.4750   -1.4779   -1.4807   -1.4838   -1.4870   -1.4901   -1.4931   -1.4965   -1.4997   -1.5029   -1.5059   -1.5089   -1.5119   -1.5153   -1.5186   -1.5219   -1.5248   -1.5278   -1.5310   -1.5345   -1.5372   -1.5400   -1.5424   -1.5449   -1.5481   -1.5512   -1.5545   -1.5580   -1.5607   -1.5638   -1.5669   -1.5701   -1.5732   -1.5753   -1.5783   -1.5816   -1.5849   -1.5885   -1.5915   -1.5947   -1.5979   -1.6009   -1.6038   -1.6067   -1.6099   -1.6129   -1.6159   -1.6183   -1.6214   -1.6243   -1.6274   -1.6301   -1.6335   -1.6371   -1.6401   -1.6436   -1.6469   -1.6501   -1.6529   -1.6563   -1.6592   -1.6619   -1.6648   -1.6678   -1.6705   -1.6732   -1.6758   -1.6788   -1.6824   -1.6853   -1.6879   -1.6912   -1.6944   -1.6976   -1.7004   -1.7036   -1.7066   -1.7099   -1.7128   -1.7157   -1.7188   -1.7218   -1.7249   -1.7280   -1.7304   -1.7336   -1.7365   -1.7392   -1.7418   -1.7445   -1.7481   -1.7511   -1.7546   -1.7577   -1.7600   -1.7634   -1.7663   -1.7688   -1.7716   -1.7741   -1.7774   -1.7800   -1.7836   -1.7871   -1.7903   -1.7937   -1.7970   -1.8001   -1.8033   -1.8062   -1.8091   -1.8120   -1.8146   -1.8173   -1.8202   -1.8232   -1.8260   -1.8287   -1.8319   -1.8348   -1.8380   -1.8414   -1.8447   -1.8476   -1.8507   -1.8533   -1.8568   -1.8596   -1.8626   -1.8654   -1.8680   -1.8710   -1.8739   -1.8762   -1.8791   -1.8822   -1.8852   -1.8876   -1.8901   -1.8923   -1.8953   -1.8981   -1.9009   -1.9037   -1.9072   -1.9094   -1.9123   -1.9156   -1.9189   -1.9219   -1.9246   -1.9270   -1.9299   -1.9330   -1.9366
 -1.2978   -1.3022   -1.3060   -1.3093   -1.3129   -1.3159   -1.3187   -1.3226   -1.3258   -1.3297   -1.3338   -1.3369   -1.3396   -1.3420   -1.3459   -1.3493   -1.3528   -1.3561   -1.3599   -1.3638   -1.3677   -1.3717   -1.3753   -1.3788   -1.3820   -1.3853   -1.3891   -1.3926   -1.3967   -1.4009   -1.4043   -1.4079   -1.4109   -1.4141   -1.4178   -1.4210   -1.4240   -1.4279   -1.4314   -1.4347   -1.4380   -1.4412   -1.4450   -1.4488   -1.4526   -1.4563   -1.4597   -1.4635   -1.4674   -1.4711   -1.4751   -1.4781   -1.4816   -1.4850   -1.4883   -1.4917   -1.4951   -1.4989   -1.5022   -1.5060   -1.5090   -1.5126   -1.5158   -1.5191   -1.5218   -1.5253   -1.5290   -1.5323   -1.5358   -1.5390   -1.5425   -1.5462   -1.5500   -1.5535   -1.5570   -1.5608   -1.5639   -1.5675   -1.5712   -1.5749   -1.5784   -1.5819   -1.5855   -1.5886   -1.5917   -1.5953   -1.5995   -1.6029   -1.6060   -1.6090   -1.6119   -1.6152   -1.6186   -1.6216   -1.6251   -1.6287   -1.6324   -1.6364   -1.6401   -1.6436   -1.6471   -1.6509   -1.6542   -1.6578   -1.6611   -1.6640   -1.6677   -1.6709   -1.6746   -1.6775   -1.6808   -1.6841   -1.6879   -1.6912   -1.6942   -1.6969   -1.6999   -1.7033   -1.7067   -1.7104   -1.7137   -1.7169   -1.7207   -1.7241   -1.7273   -1.7311   -1.7341   -1.7371   -1.7404   -1.7443   -1.7476   -1.7512   -1.7549   -1.7580   -1.7616   -1.7647   -1.7678   -1.7712   -1.7744   -1.7777   -1.7816   -1.7847   -1.7879   -1.7915   -1.7942   -1.7973   -1.8009   -1.8041   -1.8074   -1.8107   -1.8137   -1.8167   -1.8202   -1.8236   -1.8268   -1.8304   -1.8336   -1.8375   -1.8413   -1.8447   -1.8476   -1.8504   -1.8537   -1.8571   -1.8601   -1.8635   -1.8672   -1.8704   -1.8739   -1.8775   -1.8810   -1.8843   -1.8874   -1.8906   -1.8934   -1.8973   -1.9005   -1.9036   -1.9070   -1.9104   -1.9138   -1.9165   -1.9198   -1.9230   -1.9263   -1.9296   -1.9330   -1.9367   -1.9398   -1.9429   -1.9463   -1.9496   -1.9534   -1.9559   -1.9586   -1.9623   -1.9655   -1.9677   -1.9695
 -1.2606   -1.2651   -1.2689   -1.2731   -1.2780   -1.2821   -1.2857   -1.2899   -1.2936   -1.2969   -1.3005   -1.3040   -1.3083   -1.3121   -1.3163   -1.3199   -1.3239   -1.3275   -1.3312   -1.3351   -1.3392   -1.3427   -1.3470   -1.3510   -1.3549   -1.3591   -1.3633   -1.3669   -1.3704   -1.3742   -1.3783   -1.3822   -1.3867   -1.3907   -1.3950   -1.3983   -1.4026   -1.4063   -1.4107   -1.4145   -1.4182   -1.4223   -1.4267   -1.4309   -1.4347   -1.4383   -1.4421   -1.4461   -1.4498   -1.4534   -1.4570   -1.4612   -1.4651   -1.4690   -1.4725   -1.4768   -1.4807   -1.4849   -1.4890   -1.4934   -1.4970   -1.5011   -1.5043   -1.5077   -1.5114   -1.5148   -1.5186   -1.5224   -1.5259   -1.5300   -1.5338   -1.5379   -1.5417   -1.5454   -1.5494   -1.5528   -1.5564   -1.5601   -1.5639   -1.5676   -1.5706   -1.5747   -1.5787   -1.5827   -1.5864   -1.5910   -1.5948   -1.5984   -1.6020   -1.6054   -1.6093   -1.6130   -1.6165   -1.6203   -1.6241   -1.6278   -1.6318   -1.6357   -1.6398   -1.6436   -1.6472   -1.6513   -1.6544   -1.6585   -1.6622   -1.6657   -1.6701   -1.6736   -1.6772   -1.6810   -1.6848   -1.6885   -1.6921   -1.6960   -1.6995   -1.7028   -1.7059   -1.7095   -1.7137   -1.7171   -1.7209   -1.7248   -1.7288   -1.7321   -1.7356   -1.7392   -1.7426   -1.7463   -1.7499   -1.7534   -1.7569   -1.7611   -1.7650   -1.7687   -1.7728   -1.7767   -1.7800   -1.7834   -1.7872   -1.7911   -1.7950   -1.7988   -1.8028   -1.8068   -1.8097   -1.8136   -1.8172   -1.8206   -1.8244   -1.8275   -1.8313   -1.8349   -1.8381   -1.8420   -1.8451   -1.8488   -1.8527   -1.8562   -1.8596   -1.8634   -1.8673   -1.8703   -1.8733   -1.8765   -1.8801   -1.8840   -1.8875   -1.8909   -1.8944   -1.8979   -1.9010   -1.9053   -1.9087   -1.9121   -1.9152   -1.9182   -1.9216   -1.9257   -1.9300   -1.9338   -1.9377   -1.9410   -1.9443   -1.9477   -1.9514   -1.9551   -1.9594   -1.9621   -1.9655   -1.9685   -1.9712   -1.9744   -1.9781   -1.9822   -1.9857   -1.9888   -1.9923   -1.9962   -1.9985
 -1.2240   -1.2281   -1.2330   -1.2377   -1.2418   -1.2461   -1.2509   -1.2554   -1.2601   -1.2641   -1.2680   -1.2724   -1.2769   -1.2808   -1.2855   -1.2896   -1.2937   -1.2982   -1.3018   -1.3064   -1.3106   -1.3149   -1.3193   -1.3239   -1.3278   -1.3325   -1.3367   -1.3411   -1.3455   -1.3502   -1.3549   -1.3588   -1.3632   -1.3677   -1.3721   -1.3765   -1.3812   -1.3860   -1.3907   -1.3948   -1.3984   -1.4027   -1.4078   -1.4124   -1.4164   -1.4202   -1.4243   -1.4281   -1.4322   -1.4364   -1.4410   -1.4452   -1.4499   -1.4535   -1.4582   -1.4628   -1.4671   -1.4718   -1.4760   -1.4799   -1.4837   -1.4874   -1.4917   -1.4960   -1.5004   -1.5045   -1.5087   -1.5120   -1.5157   -1.5199   -1.5238   -1.5274   -1.5313   -1.5358   -1.5398   -1.5436   -1.5479   -1.5521   -1.5565   -1.5608   -1.5648   -1.5686   -1.5730   -1.5771   -1.5813   -1.5858   -1.5902   -1.5943   -1.5984   -1.6025   -1.6070   -1.6106   -1.6149   -1.6187   -1.6227   -1.6269   -1.6312   -1.6350   -1.6394   -1.6436   -1.6475   -1.6519   -1.6557   -1.6597   -1.6638   -1.6679   -1.6721   -1.6760   -1.6799   -1.6839   -1.6878   -1.6916   -1.6957   -1.6994   -1.7037   -1.7074   -1.7112   -1.7150   -1.7188   -1.7225   -1.7271   -1.7310   -1.7357   -1.7401   -1.7438   -1.7482   -1.7517   -1.7556   -1.7595   -1.7636   -1.7677   -1.7712   -1.7757   -1.7796   -1.7836   -1.7871   -1.7907   -1.7950   -1.7987   -1.8028   -1.8072   -1.8109   -1.8138   -1.8178   -1.8221   -1.8260   -1.8299   -1.8340   -1.8383   -1.8419   -1.8455   -1.8495   -1.8535   -1.8573   -1.8613   -1.8651   -1.8688   -1.8722   -1.8764   -1.8800   -1.8835   -1.8877   -1.8913   -1.8951   -1.8988   -1.9027   -1.9059   -1.9100   -1.9141   -1.9184   -1.9229   -1.9260   -1.9297   -1.9341   -1.9379   -1.9411   -1.9452   -1.9482   -1.9526   -1.9565   -1.9602   -1.9639   -1.9676   -1.9719   -1.9758   -1.9788   -1.9831   -1.9863   -1.9895   -1.9930   -1.9971   -2.0016   -2.0057   -2.0091   -2.0130   -2.0159   -2.0192   -2.0226   -2.0264
 -1.1931   -1.1979   -1.2025   -1.2079   -1.2128   -1.2168   -1.2215   -1.2262   -1.2304   -1.2354   -1.2399   -1.2437   -1.2483   -1.2525   -1.2569   -1.2619   -1.2663   -1.2707   -1.2752   -1.2801   -1.2854   -1.2905   -1.2953   -1.3003   -1.3041   -1.3088   -1.3130   -1.3179   -1.3223   -1.3269   -1.3318   -1.3365   -1.3411   -1.3452   -1.3499   -1.3548   -1.3595   -1.3638   -1.3684   -1.3730   -1.3773   -1.3819   -1.3865   -1.3911   -1.3962   -1.4007   -1.4045   -1.4091   -1.4137   -1.4185   -1.4226   -1.4274   -1.4318   -1.4367   -1.4416   -1.4465   -1.4509   -1.4553   -1.4605   -1.4650   -1.4693   -1.4739   -1.4788   -1.4835   -1.4879   -1.4924   -1.4966   -1.5010   -1.5058   -1.5104   -1.5146   -1.5187   -1.5230   -1.5273   -1.5316   -1.5360   -1.5401   -1.5447   -1.5492   -1.5536   -1.5579   -1.5623   -1.5668   -1.5712   -1.5762   -1.5806   -1.5852   -1.5899   -1.5947   -1.5990   -1.6040   -1.6080   -1.6123   -1.6168   -1.6211   -1.6252   -1.6298   -1.6343   -1.6391   -1.6436   -1.6480   -1.6527   -1.6568   -1.6612   -1.6655   -1.6700   -1.6742   -1.6785   -1.6828   -1.6872   -1.6920   -1.6957   -1.7001   -1.7042   -1.7085   -1.7129   -1.7181   -1.7222   -1.7263   -1.7306   -1.7343   -1.7385   -1.7426   -1.7471   -1.7513   -1.7558   -1.7595   -1.7638   -1.7683   -1.7724   -1.7767   -1.7810   -1.7848   -1.7892   -1.7935   -1.7982   -1.8021   -1.8060   -1.8099   -1.8142   -1.8183   -1.8228   -1.8271   -1.8319   -1.8357   -1.8402   -1.8445   -1.8484   -1.8521   -1.8562   -1.8603   -1.8640   -1.8682   -1.8721   -1.8764   -1.8810   -1.8854   -1.8897   -1.8931   -1.8977   -1.9022   -1.9059   -1.9104   -1.9147   -1.9190   -1.9235   -1.9275   -1.9315   -1.9354   -1.9394   -1.9431   -1.9473   -1.9510   -1.9553   -1.9598   -1.9648   -1.9692   -1.9733   -1.9771   -1.9809   -1.9846   -1.9886   -1.9926   -1.9970   -2.0003   -2.0042   -2.0079   -2.0117   -2.0150   -2.0183   -2.0219   -2.0257   -2.0301   -2.0337   -2.0372   -2.0404   -2.0442   -2.0485   -2.0520
 -1.1602   -1.1660   -1.1712   -1.1761   -1.1810   -1.1853   -1.1908   -1.1962   -1.2005   -1.2052   -1.2098   -1.2151   -1.2205   -1.2256   -1.2302   -1.2349   -1.2398   -1.2449   -1.2494   -1.2542   -1.2589   -1.2641   -1.2688   -1.2733   -1.2780   -1.2827   -1.2884   -1.2934   -1.2982   -1.3033   -1.3086   -1.3138   -1.3187   -1.3238   -1.3285   -1.3328   -1.3381   -1.3430   -1.3481   -1.3528   -1.3579   -1.3632   -1.3681   -1.3728   -1.3778   -1.3827   -1.3877   -1.3928   -1.3981   -1.4027   -1.4081   -1.4134   -1.4183   -1.4236   -1.4281   -1.4323   -1.4367   -1.4414   -1.4467   -1.4518   -1.4564   -1.4609   -1.4660   -1.4710   -1.4759   -1.4810   -1.4855   -1.4905   -1.4955   -1.5007   -1.5049   -1.5102   -1.5151   -1.5194   -1.5243   -1.5294   -1.5344   -1.5390   -1.5440   -1.5490   -1.5535   -1.5582   -1.5624   -1.5672   -1.5719   -1.5768   -1.5819   -1.5863   -1.5917   -1.5960   -1.6004   -1.6050   -1.6099   -1.6146   -1.6195   -1.6239   -1.6289   -1.6341   -1.6388   -1.6436   -1.6482   -1.6532   -1.6576   -1.6622   -1.6668   -1.6718   -1.6764   -1.6807   -1.6855   -1.6901   -1.6949   -1.6994   -1.7040   -1.7083   -1.7129   -1.7175   -1.7218   -1.7259   -1.7302   -1.7351   -1.7400   -1.7445   -1.7490   -1.7532   -1.7576   -1.7620   -1.7669   -1.7713   -1.7752   -1.7799   -1.7845   -1.7893   -1.7943   -1.7991   -1.8043   -1.8086   -1.8126   -1.8171   -1.8216   -1.8259   -1.8299   -1.8342   -1.8382   -1.8427   -1.8472   -1.8519   -1.8563   -1.8611   -1.8653   -1.8692   -1.8737   -1.8781   -1.8818   -1.8863   -1.8909   -1.8954   -1.8996   -1.9046   -1.9095   -1.9139   -1.9180   -1.9224   -1.9266   -1.9308   -1.9355   -1.9402   -1.9449   -1.9492   -1.9530   -1.9576   -1.9616   -1.9662   -1.9701   -1.9744   -1.9790   -1.9829   -1.9872   -1.9914   -1.9956   -1.9999   -2.0038   -2.0077   -2.0122   -2.0153   -2.0192   -2.0234   -2.0281   -2.0327   -2.0377   -2.0416   -2.0454   -2.0499   -2.0547   -2.0587   -2.0632   -2.0670   -2.0711   -2.0744   -2.0784
 -1.1312   -1.1363   -1.1413   -1.1458   -1.1519   -1.1574   -1.1626   -1.1672   -1.1719   -1.1771   -1.1823   -1.1873   -1.1929   -1.1987   -1.2039   -1.2094   -1.2150   -1.2211   -1.2265   -1.2315   -1.2370   -1.2419   -1.2470   -1.2518   -1.2570   -1.2618   -1.2674   -1.2727   -1.2779   -1.2828   -1.2882   -1.2936   -1.2990   -1.3045   -1.3100   -1.3147   -1.3202   -1.3256   -1.3310   -1.3362   -1.3413   -1.3464   -1.3517   -1.3568   -1.3621   -1.3675   -1.3726   -1.3782   -1.3835   -1.3891   -1.3940   -1.3994   -1.4049   -1.4102   -1.4155   -1.4206   -1.4254   -1.4303   -1.4350   -1.4402   -1.4452   -1.4504   -1.4551   -1.4600   -1.4653   -1.4707   -1.4759   -1.4813   -1.4870   -1.4924   -1.4979   -1.5032   -1.5083   -1.5138   -1.5185   -1.5237   -1.5289   -1.5341   -1.5390   -1.5439   -1.5484   -1.5533   -1.5584   -1.5637   -1.5691   -1.5738   -1.5788   -1.5839   -1.5889   -1.5938   -1.5985   -1.6034   -1.6081   -1.6129   -1.6178   -1.6228   -1.6282   -1.6336   -1.6387   -1.6436   -1.6485   -1.6535   -1.6583   -1.6634   -1.6684   -1.6733   -1.6782   -1.6831   -1.6880   -1.6928   -1.6980   -1.7028   -1.7074   -1.7127   -1.7170   -1.7218   -1.7263   -1.7315   -1.7364   -1.7413   -1.7465   -1.7511   -1.7558   -1.7602   -1.7650   -1.7695   -1.7745   -1.7792   -1.7839   -1.7888   -1.7936   -1.7987   -1.8033   -1.8078   -1.8126   -1.8178   -1.8223   -1.8268   -1.8316   -1.8363   -1.8409   -1.8456   -1.8500   -1.8549   -1.8593   -1.8637   -1.8683   -1.8727   -1.8773   -1.8818   -1.8866   -1.8907   -1.8950   -1.9002   -1.9048   -1.9090   -1.9132   -1.9178   -1.9227   -1.9274   -1.9314   -1.9358   -1.9407   -1.9450   -1.9499   -1.9547   -1.9586   -1.9634   -1.9678   -1.9723   -1.9766   -1.9811   -1.9856   -1.9902   -1.9948   -1.9998   -2.0046   -2.0092   -2.0139   -2.0176   -2.0222   -2.0272   -2.0318   -2.0357   -2.0400   -2.0445   -2.0488   -2.0536   -2.0578   -2.0623   -2.0670   -2.0715   -2.0755   -2.0794   -2.0839   -2.0886   -2.0920   -2.0964   -2.1004
 -1.1009   -1.1066   -1.1116   -1.1176   -1.1231   -1.1282   -1.1339   -1.1396   -1.1448   -1.1505   -1.1561   -1.1621   -1.1673   -1.1724   -1.1778   -1.1837   -1.1899   -1.1956   -1.2009   -1.2069   -1.2126   -1.2181   -1.2240   -1.2298   -1.2354   -1.2412   -1.2467   -1.2522   -1.2578   -1.2640   -1.2696   -1.2750   -1.2807   -1.2861   -1.2916   -1.2970   -1.3028   -1.3082   -1.3138   -1.3194   -1.3242   -1.3294   -1.3351   -1.3407   -1.3465   -1.3521   -1.3574   -1.3628   -1.3682   -1.3739   -1.3793   -1.3851   -1.3905   -1.3966   -1.4024   -1.4076   -1.4134   -1.4190   -1.4245   -1.4303   -1.4359   -1.4416   -1.4471   -1.4529   -1.4579   -1.4636   -1.4693   -1.4747   -1.4802   -1.4851   -1.4908   -1.4963   -1.5014   -1.5067   -1.5122   -1.5174   -1.5228   -1.5285   -1.5338   -1.5385   -1.5435   -1.5486   -1.5534   -1.5586   -1.5641   -1.5699   -1.5752   -1.5805   -1.5857   -1.5908   -1.5961   -1.6012   -1.6062   -1.6116   -1.6167   -1.6216   -1.6273   -1.6330   -1.6383   -1.6436   -1.6488   -1.6546   -1.6597   -1.6652   -1.6704   -1.6757   -1.6812   -1.6863   -1.6914   -1.6965   -1.7012   -1.7061   -1.7113   -1.7166   -1.7216   -1.7266   -1.7320   -1.7370   -1.7421   -1.7467   -1.7520   -1.7572   -1.7620   -1.7666   -1.7713   -1.7760   -1.7812   -1.7860   -1.7911   -1.7964   -1.8010   -1.8059   -1.8109   -1.8161   -1.8209   -1.8263   -1.8310   -1.8359   -1.8411   -1.8459   -1.8508   -1.8561   -1.8613   -1.8661   -1.8714   -1.8757   -1.8807   -1.8854   -1.8900   -1.8948   -1.8999   -1.9046   -1.9096   -1.9143   -1.9195   -1.9246   -1.9288   -1.9336   -1.9384   -1.9429   -1.9477   -1.9521   -1.9570   -1.9621   -1.9667   -1.9720   -1.9767   -1.9814   -1.9864   -1.9903   -1.9951   -1.9999   -2.0048   -2.0089   -2.0132   -2.0176   -2.0214   -2.0264   -2.0310   -2.0357   -2.0400   -2.0444   -2.0490   -2.0541   -2.0585   -2.0635   -2.0683   -2.0726   -2.0770   -2.0816   -2.0865   -2.0909   -2.0959   -2.0997   -2.1039   -2.1086   -2.1133   -2.1183   -2.1231
 -1.0704   -1.0771   -1.0836   -1.0897   -1.0948   -1.1003   -1.1063   -1.1129   -1.1180   -1.1242   -1.1301   -1.1367   -1.1422   -1.1489   -1.1547   -1.1605   -1.1666   -1.1724   -1.1786   -1.1844   -1.1902   -1.1962   -1.2027   -1.2089   -1.2150   -1.2209   -1.2268   -1.2326   -1.2388   -1.2453   -1.2512   -1.2575   -1.2635   -1.2693   -1.2749   -1.2806   -1.2864   -1.2922   -1.2982   -1.3043   -1.3099   -1.3161   -1.3218   -1.3277   -1.3337   -1.3395   -1.3454   -1.3508   -1.3564   -1.3617   -1.3676   -1.3739   -1.3798   -1.3857   -1.3915   -1.3973   -1.4030   -1.4085   -1.4146   -1.4203   -1.4260   -1.4315   -1.4366   -1.4426   -1.4483   -1.4544   -1.4600   -1.4659   -1.4715   -1.4772   -1.4822   -1.4878   -1.4936   -1.4994   -1.5049   -1.5104   -1.5165   -1.5219   -1.5274   -1.5337   -1.5395   -1.5448   -1.5501   -1.5560   -1.5617   -1.5665   -1.5719   -1.5775   -1.5829   -1.5883   -1.5937   -1.5995   -1.6046   -1.6097   -1.6152   -1.6212   -1.6268   -1.6325   -1.6381   -1.6436   -1.6492   -1.6552   -1.6603   -1.6657   -1.6716   -1.6770   -1.6825   -1.6882   -1.6935   -1.6988   -1.7049   -1.7105   -1.7156   -1.7205   -1.7258   -1.7312   -1.7365   -1.7422   -1.7466   -1.7520   -1.7573   -1.7625   -1.7680   -1.7734   -1.7784   -1.7833   -1.7886   -1.7941   -1.7994   -1.8048   -1.8096   -1.8150   -1.8203   -1.8254   -1.8306   -1.8363   -1.8411   -1.8462   -1.8511   -1.8561   -1.8611   -1.8662   -1.8708   -1.8759   -1.8809   -1.8857   -1.8908   -1.8957   -1.9008   -1.9056   -1.9112   -1.9170   -1.9217   -1.9265   -1.9319   -1.9367   -1.9415   -1.9460   -1.9511   -1.9561   -1.9612   -1.9659   -1.9703   -1.9750   -1.9795   -1.9847   -1.9901   -1.9952   -1.9998   -2.0045   -2.0094   -2.0136   -2.0182   -2.0233   -2.0283   -2.0329   -2.0373   -2.0421   -2.0469   -2.0515   -2.0562   -2.0611   -2.0657   -2.0704   -2.0753   -2.0797   -2.0851   -2.0900   -2.0946   -2.0993   -2.1045   -2.1093   -2.1135   -2.1184   -2.1229   -2.1278   -2.1319   -2.1370   -2.1415
 -1.0401   -1.0457   -1.0518   -1.0583   -1.0655   -1.0718   -1.0779   -1.0846   -1.0908   -1.0977   -1.1038   -1.1103   -1.1170   -1.1235   -1.1298   -1.1360   -1.1426   -1.1487   -1.1556   -1.1615   -1.1681   -1.1742   -1.1800   -1.1866   -1.1932   -1.1993   -1.2056   -1.2120   -1.2180   -1.2239   -1.2302   -1.2361   -1.2424   -1.2483   -1.2548   -1.2610   -1.2673   -1.2734   -1.2799   -1.2860   -1.2925   -1.2989   -1.3047   -1.3104   -1.3165   -1.3227   -1.3286   -1.3349   -1.3411   -1.3477   -1.3535   -1.3598   -1.3662   -1.3722   -1.3785   -1.3848   -1.3913   -1.3975   -1.4035   -1.4098   -1.4159   -1.4219   -1.4278   -1.4341   -1.4399   -1.4462   -1.4516   -1.4577   -1.4637   -1.4695   -1.4752   -1.4809   -1.4872   -1.4933   -1.4986   -1.5046   -1.5104   -1.5163   -1.5223   -1.5280   -1.5340   -1.5399   -1.5457   -1.5513   -1.5574   -1.5627   -1.5684   -1.5746   -1.5805   -1.5862   -1.5920   -1.5974   -1.6031   -1.6092   -1.6149   -1.6207   -1.6264   -1.6322   -1.6378   -1.6436   -1.6491   -1.6551   -1.6611   -1.6669   -1.6726   -1.6783   -1.6843   -1.6898   -1.6951   -1.7010   -1.7066   -1.7121   -1.7175   -1.7230   -1.7283   -1.7341   -1.7399   -1.7458   -1.7513   -1.7569   -1.7621   -1.7676   -1.7727   -1.7784   -1.7842   -1.7898   -1.7952   -1.8013   -1.8067   -1.8118   -1.8172   -1.8224   -1.8279   -1.8338   -1.8396   -1.8447   -1.8496   -1.8544   -1.8598   -1.8653   -1.8706   -1.8759   -1.8815   -1.8871   -1.8926   -1.8978   -1.9030   -1.9080   -1.9132   -1.9190   -1.9245   -1.9293   -1.9345   -1.9395   -1.9438   -1.9489   -1.9546   -1.9593   -1.9642   -1.9696   -1.9743   -1.9792   -1.9843   -1.9893   -1.9944   -1.9994   -2.0042   -2.0095   -2.0143   -2.0195   -2.0240   -2.0290   -2.0336   -2.0387   -2.0438   -2.0484   -2.0534   -2.0585   -2.0640   -2.0684   -2.0735   -2.0782   -2.0832   -2.0885   -2.0934   -2.0985   -2.1033   -2.1090   -2.1142   -2.1188   -2.1236   -2.1286   -2.1332   -2.1379   -2.1421   -2.1467   -2.1508   -2.1551   -2.1598
 -1.0121   -1.0197   -1.0259   -1.0322   -1.0390   -1.0456   -1.0518   -1.0577   -1.0654   -1.0722   -1.0792   -1.0857   -1.0911   -1.0987   -1.1052   -1.1125   -1.1195   -1.1257   -1.1323   -1.1384   -1.1451   -1.1523   -1.1590   -1.1658   -1.1726   -1.1790   -1.1859   -1.1929   -1.1992   -1.2056   -1.2123   -1.2188   -1.2253   -1.2320   -1.2385   -1.2449   -1.2516   -1.2584   -1.2654   -1.2716   -1.2783   -1.2845   -1.2911   -1.2980   -1.3043   -1.3107   -1.3173   -1.3240   -1.3306   -1.3368   -1.3432   -1.3502   -1.3567   -1.3636   -1.3695   -1.3758   -1.3823   -1.3887   -1.3946   -1.4006   -1.4067   -1.4124   -1.4191   -1.4257   -1.4317   -1.4383   -1.4444   -1.4505   -1.4563   -1.4625   -1.4689   -1.4752   -1.4810   -1.4871   -1.4935   -1.4992   -1.5050   -1.5107   -1.5166   -1.5227   -1.5290   -1.5350   -1.5412   -1.5471   -1.5531   -1.5592   -1.5653   -1.5713   -1.5774   -1.5836   -1.5898   -1.5957   -1.6016   -1.6073   -1.6131   -1.6196   -1.6257   -1.6319   -1.6375   -1.6436   -1.6493   -1.6555   -1.6618   -1.6682   -1.6742   -1.6796   -1.6857   -1.6914   -1.6971   -1.7029   -1.7087   -1.7139   -1.7194   -1.7251   -1.7312   -1.7372   -1.7428   -1.7487   -1.7547   -1.7600   -1.7659   -1.7717   -1.7773   -1.7832   -1.7892   -1.7946   -1.8001   -1.8058   -1.8115   -1.8173   -1.8233   -1.8292   -1.8354   -1.8411   -1.8463   -1.8518   -1.8571   -1.8629   -1.8681   -1.8735   -1.8787   -1.8839   -1.8898   -1.8959   -1.9014   -1.9064   -1.9118   -1.9170   -1.9226   -1.9281   -1.9333   -1.9394   -1.9446   -1.9500   -1.9557   -1.9611   -1.9657   -1.9710   -1.9761   -1.9808   -1.9863   -1.9919   -1.9970   -2.0021   -2.0077   -2.0131   -2.0177   -2.0229   -2.0275   -2.0326   -2.0385   -2.0439   -2.0496   -2.0547   -2.0596   -2.0648   -2.0695   -2.0745   -2.0791   -2.0841   -2.0884   -2.0942   -2.0997   -2.1053   -2.1099   -2.1156   -2.1205   -2.1253   -2.1302   -2.1361   -2.1409   -2.1460   -2.1516   -2.1563   -2.1607   -2.1665   -2.1718   -2.1753   -2.1802
 -0.9856   -0.9923   -0.9986   -1.0052   -1.0121   -1.0192   -1.0260   -1.0345   -1.0411   -1.0474   -1.0545   -1.0616   -1.0691   -1.0761   -1.0829   -1.0892   -1.0961   -1.1033   -1.1103   -1.1180   -1.1248   -1.1317   -1.1388   -1.1460   -1.1531   -1.1592   -1.1664   -1.1733   -1.1801   -1.1866   -1.1932   -1.1996   -1.2069   -1.2140   -1.2211   -1.2281   -1.2350   -1.2421   -1.2489   -1.2558   -1.2629   -1.2694   -1.2760   -1.2828   -1.2892   -1.2962   -1.3030   -1.3102   -1.3169   -1.3237   -1.3301   -1.3373   -1.3441   -1.3508   -1.3579   -1.3646   -1.3713   -1.3777   -1.3844   -1.3911   -1.3979   -1.4047   -1.4108   -1.4167   -1.4229   -1.4293   -1.4363   -1.4426   -1.4488   -1.4550   -1.4607   -1.4674   -1.4743   -1.4806   -1.4871   -1.4936   -1.4999   -1.5059   -1.5114   -1.5175   -1.5236   -1.5302   -1.5367   -1.5429   -1.5495   -1.5558   -1.5620   -1.5687   -1.5752   -1.5813   -1.5876   -1.5939   -1.6000   -1.6055   -1.6122   -1.6188   -1.6249   -1.6312   -1.6375   -1.6436   -1.6497   -1.6557   -1.6624   -1.6690   -1.6751   -1.6811   -1.6872   -1.6930   -1.6990   -1.7050   -1.7106   -1.7168   -1.7225   -1.7286   -1.7346   -1.7407   -1.7472   -1.7529   -1.7588   -1.7650   -1.7711   -1.7769   -1.7828   -1.7884   -1.7945   -1.8004   -1.8063   -1.8120   -1.8180   -1.8234   -1.8299   -1.8361   -1.8422   -1.8480   -1.8537   -1.8593   -1.8649   -1.8704   -1.8764   -1.8823   -1.8885   -1.8940   -1.8997   -1.9050   -1.9107   -1.9163   -1.9218   -1.9271   -1.9321   -1.9383   -1.9434   -1.9495   -1.9554   -1.9615   -1.9668   -1.9720   -1.9783   -1.9835   -1.9887   -1.9940   -1.9987   -2.0040   -2.0095   -2.0146   -2.0191   -2.0250   -2.0299   -2.0353   -2.0405   -2.0462   -2.0517   -2.0574   -2.0631   -2.0682   -2.0727   -2.0778   -2.0837   -2.0886   -2.0937   -2.0992   -2.1042   -2.1097   -2.1146   -2.1196   -2.1253   -2.1299   -2.1350   -2.1398   -2.1453   -2.1504   -2.1553   -2.1608   -2.1660   -2.1714   -2.1758   -2.1804   -2.1861   -2.1912   -2.1974
 -0.9592   -0.9665   -0.9738   -0.9819   -0.9886   -0.9958   -1.0040   -1.0113   -1.0183   -1.0257   -1.0334   -1.0407   -1.0475   -1.0549   -1.0621   -1.0690   -1.0761   -1.0838   -1.0908   -1.0976   -1.1045   -1.1116   -1.1186   -1.1263   -1.1332   -1.1402   -1.1473   -1.1545   -1.1618   -1.1689   -1.1765   -1.1839   -1.1905   -1.1976   -1.2045   -1.2110   -1.2179   -1.2250   -1.2326   -1.2397   -1.2469   -1.2538   -1.2607   -1.2684   -1.2756   -1.2833   -1.2900   -1.2965   -1.3034   -1.3107   -1.3178   -1.3252   -1.3323   -1.3393   -1.3458   -1.3524   -1.3593   -1.3666   -1.3735   -1.3806   -1.3874   -1.3944   -1.4012   -1.4081   -1.4144   -1.4207   -1.4276   -1.4350   -1.4414   -1.4475   -1.4547   -1.4614   -1.4676   -1.4741   -1.4807   -1.4871   -1.4940   -1.5003   -1.5067   -1.5132   -1.5195   -1.5258   -1.5326   -1.5390   -1.5455   -1.5523   -1.5592   -1.5656   -1.5722   -1.5788   -1.5856   -1.5922   -1.5982   -1.6046   -1.6115   -1.6183   -1.6245   -1.6308   -1.6372   -1.6436   -1.6500   -1.6562   -1.6630   -1.6695   -1.6759   -1.6823   -1.6882   -1.6945   -1.7006   -1.7070   -1.7133   -1.7198   -1.7259   -1.7323   -1.7383   -1.7442   -1.7508   -1.7572   -1.7629   -1.7692   -1.7756   -1.7816   -1.7876   -1.7939   -1.8004   -1.8064   -1.8129   -1.8185   -1.8246   -1.8300   -1.8363   -1.8425   -1.8489   -1.8550   -1.8613   -1.8670   -1.8730   -1.8791   -1.8846   -1.8903   -1.8964   -1.9018   -1.9070   -1.9131   -1.9189   -1.9247   -1.9302   -1.9363   -1.9422   -1.9480   -1.9541   -1.9599   -1.9658   -1.9719   -1.9778   -1.9836   -1.9889   -1.9945   -1.9997   -2.0055   -2.0110   -2.0163   -2.0220   -2.0274   -2.0332   -2.0389   -2.0438   -2.0496   -2.0550   -2.0603   -2.0654   -2.0706   -2.0763   -2.0821   -2.0871   -2.0925   -2.0975   -2.1028   -2.1079   -2.1135   -2.1185   -2.1230   -2.1285   -2.1333   -2.1381   -2.1437   -2.1496   -2.1554   -2.1608   -2.1657   -2.1708   -2.1763   -2.1802   -2.1853   -2.1907   -2.1957   -2.2010   -2.2056   -2.2100
 -0.9320   -0.9391   -0.9470   -0.9548   -0.9631   -0.9702   -0.9788   -0.9864   -0.9944   -1.0019   -1.0099   -1.0178   -1.0252   -1.0331   -1.0407   -1.0475   -1.0546   -1.0621   -1.0690   -1.0760   -1.0836   -1.0914   -1.0990   -1.1063   -1.1136   -1.1211   -1.1280   -1.1355   -1.1424   -1.1502   -1.1581   -1.1655   -1.1726   -1.1800   -1.1874   -1.1948   -1.2022   -1.2099   -1.2171   -1.2246   -1.2324   -1.2401   -1.2471   -1.2543   -1.2608   -1.2683   -1.2761   -1.2834   -1.2912   -1.2979   -1.3056   -1.3129   -1.3207   -1.3278   -1.3354   -1.3425   -1.3501   -1.3573   -1.3646   -1.3713   -1.3783   -1.3854   -1.3925   -1.3994   -1.4065   -1.4134   -1.4203   -1.4273   -1.4343   -1.4415   -1.4483   -1.4547   -1.4615   -1.4685   -1.4755   -1.4819   -1.4885   -1.4955   -1.5022   -1.5090   -1.5152   -1.5221   -1.5287   -1.5354   -1.5425   -1.5491   -1.5562   -1.5632   -1.5694   -1.5761   -1.5832   -1.5900   -1.5963   -1.6032   -1.6100   -1.6169   -1.6239   -1.6304   -1.6371   -1.6436   -1.6500   -1.6569   -1.6637   -1.6704   -1.6770   -1.6832   -1.6899   -1.6964   -1.7028   -1.7097   -1.7155   -1.7219   -1.7283   -1.7345   -1.7407   -1.7471   -1.7534   -1.7600   -1.7662   -1.7726   -1.7790   -1.7852   -1.7919   -1.7985   -1.8047   -1.8110   -1.8173   -1.8236   -1.8299   -1.8361   -1.8420   -1.8483   -1.8548   -1.8607   -1.8671   -1.8738   -1.8797   -1.8855   -1.8914   -1.8971   -1.9035   -1.9097   -1.9164   -1.9223   -1.9283   -1.9344   -1.9400   -1.9455   -1.9514   -1.9574   -1.9638   -1.9698   -1.9760   -1.9821   -1.9884   -1.9944   -1.9999   -2.0057   -2.0114   -2.0172   -2.0226   -2.0292   -2.0348   -2.0411   -2.0469   -2.0526   -2.0580   -2.0633   -2.0691   -2.0747   -2.0798   -2.0853   -2.0910   -2.0968   -2.1023   -2.1079   -2.1129   -2.1183   -2.1237   -2.1284   -2.1337   -2.1388   -2.1448   -2.1500   -2.1550   -2.1602   -2.1657   -2.1711   -2.1760   -2.1809   -2.1864   -2.1910   -2.1956   -2.2006   -2.2046   -2.2097   -2.2152   -2.2201   -2.2259
 -0.9065   -0.9141   -0.9226   -0.9297   -0.9375   -0.9456   -0.9532   -0.9617   -0.9699   -0.9783   -0.9864   -0.9939   -1.0014   -1.0093   -1.0169   -1.0249   -1.0326   -1.0401   -1.0479   -1.0562   -1.0638   -1.0717   -1.0796   -1.0871   -1.0946   -1.1021   -1.1097   -1.1174   -1.1256   -1.1337   -1.1412   -1.1490   -1.1566   -1.1649   -1.1725   -1.1805   -1.1881   -1.1960   -1.2038   -1.2117   -1.2192   -1.2269   -1.2346   -1.2422   -1.2504   -1.2576   -1.2646   -1.2716   -1.2792   -1.2872   -1.2940   -1.3013   -1.3090   -1.3160   -1.3237   -1.3310   -1.3388   -1.3467   -1.3542   -1.3622   -1.3693   -1.3764   -1.3838   -1.3912   -1.3985   -1.4059   -1.4134   -1.4204   -1.4273   -1.4347   -1.4416   -1.4485   -1.4560   -1.4631   -1.4700   -1.4769   -1.4840   -1.4910   -1.4976   -1.5044   -1.5116   -1.5185   -1.5259   -1.5326   -1.5395   -1.5464   -1.5536   -1.5602   -1.5672   -1.5742   -1.5811   -1.5878   -1.5949   -1.6020   -1.6089   -1.6157   -1.6232   -1.6300   -1.6368   -1.6436   -1.6501   -1.6573   -1.6642   -1.6711   -1.6772   -1.6842   -1.6911   -1.6976   -1.7048   -1.7111   -1.7179   -1.7242   -1.7308   -1.7376   -1.7439   -1.7507   -1.7571   -1.7639   -1.7708   -1.7770   -1.7835   -1.7898   -1.7963   -1.8031   -1.8099   -1.8164   -1.8226   -1.8292   -1.8357   -1.8416   -1.8481   -1.8546   -1.8609   -1.8674   -1.8738   -1.8803   -1.8863   -1.8932   -1.9000   -1.9061   -1.9126   -1.9187   -1.9249   -1.9315   -1.9375   -1.9432   -1.9492   -1.9550   -1.9608   -1.9673   -1.9735   -1.9800   -1.9858   -1.9916   -1.9972   -2.0032   -2.0090   -2.0154   -2.0215   -2.0273   -2.0333   -2.0393   -2.0450   -2.0507   -2.0560   -2.0618   -2.0672   -2.0729   -2.0793   -2.0852   -2.0909   -2.0970   -2.1037   -2.1097   -2.1153   -2.1211   -2.1266   -2.1316   -2.1369   -2.1426   -2.1478   -2.1538   -2.1595   -2.1647   -2.1701   -2.1755   -2.1809   -2.1861   -2.1914   -2.1966   -2.2011   -2.2063   -2.2114   -2.2173   -2.2224   -2.2276   -2.2329   -2.2375   -2.2426
 -0.8794   -0.8873   -0.8946   -0.9035   -0.9124   -0.9204   -0.9291   -0.9371   -0.9454   -0.9537   -0.9612   -0.9695   -0.9774   -0.9859   -0.9947   -1.0035   -1.0114   -1.0196   -1.0276   -1.0355   -1.0436   -1.0511   -1.0594   -1.0675   -1.0756   -1.0837   -1.0918   -1.0997   -1.1074   -1.1153   -1.1233   -1.1312   -1.1397   -1.1476   -1.1558   -1.1641   -1.1727   -1.1803   -1.1879   -1.1956   -1.2039   -1.2119   -1.2197   -1.2277   -1.2352   -1.2428   -1.2504   -1.2587   -1.2664   -1.2744   -1.2822   -1.2902   -1.2975   -1.3055   -1.3134   -1.3212   -1.3288   -1.3366   -1.3444   -1.3524   -1.3600   -1.3676   -1.3749   -1.3823   -1.3899   -1.3972   -1.4050   -1.4124   -1.4201   -1.4275   -1.4352   -1.4419   -1.4492   -1.4564   -1.4635   -1.4707   -1.4781   -1.4854   -1.4920   -1.4989   -1.5060   -1.5133   -1.5209   -1.5285   -1.5355   -1.5430   -1.5502   -1.5576   -1.5651   -1.5722   -1.5795   -1.5865   -1.5938   -1.6005   -1.6074   -1.6149   -1.6224   -1.6296   -1.6368   -1.6436   -1.6504   -1.6575   -1.6645   -1.6715   -1.6788   -1.6854   -1.6924   -1.6991   -1.7058   -1.7127   -1.7197   -1.7265   -1.7336   -1.7405   -1.7474   -1.7541   -1.7606   -1.7677   -1.7740   -1.7806   -1.7872   -1.7937   -1.8001   -1.8068   -1.8134   -1.8202   -1.8266   -1.8333   -1.8399   -1.8465   -1.8529   -1.8591   -1.8661   -1.8729   -1.8798   -1.8862   -1.8925   -1.8991   -1.9062   -1.9123   -1.9183   -1.9249   -1.9320   -1.9380   -1.9449   -1.9519   -1.9577   -1.9639   -1.9703   -1.9762   -1.9829   -1.9890   -1.9953   -2.0014   -2.0079   -2.0136   -2.0193   -2.0252   -2.0315   -2.0378   -2.0439   -2.0500   -2.0558   -2.0613   -2.0673   -2.0734   -2.0796   -2.0850   -2.0910   -2.0971   -2.1036   -2.1082   -2.1145   -2.1204   -2.1256   -2.1308   -2.1366   -2.1421   -2.1473   -2.1526   -2.1586   -2.1643   -2.1694   -2.1758   -2.1810   -2.1859   -2.1905   -2.1950   -2.2011   -2.2061   -2.2116   -2.2171   -2.2229   -2.2282   -2.2329   -2.2382   -2.2435   -2.2496   -2.2558
 -0.8525   -0.8624   -0.8711   -0.8798   -0.8888   -0.8969   -0.9044   -0.9128   -0.9211   -0.9296   -0.9383   -0.9465   -0.9553   -0.9638   -0.9725   -0.9813   -0.9900   -0.9980   -1.0063   -1.0144   -1.0228   -1.0315   -1.0400   -1.0482   -1.0564   -1.0649   -1.0732   -1.0824   -1.0907   -1.0991   -1.1072   -1.1156   -1.1234   -1.1317   -1.1404   -1.1488   -1.1570   -1.1649   -1.1730   -1.1816   -1.1900   -1.1981   -1.2066   -1.2145   -1.2226   -1.2310   -1.2389   -1.2474   -1.2555   -1.2635   -1.2718   -1.2799   -1.2885   -1.2963   -1.3042   -1.3122   -1.3202   -1.3280   -1.3359   -1.3437   -1.3517   -1.3597   -1.3676   -1.3756   -1.3832   -1.3905   -1.3982   -1.4058   -1.4129   -1.4205   -1.4281   -1.4363   -1.4435   -1.4510   -1.4585   -1.4662   -1.4737   -1.4807   -1.4878   -1.4951   -1.5030   -1.5102   -1.5179   -1.5255   -1.5332   -1.5410   -1.5481   -1.5553   -1.5622   -1.5694   -1.5767   -1.5843   -1.5919   -1.5989   -1.6058   -1.6135   -1.6214   -1.6292   -1.6364   -1.6436   -1.6507   -1.6580   -1.6652   -1.6724   -1.6799   -1.6869   -1.6938   -1.7010   -1.7084   -1.7153   -1.7228   -1.7292   -1.7365   -1.7436   -1.7507   -1.7574   -1.7640   -1.7709   -1.7783   -1.7851   -1.7915   -1.7983   -1.8050   -1.8115   -1.8188   -1.8255   -1.8325   -1.8396   -1.8466   -1.8533   -1.8601   -1.8668   -1.8739   -1.8808   -1.8872   -1.8941   -1.9008   -1.9075   -1.9140   -1.9203   -1.9271   -1.9333   -1.9396   -1.9463   -1.9530   -1.9596   -1.9664   -1.9723   -1.9788   -1.9857   -1.9921   -1.9981   -2.0052   -2.0114   -2.0177   -2.0238   -2.0293   -2.0355   -2.0414   -2.0479   -2.0542   -2.0602   -2.0661   -2.0723   -2.0782   -2.0842   -2.0896   -2.0958   -2.1021   -2.1083   -2.1144   -2.1201   -2.1262   -2.1322   -2.1375   -2.1433   -2.1490   -2.1545   -2.1600   -2.1657   -2.1713   -2.1774   -2.1834   -2.1892   -2.1949   -2.2007   -2.2062   -2.2112   -2.2158   -2.2212   -2.2263   -2.2316   -2.2376   -2.2439   -2.2492   -2.2543   -2.2602   -2.2661   -2.2713
 -0.8259   -0.8359   -0.8452   -0.8534   -0.8622   -0.8704   -0.8789   -0.8882   -0.8972   -0.9068   -0.9154   -0.9251   -0.9338   -0.9425   -0.9510   -0.9603   -0.9692   -0.9779   -0.9859   -0.9950   -1.0036   -1.0125   -1.0206   -1.0289   -1.0375   -1.0461   -1.0545   -1.0637   -1.0723   -1.0803   -1.0891   -1.0976   -1.1063   -1.1151   -1.1239   -1.1324   -1.1411   -1.1502   -1.1588   -1.1673   -1.1757   -1.1842   -1.1927   -1.2012   -1.2095   -1.2173   -1.2257   -1.2339   -1.2426   -1.2510   -1.2590   -1.2674   -1.2759   -1.2843   -1.2924   -1.3006   -1.3087   -1.3169   -1.3249   -1.3334   -1.3418   -1.3498   -1.3579   -1.3662   -1.3747   -1.3825   -1.3905   -1.3980   -1.4057   -1.4139   -1.4219   -1.4300   -1.4381   -1.4460   -1.4536   -1.4611   -1.4691   -1.4761   -1.4838   -1.4913   -1.4988   -1.5066   -1.5143   -1.5223   -1.5302   -1.5381   -1.5459   -1.5531   -1.5608   -1.5684   -1.5752   -1.5833   -1.5907   -1.5980   -1.6051   -1.6128   -1.6211   -1.6287   -1.6362   -1.6436   -1.6510   -1.6586   -1.6661   -1.6734   -1.6806   -1.6884   -1.6952   -1.7023   -1.7097   -1.7171   -1.7246   -1.7324   -1.7388   -1.7456   -1.7532   -1.7598   -1.7670   -1.7737   -1.7805   -1.7876   -1.7949   -1.8022   -1.8090   -1.8160   -1.8230   -1.8301   -1.8372   -1.8443   -1.8515   -1.8581   -1.8650   -1.8721   -1.8797   -1.8863   -1.8930   -1.8997   -1.9064   -1.9133   -1.9207   -1.9275   -1.9336   -1.9402   -1.9470   -1.9535   -1.9598   -1.9668   -1.9729   -1.9798   -1.9861   -1.9927   -1.9987   -2.0055   -2.0120   -2.0182   -2.0248   -2.0310   -2.0374   -2.0445   -2.0512   -2.0573   -2.0638   -2.0702   -2.0770   -2.0829   -2.0890   -2.0947   -2.1008   -2.1072   -2.1137   -2.1194   -2.1255   -2.1313   -2.1370   -2.1429   -2.1481   -2.1548   -2.1607   -2.1663   -2.1723   -2.1781   -2.1831   -2.1886   -2.1946   -2.2005   -2.2063   -2.2121   -2.2180   -2.2232   -2.2281   -2.2342   -2.2393   -2.2450   -2.2503   -2.2557   -2.2617   -2.2671   -2.2725   -2.2776   -2.2829
 -0.8013   -0.8109   -0.8207   -0.8304   -0.8387   -0.8479   -0.8572   -0.8662   -0.8761   -0.8840   -0.8936   -0.9034   -0.9135   -0.9223   -0.9318   -0.9403   -0.9497   -0.9583   -0.9676   -0.9767   -0.9859   -0.9951   -1.0042   -1.0136   -1.0224   -1.0319   -1.0406   -1.0495   -1.0581   -1.0666   -1.0752   -1.0842   -1.0937   -1.1021   -1.1109   -1.1195   -1.1277   -1.1366   -1.1452   -1.1544   -1.1629   -1.1716   -1.1806   -1.1891   -1.1969   -1.2055   -1.2142   -1.2225   -1.2313   -1.2400   -1.2490   -1.2577   -1.2659   -1.2746   -1.2831   -1.2916   -1.3000   -1.3087   -1.3171   -1.3260   -1.3341   -1.3425   -1.3512   -1.3591   -1.3678   -1.3756   -1.3841   -1.3923   -1.4003   -1.4083   -1.4161   -1.4238   -1.4316   -1.4400   -1.4473   -1.4550   -1.4629   -1.4707   -1.4783   -1.4868   -1.4948   -1.5025   -1.5109   -1.5189   -1.5264   -1.5348   -1.5424   -1.5503   -1.5583   -1.5660   -1.5737   -1.5816   -1.5895   -1.5970   -1.6047   -1.6127   -1.6207   -1.6284   -1.6360   -1.6436   -1.6512   -1.6585   -1.6662   -1.6738   -1.6813   -1.6891   -1.6962   -1.7036   -1.7113   -1.7190   -1.7264   -1.7341   -1.7413   -1.7482   -1.7554   -1.7621   -1.7690   -1.7762   -1.7833   -1.7905   -1.7976   -1.8045   -1.8121   -1.8193   -1.8266   -1.8335   -1.8407   -1.8481   -1.8554   -1.8620   -1.8692   -1.8761   -1.8832   -1.8905   -1.8980   -1.9048   -1.9119   -1.9185   -1.9256   -1.9330   -1.9394   -1.9464   -1.9530   -1.9599   -1.9670   -1.9736   -1.9802   -1.9871   -1.9936   -1.9999   -2.0068   -2.0131   -2.0191   -2.0258   -2.0319   -2.0383   -2.0448   -2.0516   -2.0579   -2.0644   -2.0706   -2.0767   -2.0828   -2.0889   -2.0956   -2.1016   -2.1083   -2.1145   -2.1210   -2.1270   -2.1327   -2.1394   -2.1456   -2.1509   -2.1576   -2.1636   -2.1694   -2.1755   -2.1818   -2.1880   -2.1941   -2.1999   -2.2056   -2.2116   -2.2170   -2.2230   -2.2283   -2.2341   -2.2393   -2.2449   -2.2497   -2.2553   -2.2609   -2.2658   -2.2716   -2.2772   -2.2835   -2.2877   -2.2925
 -0.7764   -0.7854   -0.7955   -0.8052   -0.8146   -0.8236   -0.8335   -0.8430   -0.8533   -0.8635   -0.8729   -0.8821   -0.8917   -0.9009   -0.9104   -0.9198   -0.9294   -0.9386   -0.9486   -0.9584   -0.9679   -0.9772   -0.9872   -0.9962   -1.0053   -1.0145   -1.0234   -1.0324   -1.0416   -1.0506   -1.0601   -1.0693   -1.0788   -1.0880   -1.0972   -1.1061   -1.1153   -1.1243   -1.1333   -1.1421   -1.1512   -1.1598   -1.1685   -1.1770   -1.1860   -1.1948   -1.2037   -1.2123   -1.2218   -1.2303   -1.2390   -1.2475   -1.2562   -1.2646   -1.2734   -1.2818   -1.2902   -1.2987   -1.3072   -1.3152   -1.3239   -1.3329   -1.3420   -1.3503   -1.3591   -1.3681   -1.3768   -1.3853   -1.3935   -1.4015   -1.4098   -1.4179   -1.4259   -1.4346   -1.4426   -1.4501   -1.4582   -1.4660   -1.4746   -1.4825   -1.4905   -1.4988   -1.5072   -1.5155   -1.5240   -1.5324   -1.5403   -1.5484   -1.5563   -1.5648   -1.5726   -1.5806   -1.5883   -1.5962   -1.6041   -1.6122   -1.6206   -1.6283   -1.6359   -1.6436   -1.6512   -1.6588   -1.6665   -1.6746   -1.6822   -1.6897   -1.6973   -1.7052   -1.7127   -1.7203   -1.7279   -1.7361   -1.7437   -1.7513   -1.7584   -1.7659   -1.7732   -1.7808   -1.7883   -1.7952   -1.8024   -1.8097   -1.8173   -1.8245   -1.8321   -1.8389   -1.8462   -1.8535   -1.8606   -1.8679   -1.8753   -1.8821   -1.8892   -1.8964   -1.9036   -1.9110   -1.9183   -1.9256   -1.9325   -1.9403   -1.9475   -1.9544   -1.9610   -1.9680   -1.9746   -1.9810   -1.9874   -1.9942   -2.0006   -2.0072   -2.0134   -2.0199   -2.0263   -2.0328   -2.0393   -2.0458   -2.0522   -2.0589   -2.0653   -2.0719   -2.0779   -2.0842   -2.0910   -2.0976   -2.1040   -2.1107   -2.1169   -2.1225   -2.1285   -2.1347   -2.1411   -2.1476   -2.1541   -2.1601   -2.1668   -2.1730   -2.1795   -2.1858   -2.1920   -2.1975   -2.2036   -2.2103   -2.2170   -2.2225   -2.2283   -2.2345   -2.2402   -2.2462   -2.2516   -2.2575   -2.2632   -2.2688   -2.2741   -2.2795   -2.2853   -2.2914   -2.2971   -2.3031   -2.3083
 -0.7520   -0.7623   -0.7721   -0.7821   -0.7911   -0.8014   -0.8122   -0.8218   -0.8322   -0.8418   -0.8516   -0.8617   -0.8721   -0.8819   -0.8916   -0.9018   -0.9106   -0.9201   -0.9302   -0.9397   -0.9492   -0.9587   -0.9683   -0.9776   -0.9874   -0.9973   -1.0070   -1.0163   -1.0259   -1.0354   -1.0449   -1.0543   -1.0635   -1.0731   -1.0826   -1.0922   -1.1014   -1.1106   -1.1193   -1.1282   -1.1380   -1.1471   -1.1559   -1.1650   -1.1743   -1.1839   -1.1932   -1.2017   -1.2105   -1.2191   -1.2282   -1.2377   -1.2465   -1.2554   -1.2642   -1.2725   -1.2810   -1.2900   -1.2987   -1.3080   -1.3165   -1.3253   -1.3342   -1.3433   -1.3521   -1.3612   -1.3693   -1.3777   -1.3863   -1.3951   -1.4038   -1.4121   -1.4205   -1.4288   -1.4373   -1.4459   -1.4534   -1.4618   -1.4705   -1.4792   -1.4876   -1.4960   -1.5044   -1.5133   -1.5214   -1.5296   -1.5380   -1.5461   -1.5542   -1.5626   -1.5711   -1.5791   -1.5867   -1.5948   -1.6030   -1.6118   -1.6201   -1.6279   -1.6356   -1.6436   -1.6516   -1.6590   -1.6674   -1.6755   -1.6831   -1.6911   -1.6987   -1.7065   -1.7148   -1.7225   -1.7297   -1.7377   -1.7453   -1.7529   -1.7608   -1.7682   -1.7757   -1.7833   -1.7908   -1.7982   -1.8053   -1.8129   -1.8205   -1.8280   -1.8352   -1.8426   -1.8497   -1.8575   -1.8653   -1.8731   -1.8803   -1.8879   -1.8955   -1.9025   -1.9095   -1.9167   -1.9240   -1.9309   -1.9381   -1.9452   -1.9522   -1.9593   -1.9667   -1.9738   -1.9806   -1.9874   -1.9941   -2.0007   -2.0075   -2.0153   -2.0222   -2.0287   -2.0352   -2.0421   -2.0491   -2.0560   -2.0625   -2.0696   -2.0762   -2.0831   -2.0889   -2.0953   -2.1017   -2.1076   -2.1140   -2.1205   -2.1267   -2.1332   -2.1392   -2.1461   -2.1528   -2.1592   -2.1653   -2.1717   -2.1773   -2.1831   -2.1893   -2.1953   -2.2013   -2.2072   -2.2136   -2.2203   -2.2268   -2.2322   -2.2383   -2.2443   -2.2499   -2.2554   -2.2614   -2.2674   -2.2729   -2.2785   -2.2839   -2.2897   -2.2960   -2.3013   -2.3074   -2.3128   -2.3182
 -0.7284   -0.7391   -0.7501   -0.7610   -0.7707   -0.7808   -0.7912   -0.8012   -0.8119   -0.8224   -0.8327   -0.8432   -0.8530   -0.8634   -0.8732   -0.8834   -0.8936   -0.9038   -0.9140   -0.9233   -0.9325   -0.9426   -0.9526   -0.9620   -0.9716   -0.9813   -0.9913   -1.0011   -1.0106   -1.0201   -1.0296   -1.0396   -1.0495   -1.0593   -1.0688   -1.0786   -1.0881   -1.0977   -1.1072   -1.1165   -1.1259   -1.1361   -1.1455   -1.1548   -1.1646   -1.1735   -1.1827   -1.1923   -1.2012   -1.2102   -1.2195   -1.2285   -1.2376   -1.2468   -1.2557   -1.2649   -1.2737   -1.2829   -1.2921   -1.3010   -1.3097   -1.3186   -1.3271   -1.3364   -1.3456   -1.3540   -1.3631   -1.3714   -1.3803   -1.3887   -1.3973   -1.4060   -1.4144   -1.4236   -1.4324   -1.4408   -1.4495   -1.4582   -1.4664   -1.4756   -1.4846   -1.4933   -1.5019   -1.5107   -1.5191   -1.5272   -1.5359   -1.5443   -1.5528   -1.5612   -1.5693   -1.5772   -1.5858   -1.5940   -1.6026   -1.6111   -1.6193   -1.6275   -1.6354   -1.6436   -1.6514   -1.6596   -1.6674   -1.6756   -1.6839   -1.6916   -1.6997   -1.7074   -1.7152   -1.7228   -1.7306   -1.7385   -1.7464   -1.7545   -1.7617   -1.7696   -1.7778   -1.7857   -1.7933   -1.8010   -1.8093   -1.8173   -1.8251   -1.8325   -1.8401   -1.8473   -1.8549   -1.8627   -1.8704   -1.8777   -1.8856   -1.8926   -1.8996   -1.9065   -1.9144   -1.9221   -1.9295   -1.9363   -1.9431   -1.9504   -1.9579   -1.9651   -1.9719   -1.9783   -1.9853   -1.9925   -1.9998   -2.0066   -2.0134   -2.0208   -2.0279   -2.0349   -2.0418   -2.0490   -2.0551   -2.0619   -2.0684   -2.0754   -2.0818   -2.0884   -2.0952   -2.1019   -2.1085   -2.1151   -2.1217   -2.1283   -2.1348   -2.1413   -2.1478   -2.1545   -2.1607   -2.1674   -2.1740   -2.1806   -2.1870   -2.1930   -2.1994   -2.2058   -2.2121   -2.2188   -2.2248   -2.2304   -2.2363   -2.2432   -2.2494   -2.2551   -2.2613   -2.2670   -2.2725   -2.2780   -2.2839   -2.2901   -2.2955   -2.3011   -2.3066   -2.3112   -2.3167   -2.3223   -2.3276
 -0.7060   -0.7159   -0.7272   -0.7379   -0.7493   -0.7601   -0.7703   -0.7808   -0.7911   -0.8023   -0.8130   -0.8229   -0.8335   -0.8446   -0.8549   -0.8644   -0.8742   -0.8847   -0.8958   -0.9060   -0.9157   -0.9253   -0.9347   -0.9453   -0.9554   -0.9657   -0.9759   -0.9862   -0.9962   -1.0069   -1.0166   -1.0261   -1.0361   -1.0455   -1.0556   -1.0651   -1.0747   -1.0846   -1.0946   -1.1045   -1.1139   -1.1235   -1.1335   -1.1429   -1.1523   -1.1615   -1.1711   -1.1809   -1.1908   -1.2009   -1.2102   -1.2197   -1.2290   -1.2386   -1.2475   -1.2566   -1.2660   -1.2750   -1.2836   -1.2929   -1.3022   -1.3110   -1.3202   -1.3288   -1.3382   -1.3473   -1.3562   -1.3649   -1.3739   -1.3827   -1.3917   -1.4006   -1.4098   -1.4192   -1.4279   -1.4367   -1.4456   -1.4544   -1.4634   -1.4722   -1.4813   -1.4898   -1.4985   -1.5072   -1.5166   -1.5252   -1.5343   -1.5429   -1.5512   -1.5599   -1.5682   -1.5765   -1.5850   -1.5936   -1.6017   -1.6106   -1.6190   -1.6271   -1.6352   -1.6436   -1.6515   -1.6600   -1.6681   -1.6761   -1.6843   -1.6924   -1.7003   -1.7083   -1.7163   -1.7245   -1.7327   -1.7409   -1.7493   -1.7574   -1.7657   -1.7739   -1.7817   -1.7902   -1.7980   -1.8054   -1.8132   -1.8206   -1.8284   -1.8364   -1.8441   -1.8517   -1.8597   -1.8672   -1.8751   -1.8827   -1.8896   -1.8973   -1.9047   -1.9122   -1.9196   -1.9273   -1.9344   -1.9421   -1.9499   -1.9574   -1.9645   -1.9717   -1.9788   -1.9861   -1.9933   -2.0005   -2.0080   -2.0150   -2.0220   -2.0293   -2.0363   -2.0437   -2.0505   -2.0572   -2.0638   -2.0709   -2.0780   -2.0851   -2.0922   -2.0987   -2.1056   -2.1125   -2.1191   -2.1258   -2.1326   -2.1394   -2.1456   -2.1520   -2.1588   -2.1657   -2.1721   -2.1787   -2.1851   -2.1910   -2.1970   -2.2040   -2.2102   -2.2162   -2.2224   -2.2284   -2.2342   -2.2408   -2.2472   -2.2536   -2.2600   -2.2657   -2.2717   -2.2777   -2.2830   -2.2887   -2.2948   -2.3004   -2.3071   -2.3124   -2.3179   -2.3237   -2.3298   -2.3358   -2.3414
 -0.6836   -0.6939   -0.7057   -0.7164   -0.7271   -0.7385   -0.7489   -0.7601   -0.7716   -0.7825   -0.7929   -0.8035   -0.8138   -0.8253   -0.8352   -0.8453   -0.8556   -0.8660   -0.8767   -0.8874   -0.8980   -0.9082   -0.9185   -0.9288   -0.9389   -0.9492   -0.9600   -0.9703   -0.9806   -0.9907   -1.0013   -1.0115   -1.0220   -1.0322   -1.0420   -1.0517   -1.0612   -1.0709   -1.0806   -1.0904   -1.1005   -1.1106   -1.1208   -1.1307   -1.1406   -1.1504   -1.1611   -1.1707   -1.1803   -1.1899   -1.2002   -1.2095   -1.2195   -1.2287   -1.2379   -1.2475   -1.2564   -1.2657   -1.2751   -1.2847   -1.2940   -1.3036   -1.3132   -1.3225   -1.3319   -1.3413   -1.3507   -1.3599   -1.3691   -1.3778   -1.3864   -1.3959   -1.4049   -1.4145   -1.4235   -1.4320   -1.4410   -1.4500   -1.4589   -1.4680   -1.4775   -1.4863   -1.4954   -1.5044   -1.5137   -1.5228   -1.5317   -1.5403   -1.5493   -1.5583   -1.5670   -1.5758   -1.5842   -1.5929   -1.6010   -1.6098   -1.6188   -1.6268   -1.6351   -1.6436   -1.6517   -1.6601   -1.6687   -1.6772   -1.6857   -1.6934   -1.7016   -1.7096   -1.7178   -1.7260   -1.7345   -1.7425   -1.7508   -1.7592   -1.7677   -1.7757   -1.7837   -1.7917   -1.8002   -1.8077   -1.8160   -1.8239   -1.8319   -1.8400   -1.8478   -1.8556   -1.8637   -1.8713   -1.8791   -1.8869   -1.8942   -1.9021   -1.9094   -1.9170   -1.9246   -1.9321   -1.9394   -1.9469   -1.9547   -1.9621   -1.9697   -1.9770   -1.9845   -1.9915   -1.9989   -2.0065   -2.0137   -2.0216   -2.0289   -2.0359   -2.0432   -2.0502   -2.0572   -2.0644   -2.0714   -2.0786   -2.0861   -2.0928   -2.1000   -2.1074   -2.1146   -2.1216   -2.1279   -2.1342   -2.1407   -2.1474   -2.1547   -2.1615   -2.1684   -2.1752   -2.1814   -2.1880   -2.1946   -2.2009   -2.2070   -2.2131   -2.2192   -2.2257   -2.2327   -2.2392   -2.2452   -2.2522   -2.2586   -2.2644   -2.2700   -2.2762   -2.2820   -2.2882   -2.2942   -2.2999   -2.3054   -2.3118   -2.3178   -2.3246   -2.3305   -2.3361   -2.3414   -2.3466   -2.3518
 -0.6625   -0.6735   -0.6851   -0.6961   -0.7073   -0.7183   -0.7292   -0.7403   -0.7518   -0.7632   -0.7740   -0.7851   -0.7956   -0.8066   -0.8174   -0.8278   -0.8388   -0.8498   -0.8606   -0.8706   -0.8810   -0.8918   -0.9023   -0.9129   -0.9234   -0.9338   -0.9442   -0.9555   -0.9659   -0.9766   -0.9867   -0.9978   -1.0083   -1.0186   -1.0291   -1.0394   -1.0497   -1.0595   -1.0699   -1.0801   -1.0901   -1.1000   -1.1097   -1.1200   -1.1300   -1.1398   -1.1496   -1.1595   -1.1691   -1.1791   -1.1891   -1.1988   -1.2087   -1.2187   -1.2287   -1.2385   -1.2477   -1.2575   -1.2677   -1.2775   -1.2871   -1.2970   -1.3068   -1.3159   -1.3253   -1.3346   -1.3441   -1.3536   -1.3632   -1.3725   -1.3816   -1.3910   -1.4003   -1.4096   -1.4194   -1.4287   -1.4382   -1.4474   -1.4569   -1.4658   -1.4751   -1.4846   -1.4940   -1.5031   -1.5120   -1.5209   -1.5297   -1.5387   -1.5478   -1.5569   -1.5659   -1.5740   -1.5830   -1.5915   -1.6001   -1.6090   -1.6177   -1.6260   -1.6348   -1.6436   -1.6519   -1.6604   -1.6693   -1.6777   -1.6866   -1.6949   -1.7030   -1.7108   -1.7190   -1.7274   -1.7360   -1.7445   -1.7529   -1.7612   -1.7694   -1.7772   -1.7854   -1.7937   -1.8014   -1.8099   -1.8183   -1.8268   -1.8344   -1.8423   -1.8502   -1.8586   -1.8664   -1.8745   -1.8822   -1.8901   -1.8983   -1.9056   -1.9133   -1.9210   -1.9284   -1.9363   -1.9436   -1.9515   -1.9592   -1.9676   -1.9749   -1.9827   -1.9900   -1.9971   -2.0043   -2.0116   -2.0187   -2.0257   -2.0329   -2.0399   -2.0476   -2.0551   -2.0621   -2.0694   -2.0761   -2.0832   -2.0906   -2.0976   -2.1050   -2.1126   -2.1195   -2.1261   -2.1328   -2.1399   -2.1471   -2.1545   -2.1612   -2.1676   -2.1746   -2.1814   -2.1879   -2.1944   -2.2011   -2.2075   -2.2143   -2.2209   -2.2276   -2.2337   -2.2398   -2.2462   -2.2532   -2.2592   -2.2650   -2.2714   -2.2782   -2.2842   -2.2898   -2.2954   -2.3016   -2.3078   -2.3144   -2.3207   -2.3271   -2.3329   -2.3383   -2.3444   -2.3509   -2.3565   -2.3622
 -0.6457   -0.6563   -0.6674   -0.6782   -0.6892   -0.7006   -0.7114   -0.7233   -0.7346   -0.7454   -0.7564   -0.7685   -0.7798   -0.7909   -0.8014   -0.8124   -0.8237   -0.8340   -0.8452   -0.8560   -0.8667   -0.8777   -0.8884   -0.8991   -0.9101   -0.9206   -0.9315   -0.9416   -0.9529   -0.9629   -0.9735   -0.9840   -0.9946   -1.0050   -1.0159   -1.0265   -1.0371   -1.0482   -1.0585   -1.0685   -1.0791   -1.0890   -1.0996   -1.1095   -1.1195   -1.1294   -1.1395   -1.1495   -1.1596   -1.1697   -1.1798   -1.1899   -1.2000   -1.2099   -1.2202   -1.2296   -1.2397   -1.2495   -1.2599   -1.2702   -1.2799   -1.2894   -1.2994   -1.3092   -1.3189   -1.3284   -1.3377   -1.3474   -1.3570   -1.3662   -1.3760   -1.3858   -1.3949   -1.4043   -1.4140   -1.4235   -1.4330   -1.4424   -1.4521   -1.4619   -1.4715   -1.4807   -1.4901   -1.4995   -1.5084   -1.5178   -1.5269   -1.5362   -1.5453   -1.5543   -1.5634   -1.5719   -1.5809   -1.5898   -1.5990   -1.6078   -1.6169   -1.6255   -1.6345   -1.6436   -1.6524   -1.6609   -1.6702   -1.6793   -1.6871   -1.6952   -1.7043   -1.7130   -1.7219   -1.7305   -1.7386   -1.7470   -1.7552   -1.7638   -1.7725   -1.7806   -1.7887   -1.7968   -1.8050   -1.8137   -1.8217   -1.8302   -1.8385   -1.8466   -1.8552   -1.8632   -1.8712   -1.8792   -1.8871   -1.8948   -1.9026   -1.9110   -1.9187   -1.9263   -1.9341   -1.9420   -1.9492   -1.9574   -1.9649   -1.9722   -1.9801   -1.9878   -1.9951   -2.0022   -2.0101   -2.0181   -2.0254   -2.0327   -2.0400   -2.0474   -2.0551   -2.0624   -2.0695   -2.0765   -2.0841   -2.0916   -2.0984   -2.1055   -2.1128   -2.1192   -2.1262   -2.1334   -2.1402   -2.1472   -2.1541   -2.1610   -2.1679   -2.1749   -2.1819   -2.1893   -2.1958   -2.2021   -2.2087   -2.2155   -2.2225   -2.2290   -2.2354   -2.2416   -2.2483   -2.2540   -2.2594   -2.2659   -2.2724   -2.2785   -2.2853   -2.2923   -2.2989   -2.3052   -2.3109   -2.3169   -2.3229   -2.3295   -2.3360   -2.3423   -2.3482   -2.3547   -2.3607   -2.3656   -2.3711
 -0.6260   -0.6368   -0.6479   -0.6602   -0.6717   -0.6841   -0.6957   -0.7070   -0.7179   -0.7294   -0.7406   -0.7514   -0.7630   -0.7737   -0.7846   -0.7958   -0.8067   -0.8178   -0.8291   -0.8404   -0.8517   -0.8623   -0.8735   -0.8844   -0.8952   -0.9067   -0.9180   -0.9292   -0.9396   -0.9507   -0.9618   -0.9729   -0.9834   -0.9939   -1.0045   -1.0156   -1.0258   -1.0366   -1.0478   -1.0580   -1.0686   -1.0788   -1.0896   -1.0995   -1.1096   -1.1201   -1.1304   -1.1406   -1.1510   -1.1613   -1.1718   -1.1821   -1.1924   -1.2024   -1.2128   -1.2224   -1.2323   -1.2427   -1.2530   -1.2636   -1.2734   -1.2835   -1.2936   -1.3030   -1.3126   -1.3219   -1.3315   -1.3412   -1.3510   -1.3607   -1.3706   -1.3804   -1.3900   -1.3997   -1.4091   -1.4188   -1.4284   -1.4383   -1.4483   -1.4581   -1.4683   -1.4779   -1.4871   -1.4967   -1.5060   -1.5157   -1.5249   -1.5339   -1.5435   -1.5532   -1.5622   -1.5711   -1.5799   -1.5891   -1.5981   -1.6072   -1.6159   -1.6254   -1.6345   -1.6436   -1.6526   -1.6611   -1.6702   -1.6793   -1.6876   -1.6965   -1.7052   -1.7141   -1.7232   -1.7316   -1.7402   -1.7490   -1.7576   -1.7660   -1.7744   -1.7831   -1.7913   -1.7999   -1.8083   -1.8170   -1.8253   -1.8335   -1.8418   -1.8501   -1.8582   -1.8663   -1.8742   -1.8822   -1.8905   -1.8983   -1.9067   -1.9147   -1.9224   -1.9305   -1.9381   -1.9457   -1.9543   -1.9623   -1.9701   -1.9782   -1.9862   -1.9942   -2.0021   -2.0098   -2.0176   -2.0249   -2.0327   -2.0396   -2.0468   -2.0547   -2.0617   -2.0693   -2.0768   -2.0842   -2.0915   -2.0985   -2.1056   -2.1133   -2.1202   -2.1279   -2.1352   -2.1421   -2.1495   -2.1564   -2.1632   -2.1693   -2.1763   -2.1832   -2.1904   -2.1974   -2.2042   -2.2102   -2.2166   -2.2232   -2.2303   -2.2362   -2.2431   -2.2493   -2.2560   -2.2621   -2.2688   -2.2744   -2.2802   -2.2863   -2.2929   -2.2990   -2.3052   -2.3114   -2.3180   -2.3242   -2.3306   -2.3365   -2.3423   -2.3494   -2.3554   -2.3612   -2.3674   -2.3735   -2.3809
 -0.6092   -0.6212   -0.6332   -0.6440   -0.6559   -0.6672   -0.6787   -0.6906   -0.7014   -0.7121   -0.7238   -0.7351   -0.7463   -0.7578   -0.7690   -0.7796   -0.7912   -0.8027   -0.8141   -0.8251   -0.8367   -0.8481   -0.8592   -0.8702   -0.8817   -0.8932   -0.9046   -0.9153   -0.9265   -0.9378   -0.9488   -0.9596   -0.9712   -0.9820   -0.9930   -1.0036   -1.0144   -1.0250   -1.0359   -1.0466   -1.0573   -1.0683   -1.0790   -1.0898   -1.0999   -1.1108   -1.1215   -1.1319   -1.1426   -1.1528   -1.1633   -1.1738   -1.1845   -1.1943   -1.2047   -1.2150   -1.2254   -1.2357   -1.2461   -1.2565   -1.2669   -1.2770   -1.2875   -1.2976   -1.3082   -1.3180   -1.3278   -1.3378   -1.3477   -1.3579   -1.3672   -1.3768   -1.3864   -1.3960   -1.4059   -1.4158   -1.4257   -1.4359   -1.4459   -1.4554   -1.4645   -1.4741   -1.4835   -1.4936   -1.5032   -1.5127   -1.5227   -1.5321   -1.5416   -1.5513   -1.5602   -1.5695   -1.5785   -1.5880   -1.5972   -1.6063   -1.6160   -1.6250   -1.6343   -1.6436   -1.6526   -1.6615   -1.6710   -1.6798   -1.6885   -1.6974   -1.7061   -1.7151   -1.7240   -1.7328   -1.7414   -1.7497   -1.7583   -1.7672   -1.7761   -1.7848   -1.7937   -1.8024   -1.8107   -1.8191   -1.8274   -1.8361   -1.8440   -1.8525   -1.8604   -1.8686   -1.8769   -1.8851   -1.8939   -1.9021   -1.9104   -1.9185   -1.9266   -1.9345   -1.9423   -1.9504   -1.9586   -1.9665   -1.9745   -1.9827   -1.9904   -1.9985   -2.0071   -2.0144   -2.0223   -2.0300   -2.0379   -2.0451   -2.0532   -2.0601   -2.0675   -2.0749   -2.0826   -2.0900   -2.0970   -2.1044   -2.1114   -2.1190   -2.1262   -2.1338   -2.1412   -2.1486   -2.1556   -2.1628   -2.1698   -2.1772   -2.1841   -2.1914   -2.1982   -2.2048   -2.2116   -2.2178   -2.2241   -2.2311   -2.2375   -2.2436   -2.2503   -2.2570   -2.2628   -2.2684   -2.2752   -2.2813   -2.2874   -2.2940   -2.3010   -2.3070   -2.3126   -2.3191   -2.3254   -2.3308   -2.3366   -2.3430   -2.3499   -2.3560   -2.3612   -2.3674   -2.3740   -2.3802   -2.3863
 -0.5947   -0.6047   -0.6164   -0.6277   -0.6396   -0.6519   -0.6631   -0.6749   -0.6863   -0.6976   -0.7093   -0.7215   -0.7325   -0.7433   -0.7541   -0.7653   -0.7776   -0.7895   -0.8008   -0.8126   -0.8241   -0.8355   -0.8473   -0.8582   -0.8695   -0.8809   -0.8925   -0.9036   -0.9152   -0.9268   -0.9376   -0.9486   -0.9594   -0.9704   -0.9813   -0.9925   -1.0038   -1.0154   -1.0270   -1.0377   -1.0483   -1.0588   -1.0695   -1.0807   -1.0917   -1.1027   -1.1137   -1.1245   -1.1348   -1.1452   -1.1559   -1.1659   -1.1758   -1.1864   -1.1972   -1.2080   -1.2190   -1.2298   -1.2406   -1.2509   -1.2614   -1.2718   -1.2823   -1.2928   -1.3028   -1.3133   -1.3232   -1.3333   -1.3433   -1.3530   -1.3630   -1.3729   -1.3826   -1.3922   -1.4021   -1.4126   -1.4225   -1.4326   -1.4421   -1.4520   -1.4621   -1.4723   -1.4817   -1.4912   -1.5012   -1.5108   -1.5203   -1.5300   -1.5402   -1.5496   -1.5589   -1.5678   -1.5776   -1.5872   -1.5959   -1.6055   -1.6151   -1.6249   -1.6341   -1.6436   -1.6527   -1.6624   -1.6714   -1.6805   -1.6894   -1.6985   -1.7074   -1.7162   -1.7251   -1.7342   -1.7432   -1.7519   -1.7601   -1.7690   -1.7775   -1.7864   -1.7952   -1.8041   -1.8125   -1.8210   -1.8302   -1.8388   -1.8470   -1.8557   -1.8640   -1.8724   -1.8806   -1.8888   -1.8969   -1.9049   -1.9133   -1.9217   -1.9298   -1.9379   -1.9462   -1.9542   -1.9627   -1.9710   -1.9789   -1.9872   -1.9951   -2.0036   -2.0113   -2.0196   -2.0274   -2.0351   -2.0427   -2.0502   -2.0584   -2.0661   -2.0738   -2.0816   -2.0891   -2.0965   -2.1035   -2.1107   -2.1184   -2.1256   -2.1334   -2.1404   -2.1477   -2.1547   -2.1619   -2.1693   -2.1764   -2.1832   -2.1903   -2.1972   -2.2041   -2.2107   -2.2177   -2.2242   -2.2311   -2.2378   -2.2441   -2.2508   -2.2581   -2.2651   -2.2719   -2.2778   -2.2842   -2.2910   -2.2975   -2.3039   -2.3097   -2.3158   -2.3214   -2.3275   -2.3336   -2.3396   -2.3455   -2.3516   -2.3576   -2.3641   -2.3695   -2.3750   -2.3805   -2.3867   -2.3932
 -0.5815   -0.5933   -0.6035   -0.6135   -0.6246   -0.6357   -0.6475   -0.6595   -0.6717   -0.6825   -0.6939   -0.7057   -0.7168   -0.7282   -0.7395   -0.7514   -0.7636   -0.7751   -0.7872   -0.7991   -0.8113   -0.8230   -0.8348   -0.8468   -0.8580   -0.8691   -0.8811   -0.8924   -0.9039   -0.9153   -0.9269   -0.9380   -0.9491   -0.9602   -0.9716   -0.9830   -0.9948   -1.0060   -1.0174   -1.0278   -1.0388   -1.0500   -1.0614   -1.0723   -1.0829   -1.0940   -1.1046   -1.1152   -1.1261   -1.1366   -1.1475   -1.1588   -1.1693   -1.1799   -1.1903   -1.2013   -1.2116   -1.2222   -1.2326   -1.2437   -1.2540   -1.2644   -1.2754   -1.2855   -1.2959   -1.3065   -1.3166   -1.3273   -1.3382   -1.3483   -1.3581   -1.3686   -1.3787   -1.3887   -1.3988   -1.4086   -1.4190   -1.4291   -1.4392   -1.4491   -1.4587   -1.4684   -1.4783   -1.4887   -1.4987   -1.5087   -1.5188   -1.5286   -1.5380   -1.5475   -1.5573   -1.5671   -1.5763   -1.5857   -1.5957   -1.6056   -1.6149   -1.6246   -1.6341   -1.6436   -1.6529   -1.6626   -1.6718   -1.6807   -1.6900   -1.6990   -1.7080   -1.7170   -1.7256   -1.7348   -1.7444   -1.7539   -1.7631   -1.7725   -1.7815   -1.7904   -1.7992   -1.8079   -1.8170   -1.8253   -1.8339   -1.8428   -1.8511   -1.8595   -1.8685   -1.8773   -1.8860   -1.8943   -1.9023   -1.9109   -1.9191   -1.9275   -1.9359   -1.9444   -1.9527   -1.9609   -1.9693   -1.9779   -1.9855   -1.9933   -2.0010   -2.0094   -2.0174   -2.0258   -2.0340   -2.0419   -2.0500   -2.0575   -2.0649   -2.0726   -2.0801   -2.0878   -2.0962   -2.1036   -2.1113   -2.1190   -2.1265   -2.1341   -2.1411   -2.1480   -2.1551   -2.1627   -2.1699   -2.1770   -2.1841   -2.1910   -2.1980   -2.2053   -2.2120   -2.2185   -2.2252   -2.2317   -2.2384   -2.2459   -2.2524   -2.2587   -2.2652   -2.2715   -2.2781   -2.2841   -2.2907   -2.2974   -2.3034   -2.3101   -2.3160   -2.3219   -2.3282   -2.3346   -2.3404   -2.3468   -2.3524   -2.3580   -2.3637   -2.3702   -2.3765   -2.3825   -2.3885   -2.3926   -2.3979
 -0.5674   -0.5801   -0.5910   -0.6017   -0.6140   -0.6250   -0.6364   -0.6478   -0.6590   -0.6712   -0.6826   -0.6948   -0.7058   -0.7177   -0.7295   -0.7419   -0.7532   -0.7648   -0.7765   -0.7885   -0.8007   -0.8123   -0.8243   -0.8356   -0.8475   -0.8585   -0.8703   -0.8821   -0.8937   -0.9055   -0.9166   -0.9281   -0.9398   -0.9506   -0.9620   -0.9736   -0.9848   -0.9961   -1.0075   -1.0188   -1.0299   -1.0415   -1.0525   -1.0637   -1.0745   -1.0859   -1.0970   -1.1078   -1.1191   -1.1302   -1.1415   -1.1517   -1.1625   -1.1734   -1.1842   -1.1953   -1.2064   -1.2169   -1.2276   -1.2380   -1.2486   -1.2596   -1.2702   -1.2812   -1.2915   -1.3017   -1.3122   -1.3222   -1.3327   -1.3430   -1.3537   -1.3642   -1.3745   -1.3850   -1.3952   -1.4060   -1.4165   -1.4267   -1.4366   -1.4469   -1.4568   -1.4664   -1.4766   -1.4867   -1.4966   -1.5065   -1.5160   -1.5260   -1.5362   -1.5456   -1.5557   -1.5656   -1.5753   -1.5849   -1.5948   -1.6045   -1.6146   -1.6245   -1.6337   -1.6436   -1.6531   -1.6629   -1.6725   -1.6817   -1.6906   -1.6998   -1.7090   -1.7179   -1.7273   -1.7365   -1.7458   -1.7552   -1.7646   -1.7738   -1.7827   -1.7922   -1.8010   -1.8100   -1.8187   -1.8283   -1.8372   -1.8463   -1.8548   -1.8638   -1.8723   -1.8810   -1.8892   -1.8981   -1.9069   -1.9159   -1.9241   -1.9323   -1.9410   -1.9492   -1.9579   -1.9661   -1.9745   -1.9827   -1.9907   -1.9991   -2.0071   -2.0152   -2.0229   -2.0308   -2.0386   -2.0472   -2.0547   -2.0627   -2.0704   -2.0784   -2.0865   -2.0939   -2.1014   -2.1091   -2.1164   -2.1239   -2.1317   -2.1391   -2.1468   -2.1541   -2.1609   -2.1680   -2.1755   -2.1827   -2.1895   -2.1966   -2.2029   -2.2102   -2.2172   -2.2244   -2.2307   -2.2378   -2.2446   -2.2510   -2.2574   -2.2643   -2.2705   -2.2778   -2.2842   -2.2912   -2.2977   -2.3040   -2.3107   -2.3169   -2.3233   -2.3291   -2.3355   -2.3412   -2.3479   -2.3547   -2.3602   -2.3660   -2.3723   -2.3779   -2.3835   -2.3900   -2.3959   -2.4024   -2.4074
 -0.5567   -0.5683   -0.5792   -0.5910   -0.6028   -0.6141   -0.6259   -0.6371   -0.6481   -0.6596   -0.6716   -0.6833   -0.6952   -0.7076   -0.7191   -0.7302   -0.7420   -0.7545   -0.7658   -0.7781   -0.7898   -0.8012   -0.8130   -0.8250   -0.8366   -0.8489   -0.8609   -0.8721   -0.8836   -0.8959   -0.9076   -0.9196   -0.9313   -0.9426   -0.9536   -0.9651   -0.9763   -0.9877   -0.9989   -1.0104   -1.0217   -1.0336   -1.0446   -1.0559   -1.0673   -1.0785   -1.0890   -1.1004   -1.1118   -1.1227   -1.1338   -1.1450   -1.1565   -1.1673   -1.1782   -1.1897   -1.2008   -1.2115   -1.2226   -1.2331   -1.2442   -1.2550   -1.2659   -1.2767   -1.2876   -1.2985   -1.3089   -1.3195   -1.3300   -1.3405   -1.3511   -1.3612   -1.3720   -1.3822   -1.3920   -1.4021   -1.4129   -1.4234   -1.4338   -1.4443   -1.4543   -1.4642   -1.4744   -1.4843   -1.4944   -1.5045   -1.5148   -1.5246   -1.5344   -1.5444   -1.5544   -1.5645   -1.5750   -1.5845   -1.5944   -1.6042   -1.6142   -1.6238   -1.6334   -1.6436   -1.6536   -1.6633   -1.6725   -1.6818   -1.6915   -1.7011   -1.7103   -1.7193   -1.7284   -1.7379   -1.7477   -1.7573   -1.7671   -1.7762   -1.7854   -1.7948   -1.8040   -1.8130   -1.8221   -1.8315   -1.8402   -1.8495   -1.8585   -1.8667   -1.8758   -1.8844   -1.8934   -1.9019   -1.9105   -1.9190   -1.9278   -1.9365   -1.9453   -1.9538   -1.9624   -1.9708   -1.9789   -1.9874   -1.9958   -2.0036   -2.0113   -2.0195   -2.0274   -2.0360   -2.0441   -2.0518   -2.0596   -2.0678   -2.0757   -2.0838   -2.0916   -2.0990   -2.1063   -2.1142   -2.1213   -2.1289   -2.1363   -2.1436   -2.1513   -2.1585   -2.1660   -2.1736   -2.1813   -2.1892   -2.1964   -2.2036   -2.2110   -2.2182   -2.2254   -2.2323   -2.2394   -2.2466   -2.2532   -2.2601   -2.2666   -2.2734   -2.2798   -2.2862   -2.2921   -2.2990   -2.3062   -2.3127   -2.3188   -2.3255   -2.3322   -2.3385   -2.3445   -2.3507   -2.3567   -2.3620   -2.3683   -2.3736   -2.3795   -2.3850   -2.3904   -2.3967   -2.4027   -2.4087   -2.4143
 -0.5431   -0.5548   -0.5662   -0.5777   -0.5885   -0.6002   -0.6118   -0.6238   -0.6354   -0.6480   -0.6600   -0.6721   -0.6838   -0.6957   -0.7078   -0.7203   -0.7323   -0.7439   -0.7554   -0.7675   -0.7800   -0.7918   -0.8033   -0.8150   -0.8267   -0.8384   -0.8501   -0.8619   -0.8735   -0.8858   -0.8976   -0.9087   -0.9204   -0.9321   -0.9437   -0.9553   -0.9671   -0.9789   -0.9901   -1.0016   -1.0135   -1.0251   -1.0372   -1.0489   -1.0602   -1.0712   -1.0830   -1.0948   -1.1060   -1.1173   -1.1282   -1.1398   -1.1511   -1.1623   -1.1734   -1.1845   -1.1956   -1.2067   -1.2177   -1.2286   -1.2395   -1.2504   -1.2611   -1.2717   -1.2819   -1.2927   -1.3038   -1.3148   -1.3258   -1.3363   -1.3467   -1.3576   -1.3682   -1.3788   -1.3896   -1.4002   -1.4109   -1.4216   -1.4318   -1.4422   -1.4523   -1.4625   -1.4726   -1.4831   -1.4935   -1.5035   -1.5135   -1.5237   -1.5336   -1.5436   -1.5540   -1.5641   -1.5742   -1.5842   -1.5937   -1.6039   -1.6139   -1.6236   -1.6332   -1.6436   -1.6533   -1.6636   -1.6734   -1.6828   -1.6923   -1.7022   -1.7115   -1.7207   -1.7302   -1.7398   -1.7490   -1.7589   -1.7683   -1.7776   -1.7869   -1.7966   -1.8059   -1.8152   -1.8246   -1.8336   -1.8429   -1.8521   -1.8612   -1.8696   -1.8784   -1.8869   -1.8958   -1.9045   -1.9133   -1.9223   -1.9312   -1.9401   -1.9490   -1.9573   -1.9662   -1.9749   -1.9830   -1.9919   -2.0000   -2.0077   -2.0157   -2.0241   -2.0329   -2.0412   -2.0495   -2.0582   -2.0665   -2.0744   -2.0826   -2.0901   -2.0980   -2.1059   -2.1137   -2.1212   -2.1289   -2.1367   -2.1447   -2.1523   -2.1601   -2.1675   -2.1751   -2.1828   -2.1900   -2.1963   -2.2031   -2.2107   -2.2180   -2.2249   -2.2318   -2.2387   -2.2458   -2.2530   -2.2598   -2.2670   -2.2737   -2.2802   -2.2868   -2.2936   -2.3008   -2.3072   -2.3140   -2.3205   -2.3272   -2.3334   -2.3394   -2.3454   -2.3510   -2.3568   -2.3628   -2.3691   -2.3749   -2.3799   -2.3855   -2.3917   -2.3981   -2.4040   -2.4102   -2.4161   -2.4213
 -0.5324   -0.5461   -0.5570   -0.5688   -0.5795   -0.5916   -0.6029   -0.6149   -0.6275   -0.6397   -0.6520   -0.6644   -0.6762   -0.6883   -0.7003   -0.7121   -0.7241   -0.7364   -0.7486   -0.7604   -0.7729   -0.7842   -0.7952   -0.8068   -0.8191   -0.8309   -0.8424   -0.8536   -0.8656   -0.8775   -0.8891   -0.9008   -0.9131   -0.9246   -0.9362   -0.9481   -0.9597   -0.9710   -0.9828   -0.9946   -1.0061   -1.0177   -1.0292   -1.0408   -1.0528   -1.0643   -1.0752   -1.0867   -1.0989   -1.1105   -1.1222   -1.1336   -1.1452   -1.1562   -1.1675   -1.1790   -1.1907   -1.2015   -1.2121   -1.2233   -1.2342   -1.2451   -1.2563   -1.2667   -1.2777   -1.2890   -1.3000   -1.3109   -1.3216   -1.3321   -1.3430   -1.3531   -1.3641   -1.3753   -1.3861   -1.3966   -1.4081   -1.4185   -1.4286   -1.4383   -1.4490   -1.4600   -1.4708   -1.4812   -1.4915   -1.5016   -1.5116   -1.5218   -1.5324   -1.5426   -1.5526   -1.5634   -1.5735   -1.5831   -1.5932   -1.6035   -1.6140   -1.6234   -1.6330   -1.6436   -1.6536   -1.6635   -1.6738   -1.6834   -1.6929   -1.7027   -1.7125   -1.7221   -1.7319   -1.7417   -1.7515   -1.7608   -1.7704   -1.7799   -1.7892   -1.7985   -1.8083   -1.8176   -1.8268   -1.8359   -1.8448   -1.8540   -1.8625   -1.8718   -1.8810   -1.8903   -1.8991   -1.9076   -1.9166   -1.9253   -1.9344   -1.9431   -1.9519   -1.9605   -1.9689   -1.9776   -1.9861   -1.9948   -2.0033   -2.0115   -2.0192   -2.0277   -2.0361   -2.0446   -2.0529   -2.0611   -2.0693   -2.0773   -2.0852   -2.0933   -2.1014   -2.1089   -2.1172   -2.1254   -2.1334   -2.1410   -2.1489   -2.1565   -2.1640   -2.1715   -2.1787   -2.1861   -2.1938   -2.2013   -2.2087   -2.2154   -2.2225   -2.2295   -2.2367   -2.2436   -2.2512   -2.2584   -2.2654   -2.2725   -2.2794   -2.2861   -2.2933   -2.2997   -2.3067   -2.3136   -2.3199   -2.3262   -2.3324   -2.3386   -2.3451   -2.3510   -2.3569   -2.3636   -2.3694   -2.3758   -2.3822   -2.3883   -2.3941   -2.4001   -2.4061   -2.4108   -2.4169   -2.4235   -2.4292
 -0.5240   -0.5362   -0.5474   -0.5589   -0.5700   -0.5812   -0.5921   -0.6042   -0.6159   -0.6277   -0.6399   -0.6515   -0.6643   -0.6764   -0.6885   -0.7008   -0.7128   -0.7249   -0.7375   -0.7496   -0.7614   -0.7738   -0.7854   -0.7973   -0.8094   -0.8215   -0.8329   -0.8453   -0.8574   -0.8694   -0.8816   -0.8931   -0.9050   -0.9166   -0.9280   -0.9401   -0.9519   -0.9637   -0.9756   -0.9872   -0.9989   -1.0112   -1.0229   -1.0349   -1.0462   -1.0580   -1.0699   -1.0813   -1.0928   -1.1041   -1.1154   -1.1272   -1.1389   -1.1503   -1.1620   -1.1735   -1.1850   -1.1968   -1.2075   -1.2190   -1.2297   -1.2406   -1.2516   -1.2621   -1.2733   -1.2847   -1.2953   -1.3060   -1.3172   -1.3284   -1.3394   -1.3506   -1.3613   -1.3720   -1.3830   -1.3939   -1.4045   -1.4152   -1.4259   -1.4365   -1.4469   -1.4579   -1.4684   -1.4793   -1.4901   -1.5005   -1.5105   -1.5213   -1.5311   -1.5412   -1.5521   -1.5624   -1.5727   -1.5827   -1.5927   -1.6030   -1.6135   -1.6231   -1.6331   -1.6436   -1.6535   -1.6637   -1.6741   -1.6841   -1.6942   -1.7039   -1.7136   -1.7238   -1.7336   -1.7432   -1.7529   -1.7625   -1.7725   -1.7821   -1.7914   -1.8013   -1.8113   -1.8204   -1.8296   -1.8387   -1.8477   -1.8568   -1.8658   -1.8748   -1.8838   -1.8927   -1.9017   -1.9109   -1.9195   -1.9286   -1.9378   -1.9473   -1.9565   -1.9653   -1.9737   -1.9824   -1.9909   -1.9995   -2.0084   -2.0174   -2.0264   -2.0349   -2.0433   -2.0519   -2.0607   -2.0687   -2.0766   -2.0850   -2.0932   -2.1013   -2.1093   -2.1170   -2.1247   -2.1331   -2.1412   -2.1491   -2.1566   -2.1638   -2.1717   -2.1796   -2.1874   -2.1946   -2.2025   -2.2094   -2.2173   -2.2248   -2.2327   -2.2398   -2.2468   -2.2542   -2.2616   -2.2685   -2.2755   -2.2824   -2.2898   -2.2965   -2.3035   -2.3106   -2.3174   -2.3235   -2.3302   -2.3374   -2.3444   -2.3507   -2.3574   -2.3633   -2.3694   -2.3755   -2.3822   -2.3879   -2.3939   -2.3997   -2.4053   -2.4111   -2.4177   -2.4235   -2.4295   -2.4344   -2.4401
 -0.5144   -0.5258   -0.5377   -0.5492   -0.5606   -0.5732   -0.5849   -0.5973   -0.6090   -0.6209   -0.6325   -0.6441   -0.6562   -0.6689   -0.6815   -0.6945   -0.7066   -0.7191   -0.7307   -0.7425   -0.7544   -0.7664   -0.7787   -0.7906   -0.8032   -0.8151   -0.8269   -0.8384   -0.8504   -0.8627   -0.8754   -0.8875   -0.8992   -0.9112   -0.9233   -0.9349   -0.9473   -0.9593   -0.9710   -0.9831   -0.9949   -1.0070   -1.0183   -1.0301   -1.0422   -1.0546   -1.0666   -1.0781   -1.0902   -1.1017   -1.1131   -1.1244   -1.1364   -1.1483   -1.1598   -1.1706   -1.1820   -1.1934   -1.2043   -1.2156   -1.2268   -1.2383   -1.2495   -1.2607   -1.2721   -1.2830   -1.2940   -1.3049   -1.3155   -1.3265   -1.3374   -1.3485   -1.3589   -1.3697   -1.3807   -1.3917   -1.4023   -1.4128   -1.4234   -1.4338   -1.4448   -1.4555   -1.4661   -1.4772   -1.4881   -1.4984   -1.5089   -1.5195   -1.5300   -1.5406   -1.5509   -1.5613   -1.5715   -1.5819   -1.5923   -1.6027   -1.6132   -1.6233   -1.6331   -1.6436   -1.6538   -1.6638   -1.6741   -1.6844   -1.6943   -1.7042   -1.7144   -1.7241   -1.7341   -1.7438   -1.7537   -1.7637   -1.7735   -1.7827   -1.7926   -1.8023   -1.8122   -1.8215   -1.8311   -1.8406   -1.8499   -1.8593   -1.8687   -1.8776   -1.8870   -1.8963   -1.9056   -1.9149   -1.9242   -1.9335   -1.9427   -1.9517   -1.9611   -1.9701   -1.9789   -1.9877   -1.9966   -2.0052   -2.0139   -2.0225   -2.0310   -2.0398   -2.0479   -2.0564   -2.0654   -2.0741   -2.0825   -2.0907   -2.0983   -2.1067   -2.1146   -2.1228   -2.1312   -2.1394   -2.1471   -2.1553   -2.1631   -2.1710   -2.1789   -2.1870   -2.1949   -2.2028   -2.2102   -2.2179   -2.2255   -2.2335   -2.2410   -2.2486   -2.2559   -2.2631   -2.2710   -2.2782   -2.2854   -2.2929   -2.3004   -2.3070   -2.3138   -2.3207   -2.3271   -2.3340   -2.3404   -2.3465   -2.3530   -2.3600   -2.3662   -2.3720   -2.3777   -2.3837   -2.3894   -2.3962   -2.4020   -2.4084   -2.4138   -2.4203   -2.4265   -2.4316   -2.4374   -2.4440   -2.4494
 -0.5047   -0.5170   -0.5289   -0.5411   -0.5531   -0.5655   -0.5774   -0.5895   -0.6010   -0.6127   -0.6244   -0.6356   -0.6477   -0.6606   -0.6729   -0.6849   -0.6973   -0.7096   -0.7210   -0.7332   -0.7453   -0.7578   -0.7699   -0.7816   -0.7944   -0.8067   -0.8192   -0.8308   -0.8432   -0.8551   -0.8674   -0.8800   -0.8923   -0.9044   -0.9167   -0.9288   -0.9408   -0.9529   -0.9652   -0.9769   -0.9896   -1.0009   -1.0135   -1.0253   -1.0372   -1.0492   -1.0610   -1.0732   -1.0852   -1.0975   -1.1088   -1.1203   -1.1322   -1.1434   -1.1546   -1.1664   -1.1778   -1.1896   -1.2007   -1.2116   -1.2230   -1.2347   -1.2460   -1.2580   -1.2692   -1.2801   -1.2911   -1.3021   -1.3132   -1.3243   -1.3356   -1.3466   -1.3575   -1.3684   -1.3793   -1.3903   -1.4013   -1.4119   -1.4228   -1.4334   -1.4439   -1.4549   -1.4654   -1.4759   -1.4864   -1.4969   -1.5078   -1.5184   -1.5289   -1.5393   -1.5501   -1.5600   -1.5710   -1.5814   -1.5919   -1.6027   -1.6131   -1.6233   -1.6332   -1.6436   -1.6536   -1.6640   -1.6742   -1.6842   -1.6946   -1.7044   -1.7144   -1.7245   -1.7347   -1.7447   -1.7544   -1.7647   -1.7752   -1.7854   -1.7949   -1.8045   -1.8142   -1.8234   -1.8332   -1.8425   -1.8520   -1.8614   -1.8711   -1.8802   -1.8897   -1.8990   -1.9084   -1.9179   -1.9274   -1.9364   -1.9453   -1.9549   -1.9646   -1.9734   -1.9825   -1.9914   -2.0005   -2.0098   -2.0187   -2.0271   -2.0358   -2.0439   -2.0531   -2.0615   -2.0698   -2.0784   -2.0868   -2.0952   -2.1034   -2.1116   -2.1204   -2.1289   -2.1374   -2.1452   -2.1534   -2.1620   -2.1701   -2.1782   -2.1862   -2.1942   -2.2023   -2.2098   -2.2173   -2.2252   -2.2329   -2.2404   -2.2476   -2.2555   -2.2628   -2.2701   -2.2780   -2.2853   -2.2930   -2.3005   -2.3077   -2.3148   -2.3212   -2.3281   -2.3346   -2.3411   -2.3480   -2.3546   -2.3615   -2.3679   -2.3742   -2.3802   -2.3860   -2.3920   -2.3985   -2.4048   -2.4102   -2.4163   -2.4217   -2.4280   -2.4349   -2.4405   -2.4458   -2.4511   -2.4560
 -0.4981   -0.5088   -0.5210   -0.5333   -0.5453   -0.5582   -0.5703   -0.5823   -0.5936   -0.6056   -0.6181   -0.6302   -0.6425   -0.6542   -0.6665   -0.6787   -0.6912   -0.7037   -0.7158   -0.7278   -0.7400   -0.7526   -0.7644   -0.7768   -0.7889   -0.8008   -0.8131   -0.8254   -0.8377   -0.8497   -0.8614   -0.8734   -0.8858   -0.8984   -0.9110   -0.9235   -0.9359   -0.9481   -0.9604   -0.9716   -0.9834   -0.9959   -1.0073   -1.0190   -1.0312   -1.0428   -1.0553   -1.0670   -1.0785   -1.0906   -1.1027   -1.1148   -1.1268   -1.1382   -1.1502   -1.1621   -1.1737   -1.1853   -1.1966   -1.2081   -1.2196   -1.2312   -1.2425   -1.2540   -1.2648   -1.2761   -1.2871   -1.2986   -1.3098   -1.3213   -1.3323   -1.3434   -1.3550   -1.3661   -1.3775   -1.3885   -1.3997   -1.4109   -1.4215   -1.4324   -1.4432   -1.4536   -1.4647   -1.4755   -1.4862   -1.4965   -1.5074   -1.5178   -1.5281   -1.5390   -1.5497   -1.5598   -1.5702   -1.5810   -1.5914   -1.6020   -1.6125   -1.6228   -1.6331   -1.6436   -1.6535   -1.6640   -1.6746   -1.6848   -1.6950   -1.7049   -1.7149   -1.7252   -1.7352   -1.7452   -1.7550   -1.7658   -1.7756   -1.7856   -1.7958   -1.8055   -1.8153   -1.8250   -1.8344   -1.8438   -1.8540   -1.8636   -1.8734   -1.8828   -1.8918   -1.9015   -1.9112   -1.9206   -1.9299   -1.9389   -1.9481   -1.9572   -1.9668   -1.9760   -1.9845   -1.9940   -2.0031   -2.0124   -2.0214   -2.0303   -2.0390   -2.0479   -2.0570   -2.0658   -2.0743   -2.0829   -2.0917   -2.0998   -2.1081   -2.1168   -2.1256   -2.1341   -2.1419   -2.1499   -2.1582   -2.1666   -2.1745   -2.1825   -2.1903   -2.1984   -2.2063   -2.2141   -2.2222   -2.2298   -2.2379   -2.2456   -2.2528   -2.2602   -2.2679   -2.2758   -2.2835   -2.2909   -2.2982   -2.3058   -2.3131   -2.3201   -2.3277   -2.3349   -2.3415   -2.3484   -2.3557   -2.3626   -2.3693   -2.3760   -2.3820   -2.3883   -2.3949   -2.4003   -2.4067   -2.4131   -2.4191   -2.4259   -2.4314   -2.4375   -2.4439   -2.4490   -2.4548   -2.4612   -2.4671
 -0.4888   -0.5022   -0.5131   -0.5250   -0.5368   -0.5494   -0.5619   -0.5743   -0.5864   -0.5983   -0.6116   -0.6241   -0.6363   -0.6487   -0.6607   -0.6729   -0.6857   -0.6979   -0.7109   -0.7230   -0.7360   -0.7479   -0.7603   -0.7719   -0.7841   -0.7965   -0.8094   -0.8215   -0.8338   -0.8457   -0.8581   -0.8708   -0.8832   -0.8956   -0.9076   -0.9197   -0.9321   -0.9444   -0.9561   -0.9679   -0.9801   -0.9920   -1.0037   -1.0153   -1.0275   -1.0390   -1.0508   -1.0631   -1.0756   -1.0874   -1.0992   -1.1106   -1.1228   -1.1345   -1.1462   -1.1579   -1.1695   -1.1811   -1.1929   -1.2037   -1.2149   -1.2270   -1.2386   -1.2502   -1.2614   -1.2729   -1.2846   -1.2962   -1.3077   -1.3188   -1.3300   -1.3409   -1.3522   -1.3633   -1.3746   -1.3857   -1.3964   -1.4073   -1.4185   -1.4295   -1.4405   -1.4519   -1.4629   -1.4742   -1.4850   -1.4956   -1.5064   -1.5170   -1.5279   -1.5383   -1.5487   -1.5593   -1.5697   -1.5800   -1.5905   -1.6016   -1.6123   -1.6226   -1.6331   -1.6436   -1.6536   -1.6644   -1.6749   -1.6851   -1.6948   -1.7047   -1.7150   -1.7254   -1.7358   -1.7461   -1.7564   -1.7665   -1.7771   -1.7869   -1.7965   -1.8064   -1.8157   -1.8258   -1.8356   -1.8453   -1.8547   -1.8643   -1.8742   -1.8835   -1.8928   -1.9022   -1.9118   -1.9219   -1.9317   -1.9411   -1.9508   -1.9601   -1.9693   -1.9785   -1.9876   -1.9965   -2.0059   -2.0156   -2.0249   -2.0337   -2.0424   -2.0512   -2.0596   -2.0686   -2.0777   -2.0865   -2.0954   -2.1037   -2.1123   -2.1203   -2.1289   -2.1381   -2.1471   -2.1550   -2.1632   -2.1718   -2.1798   -2.1884   -2.1967   -2.2045   -2.2129   -2.2206   -2.2283   -2.2362   -2.2445   -2.2523   -2.2602   -2.2679   -2.2754   -2.2837   -2.2911   -2.2986   -2.3062   -2.3134   -2.3205   -2.3284   -2.3353   -2.3428   -2.3501   -2.3568   -2.3632   -2.3703   -2.3772   -2.3837   -2.3910   -2.3980   -2.4040   -2.4098   -2.4165   -2.4230   -2.4294   -2.4359   -2.4425   -2.4490   -2.4547   -2.4607   -2.4661   -2.4724   -2.4790
 -0.4858   -0.4975   -0.5094   -0.5212   -0.5332   -0.5458   -0.5578   -0.5702   -0.5829   -0.5949   -0.6071   -0.6201   -0.6323   -0.6449   -0.6577   -0.6701   -0.6824   -0.6950   -0.7072   -0.7193   -0.7316   -0.7438   -0.7569   -0.7692   -0.7809   -0.7932   -0.8056   -0.8177   -0.8298   -0.8416   -0.8539   -0.8660   -0.8782   -0.8906   -0.9027   -0.9150   -0.9275   -0.9400   -0.9521   -0.9641   -0.9764   -0.9883   -1.0001   -1.0117   -1.0238   -1.0357   -1.0475   -1.0596   -1.0714   -1.0835   -1.0949   -1.1074   -1.1193   -1.1311   -1.1425   -1.1542   -1.1661   -1.1775   -1.1891   -1.2010   -1.2126   -1.2243   -1.2356   -1.2474   -1.2589   -1.2706   -1.2817   -1.2931   -1.3043   -1.3155   -1.3272   -1.3386   -1.3498   -1.3612   -1.3719   -1.3834   -1.3949   -1.4060   -1.4177   -1.4286   -1.4396   -1.4501   -1.4613   -1.4720   -1.4833   -1.4939   -1.5049   -1.5158   -1.5264   -1.5371   -1.5476   -1.5583   -1.5689   -1.5793   -1.5904   -1.6012   -1.6119   -1.6224   -1.6330   -1.6436   -1.6538   -1.6642   -1.6747   -1.6850   -1.6952   -1.7052   -1.7151   -1.7255   -1.7363   -1.7466   -1.7571   -1.7677   -1.7778   -1.7877   -1.7977   -1.8077   -1.8173   -1.8270   -1.8372   -1.8468   -1.8568   -1.8672   -1.8771   -1.8866   -1.8960   -1.9054   -1.9155   -1.9247   -1.9340   -1.9435   -1.9532   -1.9624   -1.9721   -1.9816   -1.9910   -2.0003   -2.0094   -2.0189   -2.0278   -2.0370   -2.0459   -2.0551   -2.0642   -2.0731   -2.0820   -2.0910   -2.1007   -2.1092   -2.1181   -2.1271   -2.1358   -2.1443   -2.1529   -2.1608   -2.1696   -2.1780   -2.1863   -2.1947   -2.2035   -2.2116   -2.2197   -2.2287   -2.2366   -2.2448   -2.2525   -2.2601   -2.2684   -2.2767   -2.2845   -2.2917   -2.2993   -2.3068   -2.3147   -2.3222   -2.3297   -2.3374   -2.3446   -2.3520   -2.3593   -2.3662   -2.3737   -2.3814   -2.3887   -2.3957   -2.4027   -2.4095   -2.4161   -2.4234   -2.4300   -2.4371   -2.4434   -2.4492   -2.4555   -2.4625   -2.4694   -2.4750   -2.4811   -2.4867   -2.4931
 -0.4814   -0.4942   -0.5065   -0.5185   -0.5303   -0.5427   -0.5548   -0.5663   -0.5787   -0.5912   -0.6036   -0.6156   -0.6282   -0.6412   -0.6535   -0.6659   -0.6786   -0.6916   -0.7040   -0.7166   -0.7294   -0.7419   -0.7542   -0.7667   -0.7788   -0.7913   -0.8031   -0.8156   -0.8280   -0.8399   -0.8523   -0.8647   -0.8764   -0.8886   -0.9008   -0.9130   -0.9251   -0.9372   -0.9495   -0.9613   -0.9740   -0.9860   -0.9982   -1.0109   -1.0228   -1.0347   -1.0466   -1.0588   -1.0707   -1.0824   -1.0945   -1.1061   -1.1181   -1.1300   -1.1416   -1.1532   -1.1652   -1.1768   -1.1886   -1.2003   -1.2121   -1.2238   -1.2348   -1.2467   -1.2582   -1.2695   -1.2806   -1.2919   -1.3037   -1.3147   -1.3260   -1.3372   -1.3482   -1.3598   -1.3710   -1.3822   -1.3934   -1.4046   -1.4159   -1.4266   -1.4373   -1.4488   -1.4599   -1.4708   -1.4820   -1.4927   -1.5037   -1.5150   -1.5262   -1.5373   -1.5477   -1.5583   -1.5689   -1.5792   -1.5901   -1.6010   -1.6118   -1.6223   -1.6327   -1.6436   -1.6540   -1.6644   -1.6751   -1.6856   -1.6960   -1.7061   -1.7158   -1.7263   -1.7366   -1.7469   -1.7572   -1.7677   -1.7779   -1.7880   -1.7985   -1.8084   -1.8183   -1.8287   -1.8384   -1.8478   -1.8574   -1.8674   -1.8774   -1.8873   -1.8974   -1.9069   -1.9167   -1.9265   -1.9363   -1.9462   -1.9555   -1.9652   -1.9749   -1.9843   -1.9936   -2.0030   -2.0122   -2.0218   -2.0310   -2.0407   -2.0495   -2.0587   -2.0678   -2.0767   -2.0860   -2.0949   -2.1042   -2.1129   -2.1220   -2.1316   -2.1408   -2.1496   -2.1582   -2.1669   -2.1755   -2.1842   -2.1926   -2.2012   -2.2093   -2.2176   -2.2264   -2.2347   -2.2434   -2.2516   -2.2599   -2.2679   -2.2762   -2.2840   -2.2916   -2.2999   -2.3074   -2.3155   -2.3230   -2.3308   -2.3383   -2.3461   -2.3535   -2.3614   -2.3683   -2.3759   -2.3831   -2.3905   -2.3981   -2.4056   -2.4133   -2.4199   -2.4269   -2.4343   -2.4408   -2.4477   -2.4548   -2.4617   -2.4682   -2.4757   -2.4821   -2.4893   -2.4952   -2.5019   -2.5084
 -0.4782   -0.4904   -0.5028   -0.5146   -0.5271   -0.5395   -0.5529   -0.5652   -0.5778   -0.5898   -0.6022   -0.6146   -0.6268   -0.6396   -0.6523   -0.6646   -0.6770   -0.6890   -0.7015   -0.7145   -0.7271   -0.7394   -0.7521   -0.7653   -0.7783   -0.7904   -0.8028   -0.8152   -0.8276   -0.8397   -0.8520   -0.8638   -0.8762   -0.8884   -0.9000   -0.9122   -0.9241   -0.9363   -0.9479   -0.9596   -0.9718   -0.9837   -0.9957   -1.0079   -1.0202   -1.0323   -1.0439   -1.0559   -1.0681   -1.0801   -1.0919   -1.1040   -1.1160   -1.1279   -1.1397   -1.1515   -1.1630   -1.1744   -1.1861   -1.1977   -1.2096   -1.2211   -1.2328   -1.2444   -1.2560   -1.2675   -1.2793   -1.2910   -1.3025   -1.3140   -1.3255   -1.3370   -1.3480   -1.3594   -1.3705   -1.3819   -1.3931   -1.4045   -1.4153   -1.4265   -1.4379   -1.4487   -1.4598   -1.4708   -1.4817   -1.4930   -1.5042   -1.5149   -1.5255   -1.5363   -1.5473   -1.5579   -1.5687   -1.5798   -1.5902   -1.6012   -1.6123   -1.6223   -1.6328   -1.6436   -1.6540   -1.6646   -1.6754   -1.6857   -1.6958   -1.7058   -1.7158   -1.7262   -1.7365   -1.7468   -1.7574   -1.7680   -1.7781   -1.7883   -1.7983   -1.8087   -1.8189   -1.8290   -1.8391   -1.8493   -1.8592   -1.8689   -1.8788   -1.8884   -1.8984   -1.9081   -1.9179   -1.9279   -1.9377   -1.9477   -1.9574   -1.9670   -1.9763   -1.9858   -1.9954   -2.0051   -2.0146   -2.0241   -2.0338   -2.0434   -2.0532   -2.0627   -2.0717   -2.0809   -2.0903   -2.0996   -2.1089   -2.1180   -2.1271   -2.1369   -2.1460   -2.1553   -2.1645   -2.1737   -2.1827   -2.1914   -2.1998   -2.2078   -2.2166   -2.2252   -2.2338   -2.2422   -2.2502   -2.2577   -2.2657   -2.2740   -2.2820   -2.2902   -2.2984   -2.3064   -2.3143   -2.3223   -2.3304   -2.3378   -2.3455   -2.3529   -2.3606   -2.3686   -2.3765   -2.3838   -2.3918   -2.3995   -2.4069   -2.4139   -2.4217   -2.4296   -2.4370   -2.4436   -2.4512   -2.4579   -2.4642   -2.4712   -2.4783   -2.4857   -2.4930   -2.4996   -2.5070   -2.5144   -2.5206
 -0.4724   -0.4860   -0.4982   -0.5103   -0.5231   -0.5363   -0.5492   -0.5615   -0.5741   -0.5865   -0.5999   -0.6123   -0.6247   -0.6372   -0.6498   -0.6628   -0.6755   -0.6877   -0.7006   -0.7126   -0.7250   -0.7374   -0.7502   -0.7626   -0.7749   -0.7873   -0.7989   -0.8116   -0.8237   -0.8360   -0.8481   -0.8602   -0.8725   -0.8847   -0.8966   -0.9088   -0.9213   -0.9337   -0.9456   -0.9580   -0.9702   -0.9823   -0.9943   -1.0060   -1.0179   -1.0293   -1.0411   -1.0527   -1.0647   -1.0765   -1.0886   -1.1004   -1.1128   -1.1246   -1.1366   -1.1483   -1.1600   -1.1712   -1.1835   -1.1954   -1.2071   -1.2188   -1.2307   -1.2429   -1.2545   -1.2663   -1.2779   -1.2893   -1.3006   -1.3118   -1.3232   -1.3347   -1.3461   -1.3579   -1.3693   -1.3806   -1.3914   -1.4026   -1.4140   -1.4250   -1.4363   -1.4474   -1.4588   -1.4696   -1.4808   -1.4922   -1.5035   -1.5142   -1.5249   -1.5358   -1.5466   -1.5577   -1.5683   -1.5792   -1.5901   -1.6007   -1.6117   -1.6221   -1.6328   -1.6436   -1.6543   -1.6648   -1.6753   -1.6854   -1.6961   -1.7063   -1.7168   -1.7272   -1.7377   -1.7481   -1.7584   -1.7688   -1.7798   -1.7898   -1.8001   -1.8101   -1.8200   -1.8305   -1.8410   -1.8513   -1.8618   -1.8717   -1.8819   -1.8921   -1.9015   -1.9116   -1.9216   -1.9314   -1.9415   -1.9512   -1.9608   -1.9709   -1.9806   -1.9906   -2.0006   -2.0099   -2.0196   -2.0289   -2.0382   -2.0482   -2.0571   -2.0668   -2.0768   -2.0868   -2.0965   -2.1057   -2.1150   -2.1241   -2.1330   -2.1420   -2.1512   -2.1609   -2.1697   -2.1790   -2.1883   -2.1971   -2.2059   -2.2151   -2.2236   -2.2326   -2.2417   -2.2506   -2.2590   -2.2676   -2.2760   -2.2845   -2.2936   -2.3021   -2.3099   -2.3179   -2.3261   -2.3342   -2.3420   -2.3499   -2.3574   -2.3656   -2.3737   -2.3821   -2.3896   -2.3975   -2.4053   -2.4135   -2.4210   -2.4283   -2.4362   -2.4439   -2.4505   -2.4576   -2.4651   -2.4719   -2.4793   -2.4860   -2.4938   -2.5013   -2.5084   -2.5153   -2.5222   -2.5306   -2.5365
 -0.4703   -0.4826   -0.4944   -0.5072   -0.5195   -0.5328   -0.5449   -0.5574   -0.5702   -0.5825   -0.5958   -0.6085   -0.6214   -0.6344   -0.6466   -0.6594   -0.6717   -0.6841   -0.6966   -0.7096   -0.7220   -0.7346   -0.7475   -0.7599   -0.7725   -0.7852   -0.7978   -0.8097   -0.8220   -0.8342   -0.8466   -0.8589   -0.8711   -0.8832   -0.8953   -0.9071   -0.9197   -0.9315   -0.9440   -0.9561   -0.9683   -0.9798   -0.9917   -1.0042   -1.0160   -1.0280   -1.0399   -1.0526   -1.0645   -1.0769   -1.0891   -1.1010   -1.1131   -1.1252   -1.1371   -1.1486   -1.1605   -1.1720   -1.1837   -1.1956   -1.2075   -1.2189   -1.2310   -1.2425   -1.2540   -1.2659   -1.2774   -1.2890   -1.3003   -1.3120   -1.3234   -1.3349   -1.3461   -1.3572   -1.3680   -1.3794   -1.3904   -1.4019   -1.4133   -1.4245   -1.4357   -1.4470   -1.4579   -1.4687   -1.4796   -1.4911   -1.5023   -1.5133   -1.5242   -1.5352   -1.5464   -1.5576   -1.5677   -1.5786   -1.5897   -1.6005   -1.6109   -1.6217   -1.6326   -1.6436   -1.6545   -1.6649   -1.6752   -1.6857   -1.6965   -1.7071   -1.7177   -1.7281   -1.7387   -1.7491   -1.7597   -1.7698   -1.7802   -1.7904   -1.8008   -1.8113   -1.8221   -1.8321   -1.8423   -1.8524   -1.8630   -1.8727   -1.8833   -1.8937   -1.9037   -1.9140   -1.9244   -1.9346   -1.9445   -1.9541   -1.9638   -1.9735   -1.9834   -1.9933   -2.0032   -2.0132   -2.0232   -2.0328   -2.0424   -2.0517   -2.0614   -2.0711   -2.0806   -2.0905   -2.1003   -2.1100   -2.1195   -2.1286   -2.1377   -2.1473   -2.1567   -2.1658   -2.1756   -2.1844   -2.1938   -2.2029   -2.2116   -2.2206   -2.2296   -2.2382   -2.2465   -2.2557   -2.2642   -2.2729   -2.2814   -2.2899   -2.2980   -2.3066   -2.3147   -2.3229   -2.3313   -2.3391   -2.3473   -2.3560   -2.3641   -2.3725   -2.3812   -2.3891   -2.3974   -2.4052   -2.4134   -2.4219   -2.4293   -2.4370   -2.4454   -2.4534   -2.4613   -2.4687   -2.4761   -2.4840   -2.4916   -2.4990   -2.5064   -2.5138   -2.5216   -2.5290   -2.5367   -2.5441   -2.5513
 -0.4681   -0.4816   -0.4945   -0.5073   -0.5193   -0.5316   -0.5442   -0.5574   -0.5696   -0.5823   -0.5949   -0.6077   -0.6201   -0.6331   -0.6453   -0.6581   -0.6705   -0.6829   -0.6959   -0.7086   -0.7211   -0.7334   -0.7458   -0.7583   -0.7703   -0.7832   -0.7960   -0.8086   -0.8207   -0.8326   -0.8444   -0.8566   -0.8687   -0.8811   -0.8931   -0.9050   -0.9178   -0.9302   -0.9423   -0.9549   -0.9670   -0.9791   -0.9909   -1.0025   -1.0152   -1.0273   -1.0395   -1.0518   -1.0635   -1.0760   -1.0883   -1.1003   -1.1126   -1.1244   -1.1360   -1.1478   -1.1600   -1.1718   -1.1836   -1.1957   -1.2073   -1.2191   -1.2310   -1.2427   -1.2540   -1.2658   -1.2775   -1.2890   -1.3002   -1.3112   -1.3227   -1.3337   -1.3446   -1.3557   -1.3667   -1.3778   -1.3891   -1.4006   -1.4121   -1.4239   -1.4353   -1.4460   -1.4574   -1.4683   -1.4793   -1.4903   -1.5014   -1.5127   -1.5236   -1.5347   -1.5458   -1.5564   -1.5675   -1.5784   -1.5893   -1.6000   -1.6105   -1.6214   -1.6324   -1.6436   -1.6543   -1.6651   -1.6758   -1.6862   -1.6971   -1.7074   -1.7179   -1.7285   -1.7388   -1.7495   -1.7596   -1.7698   -1.7804   -1.7909   -1.8020   -1.8123   -1.8227   -1.8329   -1.8431   -1.8535   -1.8639   -1.8744   -1.8841   -1.8948   -1.9052   -1.9155   -1.9258   -1.9357   -1.9462   -1.9560   -1.9661   -1.9762   -1.9860   -1.9964   -2.0067   -2.0169   -2.0264   -2.0359   -2.0462   -2.0558   -2.0658   -2.0753   -2.0852   -2.0943   -2.1038   -2.1133   -2.1230   -2.1322   -2.1419   -2.1509   -2.1600   -2.1690   -2.1786   -2.1877   -2.1964   -2.2056   -2.2147   -2.2237   -2.2329   -2.2418   -2.2506   -2.2595   -2.2682   -2.2765   -2.2850   -2.2936   -2.3026   -2.3114   -2.3203   -2.3294   -2.3382   -2.3465   -2.3553   -2.3638   -2.3722   -2.3815   -2.3900   -2.3985   -2.4068   -2.4152   -2.4236   -2.4318   -2.4394   -2.4474   -2.4552   -2.4633   -2.4713   -2.4794   -2.4870   -2.4946   -2.5031   -2.5112   -2.5192   -2.5275   -2.5357   -2.5432   -2.5514   -2.5586   -2.5671
 -0.4673   -0.4799   -0.4928   -0.5062   -0.5180   -0.5318   -0.5447   -0.5572   -0.5697   -0.5828   -0.5956   -0.6081   -0.6203   -0.6329   -0.6454   -0.6577   -0.6709   -0.6831   -0.6961   -0.7085   -0.7213   -0.7335   -0.7460   -0.7585   -0.7708   -0.7834   -0.7953   -0.8079   -0.8202   -0.8326   -0.8446   -0.8571   -0.8694   -0.8818   -0.8942   -0.9066   -0.9186   -0.9305   -0.9428   -0.9547   -0.9672   -0.9801   -0.9918   -1.0039   -1.0162   -1.0284   -1.0398   -1.0522   -1.0645   -1.0763   -1.0879   -1.0997   -1.1110   -1.1230   -1.1347   -1.1471   -1.1586   -1.1702   -1.1819   -1.1938   -1.2054   -1.2166   -1.2285   -1.2397   -1.2515   -1.2634   -1.2749   -1.2859   -1.2978   -1.3091   -1.3210   -1.3324   -1.3435   -1.3548   -1.3663   -1.3776   -1.3890   -1.4001   -1.4111   -1.4223   -1.4334   -1.4446   -1.4555   -1.4663   -1.4778   -1.4891   -1.5009   -1.5119   -1.5229   -1.5343   -1.5449   -1.5561   -1.5674   -1.5785   -1.5892   -1.6006   -1.6109   -1.6217   -1.6325   -1.6436   -1.6543   -1.6652   -1.6761   -1.6864   -1.6971   -1.7083   -1.7187   -1.7291   -1.7394   -1.7500   -1.7604   -1.7712   -1.7814   -1.7921   -1.8027   -1.8133   -1.8241   -1.8345   -1.8448   -1.8550   -1.8653   -1.8756   -1.8857   -1.8957   -1.9065   -1.9166   -1.9268   -1.9368   -1.9470   -1.9571   -1.9673   -1.9768   -1.9870   -1.9967   -2.0069   -2.0165   -2.0266   -2.0361   -2.0461   -2.0558   -2.0659   -2.0755   -2.0852   -2.0947   -2.1045   -2.1140   -2.1238   -2.1331   -2.1424   -2.1518   -2.1611   -2.1706   -2.1801   -2.1893   -2.1990   -2.2086   -2.2183   -2.2276   -2.2365   -2.2455   -2.2537   -2.2627   -2.2719   -2.2807   -2.2899   -2.2989   -2.3081   -2.3167   -2.3256   -2.3349   -2.3440   -2.3526   -2.3620   -2.3701   -2.3786   -2.3866   -2.3950   -2.4033   -2.4117   -2.4205   -2.4291   -2.4374   -2.4457   -2.4540   -2.4621   -2.4709   -2.4791   -2.4874   -2.4951   -2.5032   -2.5114   -2.5195   -2.5280   -2.5353   -2.5427   -2.5508   -2.5599   -2.5683   -2.5765
 -0.4664   -0.4802   -0.4930   -0.5055   -0.5182   -0.5310   -0.5444   -0.5572   -0.5699   -0.5830   -0.5958   -0.6081   -0.6205   -0.6333   -0.6450   -0.6577   -0.6702   -0.6826   -0.6955   -0.7077   -0.7202   -0.7323   -0.7453   -0.7582   -0.7711   -0.7834   -0.7955   -0.8075   -0.8201   -0.8325   -0.8450   -0.8572   -0.8695   -0.8819   -0.8937   -0.9060   -0.9182   -0.9301   -0.9424   -0.9549   -0.9666   -0.9786   -0.9911   -1.0029   -1.0151   -1.0272   -1.0390   -1.0511   -1.0629   -1.0748   -1.0864   -1.0985   -1.1105   -1.1229   -1.1351   -1.1467   -1.1585   -1.1705   -1.1819   -1.1936   -1.2049   -1.2164   -1.2280   -1.2395   -1.2507   -1.2628   -1.2745   -1.2854   -1.2969   -1.3085   -1.3201   -1.3314   -1.3427   -1.3544   -1.3656   -1.3767   -1.3885   -1.3997   -1.4107   -1.4215   -1.4329   -1.4443   -1.4555   -1.4666   -1.4781   -1.4893   -1.5003   -1.5116   -1.5226   -1.5336   -1.5448   -1.5556   -1.5670   -1.5781   -1.5891   -1.6000   -1.6108   -1.6217   -1.6326   -1.6436   -1.6542   -1.6652   -1.6761   -1.6865   -1.6972   -1.7083   -1.7192   -1.7300   -1.7401   -1.7503   -1.7608   -1.7715   -1.7815   -1.7920   -1.8027   -1.8132   -1.8236   -1.8344   -1.8445   -1.8548   -1.8652   -1.8756   -1.8857   -1.8966   -1.9067   -1.9174   -1.9275   -1.9374   -1.9475   -1.9583   -1.9681   -1.9778   -1.9874   -1.9971   -2.0071   -2.0169   -2.0272   -2.0372   -2.0476   -2.0571   -2.0674   -2.0768   -2.0862   -2.0955   -2.1054   -2.1149   -2.1246   -2.1337   -2.1435   -2.1529   -2.1620   -2.1717   -2.1809   -2.1909   -2.1998   -2.2089   -2.2183   -2.2272   -2.2364   -2.2458   -2.2549   -2.2647   -2.2737   -2.2829   -2.2924   -2.3011   -2.3097   -2.3190   -2.3280   -2.3371   -2.3462   -2.3553   -2.3634   -2.3717   -2.3804   -2.3897   -2.3988   -2.4073   -2.4161   -2.4243   -2.4329   -2.4411   -2.4492   -2.4577   -2.4658   -2.4743   -2.4831   -2.4911   -2.4997   -2.5074   -2.5154   -2.5230   -2.5313   -2.5391   -2.5473   -2.5555   -2.5644   -2.5715   -2.5804
];

cv25=[-1.8082   -1.8087   -1.8100   -1.8131   -1.8147   -1.8157   -1.8163   -1.8177   -1.8198   -1.8213   -1.8232   -1.8246   -1.8264   -1.8273   -1.8282   -1.8309   -1.8331   -1.8344   -1.8360   -1.8373   -1.8391   -1.8413   -1.8424   -1.8438   -1.8440   -1.8452   -1.8469   -1.8480   -1.8498   -1.8513   -1.8530   -1.8549   -1.8568   -1.8587   -1.8606   -1.8617   -1.8635   -1.8660   -1.8681   -1.8694   -1.8709   -1.8724   -1.8736   -1.8752   -1.8767   -1.8790   -1.8809   -1.8825   -1.8833   -1.8854   -1.8879   -1.8890   -1.8902   -1.8918   -1.8926   -1.8939   -1.8952   -1.8970   -1.8975   -1.8995   -1.9005   -1.9020   -1.9025   -1.9034   -1.9051   -1.9059   -1.9073   -1.9090   -1.9101   -1.9110   -1.9124   -1.9138   -1.9159   -1.9176   -1.9194   -1.9205   -1.9222   -1.9239   -1.9252   -1.9264   -1.9278   -1.9296   -1.9314   -1.9336   -1.9353   -1.9372   -1.9384   -1.9400   -1.9415   -1.9430   -1.9451   -1.9462   -1.9483   -1.9498   -1.9512   -1.9521   -1.9531   -1.9545   -1.9560   -1.9574   -1.9589   -1.9600   -1.9617   -1.9628   -1.9651   -1.9669   -1.9685   -1.9701   -1.9714   -1.9724   -1.9733   -1.9744   -1.9753   -1.9765   -1.9784   -1.9799   -1.9812   -1.9824   -1.9838   -1.9852   -1.9871   -1.9890   -1.9907   -1.9929   -1.9944   -1.9963   -1.9975   -1.9990   -2.0009   -2.0023   -2.0043   -2.0060   -2.0074   -2.0083   -2.0095   -2.0107   -2.0122   -2.0137   -2.0151   -2.0161   -2.0174   -2.0190   -2.0199   -2.0217   -2.0236   -2.0259   -2.0280   -2.0299   -2.0314   -2.0326   -2.0343   -2.0356   -2.0374   -2.0390   -2.0402   -2.0417   -2.0439   -2.0456   -2.0477   -2.0485   -2.0500   -2.0511   -2.0524   -2.0535   -2.0545   -2.0556   -2.0573   -2.0581   -2.0600   -2.0608   -2.0624   -2.0648   -2.0670   -2.0688   -2.0700   -2.0710   -2.0731   -2.0752   -2.0767   -2.0782   -2.0789   -2.0810   -2.0819   -2.0836   -2.0852   -2.0865   -2.0881   -2.0902   -2.0912   -2.0921   -2.0929   -2.0939   -2.0951   -2.0961   -2.0975   -2.0987   -2.0999   -2.1018   -2.1030
 -1.7414   -1.7438   -1.7466   -1.7493   -1.7502   -1.7532   -1.7564   -1.7587   -1.7610   -1.7636   -1.7654   -1.7678   -1.7701   -1.7716   -1.7729   -1.7747   -1.7762   -1.7778   -1.7801   -1.7828   -1.7853   -1.7872   -1.7898   -1.7919   -1.7939   -1.7960   -1.7982   -1.7998   -1.8020   -1.8051   -1.8070   -1.8086   -1.8107   -1.8131   -1.8155   -1.8172   -1.8191   -1.8213   -1.8233   -1.8264   -1.8283   -1.8306   -1.8322   -1.8343   -1.8365   -1.8384   -1.8403   -1.8425   -1.8448   -1.8472   -1.8490   -1.8517   -1.8538   -1.8561   -1.8585   -1.8605   -1.8620   -1.8640   -1.8659   -1.8683   -1.8700   -1.8723   -1.8747   -1.8763   -1.8790   -1.8818   -1.8840   -1.8857   -1.8874   -1.8892   -1.8916   -1.8936   -1.8960   -1.8990   -1.9012   -1.9036   -1.9058   -1.9079   -1.9106   -1.9122   -1.9144   -1.9171   -1.9192   -1.9214   -1.9238   -1.9259   -1.9276   -1.9306   -1.9333   -1.9360   -1.9385   -1.9406   -1.9429   -1.9448   -1.9475   -1.9490   -1.9511   -1.9529   -1.9556   -1.9574   -1.9596   -1.9622   -1.9645   -1.9664   -1.9688   -1.9711   -1.9732   -1.9755   -1.9776   -1.9793   -1.9815   -1.9830   -1.9851   -1.9873   -1.9892   -1.9910   -1.9934   -1.9959   -1.9983   -2.0010   -2.0029   -2.0045   -2.0068   -2.0099   -2.0121   -2.0144   -2.0165   -2.0186   -2.0213   -2.0238   -2.0258   -2.0277   -2.0302   -2.0324   -2.0339   -2.0363   -2.0382   -2.0399   -2.0411   -2.0434   -2.0455   -2.0472   -2.0496   -2.0515   -2.0534   -2.0562   -2.0586   -2.0602   -2.0623   -2.0647   -2.0660   -2.0677   -2.0698   -2.0719   -2.0740   -2.0753   -2.0776   -2.0798   -2.0823   -2.0849   -2.0869   -2.0897   -2.0928   -2.0952   -2.0977   -2.1000   -2.1017   -2.1046   -2.1062   -2.1081   -2.1102   -2.1134   -2.1150   -2.1163   -2.1174   -2.1194   -2.1222   -2.1242   -2.1257   -2.1281   -2.1309   -2.1336   -2.1353   -2.1378   -2.1403   -2.1424   -2.1444   -2.1455   -2.1470   -2.1498   -2.1519   -2.1539   -2.1560   -2.1576   -2.1597   -2.1620   -2.1636   -2.1661   -2.1674
 -1.6930   -1.6955   -1.6978   -1.6994   -1.7027   -1.7050   -1.7070   -1.7102   -1.7130   -1.7156   -1.7181   -1.7213   -1.7240   -1.7268   -1.7292   -1.7325   -1.7357   -1.7385   -1.7417   -1.7443   -1.7473   -1.7502   -1.7530   -1.7560   -1.7582   -1.7611   -1.7636   -1.7664   -1.7689   -1.7714   -1.7741   -1.7764   -1.7788   -1.7814   -1.7843   -1.7875   -1.7906   -1.7932   -1.7952   -1.7976   -1.8005   -1.8033   -1.8055   -1.8082   -1.8110   -1.8139   -1.8166   -1.8193   -1.8220   -1.8238   -1.8268   -1.8292   -1.8314   -1.8340   -1.8370   -1.8395   -1.8419   -1.8446   -1.8476   -1.8500   -1.8530   -1.8558   -1.8581   -1.8607   -1.8638   -1.8665   -1.8697   -1.8723   -1.8749   -1.8774   -1.8797   -1.8821   -1.8846   -1.8870   -1.8896   -1.8927   -1.8959   -1.8985   -1.9014   -1.9044   -1.9078   -1.9107   -1.9138   -1.9161   -1.9193   -1.9213   -1.9236   -1.9260   -1.9289   -1.9315   -1.9341   -1.9367   -1.9394   -1.9418   -1.9448   -1.9475   -1.9501   -1.9527   -1.9552   -1.9574   -1.9600   -1.9630   -1.9660   -1.9687   -1.9707   -1.9736   -1.9764   -1.9787   -1.9811   -1.9842   -1.9869   -1.9892   -1.9915   -1.9939   -1.9960   -1.9982   -2.0013   -2.0043   -2.0071   -2.0094   -2.0124   -2.0149   -2.0178   -2.0204   -2.0226   -2.0249   -2.0285   -2.0308   -2.0336   -2.0362   -2.0388   -2.0411   -2.0441   -2.0474   -2.0498   -2.0521   -2.0540   -2.0564   -2.0585   -2.0611   -2.0640   -2.0667   -2.0690   -2.0721   -2.0754   -2.0777   -2.0804   -2.0832   -2.0856   -2.0873   -2.0903   -2.0932   -2.0954   -2.0977   -2.1005   -2.1027   -2.1056   -2.1079   -2.1104   -2.1124   -2.1144   -2.1168   -2.1196   -2.1216   -2.1244   -2.1271   -2.1303   -2.1326   -2.1352   -2.1383   -2.1410   -2.1433   -2.1458   -2.1488   -2.1517   -2.1547   -2.1575   -2.1597   -2.1617   -2.1642   -2.1667   -2.1692   -2.1738   -2.1771   -2.1791   -2.1818   -2.1841   -2.1871   -2.1893   -2.1923   -2.1944   -2.1972   -2.1991   -2.2023   -2.2034   -2.2067   -2.2095   -2.2125   -2.2138
 -1.6495   -1.6502   -1.6544   -1.6567   -1.6597   -1.6629   -1.6656   -1.6694   -1.6733   -1.6765   -1.6807   -1.6840   -1.6874   -1.6901   -1.6930   -1.6964   -1.6992   -1.7029   -1.7058   -1.7091   -1.7117   -1.7147   -1.7177   -1.7208   -1.7244   -1.7277   -1.7314   -1.7344   -1.7378   -1.7408   -1.7435   -1.7470   -1.7503   -1.7535   -1.7571   -1.7607   -1.7645   -1.7677   -1.7705   -1.7734   -1.7763   -1.7788   -1.7819   -1.7853   -1.7884   -1.7914   -1.7945   -1.7979   -1.8014   -1.8043   -1.8071   -1.8105   -1.8131   -1.8160   -1.8196   -1.8230   -1.8260   -1.8293   -1.8323   -1.8354   -1.8380   -1.8414   -1.8445   -1.8471   -1.8501   -1.8533   -1.8571   -1.8606   -1.8639   -1.8669   -1.8705   -1.8730   -1.8756   -1.8791   -1.8819   -1.8841   -1.8870   -1.8907   -1.8939   -1.8971   -1.9003   -1.9032   -1.9059   -1.9084   -1.9109   -1.9142   -1.9176   -1.9209   -1.9240   -1.9271   -1.9307   -1.9339   -1.9373   -1.9403   -1.9428   -1.9464   -1.9488   -1.9522   -1.9547   -1.9574   -1.9607   -1.9637   -1.9668   -1.9699   -1.9729   -1.9757   -1.9789   -1.9823   -1.9853   -1.9878   -1.9907   -1.9934   -1.9962   -1.9992   -2.0017   -2.0046   -2.0079   -2.0113   -2.0140   -2.0174   -2.0205   -2.0238   -2.0266   -2.0298   -2.0324   -2.0351   -2.0379   -2.0412   -2.0450   -2.0481   -2.0510   -2.0547   -2.0578   -2.0610   -2.0643   -2.0671   -2.0707   -2.0733   -2.0757   -2.0789   -2.0818   -2.0850   -2.0877   -2.0908   -2.0931   -2.0961   -2.0988   -2.1020   -2.1051   -2.1076   -2.1109   -2.1146   -2.1180   -2.1204   -2.1233   -2.1264   -2.1288   -2.1322   -2.1350   -2.1383   -2.1416   -2.1450   -2.1478   -2.1505   -2.1532   -2.1564   -2.1597   -2.1627   -2.1657   -2.1684   -2.1707   -2.1733   -2.1752   -2.1784   -2.1815   -2.1838   -2.1864   -2.1892   -2.1927   -2.1963   -2.2002   -2.2025   -2.2055   -2.2089   -2.2116   -2.2146   -2.2173   -2.2197   -2.2223   -2.2251   -2.2277   -2.2315   -2.2347   -2.2371   -2.2385   -2.2412   -2.2450   -2.2475   -2.2501
 -1.6125   -1.6169   -1.6208   -1.6233   -1.6268   -1.6291   -1.6323   -1.6348   -1.6377   -1.6401   -1.6432   -1.6477   -1.6519   -1.6555   -1.6595   -1.6626   -1.6660   -1.6699   -1.6737   -1.6776   -1.6805   -1.6840   -1.6872   -1.6904   -1.6943   -1.6977   -1.7011   -1.7042   -1.7074   -1.7112   -1.7145   -1.7186   -1.7226   -1.7258   -1.7288   -1.7324   -1.7363   -1.7397   -1.7430   -1.7465   -1.7509   -1.7543   -1.7579   -1.7620   -1.7653   -1.7684   -1.7729   -1.7766   -1.7800   -1.7827   -1.7864   -1.7898   -1.7933   -1.7964   -1.8002   -1.8041   -1.8074   -1.8107   -1.8143   -1.8180   -1.8215   -1.8252   -1.8285   -1.8316   -1.8355   -1.8388   -1.8426   -1.8468   -1.8506   -1.8541   -1.8579   -1.8611   -1.8653   -1.8697   -1.8734   -1.8770   -1.8801   -1.8829   -1.8868   -1.8895   -1.8926   -1.8955   -1.8984   -1.9021   -1.9055   -1.9096   -1.9127   -1.9167   -1.9204   -1.9244   -1.9282   -1.9316   -1.9350   -1.9384   -1.9420   -1.9449   -1.9478   -1.9516   -1.9545   -1.9574   -1.9608   -1.9640   -1.9679   -1.9711   -1.9741   -1.9770   -1.9807   -1.9844   -1.9878   -1.9914   -1.9950   -1.9979   -2.0014   -2.0052   -2.0085   -2.0119   -2.0151   -2.0184   -2.0214   -2.0248   -2.0279   -2.0314   -2.0352   -2.0394   -2.0424   -2.0454   -2.0486   -2.0519   -2.0552   -2.0588   -2.0620   -2.0651   -2.0687   -2.0718   -2.0752   -2.0790   -2.0819   -2.0854   -2.0883   -2.0916   -2.0946   -2.0982   -2.1017   -2.1053   -2.1086   -2.1119   -2.1153   -2.1188   -2.1227   -2.1261   -2.1295   -2.1330   -2.1358   -2.1389   -2.1427   -2.1459   -2.1495   -2.1530   -2.1562   -2.1595   -2.1623   -2.1659   -2.1692   -2.1715   -2.1745   -2.1779   -2.1812   -2.1848   -2.1875   -2.1909   -2.1943   -2.1982   -2.2011   -2.2041   -2.2076   -2.2111   -2.2140   -2.2173   -2.2201   -2.2227   -2.2261   -2.2301   -2.2327   -2.2359   -2.2382   -2.2411   -2.2439   -2.2462   -2.2493   -2.2516   -2.2540   -2.2570   -2.2600   -2.2633   -2.2662   -2.2691   -2.2733   -2.2769   -2.2819
 -1.5729   -1.5758   -1.5803   -1.5849   -1.5894   -1.5930   -1.5971   -1.6018   -1.6055   -1.6098   -1.6145   -1.6181   -1.6219   -1.6267   -1.6309   -1.6350   -1.6384   -1.6428   -1.6467   -1.6504   -1.6541   -1.6583   -1.6615   -1.6657   -1.6696   -1.6729   -1.6769   -1.6805   -1.6843   -1.6884   -1.6924   -1.6961   -1.7001   -1.7045   -1.7084   -1.7117   -1.7151   -1.7193   -1.7229   -1.7263   -1.7298   -1.7343   -1.7383   -1.7418   -1.7459   -1.7499   -1.7536   -1.7573   -1.7616   -1.7662   -1.7701   -1.7739   -1.7777   -1.7815   -1.7856   -1.7894   -1.7934   -1.7970   -1.8009   -1.8044   -1.8090   -1.8135   -1.8176   -1.8218   -1.8251   -1.8288   -1.8323   -1.8364   -1.8400   -1.8440   -1.8480   -1.8524   -1.8564   -1.8602   -1.8637   -1.8676   -1.8714   -1.8752   -1.8789   -1.8828   -1.8867   -1.8905   -1.8944   -1.8979   -1.9023   -1.9060   -1.9101   -1.9141   -1.9179   -1.9217   -1.9251   -1.9292   -1.9330   -1.9369   -1.9402   -1.9438   -1.9470   -1.9507   -1.9541   -1.9574   -1.9611   -1.9648   -1.9689   -1.9724   -1.9755   -1.9794   -1.9843   -1.9884   -1.9918   -1.9953   -1.9991   -2.0025   -2.0065   -2.0102   -2.0139   -2.0181   -2.0213   -2.0253   -2.0290   -2.0325   -2.0360   -2.0404   -2.0442   -2.0479   -2.0508   -2.0552   -2.0589   -2.0621   -2.0654   -2.0684   -2.0718   -2.0756   -2.0793   -2.0826   -2.0861   -2.0897   -2.0939   -2.0972   -2.1007   -2.1045   -2.1089   -2.1128   -2.1166   -2.1202   -2.1242   -2.1272   -2.1308   -2.1343   -2.1381   -2.1416   -2.1451   -2.1478   -2.1521   -2.1557   -2.1592   -2.1633   -2.1672   -2.1709   -2.1746   -2.1781   -2.1813   -2.1847   -2.1883   -2.1923   -2.1961   -2.1997   -2.2033   -2.2062   -2.2097   -2.2137   -2.2170   -2.2206   -2.2233   -2.2272   -2.2303   -2.2339   -2.2375   -2.2409   -2.2438   -2.2477   -2.2507   -2.2546   -2.2576   -2.2608   -2.2645   -2.2674   -2.2702   -2.2736   -2.2772   -2.2807   -2.2838   -2.2870   -2.2905   -2.2934   -2.2956   -2.2983   -2.3015   -2.3038   -2.3075
 -1.5387   -1.5432   -1.5467   -1.5510   -1.5553   -1.5590   -1.5635   -1.5680   -1.5719   -1.5772   -1.5821   -1.5866   -1.5910   -1.5952   -1.5997   -1.6049   -1.6097   -1.6142   -1.6183   -1.6224   -1.6264   -1.6308   -1.6349   -1.6397   -1.6439   -1.6477   -1.6519   -1.6562   -1.6603   -1.6643   -1.6686   -1.6729   -1.6770   -1.6814   -1.6853   -1.6893   -1.6938   -1.6975   -1.7020   -1.7062   -1.7101   -1.7150   -1.7189   -1.7226   -1.7268   -1.7310   -1.7359   -1.7397   -1.7441   -1.7480   -1.7519   -1.7573   -1.7620   -1.7666   -1.7712   -1.7752   -1.7793   -1.7833   -1.7878   -1.7920   -1.7959   -1.8001   -1.8044   -1.8087   -1.8133   -1.8170   -1.8216   -1.8261   -1.8303   -1.8346   -1.8383   -1.8428   -1.8474   -1.8516   -1.8562   -1.8601   -1.8644   -1.8686   -1.8726   -1.8766   -1.8805   -1.8853   -1.8893   -1.8933   -1.8980   -1.9015   -1.9054   -1.9095   -1.9135   -1.9178   -1.9220   -1.9261   -1.9305   -1.9344   -1.9386   -1.9423   -1.9463   -1.9503   -1.9538   -1.9574   -1.9613   -1.9657   -1.9695   -1.9737   -1.9776   -1.9812   -1.9851   -1.9892   -1.9939   -1.9979   -2.0019   -2.0058   -2.0096   -2.0134   -2.0175   -2.0217   -2.0260   -2.0299   -2.0340   -2.0379   -2.0422   -2.0458   -2.0496   -2.0539   -2.0576   -2.0622   -2.0665   -2.0703   -2.0737   -2.0781   -2.0820   -2.0854   -2.0895   -2.0932   -2.0971   -2.1011   -2.1051   -2.1087   -2.1125   -2.1164   -2.1199   -2.1241   -2.1279   -2.1315   -2.1356   -2.1395   -2.1438   -2.1476   -2.1511   -2.1544   -2.1584   -2.1633   -2.1672   -2.1712   -2.1758   -2.1793   -2.1838   -2.1865   -2.1900   -2.1942   -2.1984   -2.2022   -2.2067   -2.2109   -2.2151   -2.2189   -2.2228   -2.2262   -2.2309   -2.2348   -2.2388   -2.2428   -2.2470   -2.2507   -2.2536   -2.2574   -2.2609   -2.2640   -2.2679   -2.2711   -2.2746   -2.2789   -2.2821   -2.2862   -2.2902   -2.2922   -2.2973   -2.3006   -2.3040   -2.3073   -2.3112   -2.3146   -2.3189   -2.3219   -2.3254   -2.3282   -2.3316   -2.3342   -2.3376
 -1.5037   -1.5080   -1.5125   -1.5164   -1.5205   -1.5265   -1.5313   -1.5361   -1.5416   -1.5462   -1.5514   -1.5558   -1.5614   -1.5667   -1.5717   -1.5771   -1.5821   -1.5864   -1.5908   -1.5955   -1.5998   -1.6033   -1.6075   -1.6120   -1.6163   -1.6207   -1.6256   -1.6307   -1.6349   -1.6395   -1.6436   -1.6479   -1.6528   -1.6568   -1.6622   -1.6661   -1.6714   -1.6758   -1.6804   -1.6848   -1.6897   -1.6944   -1.6993   -1.7043   -1.7090   -1.7133   -1.7184   -1.7233   -1.7270   -1.7320   -1.7372   -1.7423   -1.7463   -1.7506   -1.7558   -1.7602   -1.7653   -1.7697   -1.7747   -1.7795   -1.7839   -1.7886   -1.7931   -1.7980   -1.8028   -1.8072   -1.8117   -1.8162   -1.8205   -1.8254   -1.8300   -1.8340   -1.8381   -1.8426   -1.8470   -1.8518   -1.8563   -1.8607   -1.8651   -1.8701   -1.8745   -1.8791   -1.8840   -1.8887   -1.8932   -1.8975   -1.9016   -1.9061   -1.9100   -1.9147   -1.9191   -1.9235   -1.9276   -1.9316   -1.9364   -1.9408   -1.9451   -1.9494   -1.9532   -1.9574   -1.9616   -1.9661   -1.9703   -1.9749   -1.9797   -1.9836   -1.9878   -1.9920   -1.9961   -2.0006   -2.0046   -2.0092   -2.0137   -2.0181   -2.0225   -2.0268   -2.0319   -2.0360   -2.0406   -2.0447   -2.0492   -2.0529   -2.0576   -2.0618   -2.0660   -2.0706   -2.0743   -2.0786   -2.0830   -2.0869   -2.0908   -2.0948   -2.0987   -2.1027   -2.1067   -2.1106   -2.1152   -2.1194   -2.1229   -2.1275   -2.1318   -2.1362   -2.1413   -2.1458   -2.1504   -2.1540   -2.1579   -2.1620   -2.1657   -2.1705   -2.1750   -2.1793   -2.1835   -2.1878   -2.1914   -2.1950   -2.1994   -2.2031   -2.2078   -2.2119   -2.2166   -2.2212   -2.2253   -2.2291   -2.2329   -2.2367   -2.2404   -2.2451   -2.2490   -2.2532   -2.2574   -2.2621   -2.2665   -2.2707   -2.2743   -2.2778   -2.2818   -2.2855   -2.2893   -2.2930   -2.2961   -2.3008   -2.3054   -2.3092   -2.3129   -2.3167   -2.3193   -2.3219   -2.3254   -2.3285   -2.3319   -2.3354   -2.3392   -2.3433   -2.3472   -2.3521   -2.3558   -2.3611   -2.3645
 -1.4721   -1.4772   -1.4831   -1.4878   -1.4922   -1.4956   -1.4996   -1.5046   -1.5099   -1.5148   -1.5215   -1.5259   -1.5304   -1.5354   -1.5402   -1.5462   -1.5507   -1.5559   -1.5602   -1.5656   -1.5704   -1.5755   -1.5808   -1.5858   -1.5915   -1.5966   -1.6013   -1.6064   -1.6118   -1.6164   -1.6208   -1.6261   -1.6317   -1.6364   -1.6418   -1.6468   -1.6511   -1.6559   -1.6614   -1.6670   -1.6719   -1.6767   -1.6822   -1.6870   -1.6918   -1.6970   -1.7017   -1.7060   -1.7118   -1.7166   -1.7214   -1.7262   -1.7309   -1.7358   -1.7411   -1.7460   -1.7511   -1.7565   -1.7616   -1.7663   -1.7717   -1.7772   -1.7824   -1.7869   -1.7922   -1.7966   -1.8014   -1.8059   -1.8110   -1.8158   -1.8208   -1.8251   -1.8305   -1.8352   -1.8397   -1.8443   -1.8485   -1.8535   -1.8585   -1.8636   -1.8681   -1.8729   -1.8780   -1.8829   -1.8880   -1.8931   -1.8975   -1.9024   -1.9069   -1.9116   -1.9156   -1.9207   -1.9249   -1.9297   -1.9347   -1.9395   -1.9444   -1.9488   -1.9531   -1.9574   -1.9615   -1.9669   -1.9717   -1.9762   -1.9801   -1.9846   -1.9886   -1.9938   -1.9982   -2.0033   -2.0077   -2.0122   -2.0173   -2.0223   -2.0271   -2.0317   -2.0364   -2.0406   -2.0451   -2.0498   -2.0551   -2.0589   -2.0639   -2.0682   -2.0734   -2.0781   -2.0823   -2.0868   -2.0916   -2.0960   -2.1005   -2.1046   -2.1087   -2.1134   -2.1178   -2.1224   -2.1276   -2.1324   -2.1364   -2.1407   -2.1452   -2.1491   -2.1539   -2.1582   -2.1628   -2.1678   -2.1722   -2.1762   -2.1804   -2.1847   -2.1890   -2.1935   -2.1974   -2.2018   -2.2060   -2.2099   -2.2150   -2.2196   -2.2243   -2.2283   -2.2320   -2.2359   -2.2401   -2.2447   -2.2488   -2.2528   -2.2569   -2.2617   -2.2659   -2.2700   -2.2737   -2.2785   -2.2822   -2.2862   -2.2902   -2.2940   -2.2983   -2.3031   -2.3077   -2.3124   -2.3167   -2.3203   -2.3244   -2.3289   -2.3326   -2.3360   -2.3399   -2.3441   -2.3492   -2.3538   -2.3572   -2.3610   -2.3651   -2.3691   -2.3718   -2.3763   -2.3811   -2.3835   -2.3877
 -1.4402   -1.4453   -1.4496   -1.4547   -1.4612   -1.4664   -1.4722   -1.4769   -1.4823   -1.4864   -1.4930   -1.4986   -1.5028   -1.5083   -1.5140   -1.5187   -1.5238   -1.5299   -1.5352   -1.5407   -1.5451   -1.5507   -1.5563   -1.5621   -1.5668   -1.5719   -1.5781   -1.5829   -1.5890   -1.5943   -1.6002   -1.6057   -1.6115   -1.6174   -1.6230   -1.6283   -1.6336   -1.6390   -1.6444   -1.6497   -1.6551   -1.6604   -1.6657   -1.6712   -1.6768   -1.6825   -1.6873   -1.6927   -1.6981   -1.7041   -1.7095   -1.7147   -1.7201   -1.7258   -1.7314   -1.7367   -1.7420   -1.7473   -1.7527   -1.7575   -1.7624   -1.7675   -1.7729   -1.7778   -1.7820   -1.7875   -1.7929   -1.7982   -1.8036   -1.8088   -1.8140   -1.8197   -1.8249   -1.8296   -1.8339   -1.8389   -1.8437   -1.8488   -1.8535   -1.8593   -1.8637   -1.8685   -1.8739   -1.8786   -1.8834   -1.8887   -1.8945   -1.8991   -1.9039   -1.9088   -1.9137   -1.9184   -1.9235   -1.9285   -1.9328   -1.9382   -1.9431   -1.9482   -1.9527   -1.9574   -1.9622   -1.9673   -1.9719   -1.9767   -1.9814   -1.9863   -1.9915   -1.9960   -2.0006   -2.0054   -2.0107   -2.0159   -2.0211   -2.0261   -2.0312   -2.0362   -2.0418   -2.0467   -2.0514   -2.0568   -2.0612   -2.0655   -2.0705   -2.0751   -2.0797   -2.0843   -2.0892   -2.0939   -2.0985   -2.1033   -2.1080   -2.1137   -2.1186   -2.1229   -2.1277   -2.1323   -2.1367   -2.1414   -2.1461   -2.1509   -2.1559   -2.1607   -2.1653   -2.1707   -2.1750   -2.1795   -2.1833   -2.1878   -2.1917   -2.1959   -2.2004   -2.2054   -2.2110   -2.2158   -2.2195   -2.2236   -2.2272   -2.2316   -2.2361   -2.2409   -2.2457   -2.2498   -2.2540   -2.2592   -2.2640   -2.2685   -2.2731   -2.2779   -2.2827   -2.2869   -2.2918   -2.2956   -2.2995   -2.3041   -2.3081   -2.3119   -2.3161   -2.3203   -2.3253   -2.3298   -2.3340   -2.3379   -2.3422   -2.3465   -2.3500   -2.3538   -2.3582   -2.3626   -2.3670   -2.3713   -2.3751   -2.3796   -2.3833   -2.3885   -2.3927   -2.3976   -2.4023   -2.4080   -2.4126
 -1.4105   -1.4166   -1.4222   -1.4280   -1.4342   -1.4398   -1.4454   -1.4518   -1.4584   -1.4627   -1.4675   -1.4729   -1.4787   -1.4849   -1.4904   -1.4957   -1.5015   -1.5074   -1.5127   -1.5189   -1.5244   -1.5305   -1.5358   -1.5407   -1.5466   -1.5520   -1.5578   -1.5639   -1.5694   -1.5754   -1.5815   -1.5874   -1.5924   -1.5984   -1.6041   -1.6101   -1.6159   -1.6216   -1.6275   -1.6338   -1.6394   -1.6453   -1.6514   -1.6574   -1.6630   -1.6683   -1.6740   -1.6796   -1.6850   -1.6900   -1.6958   -1.7011   -1.7066   -1.7119   -1.7171   -1.7223   -1.7280   -1.7337   -1.7395   -1.7451   -1.7511   -1.7564   -1.7624   -1.7677   -1.7729   -1.7779   -1.7834   -1.7897   -1.7948   -1.8005   -1.8058   -1.8115   -1.8170   -1.8226   -1.8279   -1.8332   -1.8382   -1.8433   -1.8486   -1.8537   -1.8591   -1.8642   -1.8691   -1.8740   -1.8789   -1.8837   -1.8893   -1.8955   -1.9007   -1.9059   -1.9115   -1.9167   -1.9210   -1.9265   -1.9317   -1.9370   -1.9418   -1.9470   -1.9523   -1.9574   -1.9622   -1.9675   -1.9726   -1.9781   -1.9827   -1.9878   -1.9935   -1.9985   -2.0038   -2.0089   -2.0141   -2.0198   -2.0253   -2.0301   -2.0355   -2.0407   -2.0461   -2.0510   -2.0563   -2.0613   -2.0669   -2.0722   -2.0774   -2.0820   -2.0867   -2.0912   -2.0963   -2.1005   -2.1053   -2.1103   -2.1156   -2.1201   -2.1254   -2.1302   -2.1351   -2.1401   -2.1461   -2.1514   -2.1563   -2.1611   -2.1657   -2.1706   -2.1755   -2.1803   -2.1854   -2.1896   -2.1944   -2.1990   -2.2029   -2.2077   -2.2127   -2.2175   -2.2214   -2.2266   -2.2313   -2.2366   -2.2415   -2.2461   -2.2514   -2.2555   -2.2597   -2.2639   -2.2686   -2.2732   -2.2772   -2.2822   -2.2868   -2.2912   -2.2959   -2.3005   -2.3052   -2.3098   -2.3143   -2.3189   -2.3238   -2.3280   -2.3327   -2.3370   -2.3412   -2.3461   -2.3511   -2.3555   -2.3594   -2.3633   -2.3679   -2.3723   -2.3756   -2.3802   -2.3846   -2.3886   -2.3943   -2.3987   -2.4037   -2.4085   -2.4132   -2.4182   -2.4218   -2.4264   -2.4303
 -1.3783   -1.3864   -1.3929   -1.3996   -1.4053   -1.4117   -1.4178   -1.4242   -1.4302   -1.4372   -1.4432   -1.4484   -1.4544   -1.4597   -1.4638   -1.4701   -1.4764   -1.4821   -1.4882   -1.4941   -1.5006   -1.5069   -1.5135   -1.5190   -1.5249   -1.5301   -1.5369   -1.5430   -1.5488   -1.5550   -1.5605   -1.5665   -1.5729   -1.5794   -1.5856   -1.5922   -1.5983   -1.6035   -1.6097   -1.6161   -1.6215   -1.6280   -1.6338   -1.6394   -1.6454   -1.6512   -1.6578   -1.6636   -1.6694   -1.6757   -1.6822   -1.6878   -1.6937   -1.6994   -1.7053   -1.7116   -1.7168   -1.7234   -1.7289   -1.7347   -1.7399   -1.7459   -1.7512   -1.7567   -1.7627   -1.7682   -1.7742   -1.7798   -1.7862   -1.7924   -1.7979   -1.8029   -1.8080   -1.8142   -1.8200   -1.8256   -1.8312   -1.8368   -1.8420   -1.8474   -1.8529   -1.8589   -1.8644   -1.8699   -1.8752   -1.8806   -1.8862   -1.8920   -1.8980   -1.9031   -1.9087   -1.9141   -1.9197   -1.9256   -1.9314   -1.9365   -1.9415   -1.9468   -1.9524   -1.9574   -1.9629   -1.9680   -1.9736   -1.9789   -1.9847   -1.9898   -1.9949   -2.0007   -2.0060   -2.0114   -2.0161   -2.0222   -2.0277   -2.0331   -2.0387   -2.0438   -2.0487   -2.0543   -2.0597   -2.0659   -2.0711   -2.0763   -2.0819   -2.0871   -2.0919   -2.0979   -2.1033   -2.1084   -2.1130   -2.1183   -2.1235   -2.1288   -2.1340   -2.1390   -2.1441   -2.1492   -2.1551   -2.1602   -2.1648   -2.1699   -2.1755   -2.1808   -2.1856   -2.1906   -2.1958   -2.2006   -2.2065   -2.2110   -2.2157   -2.2203   -2.2258   -2.2306   -2.2354   -2.2401   -2.2450   -2.2504   -2.2552   -2.2603   -2.2650   -2.2703   -2.2750   -2.2797   -2.2846   -2.2902   -2.2954   -2.3002   -2.3052   -2.3098   -2.3145   -2.3188   -2.3230   -2.3275   -2.3319   -2.3364   -2.3408   -2.3454   -2.3495   -2.3545   -2.3593   -2.3633   -2.3686   -2.3726   -2.3769   -2.3817   -2.3861   -2.3907   -2.3948   -2.3995   -2.4034   -2.4079   -2.4127   -2.4186   -2.4220   -2.4266   -2.4320   -2.4370   -2.4403   -2.4445   -2.4475
 -1.3483   -1.3555   -1.3625   -1.3685   -1.3754   -1.3819   -1.3879   -1.3936   -1.3999   -1.4064   -1.4127   -1.4191   -1.4254   -1.4323   -1.4386   -1.4450   -1.4514   -1.4577   -1.4646   -1.4708   -1.4766   -1.4828   -1.4899   -1.4964   -1.5027   -1.5095   -1.5159   -1.5227   -1.5297   -1.5358   -1.5426   -1.5490   -1.5549   -1.5614   -1.5679   -1.5736   -1.5797   -1.5865   -1.5922   -1.5984   -1.6049   -1.6118   -1.6183   -1.6242   -1.6305   -1.6370   -1.6431   -1.6493   -1.6556   -1.6617   -1.6676   -1.6736   -1.6793   -1.6853   -1.6919   -1.6975   -1.7038   -1.7095   -1.7158   -1.7219   -1.7280   -1.7346   -1.7410   -1.7467   -1.7529   -1.7586   -1.7647   -1.7704   -1.7763   -1.7825   -1.7884   -1.7945   -1.8003   -1.8060   -1.8120   -1.8180   -1.8237   -1.8297   -1.8352   -1.8410   -1.8472   -1.8527   -1.8584   -1.8642   -1.8701   -1.8761   -1.8826   -1.8884   -1.8948   -1.9004   -1.9058   -1.9117   -1.9175   -1.9235   -1.9293   -1.9347   -1.9404   -1.9463   -1.9519   -1.9574   -1.9634   -1.9690   -1.9745   -1.9804   -1.9862   -1.9917   -1.9974   -2.0028   -2.0084   -2.0141   -2.0195   -2.0259   -2.0311   -2.0371   -2.0427   -2.0487   -2.0542   -2.0596   -2.0656   -2.0705   -2.0758   -2.0811   -2.0861   -2.0917   -2.0973   -2.1033   -2.1093   -2.1147   -2.1201   -2.1258   -2.1317   -2.1366   -2.1425   -2.1474   -2.1527   -2.1578   -2.1631   -2.1678   -2.1733   -2.1791   -2.1850   -2.1904   -2.1958   -2.2010   -2.2061   -2.2106   -2.2162   -2.2211   -2.2260   -2.2314   -2.2361   -2.2411   -2.2459   -2.2519   -2.2573   -2.2624   -2.2679   -2.2729   -2.2782   -2.2835   -2.2886   -2.2940   -2.2987   -2.3029   -2.3081   -2.3132   -2.3177   -2.3229   -2.3278   -2.3331   -2.3380   -2.3425   -2.3466   -2.3511   -2.3556   -2.3600   -2.3644   -2.3700   -2.3739   -2.3779   -2.3820   -2.3868   -2.3914   -2.3954   -2.3998   -2.4046   -2.4089   -2.4140   -2.4189   -2.4231   -2.4283   -2.4326   -2.4371   -2.4409   -2.4459   -2.4503   -2.4532   -2.4582   -2.4629
 -1.3214   -1.3285   -1.3345   -1.3409   -1.3486   -1.3547   -1.3611   -1.3679   -1.3744   -1.3812   -1.3872   -1.3934   -1.4006   -1.4080   -1.4148   -1.4217   -1.4276   -1.4340   -1.4406   -1.4479   -1.4546   -1.4611   -1.4683   -1.4756   -1.4829   -1.4895   -1.4962   -1.5019   -1.5082   -1.5155   -1.5219   -1.5286   -1.5361   -1.5424   -1.5493   -1.5562   -1.5633   -1.5699   -1.5761   -1.5827   -1.5897   -1.5967   -1.6030   -1.6093   -1.6155   -1.6217   -1.6279   -1.6344   -1.6409   -1.6470   -1.6538   -1.6604   -1.6668   -1.6736   -1.6800   -1.6867   -1.6930   -1.6995   -1.7054   -1.7119   -1.7176   -1.7245   -1.7306   -1.7370   -1.7432   -1.7500   -1.7564   -1.7630   -1.7697   -1.7758   -1.7818   -1.7879   -1.7944   -1.8000   -1.8067   -1.8122   -1.8185   -1.8245   -1.8299   -1.8360   -1.8419   -1.8478   -1.8549   -1.8609   -1.8670   -1.8731   -1.8790   -1.8855   -1.8919   -1.8979   -1.9039   -1.9105   -1.9166   -1.9228   -1.9288   -1.9342   -1.9399   -1.9458   -1.9515   -1.9574   -1.9635   -1.9691   -1.9757   -1.9813   -1.9875   -1.9930   -1.9986   -2.0050   -2.0109   -2.0177   -2.0233   -2.0296   -2.0355   -2.0414   -2.0467   -2.0519   -2.0574   -2.0634   -2.0685   -2.0749   -2.0809   -2.0864   -2.0926   -2.0985   -2.1043   -2.1105   -2.1157   -2.1210   -2.1260   -2.1314   -2.1368   -2.1424   -2.1482   -2.1538   -2.1593   -2.1646   -2.1699   -2.1756   -2.1804   -2.1865   -2.1920   -2.1970   -2.2018   -2.2075   -2.2125   -2.2178   -2.2237   -2.2294   -2.2345   -2.2396   -2.2452   -2.2504   -2.2560   -2.2609   -2.2661   -2.2712   -2.2759   -2.2809   -2.2861   -2.2912   -2.2969   -2.3021   -2.3079   -2.3139   -2.3193   -2.3247   -2.3302   -2.3351   -2.3404   -2.3454   -2.3505   -2.3548   -2.3596   -2.3647   -2.3707   -2.3753   -2.3797   -2.3849   -2.3900   -2.3941   -2.3987   -2.4037   -2.4097   -2.4142   -2.4194   -2.4236   -2.4282   -2.4330   -2.4383   -2.4437   -2.4483   -2.4527   -2.4573   -2.4611   -2.4665   -2.4717   -2.4761   -2.4808   -2.4851
 -1.2939   -1.3011   -1.3087   -1.3168   -1.3236   -1.3307   -1.3375   -1.3453   -1.3512   -1.3581   -1.3648   -1.3718   -1.3790   -1.3861   -1.3931   -1.4002   -1.4073   -1.4141   -1.4204   -1.4269   -1.4341   -1.4417   -1.4488   -1.4556   -1.4627   -1.4689   -1.4750   -1.4820   -1.4891   -1.4961   -1.5029   -1.5103   -1.5173   -1.5243   -1.5318   -1.5388   -1.5455   -1.5520   -1.5594   -1.5660   -1.5734   -1.5805   -1.5875   -1.5947   -1.6024   -1.6098   -1.6166   -1.6235   -1.6300   -1.6365   -1.6421   -1.6486   -1.6551   -1.6614   -1.6681   -1.6749   -1.6815   -1.6879   -1.6944   -1.7015   -1.7084   -1.7151   -1.7219   -1.7285   -1.7355   -1.7415   -1.7481   -1.7544   -1.7617   -1.7679   -1.7746   -1.7811   -1.7874   -1.7938   -1.8005   -1.8071   -1.8131   -1.8196   -1.8257   -1.8315   -1.8380   -1.8446   -1.8505   -1.8577   -1.8642   -1.8704   -1.8770   -1.8838   -1.8903   -1.8967   -1.9028   -1.9086   -1.9151   -1.9220   -1.9278   -1.9336   -1.9396   -1.9454   -1.9513   -1.9574   -1.9638   -1.9699   -1.9761   -1.9824   -1.9881   -1.9942   -2.0008   -2.0069   -2.0131   -2.0195   -2.0253   -2.0317   -2.0373   -2.0434   -2.0496   -2.0556   -2.0615   -2.0679   -2.0729   -2.0788   -2.0845   -2.0910   -2.0972   -2.1028   -2.1084   -2.1137   -2.1196   -2.1248   -2.1305   -2.1365   -2.1411   -2.1474   -2.1533   -2.1593   -2.1647   -2.1709   -2.1765   -2.1816   -2.1874   -2.1928   -2.1995   -2.2051   -2.2105   -2.2160   -2.2216   -2.2278   -2.2334   -2.2393   -2.2443   -2.2496   -2.2552   -2.2608   -2.2663   -2.2716   -2.2770   -2.2823   -2.2876   -2.2927   -2.2985   -2.3044   -2.3093   -2.3142   -2.3197   -2.3253   -2.3312   -2.3369   -2.3425   -2.3472   -2.3528   -2.3584   -2.3632   -2.3681   -2.3738   -2.3789   -2.3840   -2.3893   -2.3941   -2.3979   -2.4032   -2.4082   -2.4127   -2.4171   -2.4229   -2.4283   -2.4327   -2.4376   -2.4422   -2.4473   -2.4523   -2.4566   -2.4616   -2.4664   -2.4724   -2.4765   -2.4816   -2.4860   -2.4895   -2.4946   -2.4999
 -1.2648   -1.2722   -1.2807   -1.2888   -1.2965   -1.3035   -1.3103   -1.3182   -1.3255   -1.3335   -1.3405   -1.3485   -1.3563   -1.3627   -1.3701   -1.3771   -1.3851   -1.3925   -1.3994   -1.4068   -1.4148   -1.4214   -1.4288   -1.4356   -1.4418   -1.4496   -1.4575   -1.4651   -1.4725   -1.4793   -1.4870   -1.4940   -1.5017   -1.5080   -1.5160   -1.5236   -1.5308   -1.5378   -1.5454   -1.5525   -1.5597   -1.5678   -1.5746   -1.5817   -1.5894   -1.5968   -1.6033   -1.6104   -1.6173   -1.6245   -1.6307   -1.6375   -1.6448   -1.6512   -1.6587   -1.6651   -1.6720   -1.6790   -1.6852   -1.6918   -1.6979   -1.7049   -1.7121   -1.7190   -1.7261   -1.7335   -1.7407   -1.7475   -1.7543   -1.7614   -1.7683   -1.7751   -1.7819   -1.7884   -1.7949   -1.8013   -1.8079   -1.8145   -1.8208   -1.8274   -1.8341   -1.8401   -1.8474   -1.8540   -1.8609   -1.8672   -1.8740   -1.8798   -1.8868   -1.8933   -1.8995   -1.9062   -1.9127   -1.9194   -1.9260   -1.9321   -1.9380   -1.9444   -1.9513   -1.9574   -1.9643   -1.9700   -1.9770   -1.9833   -1.9893   -1.9955   -2.0015   -2.0087   -2.0145   -2.0210   -2.0276   -2.0338   -2.0396   -2.0457   -2.0518   -2.0577   -2.0641   -2.0706   -2.0771   -2.0832   -2.0894   -2.0957   -2.1013   -2.1078   -2.1139   -2.1203   -2.1266   -2.1320   -2.1381   -2.1446   -2.1501   -2.1560   -2.1617   -2.1680   -2.1738   -2.1796   -2.1859   -2.1916   -2.1982   -2.2041   -2.2101   -2.2161   -2.2218   -2.2272   -2.2330   -2.2387   -2.2444   -2.2494   -2.2560   -2.2618   -2.2677   -2.2729   -2.2782   -2.2836   -2.2897   -2.2953   -2.3004   -2.3059   -2.3113   -2.3168   -2.3215   -2.3265   -2.3311   -2.3361   -2.3418   -2.3467   -2.3518   -2.3570   -2.3631   -2.3688   -2.3736   -2.3785   -2.3838   -2.3891   -2.3949   -2.3996   -2.4048   -2.4095   -2.4142   -2.4197   -2.4248   -2.4302   -2.4348   -2.4399   -2.4454   -2.4502   -2.4557   -2.4608   -2.4662   -2.4719   -2.4763   -2.4802   -2.4844   -2.4890   -2.4945   -2.4992   -2.5044   -2.5105   -2.5146
 -1.2402   -1.2477   -1.2551   -1.2633   -1.2712   -1.2790   -1.2866   -1.2942   -1.3018   -1.3089   -1.3158   -1.3237   -1.3300   -1.3379   -1.3456   -1.3523   -1.3600   -1.3677   -1.3750   -1.3822   -1.3899   -1.3975   -1.4054   -1.4140   -1.4215   -1.4285   -1.4359   -1.4438   -1.4519   -1.4596   -1.4670   -1.4745   -1.4827   -1.4911   -1.4986   -1.5060   -1.5133   -1.5209   -1.5281   -1.5360   -1.5438   -1.5513   -1.5588   -1.5664   -1.5737   -1.5812   -1.5884   -1.5960   -1.6034   -1.6112   -1.6189   -1.6257   -1.6329   -1.6394   -1.6464   -1.6530   -1.6601   -1.6672   -1.6741   -1.6815   -1.6889   -1.6961   -1.7034   -1.7101   -1.7176   -1.7249   -1.7317   -1.7391   -1.7458   -1.7530   -1.7603   -1.7677   -1.7747   -1.7822   -1.7893   -1.7968   -1.8040   -1.8109   -1.8177   -1.8246   -1.8305   -1.8371   -1.8439   -1.8506   -1.8574   -1.8641   -1.8706   -1.8771   -1.8840   -1.8914   -1.8983   -1.9051   -1.9120   -1.9182   -1.9253   -1.9318   -1.9381   -1.9446   -1.9513   -1.9574   -1.9643   -1.9701   -1.9769   -1.9838   -1.9901   -1.9964   -2.0033   -2.0101   -2.0171   -2.0231   -2.0296   -2.0355   -2.0423   -2.0483   -2.0549   -2.0612   -2.0679   -2.0747   -2.0807   -2.0873   -2.0938   -2.0999   -2.1056   -2.1128   -2.1190   -2.1251   -2.1317   -2.1380   -2.1443   -2.1505   -2.1565   -2.1634   -2.1703   -2.1765   -2.1824   -2.1883   -2.1946   -2.2002   -2.2061   -2.2123   -2.2185   -2.2243   -2.2298   -2.2361   -2.2425   -2.2477   -2.2533   -2.2587   -2.2647   -2.2706   -2.2755   -2.2819   -2.2876   -2.2932   -2.2981   -2.3039   -2.3097   -2.3155   -2.3206   -2.3262   -2.3315   -2.3368   -2.3423   -2.3483   -2.3537   -2.3591   -2.3648   -2.3703   -2.3754   -2.3808   -2.3857   -2.3908   -2.3968   -2.4022   -2.4074   -2.4124   -2.4177   -2.4234   -2.4287   -2.4347   -2.4397   -2.4449   -2.4506   -2.4559   -2.4602   -2.4655   -2.4689   -2.4740   -2.4780   -2.4821   -2.4865   -2.4928   -2.4975   -2.5031   -2.5083   -2.5137   -2.5180   -2.5223   -2.5269
 -1.2131   -1.2215   -1.2288   -1.2361   -1.2450   -1.2531   -1.2608   -1.2689   -1.2777   -1.2857   -1.2931   -1.3010   -1.3084   -1.3159   -1.3246   -1.3323   -1.3396   -1.3478   -1.3561   -1.3638   -1.3712   -1.3791   -1.3868   -1.3945   -1.4024   -1.4101   -1.4177   -1.4258   -1.4338   -1.4419   -1.4497   -1.4568   -1.4650   -1.4722   -1.4803   -1.4886   -1.4970   -1.5051   -1.5130   -1.5211   -1.5292   -1.5368   -1.5450   -1.5521   -1.5601   -1.5677   -1.5759   -1.5833   -1.5912   -1.5989   -1.6065   -1.6134   -1.6210   -1.6281   -1.6354   -1.6426   -1.6500   -1.6580   -1.6652   -1.6724   -1.6794   -1.6870   -1.6947   -1.7018   -1.7096   -1.7168   -1.7240   -1.7321   -1.7395   -1.7466   -1.7539   -1.7612   -1.7688   -1.7762   -1.7836   -1.7903   -1.7973   -1.8052   -1.8126   -1.8195   -1.8262   -1.8328   -1.8395   -1.8467   -1.8536   -1.8604   -1.8679   -1.8744   -1.8816   -1.8893   -1.8956   -1.9034   -1.9100   -1.9172   -1.9243   -1.9307   -1.9372   -1.9441   -1.9510   -1.9574   -1.9645   -1.9706   -1.9776   -1.9843   -1.9906   -1.9973   -2.0042   -2.0109   -2.0178   -2.0243   -2.0317   -2.0378   -2.0445   -2.0512   -2.0577   -2.0640   -2.0702   -2.0772   -2.0837   -2.0908   -2.0975   -2.1038   -2.1104   -2.1174   -2.1240   -2.1302   -2.1367   -2.1432   -2.1496   -2.1557   -2.1621   -2.1683   -2.1746   -2.1811   -2.1875   -2.1944   -2.2001   -2.2071   -2.2136   -2.2200   -2.2259   -2.2326   -2.2386   -2.2451   -2.2505   -2.2565   -2.2623   -2.2683   -2.2740   -2.2793   -2.2852   -2.2910   -2.2972   -2.3035   -2.3086   -2.3146   -2.3209   -2.3261   -2.3322   -2.3380   -2.3431   -2.3489   -2.3543   -2.3599   -2.3657   -2.3712   -2.3769   -2.3824   -2.3881   -2.3937   -2.3989   -2.4034   -2.4090   -2.4143   -2.4188   -2.4234   -2.4280   -2.4341   -2.4393   -2.4444   -2.4487   -2.4535   -2.4587   -2.4638   -2.4694   -2.4753   -2.4804   -2.4859   -2.4906   -2.4959   -2.5017   -2.5069   -2.5118   -2.5168   -2.5223   -2.5278   -2.5325   -2.5368   -2.5407
 -1.1831   -1.1924   -1.2015   -1.2103   -1.2189   -1.2266   -1.2354   -1.2446   -1.2522   -1.2607   -1.2682   -1.2767   -1.2856   -1.2945   -1.3015   -1.3094   -1.3176   -1.3251   -1.3332   -1.3417   -1.3502   -1.3587   -1.3671   -1.3759   -1.3837   -1.3919   -1.3998   -1.4078   -1.4164   -1.4254   -1.4340   -1.4421   -1.4503   -1.4586   -1.4665   -1.4745   -1.4823   -1.4905   -1.4990   -1.5064   -1.5144   -1.5227   -1.5302   -1.5373   -1.5458   -1.5534   -1.5612   -1.5699   -1.5773   -1.5847   -1.5923   -1.6002   -1.6077   -1.6158   -1.6241   -1.6318   -1.6398   -1.6472   -1.6552   -1.6629   -1.6708   -1.6786   -1.6860   -1.6934   -1.7008   -1.7093   -1.7172   -1.7249   -1.7323   -1.7403   -1.7477   -1.7553   -1.7630   -1.7703   -1.7779   -1.7844   -1.7919   -1.7992   -1.8064   -1.8147   -1.8220   -1.8291   -1.8364   -1.8432   -1.8505   -1.8585   -1.8658   -1.8725   -1.8796   -1.8865   -1.8940   -1.9012   -1.9086   -1.9157   -1.9233   -1.9300   -1.9367   -1.9438   -1.9508   -1.9574   -1.9645   -1.9711   -1.9778   -1.9848   -1.9916   -1.9986   -2.0059   -2.0130   -2.0199   -2.0272   -2.0343   -2.0412   -2.0476   -2.0546   -2.0615   -2.0679   -2.0745   -2.0815   -2.0879   -2.0949   -2.1015   -2.1081   -2.1146   -2.1216   -2.1291   -2.1353   -2.1424   -2.1492   -2.1554   -2.1620   -2.1682   -2.1744   -2.1807   -2.1870   -2.1928   -2.1990   -2.2061   -2.2123   -2.2188   -2.2254   -2.2316   -2.2375   -2.2435   -2.2494   -2.2558   -2.2623   -2.2683   -2.2745   -2.2809   -2.2867   -2.2929   -2.2984   -2.3051   -2.3117   -2.3177   -2.3238   -2.3304   -2.3368   -2.3427   -2.3483   -2.3538   -2.3594   -2.3648   -2.3705   -2.3761   -2.3820   -2.3874   -2.3925   -2.3982   -2.4043   -2.4098   -2.4143   -2.4193   -2.4245   -2.4301   -2.4349   -2.4406   -2.4458   -2.4518   -2.4562   -2.4619   -2.4675   -2.4724   -2.4776   -2.4829   -2.4884   -2.4940   -2.4992   -2.5045   -2.5093   -2.5145   -2.5196   -2.5252   -2.5303   -2.5341   -2.5382   -2.5447   -2.5491   -2.5538
 -1.1564   -1.1656   -1.1739   -1.1826   -1.1915   -1.2008   -1.2100   -1.2188   -1.2269   -1.2356   -1.2445   -1.2528   -1.2616   -1.2710   -1.2793   -1.2871   -1.2962   -1.3047   -1.3134   -1.3223   -1.3312   -1.3398   -1.3476   -1.3561   -1.3653   -1.3737   -1.3826   -1.3907   -1.3987   -1.4074   -1.4165   -1.4247   -1.4335   -1.4418   -1.4510   -1.4598   -1.4673   -1.4755   -1.4836   -1.4914   -1.4996   -1.5080   -1.5163   -1.5244   -1.5326   -1.5406   -1.5487   -1.5570   -1.5650   -1.5731   -1.5807   -1.5886   -1.5969   -1.6055   -1.6131   -1.6217   -1.6295   -1.6376   -1.6452   -1.6536   -1.6616   -1.6695   -1.6774   -1.6853   -1.6926   -1.7004   -1.7088   -1.7164   -1.7243   -1.7326   -1.7404   -1.7478   -1.7562   -1.7640   -1.7717   -1.7798   -1.7872   -1.7950   -1.8022   -1.8093   -1.8172   -1.8249   -1.8330   -1.8400   -1.8472   -1.8558   -1.8631   -1.8696   -1.8771   -1.8848   -1.8919   -1.8994   -1.9072   -1.9145   -1.9219   -1.9293   -1.9364   -1.9434   -1.9504   -1.9574   -1.9648   -1.9720   -1.9791   -1.9862   -1.9934   -2.0003   -2.0073   -2.0146   -2.0219   -2.0291   -2.0365   -2.0436   -2.0510   -2.0583   -2.0649   -2.0712   -2.0786   -2.0856   -2.0925   -2.0993   -2.1065   -2.1136   -2.1200   -2.1270   -2.1339   -2.1404   -2.1467   -2.1536   -2.1606   -2.1672   -2.1740   -2.1805   -2.1871   -2.1934   -2.1994   -2.2054   -2.2115   -2.2181   -2.2243   -2.2310   -2.2375   -2.2447   -2.2513   -2.2572   -2.2639   -2.2706   -2.2769   -2.2833   -2.2898   -2.2958   -2.3024   -2.3092   -2.3159   -2.3221   -2.3282   -2.3347   -2.3408   -2.3471   -2.3528   -2.3583   -2.3646   -2.3703   -2.3765   -2.3817   -2.3870   -2.3932   -2.3981   -2.4039   -2.4095   -2.4151   -2.4201   -2.4248   -2.4301   -2.4362   -2.4419   -2.4479   -2.4544   -2.4601   -2.4657   -2.4713   -2.4773   -2.4826   -2.4884   -2.4935   -2.4986   -2.5048   -2.5101   -2.5144   -2.5195   -2.5241   -2.5291   -2.5336   -2.5399   -2.5445   -2.5493   -2.5538   -2.5593   -2.5644   -2.5685
 -1.1343   -1.1433   -1.1528   -1.1601   -1.1687   -1.1783   -1.1866   -1.1949   -1.2045   -1.2138   -1.2216   -1.2295   -1.2380   -1.2464   -1.2561   -1.2659   -1.2744   -1.2836   -1.2917   -1.3017   -1.3107   -1.3195   -1.3281   -1.3373   -1.3462   -1.3552   -1.3643   -1.3736   -1.3825   -1.3915   -1.4007   -1.4086   -1.4169   -1.4263   -1.4346   -1.4433   -1.4521   -1.4605   -1.4694   -1.4784   -1.4874   -1.4958   -1.5050   -1.5131   -1.5210   -1.5291   -1.5372   -1.5458   -1.5546   -1.5620   -1.5708   -1.5799   -1.5886   -1.5967   -1.6053   -1.6138   -1.6218   -1.6298   -1.6378   -1.6459   -1.6543   -1.6625   -1.6696   -1.6775   -1.6855   -1.6934   -1.7016   -1.7096   -1.7169   -1.7254   -1.7329   -1.7409   -1.7493   -1.7576   -1.7653   -1.7737   -1.7817   -1.7894   -1.7978   -1.8059   -1.8140   -1.8214   -1.8289   -1.8365   -1.8444   -1.8524   -1.8602   -1.8678   -1.8755   -1.8830   -1.8907   -1.8988   -1.9061   -1.9141   -1.9219   -1.9293   -1.9366   -1.9433   -1.9504   -1.9574   -1.9651   -1.9723   -1.9799   -1.9871   -1.9946   -2.0024   -2.0096   -2.0165   -2.0241   -2.0313   -2.0385   -2.0464   -2.0530   -2.0602   -2.0674   -2.0737   -2.0808   -2.0877   -2.0951   -2.1025   -2.1094   -2.1167   -2.1234   -2.1302   -2.1379   -2.1446   -2.1515   -2.1581   -2.1652   -2.1720   -2.1790   -2.1860   -2.1928   -2.1994   -2.2061   -2.2121   -2.2189   -2.2256   -2.2316   -2.2387   -2.2451   -2.2511   -2.2577   -2.2637   -2.2702   -2.2766   -2.2833   -2.2897   -2.2962   -2.3031   -2.3096   -2.3164   -2.3228   -2.3288   -2.3348   -2.3407   -2.3460   -2.3527   -2.3583   -2.3642   -2.3696   -2.3756   -2.3819   -2.3875   -2.3939   -2.3999   -2.4052   -2.4112   -2.4175   -2.4237   -2.4293   -2.4350   -2.4411   -2.4465   -2.4513   -2.4565   -2.4625   -2.4682   -2.4731   -2.4786   -2.4848   -2.4903   -2.4963   -2.5021   -2.5083   -2.5131   -2.5181   -2.5235   -2.5273   -2.5331   -2.5380   -2.5434   -2.5484   -2.5529   -2.5590   -2.5635   -2.5692   -2.5743   -2.5798
 -1.1107   -1.1194   -1.1286   -1.1375   -1.1459   -1.1551   -1.1636   -1.1739   -1.1828   -1.1911   -1.2004   -1.2089   -1.2183   -1.2276   -1.2372   -1.2465   -1.2546   -1.2640   -1.2735   -1.2831   -1.2922   -1.3013   -1.3111   -1.3202   -1.3295   -1.3383   -1.3470   -1.3552   -1.3647   -1.3739   -1.3833   -1.3926   -1.4017   -1.4108   -1.4199   -1.4290   -1.4385   -1.4471   -1.4562   -1.4653   -1.4742   -1.4833   -1.4915   -1.5006   -1.5088   -1.5178   -1.5261   -1.5349   -1.5440   -1.5520   -1.5607   -1.5693   -1.5784   -1.5871   -1.5953   -1.6031   -1.6112   -1.6194   -1.6280   -1.6365   -1.6453   -1.6530   -1.6609   -1.6695   -1.6780   -1.6865   -1.6952   -1.7037   -1.7121   -1.7202   -1.7282   -1.7361   -1.7445   -1.7524   -1.7604   -1.7690   -1.7777   -1.7858   -1.7930   -1.8014   -1.8096   -1.8171   -1.8251   -1.8334   -1.8408   -1.8489   -1.8573   -1.8652   -1.8734   -1.8809   -1.8885   -1.8965   -1.9045   -1.9124   -1.9201   -1.9277   -1.9353   -1.9426   -1.9501   -1.9574   -1.9653   -1.9727   -1.9800   -1.9882   -1.9951   -2.0020   -2.0100   -2.0174   -2.0248   -2.0322   -2.0397   -2.0474   -2.0551   -2.0633   -2.0709   -2.0776   -2.0846   -2.0915   -2.0984   -2.1064   -2.1131   -2.1200   -2.1273   -2.1345   -2.1418   -2.1486   -2.1560   -2.1634   -2.1702   -2.1766   -2.1829   -2.1903   -2.1967   -2.2038   -2.2103   -2.2174   -2.2239   -2.2314   -2.2381   -2.2440   -2.2509   -2.2573   -2.2641   -2.2705   -2.2774   -2.2841   -2.2909   -2.2973   -2.3040   -2.3102   -2.3168   -2.3230   -2.3303   -2.3361   -2.3424   -2.3487   -2.3547   -2.3608   -2.3668   -2.3727   -2.3789   -2.3852   -2.3913   -2.3975   -2.4043   -2.4103   -2.4161   -2.4220   -2.4281   -2.4335   -2.4386   -2.4443   -2.4501   -2.4554   -2.4613   -2.4671   -2.4731   -2.4784   -2.4839   -2.4894   -2.4945   -2.4996   -2.5049   -2.5104   -2.5151   -2.5204   -2.5268   -2.5329   -2.5391   -2.5440   -2.5489   -2.5550   -2.5608   -2.5667   -2.5718   -2.5771   -2.5813   -2.5869   -2.5925
 -1.0829   -1.0915   -1.1019   -1.1121   -1.1214   -1.1313   -1.1410   -1.1513   -1.1616   -1.1709   -1.1806   -1.1897   -1.1992   -1.2094   -1.2189   -1.2285   -1.2379   -1.2476   -1.2565   -1.2664   -1.2758   -1.2845   -1.2945   -1.3040   -1.3128   -1.3221   -1.3311   -1.3403   -1.3492   -1.3577   -1.3665   -1.3755   -1.3843   -1.3938   -1.4029   -1.4125   -1.4220   -1.4306   -1.4400   -1.4496   -1.4591   -1.4685   -1.4777   -1.4871   -1.4951   -1.5043   -1.5129   -1.5223   -1.5312   -1.5399   -1.5494   -1.5591   -1.5679   -1.5769   -1.5854   -1.5937   -1.6030   -1.6116   -1.6200   -1.6292   -1.6373   -1.6464   -1.6548   -1.6629   -1.6714   -1.6798   -1.6885   -1.6970   -1.7055   -1.7144   -1.7223   -1.7303   -1.7385   -1.7462   -1.7547   -1.7636   -1.7713   -1.7795   -1.7878   -1.7964   -1.8045   -1.8133   -1.8217   -1.8301   -1.8385   -1.8466   -1.8549   -1.8634   -1.8705   -1.8787   -1.8868   -1.8949   -1.9031   -1.9112   -1.9187   -1.9271   -1.9348   -1.9421   -1.9499   -1.9574   -1.9654   -1.9726   -1.9807   -1.9887   -1.9965   -2.0039   -2.0111   -2.0187   -2.0266   -2.0340   -2.0415   -2.0492   -2.0567   -2.0646   -2.0719   -2.0789   -2.0865   -2.0937   -2.1010   -2.1081   -2.1154   -2.1230   -2.1298   -2.1371   -2.1446   -2.1520   -2.1596   -2.1672   -2.1742   -2.1813   -2.1881   -2.1954   -2.2031   -2.2100   -2.2167   -2.2237   -2.2307   -2.2375   -2.2445   -2.2516   -2.2592   -2.2649   -2.2719   -2.2787   -2.2857   -2.2924   -2.2992   -2.3058   -2.3126   -2.3184   -2.3255   -2.3318   -2.3381   -2.3445   -2.3505   -2.3566   -2.3631   -2.3687   -2.3751   -2.3806   -2.3867   -2.3927   -2.3986   -2.4047   -2.4109   -2.4176   -2.4243   -2.4298   -2.4358   -2.4408   -2.4469   -2.4526   -2.4582   -2.4636   -2.4692   -2.4759   -2.4814   -2.4876   -2.4933   -2.4987   -2.5043   -2.5099   -2.5151   -2.5206   -2.5265   -2.5327   -2.5381   -2.5437   -2.5492   -2.5546   -2.5614   -2.5668   -2.5724   -2.5770   -2.5814   -2.5865   -2.5914   -2.5966   -2.6025
 -1.0598   -1.0700   -1.0786   -1.0879   -1.0975   -1.1080   -1.1175   -1.1278   -1.1379   -1.1479   -1.1576   -1.1671   -1.1771   -1.1871   -1.1965   -1.2064   -1.2162   -1.2256   -1.2351   -1.2449   -1.2554   -1.2649   -1.2742   -1.2839   -1.2941   -1.3030   -1.3117   -1.3215   -1.3314   -1.3410   -1.3499   -1.3584   -1.3680   -1.3774   -1.3872   -1.3968   -1.4062   -1.4159   -1.4255   -1.4348   -1.4445   -1.4536   -1.4630   -1.4724   -1.4814   -1.4900   -1.4997   -1.5094   -1.5187   -1.5280   -1.5371   -1.5460   -1.5546   -1.5636   -1.5732   -1.5815   -1.5911   -1.6000   -1.6093   -1.6179   -1.6267   -1.6360   -1.6448   -1.6540   -1.6622   -1.6716   -1.6806   -1.6895   -1.6979   -1.7069   -1.7155   -1.7238   -1.7323   -1.7415   -1.7502   -1.7595   -1.7679   -1.7760   -1.7845   -1.7931   -1.8017   -1.8100   -1.8181   -1.8266   -1.8353   -1.8436   -1.8524   -1.8604   -1.8681   -1.8758   -1.8847   -1.8929   -1.9015   -1.9100   -1.9182   -1.9263   -1.9341   -1.9419   -1.9495   -1.9574   -1.9658   -1.9729   -1.9808   -1.9891   -1.9968   -2.0049   -2.0126   -2.0205   -2.0282   -2.0361   -2.0442   -2.0516   -2.0593   -2.0670   -2.0739   -2.0818   -2.0899   -2.0971   -2.1047   -2.1120   -2.1193   -2.1262   -2.1341   -2.1408   -2.1486   -2.1561   -2.1634   -2.1707   -2.1778   -2.1855   -2.1931   -2.2003   -2.2074   -2.2145   -2.2221   -2.2295   -2.2368   -2.2439   -2.2504   -2.2575   -2.2644   -2.2713   -2.2789   -2.2860   -2.2928   -2.2991   -2.3060   -2.3121   -2.3184   -2.3250   -2.3322   -2.3387   -2.3458   -2.3519   -2.3577   -2.3645   -2.3711   -2.3772   -2.3833   -2.3895   -2.3957   -2.4019   -2.4080   -2.4140   -2.4200   -2.4263   -2.4325   -2.4382   -2.4439   -2.4496   -2.4560   -2.4622   -2.4679   -2.4733   -2.4793   -2.4851   -2.4899   -2.4959   -2.5018   -2.5074   -2.5138   -2.5196   -2.5260   -2.5317   -2.5376   -2.5432   -2.5489   -2.5532   -2.5589   -2.5649   -2.5703   -2.5758   -2.5816   -2.5863   -2.5911   -2.5969   -2.6023   -2.6076   -2.6129
 -1.0393   -1.0504   -1.0590   -1.0687   -1.0778   -1.0876   -1.0987   -1.1089   -1.1194   -1.1288   -1.1384   -1.1488   -1.1581   -1.1683   -1.1787   -1.1890   -1.1991   -1.2089   -1.2195   -1.2292   -1.2392   -1.2493   -1.2598   -1.2688   -1.2782   -1.2884   -1.2985   -1.3087   -1.3187   -1.3286   -1.3383   -1.3476   -1.3576   -1.3672   -1.3759   -1.3860   -1.3962   -1.4059   -1.4149   -1.4237   -1.4326   -1.4420   -1.4518   -1.4618   -1.4714   -1.4805   -1.4912   -1.5004   -1.5098   -1.5184   -1.5281   -1.5371   -1.5465   -1.5562   -1.5647   -1.5738   -1.5833   -1.5918   -1.6010   -1.6102   -1.6195   -1.6286   -1.6372   -1.6465   -1.6556   -1.6646   -1.6732   -1.6824   -1.6910   -1.6998   -1.7090   -1.7181   -1.7276   -1.7361   -1.7448   -1.7546   -1.7640   -1.7720   -1.7808   -1.7891   -1.7980   -1.8067   -1.8149   -1.8234   -1.8321   -1.8398   -1.8489   -1.8571   -1.8656   -1.8741   -1.8831   -1.8921   -1.8999   -1.9084   -1.9171   -1.9255   -1.9330   -1.9414   -1.9495   -1.9574   -1.9657   -1.9736   -1.9820   -1.9900   -1.9977   -2.0064   -2.0142   -2.0217   -2.0295   -2.0370   -2.0452   -2.0529   -2.0607   -2.0686   -2.0762   -2.0834   -2.0910   -2.0992   -2.1068   -2.1148   -2.1222   -2.1301   -2.1382   -2.1452   -2.1529   -2.1611   -2.1682   -2.1759   -2.1831   -2.1910   -2.1985   -2.2061   -2.2135   -2.2204   -2.2272   -2.2340   -2.2412   -2.2478   -2.2550   -2.2614   -2.2686   -2.2763   -2.2833   -2.2908   -2.2977   -2.3059   -2.3129   -2.3193   -2.3258   -2.3321   -2.3393   -2.3456   -2.3531   -2.3602   -2.3666   -2.3734   -2.3799   -2.3861   -2.3926   -2.3990   -2.4048   -2.4120   -2.4175   -2.4236   -2.4299   -2.4368   -2.4427   -2.4484   -2.4548   -2.4615   -2.4666   -2.4717   -2.4772   -2.4830   -2.4887   -2.4942   -2.4991   -2.5049   -2.5100   -2.5156   -2.5218   -2.5282   -2.5340   -2.5391   -2.5450   -2.5506   -2.5569   -2.5628   -2.5697   -2.5747   -2.5804   -2.5859   -2.5914   -2.5968   -2.6027   -2.6086   -2.6132   -2.6180   -2.6227
 -1.0172   -1.0273   -1.0376   -1.0468   -1.0570   -1.0671   -1.0761   -1.0863   -1.0972   -1.1073   -1.1182   -1.1279   -1.1388   -1.1486   -1.1602   -1.1715   -1.1820   -1.1911   -1.2014   -1.2119   -1.2225   -1.2317   -1.2421   -1.2527   -1.2629   -1.2728   -1.2829   -1.2931   -1.3037   -1.3127   -1.3228   -1.3320   -1.3423   -1.3523   -1.3623   -1.3726   -1.3824   -1.3919   -1.4020   -1.4118   -1.4216   -1.4311   -1.4412   -1.4510   -1.4609   -1.4710   -1.4807   -1.4902   -1.4993   -1.5089   -1.5182   -1.5278   -1.5365   -1.5467   -1.5563   -1.5655   -1.5752   -1.5849   -1.5945   -1.6036   -1.6129   -1.6225   -1.6321   -1.6408   -1.6498   -1.6585   -1.6678   -1.6765   -1.6851   -1.6942   -1.7028   -1.7120   -1.7212   -1.7308   -1.7402   -1.7492   -1.7582   -1.7677   -1.7769   -1.7859   -1.7944   -1.8034   -1.8124   -1.8217   -1.8298   -1.8383   -1.8471   -1.8555   -1.8643   -1.8730   -1.8816   -1.8905   -1.8990   -1.9077   -1.9163   -1.9250   -1.9328   -1.9411   -1.9493   -1.9574   -1.9661   -1.9742   -1.9826   -1.9908   -1.9985   -2.0067   -2.0153   -2.0236   -2.0315   -2.0393   -2.0465   -2.0544   -2.0625   -2.0700   -2.0776   -2.0858   -2.0938   -2.1021   -2.1101   -2.1171   -2.1251   -2.1331   -2.1406   -2.1482   -2.1562   -2.1637   -2.1713   -2.1789   -2.1862   -2.1941   -2.2014   -2.2089   -2.2160   -2.2235   -2.2301   -2.2378   -2.2455   -2.2526   -2.2594   -2.2670   -2.2743   -2.2815   -2.2892   -2.2960   -2.3035   -2.3104   -2.3172   -2.3243   -2.3311   -2.3378   -2.3447   -2.3516   -2.3582   -2.3653   -2.3721   -2.3796   -2.3864   -2.3930   -2.3993   -2.4056   -2.4123   -2.4188   -2.4253   -2.4323   -2.4386   -2.4447   -2.4514   -2.4578   -2.4642   -2.4698   -2.4758   -2.4822   -2.4882   -2.4938   -2.4992   -2.5049   -2.5117   -2.5170   -2.5224   -2.5276   -2.5333   -2.5398   -2.5460   -2.5516   -2.5571   -2.5642   -2.5703   -2.5755   -2.5807   -2.5865   -2.5926   -2.5986   -2.6042   -2.6102   -2.6154   -2.6189   -2.6233   -2.6289   -2.6339
 -0.9956   -1.0063   -1.0181   -1.0284   -1.0386   -1.0488   -1.0597   -1.0702   -1.0815   -1.0933   -1.1032   -1.1135   -1.1236   -1.1340   -1.1433   -1.1538   -1.1644   -1.1747   -1.1852   -1.1966   -1.2074   -1.2180   -1.2288   -1.2400   -1.2496   -1.2597   -1.2698   -1.2803   -1.2900   -1.3003   -1.3108   -1.3212   -1.3311   -1.3404   -1.3504   -1.3605   -1.3703   -1.3803   -1.3905   -1.4008   -1.4106   -1.4209   -1.4309   -1.4412   -1.4518   -1.4617   -1.4720   -1.4818   -1.4921   -1.5012   -1.5105   -1.5208   -1.5308   -1.5405   -1.5501   -1.5592   -1.5685   -1.5771   -1.5867   -1.5962   -1.6056   -1.6148   -1.6240   -1.6331   -1.6427   -1.6520   -1.6613   -1.6710   -1.6806   -1.6897   -1.6997   -1.7089   -1.7180   -1.7276   -1.7363   -1.7452   -1.7540   -1.7623   -1.7722   -1.7808   -1.7899   -1.7992   -1.8086   -1.8174   -1.8259   -1.8351   -1.8438   -1.8527   -1.8617   -1.8703   -1.8791   -1.8883   -1.8970   -1.9060   -1.9147   -1.9232   -1.9316   -1.9403   -1.9491   -1.9574   -1.9662   -1.9744   -1.9829   -1.9916   -2.0002   -2.0085   -2.0165   -2.0246   -2.0329   -2.0411   -2.0494   -2.0570   -2.0652   -2.0729   -2.0817   -2.0891   -2.0967   -2.1050   -2.1135   -2.1217   -2.1296   -2.1374   -2.1449   -2.1528   -2.1609   -2.1686   -2.1758   -2.1834   -2.1916   -2.1995   -2.2071   -2.2154   -2.2231   -2.2302   -2.2378   -2.2450   -2.2526   -2.2600   -2.2677   -2.2745   -2.2819   -2.2898   -2.2969   -2.3033   -2.3107   -2.3179   -2.3254   -2.3323   -2.3394   -2.3469   -2.3532   -2.3592   -2.3662   -2.3724   -2.3795   -2.3862   -2.3928   -2.3993   -2.4063   -2.4125   -2.4197   -2.4255   -2.4316   -2.4385   -2.4439   -2.4502   -2.4559   -2.4622   -2.4679   -2.4745   -2.4816   -2.4885   -2.4949   -2.5011   -2.5070   -2.5125   -2.5190   -2.5250   -2.5311   -2.5367   -2.5428   -2.5473   -2.5535   -2.5594   -2.5656   -2.5707   -2.5768   -2.5826   -2.5888   -2.5943   -2.6002   -2.6054   -2.6114   -2.6172   -2.6228   -2.6286   -2.6331   -2.6380   -2.6443
 -0.9775   -0.9900   -0.9994   -1.0093   -1.0204   -1.0311   -1.0412   -1.0517   -1.0625   -1.0732   -1.0836   -1.0942   -1.1043   -1.1152   -1.1263   -1.1371   -1.1480   -1.1591   -1.1693   -1.1802   -1.1917   -1.2020   -1.2122   -1.2232   -1.2336   -1.2440   -1.2547   -1.2648   -1.2752   -1.2862   -1.2963   -1.3067   -1.3168   -1.3271   -1.3382   -1.3480   -1.3586   -1.3685   -1.3790   -1.3891   -1.3991   -1.4090   -1.4196   -1.4300   -1.4409   -1.4511   -1.4614   -1.4716   -1.4813   -1.4916   -1.5021   -1.5117   -1.5211   -1.5307   -1.5409   -1.5501   -1.5596   -1.5691   -1.5787   -1.5884   -1.5981   -1.6079   -1.6171   -1.6264   -1.6358   -1.6452   -1.6549   -1.6644   -1.6740   -1.6837   -1.6939   -1.7037   -1.7131   -1.7224   -1.7321   -1.7418   -1.7515   -1.7604   -1.7699   -1.7787   -1.7876   -1.7971   -1.8055   -1.8151   -1.8241   -1.8334   -1.8427   -1.8514   -1.8603   -1.8692   -1.8782   -1.8873   -1.8966   -1.9052   -1.9142   -1.9230   -1.9316   -1.9403   -1.9491   -1.9574   -1.9665   -1.9747   -1.9835   -1.9919   -2.0011   -2.0095   -2.0181   -2.0263   -2.0345   -2.0428   -2.0511   -2.0591   -2.0678   -2.0763   -2.0852   -2.0935   -2.1013   -2.1092   -2.1172   -2.1252   -2.1332   -2.1415   -2.1491   -2.1570   -2.1647   -2.1727   -2.1804   -2.1884   -2.1955   -2.2027   -2.2105   -2.2188   -2.2263   -2.2343   -2.2416   -2.2493   -2.2571   -2.2650   -2.2717   -2.2794   -2.2870   -2.2944   -2.3022   -2.3094   -2.3166   -2.3238   -2.3308   -2.3383   -2.3448   -2.3521   -2.3584   -2.3652   -2.3721   -2.3790   -2.3861   -2.3926   -2.3994   -2.4054   -2.4122   -2.4185   -2.4247   -2.4312   -2.4371   -2.4439   -2.4503   -2.4565   -2.4629   -2.4689   -2.4746   -2.4810   -2.4870   -2.4932   -2.4994   -2.5057   -2.5113   -2.5169   -2.5241   -2.5310   -2.5367   -2.5427   -2.5492   -2.5547   -2.5609   -2.5668   -2.5721   -2.5784   -2.5845   -2.5901   -2.5956   -2.6017   -2.6079   -2.6138   -2.6193   -2.6247   -2.6293   -2.6347   -2.6404   -2.6449   -2.6500
 -0.9620   -0.9735   -0.9846   -0.9945   -1.0044   -1.0150   -1.0260   -1.0368   -1.0473   -1.0579   -1.0680   -1.0782   -1.0894   -1.0994   -1.1098   -1.1215   -1.1331   -1.1445   -1.1554   -1.1664   -1.1781   -1.1878   -1.1988   -1.2099   -1.2202   -1.2318   -1.2420   -1.2525   -1.2628   -1.2730   -1.2839   -1.2946   -1.3054   -1.3153   -1.3263   -1.3374   -1.3474   -1.3580   -1.3681   -1.3788   -1.3891   -1.4002   -1.4102   -1.4210   -1.4312   -1.4414   -1.4522   -1.4627   -1.4724   -1.4826   -1.4930   -1.5027   -1.5126   -1.5225   -1.5317   -1.5417   -1.5512   -1.5615   -1.5709   -1.5810   -1.5904   -1.6004   -1.6101   -1.6193   -1.6296   -1.6400   -1.6493   -1.6587   -1.6687   -1.6785   -1.6881   -1.6983   -1.7079   -1.7179   -1.7280   -1.7376   -1.7473   -1.7569   -1.7660   -1.7755   -1.7845   -1.7941   -1.8033   -1.8128   -1.8220   -1.8315   -1.8402   -1.8487   -1.8585   -1.8677   -1.8772   -1.8856   -1.8950   -1.9043   -1.9126   -1.9218   -1.9308   -1.9396   -1.9486   -1.9574   -1.9666   -1.9750   -1.9836   -1.9926   -2.0017   -2.0101   -2.0193   -2.0267   -2.0358   -2.0436   -2.0518   -2.0599   -2.0688   -2.0770   -2.0856   -2.0936   -2.1025   -2.1103   -2.1188   -2.1270   -2.1348   -2.1433   -2.1511   -2.1590   -2.1672   -2.1755   -2.1838   -2.1921   -2.1998   -2.2073   -2.2150   -2.2227   -2.2297   -2.2371   -2.2451   -2.2525   -2.2597   -2.2679   -2.2752   -2.2831   -2.2902   -2.2978   -2.3052   -2.3131   -2.3211   -2.3284   -2.3350   -2.3423   -2.3490   -2.3561   -2.3635   -2.3702   -2.3773   -2.3839   -2.3912   -2.3979   -2.4054   -2.4120   -2.4186   -2.4251   -2.4319   -2.4380   -2.4443   -2.4510   -2.4575   -2.4641   -2.4703   -2.4770   -2.4831   -2.4890   -2.4950   -2.5011   -2.5074   -2.5137   -2.5194   -2.5257   -2.5317   -2.5388   -2.5451   -2.5510   -2.5570   -2.5632   -2.5696   -2.5751   -2.5806   -2.5858   -2.5914   -2.5978   -2.6034   -2.6087   -2.6156   -2.6212   -2.6273   -2.6326   -2.6373   -2.6428   -2.6482   -2.6536   -2.6576
 -0.9435   -0.9539   -0.9635   -0.9741   -0.9837   -0.9946   -1.0048   -1.0172   -1.0278   -1.0401   -1.0515   -1.0623   -1.0738   -1.0849   -1.0961   -1.1075   -1.1189   -1.1294   -1.1396   -1.1513   -1.1613   -1.1727   -1.1835   -1.1946   -1.2060   -1.2163   -1.2269   -1.2375   -1.2483   -1.2596   -1.2706   -1.2819   -1.2927   -1.3024   -1.3130   -1.3244   -1.3348   -1.3457   -1.3561   -1.3668   -1.3779   -1.3885   -1.3993   -1.4094   -1.4197   -1.4296   -1.4401   -1.4502   -1.4611   -1.4719   -1.4828   -1.4923   -1.5029   -1.5130   -1.5227   -1.5327   -1.5430   -1.5532   -1.5629   -1.5731   -1.5834   -1.5934   -1.6041   -1.6145   -1.6248   -1.6347   -1.6450   -1.6554   -1.6647   -1.6751   -1.6845   -1.6939   -1.7034   -1.7131   -1.7236   -1.7329   -1.7430   -1.7522   -1.7617   -1.7704   -1.7800   -1.7896   -1.7995   -1.8091   -1.8183   -1.8281   -1.8372   -1.8464   -1.8562   -1.8662   -1.8751   -1.8841   -1.8936   -1.9033   -1.9123   -1.9214   -1.9299   -1.9394   -1.9485   -1.9574   -1.9666   -1.9753   -1.9841   -1.9929   -2.0023   -2.0112   -2.0199   -2.0281   -2.0368   -2.0458   -2.0543   -2.0625   -2.0707   -2.0792   -2.0879   -2.0967   -2.1053   -2.1134   -2.1213   -2.1296   -2.1379   -2.1462   -2.1541   -2.1620   -2.1701   -2.1779   -2.1867   -2.1953   -2.2031   -2.2110   -2.2189   -2.2269   -2.2348   -2.2421   -2.2499   -2.2576   -2.2656   -2.2734   -2.2810   -2.2890   -2.2966   -2.3041   -2.3114   -2.3185   -2.3254   -2.3327   -2.3395   -2.3474   -2.3545   -2.3611   -2.3685   -2.3756   -2.3820   -2.3891   -2.3962   -2.4031   -2.4102   -2.4179   -2.4242   -2.4312   -2.4378   -2.4452   -2.4517   -2.4574   -2.4631   -2.4707   -2.4772   -2.4838   -2.4904   -2.4964   -2.5024   -2.5087   -2.5151   -2.5213   -2.5272   -2.5335   -2.5401   -2.5459   -2.5526   -2.5587   -2.5646   -2.5702   -2.5763   -2.5825   -2.5885   -2.5944   -2.5998   -2.6047   -2.6104   -2.6170   -2.6225   -2.6285   -2.6346   -2.6406   -2.6459   -2.6511   -2.6572   -2.6624   -2.6683
 -0.9264   -0.9377   -0.9489   -0.9589   -0.9700   -0.9798   -0.9915   -1.0019   -1.0128   -1.0239   -1.0344   -1.0456   -1.0565   -1.0684   -1.0799   -1.0910   -1.1021   -1.1133   -1.1250   -1.1358   -1.1473   -1.1587   -1.1699   -1.1813   -1.1921   -1.2025   -1.2134   -1.2241   -1.2347   -1.2453   -1.2566   -1.2674   -1.2790   -1.2904   -1.3018   -1.3123   -1.3232   -1.3341   -1.3449   -1.3554   -1.3669   -1.3782   -1.3890   -1.3996   -1.4098   -1.4209   -1.4314   -1.4420   -1.4527   -1.4631   -1.4730   -1.4837   -1.4939   -1.5042   -1.5146   -1.5253   -1.5361   -1.5464   -1.5566   -1.5673   -1.5774   -1.5875   -1.5978   -1.6081   -1.6188   -1.6285   -1.6380   -1.6478   -1.6582   -1.6683   -1.6783   -1.6882   -1.6983   -1.7084   -1.7185   -1.7288   -1.7388   -1.7481   -1.7577   -1.7674   -1.7774   -1.7873   -1.7971   -1.8063   -1.8158   -1.8257   -1.8353   -1.8458   -1.8548   -1.8644   -1.8742   -1.8834   -1.8932   -1.9023   -1.9121   -1.9218   -1.9301   -1.9396   -1.9485   -1.9574   -1.9670   -1.9756   -1.9846   -1.9935   -2.0029   -2.0117   -2.0210   -2.0291   -2.0379   -2.0465   -2.0552   -2.0644   -2.0729   -2.0816   -2.0899   -2.0979   -2.1068   -2.1151   -2.1236   -2.1324   -2.1408   -2.1487   -2.1575   -2.1660   -2.1739   -2.1813   -2.1893   -2.1976   -2.2064   -2.2142   -2.2223   -2.2298   -2.2378   -2.2458   -2.2542   -2.2620   -2.2696   -2.2776   -2.2852   -2.2933   -2.3011   -2.3088   -2.3161   -2.3240   -2.3315   -2.3390   -2.3464   -2.3540   -2.3614   -2.3685   -2.3755   -2.3825   -2.3899   -2.3967   -2.4038   -2.4108   -2.4179   -2.4248   -2.4321   -2.4380   -2.4455   -2.4518   -2.4583   -2.4646   -2.4712   -2.4774   -2.4840   -2.4905   -2.4965   -2.5026   -2.5087   -2.5147   -2.5215   -2.5272   -2.5337   -2.5406   -2.5474   -2.5531   -2.5600   -2.5660   -2.5721   -2.5781   -2.5847   -2.5905   -2.5962   -2.6010   -2.6067   -2.6120   -2.6172   -2.6227   -2.6280   -2.6343   -2.6405   -2.6469   -2.6530   -2.6585   -2.6642   -2.6699   -2.6776
 -0.9152   -0.9258   -0.9351   -0.9453   -0.9552   -0.9672   -0.9783   -0.9894   -1.0001   -1.0112   -1.0213   -1.0323   -1.0436   -1.0544   -1.0656   -1.0766   -1.0886   -1.0994   -1.1101   -1.1216   -1.1329   -1.1444   -1.1553   -1.1671   -1.1779   -1.1892   -1.2012   -1.2123   -1.2232   -1.2342   -1.2450   -1.2566   -1.2675   -1.2796   -1.2900   -1.3016   -1.3126   -1.3233   -1.3353   -1.3459   -1.3565   -1.3676   -1.3787   -1.3901   -1.4006   -1.4120   -1.4226   -1.4332   -1.4444   -1.4551   -1.4657   -1.4767   -1.4874   -1.4978   -1.5087   -1.5193   -1.5303   -1.5401   -1.5504   -1.5617   -1.5711   -1.5818   -1.5920   -1.6023   -1.6130   -1.6229   -1.6338   -1.6434   -1.6535   -1.6641   -1.6749   -1.6848   -1.6949   -1.7046   -1.7145   -1.7248   -1.7346   -1.7447   -1.7549   -1.7650   -1.7753   -1.7851   -1.7946   -1.8045   -1.8142   -1.8245   -1.8344   -1.8444   -1.8534   -1.8636   -1.8734   -1.8829   -1.8926   -1.9023   -1.9119   -1.9211   -1.9303   -1.9395   -1.9487   -1.9574   -1.9668   -1.9756   -1.9839   -1.9931   -2.0027   -2.0120   -2.0214   -2.0301   -2.0385   -2.0476   -2.0572   -2.0663   -2.0756   -2.0837   -2.0924   -2.1011   -2.1095   -2.1184   -2.1265   -2.1352   -2.1436   -2.1519   -2.1605   -2.1690   -2.1778   -2.1857   -2.1936   -2.2009   -2.2090   -2.2177   -2.2262   -2.2344   -2.2433   -2.2511   -2.2588   -2.2668   -2.2737   -2.2814   -2.2898   -2.2972   -2.3056   -2.3130   -2.3211   -2.3288   -2.3359   -2.3433   -2.3512   -2.3583   -2.3656   -2.3737   -2.3809   -2.3874   -2.3942   -2.4010   -2.4085   -2.4158   -2.4232   -2.4307   -2.4371   -2.4442   -2.4516   -2.4587   -2.4650   -2.4719   -2.4779   -2.4840   -2.4900   -2.4964   -2.5031   -2.5097   -2.5160   -2.5222   -2.5283   -2.5348   -2.5412   -2.5471   -2.5535   -2.5598   -2.5662   -2.5725   -2.5783   -2.5835   -2.5895   -2.5956   -2.6007   -2.6060   -2.6123   -2.6185   -2.6241   -2.6306   -2.6362   -2.6413   -2.6461   -2.6523   -2.6571   -2.6624   -2.6698   -2.6751   -2.6834
 -0.9008   -0.9123   -0.9228   -0.9338   -0.9445   -0.9565   -0.9669   -0.9787   -0.9893   -1.0004   -1.0111   -1.0219   -1.0321   -1.0435   -1.0544   -1.0660   -1.0772   -1.0887   -1.0999   -1.1111   -1.1221   -1.1336   -1.1449   -1.1563   -1.1683   -1.1796   -1.1916   -1.2028   -1.2134   -1.2246   -1.2353   -1.2466   -1.2576   -1.2692   -1.2800   -1.2913   -1.3024   -1.3136   -1.3239   -1.3350   -1.3467   -1.3577   -1.3689   -1.3803   -1.3918   -1.4027   -1.4131   -1.4240   -1.4357   -1.4472   -1.4578   -1.4689   -1.4798   -1.4908   -1.5016   -1.5121   -1.5237   -1.5346   -1.5453   -1.5561   -1.5658   -1.5765   -1.5864   -1.5972   -1.6078   -1.6178   -1.6285   -1.6384   -1.6486   -1.6585   -1.6691   -1.6796   -1.6898   -1.6998   -1.7103   -1.7204   -1.7308   -1.7412   -1.7518   -1.7622   -1.7721   -1.7815   -1.7921   -1.8021   -1.8124   -1.8223   -1.8322   -1.8417   -1.8516   -1.8612   -1.8717   -1.8810   -1.8911   -1.9011   -1.9107   -1.9199   -1.9297   -1.9391   -1.9487   -1.9574   -1.9668   -1.9757   -1.9847   -1.9940   -2.0037   -2.0128   -2.0222   -2.0314   -2.0407   -2.0494   -2.0587   -2.0681   -2.0771   -2.0858   -2.0950   -2.1034   -2.1117   -2.1201   -2.1283   -2.1377   -2.1459   -2.1547   -2.1625   -2.1714   -2.1798   -2.1892   -2.1972   -2.2057   -2.2142   -2.2220   -2.2300   -2.2383   -2.2464   -2.2540   -2.2621   -2.2707   -2.2788   -2.2873   -2.2953   -2.3035   -2.3114   -2.3191   -2.3270   -2.3348   -2.3425   -2.3504   -2.3583   -2.3657   -2.3736   -2.3814   -2.3878   -2.3949   -2.4018   -2.4092   -2.4161   -2.4230   -2.4298   -2.4370   -2.4440   -2.4510   -2.4573   -2.4646   -2.4719   -2.4783   -2.4850   -2.4920   -2.4986   -2.5053   -2.5117   -2.5186   -2.5248   -2.5319   -2.5380   -2.5439   -2.5502   -2.5558   -2.5624   -2.5685   -2.5744   -2.5799   -2.5858   -2.5915   -2.5975   -2.6031   -2.6086   -2.6144   -2.6214   -2.6267   -2.6319   -2.6375   -2.6439   -2.6491   -2.6562   -2.6620   -2.6667   -2.6715   -2.6769   -2.6808   -2.6860
 -0.8919   -0.9023   -0.9120   -0.9223   -0.9340   -0.9447   -0.9553   -0.9663   -0.9770   -0.9875   -0.9984   -1.0101   -1.0214   -1.0327   -1.0435   -1.0553   -1.0680   -1.0790   -1.0907   -1.1025   -1.1149   -1.1257   -1.1362   -1.1474   -1.1585   -1.1707   -1.1822   -1.1929   -1.2045   -1.2157   -1.2272   -1.2387   -1.2505   -1.2614   -1.2726   -1.2843   -1.2946   -1.3060   -1.3174   -1.3291   -1.3408   -1.3521   -1.3638   -1.3750   -1.3862   -1.3970   -1.4080   -1.4197   -1.4310   -1.4417   -1.4524   -1.4634   -1.4746   -1.4856   -1.4969   -1.5070   -1.5175   -1.5289   -1.5392   -1.5495   -1.5601   -1.5700   -1.5809   -1.5916   -1.6023   -1.6125   -1.6224   -1.6331   -1.6441   -1.6543   -1.6641   -1.6743   -1.6852   -1.6951   -1.7055   -1.7161   -1.7264   -1.7368   -1.7470   -1.7577   -1.7685   -1.7784   -1.7885   -1.7989   -1.8091   -1.8199   -1.8305   -1.8408   -1.8507   -1.8609   -1.8705   -1.8806   -1.8905   -1.9004   -1.9097   -1.9197   -1.9296   -1.9390   -1.9484   -1.9574   -1.9672   -1.9761   -1.9854   -1.9948   -2.0044   -2.0135   -2.0232   -2.0322   -2.0416   -2.0511   -2.0609   -2.0698   -2.0783   -2.0870   -2.0960   -2.1045   -2.1132   -2.1222   -2.1310   -2.1402   -2.1487   -2.1578   -2.1664   -2.1750   -2.1831   -2.1917   -2.1995   -2.2078   -2.2160   -2.2246   -2.2333   -2.2417   -2.2503   -2.2588   -2.2669   -2.2754   -2.2831   -2.2912   -2.2990   -2.3074   -2.3153   -2.3231   -2.3304   -2.3381   -2.3459   -2.3541   -2.3614   -2.3691   -2.3768   -2.3846   -2.3921   -2.4002   -2.4075   -2.4150   -2.4221   -2.4291   -2.4362   -2.4435   -2.4508   -2.4581   -2.4652   -2.4722   -2.4797   -2.4871   -2.4939   -2.5003   -2.5065   -2.5128   -2.5186   -2.5255   -2.5319   -2.5388   -2.5451   -2.5511   -2.5576   -2.5642   -2.5694   -2.5752   -2.5812   -2.5872   -2.5939   -2.5995   -2.6052   -2.6107   -2.6157   -2.6213   -2.6272   -2.6333   -2.6393   -2.6449   -2.6504   -2.6566   -2.6621   -2.6664   -2.6707   -2.6761   -2.6807   -2.6867   -2.6919
 -0.8793   -0.8881   -0.8972   -0.9077   -0.9173   -0.9287   -0.9393   -0.9506   -0.9626   -0.9745   -0.9859   -0.9977   -1.0094   -1.0207   -1.0322   -1.0436   -1.0555   -1.0662   -1.0780   -1.0891   -1.1001   -1.1111   -1.1222   -1.1336   -1.1455   -1.1575   -1.1685   -1.1800   -1.1916   -1.2030   -1.2147   -1.2265   -1.2377   -1.2501   -1.2615   -1.2727   -1.2843   -1.2958   -1.3073   -1.3188   -1.3312   -1.3427   -1.3538   -1.3656   -1.3768   -1.3881   -1.3993   -1.4104   -1.4214   -1.4328   -1.4439   -1.4550   -1.4666   -1.4773   -1.4879   -1.4985   -1.5104   -1.5220   -1.5327   -1.5432   -1.5544   -1.5647   -1.5753   -1.5856   -1.5967   -1.6073   -1.6184   -1.6297   -1.6400   -1.6507   -1.6611   -1.6715   -1.6823   -1.6931   -1.7041   -1.7142   -1.7248   -1.7342   -1.7446   -1.7555   -1.7661   -1.7761   -1.7862   -1.7973   -1.8076   -1.8179   -1.8284   -1.8383   -1.8491   -1.8589   -1.8688   -1.8795   -1.8898   -1.8999   -1.9096   -1.9194   -1.9291   -1.9384   -1.9483   -1.9574   -1.9671   -1.9767   -1.9860   -1.9955   -2.0052   -2.0148   -2.0245   -2.0336   -2.0428   -2.0514   -2.0604   -2.0703   -2.0797   -2.0894   -2.0987   -2.1074   -2.1161   -2.1248   -2.1333   -2.1418   -2.1512   -2.1602   -2.1689   -2.1769   -2.1859   -2.1944   -2.2030   -2.2117   -2.2201   -2.2289   -2.2374   -2.2457   -2.2541   -2.2629   -2.2710   -2.2790   -2.2877   -2.2959   -2.3042   -2.3130   -2.3212   -2.3287   -2.3365   -2.3444   -2.3515   -2.3589   -2.3666   -2.3741   -2.3819   -2.3888   -2.3960   -2.4036   -2.4105   -2.4188   -2.4259   -2.4335   -2.4414   -2.4486   -2.4553   -2.4626   -2.4690   -2.4757   -2.4825   -2.4890   -2.4962   -2.5033   -2.5100   -2.5167   -2.5228   -2.5288   -2.5353   -2.5415   -2.5477   -2.5546   -2.5613   -2.5684   -2.5748   -2.5813   -2.5869   -2.5927   -2.5988   -2.6052   -2.6120   -2.6181   -2.6238   -2.6284   -2.6341   -2.6411   -2.6468   -2.6521   -2.6581   -2.6640   -2.6685   -2.6741   -2.6794   -2.6850   -2.6909   -2.6957   -2.7003
 -0.8641   -0.8740   -0.8857   -0.8961   -0.9064   -0.9179   -0.9282   -0.9395   -0.9516   -0.9629   -0.9726   -0.9841   -0.9964   -1.0078   -1.0199   -1.0320   -1.0435   -1.0546   -1.0668   -1.0794   -1.0905   -1.1016   -1.1130   -1.1249   -1.1369   -1.1490   -1.1600   -1.1708   -1.1824   -1.1948   -1.2066   -1.2181   -1.2298   -1.2415   -1.2532   -1.2647   -1.2762   -1.2875   -1.2985   -1.3098   -1.3218   -1.3331   -1.3448   -1.3570   -1.3690   -1.3806   -1.3928   -1.4040   -1.4152   -1.4260   -1.4372   -1.4480   -1.4590   -1.4697   -1.4807   -1.4917   -1.5030   -1.5144   -1.5253   -1.5361   -1.5471   -1.5577   -1.5689   -1.5797   -1.5910   -1.6020   -1.6123   -1.6233   -1.6344   -1.6457   -1.6564   -1.6672   -1.6779   -1.6880   -1.6994   -1.7099   -1.7207   -1.7311   -1.7426   -1.7537   -1.7641   -1.7744   -1.7848   -1.7952   -1.8063   -1.8172   -1.8275   -1.8373   -1.8478   -1.8578   -1.8680   -1.8777   -1.8879   -1.8983   -1.9082   -1.9185   -1.9281   -1.9379   -1.9483   -1.9574   -1.9672   -1.9771   -1.9864   -1.9961   -2.0056   -2.0155   -2.0252   -2.0348   -2.0444   -2.0530   -2.0623   -2.0717   -2.0814   -2.0904   -2.0992   -2.1082   -2.1177   -2.1264   -2.1354   -2.1447   -2.1540   -2.1630   -2.1726   -2.1812   -2.1900   -2.1991   -2.2078   -2.2168   -2.2254   -2.2340   -2.2422   -2.2507   -2.2589   -2.2674   -2.2763   -2.2842   -2.2929   -2.3017   -2.3095   -2.3183   -2.3264   -2.3343   -2.3420   -2.3502   -2.3581   -2.3659   -2.3738   -2.3815   -2.3889   -2.3961   -2.4034   -2.4115   -2.4192   -2.4260   -2.4332   -2.4400   -2.4475   -2.4556   -2.4632   -2.4700   -2.4774   -2.4845   -2.4913   -2.4981   -2.5053   -2.5118   -2.5181   -2.5252   -2.5323   -2.5391   -2.5457   -2.5516   -2.5576   -2.5637   -2.5707   -2.5764   -2.5822   -2.5875   -2.5932   -2.5994   -2.6056   -2.6121   -2.6176   -2.6226   -2.6290   -2.6345   -2.6393   -2.6451   -2.6506   -2.6563   -2.6625   -2.6686   -2.6744   -2.6795   -2.6849   -2.6905   -2.6958   -2.7012   -2.7069
 -0.8535   -0.8642   -0.8745   -0.8852   -0.8961   -0.9074   -0.9177   -0.9294   -0.9407   -0.9515   -0.9634   -0.9740   -0.9851   -0.9973   -1.0088   -1.0217   -1.0345   -1.0460   -1.0584   -1.0708   -1.0817   -1.0940   -1.1055   -1.1176   -1.1291   -1.1402   -1.1522   -1.1641   -1.1758   -1.1875   -1.1994   -1.2115   -1.2240   -1.2354   -1.2465   -1.2582   -1.2697   -1.2813   -1.2931   -1.3042   -1.3161   -1.3276   -1.3393   -1.3505   -1.3621   -1.3740   -1.3855   -1.3969   -1.4087   -1.4201   -1.4306   -1.4421   -1.4536   -1.4648   -1.4755   -1.4873   -1.4984   -1.5094   -1.5200   -1.5315   -1.5430   -1.5543   -1.5645   -1.5754   -1.5865   -1.5979   -1.6087   -1.6197   -1.6310   -1.6419   -1.6531   -1.6641   -1.6748   -1.6858   -1.6972   -1.7086   -1.7191   -1.7298   -1.7408   -1.7515   -1.7627   -1.7732   -1.7838   -1.7933   -1.8043   -1.8146   -1.8252   -1.8362   -1.8464   -1.8569   -1.8667   -1.8772   -1.8873   -1.8977   -1.9077   -1.9177   -1.9281   -1.9379   -1.9478   -1.9574   -1.9676   -1.9770   -1.9867   -1.9970   -2.0070   -2.0170   -2.0259   -2.0353   -2.0447   -2.0541   -2.0631   -2.0723   -2.0821   -2.0917   -2.1011   -2.1102   -2.1197   -2.1294   -2.1387   -2.1478   -2.1566   -2.1653   -2.1740   -2.1831   -2.1922   -2.2009   -2.2096   -2.2189   -2.2280   -2.2368   -2.2452   -2.2537   -2.2620   -2.2702   -2.2784   -2.2870   -2.2948   -2.3034   -2.3116   -2.3195   -2.3288   -2.3369   -2.3457   -2.3538   -2.3619   -2.3691   -2.3773   -2.3852   -2.3933   -2.4011   -2.4087   -2.4163   -2.4236   -2.4311   -2.4388   -2.4458   -2.4532   -2.4603   -2.4674   -2.4746   -2.4815   -2.4885   -2.4952   -2.5022   -2.5090   -2.5161   -2.5235   -2.5301   -2.5363   -2.5425   -2.5491   -2.5554   -2.5614   -2.5676   -2.5739   -2.5807   -2.5876   -2.5937   -2.6002   -2.6056   -2.6109   -2.6166   -2.6228   -2.6289   -2.6343   -2.6394   -2.6448   -2.6500   -2.6558   -2.6613   -2.6667   -2.6711   -2.6761   -2.6834   -2.6891   -2.6961   -2.7014   -2.7062   -2.7111
 -0.8433   -0.8541   -0.8650   -0.8760   -0.8873   -0.8984   -0.9081   -0.9206   -0.9336   -0.9449   -0.9559   -0.9674   -0.9778   -0.9889   -0.9996   -1.0107   -1.0227   -1.0344   -1.0467   -1.0593   -1.0715   -1.0844   -1.0954   -1.1073   -1.1189   -1.1300   -1.1423   -1.1547   -1.1664   -1.1774   -1.1895   -1.2004   -1.2123   -1.2244   -1.2367   -1.2484   -1.2599   -1.2711   -1.2826   -1.2948   -1.3069   -1.3190   -1.3311   -1.3429   -1.3546   -1.3657   -1.3776   -1.3890   -1.4000   -1.4116   -1.4235   -1.4350   -1.4468   -1.4581   -1.4694   -1.4806   -1.4917   -1.5033   -1.5153   -1.5265   -1.5379   -1.5495   -1.5613   -1.5722   -1.5831   -1.5937   -1.6050   -1.6164   -1.6272   -1.6383   -1.6495   -1.6608   -1.6722   -1.6833   -1.6940   -1.7054   -1.7164   -1.7274   -1.7385   -1.7498   -1.7603   -1.7712   -1.7813   -1.7920   -1.8026   -1.8133   -1.8244   -1.8357   -1.8463   -1.8565   -1.8667   -1.8768   -1.8868   -1.8970   -1.9070   -1.9175   -1.9276   -1.9377   -1.9477   -1.9574   -1.9676   -1.9778   -1.9878   -1.9976   -2.0076   -2.0173   -2.0270   -2.0365   -2.0463   -2.0559   -2.0659   -2.0756   -2.0846   -2.0940   -2.1033   -2.1118   -2.1213   -2.1312   -2.1401   -2.1497   -2.1589   -2.1679   -2.1770   -2.1857   -2.1952   -2.2044   -2.2135   -2.2225   -2.2312   -2.2402   -2.2484   -2.2574   -2.2661   -2.2751   -2.2841   -2.2927   -2.3013   -2.3099   -2.3182   -2.3266   -2.3354   -2.3438   -2.3523   -2.3604   -2.3687   -2.3764   -2.3841   -2.3922   -2.4002   -2.4074   -2.4151   -2.4223   -2.4303   -2.4379   -2.4457   -2.4532   -2.4605   -2.4685   -2.4752   -2.4824   -2.4896   -2.4968   -2.5044   -2.5116   -2.5186   -2.5252   -2.5323   -2.5386   -2.5455   -2.5519   -2.5587   -2.5655   -2.5715   -2.5780   -2.5850   -2.5911   -2.5972   -2.6031   -2.6081   -2.6144   -2.6206   -2.6274   -2.6339   -2.6399   -2.6458   -2.6506   -2.6571   -2.6629   -2.6682   -2.6733   -2.6794   -2.6845   -2.6905   -2.6969   -2.7019   -2.7076   -2.7140   -2.7191   -2.7251
 -0.8340   -0.8447   -0.8548   -0.8663   -0.8774   -0.8888   -0.8996   -0.9104   -0.9219   -0.9334   -0.9450   -0.9569   -0.9692   -0.9811   -0.9928   -1.0046   -1.0171   -1.0292   -1.0408   -1.0519   -1.0641   -1.0761   -1.0882   -1.1002   -1.1122   -1.1245   -1.1368   -1.1478   -1.1600   -1.1720   -1.1837   -1.1962   -1.2090   -1.2209   -1.2329   -1.2440   -1.2566   -1.2686   -1.2805   -1.2924   -1.3039   -1.3154   -1.3277   -1.3392   -1.3505   -1.3626   -1.3748   -1.3869   -1.3989   -1.4101   -1.4218   -1.4336   -1.4452   -1.4560   -1.4675   -1.4790   -1.4900   -1.5017   -1.5131   -1.5250   -1.5363   -1.5483   -1.5590   -1.5699   -1.5807   -1.5916   -1.6028   -1.6144   -1.6257   -1.6373   -1.6489   -1.6597   -1.6707   -1.6818   -1.6926   -1.7034   -1.7142   -1.7253   -1.7368   -1.7481   -1.7589   -1.7698   -1.7805   -1.7913   -1.8022   -1.8127   -1.8230   -1.8333   -1.8440   -1.8541   -1.8655   -1.8762   -1.8862   -1.8962   -1.9065   -1.9169   -1.9271   -1.9371   -1.9473   -1.9574   -1.9676   -1.9781   -1.9877   -1.9977   -2.0083   -2.0177   -2.0282   -2.0377   -2.0470   -2.0570   -2.0669   -2.0768   -2.0860   -2.0955   -2.1047   -2.1149   -2.1248   -2.1335   -2.1428   -2.1520   -2.1617   -2.1713   -2.1805   -2.1899   -2.1992   -2.2082   -2.2172   -2.2258   -2.2355   -2.2441   -2.2529   -2.2616   -2.2700   -2.2785   -2.2872   -2.2959   -2.3049   -2.3138   -2.3219   -2.3302   -2.3382   -2.3469   -2.3548   -2.3629   -2.3717   -2.3797   -2.3872   -2.3951   -2.4029   -2.4106   -2.4184   -2.4269   -2.4348   -2.4426   -2.4506   -2.4581   -2.4658   -2.4735   -2.4813   -2.4886   -2.4960   -2.5037   -2.5107   -2.5184   -2.5255   -2.5329   -2.5396   -2.5463   -2.5535   -2.5603   -2.5668   -2.5728   -2.5794   -2.5863   -2.5928   -2.5994   -2.6061   -2.6123   -2.6186   -2.6252   -2.6321   -2.6380   -2.6433   -2.6505   -2.6572   -2.6625   -2.6675   -2.6730   -2.6793   -2.6848   -2.6900   -2.6957   -2.7009   -2.7062   -2.7117   -2.7166   -2.7212   -2.7275   -2.7332
 -0.8262   -0.8369   -0.8482   -0.8596   -0.8708   -0.8816   -0.8924   -0.9033   -0.9150   -0.9263   -0.9378   -0.9492   -0.9611   -0.9738   -0.9859   -0.9975   -1.0093   -1.0219   -1.0335   -1.0451   -1.0578   -1.0696   -1.0820   -1.0939   -1.1056   -1.1177   -1.1295   -1.1407   -1.1530   -1.1655   -1.1775   -1.1892   -1.2007   -1.2120   -1.2241   -1.2362   -1.2486   -1.2603   -1.2726   -1.2850   -1.2962   -1.3094   -1.3209   -1.3328   -1.3445   -1.3559   -1.3682   -1.3798   -1.3916   -1.4038   -1.4152   -1.4273   -1.4391   -1.4507   -1.4621   -1.4735   -1.4851   -1.4969   -1.5081   -1.5190   -1.5317   -1.5432   -1.5548   -1.5662   -1.5773   -1.5888   -1.5997   -1.6115   -1.6223   -1.6332   -1.6451   -1.6566   -1.6678   -1.6790   -1.6899   -1.7011   -1.7117   -1.7225   -1.7336   -1.7447   -1.7551   -1.7660   -1.7767   -1.7871   -1.7974   -1.8088   -1.8201   -1.8313   -1.8419   -1.8526   -1.8634   -1.8736   -1.8846   -1.8953   -1.9060   -1.9162   -1.9268   -1.9369   -1.9473   -1.9574   -1.9679   -1.9780   -1.9880   -1.9984   -2.0083   -2.0187   -2.0288   -2.0384   -2.0481   -2.0582   -2.0680   -2.0774   -2.0879   -2.0976   -2.1063   -2.1165   -2.1262   -2.1359   -2.1451   -2.1543   -2.1642   -2.1739   -2.1834   -2.1925   -2.2018   -2.2113   -2.2198   -2.2278   -2.2369   -2.2455   -2.2548   -2.2637   -2.2720   -2.2811   -2.2900   -2.2988   -2.3072   -2.3158   -2.3250   -2.3340   -2.3427   -2.3510   -2.3598   -2.3683   -2.3768   -2.3845   -2.3926   -2.4008   -2.4088   -2.4161   -2.4237   -2.4317   -2.4394   -2.4472   -2.4555   -2.4639   -2.4715   -2.4793   -2.4864   -2.4945   -2.5019   -2.5099   -2.5175   -2.5251   -2.5327   -2.5395   -2.5460   -2.5533   -2.5604   -2.5670   -2.5736   -2.5807   -2.5874   -2.5937   -2.6009   -2.6075   -2.6140   -2.6204   -2.6270   -2.6320   -2.6383   -2.6442   -2.6500   -2.6556   -2.6621   -2.6676   -2.6742   -2.6799   -2.6873   -2.6927   -2.6988   -2.7043   -2.7097   -2.7150   -2.7198   -2.7262   -2.7313   -2.7363   -2.7414
 -0.8152   -0.8262   -0.8367   -0.8493   -0.8613   -0.8724   -0.8837   -0.8943   -0.9053   -0.9176   -0.9289   -0.9405   -0.9523   -0.9649   -0.9772   -0.9882   -1.0012   -1.0142   -1.0265   -1.0386   -1.0509   -1.0632   -1.0755   -1.0877   -1.0997   -1.1116   -1.1233   -1.1351   -1.1471   -1.1587   -1.1704   -1.1826   -1.1944   -1.2065   -1.2193   -1.2315   -1.2434   -1.2561   -1.2682   -1.2802   -1.2924   -1.3048   -1.3168   -1.3289   -1.3412   -1.3529   -1.3644   -1.3759   -1.3884   -1.4000   -1.4122   -1.4242   -1.4359   -1.4470   -1.4586   -1.4704   -1.4818   -1.4940   -1.5052   -1.5168   -1.5284   -1.5396   -1.5512   -1.5637   -1.5746   -1.5867   -1.5975   -1.6085   -1.6198   -1.6310   -1.6428   -1.6541   -1.6647   -1.6755   -1.6869   -1.6982   -1.7092   -1.7206   -1.7317   -1.7428   -1.7537   -1.7648   -1.7757   -1.7868   -1.7974   -1.8084   -1.8186   -1.8299   -1.8410   -1.8516   -1.8618   -1.8731   -1.8838   -1.8945   -1.9051   -1.9158   -1.9263   -1.9370   -1.9472   -1.9574   -1.9682   -1.9782   -1.9882   -1.9984   -2.0091   -2.0196   -2.0300   -2.0402   -2.0506   -2.0597   -2.0694   -2.0794   -2.0893   -2.0991   -2.1092   -2.1186   -2.1283   -2.1381   -2.1479   -2.1571   -2.1669   -2.1763   -2.1857   -2.1946   -2.2043   -2.2137   -2.2226   -2.2316   -2.2405   -2.2502   -2.2593   -2.2684   -2.2773   -2.2867   -2.2960   -2.3048   -2.3129   -2.3213   -2.3304   -2.3394   -2.3476   -2.3564   -2.3656   -2.3739   -2.3825   -2.3907   -2.3992   -2.4075   -2.4158   -2.4239   -2.4319   -2.4396   -2.4476   -2.4559   -2.4639   -2.4714   -2.4788   -2.4865   -2.4941   -2.5015   -2.5086   -2.5162   -2.5239   -2.5313   -2.5387   -2.5462   -2.5534   -2.5606   -2.5677   -2.5747   -2.5816   -2.5883   -2.5958   -2.6024   -2.6091   -2.6155   -2.6215   -2.6278   -2.6345   -2.6401   -2.6458   -2.6522   -2.6587   -2.6648   -2.6711   -2.6770   -2.6828   -2.6894   -2.6957   -2.7013   -2.7065   -2.7125   -2.7181   -2.7235   -2.7291   -2.7343   -2.7387   -2.7429   -2.7473
 -0.8069   -0.8161   -0.8288   -0.8409   -0.8525   -0.8648   -0.8770   -0.8889   -0.8994   -0.9117   -0.9240   -0.9360   -0.9482   -0.9599   -0.9717   -0.9835   -0.9956   -1.0080   -1.0199   -1.0328   -1.0442   -1.0562   -1.0685   -1.0805   -1.0928   -1.1052   -1.1165   -1.1278   -1.1414   -1.1538   -1.1657   -1.1786   -1.1903   -1.2011   -1.2130   -1.2262   -1.2384   -1.2508   -1.2634   -1.2758   -1.2881   -1.3005   -1.3124   -1.3244   -1.3371   -1.3496   -1.3621   -1.3741   -1.3854   -1.3966   -1.4090   -1.4214   -1.4328   -1.4442   -1.4563   -1.4672   -1.4790   -1.4906   -1.5024   -1.5144   -1.5264   -1.5378   -1.5492   -1.5601   -1.5719   -1.5833   -1.5952   -1.6069   -1.6180   -1.6293   -1.6403   -1.6519   -1.6633   -1.6752   -1.6867   -1.6974   -1.7084   -1.7197   -1.7317   -1.7422   -1.7534   -1.7640   -1.7752   -1.7866   -1.7969   -1.8078   -1.8186   -1.8297   -1.8402   -1.8511   -1.8621   -1.8731   -1.8839   -1.8946   -1.9054   -1.9158   -1.9265   -1.9367   -1.9472   -1.9574   -1.9682   -1.9785   -1.9886   -1.9993   -2.0093   -2.0196   -2.0304   -2.0406   -2.0501   -2.0595   -2.0697   -2.0801   -2.0899   -2.1001   -2.1101   -2.1200   -2.1299   -2.1393   -2.1493   -2.1589   -2.1680   -2.1772   -2.1868   -2.1962   -2.2056   -2.2157   -2.2249   -2.2341   -2.2437   -2.2530   -2.2620   -2.2714   -2.2804   -2.2893   -2.2992   -2.3079   -2.3168   -2.3259   -2.3347   -2.3433   -2.3520   -2.3612   -2.3695   -2.3775   -2.3863   -2.3948   -2.4031   -2.4117   -2.4195   -2.4275   -2.4351   -2.4436   -2.4515   -2.4594   -2.4680   -2.4760   -2.4843   -2.4923   -2.4999   -2.5073   -2.5150   -2.5227   -2.5308   -2.5387   -2.5463   -2.5535   -2.5604   -2.5672   -2.5748   -2.5812   -2.5885   -2.5958   -2.6030   -2.6099   -2.6168   -2.6239   -2.6303   -2.6363   -2.6429   -2.6497   -2.6556   -2.6618   -2.6682   -2.6746   -2.6813   -2.6868   -2.6937   -2.7002   -2.7059   -2.7117   -2.7170   -2.7225   -2.7279   -2.7333   -2.7397   -2.7444   -2.7497   -2.7555   -2.7600
 -0.8026   -0.8139   -0.8255   -0.8376   -0.8491   -0.8610   -0.8728   -0.8852   -0.8967   -0.9084   -0.9199   -0.9320   -0.9436   -0.9559   -0.9681   -0.9800   -0.9919   -1.0039   -1.0158   -1.0276   -1.0393   -1.0519   -1.0642   -1.0763   -1.0885   -1.1007   -1.1129   -1.1245   -1.1367   -1.1497   -1.1625   -1.1746   -1.1869   -1.1993   -1.2120   -1.2247   -1.2369   -1.2492   -1.2618   -1.2733   -1.2855   -1.2967   -1.3090   -1.3213   -1.3333   -1.3461   -1.3587   -1.3707   -1.3828   -1.3945   -1.4059   -1.4173   -1.4296   -1.4415   -1.4525   -1.4646   -1.4762   -1.4879   -1.4990   -1.5103   -1.5216   -1.5338   -1.5460   -1.5575   -1.5691   -1.5809   -1.5922   -1.6037   -1.6148   -1.6264   -1.6378   -1.6489   -1.6607   -1.6723   -1.6840   -1.6953   -1.7065   -1.7177   -1.7291   -1.7408   -1.7516   -1.7626   -1.7735   -1.7845   -1.7957   -1.8067   -1.8173   -1.8283   -1.8391   -1.8501   -1.8608   -1.8717   -1.8826   -1.8934   -1.9049   -1.9156   -1.9259   -1.9364   -1.9470   -1.9574   -1.9681   -1.9784   -1.9886   -1.9989   -2.0090   -2.0194   -2.0301   -2.0407   -2.0510   -2.0613   -2.0713   -2.0817   -2.0922   -2.1021   -2.1122   -2.1223   -2.1319   -2.1417   -2.1516   -2.1612   -2.1711   -2.1808   -2.1906   -2.1995   -2.2091   -2.2187   -2.2281   -2.2376   -2.2470   -2.2564   -2.2657   -2.2753   -2.2840   -2.2932   -2.3020   -2.3108   -2.3191   -2.3290   -2.3381   -2.3467   -2.3566   -2.3657   -2.3744   -2.3835   -2.3918   -2.4005   -2.4090   -2.4167   -2.4251   -2.4331   -2.4420   -2.4505   -2.4583   -2.4662   -2.4744   -2.4821   -2.4904   -2.4980   -2.5063   -2.5144   -2.5221   -2.5298   -2.5374   -2.5451   -2.5529   -2.5598   -2.5671   -2.5736   -2.5809   -2.5880   -2.5960   -2.6032   -2.6102   -2.6175   -2.6242   -2.6319   -2.6385   -2.6452   -2.6523   -2.6593   -2.6664   -2.6721   -2.6788   -2.6855   -2.6922   -2.6975   -2.7039   -2.7100   -2.7161   -2.7217   -2.7276   -2.7336   -2.7403   -2.7461   -2.7521   -2.7569   -2.7625   -2.7688   -2.7754
 -0.7954   -0.8073   -0.8185   -0.8309   -0.8441   -0.8564   -0.8688   -0.8806   -0.8924   -0.9052   -0.9175   -0.9293   -0.9417   -0.9535   -0.9655   -0.9778   -0.9907   -1.0032   -1.0154   -1.0270   -1.0392   -1.0513   -1.0637   -1.0758   -1.0881   -1.1003   -1.1127   -1.1254   -1.1373   -1.1501   -1.1630   -1.1751   -1.1881   -1.2003   -1.2127   -1.2247   -1.2364   -1.2486   -1.2605   -1.2723   -1.2847   -1.2968   -1.3085   -1.3206   -1.3322   -1.3444   -1.3562   -1.3683   -1.3802   -1.3927   -1.4042   -1.4157   -1.4275   -1.4396   -1.4515   -1.4628   -1.4748   -1.4864   -1.4980   -1.5101   -1.5212   -1.5328   -1.5446   -1.5569   -1.5688   -1.5811   -1.5920   -1.6034   -1.6149   -1.6269   -1.6386   -1.6505   -1.6618   -1.6738   -1.6847   -1.6959   -1.7069   -1.7186   -1.7295   -1.7406   -1.7515   -1.7627   -1.7742   -1.7854   -1.7967   -1.8076   -1.8185   -1.8291   -1.8396   -1.8501   -1.8611   -1.8717   -1.8822   -1.8932   -1.9043   -1.9151   -1.9259   -1.9362   -1.9467   -1.9574   -1.9683   -1.9786   -1.9884   -1.9996   -2.0101   -2.0202   -2.0299   -2.0410   -2.0517   -2.0613   -2.0720   -2.0825   -2.0933   -2.1030   -2.1135   -2.1233   -2.1332   -2.1430   -2.1525   -2.1626   -2.1715   -2.1806   -2.1909   -2.2003   -2.2097   -2.2194   -2.2288   -2.2383   -2.2482   -2.2568   -2.2655   -2.2757   -2.2853   -2.2948   -2.3039   -2.3131   -2.3226   -2.3318   -2.3408   -2.3499   -2.3590   -2.3676   -2.3765   -2.3854   -2.3941   -2.4024   -2.4105   -2.4189   -2.4273   -2.4358   -2.4442   -2.4529   -2.4618   -2.4696   -2.4785   -2.4860   -2.4936   -2.5015   -2.5097   -2.5179   -2.5259   -2.5333   -2.5412   -2.5489   -2.5570   -2.5642   -2.5720   -2.5797   -2.5880   -2.5955   -2.6027   -2.6097   -2.6173   -2.6235   -2.6311   -2.6384   -2.6455   -2.6526   -2.6596   -2.6657   -2.6725   -2.6795   -2.6859   -2.6925   -2.6984   -2.7049   -2.7112   -2.7182   -2.7246   -2.7318   -2.7386   -2.7447   -2.7517   -2.7567   -2.7634   -2.7695   -2.7746   -2.7807   -2.7868
 -0.7913   -0.8032   -0.8156   -0.8277   -0.8403   -0.8518   -0.8637   -0.8752   -0.8881   -0.8992   -0.9113   -0.9236   -0.9372   -0.9501   -0.9624   -0.9741   -0.9859   -0.9983   -1.0105   -1.0222   -1.0341   -1.0465   -1.0590   -1.0719   -1.0842   -1.0960   -1.1082   -1.1212   -1.1335   -1.1458   -1.1581   -1.1705   -1.1826   -1.1956   -1.2076   -1.2199   -1.2324   -1.2442   -1.2567   -1.2693   -1.2811   -1.2932   -1.3056   -1.3181   -1.3299   -1.3418   -1.3537   -1.3658   -1.3772   -1.3892   -1.4014   -1.4132   -1.4250   -1.4375   -1.4488   -1.4605   -1.4727   -1.4843   -1.4971   -1.5092   -1.5215   -1.5337   -1.5452   -1.5571   -1.5685   -1.5802   -1.5916   -1.6025   -1.6136   -1.6252   -1.6365   -1.6485   -1.6601   -1.6714   -1.6833   -1.6946   -1.7062   -1.7176   -1.7294   -1.7405   -1.7512   -1.7621   -1.7734   -1.7842   -1.7952   -1.8063   -1.8167   -1.8279   -1.8388   -1.8502   -1.8615   -1.8718   -1.8831   -1.8937   -1.9044   -1.9151   -1.9262   -1.9361   -1.9468   -1.9574   -1.9683   -1.9789   -1.9894   -2.0000   -2.0101   -2.0204   -2.0310   -2.0409   -2.0511   -2.0621   -2.0725   -2.0825   -2.0928   -2.1027   -2.1129   -2.1232   -2.1330   -2.1423   -2.1518   -2.1618   -2.1720   -2.1814   -2.1915   -2.2007   -2.2105   -2.2207   -2.2303   -2.2401   -2.2495   -2.2597   -2.2689   -2.2788   -2.2886   -2.2980   -2.3069   -2.3157   -2.3252   -2.3343   -2.3433   -2.3526   -2.3621   -2.3716   -2.3807   -2.3892   -2.3984   -2.4077   -2.4169   -2.4255   -2.4333   -2.4411   -2.4499   -2.4586   -2.4670   -2.4749   -2.4837   -2.4920   -2.5002   -2.5081   -2.5157   -2.5240   -2.5320   -2.5403   -2.5487   -2.5565   -2.5648   -2.5729   -2.5796   -2.5872   -2.5954   -2.6028   -2.6109   -2.6177   -2.6251   -2.6328   -2.6412   -2.6483   -2.6562   -2.6644   -2.6716   -2.6779   -2.6848   -2.6916   -2.6985   -2.7046   -2.7114   -2.7187   -2.7256   -2.7313   -2.7379   -2.7449   -2.7518   -2.7578   -2.7640   -2.7699   -2.7759   -2.7822   -2.7876   -2.7928   -2.7980
 -0.7842   -0.7962   -0.8099   -0.8223   -0.8350   -0.8470   -0.8587   -0.8713   -0.8831   -0.8954   -0.9077   -0.9202   -0.9327   -0.9455   -0.9582   -0.9704   -0.9829   -0.9964   -1.0089   -1.0211   -1.0336   -1.0460   -1.0581   -1.0704   -1.0821   -1.0939   -1.1069   -1.1193   -1.1309   -1.1436   -1.1560   -1.1686   -1.1813   -1.1938   -1.2064   -1.2193   -1.2315   -1.2428   -1.2550   -1.2670   -1.2796   -1.2918   -1.3036   -1.3160   -1.3284   -1.3400   -1.3523   -1.3645   -1.3759   -1.3881   -1.3997   -1.4111   -1.4231   -1.4357   -1.4476   -1.4599   -1.4724   -1.4839   -1.4960   -1.5079   -1.5200   -1.5320   -1.5438   -1.5552   -1.5669   -1.5788   -1.5900   -1.6013   -1.6128   -1.6241   -1.6359   -1.6474   -1.6597   -1.6711   -1.6824   -1.6928   -1.7046   -1.7161   -1.7271   -1.7384   -1.7495   -1.7614   -1.7726   -1.7841   -1.7953   -1.8062   -1.8174   -1.8285   -1.8396   -1.8507   -1.8613   -1.8720   -1.8826   -1.8932   -1.9043   -1.9147   -1.9254   -1.9358   -1.9468   -1.9574   -1.9684   -1.9787   -1.9889   -2.0005   -2.0112   -2.0220   -2.0321   -2.0426   -2.0536   -2.0636   -2.0738   -2.0839   -2.0938   -2.1044   -2.1143   -2.1241   -2.1342   -2.1443   -2.1541   -2.1640   -2.1749   -2.1844   -2.1943   -2.2038   -2.2132   -2.2230   -2.2327   -2.2426   -2.2528   -2.2625   -2.2712   -2.2812   -2.2911   -2.3010   -2.3106   -2.3195   -2.3292   -2.3379   -2.3471   -2.3573   -2.3659   -2.3750   -2.3841   -2.3938   -2.4026   -2.4117   -2.4210   -2.4301   -2.4385   -2.4471   -2.4567   -2.4652   -2.4748   -2.4830   -2.4917   -2.5000   -2.5082   -2.5159   -2.5245   -2.5325   -2.5415   -2.5498   -2.5582   -2.5669   -2.5755   -2.5834   -2.5910   -2.5995   -2.6067   -2.6142   -2.6221   -2.6304   -2.6381   -2.6457   -2.6542   -2.6609   -2.6686   -2.6762   -2.6834   -2.6910   -2.6975   -2.7042   -2.7119   -2.7191   -2.7256   -2.7322   -2.7390   -2.7461   -2.7524   -2.7592   -2.7661   -2.7724   -2.7783   -2.7844   -2.7900   -2.7972   -2.8037   -2.8104   -2.8173
 -0.7798   -0.7926   -0.8056   -0.8184   -0.8311   -0.8431   -0.8559   -0.8674   -0.8795   -0.8921   -0.9054   -0.9176   -0.9296   -0.9417   -0.9543   -0.9673   -0.9790   -0.9905   -1.0037   -1.0163   -1.0294   -1.0423   -1.0547   -1.0676   -1.0808   -1.0932   -1.1061   -1.1182   -1.1298   -1.1418   -1.1536   -1.1659   -1.1795   -1.1918   -1.2045   -1.2160   -1.2284   -1.2411   -1.2537   -1.2660   -1.2781   -1.2905   -1.3029   -1.3153   -1.3270   -1.3391   -1.3511   -1.3631   -1.3758   -1.3876   -1.3998   -1.4113   -1.4230   -1.4359   -1.4479   -1.4594   -1.4711   -1.4831   -1.4949   -1.5065   -1.5182   -1.5295   -1.5410   -1.5521   -1.5640   -1.5760   -1.5875   -1.5992   -1.6107   -1.6225   -1.6340   -1.6459   -1.6572   -1.6691   -1.6806   -1.6930   -1.7040   -1.7156   -1.7270   -1.7383   -1.7500   -1.7617   -1.7728   -1.7840   -1.7952   -1.8067   -1.8177   -1.8288   -1.8392   -1.8498   -1.8606   -1.8711   -1.8826   -1.8934   -1.9040   -1.9152   -1.9256   -1.9357   -1.9468   -1.9574   -1.9684   -1.9791   -1.9897   -1.9999   -2.0104   -2.0210   -2.0312   -2.0422   -2.0523   -2.0625   -2.0730   -2.0831   -2.0928   -2.1031   -2.1136   -2.1243   -2.1352   -2.1454   -2.1555   -2.1655   -2.1758   -2.1855   -2.1962   -2.2062   -2.2159   -2.2257   -2.2359   -2.2451   -2.2544   -2.2636   -2.2741   -2.2837   -2.2933   -2.3032   -2.3131   -2.3225   -2.3321   -2.3415   -2.3509   -2.3604   -2.3697   -2.3790   -2.3884   -2.3976   -2.4065   -2.4153   -2.4242   -2.4327   -2.4417   -2.4513   -2.4602   -2.4690   -2.4772   -2.4862   -2.4951   -2.5039   -2.5119   -2.5215   -2.5300   -2.5384   -2.5471   -2.5563   -2.5650   -2.5737   -2.5826   -2.5901   -2.5980   -2.6066   -2.6142   -2.6227   -2.6304   -2.6388   -2.6463   -2.6541   -2.6618   -2.6698   -2.6780   -2.6849   -2.6923   -2.6994   -2.7073   -2.7145   -2.7216   -2.7287   -2.7357   -2.7430   -2.7505   -2.7578   -2.7648   -2.7721   -2.7797   -2.7861   -2.7942   -2.8002   -2.8061   -2.8130   -2.8197   -2.8257   -2.8317
 -0.7767   -0.7895   -0.8007   -0.8133   -0.8259   -0.8373   -0.8498   -0.8628   -0.8758   -0.8884   -0.9009   -0.9131   -0.9258   -0.9388   -0.9517   -0.9648   -0.9774   -0.9898   -1.0023   -1.0144   -1.0272   -1.0410   -1.0535   -1.0661   -1.0779   -1.0906   -1.1030   -1.1160   -1.1280   -1.1402   -1.1531   -1.1651   -1.1772   -1.1895   -1.2021   -1.2147   -1.2267   -1.2392   -1.2515   -1.2634   -1.2756   -1.2882   -1.2994   -1.3109   -1.3230   -1.3354   -1.3475   -1.3597   -1.3717   -1.3834   -1.3952   -1.4076   -1.4193   -1.4315   -1.4435   -1.4555   -1.4676   -1.4799   -1.4912   -1.5034   -1.5150   -1.5271   -1.5390   -1.5507   -1.5627   -1.5738   -1.5856   -1.5975   -1.6092   -1.6209   -1.6325   -1.6440   -1.6560   -1.6679   -1.6798   -1.6914   -1.7033   -1.7149   -1.7264   -1.7379   -1.7494   -1.7611   -1.7722   -1.7833   -1.7947   -1.8061   -1.8173   -1.8283   -1.8388   -1.8499   -1.8606   -1.8708   -1.8819   -1.8927   -1.9033   -1.9146   -1.9253   -1.9357   -1.9467   -1.9574   -1.9685   -1.9793   -1.9895   -2.0004   -2.0108   -2.0215   -2.0322   -2.0425   -2.0526   -2.0632   -2.0737   -2.0832   -2.0936   -2.1046   -2.1152   -2.1249   -2.1351   -2.1452   -2.1559   -2.1665   -2.1771   -2.1875   -2.1977   -2.2077   -2.2181   -2.2281   -2.2374   -2.2470   -2.2565   -2.2661   -2.2756   -2.2854   -2.2949   -2.3046   -2.3145   -2.3244   -2.3346   -2.3440   -2.3539   -2.3635   -2.3729   -2.3821   -2.3917   -2.4005   -2.4102   -2.4193   -2.4289   -2.4380   -2.4475   -2.4572   -2.4656   -2.4750   -2.4844   -2.4930   -2.5024   -2.5113   -2.5201   -2.5287   -2.5384   -2.5471   -2.5558   -2.5643   -2.5728   -2.5816   -2.5905   -2.5985   -2.6070   -2.6153   -2.6235   -2.6321   -2.6407   -2.6489   -2.6570   -2.6643   -2.6729   -2.6811   -2.6894   -2.6969   -2.7040   -2.7123   -2.7203   -2.7279   -2.7354   -2.7435   -2.7513   -2.7586   -2.7651   -2.7725   -2.7796   -2.7872   -2.7939   -2.8010   -2.8078   -2.8143   -2.8218   -2.8296   -2.8358   -2.8433   -2.8494
 -0.7719   -0.7852   -0.7978   -0.8102   -0.8220   -0.8348   -0.8471   -0.8599   -0.8724   -0.8848   -0.8982   -0.9116   -0.9240   -0.9376   -0.9509   -0.9637   -0.9767   -0.9889   -1.0014   -1.0144   -1.0270   -1.0393   -1.0526   -1.0643   -1.0779   -1.0902   -1.1029   -1.1154   -1.1275   -1.1395   -1.1527   -1.1653   -1.1771   -1.1894   -1.2017   -1.2147   -1.2269   -1.2392   -1.2520   -1.2643   -1.2774   -1.2886   -1.3013   -1.3131   -1.3248   -1.3375   -1.3494   -1.3617   -1.3735   -1.3853   -1.3976   -1.4096   -1.4217   -1.4334   -1.4467   -1.4592   -1.4712   -1.4828   -1.4946   -1.5061   -1.5181   -1.5305   -1.5421   -1.5532   -1.5648   -1.5766   -1.5877   -1.5998   -1.6115   -1.6228   -1.6342   -1.6460   -1.6570   -1.6683   -1.6795   -1.6913   -1.7034   -1.7148   -1.7260   -1.7372   -1.7491   -1.7603   -1.7712   -1.7822   -1.7942   -1.8055   -1.8163   -1.8275   -1.8389   -1.8497   -1.8603   -1.8708   -1.8811   -1.8924   -1.9035   -1.9143   -1.9248   -1.9358   -1.9465   -1.9574   -1.9685   -1.9786   -1.9896   -2.0003   -2.0110   -2.0212   -2.0316   -2.0424   -2.0524   -2.0631   -2.0736   -2.0834   -2.0934   -2.1042   -2.1148   -2.1248   -2.1350   -2.1451   -2.1554   -2.1656   -2.1753   -2.1856   -2.1957   -2.2059   -2.2158   -2.2258   -2.2356   -2.2458   -2.2559   -2.2665   -2.2758   -2.2862   -2.2961   -2.3061   -2.3154   -2.3258   -2.3354   -2.3448   -2.3548   -2.3642   -2.3743   -2.3839   -2.3935   -2.4029   -2.4127   -2.4225   -2.4319   -2.4412   -2.4501   -2.4596   -2.4687   -2.4779   -2.4872   -2.4969   -2.5063   -2.5151   -2.5238   -2.5323   -2.5413   -2.5498   -2.5582   -2.5674   -2.5764   -2.5846   -2.5931   -2.6018   -2.6107   -2.6196   -2.6283   -2.6370   -2.6464   -2.6542   -2.6623   -2.6712   -2.6788   -2.6872   -2.6945   -2.7031   -2.7104   -2.7183   -2.7266   -2.7350   -2.7432   -2.7510   -2.7593   -2.7665   -2.7739   -2.7813   -2.7887   -2.7954   -2.8024   -2.8106   -2.8192   -2.8266   -2.8343   -2.8416   -2.8496   -2.8568   -2.8644
 -0.7708   -0.7843   -0.7969   -0.8099   -0.8234   -0.8350   -0.8476   -0.8598   -0.8729   -0.8855   -0.8979   -0.9109   -0.9243   -0.9379   -0.9505   -0.9641   -0.9766   -0.9890   -1.0024   -1.0141   -1.0268   -1.0394   -1.0512   -1.0638   -1.0769   -1.0894   -1.1026   -1.1154   -1.1281   -1.1409   -1.1533   -1.1663   -1.1790   -1.1910   -1.2034   -1.2157   -1.2278   -1.2400   -1.2526   -1.2652   -1.2778   -1.2902   -1.3022   -1.3147   -1.3266   -1.3386   -1.3514   -1.3633   -1.3758   -1.3882   -1.4002   -1.4119   -1.4242   -1.4353   -1.4472   -1.4589   -1.4707   -1.4832   -1.4950   -1.5067   -1.5188   -1.5300   -1.5414   -1.5536   -1.5655   -1.5775   -1.5892   -1.6012   -1.6126   -1.6236   -1.6349   -1.6470   -1.6581   -1.6692   -1.6810   -1.6928   -1.7036   -1.7146   -1.7255   -1.7367   -1.7483   -1.7602   -1.7710   -1.7826   -1.7935   -1.8051   -1.8163   -1.8278   -1.8383   -1.8497   -1.8599   -1.8704   -1.8808   -1.8916   -1.9031   -1.9135   -1.9245   -1.9354   -1.9464   -1.9574   -1.9686   -1.9792   -1.9898   -2.0009   -2.0112   -2.0220   -2.0322   -2.0426   -2.0532   -2.0631   -2.0729   -2.0832   -2.0936   -2.1037   -2.1142   -2.1242   -2.1347   -2.1446   -2.1548   -2.1654   -2.1759   -2.1858   -2.1956   -2.2061   -2.2165   -2.2263   -2.2357   -2.2457   -2.2552   -2.2647   -2.2745   -2.2849   -2.2950   -2.3049   -2.3146   -2.3239   -2.3345   -2.3442   -2.3537   -2.3639   -2.3744   -2.3840   -2.3934   -2.4031   -2.4130   -2.4229   -2.4330   -2.4426   -2.4513   -2.4600   -2.4690   -2.4786   -2.4877   -2.4968   -2.5059   -2.5149   -2.5237   -2.5328   -2.5419   -2.5506   -2.5601   -2.5688   -2.5771   -2.5854   -2.5941   -2.6029   -2.6121   -2.6199   -2.6286   -2.6367   -2.6453   -2.6536   -2.6618   -2.6693   -2.6780   -2.6862   -2.6951   -2.7030   -2.7115   -2.7201   -2.7279   -2.7360   -2.7435   -2.7513   -2.7595   -2.7679   -2.7760   -2.7838   -2.7906   -2.7983   -2.8070   -2.8151   -2.8227   -2.8297   -2.8381   -2.8466   -2.8545   -2.8612   -2.8679
];

switch table
    case 1
        cv=cv25(row,column);
    case 2
        cv=cv5(row,column);
    case 3
        cv=cv95(row,column);
    case 4
        cv=cv975(row,column);
end

end
