function [y_ol,x_ol]=overlap(y,x,q);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PURPOSE:  Creates overlapping data for the regression model
%
%   y(t+1:t+q) = beta*x(t) + u(t+1:t+q)
%							
% INPUT:	x           (T x 1)                     
%           y           (T x 1)                     
%           q           (1 x 1)
%
% OUTPUT:	x_ol       ((T-q+1) x 1)              
%           y_ol       ((T-q+1) x 1)    
%
% AUTHOR:	Erik Hjalmarsson (erik.hjalmarsson@frb.gov)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[T,k] = size(x);

if q > 1;
    y_ol = zeros(T-q+1,1);
    x_ol = zeros(T-q+1,k);
    for i=q:T;
            x_ol(i-q+1,:)  = sum(x(i-q+1:i,:));    
            y_ol(i-q+1)  = sum(y(i-q+1:i));
    end;
else; y_ol = y; x_ol = x;
end;