%This function calculates the bootstrapped scaled t-statistic from the
%data. The size of the bootstrap sample is B.

function [pvalue,pvalue_2sided,b_dist]=bootstrap_t(y,x,q,B,method,p)
    
    if nargin < 6
        p=1;
    end
    
    if nargin < 5
        method='normal';
    end
    [~,t_data_unscaled]=OLS_OL(y,x,q);

    
    b_dist = zeros(B,1);
    [T,m]=size(x);
    if m>1
        disp('error: too many variables')
        return
    end
    [Aprim,Q,~,v,const_x]=varpest(x,p,1);
     A_bc=ar_bc(Aprim,T);
     A=A_bc';       
     scale_data=sqrt(scaling_factor_general(q,yule_walker(A,Q,q))); 
     t_scaled_data=t_data_unscaled/scale_data;
     
    %[~,~,~,~,~,u]=OLS_OL(y,x,1);
    alpha=mean(y);
    u=y-mean(y);
    
    %beta=zeros(m,1); %Bootstrap under the null
    
    len=min(length(v(:,1)),length(u));
    est_resid=[v((end-len+1):end,:) u((end-len+1):end)];

    for b=1:B
        [resid_b]=draw_sample(est_resid,T,method);
        v_b=resid_b(:,1:m);
        u_b=resid_b(2:end,end);
        x_b_comp=zeros(T,m*p);
        x_b_comp(p,:)=comp_init(x,p);
        comp_A=comp(A);
        const_x_comp=zeros(m*p,1);
        const_x_comp(1:m)=const_x;
        for i=(p+1):T
            v_comp=zeros(m*p,1);
            v_comp(1:m)=v_b(i,:)';
            x_b_comp(i,:) = (const_x_comp+comp_A*x_b_comp(i-1,:)'+ v_comp)';
        end
        x_b=x_b_comp(:,1:m);
        y_b = alpha + u_b; 
        x_b = x_b(2:T,:); 
        
        [A_b,Q_b]=varpest(x_b,p);
        A_bc_b=ar_bc(A_b,T);           
        scale_b=sqrt(scaling_factor_general(q,yule_walker(A_bc_b',Q_b,q)));
       [~,tstat_b]=OLS_OL(y_b,x_b,q);
        b_dist(b)=tstat_b/scale_b;
    end
pvalue=sum(b_dist>t_scaled_data)/B;
pvalue_2sided=sum(abs(b_dist)>abs(t_scaled_data))/B;
end

function sample_b=draw_sample(resid,T,method)
if nargin < 3
    method = 'normal';
end

[T_in,~]=size(resid);

if strcmp(method,'wild')
   indep_u=((1-sqrt(5))/2)*ones(T,1)+sqrt(5)*(rand(T,1)<(sqrt(5)-1)/(2*sqrt(5)));
   sample_b=indep_u.*resid(randi([1 T_in],T,1),:);
else
   sample_b=resid(randi([1 T_in],T,1),:);
end
    

end

function Acomp=comp(A)
    [n,np] = size(A);

    p=np/n;
    Acomp=zeros(np,np);
    Acomp(1:n,:)=A;
    Acomp(n+1:end,1:(end-n))=eye(n*(p-1));
    
end

function Xcomp_init=comp_init(x,p)
    [T,n] =size(x);
    Xcomp_init=zeros(1,p*n);
    for j=1:p
        Xcomp_init(1+(j-1)*n:j*n)=x(p-j+1,:);
    end
end
