function [beta,t_stat,R2,sigma,xxi,resid]=OLS_OL(y,x,q);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PURPOSE:  Estimates the predictive overlapping observation regression
% model, reporting non-scaled t-statistic:
%
%   y(t+1:t+q) = alpha + beta*x(t) + u(t+1:t+q)
%							
% INPUT:	x           (T x 1)                     
%           y           (T x 1)                     
%           q           (1 x 1)
%
% OUTPUT:	beta        (1 x 1)              
%           t_stat      (1 x 1)   
%           R2          (1 x 1)   
%
% AUTHOR:	Erik Hjalmarsson (erik.hjalmarsson@frb.gov)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

T = rows(y);
m = length(x(1,:));
%y = y - mean(y);  
%x = x - mean(x);  
[y_ol,x_ol] = overlap(y,x,q);
T_ol = rows(y_ol);
y_ol = y_ol(2:T_ol); 
T_ol = rows(y_ol);
x = x(1:T-q,:);

y_ol =y_ol-mean(y_ol);
x=x-mean(x);

xxi = invpd(x'*x);
beta = xxi*x'*y_ol;  
resid = y_ol - x*beta;
SSR = resid'*resid;
sigma = inv(T_ol-m-1)*SSR;
t_stat = beta./(sqrt(diag(sigma*xxi))); 
R2 = 1 - SSR/sum(y_ol.^2);
