%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

% trim auctions for asymmetric APV case

function [keep,trim] = trimasymmetricCPV(data,low,high,hG,hg)


% ids are in third column of data
idcol = 3;
% log bids are in fourth column of data
bidcol = 4;

uniqueids = unique(data(:,idcol));

keep = [];
trim = [];

for i=1:length(uniqueids)
    test = 0;
    aucid = uniqueids(i);
    ind = data((data(:,idcol) == aucid),:);
    if size(ind,1) ~= 1
        fprintf('Error not one bid at asymmetric auction\n')
    end
    if ind(1,bidcol) >= (low + max(hG,hg))
        if ind(1,bidcol) <= (high - max(hG,hg))
        else
            test = 1;
            %fprintf('Trimming at upper end\n')
        end
    else
        test = 1;
        %fprintf('Trimming at lower end\n')
    end
    if test == 0
        keep = [keep; ind];
    else
        trim = [trim; ind];
    end
end