%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

trimid = [
     1
     3
     4
     5
     7
     9
    10
    11
    12
    13
    14
    17
    19
    20
    23
    25
    26
    29
    40
    41
    45
    46
    47
    48
    51
    53
    55
    56
    58
    59
    62
    64
    66
    75
    80
    81
    82
    83
    84
    87
    89
    91
    92
    93
    94
    96
   100
   107
   108
   109
   110
   111
   112
   114
   117
   118
   119
   120
   121
   124
   125
   126
   127
   128
   129
   131
   132
   133
   134
   135
   136
   137
   138
   139
   140
   141
   143
   144
   145
   147
   148
   149
   150
   151
   152
   153
   154
   157
   158
   159
   162
   163
   164
   166
   168
   175
   176
   177
   178
   179
   180
   182
   183
   184
   185
   186
   187
   188
   191
   194
   195
   197
   204
   210
   212
   214
   216
   219
   222
   225
   226
   227];

cpvtrimid = [
     3
     5
    17
    23
    25
    45
    47
    53
    55
    56
    75
    80
    83
    84
    92
    93
   110
   148
   153
   180
   183
   191
   210
   214
   219
   226
   227];

if sum(ismember(cpvtrimid,trimid)) == length(cpvtrimid)
    fprintf('All auctions trimmed under CPV are trimmed in truth too.\n')
else
    fprintf('Some auctions trimmed under CPV are NOT trimmed in truth.\n')
end


rand('state',819);

comparefig = figure
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
box on
hold on
% this just sets legend order in an easy way
scatter(0,0,'.b')
scatter(0,0,'xr')
scatter(0,0,'sk')
for i=1:T
    ind = alldata((alldata(:,3) == i),:);
    if size(ind,1) ~= 2
        fprintf('Error in auction ID assignemnt\n')
    end
    % this just makes plot look nicer---data are organized with higher bid
    % in first row and lower bid in second so plot is all below 45 degree
    % line, this adjust for it
    u = rand(1);
    if u > .5
        ind2 = [ind(2,:); ind(1,:)];
        ind = ind2;
    end
    ptsize = 150;
    if ismember(i,cpvtrimid)
        scatter(ind(1,4),ind(2,4),'xr','SizeData',ptsize)
        scatter(ind(1,4),ind(2,4),'sk','SizeData',ptsize)
    elseif ismember(i,trimid)
        scatter(ind(1,4),ind(2,4),'sk','SizeData',ptsize)
        scatter(ind(1,4),ind(2,4),'.b','SizeData',ptsize)
    else
        scatter(ind(1,4),ind(2,4),'.b','SizeData',ptsize)
    end
end
box on
xlabel('$\mathbf{log(1 + b_i)}$','FontSize',20)
ylabel('$\mathbf{log(1 + b_j)}$','FontSize',20)
axis([2 10 2 10])
hh = legend('SURVIVE CPV','CPV TRIM','$b_i\ or\ b_j\in[\underline{b},\underline{b}+h_b]\cup[\overline{b}-h_b,\overline{b}]$', ...
    'Location','NorthOutside','Orientation','horizontal')
set(hh,'box','off','Xcolor',[1 1 1],'Ycolor',[1 1 1],'FontSize',16);
if (exist('saverun','var'))
    if saverun == 1
        fname = strcat(outfolder,'trim_scatter');
        fnameeps = strcat(fname,'.eps');
        print('-depsc',fnameeps)
    end
end
