%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

% produced kernel smoothed estimates of data vector obs at points evalgrid

function [f,h,evalgrid] = kspdf_no_bc_CPV(obs,kernel,evalgrid,fullsampsize, ...
	usehardle)

n = length(obs);
if nargin >= 4
	n = fullsampsize;
end


% defaults should user pass only 1 or only 2 arguments
if (nargin == 1)
    evalgrid = linspace(min(obs),max(obs),100);
    kernel = 'gaussian';
elseif (nargin == 2)
    kernel = 'gaussian';
end

% use Hardle's (1991) bandwidth transformation constant
c = 1;
if (isequal(kernel,'gaussian') == 1)
    c = 1;
elseif (isequal(kernel,'epanechnikov') == 1)
    c = 2.214;
elseif (isequal(kernel,'triweight') == 1)
    c = 2.978;
elseif (isequal(kernel,'uniform') == 1)
    c = 1.740;
elseif (isequal(kernel,'triangle') == 1)
    c = 2.432;
elseif (isequal(kernel,'cosinus') == 1)
    c = 2.288;
elseif (isequal(kernel,'quartic') == 1)
    c = 2.623;
end

% use Silverman's (1986) optimal bandwidth
if (exist('usehardle','var'))
	if usehardle == 0
		c = 1;
	elseif usehardle == 1
		c = c;
	end
end
h = c*(1.06)*std(obs)*(n)^(-1/5);

T = length(evalgrid);
% for density = 0 rule beyond min and max observations
maxobs = max(obs);
minobs = min(obs);
for t=1:T
    u = (evalgrid(t) - obs)/h;
	k = evalkspdf(u,kernel);
	f(t) = sum(k);
    % for density = 0 rule beyond min and max observations
    if (evalgrid(t) > maxobs) || (evalgrid(t) < minobs)
        f(t) = 0;
    end
end
f = f./(n*h);