%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

% compute two dimensional kernel density given data (required) and points
% to evaluate densities at (optional).  the kernel choice is also optional
% with the default being the gaussian kernel

function [fhat,hx,hy] = kspdf2dCPVbc(obsx,obsy,evalx,evaly,kernel,b0, ...
    minasym,maxasym)

nx = length(obsx);
ny = length(obsy);
if nx ~= ny
    fprintf('Error - lengths of data vectors differ\n')
end

% if points to evaluate kernels at or kernel not specified use defaults
if nargin == 2
    npts = 100;
    evalx = linspace(min(obsx),max(obsx),npts);
    evaly = linspace(min(obsy),max(obsy),npts);
    kernel = 'gaussian';
elseif nargin == 4
    kernel = 'gaussian';
end

if (exist('minasym','var'))
    [kx,hx] = kzroutine(obsx,evalx,kernel,b0,minasym);
    kxright = kzroutine(-obsx,-evalx,kernel,b0,-maxasym);
    % replace values near right boundary with right-corrected values
    rightindx = find(obsx >= max(obsx) - hx);
    kx(rightindx) = kxright(rightindx);
    
    [ky,hy] = kzroutine(obsy,evaly,kernel,b0,minasym);
    kyright = kzroutine(-obsy,-evaly,kernel,b0,-maxasym);
    % replace values near right boundary with right-corrected values
    rightindy = find(obsy >= max(obsy) - hy);
    ky(rightindy) = kyright(rightindy);
else
    [kx,hx] = kzroutine(obsx,evalx,kernel,b0);
    kxright = kzroutine(-obsx,-evalx,kernel,b0);
    % replace values near right boundary with right-corrected values
    rightindx = find(obsx >= max(obsx) - hx);
    kx(rightindx) = kxright(rightindx);
    
    [ky,hy] = kzroutine(obsy,evaly,kernel,b0);
    kyright = kzroutine(-obsy,-evaly,kernel,b0);
    % replace values near right boundary with right-corrected values
    rightindy = find(obsy >= max(obsy) - hy);
    ky(rightindy) = kyright(rightindy);
end

kprod = kx.*ky;
kprod = kprod';
fhat = sum(kprod)./(nx*hx*hy);