%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

% compute two dimensional kernel cdf given data (required) and points to
% evaluate edf at (optional).  the kernel choice is also optional with the
% default being the gaussian kernel 

function [Fhat,hy] = kscdf2dCPVbc(obsx,obsy,evalx,evaly,kernel,b0)

nx = length(obsx);
ny = length(obsy);
if nx ~= ny
    fprintf('Error - lengths of data vectors differ\n')
end

% if points to evaluate kernels at or kernel not specified use defaults
if nargin == 2
    npts = 100;
    evalx = linspace(min(obsx),max(obsx),npts);
    evaly = linspace(min(obsy),max(obsy),npts);
    kernel = 'gaussian';
elseif nargin == 4
    kernel = 'gaussian';
end
nevalx = length(evalx);

[ky,hy] = kzroutine(obsy,evaly,kernel,b0);
kyright = kzroutine(-obsy,-evaly,kernel,b0);
% replace values near right boundary with right-corrected values
rightindy = find(obsy >= max(obsy) - hy);
ky(rightindy) = kyright(rightindy);



% get matrix for first item in data
for i=1:nevalx
    indx(i,:) = (obsx <= evalx(i));
end


% add up product of kernels over data observations
kprod = indx.*ky;
kprod = kprod';
Fhat = sum(kprod)./(nx*hy);