%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function calculates a kernel smoothed estimate of the joint 
% distribution of two variables using boundary correction.
%
% Written by Ian Fillmore
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [mixValDens GRID1 GRID2] = jointDistbcfcn(val1,val2,T)
% val1 and val2 are vectors corresponding to the data points
% T specifies ithe size of the grid of points at which to
% evaluate the density
% h1 and h2 are the bandwidths
% LT0ss is the original sample size before any trimming

LT0ss = length(val1);
grid1 = linspace(min(val1), max(val1), T)';
grid2 = linspace(min(val2), max(val2), T)';
% b0 is needed for h0 bandwidth---see KZ (2008) bottom of page 501 and the
% K0 term in (4.9) of ZK (1998) which is K0 = 6 + 18t + 12t^2, t\in[-1,0];
% this will compute b0 for any kernel choice provided by user
kernel = 'triweight';
num_t1 = quad(@evalkspdf_num,-1,1,1e-14,[],kernel);
num_t2 = 0 - (-144/5 + 432/4 - 468/3 + 216/2 - 36);
denom_t1 = 0 - (-2 + 18/4 - 12/5);
denom_t2 = quad(@evalkspdf_denom,-1,1,1e-14,[],kernel);
b0 = ((num_t1^2*num_t2)/(denom_t1^2*denom_t2))^(1/5);

jgrid2 = ones(T,1) * linspace(min(val1),max(val1),T);
jgrid2 = reshape( jgrid2 , T^2, 1 );
sgrid2 = ones(T,1) * linspace(min(val2),max(val2),T);
sgrid2 = reshape( sgrid2' , T^2, 1 );
[mixValDensbc,h_j,h_s] = kspdf2dCPVbcFAST_joint(val1,val2,jgrid2,sgrid2,'triweight',b0);
mixValDens = reshape(mixValDensbc,T,T);
[GRID1,GRID2] = meshgrid( grid1 , grid2 );


% parameters for figure properties
lwidth = 2;
fsize = 14;
set(0,'defaulttextinterpreter','latex','Defaulttextfontsize',fsize);


figure
%set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
contour(GRID1,GRID2,mixValDens,25)
ind = findobj('Type','patch');
set(ind,'LineWidth',lwidth)
hold on
dom = linspace(19.5,13000,10);
plot(dom,dom,'k','LineWidth',lwidth/2)
hold off
xlim([21.5,15000])
ylim([19.5,8000])
xlabel('$\mathbf{JOINT\ BIDDERS}$','FontSize',20)
ylabel('$\mathbf{SOLO\ BIDDERS}$','FontSize',20)
hh = legend('LEVEL CURVES OF JOINT DENSITY: BC \qquad','$45^0$ LINE','Location','NorthOutside')
set(hh,'box','off','Xcolor',[1 1 1],'Ycolor',[1 1 1],'FontSize',16);
ind2 = legend;
set(ind2, 'interpreter', 'latex')
box on
zz = 0;
if zz == 1
    fnameeps = strcat('jointisoBC.eps');
    print('-depsc',fnameeps)
end


