%  Brent R. Hickman and Timothy P. Hubbard
% hickmanbr@uchicago.edu and timothy.hubbard@colby.edu

% please cite our Journal of Applied Econometrics paper "Replacing Sample
% Trimming with Boundary Correction in Nonparametric Estimation of
% First-Price Auctions" if this code is helpful to you.

% compare bc CPV with CPV replication figures

clear all
clc

% parameters for figure properties
lwidth = 2;
fsize = 14;
ptsize = 150;
set(0,'defaulttextinterpreter','latex','Defaulttextfontsize',fsize);

trimCPVway = 1
saverun = 0

[jj,ss,evalgridjj,fjj,evalgridss,fss, ...
    jmix,smix,evalgridjmix,fjmix,evalgridsmix, ...
    fsmix] = replicateCPV2012fcn(trimCPVway);
[jjbc,ssbc,evalgridjjbc,fjjbc,evalgridssbc,fssbc, ...
    jmixbc,smixbc,evalgridjmixbc,fjmixbc,evalgridsmixbc, ...
    fsmixbc] = bcappliedtoCPV2012fcn;

% some measures of association
%taumix = kendall1(jmix(:,6),smix(:,6));
%taumixbc = kendall1(jmixbc(:,6),smixbc(:,6));
[rhomix,pvalmix] = corr(jmix(:,6),smix(:,6));
[rhomixbc,pvalmixbc] = corr(jmixbc(:,6),smixbc(:,6));
[taumix2,pvalmix2] = corr(jmix(:,6),smix(:,6),'type','Kendall');
[taumixbc2,pvalmixbc2] = corr(jmixbc(:,6),smixbc(:,6),'type','Kendall');
[rhomixbid,pvalmixbid] = corr(jmix(:,1),smix(:,1));
[rhomixbcbid,pvalmixbcbid] = corr(jmixbc(:,1),smixbc(:,1));


% figure 1 of CPV on page 196
figure
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
hold all
box on
scatter(jj(:,1),jj(:,6),'pb','SizeData',ptsize,'MarkerFaceColor','b')
scatter(ss(:,1),ss(:,6),'pr','SizeData',ptsize,'MarkerFaceColor','r')
scatter(jjbc(:,1),jjbc(:,6),'+b','SizeData',ptsize)
scatter(ssbc(:,1),ssbc(:,6),'+r','SizeData',ptsize)
hh = legend('J vs J trim\quad','S vs S trim\quad','J vs J BC','S vs S BC','Location','Northwest')
xlabel('$\mathbf{b}$','FontSize',20)
ylabel('$\mathbf{\hat{v}}$','FontSize',20)
axis([0 4200 0 30000])
set(hh,'FontSize',16);
if saverun == 1
    fname = strcat(outfolder,'jj_ss_ibfs');
    fnameeps = strcat(fname,'.eps');
    print('-depsc',fnameeps)
end
%title('Figure 1 of CPV on page 196: Inverse bidding strategies')


% figure 2 of CPV on page 197
figure
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
hold all
box on
plot(evalgridjj,fjj,'b-.',evalgridss,fss,'r-.')
plot(evalgridjjbc,fjjbc,'b-',evalgridssbc,fssbc,'r-')
hh = legend('\quad J vs J trim\quad','\quad S vs S trim\quad','\quad J vs J BC','\quad S vs S BC','Location','Northeast')
set(hh,'FontSize',16);
xlim([0 10000])
xlabel('$\mathbf{v}$','FontSize',20)
ylabel('$\mathbf{\hat{f}_V(v)}$','FontSize',20)
if saverun == 1
    fname = strcat(outfolder,'jj_ss_pdfs');
    fnameeps = strcat(fname,'.eps');
    print('-depsc',fnameeps)
end
%title('Figure 2 of CPV on page 197: Marginal densities of private values')


% figure 3 of CPV on page 198
figure
hold on
box on
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
scatter(jmix(:,1),jmix(:,6),'pb','SizeData',ptsize,'MarkerFaceColor','b')
scatter(smix(:,1),smix(:,6),'pr','SizeData',ptsize,'MarkerFaceColor','r')
scatter(jmixbc(:,1),jmixbc(:,6),'+b','SizeData',ptsize)
scatter(smixbc(:,1),smixbc(:,6),'+r','SizeData',ptsize)
hh = legend('J vs S trim\quad','S vs J trim\quad','J vs S BC','S vs J BC','Location','Southeast')
set(hh,'FontSize',16);
xlabel('$\mathbf{b}$','FontSize',20)
ylabel('$\mathbf{\hat{v}}$','FontSize',20)
axis([0 11300 0 52000])
if saverun == 1
    fname = strcat(outfolder,'js_sj_ibfs');
    fnameeps = strcat(fname,'.eps');
    print('-depsc',fnameeps)
end
%title('Figure 3 of CPV on page 198: Inverse bidding strategies')

% figure 4 of CPV on page 199
figure
box on
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
plot(evalgridjmix,fjmix,'b-.',evalgridsmix,fsmix,'r-.')
hold all
plot(evalgridjmixbc,fjmixbc,'b-',evalgridsmixbc,fsmixbc,'r-')
hh = legend('\quad J vs S trim\quad','\quad S vs J trim\quad','\quad J vs S BC','\quad S vs J BC','Location','Northeast')
set(hh,'FontSize',16);
xlim([0 10000])
xlabel('$\mathbf{v}$','FontSize',20)
ylabel('$\mathbf{\hat{f}_V(v)}$','FontSize',20)
if saverun == 1
    fname = strcat(outfolder,'js_sj_pdfs');
    fnameeps = strcat(fname,'.eps');
    print('-depsc',fnameeps)
end
%title('Figure 4 of CPV on page 199: Marginal densities of private values')

minv = min(min(jmix(:,6)),min(smix(:,6)));
maxv = max(max(jmix(:,6)),max(smix(:,6)));
evalgrid = linspace(minv,maxv,10000);
edf_jmix = kscdf(jmix(:,6),'edf',evalgrid);
edf_smix = kscdf(smix(:,6),'edf',evalgrid);
figure 
box on
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
plot(evalgrid,edf_jmix,'-.',evalgrid,edf_smix,'-')
hh = legend('\quad J vs S','\quad S vs J','Location','Southeast')
set(hh,'FontSize',16);
xlabel('$\mathbf{v}$','FontSize',20)
ylabel('$\mathbf{\hat{F}_V(v)}$','FontSize',20)
xlim([0 9000])
if saverun == 1
    fname = strcat(outfolder,'js_sj_edfs');
    fnameeps = strcat(fname,'.eps');
    print('-depsc',fnameeps)
end


minv = min(min(jmixbc(:,6)),min(smixbc(:,6)));
maxv = max(max(jmixbc(:,6)),max(smixbc(:,6)));
evalgrid = linspace(minv,maxv,10000);
edf_jmixbc = kscdf(jmixbc(:,6),'edf',evalgrid);
edf_smixbc = kscdf(smixbc(:,6),'edf',evalgrid);
figure 
box on
set(gcf,'DefaultLineLineWidth',lwidth)
set(gca,'FontSize',fsize)
plot(evalgrid,edf_jmixbc,'-.',evalgrid,edf_smixbc,'-')
hh = legend('\quad J vs S','\quad S vs J','Location','Southeast')
set(hh,'FontSize',16);
xlabel('$\mathbf{v}$','FontSize',20)
ylabel('$\mathbf{\hat{F}_V(v)}$','FontSize',20)
xlim([0 52000])
if saverun == 1
    fname = strcat(outfolder,'js_sj_edfs_bc');
    fnameeps = strcat(fname,'.eps');
    print('-depsc',fnameeps)
end

% level sets in asymmetric case
% there's a switch for printing within this sub file:
[mixValDens GRID1 GRID2] = jointDistbcfcn(jmixbc(:,6),smixbc(:,6),250);