%------- (i) migrates original csv data files to one mat file  --------
heritage = tmigrator('cc', 'data', '-pertable', '-numcat', '-progress');
heritage_transformation;
heritage_new_matrix = tmigrator('cc', heritage_new, '-matrix', '-pertable');

%save migrated data
clearvars -except heritage_new_matrix
save heritage_data_new.mat

disp(' '),disp('-> original data saved as: heritage_data_new.mat')


%------- (ii) data generation --------
%Creates the variables used in the study by aggregating the claim level 
%data 'heritage_new_matrix' (saved as heritage_data_new.mat) to the patient 
%level. The output variable DatMat is saved as dataset.mat and is described 
%in the file variable_def.txt.
disp(' '),disp('datagen')
datagen;

%------- (iii) group data generation --------
%Generates group data, i.e. each patient is assigned in each year to one 
%primary condition group (PCG) based on the maximum number of claims.
%The output variable PCGMat is saved as PCGdata.mat and is described 
%in the file variable_def.txt.
disp(' '),disp('gen_PCGdata')
gen_PCGdata;

%------- (iv) data imputation --------
%Imputes the dataset DatMat by means of nearest neighbour techniques.
%The output variable DatMatimp is saved as datasetimp.mat and has the 
%same structure as DatMat, which is described in the file variable_def.txt.
disp(' '),disp('imputation')
disp('-> takes a long time!')
imput;