function DatMatimp = imput
%function to impute the data by means of nearest neighbour techniques


load dataset.mat

X=DatMat(:,3:end);
% -> DatMat(:,1): IDMax: MemberID
% -> DatMat(:,2): IDTarget: 1 if patient is in Target-Table

%number of patients
N=size(X,1);
%number of variables
K=size(X,2);
%matrix for imputed (and non-missing) values
Xnew = ones(N,K)*NaN;

anz = 100;
tic
%loop over all patients
for i=1:N

    if i/anz==round(i/anz),disp(['i = ' num2str(i) ' (' num2str((i/N)*100) '%)']),toc,tic,end    

	%loop over variables 
    for k=1:K
	
		%check if missing value 
        if isnan(X(i,k)) || isinf(X(i,k))
            
            %--------------------- Imputation -----------------------------
            
            %Index der Spalten ohne NaNs
            ind_comp = isnan(X(i,:))==0;
            %Matrix mit den Spalten von X ohne NaNs fr i
            Xicomp = X(i,ind_comp);
            %Daten der anderen Beobachtungen mit den Spalten von X ohne NaNs fr i
            Xiother = X(:,ind_comp);
            %originale Indizes
            orgind = (1:N)';
            %Indizes der Beobachtungen,
            % *die NaNs haben [any(isnan(Xiother))]
            % *mit Index i [(orgind==i)]
            % *die fr k ein NaN haben [isnan(X(:,k))]
            %  -> da die k-te Spalte in Xiother nicht betrachtet wird!
            ind_weg = any(isnan(Xiother),2) + (orgind==i) + isnan(X(:,k));
            %Aussortieren der Beobachtungen
            Xiother(ind_weg~=0,:)=[];
            %originalen ursprnglichen Indizes von X
            orgind(ind_weg~=0)=[];            
			
            %Indizes der konstanten Spalten
            ind_weg = var(Xiother)==0;
            %Aussortieren der Spalten
            Xiother(:,ind_weg~=0)=[];
            Xicomp(:,ind_weg~=0)=[];
                
            % -> Nearest Neighbor Search <-
            n = knnsearch(Xiother,Xicomp,'dist','seuclidean','k',1);
            %d(1,i)=sqrt(sum((((X(i,:)-Y)./nanstd(X)).^2)));
            %Index des Nachbarn
            ind_nb = orgind(n);
            %Imputation
            Xnew(i,k) = X(ind_nb,k);
			
        else
            Xnew(i,k) = X(i,k);
        end%if isnan(X(i,k)) || isinf(X(i,k))
    end%for k=1:K
end%for i=1:N

%add the Patient-IDs and ID-Target
DatMatimp = [DatMat(:,1:2),Xnew];

%clear all other variables
clearvars -except DatMatimp
%save imputed data set
save datasetimp.mat