% Script assumes that the storage variable 'heritage' is avaible
% in workspace and will create heritage_new.

heritage_new = heritage;


%%% Transformations:

% + Conversion of numbered categories to start from zero.
% + Reorder poor automatic ordering due to string characteristics.
% + Backconversion of strings and transformation to numbers; omit '+'-sign.


%%% Table: Claims

% "Year" is always converted as [Y1 --> 1, Y2 --> 2, Y3 --> 3]

heritage_new.tabledata{1}.Specialty = ...
    heritage_new.tabledata{1}.Specialty - 1;

heritage_new.tabledata{1}.PlaceSvc = ...
    heritage_new.tabledata{1}.PlaceSvc - 1;

heritage_new.tabledata{1} = ...
    tmigrator('cc', heritage_new.tabledata{1}, '-denumcat', {'PayDelay'});
heritage_new.tabledata{1}.PayDelay( ...
    strcmp('162+', heritage_new.tabledata{1}.PayDelay)) = {'162'};
heritage_new.tabledata{1}.PayDelay = ...
cellfun(@str2double, heritage_new.tabledata{1}.PayDelay);

legend = heritage_new.tabledata{1}.Properties.UserData{9};
legend_new = cell(size(legend));
LengthOfStay_new = heritage_new.tabledata{1}.LengthOfStay;
temp = heritage_new.tabledata{1}.LengthOfStay == 1;
LengthOfStay_new(temp) = 0;
legend_new{1} = legend{1};
temp = heritage_new.tabledata{1}.LengthOfStay == 3;
LengthOfStay_new(temp) = 1;
legend_new{2} = legend{3};
temp = heritage_new.tabledata{1}.LengthOfStay == 6;
LengthOfStay_new(temp) = 2;
legend_new{3} = legend{6};
temp = heritage_new.tabledata{1}.LengthOfStay == 7;
LengthOfStay_new(temp) = 3;
legend_new{4} = legend{7};
temp = heritage_new.tabledata{1}.LengthOfStay == 9;
LengthOfStay_new(temp) = 4;
legend_new{5} = legend{9};
temp = heritage_new.tabledata{1}.LengthOfStay == 10;
LengthOfStay_new(temp) = 5;
legend_new{6} = legend{10};
temp = heritage_new.tabledata{1}.LengthOfStay == 2;
LengthOfStay_new(temp) = 6;
legend_new{7} = legend{2};
temp = heritage_new.tabledata{1}.LengthOfStay == 4;
LengthOfStay_new(temp) = 7;
legend_new{8} = legend{4};
temp = heritage_new.tabledata{1}.LengthOfStay == 8;
LengthOfStay_new(temp) = 8;
legend_new{9} = legend{8};
temp = heritage_new.tabledata{1}.LengthOfStay == 5;
LengthOfStay_new(temp) = 9;
legend_new{10} = legend{5};
heritage_new.tabledata{1}.Properties.UserData{9} = legend_new;
heritage_new.tabledata{1}.LengthOfStay = LengthOfStay_new;

legend = heritage_new.tabledata{1}.Properties.UserData{10};
legend_new = cell(size(legend));
DSFS_new = heritage_new.tabledata{1}.DSFS;
temp = heritage_new.tabledata{1}.DSFS == 1;
DSFS_new(temp) = 0;
legend_new{1} = legend{1};
temp = heritage_new.tabledata{1}.DSFS == 2;
DSFS_new(temp) = 1;
legend_new{2} = legend{2};
temp = heritage_new.tabledata{1}.DSFS == 5;
DSFS_new(temp) = 2;
legend_new{3} = legend{5};
temp = heritage_new.tabledata{1}.DSFS == 6;
DSFS_new(temp) = 3;
legend_new{4} = legend{6};
temp = heritage_new.tabledata{1}.DSFS == 7;
DSFS_new(temp) = 4;
legend_new{5} = legend{7};
temp = heritage_new.tabledata{1}.DSFS == 8;
DSFS_new(temp) = 5;
legend_new{6} = legend{8};
temp = heritage_new.tabledata{1}.DSFS == 9;
DSFS_new(temp) = 6;
legend_new{7} = legend{9};
temp = heritage_new.tabledata{1}.DSFS == 10;
DSFS_new(temp) = 7;
legend_new{8} = legend{10};
temp = heritage_new.tabledata{1}.DSFS == 11;
DSFS_new(temp) = 8;
legend_new{9} = legend{11};
temp = heritage_new.tabledata{1}.DSFS == 12;
DSFS_new(temp) = 9;
legend_new{10} = legend{12};
temp = heritage_new.tabledata{1}.DSFS == 3;
DSFS_new(temp) = 10;
legend_new{11} = legend{3};
temp = heritage_new.tabledata{1}.DSFS == 4;
DSFS_new(temp) = 11;
legend_new{12} = legend{4};
heritage_new.tabledata{1}.Properties.UserData{10} = legend_new;
heritage_new.tabledata{1}.DSFS = DSFS_new;

heritage_new.tabledata{1}.PrimaryConditionGroup = ...
    heritage_new.tabledata{1}.PrimaryConditionGroup - 1;

heritage_new.tabledata{1}.CharlsonIndex = ...
    heritage_new.tabledata{1}.CharlsonIndex - 1;

heritage_new.tabledata{1}.ProcedureGroup = ...
    heritage_new.tabledata{1}.ProcedureGroup - 1;


%%% Table: DaysInHospital_Y2

% no changes


%%% Table: DaysInHospital_Y3

% no changes


%%% Table: DrugCount

% "Year" is always converted as [Y1 --> 1, Y2 --> 2, Y3 --> 3]

legend = heritage_new.tabledata{4}.Properties.UserData{3};
legend_new = cell(size(legend));
DSFS_new = heritage_new.tabledata{4}.DSFS;
temp = heritage_new.tabledata{4}.DSFS == 1;
DSFS_new(temp) = 0;
legend_new{1} = legend{1};
temp = heritage_new.tabledata{4}.DSFS == 2;
DSFS_new(temp) = 1;
legend_new{2} = legend{2};
temp = heritage_new.tabledata{4}.DSFS == 5;
DSFS_new(temp) = 2;
legend_new{3} = legend{5};
temp = heritage_new.tabledata{4}.DSFS == 6;
DSFS_new(temp) = 3;
legend_new{4} = legend{6};
temp = heritage_new.tabledata{4}.DSFS == 7;
DSFS_new(temp) = 4;
legend_new{5} = legend{7};
temp = heritage_new.tabledata{4}.DSFS == 8;
DSFS_new(temp) = 5;
legend_new{6} = legend{8};
temp = heritage_new.tabledata{4}.DSFS == 9;
DSFS_new(temp) = 6;
legend_new{7} = legend{9};
temp = heritage_new.tabledata{4}.DSFS == 10;
DSFS_new(temp) = 7;
legend_new{8} = legend{10};
temp = heritage_new.tabledata{4}.DSFS == 11;
DSFS_new(temp) = 8;
legend_new{9} = legend{11};
temp = heritage_new.tabledata{4}.DSFS == 12;
DSFS_new(temp) = 9;
legend_new{10} = legend{12};
temp = heritage_new.tabledata{4}.DSFS == 3;
DSFS_new(temp) = 10;
legend_new{11} = legend{3};
temp = heritage_new.tabledata{4}.DSFS == 4;
DSFS_new(temp) = 11;
legend_new{12} = legend{4};
heritage_new.tabledata{4}.Properties.UserData{3} = legend_new;
heritage_new.tabledata{4}.DSFS = DSFS_new;

heritage_new.tabledata{4} = ...
    tmigrator('cc', heritage_new.tabledata{4}, '-denumcat', {'DrugCount'});
heritage_new.tabledata{4}.DrugCount( ...
    strcmp('7+', heritage_new.tabledata{4}.DrugCount)) = {'7'};
heritage_new.tabledata{4}.DrugCount = ...
cellfun(@str2double, heritage_new.tabledata{4}.DrugCount);


%%% Table: LabCount

% "Year" is always converted as [Y1 --> 1, Y2 --> 2, Y3 --> 3]

legend = heritage_new.tabledata{5}.Properties.UserData{3};
legend_new = cell(size(legend));
DSFS_new = heritage_new.tabledata{5}.DSFS;
temp = heritage_new.tabledata{5}.DSFS == 1;
DSFS_new(temp) = 0;
legend_new{1} = legend{1};
temp = heritage_new.tabledata{5}.DSFS == 2;
DSFS_new(temp) = 1;
legend_new{2} = legend{2};
temp = heritage_new.tabledata{5}.DSFS == 5;
DSFS_new(temp) = 2;
legend_new{3} = legend{5};
temp = heritage_new.tabledata{5}.DSFS == 6;
DSFS_new(temp) = 3;
legend_new{4} = legend{6};
temp = heritage_new.tabledata{5}.DSFS == 7;
DSFS_new(temp) = 4;
legend_new{5} = legend{7};
temp = heritage_new.tabledata{5}.DSFS == 8;
DSFS_new(temp) = 5;
legend_new{6} = legend{8};
temp = heritage_new.tabledata{5}.DSFS == 9;
DSFS_new(temp) = 6;
legend_new{7} = legend{9};
temp = heritage_new.tabledata{5}.DSFS == 10;
DSFS_new(temp) = 7;
legend_new{8} = legend{10};
temp = heritage_new.tabledata{5}.DSFS == 11;
DSFS_new(temp) = 8;
legend_new{9} = legend{11};
temp = heritage_new.tabledata{5}.DSFS == 12;
DSFS_new(temp) = 9;
legend_new{10} = legend{12};
temp = heritage_new.tabledata{5}.DSFS == 3;
DSFS_new(temp) = 10;
legend_new{11} = legend{3};
temp = heritage_new.tabledata{5}.DSFS == 4;
DSFS_new(temp) = 11;
legend_new{12} = legend{4};
heritage_new.tabledata{5}.Properties.UserData{3} = legend_new;
heritage_new.tabledata{5}.DSFS = DSFS_new;

heritage_new.tabledata{5} = ...
    tmigrator('cc', heritage_new.tabledata{5}, '-denumcat', {'LabCount'});
heritage_new.tabledata{5}.LabCount( ...
    strcmp('10+', heritage_new.tabledata{5}.LabCount)) = {'10'};
heritage_new.tabledata{5}.LabCount = ...
cellfun(@str2double, heritage_new.tabledata{5}.LabCount);


%%% Table: Members

heritage_new.tabledata{6}.AgeAtFirstClaim = ...
    heritage_new.tabledata{6}.AgeAtFirstClaim - 1;

heritage_new.tabledata{6}.Sex = ...
    heritage_new.tabledata{6}.Sex - 1;


%%% Table: Target

% no changes
