function DatMat = datagen
%function to construct the data set


disp(' '),disp('datagen'),disp(' ')

%load data
load heritage_data_new.mat


Claims_table = heritage_new_matrix.tabledata{1}.coldata;
MembIDs_claims = unique(Claims_table(:,1));
N_IDs_claims = length(MembIDs_claims);

DaysInHospital_Y2_table = heritage_new_matrix.tabledata{2}.coldata;
MembIDs_DaysInHospital_Y2 = unique(DaysInHospital_Y2_table(:,1));
N_IDs_DaysInHospital_Y2 = length(MembIDs_DaysInHospital_Y2);

DaysInHospital_Y3_table = heritage_new_matrix.tabledata{3}.coldata;
MembIDs_DaysInHospital_Y3 = unique(DaysInHospital_Y3_table(:,1));
N_IDs_DaysInHospital_Y3 = length(MembIDs_DaysInHospital_Y3);

DrugCount_table = heritage_new_matrix.tabledata{4}.coldata;
MembIDs_DrugCount = unique(DrugCount_table(:,1));
N_IDs_DrugCount = length(MembIDs_DrugCount);

LabCount_table = heritage_new_matrix.tabledata{5}.coldata;
MembIDs_LabCount = unique(LabCount_table(:,1));
N_IDs_LabCount = length(MembIDs_LabCount);

Members_table = heritage_new_matrix.tabledata{6}.coldata;
MembIDs_Members = unique(Members_table(:,1));
N_IDs_Members = length(MembIDs_Members);

Target_table = heritage_new_matrix.tabledata{7}.coldata;
MembIDs_Target = unique(Target_table(:,1));
N_IDs_Target = length(MembIDs_Target);






%CLAIMS TABLE

%Specialty (setting NaN to 13)
Claims_table(isnan(Claims_table(:,6)),6) = 13;
Auspr_sp = unique(Claims_table(:,6));
%PlaceSvc (setting NaN to 9)
Claims_table(isnan(Claims_table(:,7)),7) = 9;
Auspr_ps = unique(Claims_table(:,7));
%PrimaryConditionGroup (setting NaN to 46)
Claims_table(isnan(Claims_table(:,11)),11) = 46;
Auspr_pcg = unique(Claims_table(:,11));
%ProcedureGroup (setting NaN to 18)
Claims_table(isnan(Claims_table(:,13)),13) = 18;
Auspr_pg = unique(Claims_table(:,13));

%*LengthOfStay (column 9)
% -> setting 9 to 182 (lower class limit, i.e. 26*7)
Claims_table((Claims_table(:,9)==9),9)=182;
% -> setting 8 to 41.5 (class midpoint, i.e. (4*7+(8*7)-1)/2)
Claims_table((Claims_table(:,9)==8),9)=41.5;
% -> setting 7 to 20.5 (class midpoint, i.e. (14+(4*7)-1)/2)
Claims_table((Claims_table(:,9)==7),9)=20.5;
% -> setting 6 to 10 (class midpoint, i.e. (7+13)/2)
Claims_table((Claims_table(:,9)==6),9)=10;
% -> setting 5 to 6
Claims_table((Claims_table(:,9)==5),9)=6;
% -> setting 4 to 5
Claims_table((Claims_table(:,9)==4),9)=5;
% -> setting 3 to 4
Claims_table((Claims_table(:,9)==3),9)=4;
% -> setting 2 to 3
Claims_table((Claims_table(:,9)==2),9)=3;
% -> setting 1 to 2
Claims_table((Claims_table(:,9)==1),9)=2;
% -> setting 0 to 1
Claims_table((Claims_table(:,9)==0),9)=1;
% -> setting NaN to 0
Claims_table(isnan(Claims_table(:,9)),9)=0;


%Hilfsmatrix ProviderL (Provider: column 2)
% -> setting NaN to 9999999
Claims_table(isnan(Claims_table(:,2)),2)=9999999;
%Ausprgungen der Provider
Auspr_PID = unique(Claims_table(:,2));
%Anzahl der Ausprgungen
N_Prov = length(Auspr_PID);
%Loop ber Ausprgungen
ProviderL = zeros(N_Prov,2);
%anz =1000;
for j=1:N_Prov
    %if j/anz==round(j/anz),disp(['j = ' num2str(j) '(' num2str((j/N_Prov)*100) '%)']),end
    %j-te ID
    id = Auspr_PID(j);
    %j-te ID
    ProviderL(j,1) = id;
    %Identifikation von id in Claims_table
    ind = Claims_table(:,2)==id;
    %Mittl. (ber alle Claims) Length in Tagen fr jeweiligen Provider
    ProviderL(j,2) = mean(Claims_table(ind,9));
end%for j=1:N_Prov


%Hilfsmatrix VendorL (Vendor: column 3)
% -> setting NaN to 999999
Claims_table(isnan(Claims_table(:,3)),3)=999999;
%Ausprgungen der Vendor
Auspr_VID = unique(Claims_table(:,3));
%Anzahl der Ausprgungen
N_Ven = length(Auspr_VID);
%Loop ber Ausprgungen
VendorL = zeros(N_Ven,2);
%anz =100;
for j=1:N_Ven
    %if j/anz==round(j/anz),disp(['j = ' num2str(j) '(' num2str((j/N_Ven)*100) '%)']),end
    %j-te ID
    id = Auspr_VID(j);
    %j-te ID
    VendorL(j,1) = id;
    %Identifikation von id in Claims_table
    ind = Claims_table(:,3)==id;
    %Mittl. (ber alle Claims) Length in Tagen fr jeweiligen Provider
    VendorL(j,2) = mean(Claims_table(ind,9));
end%for j=1:N_Ven


%Hilfsmatrix PCPL (PCP: column 4)
% -> setting NaN to 99999
Claims_table(isnan(Claims_table(:,4)),4)=99999;
%Ausprgungen der Vendor
Auspr_PCPID = unique(Claims_table(:,4));
%Anzahl der Ausprgungen
N_PCP = length(Auspr_PCPID);
%Loop ber Ausprgungen
PCPL = zeros(N_PCP,2);
%anz =100;
for j=1:N_PCP
    %if j/anz==round(j/anz),disp(['j = ' num2str(j) '(' num2str((j/N_PCP)*100) '%)']),end
    %j-te ID
    id = Auspr_PCPID(j);
    %j-te ID
    PCPL(j,1) = id;
    %Identifikation von id in Claims_table
    ind = Claims_table(:,4)==id;
    %Mittl. (ber alle Claims) Length in Tagen fr jeweiligen Provider
    PCPL(j,2) = mean(Claims_table(ind,9));
end%for j=1:N_PCP


%Hilfsmatrix PrCondL (PrimaryConditionGroup: column 11)
% -> setting NaN to 99
Claims_table(isnan(Claims_table(:,11)),11)=99;
%Ausprgungen der Vendor
Auspr_PrCID = unique(Claims_table(:,11));
%Anzahl der Ausprgungen
N_PrC = length(Auspr_PrCID);
%Loop ber Ausprgungen
PrCondL = zeros(N_PrC,2);
%anz =10;
for j=1:N_PrC
    %if j/anz==round(j/anz),disp(['j = ' num2str(j) '(' num2str((j/N_PrC)*100) '%)']),end
    %j-te ID
    id = Auspr_PrCID(j);
    %j-te ID
    PrCondL(j,1) = id;
    %Identifikation von id in Claims_table
    ind = Claims_table(:,11)==id;
    %Mittl. (ber alle Claims) Length in Tagen fr jeweiligen Provider
    PrCondL(j,2) = mean(Claims_table(ind,9));
end%for j=1:N_PrC


%Hilfsmatrix ProcedL (ProcedureGroup: column 13)
% -> setting NaN to 99
Claims_table(isnan(Claims_table(:,13)),13)=99;
%Ausprgungen der Vendor
Auspr_ProcID = unique(Claims_table(:,13));
%Anzahl der Ausprgungen
N_Proc = length(Auspr_ProcID);
%Loop ber Ausprgungen
ProcedL = zeros(N_Proc,2);
%anz =10;
for j=1:N_Proc
    %if j/anz==round(j/anz),disp(['j = ' num2str(j) '(' num2str((j/N_Proc)*100) '%)']),end
    %j-te ID
    id = Auspr_ProcID(j);
    %j-te ID
    ProcedL(j,1) = id;
    %Identifikation von id in Claims_table
    ind = Claims_table(:,13)==id;
    %Mittl. (ber alle Claims) Length in Tagen fr jeweiligen Provider
    ProcedL(j,2) = mean(Claims_table(ind,9));
end%for j=1:N_Proc





%----------------------------- Datenmatrix --------------------------------
% Zeilen: Alle Personen, die mindestens einmal irgendwo auftreten
% Spalten: Variablen:
% Name
% IDMax
% IDTarget
% ProvidMax
% ProvidMean
% VendorMax
% VendorMean
% PCPMax
% PCPMean
% Claimx
% Lengthx
% LengMaxx
% LengSumx
% SpecialYyx
% PlaceYyx
% PayDelay
% PayDelayYy
% PrCondMax
% PrCondMean
% Charlsonx
% ProcedMax
% ProcedMean
% ClaimTrunc2
% DaysHosp2
% ClaimTrunc3
% DaysHosp3
% Drugx
% Labx
% Age
% AgeMiss
% Sex
% SexMiss
% ClaimTruncT


%Member IDs aus allen Tabellen
ALL_Members = unique([MembIDs_claims;MembIDs_DaysInHospital_Y2;MembIDs_DaysInHospital_Y3;MembIDs_DrugCount;MembIDs_LabCount;MembIDs_Members;MembIDs_Target]);
%Anzahl der gesamten Members
N_ALLMemb = length(ALL_Members);


%-------------------------- Loop ber Members -----------------------------
DatMat = zeros(N_ALLMemb,160);
anz = 1000;
tic
for i=1:N_ALLMemb
    if i/anz==round(i/anz),disp(['i = ' num2str(i) '(' num2str((i/N_ALLMemb)*100) '%)']),toc,tic,end
    %i-te ID
    Memb_id = ALL_Members(i);
    %Identifikation von Memb_id in Claims_table
    ind_i = Claims_table(:,1)==Memb_id;
    %Anzahl der Claims
    N_claims = sum(ind_i);
    %Claims der i-ten ID
    Claims_i = Claims_table(ind_i,:);
    
    
    %------------------------ Datenmatrix ---------------------------------
    
    % -> IDMax (MemberID)
    DatMat(i,1) = Memb_id;
    % -> IDTarget (1 falls Person in Target-Tabelle)
    DatMat(i,2) = any(MembIDs_Target==Memb_id) + 0; %(+0 macht's numerisch)
    
    
    
    
    %----------------------------------------------------------------------
    %LOOP ber die Zeit
    spec_tj = 0; %Laufindex ber Specialties
    place_tj = 0; %Laufindex ber Places
    charl_tj = 0; %Laufindex ber Charlstonindex
    for t=1:3
        
        %Identifikation von Memb_id im Jahr t in Claims_table
        ind_it = (Claims_table(:,1)==Memb_id) & (Claims_table(:,5)==t);
        %Anzahl der Claims fr Member i in Year t
        N_claims_it = sum(ind_it);
        %Tabelle mit den Claims fr Member i in Year t
        Claims_it = Claims_table(ind_it,:);
        
        
        %------ ProviderL ------
        %Hilfsmatrix
        Hilfsmat = ProviderL;
        %Vektor mit den Providern von Member Memb_id (Provider: column 2)
        Vec_it = Claims_it(:,2);
        %Ausrgungen von Member Memb_id in claims
        uniVec_it = unique(Vec_it);
        %Anzahl der Ausrgungen
        N_Vec_it = length(uniVec_it);
        %loop ber Ausrgungen
        LoSVec_it = zeros(N_Vec_it,1);
        gewLoSVec_it = zeros(N_Vec_it,1);
        for j=1:N_Vec_it
            %Provider ID
            id_j = uniVec_it(j);
            %Identifikation von id_j in Hilfsmat
            ind_j = Hilfsmat(:,1)==id_j;
            %Vector mit LoS von id_j
            LoSVec_it(j,1) = Hilfsmat(ind_j,2);
            %Hufigkeit von id_j
            Anzid_j = sum(Vec_it==id_j);
            %Vector mit gewichteten (bzgl. der Hufigkeit von id_j) LoS von id_j
            gewLoSVec_it(j,1) = Hilfsmat(ind_j,2)*(Anzid_j/N_claims_it);
        end%for j=1:N_Vec_it
        if N_Vec_it==0
            DatMat(i,2+t) = NaN;
        else
            % -> ProvidMax (Max. (ber alle verwendeten Provider) ProviderL)
            DatMat(i,2+t) = max(LoSVec_it);
            %i.e. DatMat(i,3): ProvidMax1, DatMat(i,4): ProvidMax2, DatMat(i,5): ProvidMax3
        end
        % -> ProvidMean (Mittl. (ber alle verwendeten Provider) ProviderL)
        DatMat(i,5+t) = mean(LoSVec_it);
        %i.e. DatMat(i,6): ProvidMean1, DatMat(i,7): ProvidMean2, DatMat(i,8): ProvidMean3
        % -> ProvidgewMean (gew. Mittl. (bzgl. der Hufigkeit der verwendeten Provider) (ber alle verwendeten Provider) ProviderL)
        DatMat(i,8+t) = mean(gewLoSVec_it);
        %i.e. DatMat(i,9): ProvidgewMean1, DatMat(i,10): ProvidgewMean2, DatMat(i,11): ProvidgewMean3
        
        
        %------ VendorL ------
        %Hilfsmatrix
        Hilfsmat = VendorL;
        %Vektor mit den Vendors von Member Memb_id (Vendor: column 3)
        Vec_it = Claims_it(:,3);
        %Ausrgungen von Member Memb_id in claims
        uniVec_it = unique(Vec_it);
        %Anzahl der Ausrgungen
        N_Vec_it = length(uniVec_it);
        %loop ber Ausrgungen
        LoSVec_it = zeros(N_Vec_it,1);
        gewLoSVec_it = zeros(N_Vec_it,1);
        for j=1:N_Vec_it
            %Provider ID
            id_j = uniVec_it(j);
            %Identifikation von id_j in Hilfsmat
            ind_j = Hilfsmat(:,1)==id_j;
            %Vector mit LoS von id_j
            LoSVec_it(j,1) = Hilfsmat(ind_j,2);
            %Hufigkeit von id_j
            Anzid_j = sum(Vec_it==id_j);
            %Vector mit gewichteten (bzgl. der Hufigkeit von id_j) LoS von id_j
            gewLoSVec_it(j,1) = Hilfsmat(ind_j,2)*(Anzid_j/N_claims_it);
        end%for j=1:N_Vec_it
        if N_Vec_it==0
            DatMat(i,11+t) = NaN;
        else
            % -> VendorMax (Max. (ber alle verwendeten Vendors) VendorL)
            DatMat(i,11+t) = max(LoSVec_it);
            %i.e. DatMat(i,12): VendorMax1, DatMat(i,13): VendorMax2, DatMat(i,14): VendorMax3
        end
        % -> VendorMean (Mittl. (ber alle verwendeten Vendors) VendorL)
        DatMat(i,14+t) = mean(LoSVec_it);
        %i.e. DatMat(i,15): VendorMean1, DatMat(i,16): VendorMean2, DatMat(i,17): VendorMean3
        % -> VendorgewMean (gew. Mittl. (bzgl. der Hufigkeit der verwendeten Vendors) (ber alle verwendeten Vendors) VendorL)
        DatMat(i,17+t) = mean(gewLoSVec_it);
        %i.e. DatMat(i,18): VendorgewMean1, DatMat(i,19): VendorgewMean2, DatMat(i,20): VendorgewMean3
        
        
        %------ PCPL ------
        %Hilfsmatrix
        Hilfsmat = PCPL;
        %Vektor mit den PCPs von Member Memb_id (PCP: column 4)
        Vec_it = Claims_it(:,4);
        %Ausrgungen von Member Memb_id in claims
        uniVec_it = unique(Vec_it);
        %Anzahl der Ausrgungen
        N_Vec_it = length(uniVec_it);
        %loop ber Ausrgungen
        LoSVec_it = zeros(N_Vec_it,1);
        gewLoSVec_it = zeros(N_Vec_it,1);
        for j=1:N_Vec_it
            %Provider ID
            id_j = uniVec_it(j);
            %Identifikation von id_j in Hilfsmat
            ind_j = Hilfsmat(:,1)==id_j;
            %Vector mit LoS von id_j
            LoSVec_it(j,1) = Hilfsmat(ind_j,2);
            %Hufigkeit von id_j
            Anzid_j = sum(Vec_it==id_j);
            %Vector mit gewichteten (bzgl. der Hufigkeit von id_j) LoS von id_j
            gewLoSVec_it(j,1) = Hilfsmat(ind_j,2)*(Anzid_j/N_claims_it);
        end%for j=1:N_Vec_it
        if N_Vec_it==0
            DatMat(i,20+t) = NaN;
        else
            % -> PCPMax (Max. (ber alle verwendeten PCPs) PCPL)
            DatMat(i,20+t) = max(LoSVec_it);
            %i.e. DatMat(i,21): PCPMax1, DatMat(i,22): PCPMax2, DatMat(i,23): PCPMax3
        end
        % -> PCPMean (Mittl. (ber alle verwendeten PCPs) PCPL)
        DatMat(i,23+t) = mean(LoSVec_it);
        %i.e. DatMat(i,24): PCPMean1, DatMat(i,25): PCPMean2, DatMat(i,26): PCPMean3
        % -> PCPgewMean (gew. Mittl. (bzgl. der Hufigkeit der verwendeten PCPs) (ber alle verwendeten PCPs) PCPL)
        DatMat(i,26+t) = mean(gewLoSVec_it);
        %i.e. DatMat(i,27): PCPgewMean1, DatMat(i,28): PCPgewMean2, DatMat(i,29): PCPgewMean3
        
        
        %------ PrCondL ------
        %Hilfsmatrix
        Hilfsmat = PrCondL;
        %Vektor mit den PrimaryConditionGroups von Member Memb_id (PrimaryConditionGroup: column 11)
        Vec_it = Claims_it(:,11);
        %Ausrgungen von Member Memb_id in claims
        uniVec_it = unique(Vec_it);
        %Anzahl der Ausrgungen
        N_Vec_it = length(uniVec_it);
        %loop ber Ausrgungen
        LoSVec_it = zeros(N_Vec_it,1);
        gewLoSVec_it = zeros(N_Vec_it,1);
        for j=1:N_Vec_it
            %Provider ID
            id_j = uniVec_it(j);
            %Identifikation von id_j in Hilfsmat
            ind_j = Hilfsmat(:,1)==id_j;
            %Vector mit LoS von id_j
            LoSVec_it(j,1) = Hilfsmat(ind_j,2);
            %Hufigkeit von id_j
            Anzid_j = sum(Vec_it==id_j);
            %Vector mit gewichteten (bzgl. der Hufigkeit von id_j) LoS von id_j
            gewLoSVec_it(j,1) = Hilfsmat(ind_j,2)*(Anzid_j/N_claims_it);
        end%for j=1:N_Vec_it
        if N_Vec_it==0
            DatMat(i,29+t) = NaN;
        else
            % -> PrCondMax (Max. (ber alle auftretenden PrimaryConditions) PrCondL)
            DatMat(i,29+t) = max(LoSVec_it);
            %i.e. DatMat(i,30): PrCondMax1, DatMat(i,31): PrCondMax2, DatMat(i,32): PrCondMax3
        end
        % -> PrCondMean (Mittl. (ber alle auftretenden PrimaryConditions) PrCondL)
        DatMat(i,32+t) = mean(LoSVec_it);
        %i.e. DatMat(i,33): PrCondMean1, DatMat(i,34): PrCondMean2, DatMat(i,35): PrCondMean3
        % -> PrCondgewMean (gew. Mittl. (bzgl. der Hufigkeit der verwendeten PrimaryConditions) (ber alle auftretenden PrimaryConditions) PrCondL)
        DatMat(i,35+t) = mean(gewLoSVec_it);
        %i.e. DatMat(i,36): PrCondgewMean1, DatMat(i,37): PrCondgewMean2, DatMat(i,38): PrCondgewMean3
        
        
        %------ ProcedL ------
        %Hilfsmatrix
        Hilfsmat = ProcedL;
        %Vektor mit den ProcedureGroups von Member Memb_id (ProcedureGroup: column 13)
        Vec_it = Claims_it(:,13);
        %Ausrgungen von Member Memb_id in claims
        uniVec_it = unique(Vec_it);
        %Anzahl der Ausrgungen
        N_Vec_it = length(uniVec_it);
        %loop ber Ausrgungen
        LoSVec_it = zeros(N_Vec_it,1);
        gewLoSVec_it = zeros(N_Vec_it,1);
        for j=1:N_Vec_it
            %Provider ID
            id_j = uniVec_it(j);
            %Identifikation von id_j in Hilfsmat
            ind_j = Hilfsmat(:,1)==id_j;
            %Vector mit LoS von id_j
            LoSVec_it(j,1) = Hilfsmat(ind_j,2);
            %Hufigkeit von id_j
            Anzid_j = sum(Vec_it==id_j);
            %Vector mit gewichteten (bzgl. der Hufigkeit von id_j) LoS von id_j
            gewLoSVec_it(j,1) = Hilfsmat(ind_j,2)*(Anzid_j/N_claims_it);
        end%for j=1:N_Vec_it
        if N_Vec_it==0
            DatMat(i,38+t) = NaN;
        else
            % -> ProcedMax (Max. (ber alle auftretenden ProcedureGroups) ProcedL)
            DatMat(i,38+t) = max(LoSVec_it);
            %i.e. DatMat(i,39): ProcedMax1, DatMat(i,40): ProcedMax2, DatMat(i,41): ProcedMax3
        end
        % -> ProcedMean (Mittl. (ber alle auftretenden ProcedureGroups) ProcedL)
        DatMat(i,41+t) = mean(LoSVec_it);
        %i.e. DatMat(i,42): ProcedMean1, DatMat(i,43): ProcedMean2, DatMat(i,44): ProcedMean3
        % -> ProcedgewMean (gew. Mittl. (bzgl. der Hufigkeit der verwendeten ProcedureGroups) (ber alle auftretenden ProcedureGroups) ProcedL)
        DatMat(i,44+t) = mean(gewLoSVec_it);
        %i.e. DatMat(i,45): ProcedgewMean1, DatMat(i,46): ProcedgewMean2, DatMat(i,47): ProcedgewMean3
        
        
        
        %------------------------------------------------------------------
        
        % -> Claimx (Anzahl Claims der Person in Year x) (Year: column 5)
        DatMat(i,47+t) = sum(ind_it);
        %i.e. DatMat(i,48): Claim1, DatMat(i,49): Claim2, DatMat(i,50): Claim3
        
        % -> Lengthx (Mittl. Length (ber alle Claims) der Person in Year x) (LoS: column 9)
        DatMat(i,50+t) = mean(Claims_it(:,9));
        %i.e. DatMat(i,51): Length1, DatMat(i,52): Length2, DatMat(i,53): Length3
        
        % -> LengMaxx (Max. Length (ber alle Claims) der Person in Year x) (LoS: column 9)
        if isempty(Claims_it(:,9)==t)
            DatMat(i,53+t) = NaN;
        else
            DatMat(i,53+t) = max(Claims_it(:,9));
        end
        %i.e. DatMat(i,54): LengMax1, DatMat(i,55): LengMax2, DatMat(i,56): LengMax3
        
        % -> LengSumx (Summe Length (ber alle Claims) der Person in Year x) (LoS: column 9)
        if isempty(Claims_it(:,9)==t)
            DatMat(i,56+t) = NaN;
        else
            DatMat(i,56+t) = sum(Claims_it(:,9));
        end
        %i.e. DatMat(i,57): LengSum1, DatMat(i,58): LengSum2, DatMat(i,59): LengSum3
        
        
        %LOOP ber Specialties
        for j=1:length(Auspr_sp)
            %j-te Ausprgung
            j_id = Auspr_sp(j);
            %Laufindex
            spec_tj = spec_tj+1;
            % -> Specialxx (Anzahl Claims der Person in Specialty xx) (Specialty: column 6)
            DatMat(i,59+spec_tj) = sum(Claims_it(:,6)==j_id);
            %DatMat(i,60): Special_Y1_Anesthesiology
            %DatMat(i,61): Special_Y1_Diagnostic Imaging
            %DatMat(i,62): Special_Y1_Emergency
            %DatMat(i,63): Special_Y1_General Practice
            %DatMat(i,64): Special_Y1_Internal
            %DatMat(i,65): Special_Y1_Laboratory
            %DatMat(i,66): Special_Y1_OBSTETRICS AND GYNECOLOGY
            %DatMat(i,67): Special_Y1_Other
            %DatMat(i,68): Special_Y1_Pathology
            %DatMat(i,69): Special_Y1_Pediatrics
            %DatMat(i,70): Special_Y1_Rehabilitation
            %DatMat(i,71): Special_Y1_Surgery
            %DatMat(i,72): Special_Y1_Missing
            %DatMat(i,73): Special_Y2_Anesthesiology
            %DatMat(i,74): Special_Y2_Diagnostic Imaging
            %DatMat(i,75): Special_Y2_Emergency
            %DatMat(i,76): Special_Y2_General Practice
            %DatMat(i,77): Special_Y2_Internal
            %DatMat(i,78): Special_Y2_Laboratory
            %DatMat(i,79): Special_Y2_OBSTETRICS AND GYNECOLOGY
            %DatMat(i,80): Special_Y2_Other
            %DatMat(i,81): Special_Y2_Pathology
            %DatMat(i,82): Special_Y2_Pediatrics
            %DatMat(i,83): Special_Y2_Rehabilitation
            %DatMat(i,84): Special_Y2_Surgery
            %DatMat(i,85): Special_Y2_Missing
            %DatMat(i,86): Special_Y3_Anesthesiology
            %DatMat(i,87): Special_Y3_Diagnostic Imaging
            %DatMat(i,88): Special_Y3_Emergency
            %DatMat(i,89): Special_Y3_General Practice
            %DatMat(i,90): Special_Y3_Internal
            %DatMat(i,91): Special_Y3_Laboratory
            %DatMat(i,92): Special_Y3_OBSTETRICS AND GYNECOLOGY
            %DatMat(i,93): Special_Y3_Other
            %DatMat(i,94): Special_Y3_Pathology
            %DatMat(i,95): Special_Y3_Pediatrics
            %DatMat(i,96): Special_Y3_Rehabilitation
            %DatMat(i,97): Special_Y3_Surgery
            %DatMat(i,98): Special_Y3_Missing
        end%for j=1:length(Auspr_sp)
        
        %LOOP ber Places
        for j=1:length(Auspr_ps)
            %j-te Ausprgung
            j_id = Auspr_ps(j);
            %Laufindex
            place_tj = place_tj+1;
            % -> Placex (Anzahl Claims der Person in PlaceSvc x) (PlaceSvc: column 7)
            DatMat(i,98+place_tj) = sum(Claims_it(:,7)==j_id);
            %DatMat(i,99): Place_Y1_Ambulance
            %DatMat(i,100): Place_Y1_Home
            %DatMat(i,101): Place_Y1_IndependentLab
            %DatMat(i,102): Place_Y1_InpatientHospital
            %DatMat(i,103): Place_Y1_Office
            %DatMat(i,104): Place_Y1_Other
            %DatMat(i,105): Place_Y1_Outpatient_Hospital
            %DatMat(i,106): Place_Y1_Urgent_Care
            %DatMat(i,107): Place_Y1_Miss
            %DatMat(i,108): Place_Y2_Ambulance
            %DatMat(i,109): Place_Y2_Home
            %DatMat(i,110): Place_Y2_IndependentLab
            %DatMat(i,111): Place_Y2_InpatientHospital
            %DatMat(i,112): Place_Y2_Office
            %DatMat(i,113): Place_Y2_Other
            %DatMat(i,114): Place_Y2_Outpatient_Hospital
            %DatMat(i,115): Place_Y2_Urgent_Care
            %DatMat(i,116): Place_Y2_Miss
            %DatMat(i,117): Place_Y3_Ambulance
            %DatMat(i,118): Place_Y3_Home
            %DatMat(i,119): Place_Y3_IndependentLab
            %DatMat(i,120): Place_Y3_InpatientHospital
            %DatMat(i,121): Place_Y3_Office
            %DatMat(i,122): Place_Y3_Other
            %DatMat(i,123): Place_Y3_Outpatient_Hospital
            %DatMat(i,124): Place_Y3_Urgent_Care
            %DatMat(i,125): Place_Y3_Miss
        end%for j=1:length(Auspr_sp)
        
        % -> PayDelay (Mittl. PayDelay (ber alle Claims) der Person  in Year y) (PayDelay: column 8)
        DatMat(i,126+t) = mean(Claims_it(:,8));
        %DatMat(i,126): PayDelay (siehe unten)
        %DatMat(i,127): PayDelayY1
        %DatMat(i,128): PayDelayY2
        %DatMat(i,129): PayDelayY3
        
        %LOOP ber CharlsonIndex
        %CharlsonIndex of Memb_id (CharlsonIndex: column 12)
        CharlsInd = Claims_it(:,12);
        for j=0:3
            %Laufindex
            charl_tj = charl_tj+1;
            if isempty(CharlsInd)
                %falls es keinen Claim in Year x gibt
                DatMat(i,133+charl_tj) = NaN;
            else
                % -> Charlsonx (1 bei jeder Person beim max. (ber alle Claims) CharlsonIndex x in Year y)
                DatMat(i,133+charl_tj) = (max(CharlsInd)==j)+0; %+0 macht's numerisch
                %DatMat(i,130): Charlson_0 (siehe unten)
                %DatMat(i,131): Charlson_1-2 (siehe unten)
                %DatMat(i,132): Charlson_3-4 (siehe unten)
                %DatMat(i,133): Charlson_5+ (siehe unten)
                %DatMat(i,134): CharlsonY1_0
                %DatMat(i,135): CharlsonY1_1-2
                %DatMat(i,136): CharlsonY1_3-4
                %DatMat(i,137): CharlsonY1_5+
                %DatMat(i,138): CharlsonY2_0
                %DatMat(i,139): CharlsonY2_1-2
                %DatMat(i,140): CharlsonY2_3-4
                %DatMat(i,141): CharlsonY2_5+
                %DatMat(i,142): CharlsonY3_0
                %DatMat(i,143): CharlsonY3_1-2
                %DatMat(i,144): CharlsonY3_3-4
                %DatMat(i,145): CharlsonY3_5+
            end%if isempty(CharlsInd)
            
        end%for j=0:3
        
    end%for t=1:3
    %----------------------------------------------------------------------
    
    % -> PayDelay (Mittl. PayDelay (ber alle Claims) der Person) (PayDelay: column 8)
    DatMat(i,126) = mean(Claims_i(:,8));
    
    %LOOP ber CharlsonIndex
    %CharlsonIndex of Memb_id (CharlsonIndex: column 12)
    CharlsInd = Claims_i(:,12);
    for j=0:3
        % -> CharlsonYyx (1 bei jeder Person beim max. (ber alle Claims) CharlsonIndex x)       
        if isempty(CharlsInd)
            DatMat(i,130+j) = NaN;
        else
            DatMat(i,130+j) = (max(CharlsInd)==j)+0; %+0 macht's numerisch
        end
    end%for j=0:3
     
    
    
    
    %------- DaysInHospital_Y2 --------
    %Identifikation von Memb_id in DaysInHospital_Y2
    indHY2_i = DaysInHospital_Y2_table(:,1)==Memb_id;
    if sum(indHY2_i)==0
        %falls Memb_id nicht in DaysInHospital_Y2 auftaucht
        DatMat(i,146) = NaN;
        DatMat(i,147) = NaN;
    else
        % -> ClaimTrunc2 (ClaimsTruncated in DaysInHospital_Y2 (ClaimsTruncated: column 2))
        DatMat(i,146) = DaysInHospital_Y2_table(indHY2_i,2);
        % -> DaysHosp2 (DaysInHospital_Y2: column 3)
        DatMat(i,147) = DaysInHospital_Y2_table(indHY2_i,3);
    end%if sum(indHY2_i)==0
    
    
    %------- DaysInHospital_Y3 --------
    %Identifikation von Memb_id in DaysInHospital_Y3
    indHY3_i = DaysInHospital_Y3_table(:,1)==Memb_id;
    if sum(indHY3_i)==0
        %falls Memb_id nicht in DaysInHospital_Y3 auftaucht
        DatMat(i,148) = NaN;
        DatMat(i,149) = NaN;
    else
        % -> ClaimTrunc3 (ClaimsTruncated in DaysInHospital_Y3 (ClaimsTruncated: column 2))
        DatMat(i,148) = DaysInHospital_Y3_table(indHY3_i,2);
        % -> DaysHosp3 (DaysInHospital_Y3: column 3)
        DatMat(i,149) = DaysInHospital_Y3_table(indHY3_i,3);
    end%if sum(indHY3_i)==0
    
    
    %------- DrugCount --------
    %LOOP ber die Zeit
    for t=1:3
        %Identifikation von Memb_id im Jahr t in DrugCount_table
        ind_it = (DrugCount_table(:,1)==Memb_id) & (DrugCount_table(:,2)==t);
        % -> Drugx (Summe (ber alle DSFS) der DrugCounts in Year x) (DrugCount: column 4)
        DatMat(i,149+t) = sum(DrugCount_table(ind_it,4));
        %DatMat(i,150): Drug1, DatMat(i,151): Drug2, DatMat(i,152): Drug3
    end%for t=1:3
    
    
    %------- LabCount --------
    %LOOP ber die Zeit
    for t=1:3
        %Identifikation von Memb_id im Jahr t in LabCount_table
        ind_it = (LabCount_table(:,1)==Memb_id) & (LabCount_table(:,2)==t);
        % -> Labx (Summe (ber alle DSFS) der LabCounts in Year x) (LabCount: column 4)
        DatMat(i,152+t) = sum(LabCount_table(ind_it,4));
        %DatMat(i,153): Lab1, DatMat(i,154): Lab2, DatMat(i,155): Lab3
    end%for t=1:3
    
    
    %------ Members  -------
    %Identifikation von Memb_id in Members_table
    ind_i = Members_table(:,1)==Memb_id;
    % -> Age (AgeAtFirstClaim) (AgeAtFirstClaim: column 2)
    DatMat(i,156) = Members_table(ind_i,2);
    % -> AgeMiss (1 falls AgeAtFirstClaim fehlt) (AgeAtFirstClaim: column 2)
    DatMat(i,157) = isnan(Members_table(ind_i,2));
    % -> Sex (Biological sex of member: 1 = Male; 0=Female: column 3)
    DatMat(i,158) = Members_table(ind_i,3);
    % -> SexMiss (1 falls Sex fehlt) (Sex: column 3)
    DatMat(i,159) = isnan(Members_table(ind_i,3));
    
    
    %------ Target --------
    %Identifikation von Memb_id in Members_table
    ind_i = Target_table(:,1)==Memb_id;
    % -> ClaimTruncT (ClaimsTruncated (Target)) (ClaimsTruncated: column 2)
    %Members with truncated claims in the year prior to the main outcome are assigned a value of 1, and 0 otherwise.
    if sum(ind_i)==0
        DatMat(i,160) = NaN;
    else
        DatMat(i,160) = Target_table(ind_i,2);
    end
    
end%for i=1:N_ALLMemb

clearvars -except DatMat
save dataset.mat