/*------------------------------------------------------------------------------*/
/*                  DDDDDDDDD      IIIIIIIII   PPPPPPPPPP                       */
/*                  DDD    DDD        III      PPP     PPP                      */
/*                  DDD     DDD       III      PPP      PPP                     */
/*                  DDD      DDD      III      PPP     PPP                      */
/*                  DDD      DDD      III      PPPPPPPPPP                       */
/*                  DDD     DDD       III      PPP                              */
/*                  DDD    DDD        III      PPP                              */
/*                  DDDDDDDDD      IIIIIIIII   PPP                              */
/*------------------------------------------------------------------------------*/

/*Started 07/10/04--Revised 11/30/06*/

new;
library distrib modal pgraph;

format /rd 10,4;

output file = c:\HPR2006(JAE)\output\test.out;
output reset;

screen on;

/*----------------------------------User Input Section-------------------------*/
        
/*n = # of data points, k = # of data sets to run over*/

n = 22;
k = 1;
											            
/*List where the data is located*/
load xt[n,k] = c:\HPR2006(JAE)\Codes\chondrit.dat;

datap = 0;

if datap == 1;

    xt;stop;

endif;

/*Eliminate Oil Countries from the data set*/
/*
cutq = xt[.,1] .eq 816584;
cutk = xt[.,1] .eq 758784;
cutb = xt[.,1] .eq 668278;
cuts = xt[.,1] .eq 836585;
cutu = xt[.,1] .eq 658269;

cut = cutq+cutb+cutk+cuts+cutu;

xt = delif(xt, cut);

n = rows(xt);*/

/*w = 1 will run weighted dip test*/

w = 0;

/*ww is the column that GAUSS will create the weights from*/
/*The vector that weights should come before the rest of the data to analyze*/

ww = 0;

if w == 1;

    weight  = xt[.,ww]/sumc(xt[.,ww]);
    number  = inv(weight[minindc(weight)]);
    num1    = ceil(number*weight); 

    wxv = zeros(sumc(num1),(cols(xt)-ww));

    c2 = 1;

    for c1 (1, n, 1);

        for c3 (1, num1[c1], 1);
                
            wxv[c2,.] = xt[c1,(ww+1):cols(xt)];

            c2 = c2 + 1;
            
        endfor;
                
    endfor;

    nex = sumc(num1);    
            
else;

    wxv  = xt[.,(ww+1):k];
    weight = ones(n,1);
    nex  = n;            

endif;

/*g = number of kernel evaluation points*/	

g = 512;

/*b = # of bootstrap replications*/

b =  1000;

/*Create gamma values for student t and beta distributions*/

start = 1;
jump1 = .0005;
jump2 = .1;

/*Generate values for Symmetric Beta Distribution*/

betavb = zeros(3800,1);
gammvb = zeros(3800,1);

for i (1, 3000, 1);

    betavb[i] = start+(i-1)*jump1;
    gammvb[i] = 2^(4*betavb[i]-1)*(betavb[i]-1)*(beta(betavb[i],betavb[i]))^2;

endfor;

start2 = start+2999*jump1;

for i (1,800,1);

    t = start2+i*jump2;
    betavb[i+3000] = t;
    gammvb[i+3000] = 2^(4*t-1)*(t-1)*(beta(t,t))^2;

endfor;

start1 = .505+machepsilon;
jump1 = .0005;
jump2 = .1;

/*Generate values for Rescaled t Distribution*/

betavt = zeros(3800,1);
gammvt = zeros(3800,1);
    
for i (1, 3000, 1);

    betavt[i] = start1+(i-1)*jump1;
    gammvt[i] = 2*betavt[i]*(beta(betavt[i]-.5, .5))^2;

endfor;
        
start3 = start+2999*jump1;

for i (1,800,1);

    t = start3 +i*jump2;
    betavt[i+3000] = t;
    gammvt[i+3000] = 2*t*(beta(t-.5, .5))^2;

endfor;

/*Transform the data, 1 mean; 2 sum; 3 logarithmic*/

t = 0;

/*--------------------End of User ID section of Code---------------*/

for jj (1,k-ww,1);timedt;

    xvar = sortc(wxv[.,jj],1);
    
    if t == 1;

        xvar = xvar/meanc(xvar);
      
    elseif t == 2;

        xvar = xvar/sumc(xvar);
        
    elseif t == 3;

        xvar = ln(xvar);
   
    endif;

    x = xvar;

    {dip, xlow, xup, mn, mj} = dipstat(x);

    /*Creating a kernel estimate for the unknown distribution factor*/

    /*Create kernel estimate*/

    /*x = sortc(xt[.,jj+ww],1);*/
    
    grid   = seqa(x[1], (x[nex]-x[1])/(g-1),g);
    h      = 1.06*stdc(x)*nex^(-1/5);
    h2     = ((4/7)^(1/9))*stdc(x)*nex^(-1/9);
    ipi    = inv(sqrt(2*pi));

    fhat   = denest(h, ones(nex,1), x, grid);
    fhat0  = maxc(fhat);
    findx  = maxindc(fhat);
    xmax   = grid[findx];
    f2hat0 = denest2(h2, ones(nex,1), nex, xmax, x);

    dhat = abs(f2hat0)/(fhat0^3);
   
    ds = zeros(b,1);
    p_value = 0;

    /*Determine Betahat*/

    for i (1, b, 1);

        if dhat le gammvb[3800];   

            track = minindc(abs(gammvb-dhat));

            betahat = betavb[track];

            repvar = rndbeta(n,1,betahat,betahat);
            {d, xl, xu, mn, mj} = dipstat(repvar);
        
            if d gt dip;
        
                p_value = p_value + 1;
                
            endif;

        elseif dhat ge gammvt[3800];

            track = minindc(abs(gammvt-dhat));

            betahat = betavt[track];

            df                  = 2 * betahat - 1;
            repvar              =     rndst(n,df);
            {d, xl, xu, mn, mj} = dipstat(repvar);
        
            if d gt dip;
        
                p_value = p_value + 1;
                
            endif;

        else;

            betahat = 2*pi;

            repvar = rndn(n,1);
            {d, xl, xu, mn, mj} = dipstat(repvar);
        
            if d gt dip;
        
                p_value = p_value + 1;
                
            endif;

        endif;

        ds[i] = d;
        
    endfor;

    p_value = p_value/b;

    walpha  =      {.90, .95, .99};
    walpha  = quantile(ds, walpha);

    format /rd 8,4;

    "Dip Statistic:     "            dip;
    "W_alpha level quantiles:"   walpha';
    "P_value:           "        p_value " p < alpha is rejection of unimodality";
    "Modal Interval:    "      xlow~xup;
    "# of Observations: "             n;
    "D-Hat:             "          dhat;
    "Beta-Hat:          "       betahat;
    " ";

endfor;

/*-------------Procedures Used--------------------------------*/

proc(1) = denest(h, wayt, xvar, range);

    local j, dens, z, kelx;

    dens = 0;

    for j (1, rows(range), 1);
				
	    z    = (range[j] - xvar)/h;
	    kelx = wayt.*exp(-0.5*(z^2))*ipi;
		kelx = sumc(kelx)/(rows(xvar)*h);
	    dens = dens|kelx;

    endfor;

	dens = dens[2:rows(dens)];

    retp(dens);

endp;

proc(1) = denest2(h, wayt, n, xvar, range);

    local z, kelx;

	z    = (range - xvar)/h;
	kelx = wayt.*((z^2-1).*exp(-0.5*(z^2))*ipi);
    kelx = sumc(kelx)/(n*(h^3));
	     
	retp(kelx);

endp;

proc(1) = rndst(n,df);

    local data, betah, x, y1, y2, y, s1, s2, s3, s, u, v, lm, i;

    if df ge 2;

        betah = df/2;
        
        x = rndbeta(n,1,betah,betah);

        y1 =      (x .gt .5);
        y2 = -1 * (x .lt .5);
        y  =         y1 + y2;

        u    = ln(abs(x-.5))-.5*(ln(x)+ln(1-x));
        data =                      y .* exp(u);
            
    else;

        d    =       2/df;
        lm   =     -ln(2);
        data = zeros(n,1);
        i    =          1;

        do until i gt n;

            s = 0;

            do until (s gt 0) .and (s lt 1);

                x = rndu(1,1)^d;
                y = rndu(1,1)^d;
                s = x + y;

            endo;
                
            s       = .5*ln(x/y);
            u       =     lm + s;
            x       =     exp(u);
            v       =     lm - s;
            y       =     exp(v);
            data[i] =      x - y;
            i       =      i + 1;

        endo;

    endif;

    retp(data);

endp;

fn beta(alpha, beta) = gamma(alpha).*gamma(beta)./gamma(alpha+beta);    

end;