/*-------------------------------------------------------------------------*/
/*       BBBBBBBBBB      UUU      UUU   MMM       MMM   PPPPPPPPPP         */
/*       BBB    BBBB     UUU      UUU   MMMM     MMMM   PPP     PPP        */
/*       BBB     BBBB    UUU      UUU   MMMM     MMMM   PPP      PPP       */
/*       BBB    BBBB     UUU      UUU   MMMMM   MMMMM   PPP     PPP        */
/*       BBBBBBBBBB      UUU      UUU   MMMMMMMMMMMMM   PPPPPPPPPP         */
/*       BBB    BBBB     UUU      UUU   MMM  MMM  MMM   PPP                */
/*       BBB     BBBB    UUU      UUU   MMM   M   MMM   PPP                */
/*       BBB    BBBB      UUU    UUU    MMM       MMM   PPP                */
/*       BBBBBBBBB          UUUUUU      MMM       MMM   PPP                */
/*-------------------------------------------------------------------------*/

/*Code to Perform Silverman's Kernel Test(Allows for recalibration following Hall and York 2001)*/
/*Started 08/23/04-----------------Revised 11/21/06                                             */
/*Please note that if you have a density that is u-shpaed and there isn't enough data in        */
/*the tails to distinguish modes then the code will not perform well                            */

new;

format /rd 10,8;
/*output file = c:\HPR2006(JAE)\output\t.out;*/
output file = c:\HPR2006(JAE)\output\BianchiC.out;
output reset;

screen on;

library pgraph;
graphset;
_pvwrmode = "m";

/*----------------------------------User Input Section-------------------------*/

/*Print out Starting Time*/

timedt;
        
/*n = # of data points*/

n = 119;
k = 3;

/*List where the data is located, x is the actual data with a vector of weights, ex is the weighted vector to bootstrap from*/

load xt[n,k] = c:\HPR2006(JAE)\Data\AllGDP\Bianchi.txt;

datap = 0;

if datap == 1;

    xt;
    stop;

endif;

/*g = number of kernel evaluation points*/	

g = 512;

/*d =  increment to decrease bandwidth while searching*/

d = 6000;  /*The larger down is the longer the code will run*/
		
/*c = indicator whether to perform normal silverman or recalibrated test*/

c = 1;    /*c = 1 will calibrate testing procedure*/

/*mm = # of modes interested in graphing and testing against*/

mm = 2;    /*If using the Calibrated Test then Maxmode == 2 */

/*p = persistence towards finding a mode*/

p = 2;  /*p should be no lower than 2 for robust results*/

/*alpha = signifigance level for calibrated method*/

alpha = .05;

/*f = indicator to graph kernel density estimates*/

f = 0;    /*f = 1 will graph densities*/

/*o = 1 indicator to graph densities on top of one another*/

o = 0;  /*o = 1 will print densities on same graph*/

/*pval = indicator whether to perform signifigance testing*/

pval = 1;  /*pval = 1 will perform bandwidth testing*/

/*b = # of bootstrap replications when pval = 1*/

b = 999;

/*Transform the data, 1 mean; 2 sum; 3 logarithmic*/

t = 0;

/*w = 1 will run weighted silverman test*/

w = 0;

/*ww is the column that GAUSS will create the weights from*/
/*The vector that weights should come before the rest of the data to analyze*/

ww = 0;

if w == 1;

    weight  = xt[.,ww]/sumc(xt[.,ww]);
    number  = inv(weight[minindc(weight)]);
    num1    = ceil(number*weight); 

    wxvar = zeros(sumc(num1),(cols(xt)-ww));

    c2 = 1;

    for c1 (1, n, 1);

        for c3 (1, num1[c1], 1);
                
            wxvar[c2,.] = xt[c1,(ww+1):cols(xt)];

            c2 = c2 + 1;
            
        endfor;
                
    endfor;

    nex     = sumc(num1);    
            
else;

    weight = ones(n,1);
    wxvar  = xt[.,(ww+1):k];
    nex    = n;            

endif;

/*up1  will enlarge from above the interval over which to search for h, up2 will enlarge from below*/

up1 = 4;
up2 = .2;

/*tol is the tolerance to modes created by the tail points, the bigger it is the less tolerance*/

tol = 0; /*Cheng and Hall recommend 1.5*/

/*switch = 1 will print out kernel density estimates for each bootstrap iteration--not recommended*/

switch = 0;

/*--------------------End of User ID section of Code---------------*/

/*Creating the calibration number for the significance level*/
/*See Hall and York 2001, pg. 524*/

if c == 1;
        
    a1 =   .94029;
    a2 = -1.59914;
    a3 =   .17695;
    a4 =   .48971;
    a5 = -1.77793;
    a6 =   .36162;
    a7 =   .42423;

    lambda = (a1*alpha^3 + a2*alpha^2 + a3*alpha + a4)/(alpha^3+a5*alpha^2+a6*alpha+a7);
        
else;
        
lambda = 1;

endif;

/*-----------------------------------------------------------------*/
/*---------------Start the Loop for Multiple Tests-----------------*/
/*-----------------------------------------------------------------*/
        
for jj (ww+1,k,1);

    x = sortc(xt[.,jj],1);
    wx = sortc(wxvar[.,(jj-ww)],1);

    if t == 1;

        x = x/meanc(x);
        wx = wx/meanc(wx);

    elseif t ==2;

        x = x/sumc(x);
        wx = wx/sumc(wx);

    elseif t ==3;

        x = ln(x);
        wx = ln(wx);

    endif;

    /*Specifying the data vector to evaluate modes*/

    ipi    = inv(sqrt(2*pi));
	xrange = x[n] - x[1];
	adj    = xrange * inv(g);
	l_h    = seqa(x[1], adj, g+1);

    /*Find variance and optimal bandwidth of data*/

	oph      = 1.06 * stdc(x) * (n^(-.2));
    hu       = up1*oph;
    hl       = up2*oph;
    inc      = (hu-hl)/d;
    hs       = seqa(hu,-inc,d);                     	 
    numbmode = zeros(rows(hs),1);
    bandwith = zeros(rows(hs),1);

    /*-------------------------------------------------------*/
    /*-------------------Start Silverman Test----------------*/         
    /*Starting the loop to determine the critical bandwidths */
    /*-------------------------------------------------------*/

    for j (1, rows(hs), 1);

        /*Create kernel estimate*/

        h     = hs[j];
        dens  = denest(h, weight, x, l_h);
        kzero = tol*ipi*inv(n*h);

        /*Determine the number of modes for the density*/

        numbmod = mode(dens, kzero);			

        /*Store Values*/

        numbmode[j] = numbmod;
        bandwith[j] = h;    

    endfor;

    /*Determine the optimal bandwidths for each mode*/

    band0 = (bandwith .eq 0);
    mode0 = (numbmode .eq 0);

    bandwith = delif(bandwith, band0);
    numbmode = delif(numbmode, mode0);

    crit   = numbmode[1:(rows(numbmode)-1)] - numbmode[2:rows(numbmode)];
    select = (crit .lt 0)|0;

    hcrit  = selif(bandwith, select);
    numod  = selif(numbmode, select);

    /*Print modes versus bandwidths*/

    _pdate  = "";
    scale(bandwith,numbmode);
    xlabel("Bandwidth");
    ylabel("Number of Modes");
    ytics(0,mm+1,1,0);
    _plctrl =  { 0 };
    _pltype =  { 6 };
    _pstype =  { 1 };
    _pcolor =  15;
    fonts("simplex");
    xy(bandwith, numbmode);

    /*Display number of modes along with critical bandwidths*/

    print jj;
    print "Critical Bandwidth  # of modes";
    print hcrit~numod;

    /*-------------------------------------------------------*/
    /*---------------------Graphing Section------------------*/
    /*-------------------------------------------------------*/

    if f == 1;

        kerns = zeros(g+1, mm);
        k0    = zeros(g+1, mm); 

        for i (1, mm-1, 1);

            h = hcrit[i];

      	    kerns[.,i] = denest(h, weight, x, l_h);
            k0[.,i]    = tol*ipi*inv(n*h)*ones(g+1,1);

        endfor;

        if o == 1;

            _pdate="";
            scale(l_h,kerns);
            xlabel("X-variable");
            ylabel("Density Estimates");
            _plctrl = { 0 };
            _pltype = { 6 };
            _pstype = { 1 2 3 4};
            _pcolor = 15;
            fonts("simplex");
            xy(l_h~l_h,kerns~k0); 

        else;

            for i (1, mm-1, 1);

                _pdate="";
                scale(l_h,kerns);
                xlabel("X-variable");
                ylabel("Density Estimates");
                _plctrl = { 0, 0, 0, 0, 0, 0, 0 };
                _pltype = { 6, 5, 5, 5, 5, 5, 5 };
                _pstype = { 1 2 3 4};
                _pcolor = 15;
                fonts("simplex");
                xy(l_h~l_h,kerns[.,i]~k0[.,i]); 

            endfor;
                
        endif;

    endif;

    /*-------------------------------------------------------*/
    /*----------------Bootstrap Section----------------------*/
    /*-------------------------------------------------------*/

    if pval == 1;

        pvalue = 0;
            
		for j (1, (mm-1), 1);

		    pvalue = 0;

			for i (1, b, 1);
            
                seed = 14+23*i+5*jj+2*j;
				
				cindex = ceil(rndus(n,1,seed)*nex);
				qvar   = wx[cindex];
				e      = rndn(n,1);
		
			    /*Initialize the Transformation of the Data*/

				qvar = meanc(qvar) + inv(sqrt(1 + (hcrit[j]^2) * inv(stdc(x)^2))) .* (qvar - meanc(qvar) + hcrit[j] * e);
                qvar = sortc(qvar,1);

			    if c == 1 and j == 1;

                    h = hcrit[j]*lambda;

                else;

                    h = hcrit[j];

                endif;

                qrange  = qvar[n] - qvar[1];
		        adj     = qrange * inv(g);
		        ql_h    = seqa(qvar[1], adj, g+1);
      	        samp    = denest(h, ones(n,1), qvar, ql_h);
                kzeros  = tol*ipi*inv(n*h);

                if switch == 1;

                    scale(ql_h,samp);
                    xy(ql_h,samp); 

                endif;

                numbmod = mode(samp, kzeros);

                if numbmod gt j;	
				
				    pvalue = pvalue + 1;

			    endif;
				
			endfor;	

			pvalue = pvalue/b;			/*Calculating the P-value*/
				
			print "Critical Bandwidth   # of Modes   Alpha Level Test";
            print "  " h "         " j "         " pvalue;
                			
		endfor;

    endif;

    /*Print Out Ending time*/

    timedt;

endfor;

/*-------------------------------------------------------*/
/*---------------------Procedures------------------------*/
/*-------------------------------------------------------*/

/*Density Estimate*/

proc(1) = denest(h, wayt, xvar, range);

    local j, dens, z, kelx;

    dens = 0;

    for j (1, rows(range), 1);
				
	    z    = (range[j] - xvar)/h;
	    kelx = wayt.*exp(-0.5*(z^2))*ipi;
		kelx = sumc(kelx)/(rows(xvar)*h);
	    dens = dens|kelx;

    endfor;

	dens = dens[2:rows(dens)];

    retp(dens);

endp;

/*Calculate the number of modes*/

proc(1) = mode(dens, kzero);

    local denslow, denshigh, change, dec_inc, count, j;
    local nextp, numbmod, above;

    /*Determine the values of the kernel that are above the tail cutoff*/

    above = dens .ge kzero;
    above = above|0;        /*The last point will not represent a mode*/

    /*Here we shift dens up by one and down by one to determine slope changes*/

    denslow  = 0|dens;
    denshigh = dens|0;
    change   = denshigh - denslow;

    /*Here we determine which parts of the kernel are increasing and decreasing*/

    dec_inc = (change .gt 0);   /*1 for increasing, 0 for decreasing*/
    count   = zeros(rows(dec_inc),1);
      
    for j (1, (rows(count)-p), 1);    

        nextp = sumc(dec_inc[j:j+p]);

        if nextp .gt 1;
    
            count[j] = 1;

        endif;

    endfor;

    /*Here we determine how many modes we have*/

    dec_inc = delif(dec_inc, count);
    above   = delif(above, count);
    dec_inc = dec_inc.*above;
    numbmod = sumc(dec_inc);  /*This is the number of modes*/

    retp(numbmod);

endp;
         
end;
                


            