%Alexander Heinemann
%Efficient Estimation of Factor Models with Time and Cross-Sectional Dependence
%Journal of Applied Econometrics
%
%Table 1

clear;
clc;


%Storage space
    store_normal_Yes_AR1_AR1 = zeros(9,4);  %Case (i), Stationary
    store_normal_Yes_AR1_IN = zeros(9,4);   %Case (ii), Stationary
    store_normal_Yes_IT_AR1 = zeros(9,4);   %Case (iii), Stationary
    store_normal_Yes_MA1_MA1 = zeros(9,4);  %Case (iv), Stationary
    store_normal_Yes_MS1_MS1 = zeros(9,4);  %Case (v*), Stationary
    store_normal_Yes_MS2_MS2 = zeros(9,4);  %Case (vi*), Stationary

    store_normal_No_AR1_AR1 = zeros(9,4);   %Case (i), Non-stationary
    store_normal_No_AR1_IN = zeros(9,4);    %Case (ii), Non-stationary
    store_normal_No_IT_AR1 = zeros(9,4);    %Case (iii), Non-stationary
    store_normal_No_MA1_MA1 = zeros(9,4);   %Case (iv), Non-stationary
    store_normal_No_MS1_MS1 = zeros(9,4);   %Case (v*), Non-stationary
    store_normal_No_MS2_MS2 = zeros(9,4);   %Case (vi*), Non-stationary



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%STATIONARY%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%AR1%%AR1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_AR1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%AR1%%I_N%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_AR1_IN(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'





%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%I_T%%AR1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_IT_AR1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%MA1%%MA1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MA1_MA1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'




%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%MS1%%MS1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS1_MS1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'


%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%MS2%%MS2%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'Yes'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_Yes_MS2_MS2(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%NON-STATIONARY%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%AR1%%AR1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_AR1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%AR1%%I_N%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'I_N'; corrstruct_Phi = 'AR1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_AR1_IN(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'





%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%I_T%%AR1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'AR1'; corrstruct_Phi = 'I_T'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_IT_AR1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%MA1%%MA1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'MA1'; estimatestruct_Phi = 'MA1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MA1_MA1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'




%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%MS1%%MS1%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'Normal'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS1_MS1(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%MS2%%MS2%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%

r = 1; N = 50; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(1,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(2,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 50; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(3,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 100; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(4,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(5,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 100; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(6,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'



r = 1; N = 200; T = 50; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(7,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 100; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(8,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'

r = 1; N = 200; T = 200; corrstruct_Theta = 'MA1'; corrstruct_Phi = 'MA1'; stationary = 'No'; estimatestruct_Theta = 'AR1'; estimatestruct_Phi = 'AR1';  distribution = 'BreitungTenhofen'; 
display(strcat(corrstruct_Phi,'_',corrstruct_Theta,'_',stationary,'_',estimatestruct_Theta,'_',estimatestruct_Phi,'_N',int2str(N),'_T',int2str(T),'_r',int2str(r),'_',distribution));
store_normal_No_MS2_MS2(9,:) = Simulator(r,N,T,corrstruct_Theta, corrstruct_Phi,stationary,estimatestruct_Theta,estimatestruct_Phi,distribution)'





%%%%%%Tables%%%%%%%%%%%%%%%%%%%%%%%
table_PCA = [store_normal_Yes_AR1_AR1(:,1) store_normal_Yes_AR1_IN(:,1) store_normal_Yes_IT_AR1(:,1) store_normal_Yes_MA1_MA1(:,1) store_normal_Yes_MS1_MS1(:,1) store_normal_Yes_MS2_MS2(:,1) store_normal_No_AR1_AR1(:,1) store_normal_No_AR1_IN(:,1) store_normal_No_IT_AR1(:,1) store_normal_No_MA1_MA1(:,1) store_normal_No_MS1_MS1(:,1) store_normal_No_MS2_MS2(:,1)];
table_GLS = [store_normal_Yes_AR1_AR1(:,2) store_normal_Yes_AR1_IN(:,2) store_normal_Yes_IT_AR1(:,2) store_normal_Yes_MA1_MA1(:,2) store_normal_Yes_MS1_MS1(:,2) store_normal_Yes_MS2_MS2(:,2) store_normal_No_AR1_AR1(:,2) store_normal_No_AR1_IN(:,2) store_normal_No_IT_AR1(:,2) store_normal_No_MA1_MA1(:,2) store_normal_No_MS1_MS1(:,2) store_normal_No_MS2_MS2(:,2)];
table_BT = [store_normal_Yes_AR1_AR1(:,3) store_normal_Yes_AR1_IN(:,3) store_normal_Yes_IT_AR1(:,3) store_normal_Yes_MA1_MA1(:,3) store_normal_Yes_MS1_MS1(:,3) store_normal_Yes_MS2_MS2(:,3) store_normal_No_AR1_AR1(:,3) store_normal_No_AR1_IN(:,3) store_normal_No_IT_AR1(:,3) store_normal_No_MA1_MA1(:,3) store_normal_No_MS1_MS1(:,3) store_normal_No_MS2_MS2(:,3)];
table_CH = [store_normal_Yes_AR1_AR1(:,4) store_normal_Yes_AR1_IN(:,4) store_normal_Yes_IT_AR1(:,4) store_normal_Yes_MA1_MA1(:,4) store_normal_Yes_MS1_MS1(:,4) store_normal_Yes_MS2_MS2(:,4) store_normal_No_AR1_AR1(:,4) store_normal_No_AR1_IN(:,4) store_normal_No_IT_AR1(:,4) store_normal_No_MA1_MA1(:,4) store_normal_No_MS1_MS1(:,4) store_normal_No_MS2_MS2(:,4)];

format bank
display(table_GLS*100);
display(table_BT*100);
display(table_CH*100);
display(table_PCA*100);

%save normal_table.mat
