library(metRology)
#set.seed()
sim <- 10000
OLS.selection <- c()
t.selection <- c()
t2.selection <- c()
N.selection <- c()
check <- c()
RSS.check <- matrix(0,nr=sim,nc=2)
loglik.check <- matrix(0,nr=sim,nc=2)
loglik.check2 <- matrix(0,nr=sim,nc=2)
loglik.checkN <- matrix(0,nr=sim,nc=2)

for (iter in 1:sim){
  n <- 100
  x <- rnorm((n+101),0,1)
  y <- rep(0,(n+101))
  eps <- rt((n+101),3)

  for (i in (n+100):1){
    y[i] <- 0.6*y[i+1] + 0.5*x[i] + eps[i]
  }
  y <- y[52:(n+51)]
  x <- x[52:(n+51)]
  n <- length(y)

  ## Estimate models by OLS
  ols.c  <- lm(y[2:(n-1)]~cbind(y[1:(n-2)],x[1:(n-2)]))
  ols.nc <- lm(y[2:(n-1)]~cbind(y[3:n],x[2:(n-1)]))
  
  RSS.c <- sum(ols.c$residuals^2)
  RSS.nc <- sum(ols.nc$residuals^2)
  
  RSS.check[iter,] <- c(RSS.c,RSS.nc)

  if (RSS.c < RSS.nc){
    OLS.selection[iter] <- 1
  }
  else{
    OLS.selection[iter] <- 0
  }
  
  ## Estimate models by MARX t-MLE
  mle.c <- MARX::selection.lag.lead(y[2:(n-1)],x[2:(n-1)],1) ## Check first loglik
  mle.nc <- MARX::selection.lag.lead(y[2:(n-1)],x[2:(n-1)],1) ## Check second loglik
  
  if (mle.c$loglikelihood[1] > mle.nc$loglikelihood[2]){
    t.selection[iter] <- 1
  }
  else{
    t.selection[iter] <- 0
  }
  loglik.check[iter,] <- cbind(mle.c$loglikelihood[1], mle.nc$loglikelihood[2])
  
  #if(OLS.selection[iter] != t.selection[iter]){
  #  check[iter] <- 1
  #}
  #else{
  #  check[iter] <- 0
  #}
  
  ## Data sets for logliks below
  data.c <- cbind(y[2:(n-1)],rep(1,(n-2)),y[1:(n-2)],x[1:(n-2)])     # rep(1,(n-2))
  data.nc <- cbind(y[2:(n-1)],rep(1,(n-2)),y[3:n],x[2:(n-1)])    # rep(1,(n-2))
  
  ## Estimate models by t-MLE using logliks below
  t.mle.c <- optim(c(ols.c$coefficients,10), t.lik_ARX, y=data.c, method="BFGS", hessian=TRUE)
  t.mle.nc <- optim(c(ols.nc$coefficients,10), t.lik_ARX, y=data.nc, method="BFGS", hessian=TRUE)
  
  if (-t.mle.c$value > -t.mle.nc$value){
    t2.selection[iter] <- 1
  }
  else{
    t2.selection[iter] <- 0
  }
  loglik.check2[iter,] <- cbind(-t.mle.c$value, -t.mle.nc$value)

  ## Estimte models by Gaussian MLE using logliks below
  N.mle.c <- optim(c(ols.c$coefficients,10,10), norm.lik_ARX, y=data.c, method="BFGS", hessian=TRUE)
  N.mle.nc <- optim(c(ols.nc$coefficients,10,10), norm.lik_ARX, y=data.nc, method="BFGS", hessian=TRUE)

  if (-N.mle.c$value > -N.mle.nc$value){
    N.selection[iter] <- 1
  }
  else{
    N.selection[iter] <- 0
  }
  loglik.checkN[iter,] <- cbind(-N.mle.c$value, -N.mle.nc$value)

  print(iter)
}


table(OLS.selection)
table(t.selection)
table(N.selection)

## Gaussian Likelihoods
norm.lik_ARX <- function(param, y){
  theta <- c(1, -param[1], -param[2],-param[3])
  input <- y %*% theta
  logl <- sum(dnorm(input, mean=param[4], sd=param[5], log=TRUE))
  return(-logl)
}

norm.lik_AR <- function(param, y){
  theta <- c(1, -param[1], -param[2])
  input <- y %*% theta
  logl <- sum(dnorm(input, mean=param[3], sd=param[4], log=TRUE))
  return(-logl)
}


## Student-t Likelihoods
t.lik_ARX <- function(param, y){
  theta <- c(1, -param[1], -param[2],-param[3])
  input <- y %*% theta
  logl <- sum(dt(input, df=param[4], log=TRUE))
  return(-logl)
}

t.lik_AR <- function(param, y){
  theta <- c(1, -param[1],-param[2])
  input <- y %*% theta
  logl <- sum(dt(input, df=param[3], log=TRUE))
  return(-logl)
}