rm(list = ls())
w.dir <- ""

###----------------------------------- Packages and functions ---------------------------
require(Matrix)
require(MASS)
require(mvtnorm)

source(paste0(w.dir, "xx_optim.func.R"))

##################################### BEGIN GRID #######################################
application <- "US"
data.freq <- "Q"
trans <- "I0"
end.in <- seq(1988, 2018.75,1/4)
p <- 5
if(trans == "I0") type.conjugate.grid <- c("MIN") else type.conjugate.grid <- c("MIN", "MIN-SOC-SUR") 
var.set <- c("small", "PCA-3", "medium")

# Larger model sets --> variation of hyperparameters
grid.optim <- expand.grid(end.in = end.in, trans = trans, var.set = var.set, type = type.conjugate.grid, common.sv = FALSE, stringsAsFactors = FALSE)


#if(2018 %in% year.grid){grid <- grid[-which(grid[,"year"] == 2018 & grid[,"freq"] == 4),]}

##################################### END GRID #######################################
run <- as.integer(Sys.getenv("SGE_TASK_ID"))
run <- 1
for(run in 1:nrow(grid.optim)){
###----------------------------------------- Specifications --------------------------
var.set <- grid.optim[run,"var.set"]
end.in <- grid.optim[run,"end.in"]

hyperpara.type <- grid.optim[run, "hyperpara.type"]
common.sv <- grid.optim[run, "common.sv"]
dummy.type <- grid.optim[run, "type"]
prior.on <- grid.optim[run, "prior.on"]

output.var <- c("GDPC1")
inf.var <- c("CPIAUCSL")
forc.var <- c(output.var, inf.var,  "FEDFUNDS")
cons <- TRUE

load(paste0(w.dir, "FREDdata/Xraw_Q.rda"))
if(trans == "I0") Yraw <- Xraw.stat else if(trans == "I1") Yraw <- Xraw.int

if(var.set == "small")  Yraw <- Yraw[,forc.var]
if(var.set == "medium") Yraw <- Yraw[,variables.medium]

end.in <- end.in
Yraw <- window(Yraw, end = end.in)
var.names <- colnames(Yraw)
  
#Compute uncertainty measure according to Jurado et al. (2015)
mean.in <- apply(Yraw, 2, mean)[forc.var]
sd.in <- apply(Yraw, 2, sd)[forc.var]
Yraw <- apply(Yraw, 2, function(x)(x-mean(x))/sd(x))
Yraw <- ts(Yraw, end = end.in, frequency = 4)

if(substr(var.set,1,3) == "PCA"){
  Yfac <- Yraw[,-which(colnames(Yraw) %in% forc.var)]
  nfac <- as.numeric(substr(var.set, 5,5))
  Yfac <- extract(data = Yfac, k = nfac)[[1]]
  Yfac <- apply(Yfac, 2, function(x){(x-mean(x))/sd(x)})
  
  Yraw <- cbind(Yraw[,forc.var], Yfac)
  colnames(Yraw) <-  c(forc.var, paste0("fac", "", (1:nfac)))
} 
matplot(Yraw, type = "l")

optim.setup <- list(hyper.optim = TRUE, optim.out = 20, prior.on = prior.on, var.set = var.set)

if(dummy.type == "MIN"){
  grid.list <- list(theta.grid = c(0.01, 0.025, 0.050, 0.075, 0.10, 0.125, 0.15, 0.20, 0.25, 0.30, 0.35, 0.40, 0.45, 0.50, 0.75, 1, 2, 5), w.1.grid =  1, w.2.grid = 1)
}

if(dummy.type == "MIN-SOC-SUR")
{  
  grid.list <- list(theta.grid = c(0.05, 0.1, 0.15, 0.2, 0.3, 0.4, 0.5), w.1.grid =  c(0.25, 0.5, 1, 1.5, 2, 2.5, 3), w.2.grid =  c(0.25, 0.5, 1, 1.5, 2, 2.5, 3))
}


theta.prior <- gammacoef(mode = 1, sd = 0.4) 

if(var.set == "xlarge"){
    theta.prior <- gammacoef(mode = 0.025, sd = 0.001)
}
w.1.prior <- w.2.prior <- gammacoef(mode = 1, sd = 1)
  
ML.prior <- list(theta.prior = theta.prior, w.1.prior = w.1.prior, w.2.prior = w.2.prior,  gamma.prior = 0.01)
prior.list <- list(dummy.type = dummy.type, ML.prior = ML.prior, grid.list = grid.list)

# Look at directory
dir <- paste0(w.dir, application, "_", trans)
dir.create(dir, showWarnings = FALSE)  
foldername <- paste0(dir, "/", "hyperpara", "_", var.set, "_", dummy.type, "_", "p", p, "_", end.in,".rda")

if(foldername %in% dir(dir)){
  next()
}else{
  hyperpara.obj <- optim.func(Yraw = Yraw, p = p, cons = cons, optim.setup = optim.setup, prior.list = prior.list)
}


save(file = foldername, hyperpara.obj) 

print(run)
}
