/* programmes to calculate the likelihood, etc */
/* requires the instalation of dll libraries wwtbam and inv_gam */
/* likelihood maximised using maxlik */

proc linint2(nn,xx,M,c1);
    local y_hat,sl,cs,j;

    sl      =   (   trimr(nn[.,2],1,0)  -   trimr(nn[.,2],0,1)  )./
                (   trimr(nn[.,1],1,0)  -   trimr(nn[.,1],0,1)  );
    sl       = 0|sl|1;
@    sl     = sl|0;@
    y_hat   =   zeros(rows(xx),1);
    cs      =   0;

    for j (1,M,1);
@   cs~(cs+c1[j])~j;@
        if c1[j]/=0;
            y_hat[cs+1:(cs+c1[j])]  =
                nn[j,2]+sl[j].*(xx[cs+1:(cs+c1[j]),1]-nn[j,1]);
        endif;
        cs=cs+c1[j];

    endfor;

    retp(y_hat);
endp;


proc F_i(u,nn);

    retp(
        linint2(nn,u,rows(nn),counts(u,nn[.,1]))
        );
endp;


/*
proc u(x,a);
@ hybrid power expo @
    local v;

    v   =   (
            -exp(
                  -a[3]/(1-a[1])*(x+a[2])^(1-a[1])
                  )
            )/(1-2*(a[3]<0));
            retp(v);

endp;
*/
/*
proc u(x,a);

    local v;

    v   = (1-2*(a[1]>1))*((x+a[2])^(1-a[1])+1e-15);

    retp(v);

endp;

*/

proc v(x,a);

    retp(
        (1-2*(a[1]>1))*((x+a[2])^(1-a[1])+1e-15)
        );
        
endp;        

/*
proc u(x,a);
@ 3 regimes...28-04-08@
@ requires __K1 and __K2 defined in same units as an...@
@ a : 6x1 @

    local vv,v0,v1,v2,v0K1,v1K1,v1K2,v2K2,vmin,vmax,cnd1,cnd2;

    v0K1 = v(__K1,a[1:2]);
    v1K1 = v(__K1,a[3:4]);    
    v1K2 = v(__K2,a[3:4]);    
    
    v2K2 = v(__K2,a[5:6]);    
    
    vmin = v(an[11],a[1:2]);    
    vmax = v(ffn,a[5:6]);
    
    for i(1,rows(x),1);
        if i==1;
            if x[i]<__K1;
                vv = ( v(x[i],a[1:2]) -vmin)/(vmax-v2K2+V1K2+v0K1-v1K1-vmin);
            elseif (x[i]>=__K1) and (x[i]<__K2);
                vv = ( v(x[i],a[3:4]) +v0K1-v1K1 - vmin)/(vmax-v2K2+V1K2+v0K1-v1K1-vmin);
            else;
                vv = (v(x[i],a[5:6])-v2K2+V1K2+v0K1-v1K1-vmin)/(vmax-v2K2+V1K2+v0K1-v1K1-vmin);
            endif;
        else;
            if x[i]<__K1;
                vv = vv|( v(x[i],a[1:2]) -vmin)/(vmax-v2K2+V1K2+v0K1-v1K1-vmin);
            elseif (x[i]>=__K1) and (x[i]<__K2);
                vv = vv|( v(x[i],a[3:4]) +v0K1-v1K1 - vmin)/(vmax-v2K2+V1K2+v0K1-v1K1-vmin);
            else;
                vv = vv|(v(x[i],a[5:6])-v2K2+V1K2+v0K1-v1K1-vmin)/(vmax-v2K2+V1K2+v0K1-v1K1-vmin);
            endif;            
        endif;            
    endfor;        
    
    retp(vv);
endp;
*/

proc uj(x,a);
@linear interpolation! @
@ a needs to be 10x1 in reverse order from 1 (excluded) to 0 (excluded)@
    local res,ii,mid,scl,pb;
    ii  =   11;    
    for i(1,11,1);
        if x>an[i];
            ii = i;
            break;
        endif;
    endfor;

    if ii==1;    
        @mid =   (an[ii]+ffn)/2;@
        mid =   an[ii];
        scl =   (ffn-an[ii]);
    
        @pb = 1/(1+exp(-(x-mid)/scl));@
        pb  =   (x-mid)/scl;
    elseif ii==11;
        @mid =   (an[10])/2;@
        mid =   0;
        scl =   (an[10]);
    
        @pb = 1/(1+exp(-(x-mid)/scl));@
        pb  =   (x-mid)/scl;
    else;
        @mid =   (an[ii]+an[ii-1])/2;@
        mid =   an[ii];
        scl =   (an[ii-1]-an[ii]);
    
        @pb = 1/(1+exp(-(x-mid)/scl));@
        pb  =   (x-mid)/scl;
    endif;

    if ii==1;
        res =   a[1]*(1-pb) + pb;
    elseif ii==11;
        res =   a[10]*pb;
    else;
        res =   a[ii]*(1-pb) + a[ii-1]*(pb);
    endif;

    retp(res);
endp;

proc u(x,a);

    local res;

    for i(1,rows(x),1);
        if i==1;
            res =   uj(x[i],a);
        else;
            res =   res|uj(x[i],a);
        endif;
    endfor;

    retp(res);
endp;
        
proc phi(x,a);
/* beta distribution... */
    local f;

    f   =   (x.>1) +
            (x.<=1).*(x.>=0).*
        (
         cdfbeta(x,a,a)
        );

    retp(f);

endp;



/*
proc u(x,a);

    local v;

    v   = -1*(x+a[2])^(1-a[1])-1e-15;

    retp(v);

endp;
*/

/*** fin */

proc (4)=value0(a);

local bb0,bb1,f,st,i,p_bar,prb,r1,upp, lim_sup,lim_inf,bp,i2,
      aan,bbn;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f   =   FFn;
    f   =   u(f,a[12:21]);

    st  =   miss(0~0~0~0,0);
    bp  =   a[1:11];
    for i (1,rows(an),1);

        p_bar   =   ( aan[i] - bbn[i] )/(f[rows(f)] - bbn[i]);

        i2  =   (i-1)/(rows(an)-1);

        prb=    F4(p_bar,bp[i]);

        upp =  (1-prb.*p_bar)-F5(bp[i],p_bar);

        f   =   f|
                (
                    bbn[i]+(aan[i]-bbn[i])*prb+(f[rows(f)]-bbn[i])*upp
                );

        st  =   st|
                  (
                    prb~upp~p_bar~(upp/(1-prb))
                  );

    endfor;

    retp(
        1-trimr(st[.,1],1,0),
        trimr(st[.,4],1,0),
        f,
        st
        );
endp;

proc v0_p(n,p_max,f,a);

    local st1,st2,aan,bbn,cndab;

        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

@        st  =   aan[n]~(p_max.*(f[n]-bbn[n])+bbn[n]);@
        @st  =   (aan[n[1]]*ones(rows(p_max),1))~(p_max.*(f[n[1]]-bbn[n[1]])+bbn[n[1]]);@

        st1 =   aan[n[1]];
        st2 =   (p_max.*(f[n[1]]-bbn[n[1]]))+bbn[n[1]];

        cndab   =   smhv2d(st2,st1);

        retp(

            st1+cndab.*(st2-st1)

            );
endp;


proc vPAF_p(n,p_tilde,fPAF,f0,a,p0);
@ value of PAF given some p @
    local st,aan,bbn,cndab;
n   =   n[1];
        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

@rows(n)~cols(n)~rows(p_tilde)~cols(p_tilde);@

        st  =   @aan[n]~@
                (p_tilde[.,1].*(fPAF[n]-bbn[n])+bbn[n])~
                kPAF_0(p_tilde,n,f0,a,p0);

        cndab   =   smhv2d(st[.,1],st[.,2]);

        retp(

            st[.,2]+cndab.*(st[.,1]-st[.,2])

            );
endp;

proc vATA_p(n,p_tilde,fATA,f0,a,uv);
@ value of PAF given some p @
    local st,aan,bbn,cndab;
n   =   n[1];
        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

        st  =   @aan[n]~@
                (p_tilde[.,1].*(fATA[n]-bbn[n])+bbn[n])~
                kATA_0(p_tilde,n,f0,a,uv);

        cndab   =   smhv2d(st[.,1],st[.,2]);

        retp(

            st[.,2]+cndab.*(st[.,1]-st[.,2])

            );
endp;


proc v5050_p(n,p_tilde,f5050,f0,a);
@ value of PAF given some p @
    local st,aan,bbn,cndab;
n   =   n[1];
        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

        st  =   @aan[n]~@
                (p_tilde[.,1].*(f5050[n]-bbn[n])+bbn[n])~
                k5050_0(p_tilde,n,f0,a);

        cndab   =   smhv2d(st[.,1],st[.,2]);

        retp(

            st[.,2]+cndab.*(st[.,1]-st[.,2])

            );
endp;

proc vPAFATA_p(n,p_tild,fPAFATA,fPAF,fATA,f0,a,p0,uv);
@ value of PAF given some p @
    local st,aan,bbn,cndb,cndc;
n   =   n[1];

        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

        st  =   @aan[n]~@
                (p_tild[.,1].*(fPAFATA[n]-bbn[n])+bbn[n])~
                kPAF_ATA(p_tild,n,f0,fATA,a,p0,uv)~
                kATA_PAF(p_tild,n,f0,fPAF,a,uv,p0);

        cndb    =   smhv3d(st[.,2],st[.,3],st[.,1]);
        cndc    =   smhv3d(st[.,3],st[.,2],st[.,1]);

        retp(

            st[.,1]+cndb.*(st[.,2]-st[.,1])+cndc.*(st[.,3]-st[.,1])

            );


endp;


proc v5050PAF_p(n,p_tild,f5050PAF,f5050,fPAF,f0,a,p0);
@ value of PAF given some p @
    local st,aan,bbn,cndb,cndc;
n   =   n[1];

        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

        st  =   @aan[n]~@
                (p_tild[.,1].*(f5050PAF[n]-bbn[n])+bbn[n])~
                k5050_PAF(p_tild,n,f0,fPAF,a,p0)~
                kPAF_5050(p_tild,n,f0,f5050,a,p0);

        cndb    =   smhv3d(st[.,2],st[.,3],st[.,1]);
        cndc    =   smhv3d(st[.,3],st[.,2],st[.,1]);

        retp(

            st[.,1]+cndb.*(st[.,2]-st[.,1])+cndc.*(st[.,3]-st[.,1])

            );

endp;

proc v5050ATA_p(n,p_tild,f5050ATA,f5050,fATA,f0,a,uv);
@ value of PAF given some p @
    local st,aan,bbn,cndb,cndc;
n   =   n[1];

        aan =   missrv(u(an,a[12:21]),-100);
        bbn =   missrv(u(bn,a[12:21]),-100);

        st  =   @aan[n]~@
                (p_tild[.,1].*(f5050ATA[n]-bbn[n])+bbn[n])~
                k5050_ATA(p_tild,n,f0,fATA,a,uv)~
                kATA_5050(p_tild,n,f0,f5050,a,uv);

        cndb    =   smhv3d(st[.,2],st[.,3],st[.,1]);
        cndc    =   smhv3d(st[.,3],st[.,2],st[.,1]);

        retp(

            st[.,1]+cndb.*(st[.,2]-st[.,1])+cndc.*(st[.,3]-st[.,1])

            );
endp;


proc k5050_0(p_tild,n,f,a);
    /* p_tild matrix px4 of ordered uniforms */

    local idxa,idxb,st,div,cnd,idx,un,pst,idxc,rr;

    n   =   n[1];

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    st  =   zeros(rows(p_tild),1);
    div =   st[.,1]+1;

    for kk (1,6,1);

        if ((kk==1) or (kk==2) or (kk==4));
            cnd =   p_tild[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(p_tild)),cnd);
            if scalmiss(idx)==0;
                rr  =   rows(idx);
                un  =   ones(rr,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
                /*if kk==1;
                    div[idx]    =   un;
                elseif kk==2;
                    div[idx]    =2*un;
                elseif kk==4;
                    div[idx]    =3*un;
                endif;*/
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(p_tild)),1-cnd);
            st[idxc]    =   st[idxc] + V0_p(n,1,f,a).*ones(rows(idxc),1);
        endif;

        if scalmiss(idx)==0;
            pst =   p_tild[idx,idxa[kk]]+p_tild[idx,idxb[kk]];
            st[idx]  =   st[idx] +
                         pst.*V0_p(n,(p_tild[idx,idxa[kk]]./pst),f,a);
        else;
            break;
        endif;
    endfor;

    retp(st./div);

endp;



proc kATA_0(p_tild,n,f0,a,uv);
    /* this calculates the expected value of playing ATA given some realisation of the belief p_tild*/
    /* p_tild matrix px4 of ordered uniforms */

    local un,scal,kata,u1,h1,h2,h3,h4,G,st,stG,q_p,pst,Info;
n   =   n[1];


    un  =   rows(p_tild);
    un  =   ones(un,1);

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);

    kata=   0;


    /*beg */
    for jj (1,Njjk,1);
        st  =   0;
        for ll (1,4,1);


        { u1 , __stategl } = rndKMu( rows(p_tild), 4 , __stategl);
__u_count = __u_count+rows(u1);
        h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
        h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
        h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
        h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));

        G   =   h1~h2~h3~h4;
        G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

        Info=   G^(uv[1]-uv[2]);
        Info=   Info./(Info*ones(4,1));

        q_p =   Info.*p_tild;
        q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @

        q_p =   Smax_in_4(q_p);

        st  =   st  +   p_tild[.,ll].*v0_p(n,q_p[.,1],f0,a);
        endfor;

        kata    =   kata    +   st;
    endfor;
    /*end */

    retp(kata/Njjk);
endp;


proc kPAF_0(p_tild,n,f0,a,p0);
    /* this calculates the expected value of playing PAF given some realisation of the belief p_tild*/
    /* empirical specification...the expert is either right or undecided */
    /* p_tild matrix px4 of ordered uniforms */

    local un,st,pst,max_updt;
n   =   n[1];

    un  =   rows(p_tild);
    un  =   ones(un,1);

    st  =   0;
    for kk (1,2,1); @ not nice but life is too short! @
        if kk==1;
            pst =   p0;
            max_updt=   p_tild[.,1];    @ expert did not know...nothing learned @
        else;
            pst =   (1-p0);
            max_updt=   un; @ information is very informative...@
        endif;

        st  =   pst.*v0_p(n,max_updt,f0,a)+st;
    endfor;

    retp(st);
endp;


proc k5050_PAF(p_tild,n,f0,fPAF,a,p0);
    /* p_tild matrix px4 of ordered uniforms */

 local idxa,idxb,st,div,cnd,idx,un,idxc,pst;
n   =   n[1];

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    st  =   zeros(rows(p_tild),1);
    div =   st[.,1]+1;

    for kk (1,6,1);

        if ((kk==1)+(kk==2)+(kk==4));
            cnd =   p_tild[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(p_tild)),cnd);
            if scalmiss(idx)==0;
                un  =   rows(idx);
                un  =   ones(un,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(p_tild)),1-cnd);
            st[idxc]    =   st[idxc] + vPAF_p(n[1],1~0~0~0,fPAF,f0,a,p0).*ones(rows(idxc),1);
        endif;

        if scalmiss(idx)==0;
            pst =   p_tild[idx,idxa[kk]]+p_tild[idx,idxb[kk]];
            st[idx]  =   st[idx] +
                         pst.*vPAF_p(n,(p_tild[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),fPAF,f0,a,p0);
        else;
            break;
        endif;
    endfor;

    retp(st./div);

endp;


proc k5050_ATA(p_tild,n,f0,fATA,a,uv);
    /* p_tild matrix px4 of ordered uniforms */
local idxc,idx,st,pst,un,kk,idxa,idxb,div,cnd,info;
n   =   n[1];

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    st  =   zeros(rows(p_tild),1);
    div =   st[.,1]+1;

    for kk (1,6,1);

        if ((kk==1)+(kk==2)+(kk==4));
            cnd =   p_tild[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(p_tild)),cnd);
            if scalmiss(idx)==0;
                un  =   rows(idx);
                un  =   ones(un,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(p_tild)),1-cnd);
            st[idxc]    =   st[idxc] + vATA_p(n[1],1~0~0~0,fATA,f0,a,uv).*ones(rows(idxc),1);

        endif;

        if scalmiss(idx)==0;
            pst =   p_tild[idx,idxa[kk]]+p_tild[idx,idxb[kk]];
            st[idx]  =   st[idx] +
                         pst.*vATA_p(n,(p_tild[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),fATA,f0,a,uv);
        else;
            break;
        endif;
    endfor;

    retp(st./div);
endp;

proc kPAF_5050(p_tild,n,f0,f5050,a,p0);

    local un,st,pst,updt;
n   =   n[1];

    un  =   rows(p_tild);
    un  =   ones(un,1);

    st  =   0;
    for kk (1,2,1); @ not nice but life is too short! @
        if kk==1;
            pst =   p0;
            updt=   p_tild; @expert did not know...nothing learned@
        else;
            pst =   (1-p0);
            updt=   un~(un.*(0~0~0)); @ information is very informative...@
        endif;

        st  =   pst.*v5050_p(n,updt,f5050,f0,a)+st;
    endfor;

    retp(st);
endp;

proc kPAF_ATA(p_tild,n,f0,fATA,a,p0,uv);

    local un,st,pst,updt;
n   =   n[1];
    un  =   rows(p_tild);
    un  =   ones(un,1);

    st  =   0;
    for kk (1,2,1); @ not nice but life is too short! @
        if kk==1;
            pst =   p0;
            updt=   p_tild; @expert did not know...nothing learned@
        else;
            pst =   (1-p0);
            updt=   un~(un.*(0~0~0)); @ information is very informative...@
        endif;

        st  =   pst.*vATA_p(n,updt,fATA,f0,a,uv)+st;
    endfor;

    retp(st);
endp;


proc kATA_PAF(p_tild,n,f0,fPAF,a,uv,p0);

    local un,scal,kata,u1,h1,h2,h3,h4,G,st,stG,q_p,pst,Info;
n   =   n[1];

    un  =   rows(p_tild);
    un  =   ones(un,1);

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);

    kata=   0;

    /*beg */
    for jj (1,Njjk,1);
        st  =   0;
        for ll (1,4,1);

        { u1 , __stategl } = rndKMu( rows(p_tild), 4 , __stategl);
__u_count = __u_count+rows(u1);
        h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
        h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
        h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
        h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));
        

        G   =   h1~h2~h3~h4;
        G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

        Info=   G^(uv[1]-uv[2]);
        Info=   Info./(Info*ones(4,1));

        q_p =   Info.*p_tild;
        q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @

        q_p =   Smax_in_4(q_p);

        st  =   st  +   p_tild[.,ll].*vPAF_p(n,q_p,fPAF,f0,a,p0);
        endfor;

        kata    =   kata    +   st;
    endfor;
/*end */

    retp(kata/Njjk);

endp;

proc kATA_5050(p_tild,n,f0,f5050,a,uv);

    local un,scal,kata,u1,h1,h2,h3,h4,G,st,stG,q_p,pst,Info;
n   =   n[1];


    un  =   rows(p_tild);
    un  =   ones(un,1);

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);

    kata=   0;

    /*beg */
    for jj (1,Njjk,1);
        st  =   0;
        for ll (1,4,1);

        { u1 , __stategl } = rndKMu( rows(p_tild), 4 , __stategl);
__u_count = __u_count+rows(u1);
        h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
        h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
        h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
        h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));
        

        G   =   h1~h2~h3~h4;
        G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

        Info=   G^(uv[1]-uv[2]);
        Info=   Info./(Info*ones(4,1));

        q_p =   Info.*p_tild;
        q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @

        q_p =   Smax_in_4(q_p);

        st  =   st  +   p_tild[.,ll].*v5050_p(n,q_p,f5050,f0,a);
        endfor;

        kata    =   kata    +   st;
    endfor;
/*end */

    retp(kata/Njjk);

endp;


proc k5050_PAFATA(p_tild,n,f0,f5050,fPAF,fATA,f5050PAF,f5050ATA,fPAFATA,a,p0,uv);
    /* p_tild matrix px4 of ordered uniforms */

 local idxc,idx,st,pst,un,idxa,idxb,div,cnd;
n   =   n[1];

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    st  =   zeros(rows(p_tild),1);
    div =   st[.,1]+1;

    for kk (1,6,1);

        if ((kk==1)+(kk==2)+(kk==4));
            cnd =   p_tild[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(p_tild)),cnd);
            if scalmiss(idx)==0;
                un  =   rows(idx);
                un  =   ones(un,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(p_tild)),1-cnd);
            st[idxc]    =   st[idxc] + vPAFATA_p(n,1~0~0~0,fPAFATA,fPAF,fATA,f0,a,p0,uv)@.*ones(rows(idxc),1)@;
        endif;

        if scalmiss(idx)==0;
            pst =   p_tild[idx,idxa[kk]]+p_tild[idx,idxb[kk]];
            st[idx]  =   st[idx] +
                         pst.*vPAFATA_p(n,(p_tild[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),fPAFATA,fPAF,fATA,f0,a,p0,uv);

        else;
            break;
        endif;
    endfor;

    retp(st./div);

endp;

proc kATA_5050PAF(p_tild,n,f0,f5050,fPAF,fATA,f5050PAF,f5050ATA,fPAFATA,a,p0,uv);

    local un,scal,kata,u1,h1,h2,h3,h4,G,st,stG,q_p,pst,Info;
n   =   n[1];


    un  =   rows(p_tild);
    un  =   ones(un,1);

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);


    kata=   0;
    /*beg */
    for jj (1,Njjk,1);
        st  =   0;
        for ll (1,4,1);

        { u1 , __stategl } = rndKMu( rows(p_tild), 4 , __stategl);
__u_count = __u_count+rows(u1);
        h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
        h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
        h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
        h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));
        

        G   =   h1~h2~h3~h4;
        G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

        Info=   G^(uv[1]-uv[2]);
        Info=   Info./(Info*ones(4,1));

        q_p =   Info.*p_tild;
        q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @

        q_p =   Smax_in_4(q_p);

        st  =   st  +   p_tild[.,ll].*v5050PAF_p(n,q_p,f5050PAF,f5050,fPAF,f0,a,p0);
        endfor;

        kata    =   kata    +   st;
    endfor;
/*end */

    retp(kata/Njjk);

endp;


proc kPAF_5050ATA(p_tild,n,f0,f5050,fPAF,fATA,f5050PAF,f5050ATA,fPAFATA,a,p0,uv);

    local un,st,pst,updt;
n   =   n[1];

    un  =   rows(p_tild);
    un  =   ones(un,1);

    st  =   0;
    for kk (1,2,1); @ not nice but life is too short! @
        if kk==1;
            pst =   p0;
            updt=   p_tild; @expert did not know...nothing learned@
        else;
            pst =   (1-p0);
            updt=   un~(un.*(0~0~0)); @ information is very informative...@
        endif;

        st  =   pst.*v5050ATA_p(n,updt,f5050ATA,f5050,fATA,f0,a,uv)+st;
    endfor;

    retp(st);
endp;


proc sim_z(asim,N_sim,i);
/* simulate out of the components of psi4(...) */
    local ___n0,___n1,st,st1,z1,z2,z3,z4,n0,cnd,sst,h1,h2,h3,u1,u2,u3,nm;

    { u1 , __stategl } = rndKMu( N_sim , 3 , __stategl);
    { u2 , __stategl } = rndKMu( N_sim , 3 , __stategl);
    { u3 , __stategl } = rndKMu( N_sim , 3 , __stategl);
__u_count = __u_count+3*N_sim;
    @{g1,___n0}=q_gam(asim,u1[.,1],miss(0,0));@
    h1  =   inv_gam(u1[.,1],asim);
    @{g2,___n0}=q_gam(asim,u2[.,1],___n0);@
    h2  =   inv_gam(u2[.,1],asim);
    @{g3,___n1}=q_gam(2,u3[.,1],miss(0,0));@
    h3  =   inv_gam(u3[.,1],2);

    z1    =   (ones(4,1).*.(h1./(h1+h2+h3)))|
              (ones(4,1).*.(h2./(h1+h2+h3)));

    z1  =   z1 + (z1.>1).*(1-z1);

    @{g1,___n0}=q_gam(asim,u1[.,2],___n0);@
    h1  =   inv_gam(u1[.,2],asim);
    @{g2,___n0}=q_gam(asim,u2[.,2],___n0);@
    h2  =   inv_gam(u2[.,2],asim);

    h3       =-ln(1-u3[.,2]); @ exponential variate...direct method! @

    z2    =   ones(2,1).*.
              (
                (ones(2,1).*.(h1./(h1+h2+h3)))|
                (ones(2,1).*.(h2./(h1+h2+h3)))
              );


    h1  =   inv_gam(u1[.,3],asim);
    h2  =   inv_gam(u2[.,3],asim);
    h3  =   inv_gam(u3[.,3],asim);

    z3    =   ones(4,1).*.
              (
                missrv(h1./miss(h1+h2,0),0)|
                missrv(h2./miss(h2+h3,0),0)
              );

    z2    =   (1-z1).*z2;
    z4    =   (1-z1-z2).*(1-z3);
    z3    =   (1-z1-z2).*z3;



    retp(
        Smax_in_4(z1~z2~z3~z4)
        );
endp;

proc (1)=invalue1_5050(po,@playnow,lfln,@cnd1,aan,bbn,f1,V0,i);

local st,po1,po2,problfn,cst1,cnd2,cnd3,cnd4,cnd5,cnd6;

    st  =   cnd1.>0;
    po1 =   selif(po,st);
    po2 =   delif(po,st);
    clear po;
    cnd1    =   selif(cnd1,st);

    problfn =   miss(0,0);
    if scalmiss(po1)==0;

            cst1    =   missrv(
                                po1[.,1 1 1 2 2 3]./miss(po1[.,1 1 1 2 2 3]+po1[.,2 3 4 3 4 4],0)
                              ,0).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   smhv2d(cst1,aan[i]).*po1[.,1 1 1 2 2 3]/3;
            cst1    =   sumc(cst1');


        cnd2    =   cst1;          @ plays and wins once used... @

            cst1    =   missrv(
                                po1[.,1 1 2 1 2 3]./miss(po1[.,1 1 2 1 2 3]+po1[.,2 3 3 4 4 4],0)
                              ,0).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   smhv2d(cst1,aan[i]).*po1[.,2 3 3 4 4 4]/3;
            cst1    =   sumc(cst1');

        cnd3    =   cst1;          @ plays and loses once used...@

            cst1    =   missrv(
                                po1[.,1 1 1 2 2 3]./miss(po1[.,1 1 1 2 2 3]+po1[.,2 3 4 3 4 4],0)
                              ,0).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   (1-smhv2d(cst1,aan[i])).*(po1[.,1 1 1 2 2 3]+po1[.,2 3 4 3 4 4])/3;
            cst1    =   sumc(cst1');

        cnd4    =   cst1;           @ uses 50/50 and quits @

            cst1    =   po1[.,1];

        cnd5    =   cst1;           @ does not use 50/50 and wins @
        cst1    =   1-po1[.,1];
        cnd6    =   cst1;           @ does not use 50/50 and loses @


        problfn =   (cnd1.*cnd2)~(cnd1.*cnd3)~(cnd1.*cnd4)~((1-cnd1).*cnd5)~((1-cnd1).*cnd6);

    endif;


    if scalmiss(po2)==0;

        if scalmiss(problfn)==0;

            problfn =   problfn|
                        (
                            zeros(rows(po2),3)~po2[.,1]~(1-po2[.,1])
                        );
        else;
            problfn =   (
                            zeros(rows(po2),3)~po2[.,1]~(1-po2[.,1])
                        );
        endif;
    endif;

    retp(
        problfn
        );
endp;


proc (2)=value1_5050(a,V0);

local aan,bbn,f1,st,bp,nm,po,playnow,lfln,cnd1,problfn,i2;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    st  =   miss(0~0~0~0,0);
    
    bp  =   a[1:11];
    
    for i (1,rows(an),1);
        /*
        if i>=11;
            i;
        endif;
        */
        i2  =   (i-1)/(rows(an)-1);
        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];
        lfln    =   k5050_0(po,i,V0,a);

        cnd1    =   smhv2d(lfln,playnow); @ use life line ...@

        if i==1;
            problfn =   meanc(invalue1_5050(po,@playnow,lfln,@cnd1,aan,bbn,f1,V0,i))';
        else;
            problfn =   problfn|(meanc(invalue1_5050(po,@playnow,lfln,@cnd1,aan,bbn,f1,V0,i))');
        endif;

        f1   =   f1|
                 meanc( (playnow + cnd1.*(lfln-playnow)));
    endfor;

    retp(
        problfn,
        f1
        );
endp;


proc (1)=invalue1_ATA(po,@playnow,lfln,@cnd1,aan,bbn,uv,f1,V0,i);

local scal,cnd2,cnd3,cnd4,cnd5,cnd6,st,po1,po2,problfn,kata,u1,h1,h2,h3,h4,G,stG,cst1,stVmbi,stbi,p_t_s,q_p,pst,m_q_p,Info;
local check;
i   =   i[1];

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);

    cnd2=   0;
    cnd3=   0;
    cnd4=   0;
    cnd5=   0;
    cnd6=   0;

    st  =   cnd1.>0;
    po1 =   selif(po,st);
    po2 =   delif(po,st);
    clear po;
    cnd1    =   selif(cnd1,st);

    problfn =   miss(0,0);

    if scalmiss(po1)==0;

        kata=   0;


        for jj (1,Njj,1);
            st  =   0;
            for ll (1,4,1);

                { u1 , __stategl } = rndKMu( rows(po1), 4 ,__stategl);
__u_count = __u_count+rows(u1);
                
                h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
                h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
                h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
                h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));                

                G   =   h1~h2~h3~h4;
                G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

                Info=   G^(uv[1]-uv[2]);
                Info=   Info./(Info*ones(4,1));
                q_p =   Info.*po1;
                q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @

                q_p =   Smax_in_4(q_p);
                m_q_p   =   q_p[.,1];

                stVmbi  =   (V0[i]-bbn[i]);
                stbi    =   bbn[i];


                cst1    =   m_q_p.*stVmbi+stbi;
                cst1    =   smhv2d(cst1,aan[i]).*m_q_p;

                cnd2    =   cnd2 + po1[.,ll].*cst1;          @ plays and wins once used... @

                cst1    =   m_q_p.*stVmbi+stbi;
                cst1    =   smhv2d(cst1,aan[i]).*(1-m_q_p);

                cnd3    =   cnd3 + po1[.,ll].*cst1;          @ plays and loses once used...@

                cst1    =   m_q_p.*stVmbi+stbi;
                cst1    =   (1-smhv2d(cst1,aan[i]));

                cnd4    =   cnd4 + po1[.,ll].*cst1;           @ uses ATA and quits @
            endfor;

        endfor;

        cnd2    =   cnd2/Njj;
        cnd3    =   cnd3/Njj;
        cnd4    =   cnd4/Njj;
        cnd5    =   po1[.,1];               @ does not use ATA and wins @
        cnd6    =   (1-po1[.,1]);           @ does not use ATA and loses @
@
check   =   cnd2~cnd3~cnd4;
check   =   check~sumc(check');
meanc(check)';
@
        problfn =   (cnd1.*cnd2)~(cnd1.*cnd3)~(cnd1.*cnd4)~((1-cnd1).*cnd5)~((1-cnd1).*cnd6) ;


    endif;

    if scalmiss(po2)==0;

        if scalmiss(problfn)==0;

            problfn =   problfn|
                        (
                            zeros(rows(po2),3)~po2[.,1]~(1-po2[.,1])
                        );
        else;
            problfn =   (
                            zeros(rows(po2),3)~po2[.,1]~(1-po2[.,1])
                        );
        endif;
    endif;


    retp(
        problfn
        );

endp;

proc (2)=value1_ATA(a,V0,uv);

local po,problfn,aan,bbn,f1,bp,playnow,lfln,cnd1,i2;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    bp  =   a[1:11];

    for i (1,rows(an),1);

        i2  =   (i-1)/(rows(an)-1);

        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];
        lfln    =   kATA_0(po,i,V0,a,uv);

        cnd1    =   smhv2d(lfln,playnow); @ use life line ...@

        if i==1;
            problfn =   meanc(invalue1_ATA(po,@playnow,lfln,@cnd1,aan,bbn,uv,f1,V0,i))';
        else;
            problfn =   problfn|(meanc(invalue1_ATA(po,@playnow,lfln,@cnd1,aan,bbn,uv,f1,V0,i))');
        endif;

        f1   =   f1|
                 meanc( (playnow + @(lfln.>playnow)@cnd1.*(lfln-playnow)));
@        f1b  =  f1b|meanc(lfln);@

    endfor;

    retp(
        problfn,
        f1
        );
endp;


proc (1)=invalue1_PAF(po,@playnow,lfln,@cnd1,aan,bbn,p0,f1,V0,i);

local st,po1,po2,problfn,cst1,cnd2,cnd3,cnd4,cnd5,cnd6;

    st  =   cnd1.>0;
    po1 =   selif(po,st);
    po2 =   delif(po,st);
    clear po;
    cnd1    =   selif(cnd1,st);

    problfn =   miss(0,0);

    if scalmiss(po1)==0;

            cst1    =   (po1[.,1]~ones(rows(po1),4)).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   smhv2d(cst1,aan[i]).*((p0.*ones(rows(po1),1))~((1-p0).*po1)).*(po1[.,1]~ones(rows(po1),4));
            cst1    =   sumc(cst1');

        /*cndmiss =   cst1.==miss(0,0);
        check   =   selif(cnd1~cst1~lfln~playnow~po1,cndmiss);*/

        cnd2    =   cst1;          @ plays and wins once used... @

    @            cst1    =   missrv(
                                po1[.,1 1 2 1 2 3]./miss(po1[.,1 1 2 1 2 3]+po1[.,2 3 3 4 4 4],0)
                              ,0).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   smhv(cst1,aan[i]).*po1[.,2 3 3 4 4 4]/3;
            cst1    =   sumc(cst1');@

            cst1    =   (po1[.,1]~ones(rows(po1),4)).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   smhv2d(cst1,aan[i]).*((p0.*ones(rows(po1),1))~((1-p0).*po1)).*((1-po1[.,1])~zeros(rows(po1),4));
            cst1    =   sumc(cst1');

        cnd3    =   cst1;          @ plays and loses once used...@

            cst1    =   (po1[.,1]~ones(rows(po1),4)).*(V0[i]-bbn[i])+bbn[i];
            cst1    =   (1-smhv2d(cst1,aan[i])).*((p0.*ones(rows(po1),1))~((1-p0).*po1));
            cst1    =   sumc(cst1');

        cnd4    =   cst1;           @ uses 50/50 and quits @

            /*
            cst1    =   smhv(po1[.,1].*(f1[i]-bbn[i])+bbn[i],aan[i]); @ is this correct ? @
            cst1    =   cst1.*po1[.,1];
            */
            cst1    =   po1[.,1];

        cnd5    =   cst1;           @ does not use 50/50 and wins @

            /*
            cst1    =   smhv(po1[.,1].*(f1[i]-bbn[i])+bbn[i],aan[i]); @ is this correct ? @
            cst1    =   cst1.*(1-po1[.,1]);
            */
            cst1    =   1-po1[.,1];

        cnd6    =   cst1;           @ does not use 50/50 and loses @


        problfn =   (cnd1.*cnd2)~(cnd1.*cnd3)~(cnd1.*cnd4)~((1-cnd1).*cnd5)~((1-cnd1).*cnd6);

    endif;

    if scalmiss(po2)==0;

        if scalmiss(problfn)==0;

            problfn =   problfn|
                        (
                            zeros(rows(po2),3)~po2[.,1]~(1-po2[.,1])
                        );
        else;
            problfn =   (
                            zeros(rows(po2),3)~po2[.,1]~(1-po2[.,1])
                        );
        endif;
    endif;

    retp(problfn);

endp;

proc (2)=value1_PAF(a,V0,p0);

local bb0,bb1,f,st,i,p_bar,prb,r1,upp, lim_sup,lim_inf,bp,
      aan,bbn,f1,po,playnow,lfln,cnd1,cnd2,cnd3,cnd4,cnd5,cnd6,
      cst1,problfn,info,i2;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    st  =   miss(0~0~0~0,0);
    
    bp  =   a[1:11];
    
    for i (1,rows(an),1);

        i2  =   (i-1)/(rows(an)-1);
    
        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];
        lfln    =   kPAF_0(po,i,V0,a,p0[i]);

        cnd1    =   smhv2d(lfln,playnow); @ use life line ...@


        if i==1;
            problfn =   meanc(invalue1_PAF(po,@playnow,lfln,@cnd1,aan,bbn,p0[i],f1,V0,i))';
        else;
            problfn =   problfn|(meanc(invalue1_PAF(po,@playnow,lfln,@cnd1,aan,bbn,p0[i],f1,V0,i))');
        endif;

        f1   =   f1|
                 meanc( (playnow + @(lfln.>playnow)@cnd1.*(lfln-playnow)));
    endfor;

    retp(
        problfn,
        f1
        );
endp;


proc invalue1_5050PAF(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,p0,f5050,fPAF,V0,i);

local idxa,idxb,idxc,rpo,probb,cnd,idx,un,div,playnow,lflnPAF,lfln5050,proba,po_PAF,pinf,pst,probc;

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    rpo =   rows(po);

    probb   =   zeros(rows(po),5);
    div     =   probb[.,1]+1;

    for kk (1,6,1);

        if ((kk==1)+(kk==2)+(kk==4));
            cnd =   po[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(po)),cnd);
            if scalmiss(idx)==0;
                un  =   rows(idx);
                un  =   ones(un,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(po)),1-cnd);

            playnow =   fPAF[i];
            lflnPAF =   kPAF_0((1~0~0~0).*ones(rows(idxc),1),i,V0,a,p0);

            probb[idxc,.]  =    probb[idxc,.]   +
                                invalue1_PAF((1~0~0~0).*ones(rows(idxc),1),@playnow,lflnPAF,@smhv2d(lflnPAF,playnow),aan,bbn,p0,fPAF,V0,i);

        endif;

        if scalmiss(idx)==0;
            pst =   po[idx,idxa[kk]]+po[idx,idxb[kk]];

            playnow =   po[idx,idxa[kk]]./pst.*(fPAF[i]-bbn[i])+bbn[i];
            lflnPAF =   kPAF_0((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),i,V0,a,p0);

            probb[idx,.]  = probb[idx,.]    +   pst.*
                            invalue1_PAF((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),@playnow,lflnPAF,@smhv2d(lflnPAF,playnow),aan,bbn,p0,fPAF,V0,i);
        else;
            break;
        endif;
    endfor;

    probb   =   probb./div;

    proba   =   0;
    for kk (1,2,1);
        if kk==1;
            po_PAF  =   po;
            pinf    =   p0;
        elseif kk==2;
            po_PAF  =   ones(rpo,1)~zeros(rpo,3);
            pinf    =   (1-p0);
        endif;

        playnow =   po_PAF[.,1].*(f5050[i]-bbn[i])+bbn[i];
        lfln5050=   k5050_0(po_PAF,i,V0,a);
        proba =     proba   +   pinf.*invalue1_5050(po_PAF,@playnow,lfln5050,@smhv2d(lfln5050,playnow),aan,bbn,f5050,V0,i);
    endfor;

@ plays and wins once used...plays and loses once used...uses 50/50 and quits...does not use 50/50 and wins...does not use 50/50 and loses@

    proba   =   cnd1a.*proba;
    probb   =   cnd1b.*probb;

@use both, plays and wins...use both, plays and loses...use both and quits...@
@use 5050, plays and wins...use 5050, plays and loses...@
@use PAF, plays and wins...use PAF, plays and loses...@
@plays and wins...plays and loses@

    probc   =   (proba[.,1:3] + probb[.,1:3])~probb[.,4:5]~proba[.,4:5]~
                ( (1-cnd1a-cnd1b).*(po[.,1]~(1-po[.,1])) );

    retp(
        probc
        );

endp;


proc (2)=value1_5050PAF(a,f5050,fPAF,V0,p0);

local aan,bbn,f1,bp,po,playnow,lfln1,lfln2,cnd1a,cnd1b,problfn,i2;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);
    
    bp  =   a[1:11];

    for i (1,rows(an),1);


        i2  =   (i-1)/(rows(an)-1);

        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];

        lfln1   =   kPAF_5050(po,i,V0,f5050,a,p0[i]);
        lfln2   =   k5050_PAF(po,i,V0,fPAF,a,p0[i]);

/*
        st  =   smhv(lfln1,lfln2);
        cnd1a   =   smhv(lfln1,playnow).*st; @ use life line PAF...@
        cnd1b   =   smhv(lfln2,playnow).*(1-st); @ use life line 5050...@
*/
        cnd1a   =   smhv3d(lfln1,lfln2,playnow); @ use life line PAF...@
        cnd1b   =   smhv3d(lfln2,lfln1,playnow); @ use life line 5050..@

        if i==1;
            problfn =   meanc(invalue1_5050PAF(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,p0[i],f5050,fPAF,V0,i))';
        else;
            problfn =   problfn|(meanc(invalue1_5050PAF(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,p0[i],f5050,fPAF,V0,i))');
        endif;

        f1   =   f1|
                 meanc(
                        (playnow + cnd1a.*(lfln1-playnow)+cnd1b.*(lfln2-playnow))
                      );
    endfor;

    retp(
        problfn,
        f1
        );
endp;


proc invalue1_5050ATA(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,uv,f5050,fATA,V0,i);

local idxa,idxb,rpo,probb,div,cnd,idx,un,idxc,playnow,lflnATA,pst,scal,proba,u1,G,cst1,check,stG,h1,h2,h3,h4,q_p,lfln5050,probc,st,p_t_s,Info;

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    rpo =   rows(po);

    probb   =   zeros(rows(po),5);
    div     =   probb[.,1]+1;

    for kk (1,6,1);

        if ((kk==1)+(kk==2)+(kk==4));
            cnd =   po[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(po)),cnd);
            if scalmiss(idx)==0;
                un  =   rows(idx);
                un  =   ones(un,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(po)),1-cnd);

            playnow =   fATA[i];
            lflnATA =   kATA_0((1~0~0~0).*ones(rows(idxc),1),i,V0,a,uv);

            probb[idxc,.]  =    probb[idxc,.]   +
                                invalue1_ATA((1~0~0~0).*ones(rows(idxc),1),@playnow,lflnATA,@smhv2d(lflnATA,playnow),aan,bbn,uv,fATA,V0,i);
        endif;

        if scalmiss(idx)==0;
            pst =   po[idx,idxa[kk]]+po[idx,idxb[kk]];

            playnow =   po[idx,idxa[kk]]./pst.*(fATA[i]-bbn[i])+bbn[i];
            lflnATA =   kATA_0((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),i,V0,a,uv);


            probb[idx,.]  = probb[idx,.]    +   pst.*
                            invalue1_ATA((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),@playnow,lflnATA,@smhv2d(lflnATA,playnow),aan,bbn,uv,fATA,V0,i);

        else;
            break;
        endif;
    endfor;


    probb   =   probb./div;


    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);

    proba   =   0;

    for jj (1,Njj,1);
        st  =   0;
        for ll (1,4,1);
            { u1 , __stategl } = rndKMu( rows(po), 4 , __stategl);
           __u_count = __u_count+rows(u1);
            h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
            h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
            h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
            h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));            

            G   =   h1~h2~h3~h4;
            G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

            Info=   G^(uv[1]-uv[2]);
            Info=   Info./(Info*ones(4,1));

            q_p =   Info.*po;
            q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @

            q_p =   Smax_in_4(q_p);

            playnow =   q_p[.,1].*(f5050[i]-bbn[i])+bbn[i];

            lfln5050=   k5050_0(q_p,i,V0,a);

            proba   =   proba + po[.,ll].*invalue1_5050(q_p,@playnow,lfln5050,@smhv2d(lfln5050,playnow),aan,bbn,f5050,V0,i);
        endfor;
    endfor;

    proba   =   proba/Njj;

@ plays and wins once used...plays and loses once used...uses 50/50 and quits...does not use 50/50 and wins...does not use 50/50 and loses@

    proba   =   cnd1a.*proba;
    probb   =   cnd1b.*probb;

@use both, plays and wins...use both, plays and loses...use both and quits...@
@use 5050, plays and wins...use 5050, plays and loses...@
@use ATA, plays and wins...use ATA, plays and loses...@
@plays and wins...plays and loses@

    probc   =   (proba[.,1:3] + probb[.,1:3])~probb[.,4:5]~proba[.,4:5]~
                ( (1-cnd1a-cnd1b).*(po[.,1]~(1-po[.,1])) );

    retp(
        probc
        );

endp;


proc (2)=value1_5050ATA(a,f5050,fATA,V0,uv);

    local aan,bbn,f1,bp,po,playnow,lfln1,lfln2,cnd1a,cnd1b,problfn,i2;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    bp  =   a[1:11];
    
    for i (1,rows(an),1);

        i2  =   (i-1)/(rows(an)-1);

        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];

        lfln1   =   kATA_5050(po,i,V0,f5050,a,uv);
        lfln2   =   k5050_ATA(po,i,V0,fATA,a,uv);

/*
        st  =   smhv(lfln1,lfln2);
        cnd1a   =   smhv(lfln1,playnow).*st; @ use life line ATA...@
        cnd1b   =   smhv(lfln2,playnow).*(1-st); @ use life line 5050...@
*/
        cnd1a   =   smhv3d(lfln1,lfln2,playnow); @ use life line ATA...@
        cnd1b   =   smhv3d(lfln2,lfln1,playnow); @ use life line 5050..@

        if i==1;
            problfn =   meanc(invalue1_5050ATA(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,uv,f5050,fATA,V0,i))';
        else;
            problfn =   problfn|(meanc(invalue1_5050ATA(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,uv,f5050,fATA,V0,i))');
        endif;

        f1   =   f1|
                 meanc(
                        (playnow + cnd1a.*(lfln1-playnow)+cnd1b.*(lfln2-playnow))
                      );
    endfor;

    retp(
        problfn,
        f1
        );
endp;


/*** deb ***/

proc invalue1_PAFATA(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,p0,uv,fPAF,fATA,V0,i);

    local rpo,un,probb,po_PAF,pinf,playnow,lflnATA,scal,proba,u1,h1,h2,h3,h4,G,st,cst1,stG,p_t_s,q_p,pst,lflnPAF,probc,check,Info;

    rpo =   rows(po);
    un  =   ones(rpo,1);

    probb   =   0;
    for kk (1,2,1);
        if kk==1;
            po_PAF  =   po;
            pinf    =   p0;
        elseif kk==2;
            po_PAF  =   ones(rpo,1)~zeros(rpo,3);
            pinf    =   (1-p0);
        endif;

        playnow =   po_PAF[.,1].*(fATA[i]-bbn[i])+bbn[i];
        lflnATA =   kATA_0(po_PAF,i*un,V0,a,uv);

        probb   =   probb  +    pinf.*
                    invalue1_ATA(po_PAF,@playnow,lflnATA,@smhv2d(lflnATA,playnow),aan,bbn,uv,fATA,V0,i*un);
    endfor;

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);

    proba   =   0;

    for jj (1,Njj,1);
        st  =   0;
        for ll (1,4,1);
            { u1 , __stategl } = rndKMu( rows(po), 4 , __stategl);
           __u_count = __u_count+rows(u1);
            h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
            h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
            h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
            h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));            
            
            G   =   h1~h2~h3~h4;
            G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

            Info=   G^(uv[1]-uv[2]);
            Info=   Info./(Info*ones(4,1));
            q_p =   Info.*po;
            q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @


            q_p =   Smax_in_4(q_p);

            playnow =   q_p[.,1].*(fPAF[i]-bbn[i])+bbn[i];

            lflnPAF =   kPAF_0(q_p,i,V0,a,p0);

            proba   =   proba + po[.,ll].*invalue1_PAF(q_p,@playnow,lflnPAF,@smhv2d(lflnPAF,playnow),aan,bbn,p0,fPAF,V0,i);
        endfor;
    endfor;

    proba   =   proba/Njj;

@ plays and wins once used...plays and loses once used...uses 50/50 and quits...does not use 50/50 and wins...does not use 50/50 and loses@

    proba   =   cnd1a.*proba;
    probb   =   cnd1b.*probb;

@use both, plays and wins...use both, plays and loses...use both and quits...@
@use PAF, plays and wins...use PAF, plays and loses...@
@use ATA, plays and wins...use ATA, plays and loses...@
@plays and wins...plays and loses@

    probc   =   (proba[.,1:3] + probb[.,1:3])~probb[.,4:5]~proba[.,4:5]~
                ( (1-cnd1a-cnd1b).*(po[.,1]~(1-po[.,1])) );

    retp(
        probc
        );

endp;


proc (2)=value1_PAFATA(a,fPAF,fATA,V0,p0,uv);

local aan,bbn,f1,bp,po,playnow,lfln1,lfln2,cnd1a,cnd1b,problfn,i2;


    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    bp  =   a[1:11];
    
    for i (1,rows(an),1);

        i2  =   (i-1)/(rows(an)-1);
    
        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];

        lfln1   =   kATA_PAF(po,i,V0,fPAF,a,uv,p0[i]);
        lfln2   =   kPAF_ATA(po,i,V0,fATA,a,p0[i],uv);


        cnd1a   =   smhv3d(lfln1,lfln2,playnow); @ use life line ATA...@
        cnd1b   =   smhv3d(lfln2,lfln1,playnow); @ use life line PAF..@

        if i==1;
            problfn =   meanc(invalue1_PAFATA(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,p0[i],uv,fPAF,fATA,V0,i))';
        else;
            problfn =   problfn|
                        (meanc(invalue1_PAFATA(po,@playnow,lfln1,lfln2,@cnd1a,cnd1b,a,aan,bbn,p0[i],uv,fPAF,fATA,V0,i))');
        endif;

        f1   =   f1|
                 meanc(
                        (playnow + cnd1a.*(lfln1-playnow)+cnd1b.*(lfln2-playnow))
                      );
    endfor;

    retp(
        problfn,
        f1
        );
endp;

/*** fin ***/

proc invalue1_5050PAFATA(po,@playnow,lfln1,lfln2,lfln3,@cnd1a,cnd1b,cnd1c,a,aan,bbn,p0,uv,f5050PAF,f5050ATA,fPAFATA,f5050,fPAF,fATA,V0,i);

    local G,Info,check,cnd,cnd5050a,cnd5050b,cndATAa,cndATAb,cndPAFa,cndPAFb,cst1,div,h1,h2,h3,h4,idx,idxa,idxb,idxc,
          lfln1,lfln2,p_t_s,pinf,playnow,po_PAF,proba,probb,probc,pst,q_p,rpo,scal,st,stG,stVmbi,stbi,u1,un;

    idxa    =   { 1 1 2 1 2 3 };
    idxb    =   { 2 3 3 4 4 4 };

    rpo =   rows(po);

    probb   =   zeros(rpo,9);
    div     =   probb[.,1]+1;

    for kk (1,6,1); @ play 5050 first @

        if ((kk==1)+(kk==2)+(kk==4));
            cnd =   po[.,idxb[kk]].>0;
            idx =   selif(seqa(1,1,rows(po)),cnd);
            if scalmiss(idx)==0;
                un  =   rows(idx);
                un  =   ones(un,1);
                div[idx]    =   un*((kk==1)+(kk==2)*2+(kk==4)*3);
            endif;
        endif;

        if kk==1 and minc(cnd)<1;
            idxc        =   selif(seqa(1,1,rows(po)),1-cnd);

            playnow =   fPAFATA[i];
            lfln1   =   kATA_PAF((1~0~0~0).*ones(rows(idxc),1),i,V0,fPAF,a,uv,p0);
            lfln2   =   kPAF_ATA((1~0~0~0).*ones(rows(idxc),1),i,V0,fATA,a,p0,uv);


            cnd5050a=   smhv3d(lfln1,lfln2,playnow);
            cnd5050b=   smhv3d(lfln2,lfln1,playnow);

            probb[idxc,.]  =    probb[idxc,.]   +
                                invalue1_PAFATA((1~0~0~0).*ones(rows(idxc),1),@playnow,lfln1,lfln2,@cnd5050a,cnd5050b,a,aan,bbn,p0,uv,fPAF,fATA,V0,i);

        endif;

        if scalmiss(idx)==0;
            pst =   po[idx,idxa[kk]]+po[idx,idxb[kk]];

            playnow =   po[idx,idxa[kk]]./pst.*(fPAFATA[i]-bbn[i])+bbn[i];

            lfln1   =   kATA_PAF((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),i,V0,fPAF,a,uv,p0);
            lfln2   =   kPAF_ATA((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),i,V0,fATA,a,p0,uv);

            cnd5050a=   smhv3d(lfln1,lfln2,playnow);
            cnd5050b=   smhv3d(lfln2,lfln1,playnow);


            probb[idx,.]  =    probb[idx,.]   + pst.*
                               invalue1_PAFATA((po[idx,idxa[kk] idxb[kk]]./pst~zeros(rows(idx),2)),@playnow,lfln1,lfln2,@cnd5050a,cnd5050b,a,aan,bbn,p0,uv,fPAF,fATA,V0,i);
        else;
            break;
        endif;
    endfor;

    probb   =   probb./div;

    proba   =   0;
    for kk (1,2,1); @ play PAF first @
        if kk==1;
            po_PAF  =   po;
            pinf    =   p0;
        elseif kk==2;
            po_PAF  =   ones(rpo,1)~zeros(rpo,3);
            pinf    =   (1-p0);
        endif;

        playnow =   po_PAF[.,1].*(f5050ATA[i]-bbn[i])+bbn[i];
        lfln1   =   kATA_5050(po_PAF,i,V0,f5050,a,uv);
        lfln2   =   k5050_ATA(po_PAF,i,V0,fATA,a,uv);

        cndPAFa =   smhv3d(lfln1,lfln2,playnow);
        cndPAFb =   smhv3d(lfln2,lfln1,playnow);

        proba =     proba   +   pinf.*invalue1_5050ATA(po_PAF,@playnow,lfln1,lfln2,@cndPAFa,cndPAFb,a,aan,bbn,uv,f5050,fATA,V0,i);
    endfor;


@plays ATA first...@

    scal=   gamma(uv[1]+uv[2]*3)/gamma(4*uv[2])*gamma(uv[2])/gamma(uv[1]);


    probc   =   0;

    for jj (1,Njj,1);
        st  =   0;
        for ll (1,4,1);
            { u1 , __stategl } = rndKMu( rpo, 4 , __stategl);
__u_count = __u_count+rows(u1);
            h1  =   inv_gam(u1[.,1],uv[2]+(ll==1)*(uv[1]-uv[2]));
            h2  =   inv_gam(u1[.,2],uv[2]+(ll==2)*(uv[1]-uv[2]));
            h3  =   inv_gam(u1[.,3],uv[2]+(ll==3)*(uv[1]-uv[2]));
            h4  =   inv_gam(u1[.,4],uv[2]+(ll==4)*(uv[1]-uv[2]));
            
            G   =   h1~h2~h3~h4;
            G   =   G./(h1+h2+h3+h4); @ simulate a 4-dirichlet with parameter uv[2]^4 @

            Info=   G^(uv[1]-uv[2]);
            Info=   Info./(Info*ones(4,1));

            q_p =   Info.*po;
            q_p =   q_p./(q_p*ones(4,1)); @ updated beliefs @


            q_p   =   Smax_in_4(q_p);

            playnow =   q_p[.,1].*(f5050PAF[i]-bbn[i])+bbn[i];

            lfln1   =   kPAF_5050(q_p,i,V0,f5050,a,p0);
            lfln2   =   k5050_PAF(q_p,i,V0,fPAF,a,p0);

            cndATAa =   smhv3d(lfln1,lfln2,playnow);
            cndATAb =   smhv3d(lfln2,lfln1,playnow);

            probc   =   probc + po[.,ll].*invalue1_5050PAF(q_p,@playnow,lfln1,lfln2,@cndATAa,cndATAb,a,aan,bbn,p0,f5050,fPAF,V0,i);
        endfor;

    endfor;

    probc   =   probc/Njj;


    proba   =   cnd1a.*proba;
    probb   =   cnd1b.*probb;
    probc   =   cnd1c.*probc;

@use all 3, plays and wins...use all 3, plays and loses...use all 3 and quits...@
@use 5050 PAF, plays and wins...use 5050 PAF, plays and loses...@
@use 5050 ATA, plays and wins...use 5050 ATA, plays and loses...@
@use PAF ATA, plays and wins...use PAF ATA, plays and loses...@
@use 5050, plays and wins...use 5050, plays and loses...@
@use PAF, plays and wins...use PAF, plays and loses...@
@use ATA, plays and wins...use ATA, plays and loses...@
@plays and wins...plays and loses@


    retp(
        (probb[.,1:3]+proba[.,1:3]+probc[.,1:3])~
        (probb[.,4:5]+proba[.,4:5])~
        (probb[.,6:7]+probc[.,4:5])~
        (proba[.,6:7]+probc[.,6:7])~
        probb[.,8:9]~proba[.,8:9]~probc[.,8:9]~
        (1-cnd1a-cnd1b-cnd1c).*(po[.,1]~(1-po[.,1]))
        );

endp;

proc (2)=value1_5050PAFATA(a,f5050PAF,f5050ATA,fPAFATA,f5050,fPAF,fATA,V0,p0,uv);

local   aan,bbn,f1,po,playnow,lfln1,lfln2,lfln3,cnd1a,cnd1b,cnd1c,problfn,bp,i2;
local check;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    bp  =   a[1:11];

    for i (1,rows(an),1);

        i2  =   (i-1)/(rows(an)-1);

        po  =   sim_z(bp[i],__Nsim,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];

        lfln1   =   kPAF_5050ATA(po,i,V0,f5050,fPAF,fATA,f5050PAF,f5050ATA,fPAFATA,a,p0[i],uv);
        lfln2   =   k5050_PAFATA(po,i,V0,f5050,fPAF,fATA,f5050PAF,f5050ATA,fPAFATA,a,p0[i],uv);
        lfln3   =   kATA_5050PAF(po,i,V0,f5050,fPAF,fATA,f5050PAF,f5050ATA,fPAFATA,a,p0[i],uv);


        cnd1a   =   smhv4d(lfln1,lfln2,lfln3,playnow);
        cnd1b   =   smhv4d(lfln2,lfln1,lfln3,playnow);
        cnd1c   =   smhv4d(lfln3,lfln1,lfln2,playnow);


@check = cnd1a~cnd1b~cnd1c; check = check~sumc(check');@

        if i==1;
            problfn =   meanc(invalue1_5050PAFATA(po,
                                                  @playnow,lfln1,lfln2,lfln3,@cnd1a,cnd1b,cnd1c,
                                                  a,aan,bbn,p0[i],uv,
                                                  f5050PAF,f5050ATA,fPAFATA,f5050,fPAF,fATA,V0,i))';
        else;
            problfn =   problfn|(
                              meanc(
                              invalue1_5050PAFATA(po,
                                                  @playnow,lfln1,lfln2,lfln3,@cnd1a,cnd1b,cnd1c,
                                                  a,aan,bbn,p0[i],uv,
                                                  f5050PAF,f5050ATA,fPAFATA,f5050,fPAF,fATA,V0,i)
                                    )'
                                );
        endif;


        f1   =   f1|
                 meanc(
                        (playnow + cnd1a.*(lfln1-playnow)+cnd1b.*(lfln2-playnow)+cnd1c.*(lfln3-playnow))
                      );

    endfor;

    retp(
        problfn,
        f1
        );
endp;


proc (0)=grph_5050(a,V0);

local bb0,bb1,f,st,i,p_bar,prb,r1,upp, lim_sup,lim_inf,bp,
      aan,bbn,f1,po,playnow,lfln,cnd1,cnd2,cnd3,cnd4,cnd5,cnd6,
      cst1,problfn,mm,i2;

    aan =   u(an,a[12:21]);
    bbn =   u(bn,a[12:21]);
    f1  =   FFn;
    f1  =   u(f1,a[12:21]);

    st  =   miss(0~0~0~0,0);

    begwind;
    window(3,4,0);

    i = 1;

    do while i<=rows(an);
        /*
        if i>=11;
            i;
        endif;
        */
        i2  =   (i-1)/(rows(an)-1);
        bp  =a[1]*i2^3 + a[2]*(1-i2^3)+a[3]*(i2-i2^2); @suggested from Bezier curve...@


        po  =   sim_z(bp,8000,i);

        playnow =   po[.,1].*(f1[i]-bbn[i])+bbn[i];
        lfln    =   k5050_0(po,i,V0,a);

        cnd1    =   smhv2d(lfln,playnow); @ use life line ...@

        setwind(i);
            graphset;
                _plctrl=-1;
                _psymsiz=0.3;
            title(ftocv(i,2,0));
            xtics(-0.1,1.1,0.2,0);
            ytics(-0.1,1.1,0.2,0);
            xlabel("max belief");
            ylabel("prob use 50/50");
            call xy(maxc(po'),cnd1);



        if i==1;
            mm  =   meanc((cnd1.>0.99)~(cnd1.<0.01))';
        else;
            mm  =   mm|(meanc((cnd1.>0.99)~(cnd1.<0.01))');
        endif;

      f1   =   f1|
                 meanc( (playnow + @(lfln.>playnow)@cnd1.*(lfln-playnow)));
        i   =   i   +   1;

    endo;

    setwind(12);
        graphset;
                _plctrl=-1;
                @_psymsiz=0.3;@
            xtics(-0.1,1.1,0.2,0);
            ytics(-0.1,1.1,0.2,0);
        call xy(seqa(0,1,rows(an)),mm);

    endwind;
endp;

/*** fin ***/

@ the data must be grouped    @
@ format                      @
@ frequency finalquestion abandon winamillion   @

proc mklik(
            lfl1,rd1,lfl2,rd2,lfl3,rd3,didQuit,WinaMil,lastQ,LOst,
            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
          );

    @ changes made 24/01/04 @

    @ lfl1 = 0 means ind starts with 2 or less life lines @
    @ lfl2 = 0 means ind starts with 1 or less life lines @
    @ lfl3 = 0 means ind starts with no life lines @

    @ rd1 roud when lfl1 played @
    @ rd2 roud when lfl2 played @
    @ rd3 roud when lfl3 played @

    @ rounds are counted from 11 to 1 @

    @ didQuit=1 stopped playing @
    @ WinaMil reached the last and won!@
    @ Lost=1 looser!...@

    @ 5050 : 1 @
    @ PAF  : 2 @
    @ ATA  : 3 @

    local i,j,k,
          ll,res,flag;

        ll  =   zeros(1,11)-1;        

    if lastQ<11;

        for i (11,lastQ+1,-1);
@            i;;LastQ~Lost~didQuit~WinaMil;@
            if i>rd1;

                @ll  =   ll+ln(p5050PAFATA[i,16]);@
                ll[i]   =   p5050PAFATA[i,16];

            elseif i==rd1 and rd1>rd2;

                if lfl1==1;
                    @ll  =   ll+ln(p5050PAFATA[i,10]);@
                    ll[i]   =   p5050PAFATA[i,10];
                elseif lfl1==2;
                    @ll  =   ll+ln(p5050PAFATA[i,12]);@
                    ll[i]   =   p5050PAFATA[i,12];
                elseif lfl1==3;
                    @ll  =   ll+ln(p5050PAFATA[i,14]);@
                    ll[i]   =   p5050PAFATA[i,14];
                endif;

            elseif i==rd1 and rd1==rd2 and rd2>rd3;

                if (lfl1==1 and lfl2==2) or (lfl1==2 and lfl2==1);
                    @ll  =   ll+ln(p5050PAFATA[i,4]);@
                    ll[i]   =   p5050PAFATA[i,4];    
                elseif (lfl1==1 and lfl2==3) or (lfl1==3 and lfl2==1);
                    @ll  =   ll+ln(p5050PAFATA[i,6]);@
                    ll[i]   =   p5050PAFATA[i,6];    
                elseif (lfl1==2 and lfl2==3) or (lfl1==3 and lfl2==2);
                    @ll  =   ll+ln(p5050PAFATA[i,8]);@
                    ll[i]   =   p5050PAFATA[i,8];    
                endif;

            elseif i==rd1 and rd1==rd2 and rd1==rd3;

                    @ll  =   ll+ln(p5050PAFATA[i,1]);@
                    ll[i]   =   p5050PAFATA[i,1];    
            elseif i<rd1 and i>rd2;

                if lfl1==1;
                    @ll  =   ll+ln(pPAFATA[i,8]);@
                    ll[i]   =   pPAFATA[i,8];    
                elseif lfl1==2;
                    @ll  =   ll+ln(p5050ATA[i,8]);@
                    ll[i]   =   p5050ATA[i,8];    
                elseif lfl1==3;
                    @ll  =   ll+ln(p5050PAF[i,8]);@
                    ll[i]   =   p5050PAF[i,8];    
                endif;

            elseif i<rd1 and i==rd2 and rd2>rd3;

                if lfl1==1 and lfl2==2;
                    @ll  =   ll+ln(pPAFATA[i,4]);@
                    ll[i]   =   pPAFATA[i,4];    
                elseif lfl1==1 and lfl2==3;
                    @ll  =   ll+ln(pPAFATA[i,6]);@
                    ll[i]   =   pPAFATA[i,6];    
                elseif lfl1==2 and lfl2==1;
                    @ll  =   ll+ln(p5050ATA[i,4]);@
                    ll[i]   =   p5050ATA[i,4];    
                elseif lfl1==2 and lfl2==3;
                    @ll  =   ll+ln(p5050ATA[i,6]);@
                    ll[i]   =   p5050ATA[i,6];    
                elseif lfl1==3 and lfl2==1;
                    @ll  =   ll+ln(p5050PAF[i,4]);@
                    ll[i]   =   p5050PAF[i,4];    
                elseif lfl1==3 and lfl2==2;
                    @ll  =   ll+ln(p5050PAF[i,6]);@
                    ll[i]   =   p5050PAF[i,6];    
                endif;

            elseif i<rd1 and i==rd2 and rd2==rd3;

                if (lfl2==1 and lfl3==2) or (lfl2==2 and lfl3==1);
                    @ll  =   ll+ln(p5050PAF[i,1]);@
                    ll[i]   =   p5050PAF[i,1];    
                elseif (lfl2==1 and lfl3==3) or (lfl2==3 and lfl3==1);
                    @ll  =   ll+ln(p5050ATA[i,1]);@
                    ll[i]   =   p5050ATA[i,1];    
                elseif (lfl2==2 and lfl3==3) or (lfl2==3 and lfl3==2);
                    @ll  =   ll+ln(pPAFATA[i,1]);@
                    ll[i]   =   pPAFATA[i,1];    
                endif;

            elseif i<rd2 and i>rd3;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[i,4]);@
                    ll[i]   =   p5050[i,4];    
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[i,4]);@
                    ll[i]   =   pPAF[i,4];    
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[i,4]);@
                    ll[i]   =   pATA[i,4];    
                endif;

            elseif i<rd2 and i==rd3;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[i,1]);@
                    ll[i]   =   p5050[i,1];    
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[i,1]);@
                    ll[i]   =   pPAF[i,1];    
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[i,1]);@
                    ll[i]   =   pATA[i,1];    
                endif;

            elseif i<rd3;

                    @ll  =   ll+ln(p0[i,1]);@
                    ll[i]   =   p0[i,1];    

            endif;

        endfor;

    endif;

    i   =   lastQ;
@    i~LastQ~Lost~didQuit;
    "";@

    if lastQ>1;

        if i>rd1;

            @ll  =   ll+ln(p5050PAFATA[i,17]);@
            ll[i]   =   p5050PAFATA[i,17];    
        elseif i==rd1 and rd1>rd2;

            if lfl1==1;
                    @ll  =   ll+ln(p5050PAFATA[i,11]);@
                    ll[i]   =   p5050PAFATA[i,11];    
            elseif lfl1==2;
                    @ll  =   ll+ln(p5050PAFATA[i,13]);@
                    ll[i]   =   p5050PAFATA[i,13];
            elseif lfl1==3;
                    @ll  =   ll+ln(p5050PAFATA[i,15]);@
                    ll[i]   =   p5050PAFATA[i,15];
            endif;

        elseif i==rd1 and rd1==rd2 and rd2>rd3;

            if (lfl1==1 and lfl2==2) or (lfl1==2 and lfl2==1);
                @ll  =   ll+ln(p5050PAFATA[i,5]);@
                ll[i]   =   p5050PAFATA[i,5];
            elseif (lfl1==1 and lfl2==3) or (lfl1==3 and lfl2==1);
                @ll  =   ll+ln(p5050PAFATA[i,7]);@
                ll[i]   =   p5050PAFATA[i,7];
            elseif (lfl1==2 and lfl2==3) or (lfl1==3 and lfl2==2);
                @ll  =   ll+ln(p5050PAFATA[i,9]);@
                ll[i]   =   p5050PAFATA[i,9];
            endif;

        elseif i==rd1 and rd1==rd2 and rd1==rd3;

            if didQuit;
                @ll  =   ll+ln(p5050PAFATA[i,3]);@
                ll[i]   =   p5050PAFATA[i,3];
            elseif Lost;
                @ll  =   ll+ln(p5050PAFATA[i,2]);@
                ll[i]   =   p5050PAFATA[i,2];
            endif;

        elseif i<rd1 and i>rd2;

            if lfl1==1;
                @ll  =   ll+ln(pPAFATA[i,9]);@
                ll[i]   =   pPAFATA[i,9];
            elseif lfl1==2;
                @ll  =   ll+ln(p5050ATA[i,9]);@
                ll[i]   =   p5050ATA[i,9];
            elseif lfl1==3;
                @ll  =   ll+ln(p5050PAF[i,9]);@
                ll[i]   =   p5050PAF[i,9];
            endif;

        elseif i<rd1 and i==rd2 and rd2>rd3;

            if lfl1==1 and lfl2==2;
                @ll  =   ll+ln(pPAFATA[i,5]);@
                ll[i]   =   pPAFATA[i,5];
            elseif lfl1==1 and lfl2==3;
                @ll  =   ll+ln(pPAFATA[i,7]);@
                ll[i]   =   pPAFATA[i,7];
            elseif lfl1==2 and lfl2==1;
                @ll  =   ll+ln(p5050ATA[i,5]);@
                ll[i]   =   p5050ATA[i,5];
            elseif lfl1==2 and lfl2==3;
                @ll  =   ll+ln(p5050ATA[i,7]);@
                ll[i]   =   p5050ATA[i,7];
            elseif lfl1==3 and lfl2==1;
                @ll  =   ll+ln(p5050PAF[i,5]);@
                ll[i]   =   p5050PAF[i,5];
            elseif lfl1==3 and lfl2==2;
                @ll  =   ll+ln(p5050PAF[i,7]);@
                ll[i]   =   p5050PAF[i,7];
            endif;

        elseif i<rd1 and i==rd2 and rd2==rd3;

            if Lost;

                if (lfl2==1 and lfl3==2) or (lfl2==2 and lfl3==1);
                    @ll  =   ll+ln(p5050PAF[i,2]);@
                    ll[i]   =   p5050PAF[i,2];                    
                elseif (lfl2==1 and lfl3==3) or (lfl2==3 and lfl3==1);
                    @ll  =   ll+ln(p5050ATA[i,2]);@
                    ll[i]   =   p5050ATA[i,2];
                elseif (lfl2==2 and lfl3==3) or (lfl2==3 and lfl3==2);
                    @ll  =   ll+ln(pPAFATA[i,2]);@
                    ll[i]   =   pPAFATA[i,2];
                endif;

            elseif didQuit;

                if (lfl2==1 and lfl3==2) or (lfl2==2 and lfl3==1);
                    @ll  =   ll+ln(p5050PAF[i,3]);@
                    ll[i]   =   p5050PAF[i,3];
                elseif (lfl2==1 and lfl3==3) or (lfl2==3 and lfl3==1);
                    @ll  =   ll+ln(p5050ATA[i,3]);@
                    ll[i]   =   p5050ATA[i,3];
                elseif (lfl2==2 and lfl3==3) or (lfl2==3 and lfl3==2);
                    @ll  =   ll+ln(pPAFATA[i,3]);@
                    ll[i]   =   pPAFATA[i,3];
                endif;

            endif;

        elseif i<rd2 and i>rd3;

            if lfl3==1;
                @ll  =   ll+ln(p5050[i,5]);@
                ll[i]   =   p5050[i,5];
            elseif lfl3==2;
                @ll  =   ll+ln(pPAF[i,5]);@
                ll[i]   =   pPAF[i,5];
            elseif lfl3==3;
                @ll  =   ll+ln(pATA[i,5]);@
                ll[i]   =   pATA[i,5];        
            endif;

        elseif i<rd2 and i==rd3;

            if Lost;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[i,2]);@
                    ll[i]   =   p5050[i,2];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[i,2]);@
                    ll[i]   =   pPAF[i,2];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[i,2]);@
                    ll[i]   =   pATA[i,2];
                endif;

            elseif didQuit;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[i,3]);@
                    ll[i]   =   p5050[i,3];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[i,3]);@
                    ll[i]   =   pPAF[i,3];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[i,3]);@
                    ll[i]   =   pATA[i,3];
                endif;

            endif;

        elseif i<rd3;

            if Lost;
                @ll  =   ll+ln(p0[i,2]);@
                ll[i]   =   p0[i,2];
            elseif didQuit;
                @ll  =   ll+ln(p0[i,3]);@
                ll[i]   =   p0[i,3];
            endif;

        endif;

    elseif LastQ==1; @ last round ...@

        if i>rd1;

            if Lost;
                @ll  =   ll+ln(p5050PAFATA[1,17]);@
                ll[i]   =   p5050PAFATA[1,17];
            elseif WinaMil;
                @ll  =   ll+ln(p5050PAFATA[1,16]);@
                ll[i]   =   p5050PAFATA[1,16];
            endif;

        elseif i==rd1 and rd1>rd2;

            if Lost;

                if lfl1==1;
                        @ll  =   ll+ln(p5050PAFATA[1,11]);@
                        ll[i]   =   p5050PAFATA[1,11];
                elseif lfl1==2;
                        @ll  =   ll+ln(p5050PAFATA[1,13]);@
                        ll[i]   =   p5050PAFATA[1,13];
                elseif lfl1==3;
                        @ll  =   ll+ln(p5050PAFATA[1,15]);@
                        ll[i]   =   p5050PAFATA[1,15];
                endif;

            elseif WinaMil;

                if lfl1==1;
                        @ll  =   ll+ln(p5050PAFATA[1,10]);@
                        ll[i]   =   p5050PAFATA[1,10];
                elseif lfl1==2;
                        @ll  =   ll+ln(p5050PAFATA[1,12]);@
                        ll[i]   =   p5050PAFATA[1,12];
                elseif lfl1==3;
                        @ll  =   ll+ln(p5050PAFATA[1,14]);@
                        ll[i]   =   p5050PAFATA[1,14];
                endif;

            endif;

        elseif i==rd1 and rd1==rd2 and rd2>rd3;

            if Lost;

                if (lfl1==1 and lfl2==2) or (lfl1==2 and lfl2==1);
                    @ll  =   ll+ln(p5050PAFATA[1,5]);@
                    ll[i]   =   p5050PAFATA[1,5];
                elseif (lfl1==1 and lfl2==3) or (lfl1==3 and lfl2==1);
                    @ll  =   ll+ln(p5050PAFATA[1,7]);@
                    ll[i]   =   p5050PAFATA[1,7];
                elseif (lfl1==2 and lfl2==3) or (lfl1==3 and lfl2==2);
                    @ll  =   ll+ln(p5050PAFATA[1,9]);@
                    ll[i]   =   p5050PAFATA[1,9];
                endif;

            elseif WinaMil;

                if (lfl1==1 and lfl2==2) or (lfl1==2 and lfl2==1);
                    @ll  =   ll+ln(p5050PAFATA[1,4]);@
                    ll[i]   =   p5050PAFATA[1,4];
                elseif (lfl1==1 and lfl2==3) or (lfl1==3 and lfl2==1);
                    @ll  =   ll+ln(p5050PAFATA[1,6]);@
                    ll[i]   =   p5050PAFATA[1,6];
                elseif (lfl1==2 and lfl2==3) or (lfl1==3 and lfl2==2);
                    @ll  =   ll+ln(p5050PAFATA[1,8]);@
                    ll[i]   =   p5050PAFATA[1,8];
                endif;

            endif;

        elseif i==rd1 and rd1==rd2 and rd1==rd3;

            if didQuit;

                @ll  =   ll+ln(p5050PAFATA[1,3]);@
                ll[i]   =   p5050PAFATA[1,3];

            elseif Lost;

                @ll  =   ll+ln(p5050PAFATA[1,2]);@
                ll[i]   =   p5050PAFATA[1,2];

            elseif WinaMil;

                @ll  =   ll+ln(p5050PAFATA[1,1]);@
                ll[i]   =   p5050PAFATA[1,1];

            endif;

        elseif i<rd1 and i>rd2;

            if Lost;

                if lfl1==1;
                    @ll  =   ll+ln(pPAFATA[1,9]);@
                    ll[i]   =   pPAFATA[1,9];
                elseif lfl1==2;
                    @ll  =   ll+ln(p5050ATA[1,9]);@
                    ll[i]   =   p5050ATA[1,9];
                elseif lfl1==3;
                    @ll  =   ll+ln(p5050PAF[1,9]);@
                    ll[i]   =   p5050PAF[1,9];
                endif;

            elseif WinaMil;

                if lfl1==1;
                    @ll  =   ll+ln(pPAFATA[1,8]);@
                    ll[i]   =   pPAFATA[1,8];
                elseif lfl1==2;
                    @ll  =   ll+ln(p5050ATA[1,8]);@
                    ll[i]   =   p5050ATA[1,8];
                elseif lfl1==3;
                    @ll  =   ll+ln(p5050PAF[1,8]);@
                    ll[i]   =   p5050PAF[1,8];
                endif;

            endif;

        elseif i<rd1 and i==rd2 and rd2>rd3;

            if Lost;

                if lfl1==1 and lfl2==2;
                    @ll  =   ll+ln(pPAFATA[1,5]);@
                    ll[i]   =   pPAFATA[1,5];
                elseif lfl1==1 and lfl2==3;
                    @ll  =   ll+ln(pPAFATA[1,7]);@
                    ll[i]   =   pPAFATA[1,7];
                elseif lfl1==2 and lfl2==1;
                    @ll  =   ll+ln(p5050ATA[1,5]);@
                    ll[i]   =   p5050ATA[1,5];
                elseif lfl1==2 and lfl2==3;
                    @ll  =   ll+ln(p5050ATA[1,7]);@
                    ll[i]   =   p5050ATA[1,7];
                elseif lfl1==3 and lfl2==1;
                    @ll  =   ll+ln(p5050PAF[1,5]);@
                    ll[i]   =   p5050PAF[1,5];
                elseif lfl1==3 and lfl2==2;
                    @ll  =   ll+ln(p5050PAF[1,7]);@
                    ll[i]   =   p5050PAF[1,7];
                endif;

            elseif WinaMil;

                if lfl1==1 and lfl2==2;
                    @ll  =   ll+ln(pPAFATA[1,4]);@
                    ll[i]   =   pPAFATA[1,4];
                elseif lfl1==1 and lfl2==3;
                    @ll  =   ll+ln(pPAFATA[1,6]);@
                    ll[i]   =   pPAFATA[1,6];
                elseif lfl1==2 and lfl2==1;
                    @ll  =   ll+ln(p5050ATA[1,4]);@
                    ll[i]   =   p5050ATA[1,4];
                elseif lfl1==2 and lfl2==3;
                    @ll  =   ll+ln(p5050ATA[1,6]);@
                    ll[i]   =   p5050ATA[1,6];
                elseif lfl1==3 and lfl2==1;
                    @ll  =   ll+ln(p5050PAF[1,4]);@
                    ll[i]   =   p5050PAF[1,4];
                elseif lfl1==3 and lfl2==2;
                    @ll  =   ll+ln(p5050PAF[1,6]);@
                    ll[i]   =   p5050PAF[1,6];
                endif;

            endif;

        elseif i<rd1 and i==rd2 and rd2==rd3;

            if Lost;

                if (lfl2==1 and lfl3==2) or (lfl2==2 and lfl3==1);
                    @ll  =   ll+ln(p5050PAF[1,2]);@
                    ll[i]   =   p5050PAF[1,2];
                elseif (lfl2==1 and lfl3==3) or (lfl2==3 and lfl3==1);
                    @ll  =   ll+ln(p5050ATA[1,2]);@
                    ll[i]   =   p5050ATA[1,2];
                elseif (lfl2==2 and lfl3==3) or (lfl2==3 and lfl3==2);
                    @ll  =   ll+ln(pPAFATA[1,2]);@
                    ll[i]   =   pPAFATA[1,2];
                endif;

            elseif didQuit;

                if (lfl2==1 and lfl3==2) or (lfl2==2 and lfl3==1);
                    @ll  =   ll+ln(p5050PAF[1,3]);@
                    ll[i]   =   p5050PAF[1,3];
                elseif (lfl2==1 and lfl3==3) or (lfl2==3 and lfl3==1);
                    @ll  =   ll+ln(p5050ATA[1,3]);@
                    ll[i]   =   p5050ATA[1,3];
                elseif (lfl2==2 and lfl3==3) or (lfl2==3 and lfl3==2);
                    @ll  =   ll+ln(pPAFATA[1,3]);@
                    ll[i]   =   pPAFATA[1,3];
                endif;

            elseif WinaMil;

                if (lfl2==1 and lfl3==2) or (lfl2==2 and lfl3==1);
                    @ll  =   ll+ln(p5050PAF[1,1]);@
                    ll[i]   =   p5050PAF[1,1];
                elseif (lfl2==1 and lfl3==3) or (lfl2==3 and lfl3==1);
                    @ll  =   ll+ln(p5050ATA[1,1]);@
                    ll[i]   =   p5050ATA[1,1];
                elseif (lfl2==2 and lfl3==3) or (lfl2==3 and lfl3==2);
                    @ll  =   ll+ln(pPAFATA[1,1]);@
                    ll[i]   =   pPAFATA[1,1];
                endif;


            endif;

        elseif i<rd2 and i>rd3;

            if Lost;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[1,5]);@
                    ll[i]   =   p5050[1,5];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[1,5]);@
                    ll[i]   =   pPAF[1,5];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[1,5]);@
                    ll[i]   =   pATA[1,5];
                endif;

            elseif WinaMil;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[1,4]);@
                    ll[i]   =   p5050[1,4];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[1,4]);@
                    ll[i]   =   pPAF[1,4];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[1,4]);@
                    ll[i]   =   pATA[1,4];
                endif;

            endif;

        elseif i<rd2 and i==rd3;

            if Lost;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[1,2]);@
                    ll[i]   =   p5050[1,2];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[1,2]);@
                    ll[i]   =   pPAF[1,2];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[1,2]);@
                    ll[i]   =   pATA[1,2];
                endif;

            elseif didQuit;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[1,3]);@
                    ll[i]   =   p5050[1,3];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[1,3]);@
                    ll[i]   =   pPAF[1,3];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[1,3]);@
                    ll[i]   =   pATA[1,3];
                endif;

            elseif WinaMil;

                if lfl3==1;
                    @ll  =   ll+ln(p5050[1,1]);@
                    ll[i]   =   p5050[1,1];
                elseif lfl3==2;
                    @ll  =   ll+ln(pPAF[1,1]);@
                    ll[i]   =   pPAF[1,1];
                elseif lfl3==3;
                    @ll  =   ll+ln(pATA[1,1]);@
                    ll[i]   =   pATA[1,1];
                endif;

            endif;

        elseif i<rd3;

            if Lost;
                @ll  =   ll+ln(p0[1,2]);@
                ll[i]   =   p0[1,2];
            elseif didQuit;
                @ll  =   ll+ln(p0[1,3]);@
                ll[i]   =   p0[1,3];
            elseif WinaMil;
                @ll  =   ll+ln(p0[1,1]);@
                ll[i]   =   p0[1,1];
            endif;

        endif;

    endif;
/*
    ll  =   miss(ll,ln(0)); @ gets rid of -INF @
    ll  =   missrv(ll,-25);
    ll  =   -25 + (ll.>-25).*(ll+25);
*/

    ll = missrv(ll,0);
    ll = miss(ll,-1);
    ll = missrv(ll,1);
    flag    =   0;
    
    for i(1,11,1);
        if ll[i]<1 and flag==0;
            res =   ln(ll[i]);
            flag    =   1;
        elseif ll[i]<1 and flag==1;
            res =   res+ln(ll[i]);
        endif;
    endfor;

    if res<-25;
        retp(-25);
    else;                    
        retp(res);
    endif;                

endp;

/* format for data... */
/* 1stLF 1stLFround 2ndLF 2ndLFround 3rdLF 3rdLFround Quit WinaMil LastQuest Lost Nobs*/
/* 1     2          3     4          5     6          7    8       9         10   11  */

proc lik(beta);
    retp(
        @meanc(@
             lklh(beta,__dt)
             @)@
        );
endp;

proc mlik(beta);
    retp(
        meanc(
             lklh(beta,__dt)
             )
        );
endp;


proc lklh(beta,data);

    local ll,i,p_p0,p_w0,flag,
          b,s1,s2,bb,
          m,n,o,q,un,
          b0,bp,p10,p1,p2,p0paf,
          V0,V5050,VPAF,VATA,V5050PAF,V5050ATA,VPAFATA,V5050PAFATA,
          p0,p5050,pPAF,pATA,p5050PAF,p5050ATA,pPAFATA,p5050PAFATA,
          rho,gam,thet;

    beta    =   real(beta);
    @save betagl = beta;@

    __a =   0;
    __aa=   0;
    __z =   0;
    __zz=   0;
    __m2=   0;
    __x_f3= 0;
    __y_f3= 0;
    __stategl   =   0;
    
    bp      =   abs(beta[1:11])+0.005; @ distribution parameters one for each level! min  0.005@
    
    beta[12:21] = 1/(1+exp(-beta[12:21]));
    
    for i(13,21,1);              
            beta[i] = 
                    (
                        beta[i-1]+(1-beta[i-1])*beta[i]
                    );
    endfor;  
    
    p0paf   =   1/(1+exp(-beta[22]))+1e-3; @ parameter for quality of PAF ... @
    
    @ inverse : bb = -ln(1/(a-1e-3)-1); @
    beta[12:21] = rev(beta[12:21]);
    @ u(32) linearly interpolated between u(16) and u(64) @
    @bb = beta[12:15]|(0.75*beta[15]+0.25*beta[16])|beta[16:20];@
    b0  =   bp|beta[12:21];
    
    (b0')~p0paf~__u_count;
    __u_count=0;

    {p_p0,p_w0,V0,q}    =   value0(b0);

    p_w0 = 0.99999 + (p_w0.<0.99999).*(p_w0-0.99999);

    p0  =   (p_p0.*(p_w0~(1-p_w0)))~(1-p_p0);

    {p5050,V5050}       =   value1_5050(b0,V0);

    {pPAF,VPAF}         =   value1_PAF(b0,V0,p0paf);

    {pATA,VATA}         =   value1_ATA(b0,V0,__uvata);

    {p5050PAF,V5050PAF} =   value1_5050PAF(b0,V5050,VPAF,V0,p0paf);

    {p5050ATA,V5050ATA} =   value1_5050ATA(b0,V5050,VATA,V0,__uvata);

    {pPAFATA,VPAFATA}   =   value1_PAFATA(b0,VPAF,VATA,V0,p0paf,__uvata);
/*

    if __glflag==0; @ neutralise this step...@
        {p5050PAFATA,V5050PAFATA} = value1_5050PAFATA(b0,V5050PAF,V5050ATA,VPAFATA,V5050,VPAF,VATA,V0,p0paf,__uvata);
        save p5050PAFATAgl=p5050PAFATA, V5050PAFATAgl=V5050PAFATA;
        __glflag=1;
    else;
        loadm p5050PAFATA=p5050PAFATAgl;
        loadm V5050PAFATA=V5050PAFATAgl;
    endif;
*/

    {p5050PAFATA,V5050PAFATA} = value1_5050PAFATA(b0,V5050PAF,V5050ATA,VPAFATA,V5050,VPAF,VATA,V0,p0paf,__uvata);

    un  =   ones(1,rows(p0));

    p0  =   miss(p0,0);

    p5050   =   miss(p5050,0);
    pPAF    =   miss(pPAF,0);
    pATA    =   miss(pATA,0);

    p5050PAF    =   miss(p5050PAF,0);
    p5050ATA    =   miss(p5050ATA,0);
    pPAFATA     =   miss(pPAFATA,0);

    p5050PAFATA =   miss(p5050PAFATA,0);

    for i (1,rows(data),1);
/* format for data... */
/* 1stLF 1stLFround 2ndLF 2ndLFround 3rdLF 3rdLFround Quit WinaMil LastQuest Lost Nobs*/
/* 1     2          3     4          5     6          7    8       9         10   11  */

        if i==1;
@            lfl1,rd1,lfl2,rd2,lfl3,rd3,didQuit,WinaMil,lastQ,LOst,
            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0 @
            ll  =   mklik(
                            data[i,1],data[i,2],data[i,3],data[i,4],data[i,5],data[i,6],data[i,7],data[i,8],data[i,9],data[i,10],
                            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
                        );
        else;
            ll  =   ll|
                    (
                    mklik(
                            data[i,1],data[i,2],data[i,3],data[i,4],data[i,5],data[i,6],data[i,7],data[i,8],data[i,9],data[i,10],
                            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
                                    )
                    );
        endif;

    endfor;

    meanc(ll);

    ll  =   real(ll);

    retp(
        ll
        );
endp;


proc lklh2(beta,data);

    local ll,i,p_p0,p_w0,flag,
          b,s1,s2,bb,
          m,n,o,q,un,
          b0,bp,p10,p1,p2,p0paf,
          V0,V5050,VPAF,VATA,V5050PAF,V5050ATA,VPAFATA,V5050PAFATA,
          p0,p5050,pPAF,pATA,p5050PAF,p5050ATA,pPAFATA,p5050PAFATA,
          rho,gam,thet;

    beta    =   real(beta);
    @save betagl = beta;@

    __a =   0;
    __aa=   0;
    __z =   0;
    __zz=   0;
    __m2=   0;
    __x_f3= 0;
    __y_f3= 0;
    __stategl   =   0;
    
    bp      =   abs(beta[1:11])+0.005; @ distribution parameters one for each level! min  0.005@
    
    beta[12:21] = abs(beta[12:21]);
    
    @ keeps the parameters within limits! @
    
   local penal;
   penal = 0;
    
   for i(12,21,1);
        if _max_active[i]==1;
            if beta[i]<lim_down;
                penal   = -(beta[i]-lim_down)^2*10000;
                beta[i] = lim_down;                
            elseif beta[i]>lim_up;                    
                beta[i] = lim_up;
                penal   = -(beta[i]-lim_up)^2*10000;                
            endif;
        endif;
    endfor;        
    
    beta[12:21] = rev(beta[12:21]);  
    
    p0paf   =   1/(1+exp(-beta[22]))+1e-3; @ parameter for quality of PAF ... @

    b0  =   bp|beta[12:21];
    (b0')~p0paf~__u_count;
    __u_count=0;

    {p_p0,p_w0,V0,q}    =   value0(b0);

    p_w0 = 0.99999 + (p_w0.<0.99999).*(p_w0-0.99999);

    p0  =   (p_p0.*(p_w0~(1-p_w0)))~(1-p_p0);

    {p5050,V5050}       =   value1_5050(b0,V0);

    {pPAF,VPAF}         =   value1_PAF(b0,V0,p0paf);

    {pATA,VATA}         =   value1_ATA(b0,V0,__uvata);

    {p5050PAF,V5050PAF} =   value1_5050PAF(b0,V5050,VPAF,V0,p0paf);

    {p5050ATA,V5050ATA} =   value1_5050ATA(b0,V5050,VATA,V0,__uvata);

    {pPAFATA,VPAFATA}   =   value1_PAFATA(b0,VPAF,VATA,V0,p0paf,__uvata);
/*

    if __glflag==0; @ neutralise this step...@
        {p5050PAFATA,V5050PAFATA} = value1_5050PAFATA(b0,V5050PAF,V5050ATA,VPAFATA,V5050,VPAF,VATA,V0,p0paf,__uvata);
        save p5050PAFATAgl=p5050PAFATA, V5050PAFATAgl=V5050PAFATA;
        __glflag=1;
    else;
        loadm p5050PAFATA=p5050PAFATAgl;
        loadm V5050PAFATA=V5050PAFATAgl;
    endif;
*/

    {p5050PAFATA,V5050PAFATA} = value1_5050PAFATA(b0,V5050PAF,V5050ATA,VPAFATA,V5050,VPAF,VATA,V0,p0paf,__uvata);

    un  =   ones(1,rows(p0));

    p0  =   miss(p0,0);

    p5050   =   miss(p5050,0);
    pPAF    =   miss(pPAF,0);
    pATA    =   miss(pATA,0);

    p5050PAF    =   miss(p5050PAF,0);
    p5050ATA    =   miss(p5050ATA,0);
    pPAFATA     =   miss(pPAFATA,0);

    p5050PAFATA =   miss(p5050PAFATA,0);

    for i (1,rows(data),1);
/* format for data... */
/* 1stLF 1stLFround 2ndLF 2ndLFround 3rdLF 3rdLFround Quit WinaMil LastQuest Lost Nobs*/
/* 1     2          3     4          5     6          7    8       9         10   11  */

        if i==1;
@            lfl1,rd1,lfl2,rd2,lfl3,rd3,didQuit,WinaMil,lastQ,LOst,
            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0 @
            ll  =   mklik(
                            data[i,1],data[i,2],data[i,3],data[i,4],data[i,5],data[i,6],data[i,7],data[i,8],data[i,9],data[i,10],
                            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
                        );
        else;
            ll  =   ll|
                    (
                    mklik(
                            data[i,1],data[i,2],data[i,3],data[i,4],data[i,5],data[i,6],data[i,7],data[i,8],data[i,9],data[i,10],
                            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
                                    )
                    );
        endif;

    endfor;

    meanc(ll);

    ll  =   real(ll);

    retp(
        ll+penal
        );
endp;

proc lklh3(beta,data);
@ scaled parameters...@
@ requires declaration of pararmeter __scal_b @

    local ll,i,p_p0,p_w0,flag,
          b,s1,s2,bb,
          m,n,o,q,un,
          b0,bp,p10,p1,p2,p0paf,
          V0,V5050,VPAF,VATA,V5050PAF,V5050ATA,VPAFATA,V5050PAFATA,
          p0,p5050,pPAF,pATA,p5050PAF,p5050ATA,pPAFATA,p5050PAFATA,
          rho,gam,thet;

    beta    =   real(beta);
    @save betagl = beta;@

    __a =   0;
    __aa=   0;
    __z =   0;
    __zz=   0;
    __m2=   0;
    __x_f3= 0;
    __y_f3= 0;
    __stategl   =   0;
    
    bp      =   abs(beta[1:11].*__scal_b[1:11])+0.005; @ distribution parameters one for each level! min  0.005@
    bp  =   maxc(minc(bp'|2*ones(1,rows(bp)))'|-2*ones(1,rows(bp)));
    beta[12:21] = 1/(1+exp(-beta[12:21].*__scal_b[12:21]));
    beta[12:21]   =   minc(beta[12:21]'|0.999*ones(1,rows(beta[12:21])));
    for i(13,21,1);              
            beta[i] = 
                    (
                        beta[i-1]+(1-beta[i-1])*beta[i]
                    );            
    endfor;  
    
    p0paf   =   1/(1+exp(-beta[22:32].*__scal_b[22:32]))+1e-3; @ parameter for quality of PAF ... @
    p0paf   =   minc(p0paf'|0.99*ones(1,rows(p0paf)));
    @ inverse : bb = -ln(1/(a-1e-3)-1); @
    beta[12:21] = rev(beta[12:21]);
    @ u(32) linearly interpolated between u(16) and u(64) @
    @bb = beta[12:15]|(0.75*beta[15]+0.25*beta[16])|beta[16:20];@
    b0  =   bp|beta[12:21];
    
    (b0');p0paf';__u_count;
    __u_count=0;

    {p_p0,p_w0,V0,q}    =   value0(b0);

    p_w0 = 0.99999 + (p_w0.<0.99999).*(p_w0-0.99999);

    p0  =   (p_p0.*(p_w0~(1-p_w0)))~(1-p_p0);

    {p5050,V5050}       =   value1_5050(b0,V0);

    {pPAF,VPAF}         =   value1_PAF(b0,V0,p0paf);

    {pATA,VATA}         =   value1_ATA(b0,V0,__uvata);

    {p5050PAF,V5050PAF} =   value1_5050PAF(b0,V5050,VPAF,V0,p0paf);

    {p5050ATA,V5050ATA} =   value1_5050ATA(b0,V5050,VATA,V0,__uvata);

    {pPAFATA,VPAFATA}   =   value1_PAFATA(b0,VPAF,VATA,V0,p0paf,__uvata);
/*

    if __glflag==0; @ neutralise this step...@
        {p5050PAFATA,V5050PAFATA} = value1_5050PAFATA(b0,V5050PAF,V5050ATA,VPAFATA,V5050,VPAF,VATA,V0,p0paf,__uvata);
        save p5050PAFATAgl=p5050PAFATA, V5050PAFATAgl=V5050PAFATA;
        __glflag=1;
    else;
        loadm p5050PAFATA=p5050PAFATAgl;
        loadm V5050PAFATA=V5050PAFATAgl;
    endif;
*/

    {p5050PAFATA,V5050PAFATA} = value1_5050PAFATA(b0,V5050PAF,V5050ATA,VPAFATA,V5050,VPAF,VATA,V0,p0paf,__uvata);

    un  =   ones(1,rows(p0));

    p0  =   miss(p0,0);

    p5050   =   miss(p5050,0);
    pPAF    =   miss(pPAF,0);
    pATA    =   miss(pATA,0);

    p5050PAF    =   miss(p5050PAF,0);
    p5050ATA    =   miss(p5050ATA,0);
    pPAFATA     =   miss(pPAFATA,0);

    p5050PAFATA =   miss(p5050PAFATA,0);

    for i (1,rows(data),1);
/* format for data... */
/* 1stLF 1stLFround 2ndLF 2ndLFround 3rdLF 3rdLFround Quit WinaMil LastQuest Lost Nobs*/
/* 1     2          3     4          5     6          7    8       9         10   11  */

        if i==1;
@            lfl1,rd1,lfl2,rd2,lfl3,rd3,didQuit,WinaMil,lastQ,LOst,
            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0 @
            ll  =   mklik(
                            data[i,1],data[i,2],data[i,3],data[i,4],data[i,5],data[i,6],data[i,7],data[i,8],data[i,9],data[i,10],
                            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
                        );
        else;
            ll  =   ll|
                    (
                    mklik(
                            data[i,1],data[i,2],data[i,3],data[i,4],data[i,5],data[i,6],data[i,7],data[i,8],data[i,9],data[i,10],
                            p5050PAFATA,p5050PAF,p5050ATA,pPAFATA,p5050,pPAF,pATA,p0
                                    )
                    );
        endif;

    endfor;
    format 8,8;
    meanc(ll);
    format 4,4;
    ll  =   real(ll);

    retp(
        ll
        );
endp;
