new;

library gauss,maxlik;

maxset;

/* estimating the density of the information given by ATA without knowing the correct answer */


/* mixture of dirichlet density with known type probabilities = 1/4 */


proc (2)=evc_diric(u);
    local s,tt;
    tt  =   u[1 2 2 2];
    s   =   u[1]+3*u[2];
    retp(
        tt/s,
        1/(s^2*(s+1))*(s*eye(4).*tt - tt*tt')
        );
endp;


proc lngam(xx);
/* from numerical recipes */

    local cof,stp,half,un,fpf,x,tmp,ser,j,yy;

    cof =   (76.18009173|-86.50532033|24.01409822|-1.231739516|0.120858003*1e-2|-0.536382*1e-5);
    stp =   2.50662827465;

    half =  0.5;
    un  =   1;
    fpf =   5.5;

    if xx>=1;

        x   =   xx-un;
        tmp =   x+fpf;

        tmp =   (x+half)*ln(tmp)-tmp;

        ser =   un;

        for j (1,6,1);
            x   =   x + un;
            ser =   ser + cof[j]/x;
        endfor;

        retp(
            tmp + ln(stp*ser)
            );
    else;
        yy  =   1-xx;

        retp(
            ln(pi*yy)-lngam(1+yy)-ln(sin(pi*yy))
            );
    endif;

endp;



proc diric(p,u);
    local z;

    z   =   prodc(gamma(u))/gamma(sumc(u));
retp(
    prodc(p^(u-1))/z
    );
endp;




proc ln_diric(p,u,kk);

    local lnz,i,lgu,res,v,nbrmiss;
/* u : such that (a,b,b,b) */
/* where a is expected count if 1st answer is correct, b expected count otherwise otherwise */
    nbrmiss =   p.==miss(0,0);
    nbrmiss =   sumc(nbrmiss'); @either none or 2 @

@    p   =   1e-5+(p-1e-5).*(p.>1e-5);@

    v   =   u~u[2 1 3 4]~u[3 2 1 4]~u[4 2 3 1];

    res =   (missrv(ln(p),0)*(u-1)).*(kk.==1).*(p[.,1]./=miss(0,0));

    for i (2,rows(u),1);
        res =   res +   (missrv(ln(p),0)*(v[.,i]-1)).*(kk.==i).*(p[.,i]./=miss(0,0));
    endfor;

    lnz =   (
                lngam(u[1])+lngam(u[2])-lngam(u[1]+u[2])
            )+
            (nbrmiss.==0).*
            (
                2*lngam(u[2]) + lngam(u[1]+u[2])-lngam(u[1]+3*u[2])
            );

    retp(
        res - lnz
        );
endp;


proc lik_dir2(beta,data);

    local dt,u;

    beta    =   abs(beta) + 1e-3;
    u   =   beta[1 2 2 2];

    dt  =   data;

    retp(
        ln_diric(dt[.,1:4],u,dt[.,5])
        );
endp;
cls;
/*
{ x, newstate } = rndKMgam(50000,1,0.5,0);
{ y, newstate } = rndKMgam(50000,3,0.1,newstate);
gg = x~y;
gg = gg./(gg*ones(4,1));
dt  =   gg~ones(rows(x),1);
*/

dataf   =   "dt_ata";
loadm dt  =   ^dataf;

dt  =   selif(dt,dt[.,2]./=miss(0,0));

dt[.,3:6]   =   miss(dt[.,3:6],0);

@dt  =   packr(dt[.,3:6 cols(dt)]);@

dt  =   dt[.,3:6 cols(dt)];

{ x,f,g,cov,retcode } = MAXLIK(dt,0,&lik_dir2,1|1);

output file = ata_est.out reset;
    call maxprt(x,f,g,cov,retcode);
    {e,v}=evc_diric(abs(x)+1e-3);
    "mean";
    e;
    "variance";
    v;
output off;
