new;
cls;


dlibrary wwtbam, inv_gam;
library gauss,wwtbam, pgraph, inv_gam, maxlik;
#include maxlik.dec;
maxset;


output file = SATall.out on;
output off;

declare ksmooth    !=1000; @ smoothing parameter @

declare __bhhh      != 0;
declare lim_up      != 1;
declare lim_down    != 0;
declare __scal_b    != 0;

declare __afixed    !=0; @ used to check...@
declare __glflag    !=  1;   @ used to check...@

a=0;
declare __z !=  0;
declare __a !=  0.5;
declare __zz !=  0;
declare __aa !=  0.5;

declare __ast!= 0;
declare __flag != 0;
__flag = 0;
declare __x_f3  !=  0;
declare __y_f3  !=  0;

declare __m2!=  1;

declare an   !=  1;
declare bn   !=  1;
declare FFn  !=  1000;
@declare rho !=  2;@
declare m_x_p!= 0;

declare __dt    !=  0;
declare __n     !=  0;
declare __n0    !=  0;

declare ppetit   !=  1e-4;
declare st34     !=  4;

declare Njj     !=  1;@84@
declare Njjk    !=  1;

declare permut24!=  0;

declare __uvata !=  0;
declare __stategl   !=  0;

    /* useful thereafter */
    permut24    =   {   1 2 3 4,
                        1 2 4 3,
                        1 3 2 4,
                        1 3 4 2,
                        1 4 3 2,
                        1 4 2 3,
                        2 1 3 4,
                        2 1 4 3,
                        2 3 1 4,
                        2 3 4 1,
                        2 4 3 1,
                        2 4 1 3,
                        3 1 2 4,
                        3 1 4 2,
                        3 2 1 4,
                        3 2 4 1,
                        3 4 2 1,
                        3 4 1 2,
                        4 1 2 3,
                        4 1 3 2,
                        4 2 1 3,
                        4 2 3 1,
                        4 3 1 2,
                        4 3 2 1  };


_intord =   40;

an = { 500,250,125,64,32,16,8,4,2,1,0 };
an = an;
bn = { 32 , 32 , 32, 32,32,1 ,1 ,1,1,1,0 };
bn = bn;
FFn  = FFn;

declare __Nsim  =   12;


declare __u_count != 0;
declare __K1    !=  7;
declare __K2    !=  65;

#include option_prg.prg; 

Njj     =  6;
Njjk    =  6;


__uvata = 4.7553|0.9151;  @ new data @


a   =   1;
st  =   seqa(0,0.01,101);
__n0=   phi(st,a)~st;

st1  =   F_i(seqa(0,0.005,180)|seqa(0.9,0.001,101),__n0);

__n0    =   st1;
__n0[rows(__n0)]  =   1;


loadm path= ;
loadm dt=dtwwtbam; @ loads the data matrix in memory @

@ some good starting values @

	scal_b0 = {
	 1.946  	
	 1.3840001	
	 0.89134472	
	 0.63650947	
	 0.63491289	
	 0.11204252	
	 0.10654082	
	 0.078550456	
	-0.074893257	
	 0.04   	
	 0.04   	
	-7.8209 	
	-0.39905092	
	-1.6823474	
	-2.209968	
	-2.5115711	
	-3.5802 	
	-1.8942292	
	-2.30957	
	-1.6797849	
	-0.96941596	
	-0.7082 	
	-0.7082 	
	-0.45688978	
	-0.63028309	
	-0.39973233	
	-0.067436055	
	 0.017732326	
	 0.16444389	
	 0.53391287	
	 0.68977064	
	 0.91189781	
	};

	scal_b0 = scal_b0';

    __scal_b    =   ones(rows(scal_b0),1);

    _max_active =   ones(rows(scal_b0),1);

    scal_b0[22 23] = -0.7082|-0.7082; /* fixes paf prob to 1/3 for last two rounds */
    scal_b0[10 11] = 0.04|0.04; /* fixes question difficulty in first 2 rounds...not enough fails here to identify more*/

    scal_b0[9]  =   abs(scal_b0[9]);
/* scaling */

    _max_active =   ones(rows(scal_b0),1);
    _max_active[1]  =   0;        
    _max_active[10] =   0;
    _max_active[11] =   0;
    _max_active[22] =   0;
    _max_active[23] =   0;
    _max_active[12] =   0;
    _max_active[17] =   0;

    __scal_b    =   ones(rows(scal_b0),1);
    scal_b0 =   scal_b0./__scal_b;

/* this is an inelegant way to keep track of the optimisation...works for us! */

for ii(1,6,1);

    b0  =   scal_b0;

    maxset;
    _max_Algorithm = 2;
    if ii==1;
        _max_MaxIters   =   20;
    else;
        _max_MaxIters   =   20;
    endif;

    _max_covpar =   2;
    
    _max_usernumgrad = &gradLL;
    _max_UserNumHess = &bhhh;
    
    _max_parnames = (0 $+ "P_" $+ ftocv(seqa(1,1,11),2,0))|
                    (0 $+ "U_" $+ ftocv(seqa(1,1,10),2,0))|
                    (0 $+ "PAF_" $+ ftocv(seqa(1,1,11),2,0) );
    _max_parnames = _max_parnames $+ "        ";
    
    __title = ftocv(ksmooth,3,0);

    _max_active =   ones(rows(b0),1);

    _max_active[1]  =   0;
    _max_active[10] =   0;
    _max_active[11] =   0;        
    _max_active[22] =   0;
    _max_active[23] =   0;
    _max_active[12] =   0;
    _max_active[17] =   0;

    output on;
        "===============================================================================";
        lprint;
        $datestring(date);;"-";;$timestr(time);
        format 8,4;
        lprint;
        "__Nsim: " __Nsim  ";Njj:" Njj ";Njjk:" Njjk;
        "===============================================================================";
        { xml,fml,grd,covml,retcode } =maxlik(dt,0,&lklh3,scal_b0);
    output off;
    
    name= "Sall_" $+ ftocv(ksmooth,4,0) $+ "_" $+ datestrymd(0) $+ "_" $+ ftocv(ii+1,1,0);        
    
    output on;
        "===============================================================================";
        lprint;
        $datestring(date);;"-";;$timestr(time);;"-";;$name;
        "===============================================================================";
        format 8,4;
        lprint;
        "__Nsim: " __Nsim  ";Njj:" Njj ";Njjk:" Njjk;
        "===============================================================================";
        " smoothing parameter : ";; ksmooth;
        __scal_b;
        { xml,fml,grd,covml,retcode } = maxprt(xml,fml,grd,covml,retcode);
        "===============================================================================";
    output off;

    save xmlf=xml;
    save grd;
    save covml;
    scal_b0  =   xml.*__scal_b;
    

    save ^name = scal_b0;

    __scal_b    =   ones(rows(scal_b0),1);

endfor;
end;

/* these two routines are simple tweeks to allow a "fast" calculation of the BHHH metric */
/* you can do without if you are not happy with the trickery...*/
proc 1 = gradLL(f,x0,data);
    
    local n,k,grdd,dh,ax0,xdh,arg,dax0,i,f0;
    local f:proc;
    /* check for complex input */
    if iscplx(x0);
        if hasimag(x0);
            errorlog "ERROR: Not implemented for complex matrices.";
            end;
        else;
            x0 = real(x0);
        endif;
    endif;

    f0 = f(x0,data);
    n = rows(f0);
    k = rows(x0);
    grdd = zeros(n,k);

/* Computation of stepsize (dh) for gradient */

    ax0 = abs(x0);
    if x0 /= 0;
        dax0 = x0./ax0;
    else;
        dax0 = 1;
    endif;
    dh = (1e-8)*maxc((ax0~(1e-2)*ones(rows(x0),1))').*dax0;
    xdh = x0+dh;
    dh = xdh-x0;    /* This increases precision slightly */
    arg = diagrv(reshape(x0,k,k)',xdh);

    i = 1;
    do until i > k;
        if _max_active[i]==1;
            grdd[.,i] = f(arg[.,i],data);
        endif;            
        i = i+1;
    endo;

    grdd = (grdd-(f0.*_max_active'))./(dh');

    @if _max_covpar == 2;@
        __bhhh = -moment(grdd,1)@/rows(data)@;        
    @else;@
        @__bhhh = 0;@
    @endif;@

    retp(
        grdd
        );
endp;

proc 1 = bhhh(f,x0,data);

    local f:proc;
    retp(
        __bhhh
        );
endp; 
