MM <- function(inputs){

	## generate first- and second-stage parameter estimates both with and without interactions between case and justice covariates.
	
	vars <- c(inputs$time,inputs$individual)

	data1 <- data[data[,inputs$subset] == 1,]
	data1 <- subset(data1, select = c(vars,"case","id","vote"))
	
	num_tvars <- length(inputs$time)
	num_tint <- sum(inputs$time_interactions)
	num_ivars <- length(inputs$individual)
	num_iint <- sum(inputs$individual_interactions)
	
	interactions <- matrix(NA, nrow = nrow(data1), ncol = num_tint*num_iint)
	
	index <- 1

	for(i in 1:num_tvars){
		if(inputs$time_interactions[i] == 1){
			for(j in 1:num_ivars){
				if(inputs$individual_interactions[j] == 1){
						interactions[,index] <- data1[,inputs$time[i]]*data1[,inputs$individual[j]]
						index <- index + 1
					}
			} 
			
		}
	}
	
	votes <- as.matrix(data1[,"vote"])
	
	kvars0 <- as.matrix(cbind(1,data1[,vars]))
	kvars1 <- as.matrix(cbind(kvars0,interactions))
	
	tvars <- unique(cbind(data1[,c(inputs$time,"case")]))
	qvars <- as.matrix(cbind(1,tvars[,inputs$time]))
	
	args0 <- list("votes" = votes, "qvars" = qvars, "kvars" = kvars0)
	x0 <- tryCatch(optim(inputs$start0, LLF, gr = NULL, args0, method = "BFGS", control = list(fnscale=-1)), error = function(err) paste("MY_ERROR:  ",err))
	
	if(length(x0) <= 1){
		print("error in optim without interactions")
		return(0)
	} else if(x0$convergence != 0){
		print("no convergence without interactions")
		return(0)
	} else output0 <- second_stage(x0$par,qvars,kvars0)
	
	num_vars0 <- ncol(qvars) + 2*ncol(kvars0)
	args1 <- list("votes" = votes, "qvars" = qvars, "kvars" = kvars1)
	start1 <- c(x0$par[1:(ncol(qvars) + ncol(kvars0))],rep(0,ncol(interactions)),x0$par[(ncol(qvars) + ncol(kvars0) + 1):num_vars0],rep(0,ncol(interactions)))

	x1 <- tryCatch(optim(start1, LLF, gr = NULL, args1, method = "BFGS", control = list(fnscale=-1)), error = function(err) paste("MY_ERROR:  ",err))

	if(length(x1) <= 1){
		print("error in optim with interactions")
		return(0)
	} else if(x1$convergence != 0){
		print("no convergence with interactions")
		return(0)
	} else output1 <- second_stage(x1$par,qvars,kvars1)
	
	output <- list("first_stage_no_int" = x0$par, "params_no_int" = output0, "first_stage_yes_int" = x1$par, "params_yes_int" = output1)
	
}

LLF <- function(par,args){

	# The first stage likelihood function evaluated at "par" given data contained in "args"
	
	mem_votes <- args$votes
	qvars <- args$qvars
	kvars <- args$kvars
	
	num_qvars <- ncol(qvars)
	num_kvars <- ncol(kvars)
	num_meetings <- nrow(qvars)
	
	q.par <- as.matrix(par[1:num_qvars])
	k0.par <- as.matrix(par[(1+num_qvars):(num_qvars+num_kvars)])
	k1.par <- as.matrix(par[(num_qvars+num_kvars+1):(num_qvars+2*num_kvars)])
	
	q.est <- exp(qvars %*% q.par) / (1 + exp(qvars %*% q.par))
	k0.est <- exp(kvars %*% k0.par) / (1 +  exp(kvars %*% k0.par))
	k1.est <- (k0.est + exp(kvars %*% k1.par)) / (1 + exp(kvars %*% k1.par))
	
	p0 <- NULL
	p1 <- NULL
	sum.p0.p1 <- NULL
	
	start_index = 1
	
	for(t in 1:num_meetings){
				
		p0[t] <- (1 - q.est[t]) * exp(sum(mem_votes[(start_index):(start_index + 8)] * log(k0.est[(start_index):(start_index + 8)]) + (1 - mem_votes[(start_index):(start_index + 8)]) * log(1 - k0.est[(start_index):(start_index + 8)])))
				
		p1[t] <- q.est[t] * exp(sum(mem_votes[(start_index):(start_index + 8)] * log(k1.est[(start_index):(start_index + 8)]) + (1 - mem_votes[(start_index):(start_index + 8)]) * log(1 - k1.est[(start_index):(start_index + 8)])))
				
		sum.p0.p1[t] <- log(p0[t] + p1[t])
		
		start_index = start_index + 9
				
	}
			
	return(sum(sum.p0.p1))
			
}


second_stage <- function(first_stage_estimates,qvars,kvars){
	
	## This extracts structural parameters for each voter in each time period given first stage estimates
	
	q_params <- first_stage_estimates[1:ncol(qvars)]
	k0_params <- first_stage_estimates[(ncol(qvars) + 1):(ncol(qvars) + ncol(kvars))]
	k1_params <- first_stage_estimates[(ncol(qvars) + ncol(kvars) + 1):(ncol(qvars) + 2*ncol(kvars))]
	
	num_meetings <- nrow(qvars)
	
	q.temp <- exp(qvars %*% q_params) / (1 + exp(qvars %*% q_params))
	q <- c()

	for(t in 1:num_meetings){
		temp <- rep(q.temp[t],9)
		q <- c(q,temp)
	}
	
	k0 <- exp(kvars %*% k0_params) / (1 +  exp(kvars %*% k0_params))
	k1 <- (k0 + exp(kvars %*% k1_params)) / (1 +  exp(kvars %*% k1_params))

	sigma_est <- 1 / (qnorm(1 - k0) - qnorm(1 - k1))
	cutoff_est <- qnorm(1 - k0) / (qnorm(1 - k0) + qnorm(k1))
	
	theta_est_sin <- (1-2*cutoff_est)/(2*(sigma_est)^2) - log(q/(1-q))
	theta_est_sin <- exp(theta_est_sin) / (1 + exp(theta_est_sin))
	
	parameters <- as.data.frame(cbind(q,cutoff_est,theta_est_sin,sigma_est))
	colnames(parameters) <- c("Q","Cutoff","TN","S")
	return(parameters)
	
}

library(mvtnorm)
# setwd("~/Dropbox/Research Projects/MM Interactions/MM Data")
data <- read.csv("getitright.csv")

# use as starting values for the first-stage regression the reported estimates in Iaryczower and Shum (2012).
contents <- read.csv("issue_rights_MM.csv")
contents <- contents[,-c(1)]
start0 <- c(as.numeric(contents[1,]),as.numeric(contents[2,]),as.numeric(contents[3,]))
start0 <- start0[is.na(start0) == 0]

# time are the case covariates that go into the first-stage regression, ind are the justice covariates
# 1 in the xxx_interactions arrays indicates the variable is interacted in the first-stage kappa terms, 0 means it's not
time <- c("ptiff_local","ptiff_us","def_local","def_us","agree","jud_review","stat_interp","cjburger","cjrehnquist","cjroberts")
time_interactions <- c(1, 1, 1, 1, 1, 1, 1, 0, 0, 0)
ind <- c("jud_exp","part_nom","ideo","qual","mideo","mqual","exp")
ind_interactions <- c(1, 1, 1, 1, 0, 0, 1)

# select the subset of cases to include the regression, as in Iaryczower and Shum (2012).  Make sure it corresponds to the contents file above.
subset <- c("issue_rights")

inputs <- list("time" = time, "time_interactions" = time_interactions, "individual" = ind, "individual_interactions" = ind_interactions, "subsets" = subset, "start0" = start0)

output <- MM(inputs)
save(output, file = "rights.Rdata")