# This file extracts a theta and pi parameter for each judge.  This can be done in means or medians, just change FUN in aggregate function.  For medians, we first take median within each estimated prior, then medians across each prior.
# To run, user needs to have run regressionIS.R for both business and rights cases so that business_params.Rdata and rights_params.Rdata are in working directory

aggregation <- function(data){

	average_iq <- aggregate(data, by = list(data$id,data$Q), FUN = median, na.rm = TRUE)

	prior_high_sincere <- as.numeric(average_iq$Q - average_iq$TN >= 0)

	prob_h <- average_iq$Q*pnorm((average_iq$Cutoff-1)/average_iq$S) + (1 - average_iq$Q)*pnorm(average_iq$Cutoff/average_iq$S)
	prob_l <- average_iq$Q*(1 - pnorm((average_iq$Cutoff-1)/average_iq$S)) + (1 - average_iq$Q)*(1 - pnorm(average_iq$Cutoff/average_iq$S))

	flex_sincere <- prior_high_sincere*prob_h + (1 - prior_high_sincere)*prob_l

	average_iq <- cbind(average_iq,flex_sincere)
	colnames(average_iq)[ncol(average_iq)] <- "FLEX"
	priors <- unique(average_iq[,"Q"])

	average_i <- aggregate(average_iq, by = list(average_iq$id), FUN = median, na.rm = TRUE)
	member_info <- subset(average_i, select = c("TN","S","FLEX"))
	
	output <- list("priors" = priors, "members" = member_info)

}


file_loop <- function(master_data,files){
	
	num_files <- length(files)

	priors <- matrix(NA, nrow = 1000, ncol = 2*(num_files - 1) + 1)
	TN <- matrix(NA, nrow = 31, ncol = 2*(num_files - 1) + 1)
	S <- matrix(NA, nrow = 31, ncol = 2*(num_files - 1) + 1)
	FLEX <- matrix(NA, nrow = 31, ncol = 2*(num_files - 1) + 1)
	
	for(i in 1:num_files){
		
		if(i == 1){
			
			load(files[1])
			data <- cbind(master_data,result$params)
			data <- subset(data, select = c("case","id","Q","Cutoff","TN","S","vote"))
			estimates <- aggregation(data)
		
			priors[1:length(estimates$priors),1] <- estimates$priors
		
			TN[,1] <- estimates$members[,"TN"]
			S[,1] <- estimates$members[,"S"]
			FLEX[,1] <- estimates$members[,"FLEX"]

		}
		
		else if(i > 1){
		
			load(files[i])
		
			data <- cbind(master_data,output$params_no_int)
			data <- subset(data, select = c("case","id","Q","Cutoff","TN","S","vote"))
			estimates <- aggregation(data)
		
			priors[1:length(estimates$priors),2*(i-1)] <- estimates$priors
		
			TN[,2*(i-1)] <- estimates$members[,"TN"]
			S[,2*(i-1)] <- estimates$members[,"S"]
			FLEX[,2*(i-1)] <- estimates$members[,"FLEX"]
		
			data <- cbind(master_data,output$params_yes_int)
			data <- subset(data, select = c("case","id","Q","Cutoff","TN","S","vote"))
			estimates <- aggregation(data)
		
			priors[1:length(estimates$priors),2*(i-1) + 1] <- estimates$priors
		
			TN[,2*(i-1) + 1] <- estimates$members[,"TN"]
			S[,2*(i-1) + 1] <- estimates$members[,"S"]
			FLEX[,2*(i-1) + 1] <- estimates$members[,"FLEX"]
			
		}
	
	}
	
	priors <- priors[rowSums(is.na(priors)) != 2*(num_files-1) + 1, ]
	
	output <- list("Q" = priors, "FLEX" = FLEX, "TN" = TN, "S" = S)

}

library(mvtnorm)
# setwd("~/Dropbox/Research Projects/MM Interactions/MM Data")
temp <- read.csv("getitright.csv")

data <- temp[temp[,"issue_business"] == 1,]
x <- file_loop(data, c("business_MM.Rdata","business.Rdata"))
save(x, file = "business_params.Rdata")

data <- temp[temp[,"issue_rights"] == 1,]
x <- file_loop(data, c("rights_MM.Rdata","rights.Rdata"))
save(x, file = "rights_params.Rdata")

