/*--------------------------------------------------------------------------
 * spa_src.h - header file SPA: Test for Superior Predictive Ability
 *
 *      code (C) Peter Reinhard Hansen, 2001
 *
 *--------------------------------------------------------------------------*/

// LOSS FUNCTIONS: (Definitions of)
	mse(const mY, const mYhat);
	mad(const mY, const mYhat);
	
// OX PROCEDURES (not needed in OX 3.0)
	maxc(const a);
	maxr(const a);

// TEST STATISTICS

	TestStatScaledMax(const A, const varA);
	TestStatMax(const A, const varA);

// BOOTSTRAP RESAMPLE GENERATOR

	StatBootResamp(const n, const B, const q);

// SIMPLE OUTPUT-PROCEDURES
	PlotResult(Y);

// SPA PROCEDURES	
	getXp(const Y, const S, const Eval, const Theta);

// SPA PROCEDURES: PreSPA, SPA_pval, and SPA_test
	PreSPA(const Y, const S, const Eval, const Xp, const SigXp);
	SPA_pval(const Xp, const testStat, const n, const SigXp);
	SPA(const mY, const mX, const eval, const TestStat, const dB, const dq);
