#include <oxstd.h>
#include <oxfloat.h>

#import  "spa_src"

mse2(const y, const yhat)  { return meanc((y-yhat).*(y-yhat));	}
mse1(const y, const yhat)  { return meanc((y.^0.5-yhat.^0.5).^2);	}
mad2(const y, const yhat)  { return meanc(fabs(y-yhat));	}
mad1(const y, const yhat)  { return meanc(fabs(y.^0.5-yhat.^0.5));	}
qlike(const y, const yhat) { return meanc(log(yhat)+(y./yhat)); }
r2log(const y, const yhat) { return meanc((log(y./yhat)).^2 ); }

decl dB=10000,			  // number of resamples (default is 1000)
	 dq=0.5,		      // for bootstrapping	   (default is .5)
	 myseed = 12136;	  // Seed for random number generater

decl lossfct = {"mse1","mse2","qlike","r2log","mad1","mad2"},
	 RVident = {"OUR OLD ESTIMATES","NEW ESTIMATES: 250, 2, scaled","FOURIER ESTIMATES","LINEAR INTERPOLATION (5 MIN SAMPLING) ESTIMATES","PRE-TICK (5 MIN SAMPLING) ESTIMATES",
  			    "LINEAR INTERPOLATION (1 MIN SAMPLING) ESTIMATES","PRE-TICK (1 MIN SAMPLING) ESTIMATES"};

main()			
{
	decl Ofile = "tab3_res",			        // Where to save the result that make Tabel 3.
	     mY    = loadmat("yIBM_data.mat"),      // Dataset with Realized variances
		 mYhat = loadmat("yhatIBM_data.mat");   // Dataset with volatility forecasts

	decl i,j,TestStat,res1,res2=<>;
		 
	for (i=0; i<sizerc(lossfct); ++i){
		res1=<>;
		for (j=0; j<sizerc(RVident); ++j){
			print("\n",RVident[j]);	 ranseed(myseed);		// the GARCH(1,1) is the benchmark
			res1 ~= SPA(mY[][j+2], mYhat[][2]~mYhat[][1]~mYhat[][3:], lossfct[i] , TestStatScaledMax, dB, dq)[][2]; 
		}
		res2 |= res1;
	}

	println(res2);

	systemcall("mkdir Output");
    savemat("Output/"~sprint(Ofile)~".mat",res2,1);
    savemat("Output/"~sprint(Ofile)~".xls",res2);
}
