#include <oxstd.h>
#include <oxfloat.h>

#import  "spa_src"

mse2(const y, const yhat)  { return meanc((y-yhat).*(y-yhat));	}
mse1(const y, const yhat)  { return meanc((y.^0.5-yhat.^0.5).^2);	}
mad2(const y, const yhat)  { return meanc(fabs(y-yhat));	}
mad1(const y, const yhat)  { return meanc(fabs(y.^0.5-yhat.^0.5));	}
qlike(const y, const yhat) { return meanc(log(yhat)+(y./yhat)); }
r2log(const y, const yhat) { return meanc((log(y./yhat)).^2 ); }

decl dB=10000,		  // number of resamples (default is 1000)
	 dq=0.5,		  // for bootstrapping	   (default is .5)
	 myseed = 12136,	  // Seed for random number generater

     lossfct = {"mse1","mse2","qlike","r2log","mad1","mad2"},
     Ofile   = "tab2_res";			      // Where to save the result that make Tabel 3.

main()			
{
	decl i,j,t,TestStat={"TestStatScaledMax","TestStatMax"},res1,res2=<>,

	/////////////////////////////////////////////////////////
	//   First do Exchange rate data
	
	mY    = loadmat("yexch_data.mat"),		// Dataset with Realized variances
	mYhat = loadmat("yhatexch_data.mat");   // Dataset with volatility forecasts

	for (i=0; i<sizerc(lossfct); ++i){
		res1=<>;
		ranseed(myseed);
		println("Data is DM/Dollar Exchange rates, Benchmark is ARCH(1)");
		res1 ~= SPA(mY[][0], mYhat, lossfct[i] , TestStat[0], dB, dq); 
		println("Data is DM/Dollar Exchange rates, Benchmark is GARCH(1,1)");
		res1 ~= SPA(mY[][0], mYhat[][1]~mYhat[][0]~mYhat[][2:], lossfct[i] , TestStat[0], dB, dq); 
		res2 |= res1;
	}

	/////////////////////////////////////////////////////////
	//   Then do IBM stock return data

	mY    = loadmat("yIBM_data.mat"),      // Dataset with Realized variances
	mYhat = loadmat("yhatIBM_data.mat");   // Dataset with volatility forecasts

		 
	for (t=0; t<2; ++t){
		for (i=0; i<sizerc(lossfct); ++i){
			res1=<>;
			ranseed(myseed);
			println("Data is IBM stock returns, Benchmark is ARCH(1)");
			res1 ~= SPA(mY[][2], mYhat[][1:], lossfct[i] , TestStat[t], dB, dq); 
			println("Data is IBM stock returns, Benchmark is GARCH(1,1)");
			res1 ~= SPA(mY[][2], mYhat[][2]~mYhat[][1]~mYhat[][3:], lossfct[i] , TestStat[t], dB, dq); 
			res2 |= res1;
		}
	}
	println(res2);

	systemcall("mkdir Output");
    savemat("Output/"~sprint(Ofile)~".mat",res2,1);
    savemat("Output/"~sprint(Ofile)~".xls",res2);
}
